/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.lang.InvalidStateException;
import hec.rss.model.Channel;
import hec.rss.model.ChannelType;
import java.lang.reflect.Field;
import rma.util.RMAConst;

public class CircularChannel
extends Channel {
    private double _diameter;
    private double _manningsN;
    private double _m = 1.25;

    @Override
    public ChannelType getChannelType() {
        return ChannelType.CIRCLE;
    }

    public double getDiameter() {
        return this._diameter;
    }

    public double getManningsN() {
        return this._manningsN;
    }

    public void setDiameter(double d) {
        this._diameter = d;
    }

    public void setManningsN(double d) {
        this._manningsN = d;
    }

    public void getDiameter(ParamDouble paramDouble) {
        if (paramDouble == null) {
            return;
        }
        paramDouble.setValue(this._diameter);
        paramDouble.setUnitSystem(this.getUnitSystem());
        paramDouble.setPrecision(2);
        paramDouble.setParameterId(Parameter.PARAMID_WIDTH);
    }

    public void setDiameter(ParamDouble paramDouble) {
        if (paramDouble == null) {
            return;
        }
        int n = this.getUnitSystem();
        if (n == paramDouble.getUnitSystem()) {
            this._diameter = paramDouble.getValue();
            return;
        }
        this._diameter = paramDouble.convertToUnitSystem(n);
    }

    @Override
    public boolean isValid() throws InvalidStateException {
        int n = 0;
        if (!super.isValid()) {
            ++n;
        }
        if (!RMAConst.isValidValue((double)this._diameter) || this._diameter < 0.01) {
            System.out.println("ERROR: Invalid channel diameter");
            CircularChannel circularChannel = this;
            throw new InvalidStateException((Object)circularChannel, "Invalid channel diameter. Diameter (" + circularChannel._diameter + ") is an invalid value or less than 0.01");
        }
        if (!RMAConst.isValidValue((double)this._manningsN) || this._manningsN < 0.001) {
            System.out.println("ERROR: Invalid Manning's n for channel");
            CircularChannel circularChannel = this;
            throw new InvalidStateException((Object)circularChannel, "Invalid Manning's n for channel. Manning's n (" + circularChannel._manningsN + ") is an invalid value or less than 0.001");
        }
        return n == 0;
    }

    public double getArea(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        double d2 = this._diameter / 2.0;
        double d3 = 2.0 * Math.acos((d - d2) / d2);
        double d4 = d2;
        double d5 = d3;
        return d4 * d4 * (Math.PI - (d5 - Math.sin(d5)) / 2.0);
    }

    @Override
    public double getTopWidth(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        double d2 = d;
        return 2.0 * Math.sqrt(this._diameter * d - d2 * d2);
    }

    private double getAlpha() {
        double d = 0.503;
        if (this.getUnitSystem() == 1) {
            d = 0.747458;
        }
        return d / this._manningsN * Math.sqrt(this._slope) * Math.pow(this._diameter, 0.16666666666666666);
    }

    public double getVelocity(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        double d2 = this.getArea(d);
        return this.getAlpha() * Math.pow(d2, this._m - 1.0);
    }

    @Override
    public double getCelerity(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        double d2 = this.getArea(d);
        return this.getAlpha() * this._m * Math.pow(d2, this._m - 1.0);
    }

    @Override
    public double getDepth(double d) {
        double d2;
        double d3 = 0.0;
        double d4 = this.getAlpha();
        double d5 = Math.pow(d / d4, 1.0 / this._m);
        if (d2 > 0.65 * this._diameter * this._diameter) {
            d3 = 0.771 * this._diameter;
        } else {
            double d6 = 0.3 * this._diameter;
            double d7 = 0.5 * this._diameter;
            for (int i = 0; i < 20; ++i) {
                double d8 = d7;
                double d9 = d7;
                double d10 = 0.5 * (d7 * Math.PI * d7) - ((d7 - d6) * Math.sqrt(d8 * d8 - Math.pow(d7 - d6, 2.0)) + d9 * d9 * Math.asin((d7 - d6) / d7)) - d5;
                double d11 = d6;
                double d12 = 2.0 * Math.sqrt(d7 * 2.0 * d6 - d11 * d11);
                d3 = d6 - d10 / d12;
                if (Math.abs(d3 - d6) < 0.001) break;
                d6 = d3;
            }
        }
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        return d3;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

