/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.model.RunTimeStep;
import hec.rss.model.Element;
import hec.rss.model.Routing;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.jdom.Content;
import rma.util.RMAIO;

public class CoefRouting
extends Routing {
    int _straddle = 1;
    int _lag = 0;
    double _factor = Double.NEGATIVE_INFINITY;
    double[] _coefArray = new double[]{Double.NEGATIVE_INFINITY};

    public CoefRouting() {
    }

    public CoefRouting(Element element) {
        super(element);
    }

    public double calcLag() {
        if (this._coefArray == null) {
            return 0.0;
        }
        double d = 0.0;
        double d2 = -1.0;
        for (int i = 0; i < this._coefArray.length; ++i) {
            if (!(this._coefArray[i] > d2)) continue;
            d = i;
            d2 = this._coefArray[i];
        }
        return d;
    }

    @Override
    public synchronized Object clone() {
        CoefRouting coefRouting = (CoefRouting)super.clone();
        if (this._coefArray != null) {
            coefRouting._coefArray = new double[this._coefArray.length];
            System.arraycopy(this._coefArray, 0, coefRouting._coefArray, 0, this._coefArray.length);
        }
        return coefRouting;
    }

    @Override
    public int computeForecastStep(RunTimeStep runTimeStep) {
        this._tsDnstrm[runTimeStep.step] = 0.0;
        for (int i = 0; i < this._coefArray.length; ++i) {
            int n = runTimeStep.step - i;
            if (n < 0) {
                n = 0;
            }
            int n2 = runTimeStep.step;
            this._tsDnstrm[n2] = this._tsDnstrm[n2] + this._tsUpstrm[n] * this._coefArray[i];
        }
        return this.checkForecastStepCalc(runTimeStep, false);
    }

    @Override
    public int computeRouting(RunTimeStep runTimeStep, double[] dArray, double[] dArray2, Object[] objectArray, double[] dArray3) {
        int n;
        if (dArray == null || dArray2 == null) {
            return 1;
        }
        for (n = 0; n < runTimeStep.nstep; ++n) {
            dArray3[n] = 0.0;
        }
        int n2 = runTimeStep.getTotalNumSteps();
        for (int i = 0; i < runTimeStep.nstep; ++i) {
            int n3 = runTimeStep.step + i;
            if (n3 < 0) continue;
            if (n3 > n2) break;
            for (int j = 0; j < this._coefArray.length; ++j) {
                n = n3 - j;
                if (n < 0) {
                    n = 0;
                }
                int n4 = i;
                dArray3[n4] = dArray3[n4] + dArray[n] * this._coefArray[j];
            }
        }
        return 0;
    }

    @Override
    public int computeRouting(RunTimeStep runTimeStep) {
        int n;
        int n2 = runTimeStep.step;
        int n3 = runTimeStep.nstep + n2;
        for (n = n2; n < n3; ++n) {
            this._tsDnstrm[n] = 0.0;
        }
        while (n2 < n3) {
            for (int i = 0; i < this._coefArray.length; ++i) {
                n = n2 - i;
                if (n < 0) {
                    n = 0;
                }
                int n4 = n2;
                this._tsDnstrm[n4] = this._tsDnstrm[n4] + this._tsUpstrm[n] * this._coefArray[i];
            }
            if (runTimeStep != null && ((RssTSLocationObject)this).getSystem().b && ((RssTSLocationObject)this).getSystem().shouldSaveHotstartAtTimeStep(n2, runTimeStep.flag)) {
                ArrayList<Element> arrayList = new ArrayList<Element>(1);
                Element element = this.element.getTopParent();
                arrayList.add(element);
                ((RssTSLocationObject)this).getSystem().checkSaveHotstart(n2, runTimeStep.flag, arrayList);
            }
            ++n2;
        }
        return this.checkForecastCalc(runTimeStep, false);
    }

    public void setStraddle(int n) {
        if (n == Integer.MIN_VALUE) {
            this._straddle = 0;
            return;
        }
        this._straddle = n;
    }

    public void setLag(int n) {
        if (n == Integer.MIN_VALUE) {
            this._lag = 0;
            return;
        }
        this._lag = n;
    }

    public void setFactor(double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            this._factor = 1.0;
            return;
        }
        this._factor = d;
    }

    public void setCoefArray(double[] dArray) {
        this.setCoefArray(dArray, true);
    }

    public void setCoefArray(double[] dArray, boolean bl) {
        int n;
        if (dArray == null || dArray.length == 0) {
            return;
        }
        this._coefArray = dArray;
        double d = 0.0;
        for (n = 0; n < this._coefArray.length; ++n) {
            if (this._coefArray[n] == Double.NEGATIVE_INFINITY) {
                this._coefArray[n] = 0.0;
            }
            d += this._coefArray[n];
        }
        d = RMAIO.round((double)d, (int)5);
        if (bl && d != 1.0 && d != 0.0) {
            n = 0;
            while (n < this._coefArray.length) {
                int n2 = n++;
                this._coefArray[n2] = this._coefArray[n2] / d;
            }
        }
    }

    public double[] getCoefArray() {
        return this._coefArray;
    }

    public int getStraddle() {
        return this._straddle;
    }

    public int getLag() {
        return this._lag;
    }

    public double getFactor() {
        return this._factor;
    }

    @Override
    public boolean hasDefaultParameters() {
        return this._coefArray.length >= 3 && this._coefArray[0] == 0.333 && this._coefArray[1] == 0.333 && this._coefArray[2] == 0.334;
    }

    @Override
    public boolean estimateCoefRouting(RunTimeStep runTimeStep, double[] dArray) {
        if (dArray != null && dArray.length == this._coefArray.length) {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this._coefArray[i];
            }
            return true;
        }
        return super.estimateCoefRouting(runTimeStep, dArray);
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        alternativeInputReport = new org.jdom.Element("Coeficients");
        element.addContent((Content)alternativeInputReport);
        XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._coefArray);
    }

    @Override
    public double computeRoutingStepStandalone(int n, double d, double d2, double d3, double[] dArray, double[] dArray2) {
        dArray2[0] = d2;
        dArray2[1] = d3;
        return d3;
    }
}

