/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.io.AsciiSerializable;
import hec.model.AbstractConditionalBlockRef;
import hec.model.Conditional;
import hec.model.ConditionalBlock;
import hec.model.RunTimeStep;
import hec.rss.model.ElementOp;
import hec.rss.model.OpRuleRef;
import hec.rss.model.RssConditionalBlock;
import hec.rss.model.StorageZoneRules;
import hec.rss.model.ZoneObject;
import hec.rss.model.ZoneObjectParent;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Observer;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Element;

public class ConditionalBlockRef
extends AbstractConditionalBlockRef
implements AsciiSerializable,
ZoneObject,
AltInputReportInfc,
Observer {
    ZoneObjectParent _parent;
    float m_priority = 1.0f;
    private boolean _treeNodeExpanded = true;
    private boolean _disabled;

    public ConditionalBlockRef() {
    }

    public ConditionalBlockRef(ZoneObjectParent zoneObjectParent, ConditionalBlock conditionalBlock) {
        super(conditionalBlock);
        this._parent = zoneObjectParent;
        conditionalBlock.addObserver((Observer)this);
    }

    public ConditionalBlockRef(StorageZoneRules storageZoneRules, ConditionalBlock conditionalBlock, float f) {
        super(conditionalBlock);
        this.m_priority = f;
        conditionalBlock.addObserver((Observer)this);
    }

    @Override
    public void getReferencedStateVariables(List list) {
        ConditionalBlock conditionalBlock = this.getConditionalBlock();
        if (!(conditionalBlock instanceof RssConditionalBlock)) {
            return;
        }
        ((RssConditionalBlock)conditionalBlock).getReferencedStateVariables(list);
    }

    @Override
    public void setParent(ZoneObjectParent zoneObjectParent) {
        this._parent = zoneObjectParent;
    }

    public ZoneObjectParent getParent() {
        return this._parent;
    }

    @Override
    public float getPriority() {
        return this.m_priority;
    }

    @Override
    public void setPriority(float f) {
        this.m_priority = f;
    }

    public ConditionalBlock getConditionalBlock() {
        if (this.m_conditionalBlockId == -1) {
            return null;
        }
        if (this._conditionalBlock == null) {
            if (this._parent == null) {
                return null;
            }
            ElementOp elementOp = this._parent.getElementOp();
            if (elementOp == null) {
                return null;
            }
            this._conditionalBlock = elementOp.getConditionalBlock(this.m_conditionalBlockId);
            if (this._conditionalBlock != null) {
                this._conditionalBlock.addObserver((Observer)this);
            }
        }
        return this._conditionalBlock;
    }

    @Override
    public void removeRuleRef(int n) {
        if (this._conditionalBlock == null) {
            this._conditionalBlock = this.getConditionalBlock();
            if (this._conditionalBlock == null) {
                return;
            }
        }
        ConditionalBlockRef conditionalBlockRef = this;
        conditionalBlockRef.removeRuleRef(conditionalBlockRef._conditionalBlock, n);
    }

    private void removeRuleRef(ConditionalBlock object, int n) {
        if (object == null) {
            return;
        }
        object = object.getConditionals();
        for (int i = 0; object != null && i < object.size(); ++i) {
            Conditional conditional = (Conditional)object.get(i);
            List list = conditional.getConditionalObjects(false);
            for (int j = 0; list != null && j < list.size(); ++j) {
                Object e = list.get(j);
                if (!(e instanceof OpRuleRef) || ((OpRuleRef)e).getRule().getIndex() != n) continue;
                conditional.removeCondtionalObject(e);
            }
            List list2 = conditional.getContitionalBlocks();
            for (int j = 0; list2 != null && j < list2.size(); ++j) {
                this.removeRuleRef((ConditionalBlock)list2.get(j), n);
            }
        }
    }

    @Override
    public List getActiveRuleRefs(RunTimeStep runTimeStep) {
        if (this._conditionalBlock == null) {
            this._conditionalBlock = this.getConditionalBlock();
            if (this._conditionalBlock == null) {
                return new Vector();
            }
        }
        return this._conditionalBlock.getEvaluatedItems(runTimeStep, new Vector());
    }

    @Override
    public List getRuleRefs() {
        if (this._conditionalBlock == null) {
            this._conditionalBlock = this.getConditionalBlock();
            if (this._conditionalBlock == null) {
                return new Vector();
            }
        }
        return this._conditionalBlock.getUnEvaluatedItems(new Vector());
    }

    @Override
    public synchronized Object clone() {
        try {
            ConditionalBlockRef conditionalBlockRef = (ConditionalBlockRef)super.clone();
            if (conditionalBlockRef == null) {
                return null;
            }
            conditionalBlockRef.m_conditionalBlockId = this.m_conditionalBlockId;
            conditionalBlockRef.m_priority = this.m_priority;
            conditionalBlockRef._conditionalBlock = null;
            return conditionalBlockRef;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("clone:" + String.valueOf(cloneNotSupportedException));
            return null;
        }
    }

    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, Element element) {
        element.setAttribute("Name", this.getDisplayName());
        element.setAttribute("Description", this.getDescription());
        element.setAttribute("Priority", Float.toString(this.m_priority));
        List list = this.getRuleRefs();
        for (int i = 0; i < list.size(); ++i) {
            Element element2 = new Element("RuleRef");
            element.addContent((Content)element2);
            OpRuleRef opRuleRef = (OpRuleRef)list.get(i);
            opRuleRef.outputReport(alternativeInputReport, element2);
        }
        List list2 = this._conditionalBlock.getConditionals();
        for (int i = 0; i < list2.size(); ++i) {
        }
    }

    public void updateReference() {
        if (this._conditionalBlock != null) {
            this.m_conditionalBlockId = this._conditionalBlock.getIndex();
            ConditionalBlockRef conditionalBlockRef = this;
            conditionalBlockRef.setName(conditionalBlockRef._conditionalBlock.getName());
            ConditionalBlockRef conditionalBlockRef2 = this;
            conditionalBlockRef2.setDescription(conditionalBlockRef2._conditionalBlock.getDescription());
            return;
        }
        System.out.println("updateReference:No ConditionalBlock Object to update. " + this.getName() + " Index:" + this.m_conditionalBlockId);
    }

    public boolean shouldTreeNodeExpand() {
        return this._treeNodeExpanded;
    }

    public void setTreeNodeExpanded(boolean bl) {
        this._treeNodeExpanded = bl;
    }

    public void setDisabled(boolean bl) {
        this._disabled = bl;
    }

    public boolean isDisabled() {
        return this._disabled;
    }
}

