/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.heclib.util.doubleArrayContainer;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.rss.model.WaterControlDevice;
import hec.rss.model.WaterControlDeviceType;
import java.lang.reflect.Field;
import java.util.Vector;

public class ContinuousIntakeControlDevice
extends WaterControlDevice {
    private double _minIntake;
    private double _maxIntake;
    private boolean _useElevationForMinIntake;
    private boolean _useElevationForMaxIntake;
    private transient doubleArrayContainer b;

    public ContinuousIntakeControlDevice() {
        this.setName("Water Control Device");
    }

    public ContinuousIntakeControlDevice(ContinuousIntakeControlDevice continuousIntakeControlDevice) {
        super(continuousIntakeControlDevice);
        this._minIntake = continuousIntakeControlDevice.getMinIntake();
        this._maxIntake = continuousIntakeControlDevice.getMaxIntake();
        this._useElevationForMinIntake = continuousIntakeControlDevice.useElevationForMinIntake();
        this._useElevationForMaxIntake = continuousIntakeControlDevice.useElevationForMaxIntake();
    }

    public double getMinIntake() {
        return this._minIntake;
    }

    public void setMinIntake(double d) {
        this._minIntake = d;
    }

    public double getMaxIntake() {
        return this._maxIntake;
    }

    public void setMaxIntake(double d) {
        this._maxIntake = d;
    }

    public boolean useElevationForMinIntake() {
        return this._useElevationForMinIntake;
    }

    public void setUseElevationForMinIntake(boolean bl) {
        this._useElevationForMinIntake = bl;
    }

    public boolean useElevationForMaxIntake() {
        return this._useElevationForMaxIntake;
    }

    public void setUseElevationForMaxIntake(boolean bl) {
        this._useElevationForMaxIntake = bl;
    }

    public void setElevArray(RunTimeStep runTimeStep, double d) {
        this.b.array[runTimeStep.step] = d;
    }

    public void initializeCompute() {
        for (int i = 0; i < this._tsrecordVector.size(); ++i) {
            TSRecordProxy tSRecordProxy = (TSRecordProxy)this._tsrecordVector.elementAt(i);
            if (tSRecordProxy == null) continue;
            tSRecordProxy.initialize();
        }
        this.b = this.getTSContainer(210);
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public WaterControlDeviceType getType() {
        return WaterControlDeviceType.CONTINUOUS_INTAKE;
    }

    @Override
    void initialize(RunTimeWindow runTimeWindow) {
    }

    @Override
    public Vector getActiveTSProxies(Vector vector, int n) {
        TSRecordProxy tSRecordProxy;
        if (vector == null) {
            vector = new Vector<TSRecordProxy>();
        }
        if (n != 1 && n == 0 && (tSRecordProxy = this.getTSRecordProxy(210)) != null && !vector.contains(tSRecordProxy)) {
            vector.addElement(tSRecordProxy);
        }
        return vector;
    }

    @Override
    public ContinuousIntakeControlDevice clone() {
        return new ContinuousIntakeControlDevice(this);
    }

    @Override
    public void updateTSProxyList() {
        Object object = this.getTSRecordProxy(210);
        if (object == null) {
            object = this.getReservoir();
            object = object.getName() + "-" + this.getName();
            this.addTSRecordProxy((String)object, 210);
        }
    }
}

