/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.rss.model.AdjustableParameter;
import hec.rss.model.Element;
import hec.rss.model.Function;
import hec.rss.model.IntakeGeometry;
import java.lang.reflect.Field;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ControlStructure
extends Function {
    IntakeGeometry _intakeGeometry = new IntakeGeometry();

    public ControlStructure() {
    }

    public ControlStructure(Element element) {
        super(element);
    }

    public void setIntakeGeometry(IntakeGeometry intakeGeometry) {
        this._intakeGeometry = intakeGeometry;
    }

    public IntakeGeometry getIntakeGeometry() {
        return this._intakeGeometry;
    }

    public double periodAverageFlow(double[] dArray, double[] dArray2, int n) {
        double d = 0.0;
        double d2 = dArray[n - 1] - dArray[0];
        for (int i = 1; i < n; ++i) {
            double d3 = (dArray2[i] + dArray2[i - 1]) * 0.5;
            double d4 = this.getRelease(d3);
            d += d4 * (dArray[i] - dArray[i - 1]) / d2;
        }
        return d;
    }

    public double periodAverageFlow(double d, double d2, double d3) {
        double d4 = this.getRelease(d);
        double d5 = this.getRelease(d2);
        if (d4 <= 0.0 && d5 <= 0.0) {
            return 0.0;
        }
        double d6 = (d2 - d) / 12.0;
        double d7 = 0.0;
        double d8 = d;
        d5 = this.getRelease(d);
        for (int i = 0; i < 12; ++i) {
            double d9 = d8;
            double d10 = (d9 + (d8 += d6)) / 2.0;
            d4 = d5;
            d5 = this.getRelease(d8);
            double d11 = this.getRelease(d10);
            if (d4 <= 0.0 && d5 <= 0.0) continue;
            if (d4 <= 0.0 || d5 <= 0.0) {
                d7 += d4 * 0.25 + d11 * 0.5 + d5 * 0.25;
                continue;
            }
            d7 += d4 * 0.1666666 + d11 * 0.6666666 + d5 * 0.1666666;
        }
        double d12 = d7 / 12.0;
        return d12;
    }

    public double getRelease(double d) {
        return 0.0;
    }

    public double getEstimatedFlow(RunTimeStep runTimeStep, int n) {
        return 0.0;
    }

    public double getEstimatedROI(RunTimeStep runTimeStep, int n) {
        return 0.0;
    }

    public double getEstimatedROD(RunTimeStep runTimeStep, int n) {
        return 0.0;
    }

    @Override
    public AdjustableParameter getAdjustableParameter() {
        if (this.adjustableParam == null) {
            this.adjustableParam = new AdjustableParameter(this);
            this.adjustableParam.setName("Flow");
        }
        return this.adjustableParam;
    }

    @Override
    public synchronized Object clone() {
        ControlStructure controlStructure = (ControlStructure)super.clone();
        if (this._intakeGeometry != null) {
            try {
                controlStructure._intakeGeometry = (IntakeGeometry)this._intakeGeometry.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                Logger.getLogger(ControlStructure.class.getName()).log(Level.SEVERE, null, cloneNotSupportedException);
            }
        }
        return controlStructure;
    }

    public void copyInto(ControlStructure controlStructure) {
        if (controlStructure == null) {
            return;
        }
        if (controlStructure._intakeGeometry != null) {
            try {
                this._intakeGeometry = (IntakeGeometry)this._intakeGeometry.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                Logger.getLogger(ControlStructure.class.getName()).log(Level.SEVERE, null, cloneNotSupportedException);
            }
        }
        super.copyInto(controlStructure);
    }

    @Override
    Vector getComputedNodes() {
        return this.element.getNodeVector();
    }

    public int initForecastOperations(RunTimeWindow runTimeWindow) {
        return 0;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

