/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.lang.NamedType;
import hec.model.RunTimeStep;
import hec.model.TSLocation;
import hec.rss.model.AdjustableDiversion;
import hec.rss.model.AdjustableParameter;
import hec.rss.model.Element;
import hec.rss.model.FlowFunction;
import hec.rss.model.Function;
import hec.rss.model.Operations;
import hec.rss.model.PoolElevation;
import hec.rss.model.ReleaseOverrides;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.Rule;
import hec.rss.model.RuleConnectivityRef;
import hec.rss.model.RuleFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import rma.util.RMAIO;
import rma.util.rmaTokenizer;

public class Controller
extends NamedType
implements TSLocation {
    Operations _operations;
    AdjustableDiversion _diversion;
    String _adjparamElement = "";
    String _adjparamFunction = "";
    String _adjparamName = "";
    private transient AdjustableParameter a;
    private transient Hashtable b = null;
    Vector ruleVector = new Vector();

    public Controller() {
    }

    public Controller(AdjustableDiversion adjustableDiversion) {
        this._diversion = adjustableDiversion;
    }

    public Controller(Operations operations, int n) {
        this._operations = operations;
        this._index = n;
    }

    public Controller(Operations operations) {
        this._operations = operations;
    }

    public List getRuleConnectivityRefs(boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.ruleVector.size(); ++i) {
            Rule rule;
            Object object = (Rule)this.ruleVector.elementAt(i);
            if (object instanceof FlowFunction) {
                RssNode rssNode;
                rule = (FlowFunction)object;
                int n = ((FlowFunction)rule).getFlowLocationIndex();
                if (n < 0 || (rssNode = this.getSystem().getNode(n)) == null) continue;
                object = new RuleConnectivityRef();
                ((RuleConnectivityRef)object).a(rule);
                ((RuleConnectivityRef)object).b(rssNode);
                ((RuleConnectivityRef)object).a(3);
                arrayList.add(object);
                continue;
            }
            if (!(object instanceof PoolElevation)) continue;
            rule = (PoolElevation)object;
            ReservoirElement reservoirElement = this.getSystem().findReservoir(((PoolElevation)rule).getReservoirName());
            if (reservoirElement == null) continue;
            object = new RuleConnectivityRef();
            ((RuleConnectivityRef)object).a(rule);
            ((RuleConnectivityRef)object).b(reservoirElement);
            ((RuleConnectivityRef)object).a(4);
            arrayList.add(object);
        }
        return arrayList;
    }

    public RssSystem getSystem() {
        if (this._diversion == null) {
            return null;
        }
        return this._diversion.getElement().getSystem();
    }

    public void setOperatations(Operations operations, int n) {
        this._operations = operations;
        this._index = n;
    }

    public void setAdjustableDiversion(AdjustableDiversion adjustableDiversion) {
        this._diversion = adjustableDiversion;
    }

    public synchronized Object clone() {
        try {
            Controller controller = (Controller)((Object)super.clone());
            return controller;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int getUnitSystem() {
        if (this._operations != null) {
            return this._operations.getUnitSystem();
        }
        if (this._diversion != null) {
            return this._diversion.getUnitSystem();
        }
        return 0;
    }

    public void setDiversionFunction(AdjustableDiversion adjustableDiversion) {
        this._diversion = adjustableDiversion;
    }

    public AdjustableDiversion getDiversionFunction() {
        return this._diversion;
    }

    public Operations getOperations() {
        return this._operations;
    }

    public String getAdjParamElementName() {
        return this._adjparamElement;
    }

    public void setAdjParamData(String string, String string2, String string3) {
        this._adjparamElement = string;
        this._adjparamFunction = string2;
        this._adjparamName = string3;
    }

    public Element findElement(String string) {
        if (this._diversion != null) {
            return this._diversion.getElement();
        }
        if (this._operations != null) {
            return this._operations.findElement(string);
        }
        return null;
    }

    public Vector getRuleVector() {
        return (Vector)this.ruleVector.clone();
    }

    public void addRule(Rule rule) {
        this.ruleVector.addElement(rule);
    }

    public void removeAllRules() {
        this.ruleVector.removeAllElements();
    }

    public Rule findRule(String string) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        for (int i = 0; i < this.ruleVector.size(); ++i) {
            Rule rule = (Rule)this.ruleVector.elementAt(i);
            if (rule == null || !string.equals(rule.getName())) continue;
            return rule;
        }
        return null;
    }

    public void removeRule(String string) {
        for (int i = 0; i < this.ruleVector.size(); ++i) {
            Rule rule = (Rule)this.ruleVector.elementAt(i);
            if (rule == null || !string.equals(rule.getName())) continue;
            this.ruleVector.removeElementAt(i);
            return;
        }
    }

    public boolean initialize() {
        Enumeration enumeration = this.ruleVector.elements();
        while (enumeration.hasMoreElements()) {
            if (((Rule)enumeration.nextElement()).initialize()) continue;
            return false;
        }
        return true;
    }

    public boolean initialize_old() {
        Controller controller = this;
        Object object = controller.findElement(controller._adjparamElement);
        if (object == null) {
            return true;
        }
        this.a = this._diversion != null ? ((Function)this._diversion).getAdjustableParameter() : (this._operations != null ? this._operations.findAdjParam(this._adjparamElement, this._adjparamFunction, this._adjparamName) : null);
        if (this.a == null) {
            this._operations.printErrorMessage("Controller.initialize: Failed to find adjustable parameter");
            this._operations.printErrorMessage("Controller: " + this.getName());
            return false;
        }
        this.a.setController(this);
        this.b = null;
        if (this._operations != null && (object = this._operations.getReleaseOverrides()) != null) {
            TSLocation tSLocation = this.a.getFunction().getElement();
            if ((tSLocation = tSLocation.getDownstreamNode()) != null && tSLocation.getTSRecordProxy(0) != null && (tSLocation = tSLocation.getTSRecordProxy(0)) != null) {
                this.b = ((ReleaseOverrides)object).getReleaseValues(tSLocation.getName());
            }
        }
        object = this.ruleVector.elements();
        while (object.hasMoreElements()) {
            if (((Rule)object.nextElement()).initialize()) continue;
            return false;
        }
        return true;
    }

    public double[] findTSArray(String string, String string2, String string3) {
        if (this._diversion != null) {
            return this._diversion.getElement().getSystem().findTSArray(string, string2, string3);
        }
        if (this._operations != null) {
            return this._operations.findTSArray(string, string2, string3);
        }
        return null;
    }

    public TSDataSet getTSDataSet(boolean bl) {
        if (this._diversion != null) {
            if (bl) {
                return this._diversion.getElement().getSystem().getInputTSDataSet();
            }
            return this._diversion.getElement().getSystem().getOutputTSDataSet();
        }
        if (this._operations != null) {
            if (bl) {
                return this._operations.getInputTSDataSet();
            }
            return this._operations.getOutputTSDataSet();
        }
        return null;
    }

    public double getRuleValue(AdjustableParameter adjustableParameter, RunTimeStep runTimeStep) {
        Double d;
        double d2 = Double.NEGATIVE_INFINITY;
        if (this.b != null && (d = (Double)this.b.get(new Integer(runTimeStep.valueMinutes()))) != null && d != Double.NEGATIVE_INFINITY) {
            d2 = d;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            for (int i = 0; i < this.ruleVector.size(); ++i) {
                double d3;
                Rule rule = (Rule)this.ruleVector.elementAt(i);
                if (rule == null || (d3 = rule.getValue(adjustableParameter, runTimeStep, d2)) == Double.NEGATIVE_INFINITY) continue;
                d2 = d3;
            }
        }
        return d2;
    }

    public double getValue(AdjustableParameter adjustableParameter, RunTimeStep runTimeStep) {
        double d;
        double d2;
        double d3 = this.getRuleValue(adjustableParameter, runTimeStep);
        if (d2 > adjustableParameter.getMaxValue()) {
            d3 = adjustableParameter.getMaxValue();
        }
        if (d3 < adjustableParameter.getMinValue()) {
            d3 = adjustableParameter.getMinValue();
        }
        double d4 = adjustableParameter.getCurrentValue();
        double d5 = runTimeStep.getTimeStepSeconds();
        double d6 = (d3 - d4) / (d5 / 3600.0);
        if (d3 > d4) {
            double d7 = adjustableParameter.getMaxRateOfIncrease();
            if (d7 != Double.NEGATIVE_INFINITY && d6 > d7) {
                d3 = d4 + d7 * (d5 / 3600.0);
            }
        } else if (d3 < d4 && (d = adjustableParameter.getMaxRateOfDecrease()) != Double.NEGATIVE_INFINITY && -d6 > d) {
            d3 = d4 - d * (d5 / 3600.0);
        }
        return d3;
    }

    public boolean writeData(BufferedWriter bufferedWriter) {
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller=" + this.getIndex()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller Name=" + this.getName()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller Desc=" + this.getDescription()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller AdjustableParam= " + this._adjparamElement + ", " + this._adjparamFunction + ", " + this._adjparamName));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"");
        for (int i = 0; i < this.ruleVector.size(); ++i) {
            Rule rule = (Rule)this.ruleVector.elementAt(i);
            if (rule == null) continue;
            rule.writeData(bufferedWriter);
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"");
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"Controller End");
        return true;
    }

    public boolean readData(BufferedReader bufferedReader) {
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.length() == 0) {
                    string = bufferedReader.readLine();
                    continue;
                }
                if (string.indexOf("Controller") < 0) break;
                Object object = RMAIO.getType((String)string, (String)"=");
                string = RMAIO.getParam((String)string, (String)"=");
                if (((String)object).compareTo("Controller Name") == 0) {
                    this.setName(string);
                } else if (((String)object).compareTo("Controller Desc") == 0) {
                    this.setDescription(string);
                } else if (((String)object).compareTo("Controller AdjustableParam") == 0) {
                    object = new rmaTokenizer(string, ",");
                    try {
                        string = object.nextToken();
                        this._adjparamElement = string.trim();
                        string = object.nextToken();
                        this._adjparamFunction = string.trim();
                        string = object.nextToken();
                        this._adjparamName = string.trim();
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                } else if (((String)object).compareTo("Controller Rule") == 0) {
                    object = RuleFactory.a(this, string);
                    if (object == null) {
                        this._operations.printMessage("Could not create Rule " + string);
                    } else if (((Rule)object).readData(bufferedReader)) {
                        this.ruleVector.addElement(object);
                    } else {
                        this._operations.printMessage("Error reading data for Rule " + string);
                    }
                } else if (((String)object).compareTo("Controller End") == 0) break;
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void updateTSProxyList() {
        Enumeration enumeration = this.ruleVector.elements();
        while (enumeration.hasMoreElements()) {
            Rule rule = (Rule)enumeration.nextElement();
            if (rule == null) continue;
            ((RssTSLocationObject)rule).updateTSProxyList();
        }
    }

    public Vector getActiveTSRecordProxies(Vector vector, int n) {
        if (vector == null) {
            vector = new Vector();
        }
        Enumeration enumeration = this.ruleVector.elements();
        while (enumeration.hasMoreElements()) {
            Rule rule = (Rule)enumeration.nextElement();
            ((RssTSLocationObject)rule).getActiveTSRecordProxies(vector, n);
        }
        return vector;
    }

    public Vector getTSRecordProxies(boolean bl) {
        Vector vector = new Vector();
        Controller controller = this;
        Object object = controller.findElement(controller._adjparamElement);
        if (object == null) {
            return vector;
        }
        for (int i = 0; i < this.ruleVector.size(); ++i) {
            object = (Rule)this.ruleVector.elementAt(i);
            if (object == null || (object = ((RssTSLocationObject)object).getTSRecordProxies()) == null) continue;
            for (int j = 0; j < ((Vector)object).size(); ++j) {
                TSRecordProxy tSRecordProxy = (TSRecordProxy)((Vector)object).elementAt(j);
                if (tSRecordProxy == null || tSRecordProxy.isInput() != bl) continue;
                vector.addElement(((Vector)object).elementAt(j));
            }
        }
        return vector;
    }

    public Object getFieldObject(Field field) {
        try {
            Object object = field.get((Object)this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set((Object)this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

