/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.heclib.util.doubleArrayContainer;
import hec.model.RunTimeStep;
import hec.rss.model.Function;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssNode;
import java.lang.reflect.Field;
import java.util.List;

public class CumLocFunction
extends Function {
    private transient doubleArrayContainer[] a;

    public CumLocFunction() {
    }

    public CumLocFunction(ReservoirElement reservoirElement) {
        super(reservoirElement);
    }

    @Override
    public synchronized Object clone() {
        CumLocFunction cumLocFunction = (CumLocFunction)super.clone();
        return cumLocFunction;
    }

    @Override
    public int computeForecastStep(RunTimeStep runTimeStep) {
        if (this.a == null) {
            return 1;
        }
        for (int i = 0; i < this.a.length; ++i) {
            this.a[i].array[runTimeStep.step] = 0.0;
        }
        return 0;
    }

    @Override
    public int computeHindcastStep(RunTimeStep runTimeStep) {
        return ((Function)this).computeForecastStep(runTimeStep);
    }

    @Override
    public boolean initialize() {
        List list = this.element.getDownstreamNodes(null);
        if (list == null || list.size() <= 0) {
            this.printErrorMessage("initialize", "Reservoir has no outlet");
            return false;
        }
        this.a = new doubleArrayContainer[list.size()];
        for (int i = 0; i < this.a.length; ++i) {
            RssNode rssNode = (RssNode)list.get(i);
            if (rssNode == null) {
                this.printErrorMessage("initialize", "Failed to get outlet node");
                return false;
            }
            this.a[i] = rssNode.getTSContainer(0);
            if (this.a[i] != null) continue;
            this.printErrorMessage("initialize", "Failed to get outlet node time series");
            return false;
        }
        return true;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

