/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.doubleArrayContainer;
import hec.io.DSSIdentifier;
import hec.model.PairedValues;
import hec.model.RunTimeStep;
import hec.rss.model.ControlStructure;
import hec.rss.model.Element;
import hec.rss.model.Function;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssNode;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import java.lang.reflect.Field;
import java.util.ArrayList;
import rma.util.DSSPathPartGenerator;
import rma.util.RMAConst;

public class Dam
extends ControlStructure
implements AltInputReportInfc {
    double _topOfDam = Double.NEGATIVE_INFINITY;
    double _topLength = Double.NEGATIVE_INFINITY;
    double _weirCoef = 0.3;
    PairedValues _leakageValues = new PairedValues();
    boolean _computesLeakage = false;
    private transient doubleArrayContainer a;
    private transient doubleArrayContainer b;
    private transient doubleArrayContainer c;
    private transient doubleArrayContainer d;

    public Dam() {
    }

    public Dam(Element element) {
        super(element);
    }

    public double computeStepFlow(RunTimeStep runTimeStep) {
        double d;
        if (runTimeStep.isPerAvgTimeStep()) {
            Dam dam = this;
            d = dam.periodAverageFlow(dam.a.array[runTimeStep.step - 1], this.a.array[runTimeStep.step], (double)runTimeStep.getTimeStepSeconds());
        } else {
            Dam dam = this;
            d = ((ControlStructure)dam).getRelease(dam.a.array[runTimeStep.step]);
        }
        return d;
    }

    public double getHindcastFlow(RunTimeStep runTimeStep) {
        return 0.0;
    }

    public double getEstimatedFlow(RunTimeStep runTimeStep, double d, double d2) {
        if (runTimeStep.isPerAvgTimeStep()) {
            return this.periodAverageFlow(d, d2, (double)runTimeStep.getTimeStepSeconds());
        }
        return ((ControlStructure)this).getRelease(d2);
    }

    @Override
    public double getEstimatedFlow(RunTimeStep runTimeStep, int n) {
        double d = 0.0;
        if (this.c == null) {
            return 0.0;
        }
        n = runTimeStep.step - 1;
        if (n < 0) {
            n = 0;
        }
        if (!RMAConst.isUndefinedValue((double)this.c.array[runTimeStep.step])) {
            d = this.c.array[runTimeStep.step];
        } else if (!RMAConst.isUndefinedValue((double)this.c.array[n])) {
            d = this.c.array[n];
        }
        return d;
    }

    @Override
    public double getEstimatedROI(RunTimeStep runTimeStep, int n) {
        n = runTimeStep.step - 1;
        if (n < 0) {
            return 0.0;
        }
        double d = 0.0;
        if (this.c == null) {
            return 0.0;
        }
        if (!RMAConst.isUndefinedValue((double)this.c.array[runTimeStep.step]) && !RMAConst.isUndefinedValue((double)this.c.array[n])) {
            d = (this.c.array[runTimeStep.step] - this.c.array[n]) / (double)runTimeStep.getTimeStepMinutes() * 60.0;
        }
        return d;
    }

    @Override
    public double getEstimatedROD(RunTimeStep runTimeStep, int n) {
        n = runTimeStep.step - 1;
        if (n < 0) {
            return 0.0;
        }
        double d = 0.0;
        if (this.c == null) {
            return 0.0;
        }
        if (!RMAConst.isUndefinedValue((double)this.c.array[runTimeStep.step]) && !RMAConst.isUndefinedValue((double)this.c.array[n])) {
            d = (this.c.array[n] - this.c.array[runTimeStep.step]) / (double)runTimeStep.getTimeStepMinutes() * 60.0;
        }
        return d;
    }

    @Override
    public void setupForSerialization() {
        super.setupForSerialization();
        if (this._leakageValues == null) {
            return;
        }
        Object object = new DSSPathname();
        Object object2 = new DSSPathPartGenerator();
        String string = this.getElement().getTopParent().getName();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        string = object2.generatePathnamePart(arrayList, "");
        object.setAPart(string);
        arrayList.clear();
        arrayList.add(this.getName());
        arrayList.add("Leakage");
        object2 = object2.generatePathnamePart(arrayList, "-");
        object.setBPart((String)object2);
        object2 = Parameter.getParamString((int)Parameter.PARAMID_ELEV) + "-" + Parameter.getParamString((int)Parameter.PARAMID_FLOW);
        object.setCPart((String)object2);
        object2 = this.getElement().getSystem().getDssPairedDataFilePath();
        object = object.getPathname();
        this._leakageValues.setDssIdentifer(new DSSIdentifier((String)object2, (String)object));
        this._leakageValues.setParamXId(Parameter.PARAMID_ELEV);
        this._leakageValues.setParamYId(Parameter.PARAMID_FLOW);
        this._leakageValues.setUnitSystem(this.getUnitSystem());
    }

    public boolean getComputesLeakage() {
        return this._computesLeakage;
    }

    public void setComputesLeakage(boolean bl) {
        this._computesLeakage = bl;
    }

    @Override
    public synchronized Object clone() {
        Dam dam = (Dam)super.clone();
        if (this._leakageValues != null) {
            dam._leakageValues = (PairedValues)this._leakageValues.clone();
        }
        return dam;
    }

    public boolean hasLeakageValues() {
        return this._computesLeakage && this._leakageValues != null && this._leakageValues.size() > 0;
    }

    public PairedValues getLeakageValues() {
        this._leakageValues.setUnitSystem(this.getUnitSystem());
        this._leakageValues.setParamXId(Parameter.PARAMID_ELEV);
        this._leakageValues.setParamYId(Parameter.PARAMID_FLOW);
        return this._leakageValues;
    }

    public void setLeakageValues(PairedValues pairedValues) {
        this._leakageValues = pairedValues;
    }

    @Override
    public int computeHindcastStep(RunTimeStep runTimeStep) {
        if (this.c == null || this.b == null) {
            return 1;
        }
        this.c.array[runTimeStep.step] = this.getHindcastFlow(runTimeStep);
        this.b.array[runTimeStep.step] = this.c.array[runTimeStep.step];
        this.adjustableParam.setMaxValue(this.c.array[runTimeStep.step]);
        this.adjustableParam.setMinValue(this.c.array[runTimeStep.step]);
        this.adjustableParam.setValue(this.c.array[runTimeStep.step]);
        this.d.array[runTimeStep.step] = this.c.array[runTimeStep.step];
        return 0;
    }

    @Override
    public boolean initialize() {
        this.b = null;
        this.c = null;
        this.a = null;
        if (!super.initialize()) {
            return false;
        }
        RssNode rssNode = this.element.getNode(0);
        RssNode rssNode2 = this.element.getNode(1);
        if (rssNode == null || rssNode2 == null) {
            this.printErrorMessage("initialize", "failed to load up and down stream nodes");
            return false;
        }
        Element element = this.element.getTopParent();
        if (!(element instanceof ReservoirElement)) {
            this.printErrorMessage("initialize", "no parent reservoir");
            return false;
        }
        this.a = ((ReservoirElement)element).getStorageFunction().getTSContainer(10);
        this.b = rssNode.getTSContainer(0);
        this.c = rssNode2.getTSContainer(0);
        if (this.a == null || this.c == null || this.b == null) {
            this.printErrorMessage("initialize", "failed to load elevation or flow time-series");
            return false;
        }
        if (this.adjustableParam == null) {
            this.adjustableParam = ((Function)this).getAdjustableParameter();
        }
        this.d = this.getTSContainer(47);
        if (this.d == null) {
            this.printErrorMessage("initialize", "failed to load flow setting time-series");
            return false;
        }
        this.adjustableParam.setValueTSContainer(this.d);
        return true;
    }

    @Override
    public int computeForecastStep(RunTimeStep runTimeStep) {
        if (this.b == null) {
            return 1;
        }
        if (this.c == null) {
            return 1;
        }
        if (this.a == null) {
            return 1;
        }
        if (runTimeStep.isPerAvgTimeStep()) {
            int n = runTimeStep.step > 0 ? runTimeStep.step - 1 : 0;
            Dam dam = this;
            this.c.array[runTimeStep.step] = dam.periodAverageFlow(dam.a.array[n], this.a.array[runTimeStep.step], (double)runTimeStep.getTimeStepSeconds());
        } else {
            Dam dam = this;
            this.c.array[runTimeStep.step] = ((ControlStructure)dam).getRelease(dam.a.array[runTimeStep.step]);
        }
        this.b.array[runTimeStep.step] = this.c.array[runTimeStep.step];
        this.adjustableParam.setMaxValue(this.c.array[runTimeStep.step]);
        this.adjustableParam.setMinValue(this.c.array[runTimeStep.step]);
        this.adjustableParam.setValue(this.c.array[runTimeStep.step]);
        this.d.array[runTimeStep.step] = this.c.array[runTimeStep.step];
        return 0;
    }

    @Override
    public int computeForecastStep(RunTimeStep runTimeStep, double[] dArray, double[] dArray2, int n) {
        if (this.b == null) {
            return 1;
        }
        if (this.c == null) {
            return 1;
        }
        if (this.a == null) {
            return 1;
        }
        this.c.array[runTimeStep.step] = runTimeStep.isPerAvgTimeStep() ? this.periodAverageFlow(dArray, dArray2, n) : ((ControlStructure)this).getRelease(dArray2[n - 1]);
        this.b.array[runTimeStep.step] = this.c.array[runTimeStep.step];
        this.adjustableParam.setMaxValue(this.c.array[runTimeStep.step]);
        this.adjustableParam.setMinValue(this.c.array[runTimeStep.step]);
        this.adjustableParam.setValue(this.c.array[runTimeStep.step]);
        this.d.array[runTimeStep.step] = this.c.array[runTimeStep.step];
        return 0;
    }

    @Override
    public double computeSubStepFlow(RunTimeStep runTimeStep, double d, double d2) {
        double d3 = ((ControlStructure)this).getRelease(d2);
        return d3;
    }

    @Override
    public double getRelease(double d) {
        double d2 = 0.0;
        if (this._topOfDam == Double.NEGATIVE_INFINITY || this._topLength == Double.NEGATIVE_INFINITY) {
            d2 = 0.0;
        } else if (d > this._topOfDam) {
            double d3 = 3.0;
            if (this.getUnitSystem() == 2) {
                d3 = 1.65;
            }
            d2 = d3 * this._topLength * Math.pow(d - this._topOfDam, 1.5);
        }
        if (this.hasLeakageValues()) {
            d2 += this._leakageValues.interpolateValue(d);
        }
        return d2;
    }

    public void getTopOfDam(ParamDouble paramDouble) {
        paramDouble.setValue(this._topOfDam);
        paramDouble.setUnitSystem(this.getUnitSystem());
        paramDouble.setParameterId(Parameter.PARAMID_ELEV);
    }

    public void setTopOfDam(ParamDouble paramDouble) {
        this._topOfDam = paramDouble.getValue();
    }

    public double getTopOfDam() {
        return this._topOfDam;
    }

    public void getWidthOfDam(ParamDouble paramDouble) {
        paramDouble.setValue(this._topLength);
        paramDouble.setParameterId(Parameter.PARAMID_WIDTH);
        paramDouble.setUnitSystem(this.getUnitSystem());
    }

    public void setWidthOfDam(ParamDouble paramDouble) {
        this._topLength = paramDouble.getValue();
    }

    public double getWidthOfDam() {
        return this._topLength;
    }

    public void setTopOfDam(double d) {
        this._topOfDam = d;
    }

    public void setWidthOfDam(double d) {
        this._topLength = d;
    }

    public double getWeirCoef() {
        return this._weirCoef;
    }

    public void setWeirCoef(double d) {
        this._weirCoef = d;
    }

    @Override
    public void updateTSProxyList() {
        if (this.element == null) {
            return;
        }
        RssNode rssNode = this.element.getNode(0);
        if (rssNode != null && rssNode.getTSRecordProxy(0) == null) {
            rssNode.addTSRecordProxy(0);
        }
        if ((rssNode = this.element.getNode(1)) != null && rssNode.getTSRecordProxy(0) == null) {
            rssNode.addTSRecordProxy(0);
        }
        if (this.getTSRecordProxy(47) == null) {
            this.addTSRecordProxy(47);
        }
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        element.setAttribute("Elev_At_Top", Double.toString(this._topOfDam));
        element.setAttribute("Length_At_Top", Double.toString(this._topLength));
    }
}

