/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.heclib.util.HecTime;
import hec.io.AsciiSerializable;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.lang.reflect.Field;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Element;

public class DecisionSch
implements AsciiSerializable,
AltInputReportInfc,
Cloneable {
    public static final int INTERVALTYPE_STEP = 0;
    public static final int INTERVALTYPE_REGULAR = 1;
    public static final int INTERVALTYPE_WEEKLYSCH = 2;
    public static final int REGULARTYPE_1HR = 0;
    public static final int REGULARTYPE_2HR = 1;
    public static final int REGULARTYPE_3HR = 2;
    public static final int REGULARTYPE_4HR = 3;
    public static final int REGULARTYPE_6HR = 4;
    public static final int REGULARTYPE_8HR = 5;
    public static final int REGULARTYPE_12HR = 6;
    public static final int REGULARTYPE_DAILY = 7;
    public static final int REGULARTYPE_WEEKLY = 8;
    public static final int REGULARTYPE_MONTHLY = 9;
    int _intervalType = 0;
    int _regularType = 0;
    int _startingHr = 0;
    int _startingDOW = -1;
    int _startingDOM = -1;
    Vector[] _weeklySch;
    private transient int a = -1;
    private transient int[] b;
    private static int[] c = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public Object clone() {
        try {
            DecisionSch decisionSch = (DecisionSch)super.clone();
            if (this._weeklySch != null) {
                decisionSch._weeklySch = new Vector[7];
                for (int i = 0; i < 7; ++i) {
                    if (this._weeklySch.length <= i || this._weeklySch[i] == null) continue;
                    decisionSch._weeklySch[i] = new Vector();
                    int n = this._weeklySch[i].size();
                    for (int j = 0; j < n; ++j) {
                        decisionSch._weeklySch[i].add(new String((String)this._weeklySch[i].elementAt(j)));
                    }
                }
            }
            return decisionSch;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int getCurrentDecisionInterval() {
        return this._intervalType;
    }

    public void setCurrentDecisionInterval(int n) {
        this._intervalType = n;
    }

    public int getRegularType() {
        return this._regularType;
    }

    public void setRegularType(int n) {
        this._regularType = n;
    }

    public int getStartHour() {
        return this._startingHr;
    }

    public void setStartHour(int n) {
        this._startingHr = n;
    }

    public int getStartDOW() {
        return this._startingDOW;
    }

    public void setStartDOW(int n) {
        this._startingDOW = n;
    }

    public int getStartDOM() {
        return this._startingDOM;
    }

    public void setStartDOM(int n) {
        this._startingDOM = n;
    }

    public Vector[] getWeeklySchedule() {
        return this._weeklySch;
    }

    public void setWeeklySchedule(Vector[] vectorArray) {
        this._weeklySch = vectorArray;
    }

    public void clearRegularInterval() {
        this._intervalType = 0;
        this._regularType = 0;
        this._startingHr = 0;
        this._startingDOW = -1;
        this._startingDOM = -1;
    }

    public void clearWeeklySchedule() {
        this._weeklySch = null;
    }

    public boolean isDecisionStep(RunTimeStep runTimeStep) {
        if (this.b == null) {
            return true;
        }
        int n = runTimeStep.step;
        if (n < 0) {
            n = 0;
        }
        if (n > this.b.length) {
            n = this.b.length - 1;
        }
        return this.b[n] > 0;
    }

    public boolean determineDecisionStep(RunTimeStep runTimeStep) {
        if (this._intervalType == 2) {
            String string;
            int n;
            if (this._weeklySch == null) {
                return true;
            }
            HecTime hecTime = runTimeStep.getHecTime();
            int n2 = hecTime.secondsSinceMidnight();
            int n3 = n2 + runTimeStep.getTimeStepSeconds();
            int n4 = n2 - runTimeStep.getTimeStepSeconds();
            if (n4 < 0) {
                n4 += 86400;
            }
            if ((n = runTimeStep.getDayOfWeek()) < 0 || n > this._weeklySch.length) {
                return false;
            }
            Vector vector = this._weeklySch[n];
            if (vector == null) {
                return false;
            }
            int n5 = vector.size();
            for (int i = 0; i < n5 && (string = (String)vector.elementAt(i)) != null && string.length() >= 4; ++i) {
                int n6 = Integer.parseInt(string);
                n6 = n6 / 100 * 3600 + n6 % 100 * 60;
                if ((n6 += runTimeStep.getTimeStepSeconds()) > n3) {
                    return false;
                }
                if (n6 <= n4 || n6 > n2) continue;
                return true;
            }
            return false;
        }
        if (this._intervalType == 1) {
            HecTime hecTime = runTimeStep.getHecTime();
            int n = hecTime.secondsSinceMidnight();
            int n7 = runTimeStep.getTimeStepSeconds();
            if (n7 <= 86400 && n < n7 + this._startingHr * 3600) {
                n += 86400;
            }
            if (n7 > 86400) {
                System.out.println("hec.rss.model.DecisionSch: not expecting a time step > 1 day");
            }
            switch (this._regularType) {
                case 0: {
                    if (n7 >= 3600) {
                        return true;
                    }
                    return (n - n7) % 3600 == 0;
                }
                case 1: {
                    if (n7 >= 7200) {
                        return true;
                    }
                    return (n - n7 - this._startingHr * 3600) % 7200 < n7;
                }
                case 2: {
                    if (n7 >= 10800) {
                        return true;
                    }
                    return (n - n7 - this._startingHr * 3600) % 10800 < n7;
                }
                case 3: {
                    if (n7 >= 14400) {
                        return true;
                    }
                    return (n - n7 - this._startingHr * 3600) % 14400 < n7;
                }
                case 4: {
                    if (n7 >= 21600) {
                        return true;
                    }
                    return (n - n7 - this._startingHr * 3600) % 21600 < n7;
                }
                case 5: {
                    if (n7 >= 28800) {
                        return true;
                    }
                    return (n - n7 - this._startingHr * 3600) % 28800 < n7;
                }
                case 6: {
                    if (n7 >= 43200) {
                        return true;
                    }
                    return (n - n7 - this._startingHr * 3600) % 43200 < n7;
                }
                case 7: {
                    if (n7 >= 86400) {
                        return true;
                    }
                    if (n < n7 + this._startingHr * 3600) {
                        n += 86400;
                    }
                    return (n - n7 - this._startingHr * 3600) % 86400 < n7;
                }
                case 8: {
                    if (n < n7 + this._startingHr * 3600) {
                        n += 86400;
                    }
                    int n8 = this._startingDOW;
                    if (n7 + this._startingHr * 3600 > 86400) {
                        ++n8;
                    }
                    return (n - n7 - this._startingHr * 3600) % 86400 < n7 && RunTimeStep.getDayOfWeek((HecTime)hecTime) == n8;
                }
                case 9: {
                    if (n < n7 + this._startingHr * 3600) {
                        n += 86400;
                    }
                    int n9 = this._startingDOM + 1;
                    if (n7 + this._startingHr * 3600 > 86400) {
                        ++n9;
                    }
                    if (n9 > DecisionSch.a(hecTime)) {
                        n9 = 1;
                    }
                    return (n - n7 - this._startingHr * 3600) % 86400 < n7 && hecTime.day() == n9;
                }
            }
            return true;
        }
        return true;
    }

    public int getNumDecisionSteps(RunTimeStep runTimeStep) {
        if (this.b == null) {
            return 1;
        }
        int n = runTimeStep.step;
        if (n < 0) {
            n = 0;
        }
        if (n >= this.b.length) {
            n = this.b.length - 1;
        }
        return this.b[n];
    }

    public int calcNumDecisionSteps(RunTimeStep runTimeStep) {
        if (this._intervalType == 2) {
            int n = runTimeStep.getTimeStepSeconds();
            if (this._weeklySch == null) {
                return 604800 / n;
            }
            HecTime hecTime = runTimeStep.getHecTime();
            int n2 = hecTime.secondsSinceMidnight();
            runTimeStep.getTimeStepSeconds();
            int n3 = runTimeStep.getDayOfWeek();
            if (n3 < 0 || n3 > this._weeklySch.length) {
                return 604800 / n;
            }
            for (int i = 0; i < 8; ++i) {
                String string;
                Vector vector;
                int n4 = n3 + i;
                if (n4 >= 7) {
                    n4 -= 7;
                }
                if ((vector = this._weeklySch[n4]) == null) continue;
                int n5 = vector.size();
                for (int j = 0; j < n5 && (string = (String)vector.elementAt(j)) != null && string.length() >= 4; ++j) {
                    int n6 = Integer.parseInt(string);
                    n6 = n6 / 100 * 3600 + n6 % 100 * 60;
                    if (i == 0 && (n6 += runTimeStep.getTimeStepSeconds()) <= n2) continue;
                    return (i * 24 * 3600 + n6 - n2) / n;
                }
            }
            return 604800 / n;
        }
        return this.a;
    }

    public int getMaxNumDecisionSteps(int n) {
        if (this.a <= 0) {
            return this.calcMaxNumDecisionSteps(n);
        }
        return this.a;
    }

    public int calcMaxNumDecisionSteps(int n) {
        if (this._intervalType == 2) {
            if (this._weeklySch == null) {
                return 604800 / n;
            }
            int n2 = 0;
            int n3 = 0;
            boolean bl = true;
            int n4 = 0;
            int n5 = 1;
            int n6 = 0;
            for (int i = 0; i < 7; ++i) {
                String string;
                int n7 = i + 0;
                Vector vector = this._weeklySch[n7];
                if (vector == null) continue;
                int n8 = vector.size();
                for (int j = 0; j < n8 && (string = (String)vector.elementAt(j)) != null; ++j) {
                    n6 = Integer.parseInt(string);
                    n6 = n6 / 100 * 3600 + n6 % 100 * 60;
                    if (i == 0 && n6 <= n2) continue;
                    if (n5 < (n2 = (n3 * 24 * 3600 + n6 - n2) / n)) {
                        n5 = n2;
                    }
                    if (bl) {
                        n4 = n2;
                    }
                    bl = false;
                    n3 = 0;
                    n2 = n6;
                }
                ++n3;
            }
            n2 = n4 + (n3 * 24 * 3600 + n6) / n;
            if (n5 < n2) {
                n5 = n2;
            }
            if (n5 <= 0) {
                n5 = 1;
            }
            if (n5 > 604800 / n) {
                n5 = 604800 / n;
            }
            return n5;
        }
        if (this._intervalType == 1) {
            if (n == 0) {
                return 1;
            }
            switch (this._regularType) {
                case 0: {
                    if (n >= 3600) {
                        return 1;
                    }
                    return 3600 / n;
                }
                case 1: {
                    if (n >= 7200) {
                        return 1;
                    }
                    return 7200 / n;
                }
                case 2: {
                    if (n >= 10800) {
                        return 1;
                    }
                    return 10800 / n;
                }
                case 3: {
                    if (n >= 14400) {
                        return 1;
                    }
                    return 14400 / n;
                }
                case 4: {
                    if (n >= 21600) {
                        return 1;
                    }
                    return 21600 / n;
                }
                case 5: {
                    if (n >= 28800) {
                        return 1;
                    }
                    return 28800 / n;
                }
                case 6: {
                    if (n >= 43200) {
                        return 1;
                    }
                    return 43200 / n;
                }
                case 7: {
                    if (n >= 86400) {
                        return 1;
                    }
                    return 86400 / n;
                }
                case 8: {
                    if (n >= 604800) {
                        return 1;
                    }
                    return 604800 / n;
                }
                case 9: {
                    return 2678400 / n;
                }
            }
            return 1;
        }
        return 1;
    }

    public static int a(HecTime hecTime) {
        int n = hecTime.month();
        int n2 = hecTime.year();
        if (--n == 1 && n2 % 4 == 0 && (n2 % 100 != 0 || n2 % 400 == 0)) {
            return 29;
        }
        return c[n];
    }

    public boolean initializeCompute(RunTimeWindow runTimeWindow) {
        this.a = this.calcMaxNumDecisionSteps(runTimeWindow.getTimeStepSeconds());
        if (this.a > 1) {
            int n = runTimeWindow.getNumSteps();
            this.b = new int[n + 1];
            RunTimeStep runTimeStep = new RunTimeStep(runTimeWindow);
            for (int i = 0; i <= n; ++i) {
                runTimeStep.step = i;
                this.b[i] = this.determineDecisionStep(runTimeStep) ? this.calcNumDecisionSteps(runTimeStep) : -1;
            }
        } else {
            this.b = null;
        }
        return true;
    }

    public Object getFieldObject(Field object) {
        try {
            object = ((Field)object).get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, Element element) {
        element.setAttribute("IntervalType", Integer.toString(this._intervalType));
        if (this._intervalType == 1) {
            element.setAttribute("RegularType", Integer.toString(this._regularType));
            element.setAttribute("StartHour", Integer.toString(this._startingHr));
            element.setAttribute("StartDOW", Integer.toString(this._startingDOW));
            element.setAttribute("StartDOM", Integer.toString(this._startingDOM));
            return;
        }
        if (this._intervalType == 2) {
            for (int i = 0; i < this._weeklySch.length; ++i) {
                Vector vector = this._weeklySch[i];
                alternativeInputReport = new Element("HoursOfDec" + i);
                element.addContent((Content)alternativeInputReport);
                if (vector == null || vector.size() <= 0) continue;
                String[] stringArray = new String[vector.size()];
                for (int j = 0; j < vector.size(); ++j) {
                    stringArray[j] = vector.get(j).toString();
                }
                XMLUtilities.createArrayElements((Element)alternativeInputReport, (String[])stringArray);
            }
        }
    }
}

