/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.heclib.dss.DSSPathname;
import hec.io.DSSIdentifier;
import hec.lang.NamedType;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.model.ModelVariable;
import hec.model.PairedValues;
import hec.model.PairedValuesExt;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.model.TSLocation;
import hec.rss.model.AdjustableDiversion;
import hec.rss.model.CoefRouting;
import hec.rss.model.ConditionalBlockRef;
import hec.rss.model.ConstantRelease;
import hec.rss.model.ControlStructure;
import hec.rss.model.Controller;
import hec.rss.model.DiversionDemandOpRule;
import hec.rss.model.DiversionOp;
import hec.rss.model.DiversionRule;
import hec.rss.model.Element;
import hec.rss.model.ElementAssignmentContainer;
import hec.rss.model.ElementOp;
import hec.rss.model.FlowFunction;
import hec.rss.model.Function;
import hec.rss.model.FunctionFactory;
import hec.rss.model.LagAndKRouting;
import hec.rss.model.MonthlyRelease;
import hec.rss.model.MuskingumCungeRouting;
import hec.rss.model.MuskingumRouting;
import hec.rss.model.NullRouting;
import hec.rss.model.OpController;
import hec.rss.model.OpRule;
import hec.rss.model.OpSet;
import hec.rss.model.OperationsElement;
import hec.rss.model.PoolElevation;
import hec.rss.model.PulsChannelRoutingWithLosses;
import hec.rss.model.RSimDssPathPartGenerator;
import hec.rss.model.ReleaseElement;
import hec.rss.model.Routing;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.Rule;
import hec.rss.model.RuleResolution;
import hec.rss.model.SeepageConstants;
import hec.rss.model.SpecifiedRelease;
import hec.rss.model.SsarrRouting;
import hec.rss.model.Storage;
import hec.rss.model.StorageZone;
import hec.rss.model.TimeStepRoutingElement;
import hec.rss.model.TimeStepUtil;
import hec.rss.model.VerticalDatumSettings;
import hec.rss.model.WorkingRDRouting;
import hec.rss.model.reports.AltInputReportEnums;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.jdom.Content;

public class DiversionElement
extends Element
implements OperationsElement,
ReleaseElement,
SeepageConstants,
AltInputReportInfc {
    public static final String CONTROL_STR = " Cntrl";
    int _seepageType = 0;
    double _constSeepage = Double.NEGATIVE_INFINITY;
    double _returnRatio = 1.0;
    public static final String KNOWN_DIVERSION = " Hindcast";
    PairedValues _seepageValues = new PairedValues();
    WorldPt _referencePt = new WorldPt();
    WorldLine _line = new WorldLine();
    RssNode _cntrlNode = null;
    int _inFlowType = 0;
    boolean _computeDuringUnReg = false;
    long _diversionProjectId = Long.MIN_VALUE;
    private VerticalDatumSettings _verticalDatumSettings = new VerticalDatumSettings();
    private DiversionOp _divOps;
    private String _divOpName;
    private String _fillColorName;

    public DiversionElement() {
    }

    public DiversionElement(RssSystem rssSystem, int n) {
        super(rssSystem, n);
    }

    private void createDefaultDiversionOp() {
        if (this._divOps == null) {
            DiversionOp diversionOp = new DiversionOp();
            diversionOp.setDiversionElement(this);
            diversionOp.setName(this.getDivOpName());
            diversionOp.setDescription("Operations for " + this.getName());
            this._divOps = diversionOp;
        }
    }

    public String getDivOpName() {
        if (this._divOpName == null) {
            this._divOpName = this._system.getName() + "_" + this.getName();
        }
        return this._divOpName;
    }

    @Override
    public List<Element> getLinkedElementList(int n) {
        if (n == 0) {
            return super.getLinkedElementList(n);
        }
        Object object = this.getSourceElement();
        object = ((Element)object).getLinkedElementList(1);
        int n2 = object.size();
        for (int i = n2 - 1; i >= 0; --i) {
            Element element = (Element)object.get(i);
            if (!(element instanceof DiversionElement)) continue;
            object.remove(i);
        }
        return object;
    }

    public double getDiversionVolume(RunTimeStep runTimeStep) {
        double d;
        AdjustableDiversion adjustableDiversion = (AdjustableDiversion)this.getChildElementAt(0).getFunction();
        double d2 = adjustableDiversion.getController().getRuleValue(((Function)adjustableDiversion).getAdjustableParameter(), runTimeStep);
        if (d2 == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (runTimeStep.isPerAvgTimeStep()) {
            d = d2 * (double)runTimeStep.getTimeStepSeconds() / Storage.DSDT_TO_Q;
        } else {
            int n = runTimeStep.step--;
            if (runTimeStep.step < 0) {
                runTimeStep.step = 0;
            }
            double d3 = adjustableDiversion.getController().getRuleValue(((Function)adjustableDiversion).getAdjustableParameter(), runTimeStep);
            runTimeStep.step = n;
            if (d3 == Double.NEGATIVE_INFINITY) {
                d3 = d2;
            }
            d = 0.5 * (d3 + d2) * (double)runTimeStep.getTimeStepSeconds() / Storage.DSDT_TO_Q;
        }
        return d;
    }

    public void getReferencedStateVariables(List list) {
        if (list == null) {
            return;
        }
        Object object = this.getController();
        object = ((Controller)((Object)object)).getRuleVector();
        int n = object.size();
        for (int i = 0; i < n; ++i) {
            Rule rule = (Rule)object.get(i);
            if (rule == null) continue;
            rule.getReferencedStateVariables(list);
        }
    }

    @Override
    public List getRuleConnectivityRefs() {
        Controller controller = this.getController();
        if (controller == null) {
            return null;
        }
        return controller.getRuleConnectivityRefs(true);
    }

    public void disconnectDownstream(double d, double d2) {
        RssNode rssNode = ((Element)this).getDownstreamNode();
        if (rssNode == null) {
            return;
        }
        ((Element)this).removeNode(rssNode);
        Element element = rssNode.getDownstreamElement();
        if (element != null) {
            element.removeNode(rssNode);
        }
        if (d != 0.0 && d2 != 0.0) {
            rssNode = new WorldPt(rssNode.getLocation());
            ((WorldPt)rssNode).n += d2;
            ((WorldPt)rssNode).e += d;
            this.getLine().getLastPt().init((WorldPt)rssNode);
        }
        this.setModified(true);
    }

    @Override
    public Vector getComputedTSRecordProxies() {
        Vector<TSRecordProxy> vector = new Vector<TSRecordProxy>();
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            RssNode rssNode = this._nodeVector.elementAt(i);
            if (rssNode == null || rssNode.getTSRecordProxy(0) == null) continue;
            vector.addElement(rssNode.getTSRecordProxy(0));
        }
        return vector;
    }

    @Override
    public void updateDecisions(RunTimeStep runTimeStep, int n) {
        if (this._divOps == null) {
            return;
        }
        this._divOps.updateDecisions(runTimeStep, n);
    }

    public int updateOperations(RunTimeStep runTimeStep, int n, boolean bl) {
        if (n == 0 && runTimeStep.step == runTimeStep.rtw.getNumLookbackSteps() + 1) {
            return 100;
        }
        return 0;
    }

    @Override
    public boolean initialize(RunTimeWindow runTimeWindow) {
        if (!super.initialize(runTimeWindow)) {
            return false;
        }
        this.getCompositeRelease();
        RssAlt rssAlt = this._system.getAlternative();
        if (rssAlt == null) {
            return false;
        }
        this.getDiversionOps();
        if (this._divOps == null) {
            this._system.printErrorMessage("DiversionElement.initialize: Could not retrieve operations data for diversion " + this.getName());
            return false;
        }
        this.getReachElement();
        return this._divOps.initializeCompute(runTimeWindow);
    }

    @Override
    public int initForecastOperations(RunTimeWindow runTimeWindow) {
        this.getDiversionOps();
        return 0;
    }

    public long getDiversionProjectId() {
        return this._diversionProjectId;
    }

    public void setDiversionProjectId(long l) {
        this._diversionProjectId = l;
    }

    @Override
    public void setupForSerialization() {
        super.setupForSerialization();
        if (this._seepageValues == null) {
            return;
        }
        Object object = new DSSPathname();
        Object object2 = new RSimDssPathPartGenerator();
        Object object3 = this.getTopParent().getName();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add((String)object3);
        object3 = object2.generatePathnamePart(arrayList, "");
        object.setAPart((String)object3);
        arrayList.clear();
        arrayList.add("Seepage");
        object3 = this.getSystem();
        object2 = object3 != null ? ((RssSystem)object3).generateUniquePathPart(arrayList, "-") : object2.generatePathnamePart(arrayList, "-");
        object.setBPart((String)object2);
        object2 = Parameter.getParamString((int)Parameter.PARAMID_FLOW) + "-" + Parameter.getParamString((int)Parameter.PARAMID_FLOW);
        object.setCPart((String)object2);
        object2 = this.getSystem().getDssPairedDataFilePath();
        object = object.getPathname();
        this._seepageValues.setDssIdentifer(new DSSIdentifier((String)object2, (String)object));
        this._seepageValues.setParamXId(Parameter.PARAMID_FLOW);
        this._seepageValues.setParamYId(Parameter.PARAMID_FLOW);
        this._seepageValues.setUnitSystem(this.getUnitSystem());
    }

    public Controller getController() {
        ControlStructure controlStructure = this.getControlElement();
        if (controlStructure instanceof AdjustableDiversion) {
            return ((AdjustableDiversion)controlStructure).getController();
        }
        return null;
    }

    @Override
    public synchronized Object clone() {
        DiversionElement diversionElement = (DiversionElement)super.clone();
        if (this._seepageValues != null) {
            diversionElement._seepageValues = (PairedValues)this._seepageValues.clone();
        }
        return diversionElement;
    }

    @Override
    public void setActive(boolean bl) {
        Enumeration<Element> enumeration = this._elemVector.elements();
        while (enumeration.hasMoreElements()) {
            Element element = enumeration.nextElement();
            element.setActive(bl);
        }
        super.setActive(bl);
    }

    @Override
    public void removeNode(RssNode rssNode) {
        if (rssNode == ((Element)this).getDownstreamNode() && this.hasReach()) {
            Element element = this._elemVector.elementAt(1);
            element.dispose();
            this._elemVector.removeElementAt(1);
        }
        super.removeNode(rssNode);
    }

    public String getControllerName() {
        return this.getName() + ";" + this._elemVector.elementAt(0).getName();
    }

    public ControlStructure getControlElement() {
        return (ControlStructure)this._elemVector.elementAt(0).getFunction();
    }

    public boolean hasReach() {
        return this._elemVector.size() > 1;
    }

    public Element getReachElement() {
        if (!this.hasReach()) {
            return null;
        }
        return this._elemVector.elementAt(1);
    }

    @Override
    public int computeHindcastStep(RunTimeStep runTimeStep) {
        int n = this._elemVector.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            Element element = this._elemVector.elementAt(i);
            if (element == null || !element.isActive() || (n2 = element.computeHindcastStep(runTimeStep)) == 0) continue;
            return n2;
        }
        return 0;
    }

    @Override
    public int computeForecastStep(RunTimeStep runTimeStep) {
        int n = this._elemVector.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            Element element = this._elemVector.elementAt(i);
            if (element == null || !element.isActive() || (n2 = element.computeForecastStep(runTimeStep)) == 0) continue;
            return n2;
        }
        return 0;
    }

    @Override
    public int computeHindcast(RunTimeWindow runTimeWindow, int n) {
        for (int i = 0; i < this._elemVector.size(); ++i) {
            Element element = this._elemVector.elementAt(i);
            if (element == null || element.computeHindcast(runTimeWindow, n) == 0) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public int computeForecast(RunTimeWindow runTimeWindow, int n) {
        if (n == 1) {
            RunTimeWindow runTimeWindow2 = runTimeWindow;
            RunTimeStep runTimeStep = runTimeWindow2.getRunTimeStepAtTime(runTimeWindow2.getStartTime());
            int n2 = runTimeStep.getStep();
            while (n2 <= runTimeStep.getTotalNumSteps()) {
                runTimeStep.step = n2++;
                this.updateDecisions(runTimeStep, 0);
            }
        }
        for (int i = 0; i < this._elemVector.size(); ++i) {
            Element element = this._elemVector.elementAt(i);
            if (element == null || element.computeForecast(runTimeWindow, n) == 0) continue;
            return 1;
        }
        return 0;
    }

    public Element getSourceElement() {
        RssNode rssNode = ((Element)this).getUpstreamNode();
        if (rssNode == null) {
            return null;
        }
        return rssNode.getDownstreamElement();
    }

    @Override
    public Vector getRequiredTSRecordProxies() {
        Vector<Object> vector = new Vector<Object>();
        TSLocation tSLocation = this.getSourceElement();
        if (tSLocation == null) {
            return vector;
        }
        Object object = tSLocation.getNodeVector();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            TSRecordProxy tSRecordProxy;
            Element element;
            int n;
            RssNode rssNode = (RssNode)((Vector)object).elementAt(i);
            if (rssNode == null || (n = tSLocation.getNodeDir(i)) == 0 || (element = rssNode.getUpstreamElement()) != null && element.getFunction() instanceof AdjustableDiversion && element.getParent() != null && element.getParent().getIndex() >= this.getIndex() || rssNode.getTSRecordProxy(4) != null || (tSRecordProxy = rssNode.getTSRecordProxy(0)) == null || tSRecordProxy.isInput()) continue;
            vector.addElement(tSRecordProxy);
        }
        Vector vector2 = this.getController().getRuleVector();
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            Vector vector3;
            tSLocation = (Rule)vector2.elementAt(i);
            if (tSLocation == null) continue;
            if (tSLocation instanceof FlowFunction) {
                tSLocation = this._system.getNode(((FlowFunction)tSLocation)._flowLocationIndex);
                if (tSLocation == null) continue;
                object = tSLocation.getUpstreamElement();
                vector3 = this._system.getDownstreamElements(this, false);
                if (vector3.contains(object) || (tSLocation = tSLocation.getTSRecordProxy(0)) == null || tSLocation.isInput()) continue;
                vector.addElement(tSLocation);
                continue;
            }
            if (!(tSLocation instanceof PoolElevation) || (tSLocation = this._system.findReservoir(((PoolElevation)tSLocation).getReservoirName())) == null || (vector3 = this._system.getDownstreamElements(this, false)).contains(tSLocation) || (object = tSLocation.getStorageFunction().getTSRecordProxy(10)) == null || object.isInput()) continue;
            vector.addElement(object);
        }
        return vector;
    }

    @Override
    public double calcSeepageFlow(double d) {
        double d2 = 0.0;
        if (this._seepageType == 0) {
            d2 = this._constSeepage;
        } else if (this._seepageType == 2) {
            d2 = d * (1.0 - this._returnRatio);
        } else if (this._seepageType == 1) {
            d2 = this._seepageValues.interpolateValue(d);
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        return d2;
    }

    public double getConstSeepage() {
        return this._constSeepage;
    }

    public void setConstSeepage(double d) {
        this._constSeepage = d;
    }

    public void getConstSeepage(ParamDouble paramDouble) {
        paramDouble.setValue(this._constSeepage);
        paramDouble.setParameterId(Parameter.PARAMID_FLOW);
        paramDouble.setUnitSystem(this.getUnitSystem());
    }

    public void setConstSeepage(ParamDouble paramDouble) {
        this._constSeepage = paramDouble.getValue();
    }

    public double getReturnRatio() {
        return this._returnRatio;
    }

    public void setReturnRatio(double d) {
        this._returnRatio = d;
    }

    public PairedValues getSeepageValues() {
        if (this._seepageValues == null) {
            this._seepageValues = new PairedValues();
        }
        this._seepageValues.setUnitSystem(this.getUnitSystem());
        this._seepageValues.setParamXId(Parameter.PARAMID_FLOW);
        this._seepageValues.setParamYId(Parameter.PARAMID_FLOW);
        return this._seepageValues;
    }

    public void setSeepageValues(PairedValues pairedValues) {
        this._seepageValues = pairedValues;
    }

    public int getSeepageType() {
        return this._seepageType;
    }

    public boolean setSeepageType(int n) {
        if (n < 0 || n > 2) {
            return false;
        }
        this._seepageType = n;
        return true;
    }

    public WorldLine getLine() {
        return this._line;
    }

    @Override
    public WorldPt getReferencePt() {
        return this._referencePt;
    }

    public void setReferencePt(WorldPt worldPt) {
        this._referencePt = worldPt;
    }

    public void setLine(WorldLine worldLine) {
        if (worldLine == null) {
            return;
        }
        this._line = worldLine;
        this._referencePt = (WorldPt)this._line.pts.elementAt(0);
    }

    @Override
    public RssNode getUpstreamNode() {
        if (this._nodeVector.size() <= 0) {
            return null;
        }
        return this._nodeVector.elementAt(0);
    }

    @Override
    public RssNode getDownstreamNode() {
        if (this._nodeVector.size() < 2) {
            return null;
        }
        return this._nodeVector.elementAt(1);
    }

    public RssNode getDiversionNode() {
        if (this._elemVector.size() <= 0) {
            return null;
        }
        Element element = this._elemVector.elementAt(0);
        if (element == null) {
            return null;
        }
        return element.getNode(0);
    }

    void createDefaultElements(RssSystem rssSystem) {
        this.removeAllChildElements();
        Element element = this._system.newElement(false);
        element.setName(CONTROL_STR);
        Element element2 = element;
        element2.setFunction(FunctionFactory.a(element2, "AdjustableDiversion"));
        this.addChildElement(element);
        this._cntrlNode = this._system.newNode();
        this._cntrlNode.setName(element.getName());
        element.addNode(this._cntrlNode, 0, false);
        this.updateOperations(rssSystem);
    }

    @Deprecated
    public void setFlowHindcastCondition(int n) {
        RssNode rssNode = this._elemVector.elementAt(0).getNode(0);
        String string = rssNode.getName() + KNOWN_DIVERSION;
        switch (n) {
            case 1: {
                if (rssNode == null || rssNode.getTSRecordProxy("FLOW", true) != null) break;
                rssNode.addTSRecord(string, "FLOW", true);
                return;
            }
            case 0: {
                if (rssNode == null || rssNode.getTSRecordProxy("FLOW", true) == null) break;
                rssNode.removeTSRecord(string, "FLOW", true);
                return;
            }
            default: {
                System.out.println("DiversionElement.setFlowHindcastCondition: unknown hindcast condition " + n);
            }
        }
    }

    @Override
    public void addNode(RssNode rssNode, int n) {
        if (n == 1) {
            super.addNode(rssNode, 0, true);
            Element element = this._elemVector.elementAt(0);
            rssNode.setName(this.getName());
            element.addNode(rssNode, 0, false);
            return;
        }
        super.addNode(rssNode, 0, false);
        TimeStepRoutingElement timeStepRoutingElement = this._system.newTimeStepRoutingElement(false);
        timeStepRoutingElement.setName(this.getName() + " Rch");
        Function function = FunctionFactory.a(timeStepRoutingElement, "NullRouting");
        timeStepRoutingElement.putFunction(TimeStepUtil.TIME_STEP_ALL.getDuration(), function);
        this.addChildElementAt(timeStepRoutingElement, 1);
        timeStepRoutingElement.addNode(this._cntrlNode, 1);
        rssNode.setName(timeStepRoutingElement.getName());
        timeStepRoutingElement.addNode(rssNode, n, true);
    }

    public void convertRoutingElement() {
        Element element;
        if (this.hasReach() && !((element = this.getReachElement()) instanceof TimeStepRoutingElement)) {
            TimeStepRoutingElement timeStepRoutingElement = this._system != null ? this._system.newTimeStepRoutingElement(false) : new TimeStepRoutingElement();
            timeStepRoutingElement.setName(element.getName());
            timeStepRoutingElement.putFunction(TimeStepUtil.TIME_STEP_ALL.getDuration(), element.getFunction());
            int n = element.getNodeCount();
            for (int i = 0; i < n; ++i) {
                timeStepRoutingElement.addNode(element.getNode(i), element.getNodeDir(i));
            }
            this.addChildElementAt(timeStepRoutingElement, 1);
        }
    }

    public Color getLineColor() {
        return Color.black;
    }

    public int getInflowType() {
        return this._inFlowType;
    }

    public void setInflowType(int n) {
        this._inFlowType = n;
    }

    public boolean getComputeDuringUnReg() {
        return this._computeDuringUnReg;
    }

    public void setComputeDuringUnReg(boolean bl) {
        this._computeDuringUnReg = bl;
    }

    @Override
    public Vector getModelVariables(Vector vector) {
        if (vector == null) {
            vector = new Vector<ModelVariable>();
        }
        vector.add(RssModelVariableSet.getModelVariable(120));
        if (this.getReachElement() != null) {
            vector.add(RssModelVariableSet.getModelVariable(121));
        }
        return vector;
    }

    @Override
    public Vector getDefaultModelVariables() {
        Vector<ModelVariable> vector = new Vector<ModelVariable>();
        vector.add(RssModelVariableSet.getModelVariable(120));
        vector.add(RssModelVariableSet.getModelVariable(121));
        return vector;
    }

    @Override
    public Vector getTSRecords(ModelVariable object, Vector vector) {
        if (vector == null) {
            vector = new Vector<ModelVariable>();
        }
        if (object == null) {
            return vector;
        }
        switch (object.getType()) {
            case 120: {
                object = this._nodeVector.elementAt(0);
                object = object.getTSRecordProxy(0);
                if (object == null) break;
                vector.addElement((ModelVariable)object);
                break;
            }
            case 121: {
                if (this.getReachElement() == null) break;
                object = this._nodeVector.elementAt(1);
                if ((object = object.getTSRecordProxy(0)) == null) break;
                vector.addElement((ModelVariable)object);
                break;
            }
            case 47: {
                if (this._cntrlNode == null || this._cntrlNode.getUpstreamElement() == null || this._cntrlNode.getUpstreamElement().getFunction() == null || (object = this._cntrlNode.getUpstreamElement().getFunction().getTSRecordProxy(47)) == null) break;
                vector.addElement((ModelVariable)object);
            }
        }
        return vector;
    }

    public boolean importFrom(RuleResolution object) {
        if (!(((ElementAssignmentContainer)object).b instanceof DiversionElement)) {
            System.out.println("importFrom: can't import a DiversionElement from a " + String.valueOf(((ElementAssignmentContainer)object).b));
            return false;
        }
        DiversionElement diversionElement = this;
        object = (DiversionElement)((ElementAssignmentContainer)object).b;
        diversionElement.setDescription(object.getDescription());
        diversionElement.setComputeDuringUnReg(((DiversionElement)object).getComputeDuringUnReg());
        ((DiversionElement)object).getDiversionOps().getController();
        diversionElement.getDiversionOps().getController();
        ((DiversionElement)object).getDiversionOps().getRules();
        if (diversionElement.hasReach() && ((DiversionElement)object).hasReach()) {
            diversionElement.setSeepageType(((DiversionElement)object).getSeepageType());
            diversionElement.setSeepageValues((PairedValues)((DiversionElement)object).getSeepageValues().clone());
            diversionElement.setConstSeepage(((DiversionElement)object).getConstSeepage());
            diversionElement.setReturnRatio(((DiversionElement)object).getReturnRatio());
            NamedType namedType = ((DiversionElement)object).getReachElement();
            Element element = diversionElement.getReachElement();
            if (namedType != null && element != null && (namedType = namedType.getFunction()) != null) {
                element.setFunction((Function)namedType.clone());
            }
        }
        this.importObservedData((Element)object, null);
        diversionElement.setModified(true);
        diversionElement.getSystem().setModified(true);
        return true;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        org.jdom.Element element2;
        element.setAttribute("Name", this.getDisplayName());
        element.setAttribute("Description", this.getDescription());
        org.jdom.Element element3 = new org.jdom.Element("Release");
        element.addContent((Content)element3);
        this.getController().getDiversionFunction();
        Object object = null;
        if (!this.getController().getRuleVector().isEmpty()) {
            object = (Rule)this.getController().getRuleVector().get(0);
        }
        element3.setAttribute("ComputeDuringUnReg", Boolean.toString(this._computeDuringUnReg));
        if (object instanceof ConstantRelease) {
            element3.setAttribute("Type", "Constant");
            element3.setAttribute("Constant", Double.toString(((ConstantRelease)object)._defaultRelease));
        } else if (object instanceof MonthlyRelease) {
            element3.setAttribute("Type", "Monthly");
            element2 = new org.jdom.Element("Diversion");
            element3.addContent((Content)element2);
            XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])((MonthlyRelease)object)._monthlyRelease);
        } else if (object instanceof SpecifiedRelease) {
            element3.setAttribute("Type", "Seasonal");
            element3.setAttribute("Values", ((SpecifiedRelease)object).getReleaseValues());
        } else if (object instanceof FlowFunction) {
            element3.setAttribute("Type", "FunctionOfFlow");
            element3.setAttribute("FlowLocation", ((FlowFunction)object)._flowLocation);
            element2 = new org.jdom.Element("Flows");
            org.jdom.Element element4 = element3;
            element4.addContent((Content)element4);
            XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])((FlowFunction)object)._flowValues.getXArray());
            element2 = new org.jdom.Element("Diversions");
            org.jdom.Element element5 = element3;
            element5.addContent((Content)element5);
            XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])((FlowFunction)object)._flowValues.getYArray());
        } else if (object instanceof PoolElevation) {
            element3.setAttribute("Type", "FunctionOfFlow");
            element3.setAttribute("Reservoir", ((PoolElevation)object)._resName);
            element2 = new org.jdom.Element("Elevations");
            org.jdom.Element element6 = element3;
            element6.addContent((Content)element6);
            XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])((PoolElevation)object)._poolValues.getXArray());
            element2 = new org.jdom.Element("Diversions");
            org.jdom.Element element7 = element3;
            element7.addContent((Content)element7);
            XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])((PoolElevation)object)._poolValues.getYArray());
        } else if (object instanceof DiversionRule) {
            element3.setAttribute("Type", "DiversionRule");
            element2 = new org.jdom.Element("IndependentVariable");
            element3.addContent((Content)element2);
            object = (DiversionRule)object;
            ((DiversionRule)object).getIndependentVariable().outputReport(alternativeInputReport, element2);
            if (((DiversionRule)object).getIndependentVariable().getType() == 1 || ((DiversionRule)object).getIndependentVariable().getType() == 0) {
                var6_6 = ((DiversionRule)object).getSeasonalRecord();
                element3.setAttribute("VarType", "Date");
                element2 = new org.jdom.Element("Dates");
                element3.addContent((Content)element2);
                XMLUtilities.createArrayElements((org.jdom.Element)element2, (int[])var6_6.getTimeArray());
                element2 = new org.jdom.Element("Data");
                element3.addContent((Content)element2);
                XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])var6_6.getDataArray());
            } else if (((DiversionRule)object).getIndependentVariable().getType() == 2 || ((DiversionRule)object).getIndependentVariable().getType() == 4 || ((DiversionRule)object).getIndependentVariable().getType() == 6) {
                if (((DiversionRule)object).hasSeasonalVariation()) {
                    var6_6 = ((DiversionRule)object).getSeasonalFlowValues();
                    element3.setAttribute("InterpType", Integer.toString(var6_6.getInterpolationType()));
                    element3.setAttribute("VarType", "SeasonalInput");
                    element2 = new org.jdom.Element("Param");
                    element3.addContent((Content)element2);
                    XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])var6_6.getXArray());
                    for (int i = 0; i < var6_6.getNumberCurves(); ++i) {
                        element2 = new org.jdom.Element("Release" + Integer.toString(i));
                        element3.addContent((Content)element2);
                        XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])var6_6.getCurve(i).getYArray());
                    }
                } else {
                    element3.setAttribute("InterpType", Integer.toString(((DiversionRule)object)._flowValues.getInterpolationType()));
                    element3.setAttribute("VarType", "Input");
                    element2 = new org.jdom.Element("Param");
                    element3.addContent((Content)element2);
                    XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])((DiversionRule)object)._flowValues.getXArray());
                    element2 = new org.jdom.Element("Releases");
                    element3.addContent((Content)element2);
                    XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])((DiversionRule)object)._flowValues.getYArray());
                }
            } else if (((DiversionRule)object).getIndependentVariable().getType() == 3) {
                element3.setAttribute("VarType", "TimeSeries");
            }
            if (((Rule)object)._useTimeOfDayMultiplier) {
                element2 = new org.jdom.Element("TimeOfDayMultiplier");
                element3.addContent((Content)element2);
                ((Rule)object)._timeOfDayMultiplier.outputReport(alternativeInputReport, element2);
            }
            if (((Rule)object)._useDayOfWeekMultiplier) {
                element2 = new org.jdom.Element("DayOfWeekMultiplier");
                element3.addContent((Content)element2);
                ((Rule)object)._multiplier.outputReport(alternativeInputReport, element2);
            }
        } else {
            element3.setAttribute("Type", "TimeSeries");
        }
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.DIVERSIONS_ROUTING).a() && this.hasReach()) {
            element3 = new org.jdom.Element("Routing");
            element.addContent((Content)element3);
            this.getReachElement().getFunction();
            if (this._function instanceof NullRouting) {
                element3.setAttribute("Type", "NullRouting");
            } else if (this._function instanceof CoefRouting) {
                element3.setAttribute("Type", "Coef");
                ((Routing)((CoefRouting)this._function)).outputReport(alternativeInputReport, element3);
            } else if (this._function instanceof MuskingumRouting) {
                element3.setAttribute("Type", "MuskingumRouting");
                ((Routing)((MuskingumRouting)this._function)).outputReport(alternativeInputReport, element3);
            } else if (this._function instanceof MuskingumCungeRouting) {
                ((Routing)((MuskingumCungeRouting)this._function)).outputReport(alternativeInputReport, element3);
            } else if (this._function instanceof PulsChannelRoutingWithLosses) {
                element3.setAttribute("Type", "ModifiedPulse");
                ((Routing)((PulsChannelRoutingWithLosses)this._function)).outputReport(alternativeInputReport, element3);
            } else if (this._function instanceof SsarrRouting) {
                element3.setAttribute("Type", "SsarrRouting");
                ((Routing)((SsarrRouting)this._function)).outputReport(alternativeInputReport, element3);
            } else if (this._function instanceof WorkingRDRouting) {
                element3.setAttribute("Type", "WorkingRDRouting");
                ((Routing)((WorkingRDRouting)this._function)).outputReport(alternativeInputReport, element3);
            } else if (this._function instanceof LagAndKRouting) {
                element3.setAttribute("Type", "VariableLagKRouting");
                ((Routing)((LagAndKRouting)this._function)).outputReport(alternativeInputReport, element3);
            }
        }
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.REACH_LOSSES).a()) {
            element3 = new org.jdom.Element("Losses");
            element.addContent((Content)element3);
            if (this._seepageType == 0) {
                element3.setAttribute("ConstantSeepage", Double.toString(this._constSeepage));
            } else {
                element2 = new org.jdom.Element("Flows");
                element3.addContent((Content)element2);
                XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._seepageValues.getXArray());
                element2 = new org.jdom.Element("Seepages");
                element3.addContent((Content)element2);
                XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._seepageValues.getYArray());
            }
        }
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.DIVERSIONS_OBSERVED).a() && this._obsDataVector != null && !this._obsDataVector.isEmpty()) {
            element3 = new org.jdom.Element("ObservedData");
            element.addContent((Content)element3);
            for (int i = 0; i < this._obsDataVector.size(); ++i) {
                object = (String)this._obsDataVector.get(i);
                element3.setAttribute("NameParamID", (String)object);
            }
        }
    }

    public void updateOperations(RssSystem rssSystem) {
        this._system = rssSystem;
        if (this._divOps == null) {
            this.createDefaultDiversionOp();
        }
        if (this._divOps.getOpSetTable().size() == 0) {
            NamedType namedType = this._divOps.addNewOpSet("Default");
            namedType.setDescription("OpSet created by the System");
            StorageZone storageZone = this._divOps.createDefaultZone((OpSet)namedType);
            RssTSLocationObject rssTSLocationObject = this._divOps.getController();
            this._divOps.setActiveOpSet(namedType.getIndex());
            namedType = this.getController();
            Object object = namedType.getRuleVector();
            object = ((Vector)object).size() > 0 ? (Rule)((Vector)object).get(0) : new ConstantRelease((OpController)rssTSLocationObject);
            rssTSLocationObject = (DiversionDemandOpRule)((OpController)rssTSLocationObject).newRule("Flow Function", "Demand Rule", -1);
            ((DiversionDemandOpRule)rssTSLocationObject).setRule((Rule)object);
            ((OpRule)rssTSLocationObject).setSystem(rssSystem);
            storageZone.addRule((OpRule)rssTSLocationObject);
            namedType.removeAllRules();
        }
    }

    @Override
    public Storage getStorageFunction() {
        return null;
    }

    @Override
    public VerticalDatumSettings getVerticalDatumSettings() {
        return this._verticalDatumSettings;
    }

    public void setVeriticalDatumSettings(VerticalDatumSettings verticalDatumSettings) {
        this._verticalDatumSettings = verticalDatumSettings;
    }

    @Override
    public PairedValuesExt getCompositeRelease() {
        return null;
    }

    public DiversionOp getDiversionOps() {
        return (DiversionOp)this.getElementOp(true);
    }

    @Override
    public ElementOp getElementOp() {
        return this.getElementOp(true);
    }

    @Override
    public ElementOp getElementOp(boolean bl) {
        RssAlt rssAlt;
        if (this._divOps == null) {
            this.createDefaultDiversionOp();
        }
        if (this._divOps.getDiversionElement() == null) {
            this._divOps.setDiversionElement(this);
        }
        if (bl && (rssAlt = this._system.getAlternative()) != null) {
            int n = rssAlt.getDivOpSetSelection(this.getIndex(), false);
            if (n == Integer.MIN_VALUE) {
                this._divOps.setDefaultOpSetActive();
            } else {
                this._divOps.setActiveOpSet(n);
            }
        }
        return this._divOps;
    }

    @Override
    public Vector getActiveTSProxies(Vector vector, int n) {
        vector = super.getActiveTSProxies(vector, n);
        if (this._divOps == null) {
            return vector;
        }
        this._divOps.getActiveTSRecordProxies(vector, n);
        return vector;
    }

    @Override
    public void updateTSProxyList() {
        super.updateTSProxyList();
        this.getDiversionOps();
        if (this._divOps != null) {
            this._divOps.updateTSProxyList();
        }
    }

    public void getRules(int n, List list) {
        if (this._divOps == null) {
            return;
        }
        this._divOps.getRules(n, list);
    }

    public List<ConditionalBlockRef> getConditionalBlockRefs(int n, List<ConditionalBlockRef> list) {
        DiversionOp diversionOp = this.getDiversionOps();
        if (diversionOp == null) {
            return null;
        }
        OpSet opSet = diversionOp.getOperationSet(n);
        if (opSet == null) {
            return null;
        }
        if (list == null) {
            list = new ArrayList<ConditionalBlockRef>();
        }
        return opSet.getConditionals(list);
    }

    public String getFillColorName() {
        return this._fillColorName;
    }

    public void setFillColorName(String string) {
        this._fillColorName = string;
    }
}

