/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.heclib.util.intContainer;
import hec.io.AsciiSerializable;
import hec.lang.NamedType;
import hec.model.Conditional;
import hec.model.ConditionalBlock;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.rss.model.ConditionalBlockRef;
import hec.rss.model.DiversionElement;
import hec.rss.model.DownstreamCntrlOpRule;
import hec.rss.model.DownstreamOpRule;
import hec.rss.model.Element;
import hec.rss.model.ElementOp;
import hec.rss.model.OpController;
import hec.rss.model.OpRule;
import hec.rss.model.OpRuleRef;
import hec.rss.model.OpSet;
import hec.rss.model.OpValue;
import hec.rss.model.OperationsElement;
import hec.rss.model.RssAlt;
import hec.rss.model.RssConditionalBlock;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.StorageZone;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import rma.util.RMASort;

public class DiversionOp
extends NamedType
implements AsciiSerializable,
ElementOp {
    DiversionElement _diversion;
    OpController _controller = new OpController("Reservoir", 0);
    Hashtable<intContainer, OpSet> _opSetTable = new Hashtable();
    List<ConditionalBlock> _conditionalBlockList = new ArrayList<ConditionalBlock>();
    int _nextConditionalBlockIndex = 100000;
    int _nextControllerIndex = 1;
    int _nextOpSetIndex = 0;
    private transient intContainer a = new intContainer();
    private transient OpSet b;
    private transient int c = 1;
    private transient List d;

    public void updateDecisions(RunTimeStep runTimeStep, int n) {
        this.c = this.b.getNumDecisionSteps(runTimeStep);
        StorageZone storageZone = this.b.getTopZone();
        this.evalControllerDecision(runTimeStep, storageZone, n);
        OpValue opValue = this._controller.getCurMinOpValue(runTimeStep);
        this._controller.distributeRelease(runTimeStep, opValue);
        this._controller.commitOperation(runTimeStep, this.c);
    }

    void evalControllerDecision(RunTimeStep runTimeStep, StorageZone object, int n) {
        this._controller.initOperationStep(runTimeStep, n);
        this._controller.applyPhysicalLimits(runTimeStep, true);
        this._controller.applyReleaseOverrides(runTimeStep);
        if (object != null) {
            object = ((StorageZone)object).getActiveRules(runTimeStep, null);
            int n2 = object.size();
            for (int i = 0; i < n2; ++i) {
                OpRule opRule = (OpRule)object.get(i);
                opRule.evaluateLimits(runTimeStep, n);
                this._controller.applyRuleLimits2(runTimeStep, opRule, n);
            }
        }
    }

    public boolean initializeCompute(RunTimeWindow runTimeWindow) {
        if (this.b == null) {
            this.getActiveOpSet();
            if (this.b == null) {
                if (this._diversion != null) {
                    this._diversion.getSystem().printErrorMessage("No Active Operations Set selected for Diversion " + this._diversion.getName() + ". Default Operations Set not found.");
                }
                return false;
            }
        }
        if (!this.b.initializeCompute(runTimeWindow)) {
            return false;
        }
        ArrayList arrayList = new ArrayList();
        Object object = this.b.getZoneVector();
        for (int i = 0; object != null && i < object.size(); ++i) {
            StorageZone storageZone = (StorageZone)object.get(i);
            List list = storageZone.getConditionalBlockRefs(null);
            arrayList.addAll(list);
        }
        if (arrayList.size() > 0) {
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                object = (ConditionalBlockRef)arrayList.get(i);
                if ((object = ((ConditionalBlockRef)object).getConditionalBlock()) == null || hashMap.get(object) != null) continue;
                Object object2 = object;
                hashMap.put(object2, object2);
                object.setParent((Object)this);
                if (object.initializeCompute(runTimeWindow)) continue;
                return false;
            }
        }
        this.d = this.b.getRules(null);
        return this._controller.initializeCompute(runTimeWindow);
    }

    public boolean doesOpSetExist(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        Object object = this._opSetTable.values();
        object = object.iterator();
        while (object.hasNext()) {
            OpSet opSet = (OpSet)object.next();
            if (!opSet.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public OpSet addNewOpSet(String object) {
        object = new OpSet(this, (String)object);
        this.createDefaultZone((OpSet)object);
        int n = this.nextOpSetIndex();
        object.setIndex(n);
        this._opSetTable.put(new intContainer(n), (OpSet)object);
        this.setModified(true);
        return object;
    }

    StorageZone createDefaultZone(OpSet opSet) {
        Vector vector = opSet.getZoneVector();
        StorageZone storageZone = null;
        if (vector != null) {
            int n;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(vector.size());
            for (n = 0; n < vector.size(); ++n) {
                StorageZone storageZone2 = (StorageZone)vector.get(n);
                if ("Default".equals(storageZone2.getName())) {
                    storageZone = storageZone2;
                    continue;
                }
                arrayList.add(storageZone2.getIndex());
            }
            for (n = 0; n < arrayList.size(); ++n) {
                opSet.deleteZone((Integer)arrayList.get(n));
            }
        }
        if (storageZone == null) {
            storageZone = opSet.addNewStorageZone("Default");
            storageZone.setDescription("Only Zone for Diversion");
        }
        return storageZone;
    }

    public void removeOpSet(int n) {
        this._opSetTable.remove(new intContainer(n));
        this.setModified(true);
    }

    public void removeOpSet(OpSet opSet) {
        if (opSet == null) {
            return;
        }
        this._opSetTable.remove(new intContainer(opSet.getIndex()));
        this.setModified(true);
    }

    private int nextOpSetIndex() {
        int n = this._nextOpSetIndex++;
        return n;
    }

    public void setActiveOpSet(int n) {
        if (this.a == null) {
            this.a = new intContainer();
        }
        this.a.value = n;
        this.b = this._opSetTable.get(this.a);
        this._controller.setActiveOperations(this.b);
    }

    public void setDefaultOpSetActive() {
        RssReturnStatusConstants rssReturnStatusConstants = this.getOperationSet("Default");
        int n = Integer.MIN_VALUE;
        if (rssReturnStatusConstants != null) {
            n = rssReturnStatusConstants.getIndex();
            rssReturnStatusConstants = this._diversion.getSystem();
            if (rssReturnStatusConstants != null) {
                RssAlt rssAlt = ((RssSystem)rssReturnStatusConstants).getAlternative();
                if (rssAlt != null) {
                    rssAlt.addDivOpSetSelection(this.getIndex(), n);
                }
                rssReturnStatusConstants.printMessage("No Operation set selected in Alternative for Diversion " + this.getName() + ". Computing with the Default operations set.");
            }
        }
        this.setActiveOpSet(n);
    }

    @Override
    public OpSet getActiveOpSet() {
        if (this.b == null) {
            this.setDefaultOpSetActive();
        }
        return this.b;
    }

    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public Vector<OpController> getControllers() {
        Vector<OpController> vector = new Vector<OpController>();
        vector.add(this._controller);
        this._controller.getChildControllers(vector);
        return vector;
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public OpController getController() {
        if (this._controller.getReleaseElement() == null) {
            Element element = this._diversion.getChildElementAt(0);
            this._controller.setReleaseElement(element);
        }
        return this._controller;
    }

    public DiversionElement getDiversionElement() {
        return this._diversion;
    }

    @Override
    public OperationsElement getOperationsElement() {
        return this._diversion;
    }

    @Override
    public int getUnitSystem() {
        return this._diversion._system.getUnitSystem();
    }

    public void setDiversionElement(DiversionElement element) {
        this._diversion = element;
        this._controller.setElementOp(this);
        this._controller.setName(this._diversion.getName());
        element = element.getChildElementAt(0);
        this._controller.setReleaseElement(element);
        this._controller.updateControllerTree(this._diversion);
    }

    @Override
    public int getGmtOffset() {
        return this._diversion._system.getGmtOffset();
    }

    @Override
    public OpSet getOperationSet(int n) {
        return this._opSetTable.get(new intContainer(n));
    }

    @Override
    public OpSet getOperationSet(String string) {
        if (string == null) {
            return null;
        }
        Enumeration<OpSet> enumeration = this._opSetTable.elements();
        while (enumeration.hasMoreElements()) {
            OpSet opSet = enumeration.nextElement();
            if (!string.equalsIgnoreCase(opSet.getName())) continue;
            return opSet;
        }
        return null;
    }

    @Override
    public Vector<OpSet> getOperationSets() {
        Vector<OpSet> vector = new Vector<OpSet>();
        Enumeration<OpSet> enumeration = this._opSetTable.elements();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        RMASort.quickSort(vector);
        return vector;
    }

    @Override
    public OpController getController(int n) {
        Vector<OpController> vector = new Vector<OpController>();
        vector.add(this._controller);
        this._controller.getChildControllers(vector);
        for (int i = 0; i < vector.size(); ++i) {
            OpController opController = (OpController)vector.get(i);
            if (opController.getIndex() != n) continue;
            return opController;
        }
        return null;
    }

    @Override
    public OpController newController() {
        OpController opController = new OpController();
        opController.setIndex(this.nextControllerIndex());
        return opController;
    }

    private int nextControllerIndex() {
        int n = this._nextControllerIndex++;
        return n;
    }

    @Override
    public void deleteControllerReferences(int n) {
        Enumeration<OpSet> enumeration = this._opSetTable.elements();
        while (enumeration.hasMoreElements()) {
            OpSet opSet = enumeration.nextElement();
            opSet.deleteControllerReferences(n);
        }
    }

    @Override
    public void printErrorMessage(String string) {
        if (this._diversion != null) {
            this._diversion.getSystem().printErrorMessage(string);
            return;
        }
        System.out.println(string);
    }

    @Override
    public void printMessage(String string) {
        if (this._diversion != null) {
            this._diversion.getSystem().printMessage(string);
            return;
        }
        System.out.println(string);
    }

    @Override
    public String getControllerRuleNameByID(int n) {
        if (n == Integer.MIN_VALUE) {
            return "";
        }
        if (n >= 0) {
            int n2 = n >>> 16;
            int n3 = n & 0xFFFF;
            OpController opController = this.getController(n2);
            OpRule opRule = opController != null ? opController.getRule(n3) : this._controller.getRule(n);
            if (opRule != null) {
                return opRule.getName();
            }
            return "";
        }
        if (-n < OpController.OBJECTIVE_NAME.length) {
            return OpController.OBJECTIVE_NAME[-n];
        }
        return "";
    }

    @Override
    public String getControllerConstraintNameByID(int n) {
        if (n == Integer.MIN_VALUE) {
            return "";
        }
        if (n >= 0) {
            int n2 = n >>> 16;
            n &= 0xFFFF;
            OpController opController = this.getController(n2);
            OpRule opRule = null;
            if (opController != null) {
                opRule = opController.getRule(n);
            }
            if (opRule != null) {
                return opRule.getName();
            }
            return "";
        }
        if (-n < OpController.CNSTRNT_NAME.length) {
            return OpController.CNSTRNT_NAME[-n];
        }
        return "";
    }

    @Override
    public OpController getController(Element element) {
        Vector<OpController> vector = new Vector<OpController>();
        vector.add(this._controller);
        this._controller.getChildControllers(vector);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            OpController opController = (OpController)vector.elementAt(i);
            if (opController.getReleaseElement() != element) continue;
            return opController;
        }
        return null;
    }

    @Override
    public void determinePhysicalLimits(OpController opController, RunTimeStep runTimeStep) {
        this._controller.recalcPhysicalLimitsInst(runTimeStep, 0.0);
        this._controller.distributePhysicalLimits(runTimeStep);
    }

    @Override
    public Hashtable<intContainer, OpSet> getOpSetTable() {
        return this._opSetTable;
    }

    public String[] getOperationSetNames() {
        Object[] objectArray = new String[this._opSetTable.size()];
        Enumeration<OpSet> enumeration = this._opSetTable.elements();
        for (int i = 0; i < this._opSetTable.size(); ++i) {
            OpSet opSet = enumeration.nextElement();
            objectArray[i] = opSet.getName();
        }
        RMASort.quickSort((Object[])objectArray);
        return objectArray;
    }

    public OpSet addDuplicateOpSet(int n, String string) {
        if (string == null) {
            return null;
        }
        OpSet opSet = this._opSetTable.get(new intContainer(n));
        if (opSet == null) {
            return null;
        }
        opSet = (OpSet)((RssTSLocationObject)opSet).clone();
        opSet.setName(string);
        int n2 = this.nextOpSetIndex();
        opSet.setIndex(n2);
        this._opSetTable.put(new intContainer(n2), opSet);
        this.setModified(true);
        return opSet;
    }

    public ConditionalBlock getConditionalBlock(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this._conditionalBlockList.size(); ++i) {
            ConditionalBlock conditionalBlock = this._conditionalBlockList.get(i);
            if (conditionalBlock == null || !conditionalBlock.getName().equalsIgnoreCase(string)) continue;
            return conditionalBlock;
        }
        return null;
    }

    public ConditionalBlock createNewConditionalBlock(String object) {
        object = new RssConditionalBlock((String)object);
        object.setIndex(this.nextConditionalBlockIndex());
        this._conditionalBlockList.add((ConditionalBlock)object);
        object.setParent((Object)this);
        return object;
    }

    int nextConditionalBlockIndex() {
        return this._nextConditionalBlockIndex++;
    }

    public List<ConditionalBlock> getConditionalBlocks() {
        return this._conditionalBlockList;
    }

    public ConditionalBlock deleteConditionalBlock(ConditionalBlock conditionalBlock) {
        if (conditionalBlock == null) {
            return null;
        }
        return this.deleteConditionalBlock(conditionalBlock.getIndex());
    }

    public ConditionalBlock deleteConditionalBlock(int n) {
        for (int i = 0; i < this._conditionalBlockList.size(); ++i) {
            ConditionalBlock conditionalBlock = this._conditionalBlockList.get(i);
            if (conditionalBlock.getIndex() == n) {
                this._conditionalBlockList.remove(conditionalBlock);
                return conditionalBlock;
            }
            conditionalBlock.deleteConditionalBlock(n);
        }
        return null;
    }

    @Override
    public void deleteOpRule(OpRule opRule) {
        OpSet opSet;
        int n;
        Object object;
        ConditionalBlock conditionalBlock;
        int n2;
        if (opRule == null) {
            return;
        }
        if (!(opRule instanceof DownstreamOpRule) || opRule instanceof DownstreamCntrlOpRule) {
            n2 = opRule.getIndex();
            conditionalBlock = this.getOperationSets();
            if (conditionalBlock == null) {
                return;
            }
            object = opRule.getController();
            for (n = 0; n < conditionalBlock.size(); ++n) {
                opSet = (OpSet)conditionalBlock.elementAt(n);
                opSet.removeAllRuleRef(object.getIndex(), n2);
            }
            ((OpController)object).deleteRule(n2);
        }
        for (n2 = 0; n2 < this._conditionalBlockList.size(); ++n2) {
            conditionalBlock = this._conditionalBlockList.get(n2);
            object = conditionalBlock.getConditionals();
            for (n = 0; n < object.size(); ++n) {
                opSet = (Conditional)object.get(n);
                opSet.removeCondtionalObject(opRule);
            }
        }
        if (opRule instanceof DownstreamOpRule) {
            n2 = opRule.getIndex();
            if (opRule instanceof DownstreamCntrlOpRule) {
                n2 = ((DownstreamCntrlOpRule)opRule).getParentRuleIndex();
            }
            int n3 = ((DownstreamOpRule)opRule).getDownstreamControlLocationID();
            object = this.getDiversionElement().getSystem();
            ((RssSystem)object).deleteDownstreamOpRule(n3, n2);
        }
    }

    @Override
    public Vector<OpRule> getRules() {
        Vector<OpController> vector = this.getControllers();
        Vector<OpRule> vector2 = new Vector<OpRule>();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            OpController opController = (OpController)vector.get(i);
            opController.getRules(vector2);
        }
        return vector2;
    }

    public void getRules(int n, List<OpRule> list) {
        if (this.a == null) {
            this.a = new intContainer();
        }
        this.a.value = n;
        OpSet opSet = this._opSetTable.get(this.a);
        if (opSet != null) {
            opSet.getRules(list);
        }
    }

    @Override
    public boolean isRuleActive(OpRule opRule, RunTimeStep object) {
        if (this.b == null) {
            return false;
        }
        StorageZone storageZone = this.b.getActiveZone(0.0, (RunTimeStep)object);
        if (storageZone == null) {
            return false;
        }
        object = storageZone.getActiveRules((RunTimeStep)object, null);
        int n = object.size();
        for (int i = 0; i < n; ++i) {
            OpRuleRef opRuleRef = (OpRuleRef)object.get(i);
            if (opRuleRef.getRule() != opRule) continue;
            return true;
        }
        return false;
    }

    public synchronized DiversionOp clone() {
        try {
            OpSet opSet;
            DiversionOp diversionOp = (DiversionOp)super.clone();
            ((DiversionOp)super.clone())._diversion = this._diversion;
            diversionOp._controller = (OpController)((RssTSLocationObject)this._controller).clone();
            diversionOp._controller.setElementOp(diversionOp);
            diversionOp._opSetTable = new Hashtable();
            Enumeration<intContainer> enumeration = this._opSetTable.keys();
            while (enumeration.hasMoreElements()) {
                intContainer intContainer2 = enumeration.nextElement();
                opSet = this._opSetTable.get(intContainer2);
                opSet = (OpSet)((RssTSLocationObject)opSet).clone();
                opSet.setElementOp(diversionOp);
                diversionOp._opSetTable.put(intContainer2, opSet);
            }
            diversionOp._nextControllerIndex = this._nextControllerIndex;
            diversionOp._nextOpSetIndex = this._nextOpSetIndex;
            diversionOp.a = this.a;
            if (this.b != null) {
                diversionOp.setActiveOpSet(this.b.getIndex());
            }
            diversionOp._nextConditionalBlockIndex = this._nextConditionalBlockIndex;
            diversionOp._conditionalBlockList = new Vector<ConditionalBlock>(this._conditionalBlockList.size());
            for (int i = 0; i < this._conditionalBlockList.size(); ++i) {
                opSet = this._conditionalBlockList.get(i);
                opSet = opSet.clone();
                opSet.setParent(diversionOp);
                diversionOp._conditionalBlockList.add((ConditionalBlock)opSet);
            }
            return diversionOp;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void copyInto(DiversionOp diversionOp) {
        if (diversionOp != this) {
            OpSet opSet;
            this._controller = (OpController)((RssTSLocationObject)diversionOp._controller).clone();
            this._controller.setElementOp(this);
            this._opSetTable = new Hashtable();
            Enumeration<intContainer> enumeration = diversionOp._opSetTable.keys();
            while (enumeration.hasMoreElements()) {
                intContainer intContainer2 = enumeration.nextElement();
                opSet = diversionOp._opSetTable.get(intContainer2);
                opSet = (OpSet)((RssTSLocationObject)opSet).clone();
                opSet.setElementOp(this);
                this._opSetTable.put(intContainer2, opSet);
            }
            this._nextControllerIndex = diversionOp._nextControllerIndex;
            this._nextOpSetIndex = diversionOp._nextOpSetIndex;
            if (diversionOp.b != null) {
                this.setActiveOpSet(diversionOp.b.getIndex());
            }
            this._nextConditionalBlockIndex = diversionOp._nextConditionalBlockIndex;
            this._conditionalBlockList = new Vector<ConditionalBlock>(diversionOp._conditionalBlockList.size());
            for (int i = 0; i < diversionOp._conditionalBlockList.size(); ++i) {
                opSet = diversionOp._conditionalBlockList.get(i);
                opSet = opSet.clone();
                opSet.setParent(this);
                this._conditionalBlockList.add((ConditionalBlock)opSet);
            }
        }
        this.setModified(true);
    }

    @Override
    public ConditionalBlock getConditionalBlock(int n) {
        for (int i = 0; i < this._conditionalBlockList.size(); ++i) {
            ConditionalBlock conditionalBlock = this._conditionalBlockList.get(i);
            if (conditionalBlock == null || conditionalBlock.getIndex() != n) continue;
            return conditionalBlock;
        }
        return null;
    }

    public void getActiveTSRecordProxies(Vector vector, int n) {
        for (int i = 0; i < this._conditionalBlockList.size(); ++i) {
            ConditionalBlock conditionalBlock = this._conditionalBlockList.get(i);
            if (!(conditionalBlock instanceof RssConditionalBlock)) continue;
            ((RssConditionalBlock)conditionalBlock).getActiveTSRecordProxies(vector, n);
        }
        if (this.b == null) {
            this.getActiveOpSet();
        }
        if (this.b == null) {
            return;
        }
        ((RssTSLocationObject)this.b).getActiveTSRecordProxies(vector, n);
        ((RssTSLocationObject)this._controller).getActiveTSRecordProxies(vector, n);
    }

    public void updateTSProxyList() {
        OpRule opRule;
        int n;
        Vector<OpRule> vector = this.getRules();
        for (n = 0; n < vector.size(); ++n) {
            opRule = vector.get(n);
            opRule.setSystem(this._diversion.getSystem());
            opRule.setController(this._controller);
        }
        if (this._controller != null) {
            this._controller.setElementOp(this);
        }
        if (this.b == null) {
            this.getActiveOpSet();
        }
        if (this.b != null) {
            ((RssTSLocationObject)this.b).updateTSProxyList();
        }
        if (this._controller != null) {
            ((RssTSLocationObject)this._controller).updateTSProxyList();
        }
        for (n = 0; n < this._conditionalBlockList.size(); ++n) {
            opRule = this._conditionalBlockList.get(n);
            if (!(opRule instanceof RssConditionalBlock)) continue;
            ((RssConditionalBlock)((Object)opRule)).updateTSProxyList();
        }
    }
}

