/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.data.Parameter;
import hec.data.Units;
import hec.heclib.util.doubleArrayContainer;
import hec.lang.Logger;
import hec.model.PairedValues;
import hec.model.RunTimeStep;
import hec.model.SeasonalPairedValues;
import hec.model.SeasonalRecord;
import hec.rss.model.AdjustableParameter;
import hec.rss.model.Controller;
import hec.rss.model.Element;
import hec.rss.model.IndependentVariable;
import hec.rss.model.OpController;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.Rule;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Vector;
import rma.util.RMAConst;

public class DiversionRule
extends Rule {
    String _flowLocation = "";
    int _flowLocationIndex = -1;
    public static final String FLOW = "Flow";
    IndependentVariable _independentVariable;
    private SeasonalPairedValues _seasonalPairedValues = new SeasonalPairedValues();
    private boolean _hasSeasonalVariation = false;
    PairedValues _flowValues = new PairedValues();
    private SeasonalRecord _seasonalRecord;
    public static final int NONE = 0;
    private transient doubleArrayContainer b;
    private transient Vector c;

    public DiversionRule() {
        this.setRuleType("Flexible Diversion Rule");
    }

    public DiversionRule(String string) {
        this.setName(string);
        this.setRuleType("Flexible Diversion Rule");
    }

    @Deprecated
    public DiversionRule(Controller controller) {
        super(controller);
        this.setRuleType("Flexible Diversion Rule");
    }

    public DiversionRule(OpController opController) {
        super(opController);
        this.setRuleType("Flexible Diversion Rule");
    }

    public void getElementDependencies(List list) {
        Object object = this.getIndependentVariable();
        if (object != null && ((IndependentVariable)object).getType() == 2) {
            Element element = (Element)((Object)this._opController.getElementOp().getOperationsElement());
            RssSystem rssSystem = ((RssTSLocationObject)this).getSystem();
            object = rssSystem.getElement(((IndependentVariable)object).getElementId());
            if (object != null && (object = ((Element)object).getTopParent()) != element && !list.contains(object)) {
                list.add(object);
            }
        }
    }

    public SeasonalPairedValues getSeasonalFlowValues() {
        if (this._seasonalPairedValues.size() == 0 && this._flowValues.size() > 0) {
            this._seasonalPairedValues.setData(this._flowValues, "01Jan");
        }
        this._seasonalPairedValues.setUnitSystem(this.getUnitSystem());
        this._seasonalPairedValues.setParamXId(Parameter.PARAMID_FLOW);
        this._seasonalPairedValues.setParamYId(Parameter.PARAMID_FLOW);
        return this._seasonalPairedValues;
    }

    public void setSeasonalFlowValues(SeasonalPairedValues seasonalPairedValues) {
        this._seasonalPairedValues = seasonalPairedValues;
        if (this._seasonalPairedValues != null) {
            this._seasonalPairedValues.setHasSeasonalVariation(this._hasSeasonalVariation);
        }
    }

    public boolean hasSeasonalVariation() {
        return this._hasSeasonalVariation;
    }

    public void setHasSeasonalVariation(boolean bl) {
        this._hasSeasonalVariation = bl;
        if (this._seasonalPairedValues != null) {
            this._seasonalPairedValues.setHasSeasonalVariation(this._hasSeasonalVariation);
        }
    }

    public void setFunctionRelease(SeasonalPairedValues seasonalPairedValues) {
        if (seasonalPairedValues == null) {
            return;
        }
        this._seasonalPairedValues = seasonalPairedValues;
    }

    public SeasonalPairedValues getFunctionRelease() {
        if (this._seasonalPairedValues == null) {
            return null;
        }
        this._seasonalPairedValues.setUnitSystem(this.getUnitSystem());
        this._seasonalPairedValues.setParamXId(-1);
        this._seasonalPairedValues.setParamYId(Parameter.PARAMID_FLOW);
        return this._seasonalPairedValues;
    }

    public void setFunctionRelease(PairedValues pairedValues) {
        if (!Units.isValidUnitsSystem((int)pairedValues.getUnitSystem())) {
            pairedValues.setUnitSystem(this.getUnitSystem());
        }
        this._seasonalPairedValues.clearValues();
        this._seasonalPairedValues.setData(pairedValues, "01Jan");
        this._seasonalPairedValues.setHasSeasonalVariation(false);
    }

    public SeasonalRecord getSeasonalRecord() {
        if (this._seasonalRecord == null) {
            return null;
        }
        this._seasonalRecord.setUnitSystem(this.getUnitSystem());
        this._seasonalRecord.setParameterId(Parameter.PARAMID_FLOW);
        this._seasonalRecord.setGmtOffset(this.getGmtOffset());
        return this._seasonalRecord;
    }

    public void setSeasonalRecord(SeasonalRecord seasonalRecord) {
        this._seasonalRecord = seasonalRecord;
    }

    public void setIndependentVariable(IndependentVariable independentVariable) {
        this._independentVariable = independentVariable;
    }

    public IndependentVariable getIndependentVariable() {
        return this._independentVariable;
    }

    @Override
    public void getReferencedStateVariables(List list) {
        if (this._independentVariable == null) {
            return;
        }
        if (this._independentVariable.getType() == 4) {
            RssReturnStatusConstants rssReturnStatusConstants = ((RssTSLocationObject)this).getSystem();
            if (rssReturnStatusConstants == null) {
                return;
            }
            if ((rssReturnStatusConstants = rssReturnStatusConstants.getStateVariable(this._independentVariable.getStateVariableId())) != null && !list.contains(rssReturnStatusConstants)) {
                list.add(rssReturnStatusConstants);
            }
        }
    }

    public void setFlowLocation(String string) {
        this._flowLocation = string;
    }

    public String getFlowLocation() {
        return this._flowLocation;
    }

    public void setFlowLocationIndex(int n) {
        this._flowLocationIndex = n;
    }

    public int getFlowLocationIndex() {
        return this._flowLocationIndex;
    }

    @Override
    public boolean initialize() {
        this.b = null;
        this.c = null;
        return ((Rule)this).initializeCompute();
    }

    @Override
    public boolean initializeCompute() {
        RssSystem rssSystem = ((RssTSLocationObject)this).getSystem();
        if (rssSystem == null) {
            return false;
        }
        if (!super.initializeCompute()) {
            return false;
        }
        if (this._independentVariable == null) {
            rssSystem.printErrorMessage("DiversionRule.initializeCompute(" + this.getName() + "): Function is not defined");
            return false;
        }
        return this._independentVariable.initializeCompute(rssSystem, this);
    }

    @Override
    public double getValue(AdjustableParameter adjustableParameter, RunTimeStep runTimeStep, double d) {
        return this.getLimitValue(runTimeStep);
    }

    public double getLimitValue(RunTimeStep runTimeStep) {
        double d;
        double d2;
        if (this._independentVariable == null) {
            return Double.NEGATIVE_INFINITY;
        }
        switch (this._independentVariable.getType()) {
            case 0: 
            case 1: {
                d2 = this._seasonalRecord.interpolate(runTimeStep);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                d = this._independentVariable.evaluateTSFunction(runTimeStep);
                if (d == Double.NEGATIVE_INFINITY) {
                    return Double.NEGATIVE_INFINITY;
                }
                int n = Logger.getDebugLevel((String)"scripting");
                if (!RMAConst.isValidValue((double)d) && n == 10) {
                    System.out.println(" \nState Variable: " + this._independentVariable.getStateVariableName() + " is returning an invalid value of " + d + ", at time step " + runTimeStep.step + ".");
                }
                if (this._seasonalPairedValues.hasSeasonalVariation()) {
                    d2 = this._seasonalPairedValues.interpolate(runTimeStep, d);
                    break;
                }
                d2 = this._seasonalPairedValues.interpolate(d);
                break;
            }
            default: {
                return Double.NEGATIVE_INFINITY;
            }
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        d = this.getTimeOfDayFactor(runTimeStep) * this.getDayOfWeekFactor(runTimeStep);
        d2 *= d;
        if (this.useDemandScale()) {
            return d2 * this.getDemandScale();
        }
        return d2;
    }

    @Override
    public void updateTSProxyList() {
        String string;
        TSRecordProxy tSRecordProxy;
        super.updateTSProxyList();
        if (this._independentVariable != null && this._independentVariable.getType() == 3 && (tSRecordProxy = this.getTSRecordProxy(string = this._independentVariable.getTimeSeriesName(), 85)) == null) {
            this.addTSRecordProxy(string, 85);
        }
    }

    @Override
    public Vector getActiveTSRecordProxies(Vector vector, int n) {
        vector = super.getActiveTSRecordProxies(vector, n);
        if (n == 1 && this._independentVariable != null && this._independentVariable.getType() == 3) {
            String string = this._independentVariable.getTimeSeriesName();
            if ((string = this.getTSRecordProxy(string, 85)) != null) {
                vector.addElement(string);
            }
        }
        return vector;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public Object clone() {
        DiversionRule diversionRule = new DiversionRule();
        new DiversionRule()._flowLocation = this._flowLocation;
        diversionRule._flowLocationIndex = this._flowLocationIndex;
        diversionRule._independentVariable = this._independentVariable;
        diversionRule._seasonalPairedValues = this._seasonalPairedValues;
        diversionRule._hasSeasonalVariation = this._hasSeasonalVariation;
        diversionRule._flowValues = this._flowValues;
        diversionRule._seasonalRecord = this._seasonalRecord;
        return diversionRule;
    }
}

