/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.heclib.dss.DSSPathname;
import hec.io.DSSIdentifier;
import hec.lang.NamedType;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.model.ModelVariable;
import hec.model.PairedValues;
import hec.model.PairedValuesExt;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.Element;
import hec.rss.model.ForebayHeadLoss;
import hec.rss.model.Function;
import hec.rss.model.FunctionFactory;
import hec.rss.model.OutletGroupElement;
import hec.rss.model.PowerPlantFlow;
import hec.rss.model.PumpFlow;
import hec.rss.model.RSimDssPathPartGenerator;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOutletElement;
import hec.rss.model.ReservoirUtilities;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.SeepageConstants;
import hec.rss.model.Spillway;
import hec.rss.model.TailElevContainer;
import hec.rss.model.TailwaterElevation;
import hec.rss.model.TimeStepRoutingElement;
import hec.rss.model.TimeStepUtil;
import hec.rss.model.reports.AltInputReportEnums;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.jdom.Content;

public class DivertedOutletElement
extends ReservoirOutletElement
implements SeepageConstants,
TailElevContainer,
AltInputReportInfc {
    public static final int TAILWATER_CHILD_ID = 1;
    public static final int REACH_CHILD_ID = 0;
    int _seepageType = 0;
    double _constSeepage = Double.NEGATIVE_INFINITY;
    double _returnRatio = 1.0;
    PairedValues _seepageValues = new PairedValues();
    WorldPt _referencePt = new WorldPt();
    WorldLine _line = new WorldLine();
    RssNode _cntrlNode = null;
    int _inFlowType = 0;
    boolean _hasTailElev = false;
    TailwaterElevation _tailElev;
    long _diversionProjectId = Long.MIN_VALUE;
    private transient PairedValuesExt a;

    public DivertedOutletElement() {
    }

    public DivertedOutletElement(RssSystem rssSystem, int n, ReservoirElement reservoirElement) {
        super(rssSystem, n);
        this._parentElement = reservoirElement;
    }

    @Override
    public Vector getModelVariables(Vector vector) {
        if (vector == null) {
            vector = new Vector<ModelVariable>();
        }
        vector.add(RssModelVariableSet.getModelVariable(125));
        if (this.getReachElement() != null) {
            vector.add(RssModelVariableSet.getModelVariable(126));
        }
        return vector;
    }

    @Override
    public Vector getDefaultModelVariables() {
        Vector<ModelVariable> vector = new Vector<ModelVariable>();
        vector.add(RssModelVariableSet.getModelVariable(125));
        vector.add(RssModelVariableSet.getModelVariable(126));
        return vector;
    }

    @Override
    public Vector getTSRecords(ModelVariable object, Vector vector) {
        if (vector == null) {
            vector = new Vector<Object>();
        }
        if (object == null) {
            return vector;
        }
        switch (object.getType()) {
            case 125: {
                object = this.getTailNode();
                if (object == null || (object = ((RssNode)object).getTSRecordProxy(0)) == null) break;
                vector.addElement(object);
                break;
            }
            case 126: {
                object = this.getReachElement();
                if (object == null || (object = ((Element)object).getDownstreamNode()) == null || (object = ((RssNode)object).getTSRecordProxy(0)) == null) break;
                vector.addElement(object);
            }
        }
        return vector;
    }

    public void disconnectDownstream(double d, double d2) {
        RssNode rssNode = ((Element)this).getDownstreamNode();
        if (rssNode == null) {
            return;
        }
        ((Element)this).removeNode(rssNode);
        Element element = rssNode.getDownstreamElement();
        if (element != null) {
            element.removeNode(rssNode);
        }
        if (d != 0.0 && d2 != 0.0) {
            rssNode = new WorldPt(rssNode.getLocation());
            ((WorldPt)rssNode).n += d2;
            ((WorldPt)rssNode).e += d;
            this.getLine().getLastPt().init((WorldPt)rssNode);
        }
        this.setModified(true);
    }

    public long getDiversionProjectId() {
        return this._diversionProjectId;
    }

    public void setDiversionProjectId(long l) {
        this._diversionProjectId = l;
    }

    public PairedValuesExt getCompositeRelease() {
        this.a = ReservoirUtilities.a(this);
        return this.a;
    }

    @Override
    public void setupForSerialization() {
        super.setupForSerialization();
        if (this._seepageValues != null) {
            Object object = new DSSPathname();
            Object object2 = new RSimDssPathPartGenerator();
            Object object3 = this.getTopParent().getName();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add((String)object3);
            object3 = object2.generatePathnamePart(arrayList, "");
            object.setAPart((String)object3);
            arrayList.clear();
            arrayList.add(this.getName());
            arrayList.add("Seepage");
            object3 = this.getSystem();
            object2 = object3 != null ? ((RssSystem)object3).generateUniquePathPart(arrayList, "-") : object2.generatePathnamePart(arrayList, "-");
            object.setBPart((String)object2);
            object2 = Parameter.getParamString((int)Parameter.PARAMID_FLOW) + "-" + Parameter.getParamString((int)Parameter.PARAMID_FLOW);
            object.setCPart((String)object2);
            object2 = this.getSystem().getDssPairedDataFilePath();
            object = object.getPathname();
            this._seepageValues.setDssIdentifer(new DSSIdentifier((String)object2, (String)object));
            this._seepageValues.setParamXId(Parameter.PARAMID_FLOW);
            this._seepageValues.setParamYId(Parameter.PARAMID_FLOW);
            this._seepageValues.setUnitSystem(this.getUnitSystem());
        }
        if (this._tailElev != null) {
            this._tailElev.setupForSerialization();
        }
    }

    @Override
    public boolean initialize(RunTimeWindow runTimeWindow) {
        if (this._tailElev != null) {
            this._tailElev.initialize();
        }
        return super.initialize(runTimeWindow);
    }

    public Element getTailwaterElement() {
        if (this._elemVector.size() <= 1) {
            return null;
        }
        return this._elemVector.elementAt(1);
    }

    @Override
    public TailwaterElevation getTailwaterElevation() {
        if (this._tailElev == null) {
            this._tailElev = new TailwaterElevation(this);
        }
        if (this._tailElev.getElement() == null) {
            this._tailElev.setElement(this);
        }
        return this._tailElev;
    }

    @Override
    public void setParentElement(Element element) {
        super.setParentElement(element);
        if (this._tailElev != null) {
            this._tailElev.setElement(this);
        }
    }

    @Override
    public void setHasTailElev(boolean bl) {
        this._hasTailElev = bl;
    }

    @Override
    public boolean hasTailElev() {
        return this._hasTailElev;
    }

    public boolean hasPowerPlant() {
        Vector vector = this.getElementsByClass(AdjustableFlow.class, null);
        for (int i = 0; i < vector.size(); ++i) {
            NamedType namedType = (Element)vector.elementAt(i);
            if (!((AdjustableFlow)(namedType = (AdjustableFlow)namedType.getFunction())).hasPowerPlant()) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Object clone() {
        DivertedOutletElement divertedOutletElement = (DivertedOutletElement)super.clone();
        if (this._seepageValues != null) {
            divertedOutletElement._seepageValues = (PairedValues)this._seepageValues.clone();
        }
        if (this._referencePt != null) {
            divertedOutletElement._referencePt = (WorldPt)this._referencePt.clone();
        }
        if (this._tailElev != null) {
            divertedOutletElement._tailElev = (TailwaterElevation)((RssTSLocationObject)this._tailElev).clone();
            divertedOutletElement._tailElev.setElement(divertedOutletElement);
        }
        return divertedOutletElement;
    }

    @Override
    public void setActive(boolean bl) {
        if (bl && !this.hasOutlets()) {
            bl = false;
        }
        Enumeration<Element> enumeration = this._elemVector.elements();
        while (enumeration.hasMoreElements()) {
            Element element = enumeration.nextElement();
            element.setActive(bl);
        }
        if (((Element)this).getDownstreamNode() == null) {
            this.getReachElement().setActive(false);
        }
        super.setActive(bl);
    }

    @Override
    public void removeNode(RssNode rssNode) {
        if (rssNode == ((Element)this).getDownstreamNode() && this.hasReach()) {
            Element element = this._elemVector.elementAt(0);
            element.removeNode(rssNode);
        }
        super.removeNode(rssNode);
    }

    public boolean hasReach() {
        return this._elemVector.size() > 1;
    }

    public boolean isConnected() {
        return ((Element)this).getDownstreamNode() != null;
    }

    public Element getReachElement() {
        if (!this.hasReach()) {
            return null;
        }
        return this._elemVector.elementAt(0);
    }

    @Override
    public double calcSeepageFlow(double d) {
        double d2 = 0.0;
        if (this._seepageType == 0) {
            d2 = this._constSeepage;
        } else if (this._seepageType == 2) {
            d2 = d * (1.0 - this._returnRatio);
        } else if (this._seepageType == 1) {
            d2 = this._seepageValues.interpolateValue(d);
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        return d2;
    }

    @Override
    public int computeHindcastStep(RunTimeStep runTimeStep) {
        int n = this._elemVector.size();
        for (int i = n - 1; i > 0; --i) {
            int n2;
            Element element = this._elemVector.elementAt(i);
            if (element == null || !element.isActive() || (n2 = element.computeHindcastStep(runTimeStep)) == 0) continue;
            return n2;
        }
        if (this._function != null && (n = this._function.computeHindcastStep(runTimeStep)) != 0) {
            return n;
        }
        return 0;
    }

    @Override
    public int computeForecastStep(RunTimeStep runTimeStep) {
        int n = this._elemVector.size();
        for (int i = n - 1; i > 0; --i) {
            int n2;
            Element element = this._elemVector.elementAt(i);
            if (element == null || !element.isActive() || (n2 = element.computeForecastStep(runTimeStep)) == 0) continue;
            return n2;
        }
        if (this._function != null && (n = this._function.computeForecastStep(runTimeStep)) != 0) {
            return n;
        }
        return 0;
    }

    public double getConstSeepage() {
        return this._constSeepage;
    }

    public void setConstSeepage(double d) {
        this._constSeepage = d;
    }

    public void getConstSeepage(ParamDouble paramDouble) {
        paramDouble.setValue(this._constSeepage);
        paramDouble.setParameterId(Parameter.PARAMID_FLOW);
        paramDouble.setUnitSystem(this.getUnitSystem());
    }

    public void setConstSeepage(ParamDouble paramDouble) {
        this._constSeepage = paramDouble.getValue();
    }

    public double getReturnRatio() {
        return this._returnRatio;
    }

    public void setReturnRatio(double d) {
        this._returnRatio = d;
    }

    public PairedValues getSeepageValues() {
        if (this._seepageValues == null) {
            this._seepageValues = new PairedValues();
        }
        this._seepageValues.setUnitSystem(this.getUnitSystem());
        this._seepageValues.setParamXId(Parameter.PARAMID_FLOW);
        this._seepageValues.setParamYId(Parameter.PARAMID_FLOW);
        return this._seepageValues;
    }

    public void setSeepageValues(PairedValues pairedValues) {
        this._seepageValues = pairedValues;
    }

    public int getSeepageType() {
        return this._seepageType;
    }

    public boolean setSeepageType(int n) {
        if (n < 0 || n > 2) {
            return false;
        }
        this._seepageType = n;
        return true;
    }

    public WorldLine getLine() {
        return this._line;
    }

    @Override
    public WorldPt getReferencePt() {
        return this._referencePt;
    }

    public void setReferencePt(WorldPt worldPt) {
        this._referencePt = worldPt;
    }

    public void setLine(WorldLine worldLine) {
        if (worldLine == null) {
            return;
        }
        this._line = worldLine;
        this._referencePt = (WorldPt)this._line.pts.elementAt(0);
    }

    @Override
    public RssNode getUpstreamNode() {
        return this.getTailNode();
    }

    @Override
    public RssNode getDownstreamNode() {
        return this.getReachNode();
    }

    @Override
    public List getDownstreamNodes(List arrayList) {
        RssNode rssNode;
        if (arrayList == null) {
            arrayList = new ArrayList<RssNode>(1);
        }
        if ((rssNode = ((Element)this).getDownstreamNode()) != null) {
            arrayList.add(rssNode);
        }
        return arrayList;
    }

    public RssNode getReachNode() {
        return this.getReachElement().getDownstreamNode();
    }

    void createDefaultElements(RssNode rssNode) {
        this.removeAllChildElements();
        TimeStepRoutingElement timeStepRoutingElement = this._system.newTimeStepRoutingElement(false);
        timeStepRoutingElement.setName(this._system.getKeyStringForObject(this) + "~Reach");
        NamedType namedType = FunctionFactory.a(timeStepRoutingElement, "NullRouting");
        timeStepRoutingElement.putFunction(TimeStepUtil.TIME_STEP_ALL.getDuration(), (Function)namedType);
        super.addChildElement(timeStepRoutingElement);
        namedType = this._system.newElement(false);
        namedType.setName(this._system.getKeyStringForObject(this) + "~Tailwater");
        NamedType namedType2 = namedType;
        namedType2.setFunction(FunctionFactory.a((Element)namedType2, "Junction"));
        super.addChildElement((Element)namedType);
        if (rssNode == null) {
            rssNode = this._system.newNode();
        }
        namedType.addNode(rssNode, 0);
        timeStepRoutingElement.addNode(rssNode, 1);
    }

    public void convertRoutingElement() {
        Element element;
        if (this.hasReach() && !((element = this.getReachElement()) instanceof TimeStepRoutingElement)) {
            int n;
            TimeStepRoutingElement timeStepRoutingElement = this._system != null ? this._system.newTimeStepRoutingElement(false) : new TimeStepRoutingElement();
            timeStepRoutingElement.setName(element.getName());
            timeStepRoutingElement.putFunction(TimeStepUtil.TIME_STEP_ALL.getDuration(), element.getFunction());
            int n2 = element.getNodeCount();
            for (n = 0; n < n2; ++n) {
                timeStepRoutingElement.addNode(element.getNode(n), element.getNodeDir(n));
            }
            n = this.getChildElementCount();
            for (n2 = 0; n2 < n; ++n2) {
                Element element2 = this.getChildElementAt(n2);
                if (element2 != element) continue;
                this.addChildElementAt(timeStepRoutingElement, n2);
            }
        }
    }

    @Override
    public void addNode(RssNode rssNode, int n) {
        if (rssNode == null || this._nodeVector.contains(rssNode)) {
            return;
        }
        super.addNode(rssNode, n);
        if (this._elemVector.size() < 2) {
            return;
        }
        if (n == 0) {
            Element element = this._elemVector.elementAt(0);
            element.addNode(rssNode, n);
        }
    }

    public RssNode getTailNode() {
        return this.getTailwaterElement().getDownstreamNode();
    }

    @Override
    public void addChildElement(Element element) {
        Element element2;
        RssNode rssNode;
        if (element == null) {
            return;
        }
        super.addChildElement(element);
        if (!(element instanceof OutletGroupElement)) {
            rssNode = this._system.newNode();
            element2 = ((ReservoirElement)this._parentElement).getStorageElement();
            element2.addNode(rssNode, 0);
            ((Element)this).addNode(rssNode, 1);
            element.addNode(rssNode, 1);
            rssNode.setName(this._system.getKeyStringForObject(element) + "~" + "IN");
        }
        element2 = this._elemVector.elementAt(1);
        rssNode = this._system.newNode();
        element.addNode(rssNode, 0);
        element2.addNode(rssNode, 1);
    }

    @Override
    public void setActive(boolean bl, boolean bl2) {
        if (bl && !this.hasOutlets()) {
            bl = false;
        }
        super.setActive(bl, bl2);
        if (((Element)this).getDownstreamNode() == null) {
            this.getReachElement().setActive(false);
        }
    }

    public boolean hasOutlets() {
        if (this.hasElementsOfClass(AdjustableFlow.class)) {
            return true;
        }
        return this.hasElementsOfClass(Spillway.class);
    }

    public Color getLineColor() {
        return Color.black;
    }

    public int getInflowType() {
        return this._inFlowType;
    }

    public void setInflowType(int n) {
        this._inFlowType = n;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        org.jdom.Element element2;
        Cloneable cloneable;
        element.setAttribute("Name", this.getDisplayName());
        if (!this.getUseDefaultPulseFlow()) {
            element.setAttribute("PulseRouting", Double.toString(this.getPulseFlow()));
        }
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_TAILWATER).a() && (cloneable = this.getTailwaterElevation()) != null) {
            element2 = new org.jdom.Element("Tailwater");
            element.addContent((Content)element2);
            ((TailwaterElevation)cloneable).outputReport(alternativeInputReport, element2);
        }
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_FOREBAY_HEADLOSS).a() && this.hasForebayHeadLoss() && (cloneable = this.getForebayHeadLoss()) != null) {
            element2 = new org.jdom.Element("ForebayHeadLoss");
            element.addContent((Content)element2);
            ((ForebayHeadLoss)cloneable).outputReport(alternativeInputReport, element2);
        }
        cloneable = this.getOutletElementList();
        for (int i = 0; i < ((Vector)cloneable).size(); ++i) {
            Element element3 = (Element)((Vector)cloneable).get(i);
            element3.getFunction();
            if (element3.getFunction() instanceof PowerPlantFlow && alternativeInputReport.b().get((Object)AltInputReportEnums.RES_POWER_PLANT).a()) {
                element2 = new org.jdom.Element("Power_Plant");
                element.addContent((Content)element2);
                ((AdjustableFlow)element3.getFunction()).outputReport(alternativeInputReport, element2);
            }
            if (element3.getFunction() instanceof PumpFlow && alternativeInputReport.b().get((Object)AltInputReportEnums.RES_PUMP).a()) {
                element2 = new org.jdom.Element("Pump");
                element.addContent((Content)element2);
                ((AdjustableFlow)element3.getFunction()).outputReport(alternativeInputReport, element2);
            } else if (element3.getFunction() instanceof Spillway && alternativeInputReport.b().get((Object)AltInputReportEnums.RES_UNCONTROLLED_OUTLET).a()) {
                element2 = new org.jdom.Element("Spillway");
                element.addContent((Content)element2);
                ((Spillway)element3.getFunction()).outputReport(alternativeInputReport, element2);
            } else if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_CONTROLLED_OUTLET).a()) {
                element2 = new org.jdom.Element("Controlled_Outlet");
                element.addContent((Content)element2);
                ((AdjustableFlow)element3.getFunction()).outputReport(alternativeInputReport, element2);
            }
            if (element3._forebayHeadLoss == null) continue;
            element2 = new org.jdom.Element("Forebay");
            element.addContent((Content)element2);
            this._forebayHeadLoss.outputReport(alternativeInputReport, element2);
        }
    }
}

