/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.rss.model.DemandRuleInf;
import hec.rss.model.DownstreamCntrlOpRule$OperationType;
import hec.rss.model.DownstreamOp;
import hec.rss.model.DownstreamOpRule;
import hec.rss.model.Element;
import hec.rss.model.OpRule;
import hec.rss.model.OpValue;
import hec.rss.model.RssNode;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.WaterAccount;
import hec.rss.model.reports.AlternativeInputReport;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Vector;
import org.jdom.Content;

public class DownstreamCntrlOpRule
extends DownstreamOpRule
implements DemandRuleInf {
    int _parentRuleIndex = Integer.MIN_VALUE;
    boolean _isPassThru = false;
    DownstreamCntrlOpRule$OperationType _operationType = DownstreamCntrlOpRule$OperationType.MANAGED_STORAGE;
    String _upperLimitZone;
    String _lowerLimitZone;
    Double _reRegAvgPeriod;
    private transient DownstreamOpRule j;
    private transient DownstreamOp k;
    private transient OpValue[] l;
    private transient OpValue m;

    public DownstreamCntrlOpRule() {
    }

    public DownstreamCntrlOpRule(String string) {
        super(string);
    }

    public DownstreamCntrlOpRule(String string, int n) {
        super(string);
        this.setDownstreamControlLocationID(n);
    }

    @Override
    public void evaulatePerformance(RunTimeWindow runTimeWindow) {
        DownstreamOpRule downstreamOpRule = this.getParentRule();
        if (downstreamOpRule == null) {
            return;
        }
        ((OpRule)downstreamOpRule).evaulatePerformance(runTimeWindow);
    }

    @Override
    public void getElementDependencies(List list) {
        super.getElementDependencies(list);
        RssReturnStatusConstants rssReturnStatusConstants = ((RssTSLocationObject)this).getSystem();
        rssReturnStatusConstants = ((RssSystem)rssReturnStatusConstants).getNode(this.getDownstreamControlLocationID());
        if (rssReturnStatusConstants == null) {
            return;
        }
        if ((rssReturnStatusConstants = ((RssNode)rssReturnStatusConstants).getUpstreamElement()) != null && !list.contains(rssReturnStatusConstants = ((Element)rssReturnStatusConstants).getTopParent())) {
            list.add(rssReturnStatusConstants);
        }
    }

    @Override
    public void evaluateLimits(RunTimeStep runTimeStep, int n) {
    }

    public void setOpValue(RunTimeStep runTimeStep, OpValue opValue) {
        this.l[runTimeStep.step] = opValue;
        if (opValue == null || opValue.value == Double.NEGATIVE_INFINITY) {
            this.h.array[runTimeStep.step] = -3.4028234663852886E38;
            return;
        }
        opValue.type = this.getLimitType() == 1 ? 2 : 0;
        this.h.array[runTimeStep.step] = opValue.value;
    }

    @Override
    public OpValue getOpValue(RunTimeStep runTimeStep) {
        if (this.l[runTimeStep.step] == null) {
            return null;
        }
        return new OpValue(this.l[runTimeStep.step]);
    }

    @Override
    public boolean isLocalRule() {
        return false;
    }

    @Override
    public boolean isDnstrmRule() {
        return true;
    }

    @Override
    public boolean isPerAvgRule() {
        return false;
    }

    public int getMaxRoutingSteps() {
        if (this.getParentRule() == null) {
            return 1;
        }
        return this.j.getNumRouteSteps();
    }

    public OpValue getPriorityLimit() {
        return this.m;
    }

    @Override
    public OpValue evaluateRule(RunTimeStep runTimeStep, double d, int n, boolean bl) {
        if (n < 0) {
            return null;
        }
        if (this.getLimitType() == 1) {
            this.m.init(this._controller.getCurMinOpValue(runTimeStep));
        } else {
            this.m.init(this._controller.getCurMaxOpValue(runTimeStep));
        }
        if (!bl) {
            this.k.addActiveRule(this);
            return null;
        }
        OpValue opValue = this.k.computeFlowLimit(this, runTimeStep);
        if (opValue == null || opValue.value == Double.NEGATIVE_INFINITY) {
            if (this.h.array != null) {
                this.h.array[runTimeStep.step] = -3.4028234663852886E38;
            }
            return null;
        }
        if (this.h.array != null) {
            this.h.array[runTimeStep.step] = opValue.value;
        }
        opValue.type = this.getLimitType() == 1 ? 2 : 0;
        return opValue;
    }

    @Override
    public boolean initializeCompute() {
        super.initializeCompute();
        if (this.h == null) {
            ((RssTSLocationObject)this._controller).getSystem().printErrorMessage("DownstreamCntrlOpRule.initializeCompute: Failed to get rule array for rule " + this.getName());
            this.l = null;
            return false;
        }
        this.m = new OpValue();
        this.k = ((RssTSLocationObject)this._controller).getSystem().getDownstreamOp(this._downstreamLocationID);
        if (this.k == null) {
            ((RssTSLocationObject)this._controller).getSystem().printErrorMessage("DownstreamCntrlOpRule.initializeCompute: Failed to get DownstreamOp for rule " + this.getName());
            return false;
        }
        this.j = this.k.getDownstreamOpRule(this._parentRuleIndex);
        if (this.j == null) {
            return false;
        }
        this.j.addChildRule(this);
        if (this.h.array != null) {
            this.l = new OpValue[this.h.array.length];
        } else {
            ((RssTSLocationObject)this._controller).getSystem().printErrorMessage("DownstreamCntrlOpRule.initializeCompute: Failed allocate OpValue array for rule " + this.getName());
        }
        return true;
    }

    @Override
    public boolean initForPostProcessing() {
        super.initForPostProcessing();
        this.k = ((RssTSLocationObject)this._controller).getSystem().getDownstreamOp(this._downstreamLocationID);
        if (this.k == null) {
            ((RssTSLocationObject)this._controller).getSystem().printErrorMessage("DownstreamCntrlOpRule.initializeCompute: Failed to get DownstreamOp for rule " + this.getName());
            return false;
        }
        this.j = this.k.getDownstreamOpRule(this._parentRuleIndex);
        if (this.j == null) {
            return false;
        }
        this.j.addChildRule(this);
        return true;
    }

    public void setParentRuleIndex(int n) {
        if (this._parentRuleIndex != n) {
            this.j = null;
        }
        this._parentRuleIndex = n;
    }

    public int getParentRuleIndex() {
        return this._parentRuleIndex;
    }

    public DownstreamOp getDownstreamOp() {
        if (this.k == null) {
            this.k = ((RssTSLocationObject)this._controller).getSystem().getDownstreamOp(this._downstreamLocationID);
        }
        return this.k;
    }

    public DownstreamOpRule getParentRule() {
        if (this.k == null) {
            this.getDownstreamOp();
        }
        if (this.j == null && this.k != null) {
            this.j = this.k.getDownstreamOpRule(this._parentRuleIndex);
        }
        return this.j;
    }

    public void copyParentInto(DownstreamOpRule downstreamOpRule) {
        if (downstreamOpRule == null) {
            return;
        }
        downstreamOpRule.setController(this.getController());
        this.copyInto(downstreamOpRule);
        this._parentRuleIndex = downstreamOpRule.getIndex();
        downstreamOpRule.setController(null);
    }

    @Override
    public int getRuleLimitType() {
        DownstreamOpRule downstreamOpRule = this.getParentRule();
        if (downstreamOpRule != null) {
            return ((OpRule)downstreamOpRule).getRuleLimitType();
        }
        return super.getRuleLimitType();
    }

    @Override
    public void updateTSProxyList() {
        super.updateTSProxyList();
        Object object = this.getParentRule();
        if (object == null) {
            return;
        }
        ((RssTSLocationObject)object).updateTSProxyList();
        object = this.getTSProxyName();
        if (this.getTSRecordProxy((String)object, 89) == null) {
            this.addTSRecordProxy((String)object, 89);
        }
        if (this.getTSRecordProxy((String)object + "-Final", 167) == null) {
            this.addTSRecordProxy((String)object + "-Final", 167);
        }
        if (this.getTSRecordProxy((String)object, 198) == null) {
            this.addTSRecordProxy((String)object, 198);
        }
        if (this.getTSRecordProxy((String)object, 199) == null) {
            this.addTSRecordProxy((String)object, 199);
        }
        if (this.getTSRecordProxy((String)object, 200) == null) {
            this.addTSRecordProxy((String)object, 200);
        }
    }

    @Override
    public Vector getActiveTSRecordProxies(Vector vector, int n) {
        Object object;
        super.getActiveTSRecordProxies(vector, n);
        if (n == 0) {
            object = this.getTSProxyName();
            TSRecordProxy tSRecordProxy = this.getTSRecordProxy((String)object, 89);
            if (tSRecordProxy != null && !vector.contains(tSRecordProxy)) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = this.getTSRecordProxy((String)object + "-Final", 167)) != null && !vector.contains(tSRecordProxy)) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = this.getTSRecordProxy((String)object, 198)) != null && !vector.contains(tSRecordProxy)) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = this.getTSRecordProxy((String)object, 199)) != null && !vector.contains(tSRecordProxy)) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = this.getTSRecordProxy((String)object, 200)) != null && !vector.contains(tSRecordProxy)) {
                vector.addElement(tSRecordProxy);
            }
        }
        if ((object = this.getParentRule()) != null) {
            return ((RssTSLocationObject)object).getActiveTSRecordProxies(vector, n);
        }
        return vector;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element object) {
        super.outputReport(alternativeInputReport, (org.jdom.Element)object);
        object.setAttribute("Rule", "DownStreamOp");
        object.setAttribute("DSControllerID", Integer.toString(this.getDownstreamControlLocationID()));
        object.setAttribute("DSParameter", Integer.toString(this.getDownstreamControlParameter()));
        object.setAttribute("UseDefaultRuleOptions", Boolean.toString(this.useDefaultDSOptions()));
        if (!this.useDefaultDSOptions()) {
            alternativeInputReport = new org.jdom.Element("RuleSpecificDownStreamOptions");
            object.addContent((Content)alternativeInputReport);
            object = this.getDownStreamOptions();
            if (object._useLaggedSpaceAdj) {
                alternativeInputReport.setAttribute("CorrectionForAtteniation", "Option1_LaggedSpaceAdj");
                alternativeInputReport.setAttribute("MaxIterations", Integer.toString(object._lagMaxIterations));
                alternativeInputReport.setAttribute("AbsoluteFlowTol", Double.toString(object._lagFlowTolerance));
                alternativeInputReport.setAttribute("TolFractionLimit", Double.toString(object._lagFractionLimit));
            } else if (object._usePredictor) {
                alternativeInputReport.setAttribute("CorrectionForAtteniation", "Option2_PredictorCorrector");
                alternativeInputReport.setAttribute("MaxIterations", Integer.toString(object._predictorMaxIterations));
                alternativeInputReport.setAttribute("CorrectionFactor", Double.toString(object._predictorCorrectionFactor));
            } else {
                alternativeInputReport.setAttribute("CorrectionForAtteniation", "Option3_NoCorrection");
            }
            alternativeInputReport.setAttribute("ConsiderROC_Constraints", Boolean.toString(object._useConsiderROC));
            if (object._useConsiderROC) {
                alternativeInputReport.setAttribute("MaxLookahead", Integer.toString(object._maxLookaheadROC));
            }
        }
    }

    @Override
    public WaterAccount getWaterAccount() {
        return this.j.getWaterAccount();
    }

    @Override
    public void setWaterAccount(WaterAccount waterAccount) {
        this.j.setWaterAccount(waterAccount);
    }

    public boolean isPassThru() {
        return this._isPassThru;
    }

    public void setPassThru(boolean bl) {
        this._isPassThru = bl;
    }

    public void setOperationType(DownstreamCntrlOpRule$OperationType downstreamCntrlOpRule$OperationType) {
        this._operationType = downstreamCntrlOpRule$OperationType;
    }

    public DownstreamCntrlOpRule$OperationType getOperationType() {
        return this._operationType;
    }

    public void setUpperLimitZone(String string) {
        this._upperLimitZone = string;
    }

    public String getUpperLimitZone() {
        return this._upperLimitZone;
    }

    public void setLowerLimitZone(String string) {
        this._lowerLimitZone = string;
    }

    public String getLowerLimitZone() {
        return this._lowerLimitZone;
    }

    public void setReRegAvgPeriod(Double d) {
        this._reRegAvgPeriod = d;
    }

    public Double getReRegAvgPeriod() {
        return this._reRegAvgPeriod;
    }

    @Override
    public void setPriority(RunTimeStep runTimeStep, double d) {
        super.setPriority(runTimeStep, d);
        if (this.j != null) {
            this.j.setPriority(runTimeStep, d);
        }
    }

    @Override
    public double getPriority(RunTimeStep runTimeStep) {
        if (this.j != null) {
            return this.j.getPriority(runTimeStep);
        }
        return super.getPriority(runTimeStep);
    }
}

