/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.heclib.util.doubleArrayContainer;
import hec.io.AsciiSerializable;
import hec.lang.NamedType;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.rss.model.ControlStructure;
import hec.rss.model.DownstreamCntrlOpRule;
import hec.rss.model.DownstreamOpRule;
import hec.rss.model.DownstreamOptions;
import hec.rss.model.DownstreamPulseResponse;
import hec.rss.model.Element;
import hec.rss.model.OpRule;
import hec.rss.model.OpValue;
import hec.rss.model.PulseRoutingFunction;
import hec.rss.model.ReleaseFuncOpRule;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOutletElement;
import hec.rss.model.ReservoirSysOp;
import hec.rss.model.RssModelVariableConstants;
import hec.rss.model.RssNode;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.Spillway;
import hec.rss.model.Storage;
import hec.rss.model.SystemStorageDefinition;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import rma.lang.RmaMath;

public class DownstreamOp
implements AsciiSerializable,
RssModelVariableConstants,
RssReturnStatusConstants {
    private int _nodeIndex;
    private Hashtable _ruleTable;
    private int _nextRuleIndex = 0;
    transient RssSystem a;
    private transient RssNode b;
    private transient Hashtable c;
    private transient Hashtable d;
    private transient ReservoirElement[] e;
    private transient int f;
    private transient int g;
    private transient int h;
    private transient int i;
    private transient double[][] j;
    private transient double[][] k;
    private transient double[] l;
    private transient double[] m;
    private transient boolean[] n;
    private transient boolean[] o;
    private transient boolean p;
    private transient boolean q;
    private transient double[][] r;
    private transient double[] s;
    private transient Object[] t;
    private transient Object[] u;
    private transient Object[] v;
    private transient Object[] w;
    private transient doubleArrayContainer x;
    private transient SystemStorageDefinition y;
    private transient double[] z;
    private transient double[] A;
    private transient double[] B;
    private transient boolean[] C;
    private transient boolean[] D;
    private transient double[] E;
    private transient double[] F;
    private transient double[] G;
    private transient double[] H;
    private transient double[] I;
    private transient double[] J;
    private transient double[] K;
    private transient double[] L;
    private transient double[] M;
    private transient double[] N;
    private transient double[] O;
    private transient int[] P;
    private transient double[] Q;

    public DownstreamOp() {
    }

    public DownstreamOp(int n) {
        this._nodeIndex = n;
    }

    public Hashtable getResPulseTable(int n) {
        if (this.c == null) {
            return null;
        }
        return (Hashtable)this.c.get(n);
    }

    public void evaluateLimits(RunTimeStep runTimeStep, int n) {
    }

    public int getMaxRoutingSteps(ReservoirElement object) {
        if (object == null) {
            return 1;
        }
        if (this.c == null) {
            return 1;
        }
        if ((object = (Hashtable)this.c.get(new Integer(object.getIndex()))) == null) {
            return 1;
        }
        int n = 1;
        Enumeration enumeration = ((Hashtable)object).elements();
        while (enumeration.hasMoreElements()) {
            object = (DownstreamPulseResponse)enumeration.nextElement();
            int n2 = ((DownstreamPulseResponse)object).f() + ((DownstreamPulseResponse)object).g();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public OpValue computeFlowLimit(DownstreamCntrlOpRule downstreamCntrlOpRule, RunTimeStep object) {
        double d;
        int n;
        int n2;
        object = downstreamCntrlOpRule.getController().getElementOp().getOperationsElement();
        int n3 = -1;
        for (n2 = 0; n2 < this.e.length; ++n2) {
            if (this.e[n2] != object) continue;
            n3 = n2;
            break;
        }
        if (n3 < 0) {
            return null;
        }
        n2 = 1;
        if (downstreamCntrlOpRule.getLimitType() == -1) {
            n2 = 0;
        }
        double[] dArray = this.j[n3];
        if (n2 == 0) {
            dArray = this.k[n3];
        }
        DownstreamPulseResponse[] downstreamPulseResponseArray = (DownstreamPulseResponse[])this.u[n3];
        Object[] objectArray = (Object[])this.v[n3];
        Object[] objectArray2 = (Object[])this.w[n3];
        doubleArrayContainer[] cfr_ignored_0 = (doubleArrayContainer[])this.t[n3];
        int n4 = downstreamPulseResponseArray.length;
        OpValue opValue = new OpValue();
        int n5 = object.getChildElementCount() - 1;
        if (n5 > 1) {
            opValue.childFractionTable = new Hashtable(n4);
        }
        for (n = 0; n < downstreamPulseResponseArray.length; ++n) {
            int n6;
            DownstreamPulseResponse downstreamPulseResponse = downstreamPulseResponseArray[n];
            if (n5 > 1) {
                opValue.childFractionTable.put(new Integer(downstreamPulseResponse.b()), new Float(1.0 / (double)n4));
            }
            double[] dArray2 = downstreamPulseResponse.e();
            int n7 = downstreamPulseResponse.f();
            int n8 = downstreamPulseResponse.g();
            int n9 = downstreamPulseResponse.h();
            double[] cfr_ignored_1 = (double[])objectArray[n];
            double[] dArray3 = (double[])objectArray2[n];
            Arrays.fill(this.G, 0.0);
            for (n6 = 0; n6 < this.i; ++n6) {
                int n10;
                int n11 = n6;
                this.G[n11] = this.G[n11] + dArray3[n6];
                int n12 = n6 - this.h + n9;
                if (n12 >= this.i) {
                    n12 = this.i - 1;
                }
                for (int i = 0; i < n8 && (n10 = n6 + (n7 - this.h) + i) < this.i; ++i) {
                    int n13 = n10;
                    this.G[n13] = this.G[n13] + dArray[n12] * dArray2[i];
                }
            }
            n6 = this.P[n3] - this.h;
            if (n6 < 0) {
                n6 = 0;
            }
            if (n6 >= this.G.length) {
                n6 = this.G.length - 1;
            }
            double d2 = this.G[n6] - dArray[n6];
            double cfr_ignored_2 = (Math.abs(d2) + dArray[n6]) / dArray[n6];
            double cfr_ignored_3 = dArray[n6];
            for (n9 = 0; n9 < n8; ++n9) {
                n6 = n9 + (n7 - this.h);
                double cfr_ignored_4 = dArray[n6];
                double cfr_ignored_5 = dArray2[n9];
            }
        }
        n = this.P[n3] - this.h;
        if (n < 0) {
            n = 0;
            this.a.printErrorMessage("DownstreamOp.computeFlowLimit: Warning, _resLag[resId]-_minOffset less than zero");
            this.a.printErrorMessage("Downstream Rule - " + downstreamCntrlOpRule.getName());
        }
        opValue.value = d = dArray[n];
        return opValue;
    }

    public void addActiveRule(DownstreamCntrlOpRule downstreamCntrlOpRule) {
        if (this.e == null || downstreamCntrlOpRule == null) {
            return;
        }
        Vector<DownstreamCntrlOpRule> vector = downstreamCntrlOpRule.getController().getElementOp().getOperationsElement();
        int n = -1;
        for (int i = 0; i < this.e.length; ++i) {
            if (this.e[i] != vector) continue;
            n = i;
            break;
        }
        if (n < 0) {
            return;
        }
        if (downstreamCntrlOpRule.getLimitType() == 1) {
            this.n[n] = true;
            this.q = true;
        } else {
            this.o[n] = true;
            this.p = true;
        }
        Integer n2 = new Integer(vector.getIndex());
        vector = (Vector)this.d.get(n2);
        if (vector == null) {
            vector = new Vector<DownstreamCntrlOpRule>();
            vector.add(downstreamCntrlOpRule);
            this.d.put(n2, vector);
            return;
        }
        if (!vector.contains(downstreamCntrlOpRule)) {
            vector.add(downstreamCntrlOpRule);
        }
    }

    public int evaluateBaseFlow(RunTimeStep runTimeStep, int n, int n2) {
        int n3;
        int n4;
        boolean[] blArray = n2 == 1 ? this.n : this.o;
        int n5 = this.e.length;
        int n6 = runTimeStep.getTotalNumSteps();
        int n7 = n6;
        if (runTimeStep.step + this.h + this.i <= n7) {
            System.arraycopy(this.x.array, runTimeStep.step + this.h, this.s, 0, this.i);
        } else {
            for (n4 = 0; n4 < this.i; ++n4) {
                n3 = runTimeStep.step + this.h + n4;
                if (n3 > n7) {
                    n3 = n7;
                }
                this.s[n4] = this.x.array[n3];
            }
        }
        Arrays.fill(this.M, 0.0);
        Arrays.fill(this.N, 0.0);
        Arrays.fill(this.O, 0.0);
        for (n2 = 0; n2 < n5; ++n2) {
            Object[] objectArray;
            Object[] objectArray2;
            doubleArrayContainer[] doubleArrayContainerArray;
            DownstreamPulseResponse[] downstreamPulseResponseArray;
            if (this.e[n2] == null || !blArray[n2] || (downstreamPulseResponseArray = (DownstreamPulseResponse[])this.u[n2]) == null || (doubleArrayContainerArray = (doubleArrayContainer[])this.t[n2]) == null || (objectArray2 = (Object[])this.v[n2]) == null || (objectArray = (Object[])this.w[n2]) == null) continue;
            n7 = downstreamPulseResponseArray.length;
            this.P[n2] = this.h;
            for (n3 = 0; n3 < n7; ++n3) {
                int n8;
                int n9;
                int n10;
                if (downstreamPulseResponseArray[n3] == null || objectArray2[n3] == null || objectArray[n3] == null) continue;
                double[] dArray = (double[])objectArray2[n3];
                Arrays.fill(dArray, 0.0);
                double[] dArray2 = (double[])objectArray[n3];
                Arrays.fill(dArray2, 0.0);
                DownstreamPulseResponse downstreamPulseResponse = downstreamPulseResponseArray[n3];
                double[] dArray3 = downstreamPulseResponse.e();
                double[] dArray4 = doubleArrayContainerArray[n3].array;
                int n11 = downstreamPulseResponse.h();
                if (this.P[n2] < n11) {
                    this.P[n2] = n11;
                }
                int n12 = downstreamPulseResponse.f();
                int n13 = downstreamPulseResponse.g();
                int n14 = this.i - (n12 - this.h);
                for (n4 = 0; n4 < n14; ++n4) {
                    n10 = runTimeStep.step + n4;
                    if (n10 > n6) {
                        n10 = n6;
                    }
                    for (n9 = 0; n9 < n13 && (n8 = n4 + (n12 - this.h) + n9) < this.i; ++n9) {
                        int n15 = n8;
                        this.s[n15] = this.s[n15] - dArray4[n10] * dArray3[n9];
                        int n16 = n8;
                        dArray[n16] = dArray[n16] + dArray3[n9];
                        if (n4 > this.g - n11) continue;
                        int n17 = n8;
                        this.M[n17] = this.M[n17] + dArray3[n9];
                    }
                }
                n14 = this.i;
                for (n4 = 1; n4 <= n14; ++n4) {
                    n10 = runTimeStep.step - n4;
                    if (n10 < 0) {
                        n10 = 0;
                    }
                    for (n9 = n13 - 1; n9 >= 0 && (n8 = -n4 + (n12 - this.h) + n9) >= 0; --n9) {
                        if (n8 >= this.i) continue;
                        int n18 = n8;
                        this.s[n18] = this.s[n18] - dArray4[n10] * dArray3[n9];
                        int n19 = n8;
                        dArray2[n19] = dArray2[n19] + dArray4[n10] * dArray3[n9];
                        int n20 = n8;
                        this.N[n20] = this.N[n20] + dArray4[n10] * dArray3[n9];
                        int n21 = n8;
                        this.O[n21] = this.O[n21] + dArray3[n9];
                    }
                }
            }
        }
        if (runTimeStep.step + this.h + this.i > n6) {
            int n22 = n6 - (runTimeStep.step + this.h);
            if (n22 < 0) {
                n22 = 0;
            }
            Arrays.fill(this.s, n22 + 1, this.i, this.s[n22]);
        }
        return 0;
    }

    public int evaluateOperationStep(RunTimeStep runTimeStep, int n) {
        int n2 = 0;
        if (this.q) {
            this.evaluateBaseFlow(runTimeStep, n, 1);
            n2 = this.evaluateOperationStep(runTimeStep, n, 1);
            if (n2 != 0) {
                return n2;
            }
        }
        if (this.p) {
            this.evaluateBaseFlow(runTimeStep, n, -1);
            n2 = this.evaluateOperationStep(runTimeStep, n, -1);
            if (n2 != 0) {
                return n2;
            }
        }
        return n2;
    }

    public int evaluateOperationStep(RunTimeStep runTimeStep, int n, int n2) {
        double d;
        int n3;
        double d2;
        int n4;
        Object object;
        boolean[] blArray;
        double[][] dArray;
        boolean bl;
        int n5 = this.e.length;
        RunTimeStep runTimeStep2 = new RunTimeStep(runTimeStep);
        RunTimeStep runTimeStep3 = new RunTimeStep(runTimeStep);
        int n6 = runTimeStep.getTotalNumSteps();
        boolean bl2 = bl = !runTimeStep.isPerAvgTimeStep();
        if (n2 == 1) {
            dArray = this.j;
            var15_11 = this.l;
            blArray = this.n;
        } else {
            dArray = this.k;
            var15_11 = this.m;
            blArray = this.o;
        }
        for (n = 0; n < n5; ++n) {
            Arrays.fill(this.r[n], Double.NEGATIVE_INFINITY);
            if (!blArray[n]) continue;
            object = (Vector)this.d.get(new Integer(this.e[n].getIndex()));
            if (object == null || ((Vector)object).size() <= 0) {
                blArray[n] = false;
                continue;
            }
            int n7 = ((Vector)object).size();
            for (n4 = 0; n4 < this.i; ++n4) {
                d2 = Double.NEGATIVE_INFINITY;
                runTimeStep2.setStep(runTimeStep.step + this.h + n4);
                if (runTimeStep2.step > n6) {
                    runTimeStep2.step = n6;
                }
                for (n3 = 0; n3 < n7; ++n3) {
                    int n8;
                    DownstreamOpRule downstreamOpRule = (DownstreamCntrlOpRule)((Vector)object).elementAt(n3);
                    if (downstreamOpRule == null || (downstreamOpRule = ((DownstreamCntrlOpRule)downstreamOpRule).getParentRule()) == null || (n8 = downstreamOpRule.getLimitType()) != n2) continue;
                    d = ((ReleaseFuncOpRule)downstreamOpRule).getLimitValue(runTimeStep2);
                    if (n2 == 1) {
                        if (d2 != Double.NEGATIVE_INFINITY && !(d2 > d)) continue;
                        d2 = d;
                        continue;
                    }
                    if (d2 != Double.NEGATIVE_INFINITY && !(d2 < d)) continue;
                    d2 = d;
                }
                this.r[n][n4] = d2;
            }
        }
        for (n3 = 0; n3 < this.i; ++n3) {
            double d3;
            double d4;
            double d5;
            d = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            int n9 = 0;
            if (n3 == 0) {
                this.Q[0] = 0.0;
            }
            for (n = 0; n < n5; ++n) {
                if (!blArray[n]) {
                    dArray[n][n3] = 0.0;
                    continue;
                }
                ++n9;
                runTimeStep3.step = runTimeStep.step - 1 + n3 - (this.P[n] - this.h);
                if (runTimeStep3.step < 0) {
                    runTimeStep3.step = 0;
                }
                if (runTimeStep3.step > n6) {
                    runTimeStep3.step = n6;
                }
                runTimeStep2.step = runTimeStep.step + n3 - (this.P[n] - this.h);
                if (runTimeStep2.step < 0) {
                    runTimeStep2.step = 0;
                }
                if (runTimeStep2.step > n6) {
                    runTimeStep2.step = n6;
                }
                this.K[n] = this.e[n].getGuideCurveStorage(runTimeStep2);
                double d9 = this.z[n];
                if (runTimeStep3.step < runTimeStep.step) {
                    this.z[n] = this.e[n].getStorageFunction().getStorage(runTimeStep3);
                } else {
                    int n10 = n;
                    this.z[n10] = this.z[n10] + this.I[n];
                    double d10 = bl && n3 > 1 ? (dArray[n][n3 - 1] + dArray[n][n3 - 2]) / 2.0 / Storage.DSDT_TO_Q * (double)runTimeStep.getTimeStepSeconds() : dArray[n][n3 - 1] / Storage.DSDT_TO_Q * (double)runTimeStep.getTimeStepSeconds();
                    if (n2 == 1) {
                        if (this.z[n] > this.K[n]) {
                            if (this.z[n] - d10 > this.K[n]) {
                                int n11 = n;
                                this.z[n11] = this.z[n11] - d10;
                            } else {
                                this.z[n] = this.K[n];
                            }
                        }
                    } else {
                        int n12 = n;
                        this.z[n12] = this.z[n12] - d10;
                        if (this.z[n] < 0.0) {
                            this.z[n] = 0.0;
                        }
                    }
                }
                d += this.z[n];
                double d11 = this.z[n];
                if (runTimeStep2.step < runTimeStep.step) {
                    d11 = this.e[n].getStorageFunction().getStorage(runTimeStep2);
                } else if (n3 > 0) {
                    double d12;
                    d11 = this.z[n] + (this.z[n] - d9);
                    if (d12 < 0.0) {
                        d11 = 0.0;
                    }
                    if (n2 == 1 && this.z[n] >= this.K[n] && d11 < this.K[n]) {
                        d11 = this.K[n];
                    }
                }
                double d13 = this.e[n].getStorageFunction().storageToElevation(this.z[n]);
                d5 = this.e[n].getStorageFunction().storageToElevation(d11);
                Vector vector = this.e[n].getElementsByClass(Spillway.class, new Vector());
                int n13 = vector.size();
                double d14 = 0.0;
                double d15 = 0.0;
                for (int i = 0; i < n13; ++i) {
                    object = (Spillway)((Element)vector.elementAt(i)).getFunction();
                    d14 += ((ControlStructure)object).getRelease(d13);
                    d15 += ((ControlStructure)object).getRelease(d5);
                }
                d8 += d15;
                this.I[n] = 0.0;
                d2 = bl ? (this.e[n].getStorageFunction().getNetInflow(runTimeStep2) + this.e[n].getStorageFunction().getNetInflow(runTimeStep3)) / 2.0 - (d14 + d15) / 2.0 : this.e[n].getStorageFunction().getNetInflow(runTimeStep2) - d15;
                int n14 = n;
                this.I[n14] = this.I[n14] + d2 / Storage.DSDT_TO_Q * (double)runTimeStep.getTimeStepSeconds();
                d6 += this.I[n];
                d7 += this.K[n];
                if (n3 != 0) continue;
                this.Q[0] = this.Q[0] + this.e[n].getStorageFunction().getOutflowArray()[runTimeStep3.step];
            }
            double d16 = Double.NEGATIVE_INFINITY;
            Arrays.fill(this.D, false);
            for (n = 0; n < n5; ++n) {
                if (!blArray[n]) continue;
                if (n2 == 1) {
                    if (d16 == Double.NEGATIVE_INFINITY || d16 > this.r[n][n3]) {
                        d16 = this.r[n][n3];
                    }
                } else if (d16 == Double.NEGATIVE_INFINITY || d16 < this.r[n][n3]) {
                    d16 = this.r[n][n3];
                }
                Object[] objectArray = (Object[])this.v[n];
                for (n4 = 0; n4 < objectArray.length; ++n4) {
                    double[] dArray2 = (double[])objectArray[n4];
                    object = dArray2;
                    if (!(dArray2[n3] > 0.0)) continue;
                    this.D[n] = true;
                }
            }
            this.Q[n3 + 1] = d16 - this.s[n3];
            d5 = (this.Q[n3 + 1] + this.Q[n3]) / 2.0 / Storage.DSDT_TO_Q * (double)runTimeStep.getTimeStepSeconds();
            if (n2 == 1) {
                if (d + d6 > d7) {
                    if (d + d6 - d5 < d7) {
                        d4 = d7 - d;
                        this.Q[n3 + 1] = bl ? (d + d6 - d7) * Storage.DSDT_TO_Q / (double)runTimeStep.getTimeStepSeconds() * 2.0 - this.Q[n3] : (d + d6 - d7) * Storage.DSDT_TO_Q / (double)runTimeStep.getTimeStepSeconds();
                    } else {
                        d4 = d6 - d5;
                    }
                } else {
                    d4 = d6;
                    this.Q[n3 + 1] = 0.0;
                }
            } else {
                d4 = d6 - d5;
                if (d + d4 < 0.0) {
                    d4 = d;
                }
            }
            Arrays.fill(this.A, 0.0);
            runTimeStep2.step = runTimeStep.step - 1;
            if (runTimeStep2.step < 0) {
                runTimeStep2.step = 0;
            }
            if (n9 > 0) {
                ReservoirSysOp.a(this.a, this.e, blArray, runTimeStep2, this.y, this.z, this.A, d4);
            }
            double d17 = 0.0;
            for (n = 0; n < n5; ++n) {
                if (!this.D[n]) continue;
                this.B[n] = this.z[n] - this.A[n] + this.I[n];
                if (this.B[n] < 0.0) {
                    this.B[n] = 0.0;
                }
                d17 += this.B[n];
            }
            if (d17 != 0.0) {
                n = 0;
                while (n < n5) {
                    int n15 = n++;
                    this.B[n15] = this.B[n15] / d17;
                }
            }
            n9 = 0;
            d16 = Double.NEGATIVE_INFINITY;
            Arrays.fill(this.D, false);
            Arrays.fill(this.F, 0.0);
            double d18 = 0.0;
            for (n = 0; n < n5; ++n) {
                this.C[n] = false;
                if (!blArray[n]) continue;
                Object[] objectArray = (Object[])this.v[n];
                for (n4 = 0; n4 < objectArray.length; ++n4) {
                    double[] dArray3 = (double[])objectArray[n4];
                    object = dArray3;
                    if (!(dArray3[n3] > 0.0)) continue;
                    this.C[n] = true;
                }
                if (!this.C[n] || !blArray[n]) continue;
                if (d16 == Double.NEGATIVE_INFINITY || d16 > this.r[n][n3]) {
                    d16 = this.r[n][n3];
                }
                this.D[n] = true;
                d18 += this.B[n];
                ++n9;
            }
            var15_11[n3] = d3 = d16 - this.s[n3] - d8;
            for (n = 0; n < n5; ++n) {
                Object[] objectArray = (Object[])this.w[n];
                if (this.D[n]) continue;
                for (n4 = 0; n4 < objectArray.length; ++n4) {
                    object = (double[])objectArray[n4];
                    d3 -= object[n3];
                }
            }
            if (d3 < 0.0) {
                d3 = 0.0;
            }
            for (n = 0; n < n5; ++n) {
                if (this.D[n]) {
                    if (d18 == 0.0) {
                        this.E[n] = d3 / (double)n9;
                        continue;
                    }
                    this.E[n] = d3 * this.B[n] / d18;
                    continue;
                }
                this.E[n] = 0.0;
            }
            boolean[] blArray2 = new boolean[n5];
            Arrays.fill(blArray2, true);
            for (n = 0; n < n5; ++n) {
                object = (DownstreamPulseResponse[])this.u[n];
                int cfr_ignored_0 = ((DownstreamPulseResponse[])object).length;
                for (n4 = 0; n4 < ((Object)object).length; ++n4) {
                    dArray[n][n3] = this.E[n];
                }
            }
        }
        return 0;
    }

    public int initOperationStep(RunTimeStep runTimeStep) {
        Cloneable cloneable;
        Enumeration enumeration = this.d.elements();
        while (enumeration.hasMoreElements()) {
            cloneable = (Vector)enumeration.nextElement();
            ((Vector)cloneable).clear();
        }
        int n = this.c.size();
        if (this.e == null && n > 0) {
            this.e = new ReservoirElement[n];
            this.t = new Object[n];
            this.u = new Object[n];
            this.v = new Object[n];
            this.P = new int[n];
            int n2 = 0;
            int n3 = Integer.MAX_VALUE;
            int n4 = 0;
            int n5 = Integer.MAX_VALUE;
            int n6 = 1;
            Object[] objectArray = this.c.keys();
            while (objectArray.hasMoreElements()) {
                Object object = (Integer)objectArray.nextElement();
                cloneable = (ReservoirElement)this.a.getElement((Integer)object);
                this.e[n2] = cloneable;
                if (cloneable == null) continue;
                this.P[n2] = 0;
                int n7 = ((ReservoirElement)cloneable).getReservoirOp(false).getActiveOpSet().getMaxNumDecisionSteps(runTimeStep.getTimeStepSeconds());
                if ((object = (Hashtable)this.c.get(object)) != null && ((Hashtable)object).size() > 0) {
                    int n8 = ((Hashtable)object).size();
                    doubleArrayContainer[] doubleArrayContainerArray = new doubleArrayContainer[n8];
                    DownstreamPulseResponse[] downstreamPulseResponseArray = new DownstreamPulseResponse[n8];
                    Object[] objectArray2 = new Object[n8];
                    this.t[n2] = doubleArrayContainerArray;
                    this.u[n2] = downstreamPulseResponseArray;
                    this.v[n2] = objectArray2;
                    int n9 = 0;
                    Enumeration enumeration2 = ((Hashtable)object).elements();
                    while (enumeration2.hasMoreElements()) {
                        downstreamPulseResponseArray[n9] = object = (DownstreamPulseResponse)enumeration2.nextElement();
                        if (object == null) continue;
                        int n10 = ((DownstreamPulseResponse)object).h();
                        if (this.P[n2] < n10) {
                            this.P[n2] = n10;
                        }
                        int n11 = ((DownstreamPulseResponse)object).f();
                        int n12 = ((DownstreamPulseResponse)object).g();
                        n12 = n11 + n12 + (n7 - 1);
                        if (n10 < n3) {
                            n3 = n10;
                        }
                        if (n10 > n4) {
                            n4 = n10;
                        }
                        if (n11 < n5) {
                            n5 = n11;
                        }
                        if (n6 < n12) {
                            n6 = n12;
                        }
                        if ((object = ((Element)((Object)cloneable)).getChildElementAt(((DownstreamPulseResponse)object).b())) != null && ((Element)object).getDownstreamNode() != null) {
                            doubleArrayContainerArray[n9] = ((Element)object).getDownstreamNode().getTSContainer(0);
                        }
                        ++n9;
                    }
                }
                ++n2;
            }
            this.f = n3;
            this.g = n4;
            this.h = n5;
            if (this.h < 0) {
                this.h = 0;
            }
            this.i = n6 - this.h;
            this.r = new double[n][this.i];
            this.j = new double[n][this.i];
            this.k = new double[n][this.i];
            this.G = new double[this.i];
            this.H = new double[this.i];
            this.M = new double[this.i];
            this.N = new double[this.i];
            this.O = new double[this.i];
            this.l = new double[this.i];
            this.m = new double[this.i];
            this.Q = new double[this.i + 1];
            this.s = new double[this.i];
            this.z = new double[n];
            this.A = new double[n];
            this.B = new double[n];
            this.n = new boolean[n];
            this.o = new boolean[n];
            this.C = new boolean[n];
            this.D = new boolean[n];
            this.E = new double[n];
            this.F = new double[n];
            this.I = new double[n];
            this.J = new double[n];
            this.K = new double[n];
            this.L = new double[n];
            this.x = this.b.getTSContainer(0);
            this.w = new Object[n];
            for (int i = 0; i < this.v.length; ++i) {
                Object[] objectArray3;
                objectArray = (Object[])this.v[i];
                for (n = 0; n < objectArray.length; ++n) {
                    objectArray[n] = new double[this.i];
                }
                this.w[i] = objectArray3 = new Object[objectArray.length];
                for (n = 0; n < objectArray3.length; ++n) {
                    objectArray3[n] = new double[this.i];
                }
            }
            this.y = ReservoirSysOp.a(this.a, this.e);
        }
        this.p = false;
        this.q = false;
        Arrays.fill(this.n, false);
        Arrays.fill(this.o, false);
        return 0;
    }

    public void setSystem(RssSystem rssReturnStatusConstants) {
        this.a = rssReturnStatusConstants;
        if (this._ruleTable != null) {
            Enumeration enumeration = this._ruleTable.elements();
            while (enumeration.hasMoreElements()) {
                rssReturnStatusConstants = (DownstreamOpRule)enumeration.nextElement();
                ((OpRule)rssReturnStatusConstants).setSystem(this.a);
            }
        }
    }

    public int initForPulse(RssSystem rssSystem, RssNode rssNode) {
        if (rssSystem == null || rssNode == null) {
            return 1;
        }
        this._nodeIndex = rssNode.getIndex();
        this.a = rssSystem;
        this.b = rssNode;
        if (this.c == null) {
            this.c = new Hashtable();
        } else {
            this.c.clear();
        }
        return 0;
    }

    public int clearForCompute(RssSystem rssReturnStatusConstants, int n) {
        if (this._ruleTable == null || this._ruleTable.isEmpty()) {
            return 0;
        }
        this._nodeIndex = n;
        this.a = rssReturnStatusConstants;
        if (this.a == null) {
            return 1;
        }
        this.b = this.a.getNode(this._nodeIndex);
        if (this.b == null) {
            rssReturnStatusConstants.printErrorMessage("DownstreamOp.initialize: Warning failed initialize, node " + this._nodeIndex + " not found");
            return 0;
        }
        if (this.d == null) {
            this.d = new Hashtable();
        } else {
            this.d.clear();
        }
        this.e = null;
        Enumeration enumeration = this._ruleTable.elements();
        while (enumeration.hasMoreElements()) {
            rssReturnStatusConstants = (DownstreamOpRule)enumeration.nextElement();
            ((DownstreamOpRule)rssReturnStatusConstants).clearForCompute(this.a, this.b, this);
        }
        return 0;
    }

    public int initialize(RssSystem rssReturnStatusConstants, int n, RunTimeWindow runTimeWindow) {
        if (this._ruleTable == null || this._ruleTable.isEmpty()) {
            return 0;
        }
        if (this.a == null) {
            return 1;
        }
        if (this.b == null) {
            return 0;
        }
        Enumeration enumeration = this._ruleTable.elements();
        while (enumeration.hasMoreElements()) {
            rssReturnStatusConstants = (DownstreamOpRule)enumeration.nextElement();
            ((DownstreamOpRule)rssReturnStatusConstants).initialize(this.a, this.b, this, runTimeWindow);
        }
        return 0;
    }

    public int initForPostProcessing(RssSystem rssReturnStatusConstants, int n, RunTimeWindow runTimeWindow) {
        if (this._ruleTable == null || this._ruleTable.isEmpty()) {
            return 0;
        }
        if (this.a == null) {
            return 1;
        }
        if (this.b == null) {
            return 0;
        }
        Enumeration enumeration = this._ruleTable.elements();
        while (enumeration.hasMoreElements()) {
            rssReturnStatusConstants = (DownstreamOpRule)enumeration.nextElement();
            ((DownstreamOpRule)rssReturnStatusConstants).initForPostProcessing(this.a, this.b, this, runTimeWindow);
        }
        return 0;
    }

    public int computePulseResponse(ReservoirElement object, int n, RunTimeStep object2) {
        int n2;
        DownstreamPulseResponse downstreamPulseResponse;
        if (object == null) {
            return 1;
        }
        NamedType namedType = ((Element)object).getChildElementAt(n);
        if (namedType == null || !(namedType instanceof ReservoirOutletElement)) {
            return 1;
        }
        if ((namedType = namedType.getFunction()) == null || !(namedType instanceof PulseRoutingFunction)) {
            return 1;
        }
        namedType = (PulseRoutingFunction)namedType;
        double d = namedType.getPulseQ();
        double d2 = namedType.getOutletQ();
        int n3 = namedType.getPulseStep();
        double[] dArray = this.b.getTSArray(0);
        if (dArray == null) {
            return 1;
        }
        int n4 = ((RunTimeStep)object2).step;
        int n5 = ((RunTimeStep)object2).nstep;
        Hashtable hashtable = (Hashtable)this.c.get(new Integer(object.getIndex()));
        if (hashtable == null) {
            hashtable = new Hashtable();
            this.c.put(new Integer(object.getIndex()), hashtable);
        }
        if ((downstreamPulseResponse = (DownstreamPulseResponse)hashtable.get(n)) == null) {
            downstreamPulseResponse = new DownstreamPulseResponse();
            hashtable.put(n, downstreamPulseResponse);
        }
        hashtable = (Hashtable)new double[n5];
        double d3 = d - d2;
        if (d3 == 0.0) {
            return 1;
        }
        int n6 = n5;
        int n7 = -1;
        int n8 = 0;
        Object object3 = Double.MIN_VALUE;
        for (int i = 0; i < n5; ++i) {
            hashtable[i] = dArray[i + n4] - d2;
            hashtable[i] = hashtable[i] / d3;
            if (!(object3 < hashtable[i])) continue;
            object3 = hashtable[i];
            n8 = i;
        }
        if ((n8 -= n3 + 1) < 0) {
            n8 = 0;
        }
        double[] dArray2 = new double[9];
        dArray = new double[3];
        dArray2[0] = ((double)n8 - 1.0) * ((double)n8 - 1.0);
        dArray2[1] = (double)n8 - 1.0;
        dArray2[2] = 1.0;
        int n9 = n8;
        dArray2[3] = n9 * n9;
        dArray2[4] = n8;
        dArray2[5] = 1.0;
        dArray2[6] = ((double)n8 + 1.0) * ((double)n8 + 1.0);
        dArray2[7] = (double)n8 + 1.0;
        dArray2[8] = 1.0;
        if (n8 + 1 + n3 + 1 >= ((Object)hashtable).length) {
            n4 = n8 + 1 + n3 + 2 - ((Object)hashtable).length;
            int n10 = object2.getTimeStepMinutes();
            if (n10 > 360) {
                if (n4 < 5) {
                    n4 = 5;
                }
            } else if (n4 < 20) {
                n4 = 20;
            }
            RssNode rssNode = this.a.getNode(this._nodeIndex);
            String string = "ResSim ERROR: Downstream Operation...Pulse routing computation from " + ((Element)object).toString() + " to " + rssNode.toString() + " needs a longer Simulation window.\nTry increasing the End time of the Simulation to reflect at least " + n4 + " steps\n";
            System.out.println("DownstreamOp:computePulseResponse()");
            System.out.println(string);
            this.a.printErrorMessage(string);
            return 0;
        }
        dArray[0] = n8 == 0 ? 0.0 : (double)hashtable[n8 - 1 + n3 + 1];
        dArray[1] = (double)hashtable[n8 + n3 + 1];
        if (n8 == n5) {
            dArray[2] = 0.0;
        } else {
            n4 = n8 + 1 + n3 + 1;
            if (n4 >= ((Object)hashtable).length) {
                return 1;
            }
            dArray[2] = (double)hashtable[n4];
        }
        RmaMath.invertMatrix((double[])dArray2);
        double d4 = dArray2[0] * dArray[0] + dArray2[1] * dArray[1] + dArray2[2] * dArray[2];
        double d5 = dArray2[3] * dArray[0] + dArray2[4] * dArray[1] + dArray2[5] * dArray[2];
        double d6 = d4 == 0.0 ? (double)n8 : d5 * -0.5 / d4;
        object2 = this._ruleTable.elements();
        DownstreamOpRule downstreamOpRule = (DownstreamOpRule)object2.nextElement();
        object2 = downstreamOpRule.useDefaultDSOptions() ? this.a.getDefaultDownstreamOptions() : downstreamOpRule.getDownStreamOptions();
        double d7 = object3 * 0.01;
        double d8 = 0.0;
        double d9 = 0.0;
        int n11 = (int)((double)(n3 + 1) + (1.0 + ((DownstreamOptions)object2).getMultiplierRTW()) * d6);
        for (n2 = n3 + 1; n2 < n5; ++n2) {
            d9 += hashtable[n2];
            if (hashtable[n2] > d7) {
                n6 = ((DownstreamOptions)object2).getUseConsiderRTW() ? (n2 <= n11 ? n2 : n11) : n2;
                if (n7 < 0) {
                    n7 = n2;
                }
                d8 += hashtable[n2];
                continue;
            }
            hashtable[n2] = 0.0;
        }
        if (d9 > 1.0) {
            d9 = 1.0;
        }
        if (d9 < 0.0) {
            d9 = 0.0;
        }
        for (n2 = n6 + 1; n2 < n5; ++n2) {
            hashtable[n2] = 0.0;
        }
        if (d8 != 0.0) {
            n2 = n7;
            while (n2 <= n6) {
                Hashtable hashtable2 = hashtable;
                int n12 = n2++;
                hashtable2[n12] = hashtable2[n12] / (d8 * d9);
            }
        }
        double d10 = 1.0;
        if (object3 > 0.0 && d8 > 0.0) {
            d10 = object3 / (d8 * d9);
        }
        int n13 = n6 - n7 + 1;
        double[] dArray3 = new double[n13];
        if (n7 < 0) {
            object = "ResSim ERROR: Downstream Operation. Please check time window and lookback times.  Verify Lookback time is long enough for the compute's time step.\n";
            System.out.println("DownstreamOp:computePulseResponse()");
            System.out.println((String)object);
            this.a.printErrorMessage((String)object);
            return 0;
        }
        System.arraycopy(hashtable, n7, dArray3, 0, n13);
        downstreamPulseResponse.a(object.getIndex());
        downstreamPulseResponse.b(n);
        downstreamPulseResponse.d(n13);
        downstreamPulseResponse.c(n7 - (n3 + 1));
        downstreamPulseResponse.e(n8);
        downstreamPulseResponse.c(d6);
        downstreamPulseResponse.a(dArray3);
        downstreamPulseResponse.b(d10);
        downstreamPulseResponse.a(d9);
        return 0;
    }

    public void removeRuleRef(DownstreamCntrlOpRule downstreamCntrlOpRule) {
        if (downstreamCntrlOpRule == null) {
            return;
        }
        if (this._ruleTable == null) {
            return;
        }
        Serializable serializable = new Integer(downstreamCntrlOpRule.getParentRuleIndex());
        if ((serializable = (DownstreamOpRule)this._ruleTable.get(serializable)) == null) {
            return;
        }
        ((DownstreamOpRule)serializable).removeRuleRef(downstreamCntrlOpRule);
    }

    public boolean isRuleTableEmpty() {
        if (this._ruleTable == null) {
            return true;
        }
        return this._ruleTable.isEmpty();
    }

    public DownstreamOpRule addRule(DownstreamCntrlOpRule downstreamCntrlOpRule) {
        DownstreamOpRule downstreamOpRule;
        if (downstreamCntrlOpRule == null) {
            return null;
        }
        if (this._ruleTable == null) {
            this._ruleTable = new Hashtable();
        }
        if ((downstreamOpRule = this.getDownstreamOpRule(downstreamCntrlOpRule.getParentRuleIndex())) == null) {
            downstreamOpRule = new DownstreamOpRule(downstreamCntrlOpRule.getName());
            downstreamOpRule.setIndex(this._nextRuleIndex);
            this._ruleTable.put(this._nextRuleIndex, downstreamOpRule);
            ++this._nextRuleIndex;
        }
        downstreamOpRule.copyChildInto(downstreamCntrlOpRule);
        downstreamCntrlOpRule.setParentRuleIndex(downstreamOpRule.getIndex());
        return downstreamOpRule;
    }

    public void dispose() {
        if (this._ruleTable == null) {
            return;
        }
        this._ruleTable.clear();
        this._ruleTable = null;
    }

    public DownstreamOpRule removeRule(int n) {
        if (this._ruleTable == null) {
            return null;
        }
        DownstreamOpRule downstreamOpRule = (DownstreamOpRule)this._ruleTable.remove(n);
        return downstreamOpRule;
    }

    public DownstreamOpRule getDownstreamOpRule(String string) {
        if (this._ruleTable == null) {
            return null;
        }
        Enumeration enumeration = this._ruleTable.elements();
        while (enumeration.hasMoreElements()) {
            DownstreamOpRule downstreamOpRule = (DownstreamOpRule)enumeration.nextElement();
            if (!downstreamOpRule.getName().equals(string)) continue;
            return downstreamOpRule;
        }
        return null;
    }

    public DownstreamOpRule getDownstreamOpRule(int n) {
        if (this._ruleTable == null) {
            return null;
        }
        DownstreamOpRule downstreamOpRule = (DownstreamOpRule)this._ruleTable.get(n);
        return downstreamOpRule;
    }

    public Vector getRules(Vector vector) {
        if (vector == null) {
            vector = new Vector();
        }
        if (this._ruleTable == null) {
            return vector;
        }
        Enumeration enumeration = this._ruleTable.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (vector.contains(v)) continue;
            vector.add(v);
        }
        return vector;
    }

    public Object getFieldObject(Field object) {
        try {
            object = ((Field)object).get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }
}

