/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.heclib.util.HecTime;
import hec.heclib.util.doubleArrayContainer;
import hec.model.PairedValues;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.model.SeasonalRecord;
import hec.rss.model.DayOfWeekMultiplier;
import hec.rss.model.DecisionEngine;
import hec.rss.model.DownstreamCntrlOpRule;
import hec.rss.model.DownstreamOp;
import hec.rss.model.DownstreamOpRuleBackRoute;
import hec.rss.model.DownstreamOptions;
import hec.rss.model.DownstreamPulseResponse;
import hec.rss.model.Element;
import hec.rss.model.IndependentVariable;
import hec.rss.model.Junction;
import hec.rss.model.JunctionElement;
import hec.rss.model.OpController;
import hec.rss.model.OpRule;
import hec.rss.model.OpSet;
import hec.rss.model.OpValue;
import hec.rss.model.ReleaseFuncOpRule;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOp;
import hec.rss.model.ReservoirSysOp;
import hec.rss.model.RssNode;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.Storage;
import hec.rss.model.StorageZone;
import hec.rss.model.SystemStorageDefinition;
import hec.rss.model.TimeOfDayMultiplier;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import rma.lang.RmaMath;
import rma.util.RMAConst;

public class DownstreamOpRule
extends ReleaseFuncOpRule {
    public static final String FLOW_PARAMETER_STR = "Flow";
    public static final String STAGE_PARAMETER_STR = "Stage";
    public static int a = 1;
    public static int b = 2;
    public static int c = 0;
    public static int d = 1;
    int _downstreamCntrlParam = a;
    int _downstreamLocationID = Integer.MIN_VALUE;
    private boolean _useContingency = false;
    private int _contingencyType = c;
    private double _contingencyConst = Double.NEGATIVE_INFINITY;
    private PairedValues _contingencyPV = new PairedValues();
    private boolean _useDefaultOptions = true;
    public DownstreamOptions _downstreamOptions = new DownstreamOptions();
    private transient DownstreamOp j;
    private transient List<DownstreamCntrlOpRule> k;
    private transient RssNode l;
    private transient Junction m;
    private transient doubleArrayContainer n;
    private transient doubleArrayContainer o;
    private transient SystemStorageDefinition p;
    transient ReservoirElement[] e;
    private transient boolean[] q;
    private transient Object[] r;
    private transient Object[] s;
    private transient Object[] t;
    private transient Object[] u;
    private transient Object[] v;
    double _lambda;
    private transient doubleArrayContainer w;
    private transient DownstreamCntrlOpRule[] x;
    @Deprecated
    private transient int[] y;
    @Deprecated
    private transient int z;
    @Deprecated
    private transient int A;
    transient double[] f;
    private transient int B;
    private transient int C;
    private transient int D;
    private transient double[] E;
    private transient double[] F;
    private transient double[] G;
    private transient boolean[] H;
    private transient doubleArrayContainer[] I;
    private transient doubleArrayContainer[] J;
    private transient Object[] K;
    private transient Object[] L;
    private transient Object[] M;
    private transient Object[] N;
    private transient double[] O;
    private transient double[][] P;
    private transient double[][] Q;
    private transient double[][] R;
    private transient double[][] S;
    private transient double[] T;
    private transient double[] U;
    private transient double[] V;
    private transient double[][] W;
    private transient double[][] X;
    private transient Object[] Y;
    private transient double[] Z;
    private transient double[] aa;
    private transient boolean[] ab;
    private transient double[] ac;
    private transient double[] ad;
    private transient double[] ae;
    private transient double[] af;
    private transient double[] ag;
    private transient double[] ah;
    private transient doubleArrayContainer[] ai;
    private transient doubleArrayContainer aj;
    private transient doubleArrayContainer ak;
    private transient doubleArrayContainer[] al;
    private transient Object[] am;
    private transient Object[] an;
    private transient Object[] ao;
    private transient DownstreamOptions ap;
    private transient Map<Element, boolean[]> aq;
    private transient Map<Element, boolean[]> ar;
    private transient DownstreamOpRuleBackRoute as;
    PrintWriter _convergWriter = null;
    boolean[] _allocActive;
    private double[] _curRelease;
    private double[] _allocMax;
    private double[] _allocMin;
    private double[] _allocRelease;
    private double[] _allocFac;
    private boolean[] _minLimited;
    private boolean[] _maxLimited;
    private boolean[] _tbActive;
    private boolean[] _specLimited;
    double[] _balanceStor2;

    public DownstreamOpRule() {
    }

    public DownstreamOpRule(String string) {
        super(string);
    }

    @Override
    public void evaulatePerformance(RunTimeWindow runTimeWindow) {
        int n;
        int n2;
        if (this.e == null || this.e.length <= 0) {
            return;
        }
        int n3 = this.e.length;
        RssSystem rssSystem = ((RssTSLocationObject)this).getSystem();
        for (int i = 0; i < n3; ++i) {
            this.H[i] = true;
        }
        RunTimeWindow runTimeWindow2 = runTimeWindow;
        RunTimeStep runTimeStep = runTimeWindow2.getRunTimeStepAtTime(runTimeWindow2.getLookbackTime());
        runTimeStep.getTimeStepSeconds();
        HecTime hecTime = runTimeStep.getHecTime();
        hecTime.secondsSinceMidnight();
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        int n4 = runTimeWindow.getNumSteps();
        double[] dArray3 = new double[n3];
        double[] dArray4 = new double[n3];
        for (n2 = 0; n2 <= n4; ++n2) {
            runTimeStep.step = n2;
            for (n = 0; n < n3; ++n) {
                dArray3[n] = this.e[n].getStorageFunction().getStorage(runTimeStep);
            }
            ReservoirSysOp.a(rssSystem, this.e, this.H, runTimeStep, this.p, dArray3, dArray4, 0.0, dArray, dArray2);
            this.ak.array[n2] = dArray2[0];
            for (n = 0; n < n3; ++n) {
                this.ai[n].array[n2] = dArray4[n];
            }
        }
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < n3; ++i) {
                this.H[i] = false;
            }
            this.H[n] = true;
            SystemStorageDefinition systemStorageDefinition = ReservoirSysOp.a(rssSystem, this.e, this.H);
            for (n2 = 0; n2 <= n4; ++n2) {
                int n5;
                runTimeStep.step = n2;
                dArray3[n] = this.e[n].getStorageFunction().getStorage(runTimeStep);
                ReservoirSysOp.a(rssSystem, this.e, this.H, runTimeStep, systemStorageDefinition, dArray3, dArray4, 0.0, dArray, dArray2);
                this.al[n].array[n2] = dArray2[0];
                Hashtable hashtable = this.j.getResPulseTable(this.e[n].getIndex());
                if (hashtable == null || hashtable.size() <= 0 || (n5 = hashtable.size()) <= 0) continue;
                for (int i = 0; i < n5; ++i) {
                    DownstreamPulseResponse[] downstreamPulseResponseArray = (DownstreamPulseResponse[])this.s[n];
                    if (downstreamPulseResponseArray == null) {
                        return;
                    }
                    doubleArrayContainer[] doubleArrayContainerArray = (doubleArrayContainer[])this.am[n];
                    doubleArrayContainerArray[i].array[n2] = downstreamPulseResponseArray[i].i() * (double)runTimeWindow.getTimeStepMinutes();
                    doubleArrayContainerArray = (doubleArrayContainer[])this.an[n];
                    doubleArrayContainerArray[i].array[n2] = downstreamPulseResponseArray[i].f() * runTimeWindow.getTimeStepMinutes();
                    doubleArrayContainerArray = (doubleArrayContainer[])this.ao[n];
                    doubleArrayContainerArray[i].array[n2] = (downstreamPulseResponseArray[i].f() + downstreamPulseResponseArray[i].g()) * runTimeWindow.getTimeStepMinutes();
                }
            }
        }
    }

    public void closeForecast() {
        if (this._convergWriter != null) {
            this._convergWriter.close();
            this._convergWriter = null;
        }
    }

    void getDistributedCorrection(RunTimeStep object, double[] dArray, DecisionEngine decisionEngine, RunTimeStep runTimeStep, int n) {
        Object object2;
        if (this._convergWriter == null && RssSystem.d) {
            try {
                String string = String.format("resSimDnstrmRule-%s.out", this.getName());
                this._convergWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
                object2 = "startRts\ticnt\trts.step\tcorrection";
                ReservoirElement[] reservoirElementArray = this.e;
                int n2 = this.e.length;
                for (int i = 0; i < n2; ++i) {
                    ReservoirElement reservoirElement = reservoirElementArray[i];
                    string = reservoirElement.getName();
                    object2 = String.format("%s\t%s-Stor\t%s-Correct", object2, string, string, string);
                }
                this._convergWriter.println((String)object2);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        double d = ((ReleaseFuncOpRule)this).getLimitValue((RunTimeStep)object);
        double d2 = this.w.array[object.step];
        if (!RMAConst.isValidValue((double)d2)) {
            d2 = this.w.array[object.step - 1];
        }
        if (!RMAConst.isValidValue((double)d2)) {
            d2 = this.w.array[runTimeStep.step - 1];
        }
        double d3 = d - d2;
        object2 = new RunTimeStep(object);
        for (int i = 0; i < this.e.length; ++i) {
            object2.step = object.step - this.getResIntLag(i);
            if (object2.step < 0) {
                object2.step = 0;
            }
            Storage storage = this.e[i].getStorageFunction();
            double d4 = storage.getElevationEst33((RunTimeStep)object2);
            this.ac[i] = storage.elevationToStorage(d4);
        }
        Element element = this.l.getUpstreamElement();
        this.distributeCorrectionToElement2((RunTimeStep)object, element, d3, dArray, decisionEngine, runTimeStep, n);
        if (this._convergWriter != null) {
            object = String.format("%d\t%d\t%d\t%.4f", runTimeStep.step, n, object.step, d3);
            int n3 = this.e.length;
            for (int i = 0; i < n3; ++i) {
                object = String.format("%s\t%.4f\t%.4f", object, this.ac[i], dArray[i]);
            }
            this._convergWriter.println((String)object);
        }
    }

    public int getResIntLag(int n) {
        return (int)(this.f[n] + 0.5);
    }

    void distributeCorrectionToElement(RunTimeStep runTimeStep, Element element, double d, double[] dArray, DecisionEngine decisionEngine, RunTimeStep runTimeStep2, int n) {
        double d2;
        double d3;
        double d4;
        int n2;
        int n3;
        int n4 = this.e.length;
        if (this._allocActive == null || this._allocActive.length != n4) {
            this._allocActive = new boolean[n4];
        }
        if (Math.abs(d) <= 1.0E-8) {
            d = 0.0;
        }
        double[] dArray2 = new double[n4];
        if (n4 == 1) {
            dArray[0] = d;
            return;
        }
        boolean[] blArray = this.ar.get(element);
        boolean[] blArray2 = this.aq.get(element);
        int n5 = 0;
        double d5 = 0.0;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = runTimeStep.step - this.getResIntLag(n3) >= runTimeStep2.step ? 1 : 0;
            this.H[n3] = blArray2[n3] && !this.q[n3] && n2 != 0;
            boolean bl = this._allocActive[n3] = blArray2[n3] && n2 != 0;
            if (this.H[n3]) {
                ++n5;
            }
            if (this.q[n3]) {
                dArray2[n3] = d4 = this.e[n3].getGuideCurveStorage(runTimeStep);
                d5 += d4 - this.ac[n3];
                continue;
            }
            if (n2 != 0) continue;
            dArray2[n3] = this.ac[n3];
        }
        if (n5 == 0) {
            return;
        }
        d4 = d * (double)runTimeStep.getTimeStepSeconds() / Storage.DSDT_TO_Q + d5;
        n3 = 0;
        while (n3 == 0) {
            int n6;
            ReservoirSysOp.a(this.g, this.e, this.H, runTimeStep, this.p, this.ac, dArray2, -d4);
            d3 = 0.0;
            int n7 = 0;
            for (n3 = 0; n3 < n4; ++n3) {
                if (!blArray[n3] || !this._allocActive[n3]) continue;
                ++n7;
                dArray[n3] = 0.0;
                boolean[] blArray3 = this.aq.get(this.e[n3]);
                if (blArray3 == null) continue;
                for (n6 = 0; n6 < n4; ++n6) {
                    if (n3 != n6 && !blArray3[n6]) continue;
                    int n8 = n3;
                    dArray[n8] = dArray[n8] + (this.ac[n6] - dArray2[n6]) / (double)runTimeStep.getTimeStepSeconds() * Storage.DSDT_TO_Q;
                }
                d3 += dArray[n3];
            }
            if (d3 != d) {
                if (d3 != 0.0 && d != 0.0 && Math.abs(d3) > 1.0E-8) {
                    double d6 = d / d3;
                    for (n3 = 0; n3 < n4; ++n3) {
                        if (!blArray[n3] || !this._allocActive[n3]) continue;
                        int n9 = n3;
                        dArray[n9] = dArray[n9] * d6;
                    }
                } else {
                    d2 = (d - d3) / (double)n7;
                    for (n3 = 0; n3 < n4; ++n3) {
                        if (!blArray[n3] || !this._allocActive[n3]) continue;
                        int n10 = n3;
                        dArray[n10] = dArray[n10] + d2;
                    }
                }
            }
            n2 = this.testBalanceCorrection(blArray, this._allocActive, dArray, runTimeStep, decisionEngine);
            n3 = 1;
            if (n2 <= 0) continue;
            for (n6 = 0; n6 < n4; ++n6) {
                if (!this._minLimited[n6] && !this._maxLimited[n6]) continue;
                d -= dArray[n6];
                d4 -= dArray[n6] * (double)runTimeStep.getTimeStepSeconds() / Storage.DSDT_TO_Q;
                boolean[] blArray4 = this.aq.get(this.e[n6]);
                if (blArray4 == null) continue;
                for (n2 = 0; n2 < n4; ++n2) {
                    if (n6 != n2 && !blArray4[n2]) continue;
                    this._allocActive[n2] = false;
                    this.H[n2] = false;
                    if (--n5 <= 0) continue;
                    n3 = 0;
                }
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (!blArray[n3]) continue;
            boolean[] blArray5 = this.aq.get(this.e[n3]);
            n5 = 0;
            d5 = 0.0;
            for (int i = 0; i < n4; ++i) {
                n2 = runTimeStep.step - this.getResIntLag(i) >= runTimeStep2.step ? 1 : 0;
                boolean bl = this.H[i] = blArray5[i] && !this.q[i] && n2 != 0;
                if (n3 == i && !this.q[i] && n2 != 0) {
                    this.H[i] = true;
                }
                if (this.H[i]) {
                    ++n5;
                }
                if (this.q[i] && (blArray5[i] || n3 == i)) {
                    dArray2[i] = d2 = this.e[i].getGuideCurveStorage(runTimeStep);
                    d5 += d2 - this.ac[i];
                    continue;
                }
                if (n2 != 0) continue;
                dArray2[i] = this.ac[i];
            }
            if (n5 > 0) {
                d4 = dArray[n3] * (double)runTimeStep.getTimeStepSeconds() / Storage.DSDT_TO_Q + d5;
                ReservoirSysOp.a(this.g, this.e, this.H, runTimeStep, this.p, this.ac, dArray2, -d4);
            }
            d3 = dArray[n3] - (this.ac[n3] - dArray2[n3]) / (double)runTimeStep.getTimeStepSeconds() * Storage.DSDT_TO_Q;
            this.distributeCorrectionToElement(runTimeStep, this.e[n3], d3, dArray, decisionEngine, runTimeStep2, n);
        }
    }

    int testBalanceCorrection(boolean[] blArray, boolean[] blArray2, double[] dArray, RunTimeStep runTimeStep, DecisionEngine decisionEngine) {
        int n;
        int n2 = this.e.length;
        if (this._curRelease == null || this._curRelease.length != n2) {
            this._curRelease = new double[n2];
            this._allocMax = new double[n2];
            this._allocMin = new double[n2];
            this._allocRelease = new double[n2];
            this._allocFac = new double[n2];
            this._minLimited = new boolean[n2];
            this._maxLimited = new boolean[n2];
            this._tbActive = new boolean[n2];
        }
        RunTimeStep runTimeStep2 = new RunTimeStep(runTimeStep);
        int n3 = 0;
        double d = 0.0;
        double d2 = 0.0;
        int n4 = 0;
        double d3 = 100.0;
        for (n = 0; n < n2; ++n) {
            if (!blArray[n] || !blArray2[n]) continue;
            runTimeStep2.step = runTimeStep.step - this.getResIntLag(n);
            if (runTimeStep2.step < 0) {
                runTimeStep2.step = 0;
            }
            DownstreamOpRule downstreamOpRule = this;
            decisionEngine.a(downstreamOpRule, downstreamOpRule.e[n], runTimeStep2, this._allocMin, this._allocMax, this._curRelease, n);
            d += this._curRelease[n];
            d2 += dArray[n];
            ++n4;
            if (!(d3 < -(this._curRelease[n] + dArray[n] - 100.0))) continue;
            d3 = -(this._curRelease[n] + dArray[n] - 100.0);
        }
        if (n4 == 0) {
            return 0;
        }
        double d4 = d + d2 + (double)n4 * d3;
        for (n = 0; n < n2; ++n) {
            this._tbActive[n] = false;
            this._minLimited[n] = false;
            this._maxLimited[n] = false;
            if (!blArray[n] || !blArray2[n]) continue;
            int n5 = n;
            this._allocMin[n5] = this._allocMin[n5] + d3;
            int n6 = n;
            this._allocMax[n6] = this._allocMax[n6] + d3;
            this._allocFac[n] = d4 != 0.0 ? (this._curRelease[n] + dArray[n] + d3) / d4 : this._curRelease[n] + dArray[n] + d3;
            this._tbActive[n] = true;
        }
        RmaMath.balancedDistribution((double)d4, (double[])this._allocRelease, (double[])this._allocFac, (double[])this._allocMin, (double[])this._allocMax, (double)1.0E-8, (boolean[])this._tbActive, (boolean[])this._minLimited, (boolean[])this._maxLimited);
        for (n = 0; n < n2; ++n) {
            if (!this._tbActive[n]) continue;
            if (this._minLimited[n] || this._maxLimited[n]) {
                ++n3;
            }
            dArray[n] = this._allocRelease[n] - this._curRelease[n] - d3;
        }
        return n3;
    }

    void distributeCorrectionToElement2(RunTimeStep runTimeStep, Element element, double d, double[] dArray, DecisionEngine decisionEngine, RunTimeStep runTimeStep2, int n) {
        double d2;
        int n2;
        int n3 = this.e.length;
        boolean[] blArray = new boolean[n3];
        boolean[] blArray2 = new boolean[n3];
        if (this._balanceStor2 == null || this._balanceStor2.length != n3) {
            this._balanceStor2 = new double[n3];
        }
        if (Math.abs(d) <= 1.0E-8) {
            d = 0.0;
        }
        if (n3 == 1) {
            dArray[0] = d;
            return;
        }
        boolean[] blArray3 = this.ar.get(element);
        boolean[] blArray4 = this.aq.get(element);
        int n4 = 0;
        double d3 = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            boolean bl = runTimeStep.step - this.getResIntLag(n2) >= runTimeStep2.step;
            boolean bl2 = blArray4[n2];
            if (this.e[n2] == element) {
                bl2 = true;
            }
            blArray[n2] = bl2 && bl && !this.q[n2];
            boolean bl3 = blArray2[n2] = bl2 && bl;
            if (blArray[n2]) {
                ++n4;
            }
            if (this.q[n2] && bl2 && bl) {
                this._balanceStor2[n2] = d2 = this.e[n2].getGuideCurveStorage(runTimeStep);
                d3 += d2 - this.ac[n2];
                continue;
            }
            if (bl) continue;
            this._balanceStor2[n2] = this.ac[n2];
        }
        if (n4 == 0) {
            return;
        }
        d2 = d * (double)runTimeStep.getTimeStepSeconds() / Storage.DSDT_TO_Q + d3;
        boolean bl = false;
        while (!bl) {
            boolean[] blArray5;
            int n5;
            ReservoirSysOp.a(this.g, this.e, blArray, runTimeStep, this.p, this.ac, this._balanceStor2, -d2);
            for (n2 = 0; n2 < n3; ++n2) {
                if (!blArray2[n2]) continue;
                dArray[n2] = 0.0;
                boolean[] blArray6 = this.aq.get(this.e[n2]);
                if (blArray6 == null) continue;
                for (n5 = 0; n5 < n3; ++n5) {
                    if (n2 != n5 && !blArray6[n5]) continue;
                    int n6 = n2;
                    dArray[n6] = dArray[n6] + (this.ac[n5] - this._balanceStor2[n5]) / (double)runTimeStep.getTimeStepSeconds() * Storage.DSDT_TO_Q;
                }
            }
            if (this._curRelease == null || this._curRelease.length != n3) {
                this._minLimited = new boolean[n3];
                this._maxLimited = new boolean[n3];
                this._specLimited = new boolean[n3];
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this._minLimited[n2] = false;
                this._maxLimited[n2] = false;
                this._specLimited[n2] = false;
            }
            if (element instanceof ReservoirElement) {
                blArray5 = new boolean[this.e.length];
                for (n5 = 0; n5 < n3; ++n5) {
                    if (this.e[n5] != element) continue;
                    blArray5[n5] = true;
                }
            } else {
                blArray5 = blArray3;
            }
            n5 = this.testBalanceCorrection2(blArray5, blArray, dArray, runTimeStep, decisionEngine, false);
            bl = true;
            if (n5 <= 0) continue;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            this.findMostDownstreamSpecLimited(arrayList, blArray, element);
            int n7 = 0;
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                int n8 = (Integer)arrayList.get(n2);
                this.distributeCorrectionToElement2(runTimeStep, this.e[n8], dArray[n8], dArray, decisionEngine, runTimeStep2, n);
                boolean[] blArray7 = this.aq.get(this.e[n8]);
                if (blArray7 == null) continue;
                for (n7 = 0; n7 < n3; ++n7) {
                    if (n8 != n7 && !blArray7[n7]) continue;
                    --n4;
                    blArray[n7] = false;
                    double cfr_ignored_0 = dArray[n7];
                    d2 -= dArray[n7] * (double)runTimeStep.getTimeStepSeconds() / Storage.DSDT_TO_Q;
                }
                n7 = 1;
            }
            if (n7 == 0) {
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                this.findMostDownstreamMinMaxLimited(arrayList2, blArray, element);
                for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                    int n9 = (Integer)arrayList2.get(n2);
                    this.distributeCorrectionToElement2(runTimeStep, this.e[n9], dArray[n9], dArray, decisionEngine, runTimeStep2, n);
                    boolean[] blArray8 = this.aq.get(this.e[n9]);
                    if (blArray8 == null) continue;
                    for (int i = 0; i < n3; ++i) {
                        if (n9 != i && !blArray8[i]) continue;
                        --n4;
                        blArray[i] = false;
                        double cfr_ignored_1 = dArray[i];
                        d2 -= dArray[i] * (double)runTimeStep.getTimeStepSeconds() / Storage.DSDT_TO_Q;
                    }
                }
            }
            if (n4 <= 0) continue;
            bl = false;
        }
    }

    int testBalanceCorrection2(boolean[] blArray, boolean[] blArray2, double[] dArray, RunTimeStep runTimeStep, DecisionEngine decisionEngine, boolean bl) {
        int n;
        int n2 = this.e.length;
        if (this._curRelease == null || this._curRelease.length != n2) {
            this._curRelease = new double[n2];
            this._allocMax = new double[n2];
            this._allocMin = new double[n2];
            this._allocRelease = new double[n2];
            this._allocFac = new double[n2];
            this._tbActive = new boolean[n2];
        }
        Object object = new RunTimeStep(runTimeStep);
        double d = 0.0;
        double d2 = 0.0;
        int n3 = 0;
        double d3 = 100.0;
        for (n = 0; n < n2; ++n) {
            if (!blArray2[n]) continue;
            object.step = runTimeStep.step - this.getResIntLag(n);
            if (object.step < 0) {
                object.step = 0;
            }
            DownstreamOpRule downstreamOpRule = this;
            decisionEngine.a(downstreamOpRule, downstreamOpRule.e[n], (RunTimeStep)object, this._allocMin, this._allocMax, this._curRelease, n);
            if (!blArray[n]) continue;
            d += this._curRelease[n];
            d2 += dArray[n];
            ++n3;
            if (!(d3 < -(this._curRelease[n] + dArray[n] - 100.0))) continue;
            d3 = -(this._curRelease[n] + dArray[n] - 100.0);
        }
        if (n3 == 0) {
            return 0;
        }
        double d4 = d + d2 + (double)n3 * d3;
        for (n = 0; n < n2; ++n) {
            this._tbActive[n] = false;
            if (!blArray[n] || !blArray2[n]) continue;
            int n4 = n;
            this._allocMin[n4] = this._allocMin[n4] + d3;
            int n5 = n;
            this._allocMax[n5] = this._allocMax[n5] + d3;
            this._allocFac[n] = d4 != 0.0 ? (this._curRelease[n] + dArray[n] + d3) / d4 : this._curRelease[n] + dArray[n] + d3;
            this._tbActive[n] = true;
        }
        object = new boolean[n2];
        boolean[] blArray3 = new boolean[n2];
        RmaMath.balancedDistribution((double)d4, (double[])this._allocRelease, (double[])this._allocFac, (double[])this._allocMin, (double[])this._allocMax, (double)1.0E-8, (boolean[])this._tbActive, (boolean[])object, (boolean[])blArray3);
        int n6 = 0;
        double d5 = 0.0;
        double d6 = 0.0;
        String string = null;
        for (n = 0; n < n2; ++n) {
            if (!this._tbActive[n]) continue;
            this._minLimited[n] = object[n];
            this._maxLimited[n] = blArray3[n];
            if (this._minLimited[n] || this._maxLimited[n]) {
                ++n6;
                if (Math.abs(this._allocMin[n] - this._allocMax[n]) < 0.001) {
                    this._specLimited[n] = true;
                }
            }
            if (n3 == 1) {
                d5 = dArray[n];
            }
            dArray[n] = this._allocRelease[n] - this._curRelease[n] - d3;
            if (n3 != 1) continue;
            d6 = dArray[n];
            string = this.e[n].getName();
        }
        int n7 = n = Math.abs(d5 - d6) < 0.01 ? 1 : 0;
        if (n6 == 1 && n3 == 1 && !bl) {
            if (n != 0) {
                n6 = 0;
            } else {
                System.out.println("Error with res balancing and testing");
                System.out.println("RTS = " + String.valueOf(runTimeStep.step) + " Res = " + string);
                n6 = 0;
            }
        }
        for (n = 0; n < n2; ++n) {
            if (!blArray[n]) continue;
            boolean[] blArray4 = this.ar.get(this.e[n]);
            n6 += this.testBalanceCorrection2(blArray4, blArray2, dArray, runTimeStep, decisionEngine, true);
        }
        return n6;
    }

    private void findMostDownstreamSpecLimited(List<Integer> list, boolean[] blArray, Element object) {
        int n;
        object = this.ar.get(object);
        for (n = 0; n < this.e.length; ++n) {
            if (!blArray[n] || object[n] == false || !this._specLimited[n]) continue;
            list.add(n);
        }
        for (n = 0; n < this.e.length; ++n) {
            if (object[n] == false || list.contains(n)) continue;
            this.findMostDownstreamSpecLimited(list, blArray, this.e[n]);
        }
    }

    private void findMostDownstreamMinMaxLimited(List<Integer> list, boolean[] blArray, Element object) {
        int n;
        object = this.ar.get(object);
        for (n = 0; n < this.e.length; ++n) {
            if (!blArray[n] || object[n] == false || !this._minLimited[n] && !this._maxLimited[n]) continue;
            list.add(n);
        }
        for (n = 0; n < this.e.length; ++n) {
            if (object[n] == false || list.contains(n)) continue;
            this.findMostDownstreamMinMaxLimited(list, blArray, this.e[n]);
        }
    }

    private void estResRuleConstraints3x(RunTimeStep runTimeStep, int n, int n2) {
        double d;
        if (!this.H[n]) {
            return;
        }
        new OpValue();
        int cfr_ignored_0 = this.e.length;
        this.k.get(n);
        ReservoirOp reservoirOp = this.e[n].getReservoirOp(false);
        DownstreamPulseResponse[] downstreamPulseResponseArray = (DownstreamPulseResponse[])this.s[n];
        int n3 = downstreamPulseResponseArray.length;
        this.Z[n] = d = reservoirOp.getController().getCurMaxOpValue((RunTimeStep)runTimeStep).value;
        double d2 = reservoirOp.getController().getCurMinOpValue((RunTimeStep)runTimeStep).value;
        int n4 = n;
        this.aa[n4] = this.aa[n4] + d2;
        if (this.ap._useConsiderROC) {
            Object object = this.e[n].getStorageFunction();
            double d3 = ((Storage)object).getPreviousElevation(runTimeStep);
            object = reservoirOp.getActiveOpSet().getActiveZone(d3, runTimeStep);
            List list = null;
            if (object != null) {
                list = ((StorageZone)object).getActiveRules(runTimeStep, null);
            }
            object = new double[1];
            double[] dArray = new double[1];
            for (int i = 0; i < n3; ++i) {
                OpController opController = n3 == 1 ? reservoirOp.getController() : reservoirOp.getController(this.e[n].getChildElementAt(downstreamPulseResponseArray[i].a));
                this.I[n].array[i] = opController.getDecrROCLimit(runTimeStep, (double[])object, dArray, d3, list);
                this.J[n].array[i] = opController.getIncrROCLimit(runTimeStep, (double[])object, dArray, d3, list);
            }
        }
    }

    public void evaluateSysLimits(RunTimeStep runTimeStep, int n) {
        int n2;
        RunTimeStep runTimeStep2 = new RunTimeStep(runTimeStep);
        int n3 = runTimeStep.getTotalNumSteps();
        for (n2 = 0; n2 < this.C; ++n2) {
            runTimeStep2.setStep(this.calcTSstep(runTimeStep, n2));
            if (runTimeStep2.step > n3) {
                runTimeStep2.step = n3;
            }
            this.T[n2] = ((ReleaseFuncOpRule)this).getLimitValue(runTimeStep2);
        }
        this.evaluateBaseFlow(runTimeStep);
        double d = 1.0;
        if (this.getLimitType() == -1) {
            d = -1.0;
        }
        double d2 = 1.0;
        if (this._useContingency && this._contingencyType == c) {
            d2 = 1.0 + d * this._contingencyConst / 100.0;
        }
        for (n2 = 0; n2 < this.C; ++n2) {
            int n4 = this.calcTSstep(runTimeStep, n2);
            if (this._useContingency && this._contingencyType == DownstreamOpRule.d && this._contingencyPV != null) {
                d2 = 1.0 + d * this._contingencyPV.interpolate(this.U[n2]) / 100.0;
            }
            this.V[n2] = this.T[n2] - this.U[n2] * d2;
            double d3 = this.V[n2];
            if (d3 == Double.NEGATIVE_INFINITY) {
                d3 = -3.4028234663852886E38;
            }
            if (!(this.n != null & n2 > 0 & n4 <= n3)) continue;
            this.n.array[n4] = d3;
        }
    }

    public void evaluateSysBalance(RunTimeStep runTimeStep, int n) {
        int n2;
        this.determineActiveReservoirs(runTimeStep);
        runTimeStep.getTotalNumSteps();
        int n3 = this.e.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.estResRuleConstraints(runTimeStep, n2, n);
        }
        boolean bl = true;
        for (int i = 0; bl && i < 3; ++i) {
            this.evaluateReleases(runTimeStep);
            bl = false;
            for (n2 = 0; n2 < n3; ++n2) {
                double[][] dArray = (double[][])this.M[n2];
                int n4 = dArray.length;
                for (n = 0; n < n4; ++n) {
                    this.determineRelease(n2, n, runTimeStep);
                    if (!this.hasROCconstraint(n2, n) || !this.ap._useConsiderROC || !this.modForROCconstraint(runTimeStep, n2, n)) continue;
                    bl = true;
                }
            }
        }
        this.assignReleases(runTimeStep);
    }

    List<DownstreamCntrlOpRule> getChildRuleList() {
        return this.k;
    }

    public int getNumRouteSteps() {
        return this.C + this.B;
    }

    @Override
    public TSRecordProxy getTargetTSRecordProxy() {
        RssReturnStatusConstants rssReturnStatusConstants = ((RssTSLocationObject)this).getSystem();
        rssReturnStatusConstants = ((RssSystem)rssReturnStatusConstants).getNode(this.getDownstreamControlLocationID());
        rssReturnStatusConstants = this.getParameterType() == b ? ((RssNode)rssReturnStatusConstants).getTSRecordProxy(2) : ((RssNode)rssReturnStatusConstants).getTSRecordProxy(0);
        return rssReturnStatusConstants;
    }

    public List<ReservoirElement> getReservoirs(List<ReservoirElement> list) {
        if (list == null) {
            list = new ArrayList<ReservoirElement>();
        }
        if (this.e == null) {
            return list;
        }
        int n = this.e.length;
        for (int i = 0; i < n; ++i) {
            if (this.e[i] == null) continue;
            list.add(this.e[i]);
        }
        return list;
    }

    public boolean[] getReservoirPassThru() {
        return this.q;
    }

    private int calcTSstep(RunTimeStep runTimeStep, int n) {
        return runTimeStep.step + this.B + n - 1;
    }

    private double getDecrROCLimit(RunTimeStep runTimeStep) {
        int n = this.e.length;
        double d = 0.0;
        double d2 = 0.0;
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        for (int i = 0; i < n; ++i) {
            ReservoirOp reservoirOp = this.e[i].getReservoirOp();
            reservoirOp.getDecrROCLimit(runTimeStep, dArray, dArray2);
            d += dArray[0];
            if (dArray2[0] == Double.NEGATIVE_INFINITY) continue;
            d2 = Math.max(d2, dArray2[0]);
        }
        double d3 = d2 == 0.0 ? Double.NEGATIVE_INFINITY : d / d2;
        return d3;
    }

    private double getIncrROCLimit(RunTimeStep runTimeStep) {
        int n = this.e.length;
        double d = 0.0;
        double d2 = 0.0;
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        for (int i = 0; i < n; ++i) {
            ReservoirOp reservoirOp = this.e[i].getReservoirOp();
            reservoirOp.getIncrROCLimit(runTimeStep, dArray, dArray2);
            d += dArray[0];
            if (dArray2[0] == Double.NEGATIVE_INFINITY) continue;
            d2 = Math.max(d2, dArray2[0]);
        }
        double d3 = d2 == 0.0 ? Double.NEGATIVE_INFINITY : d / d2;
        return d3;
    }

    private void adjustSpaceForROC(RunTimeStep runTimeStep) {
        int n = this.getLimitType();
        int n2 = runTimeStep.getTotalNumSteps();
        double d = runTimeStep.getTimeStepSeconds();
        if (n == 1) {
            double d2 = this.getDecrROCLimit(runTimeStep);
            if (d2 == Double.NEGATIVE_INFINITY) {
                return;
            }
            for (n = this.C - 2; n > 0; --n) {
                int n3 = this.calcTSstep(runTimeStep, n);
                if (n3 > n2 || this.V[n] == Double.NEGATIVE_INFINITY) continue;
                double d3 = this.V[n + 1] + d2 * d;
                if (this.V[n] > d3) {
                    this.V[n] = d3;
                }
                if (this.n == null) continue;
                this.n.array[n3] = this.V[n];
            }
            return;
        }
        double d4 = this.getIncrROCLimit(runTimeStep);
        if (d4 == Double.NEGATIVE_INFINITY) {
            return;
        }
        for (n = this.C - 2; n > 0; --n) {
            int n4 = this.calcTSstep(runTimeStep, n);
            if (n4 > n2 || this.V[n] == Double.NEGATIVE_INFINITY) continue;
            double d5 = this.V[n + 1] - d4 * d;
            if (this.V[n] < d5) {
                this.V[n] = d5;
            }
            if (this.n == null) continue;
            this.n.array[n4] = this.V[n];
        }
    }

    @Override
    public Object clone() {
        DownstreamOpRule downstreamOpRule = (DownstreamOpRule)super.clone();
        ((DownstreamOpRule)super.clone()).i = this.i;
        if (this._contingencyPV != null) {
            downstreamOpRule._contingencyPV = (PairedValues)this._contingencyPV.clone();
        }
        if (this._downstreamOptions != null) {
            downstreamOpRule._downstreamOptions = this._downstreamOptions.clone();
        }
        return downstreamOpRule;
    }

    public boolean usesContingency() {
        return this._useContingency;
    }

    public boolean useDefaultDSOptions() {
        return this._useDefaultOptions;
    }

    public void setUseDefaultDSOptions(boolean bl) {
        this._useDefaultOptions = bl;
    }

    public DownstreamOptions getActiveDownstreamOptions() {
        this.ap = this._useDefaultOptions ? this.g.getDefaultDownstreamOptions() : this._downstreamOptions;
        if (this.ap == null) {
            this.ap = new DownstreamOptions();
        }
        return this.ap;
    }

    public DownstreamOptions getDownStreamOptions() {
        return this._downstreamOptions;
    }

    public void setDownStreamOptions(DownstreamOptions downstreamOptions) {
        this._downstreamOptions = downstreamOptions;
    }

    public DownstreamOptions getDefaultDownstreamOptions() {
        return this.getRssSystem().getDefaultDownstreamOptions();
    }

    public void setDefaultDownstreamOptions(DownstreamOptions downstreamOptions) {
        this.getRssSystem().setDefaultDownstreamOptions(downstreamOptions);
    }

    public void setUsesContingency(boolean bl) {
        this._useContingency = bl;
    }

    public int getContingencyType() {
        return this._contingencyType;
    }

    public void setContingencyType(int n) {
        if (n == d) {
            this._contingencyType = d;
            return;
        }
        this._contingencyType = c;
    }

    public double getContingencyConstant() {
        return this._contingencyConst;
    }

    public void setContingencyConstant(double d) {
        this._contingencyConst = d;
    }

    public PairedValues getContingencyPV() {
        return this._contingencyPV;
    }

    public void setContingencyPV(PairedValues pairedValues) {
        this._contingencyPV = pairedValues;
    }

    public int clearForCompute(RssSystem rssSystem, RssNode rssNode, DownstreamOp downstreamOp) {
        this.g = rssSystem;
        this.l = rssNode;
        this.j = downstreamOp;
        this.m = null;
        this.k = new ArrayList<DownstreamCntrlOpRule>();
        return 0;
    }

    public void addChildRule(DownstreamCntrlOpRule downstreamCntrlOpRule) {
        if (this.k == null || this.k.contains(downstreamCntrlOpRule)) {
            return;
        }
        this.k.add(downstreamCntrlOpRule);
    }

    public int initialize(RssSystem rssReturnStatusConstants, RssNode object, DownstreamOp downstreamOp, RunTimeWindow runTimeWindow) {
        Object object2;
        int n;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        int n2;
        this.g = rssReturnStatusConstants;
        this.l = object;
        this.j = downstreamOp;
        this.m = null;
        this.e = null;
        this.q = null;
        this.aq = null;
        this.ar = null;
        this.ap = this._useDefaultOptions ? this.g.getDefaultDownstreamOptions() : this._downstreamOptions;
        if (this.ap == null) {
            this.ap = new DownstreamOptions();
        }
        if (this.l == null) {
            return 1;
        }
        if (this._downstreamCntrlParam == b) {
            rssReturnStatusConstants = this.l.getUpstreamElement();
            if (rssReturnStatusConstants == null || !(rssReturnStatusConstants instanceof JunctionElement) || !((JunctionElement)rssReturnStatusConstants).hasRatingCurve()) {
                this.g.printErrorMessage("DownstreamOpRule.initialize: Error attempting to operate for stage when rating is not defined at location " + this.g.getNameForKeyString(this.l.getName()));
                return 1;
            }
            object = (Junction)((Element)rssReturnStatusConstants).getFunction();
            this.m = object;
        }
        if (this.k == null || this.k.size() <= 0) {
            return 0;
        }
        int n3 = this.k.size();
        this.e = new ReservoirElement[n3];
        this.q = new boolean[n3];
        this.r = new Object[n3];
        this.s = new Object[n3];
        this.t = new Object[n3];
        this.v = new Object[n3];
        this.u = new Object[n3];
        this.y = new int[n3];
        this.f = new double[n3];
        int n4 = 0;
        int n5 = Integer.MAX_VALUE;
        int n6 = 0;
        int n7 = Integer.MAX_VALUE;
        int n8 = 1;
        int n9 = 0;
        double d = ((ReleaseFuncOpRule)this).getLargestLimitValue();
        for (n2 = 0; n2 < n3; ++n2) {
            object6 = this.k.get(n2);
            object = ((OpRule)object6).getOperationsElement();
            this.e[n2] = (ReservoirElement)object;
            this.q[n2] = ((DownstreamCntrlOpRule)object6).isPassThru();
            if (object == null) continue;
            this.y[n2] = 0;
            this.f[n2] = 0.0;
            int n10 = object.getElementOp(false).getActiveOpSet().getMaxNumDecisionSteps(runTimeWindow.getTimeStepSeconds());
            if (this.ap._useConsiderROC) {
                int n11 = object.getElementOp(false).getActiveOpSet().getMaxNumROCSteps(runTimeWindow, d, this._limitType);
                n9 = Math.max(n9, n11);
            }
            if (this.ap._useConsiderRTW && this.ap._multiplierRTW > 0.0) {
                double cfr_ignored_0 = this.ap._multiplierRTW;
            }
            if ((object6 = downstreamOp.getResPulseTable(object.getIndex())) != null && ((Hashtable)object6).size() > 0) {
                int n12 = ((Hashtable)object6).size();
                object5 = new doubleArrayContainer[n12];
                DownstreamPulseResponse[] downstreamPulseResponseArray = new DownstreamPulseResponse[n12];
                object4 = new Object[n12];
                object3 = new Object[n12];
                Object[] objectArray = new Object[n12];
                this.r[n2] = object5;
                this.s[n2] = downstreamPulseResponseArray;
                this.t[n2] = object4;
                this.v[n2] = object3;
                this.u[n2] = objectArray;
                n = 0;
                object2 = ((Hashtable)object6).elements();
                while (object2.hasMoreElements()) {
                    downstreamPulseResponseArray[n] = object6 = (DownstreamPulseResponse)object2.nextElement();
                    if (object6 == null) continue;
                    int n13 = ((DownstreamPulseResponse)object6).h();
                    double d2 = ((DownstreamPulseResponse)object6).i();
                    if (this.y[n4] < n13) {
                        this.y[n4] = n13;
                    }
                    if (this.f[n4] < d2) {
                        this.f[n4] = d2;
                    }
                    int n14 = ((DownstreamPulseResponse)object6).f();
                    int n15 = ((DownstreamPulseResponse)object6).g();
                    int n16 = n14 + n15 + (n10 - 1);
                    if (this.ap._usePredictor) {
                        n16 += n15;
                    }
                    if (n13 < n5) {
                        n5 = n13;
                    }
                    if (n13 > n6) {
                        n6 = n13;
                    }
                    if (n14 < n7) {
                        n7 = n14;
                    }
                    if (n8 < n16) {
                        n8 = n16;
                    }
                    if ((object6 = object.getChildElementAt(((DownstreamPulseResponse)object6).b())) != null && ((Element)object6).getDownstreamNode() != null) {
                        object5[n] = ((Element)object6).getDownstreamNode().getTSContainer(0);
                    }
                    ++n;
                }
            }
            ++n4;
        }
        if (this.ap._useConsiderROC && RMAConst.isValidValue((int)this.ap._maxLookaheadROC) && this.ap._maxLookaheadROC > 0 && n9 > this.ap._maxLookaheadROC) {
            n9 = this.ap._maxLookaheadROC;
        }
        this.z = n5;
        this.A = n6;
        this.B = n7;
        if (this.B < 0) {
            this.B = 0;
        }
        this.C = n8 - this.B + 1 + n9;
        this.D = n8 - this.B + 1;
        if (this.C > runTimeWindow.getForecastSteps()) {
            this.C = runTimeWindow.getForecastSteps();
        }
        if (this.D > runTimeWindow.getForecastSteps()) {
            this.D = runTimeWindow.getForecastSteps();
        }
        this.g.printMessage("Pulse Width Steps = " + Integer.toString(this.C) + " for analysis of Downstream Rule " + this.getName());
        if (n9 > 0) {
            this.g.printMessage("Pulse Width Steps associated with ROC constraints = " + Integer.toString(n9) + " for analysis of Downstream Rule " + this.getName());
        }
        if (this.C <= 0) {
            this.g.printMessage("Pulse Width Steps <= 0 for analysis of Downstream Rule " + this.getName() + " - skipping pulse initialization");
            return 0;
        }
        this.T = new double[this.C];
        this.W = new double[n3][this.C];
        this.X = new double[n3][this.C];
        this.ag = new double[this.C];
        this.ah = new double[this.C];
        this.E = new double[this.C];
        this.F = new double[this.C];
        this.G = new double[this.C];
        this.V = new double[this.C];
        this.O = new double[this.C];
        this.S = new double[n3][this.C];
        this.P = new double[n3][this.C];
        this.Q = new double[n3][this.C];
        this.R = new double[n3][this.C];
        this.Z = new double[n3];
        this.aa = new double[n3];
        this.ae = new double[n3];
        this.af = new double[n3];
        this.U = new double[this.C];
        this.ac = new double[n3];
        this.ad = new double[n3];
        this.H = new boolean[n3];
        this.ab = new boolean[n3];
        this.w = this.l.getTSContainer(0);
        this.n = this.getTSContainer(79);
        this.o = this._downstreamCntrlParam == b && this._limitType == -1 ? this.getTSContainer(142) : (this._downstreamCntrlParam == b && this._limitType == 1 ? this.getTSContainer(141) : null);
        Object object7 = this.getTSProxyName();
        this.aj = this.getTSContainer((String)object7 + "-Projected", 167);
        this.ak = this.getTSContainer((String)object7 + "-Final", 167);
        this.ai = new doubleArrayContainer[n3];
        this.al = new doubleArrayContainer[n3];
        this.am = new Object[n3];
        this.an = new Object[n3];
        this.ao = new Object[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            int n17;
            object5 = this.e[n2].getName() + "-" + (String)object7;
            this.ai[n2] = this.k.get(n2).getTSContainer((String)object5, 89);
            this.al[n2] = this.k.get(n2).getTSContainer((String)object5 + "-Final", 167);
            object6 = downstreamOp.getResPulseTable(this.e[n2].getIndex());
            if (object6 == null || ((Hashtable)object6).size() <= 0 || (n17 = ((Hashtable)object6).size()) <= 0) continue;
            this.am[n2] = new doubleArrayContainer[n17];
            this.an[n2] = new doubleArrayContainer[n17];
            this.ao[n2] = new doubleArrayContainer[n17];
            for (int i = 0; i < n17; ++i) {
                doubleArrayContainer[] doubleArrayContainerArray = (doubleArrayContainer[])this.am[n2];
                object4 = doubleArrayContainerArray;
                doubleArrayContainerArray[i] = ((OpRule)this.k.get(n2)).getTSContainer(198);
                doubleArrayContainer[] doubleArrayContainerArray2 = (doubleArrayContainer[])this.an[n2];
                object4 = doubleArrayContainerArray2;
                doubleArrayContainerArray2[i] = ((OpRule)this.k.get(n2)).getTSContainer(199);
                doubleArrayContainer[] doubleArrayContainerArray3 = (doubleArrayContainer[])this.ao[n2];
                object4 = doubleArrayContainerArray3;
                doubleArrayContainerArray3[i] = ((OpRule)this.k.get(n2)).getTSContainer(200);
            }
        }
        this.N = new Object[n3];
        this.K = new Object[n3];
        this.L = new Object[n3];
        this.I = new doubleArrayContainer[n3];
        this.J = new doubleArrayContainer[n3];
        this.Y = new Object[n3];
        this.M = new Object[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            Arrays.fill(this.W[n2], Double.NEGATIVE_INFINITY);
            Arrays.fill(this.X[n2], Double.NEGATIVE_INFINITY);
        }
        for (n2 = 0; n2 < this.t.length; ++n2) {
            int n18;
            Object[] objectArray = (Object[])this.t[n2];
            for (n18 = 0; n18 < objectArray.length; ++n18) {
                objectArray[n18] = new double[this.C];
            }
            this.N[n2] = object4 = new Object[objectArray.length];
            for (n18 = 0; n18 < ((Object[])object4).length; ++n18) {
                object4[n18] = new double[this.C];
            }
            this.Y[n2] = new double[objectArray.length][this.C];
            this.M[n2] = new double[objectArray.length][this.C];
            this.K[n2] = new double[objectArray.length][this.C];
            this.L[n2] = new double[objectArray.length][this.C];
            this.I[n2] = new doubleArrayContainer();
            this.I[n2].setSize(objectArray.length);
            this.J[n2] = new doubleArrayContainer();
            this.J[n2].setSize(objectArray.length);
        }
        this.p = ReservoirSysOp.a(this.g, this.e);
        boolean[][] blArray = new boolean[n3 + 1][n3];
        this.ar = new HashMap<Element, boolean[]>();
        this.aq = new HashMap<Element, boolean[]>();
        object4 = new boolean[n3 + 1][n3];
        object3 = this.l.getUpstreamElement();
        block8: for (n2 = 0; n2 < n3; ++n2) {
            int n19;
            object7 = this.g.getDownstreamElements(this.e[n2], true);
            for (n19 = 0; n19 < n3; ++n19) {
                blArray[n19][n2] = n2 != n19 && object7.contains(this.e[n19]);
            }
            if (object7.contains(object3)) {
                blArray[n3][n2] = true;
            }
            n = 0;
            object2 = object7.iterator();
            while (object2.hasNext()) {
                object6 = (Element)object2.next();
                for (n19 = 0; n19 < n3; ++n19) {
                    if (object6 != this.e[n19]) continue;
                    object4[n19][n2] = true;
                    n = 1;
                    break;
                }
                if (n != 0) continue block8;
                if (object6 != object3) continue;
                object4[n3][n2] = true;
                continue block8;
            }
        }
        for (int i = 0; i < n3; ++i) {
            this.aq.put(this.e[i], blArray[i]);
            this.ar.put(this.e[i], (boolean[])object4[i]);
        }
        this.aq.put((Element)object3, blArray[n3]);
        this.ar.put((Element)object3, (boolean[])object4[n3]);
        if (this.ap.getUsePESTAdj()) {
            this.as = new DownstreamOpRuleBackRoute();
        }
        ((OpRule)this).initializeCompute();
        return 0;
    }

    public int initForPostProcessing(RssSystem rssReturnStatusConstants, RssNode object, DownstreamOp downstreamOp, RunTimeWindow runTimeWindow) {
        this.g = rssReturnStatusConstants;
        this.l = object;
        this.j = downstreamOp;
        this.m = null;
        this.e = null;
        this.ap = this._useDefaultOptions ? this.g.getDefaultDownstreamOptions() : this._downstreamOptions;
        if (this.ap == null) {
            this.ap = new DownstreamOptions();
        }
        if (this.l == null) {
            return 1;
        }
        if (this._downstreamCntrlParam == b) {
            rssReturnStatusConstants = this.l.getUpstreamElement();
            if (rssReturnStatusConstants == null || !(rssReturnStatusConstants instanceof JunctionElement) || !((JunctionElement)rssReturnStatusConstants).hasRatingCurve()) {
                this.g.printErrorMessage("DownstreamOpRule.initialize: Error attempting to operate for stage when rating is not defined at location " + this.g.getNameForKeyString(this.l.getName()));
                return 1;
            }
            object = (Junction)((Element)rssReturnStatusConstants).getFunction();
            this.m = object;
        }
        if (this.k == null || this.k.size() <= 0) {
            return 0;
        }
        int n = this.k.size();
        this.e = new ReservoirElement[n];
        this.r = new Object[n];
        this.s = new Object[n];
        this.t = new Object[n];
        this.v = new Object[n];
        this.u = new Object[n];
        this.y = new int[n];
        this.f = new double[n];
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        int n5 = Integer.MAX_VALUE;
        int n6 = 1;
        int n7 = 0;
        double d = ((ReleaseFuncOpRule)this).getLargestLimitValue();
        for (int i = 0; i < n; ++i) {
            Object object2;
            object = this.k.get(i);
            object = ((OpRule)object).getOperationsElement();
            this.e[i] = (ReservoirElement)object;
            if (object == null) continue;
            this.y[i] = 0;
            this.f[i] = 0.0;
            int n8 = object.getElementOp(false).getActiveOpSet().getMaxNumDecisionSteps(runTimeWindow.getTimeStepSeconds());
            if (this.ap._useConsiderROC) {
                int n9 = object.getElementOp(false).getActiveOpSet().getMaxNumROCSteps(runTimeWindow, d, this._limitType);
                n7 = Math.max(n7, n9);
            }
            if (this.ap._useConsiderRTW && this.ap._multiplierRTW > 0.0) {
                double cfr_ignored_0 = this.ap._multiplierRTW;
            }
            if ((object2 = downstreamOp.getResPulseTable(object.getIndex())) != null && ((Hashtable)object2).size() > 0) {
                int n10 = ((Hashtable)object2).size();
                doubleArrayContainer[] doubleArrayContainerArray = new doubleArrayContainer[n10];
                DownstreamPulseResponse[] downstreamPulseResponseArray = new DownstreamPulseResponse[n10];
                Object[] objectArray = new Object[n10];
                Object[] objectArray2 = new Object[n10];
                Object[] objectArray3 = new Object[n10];
                this.r[i] = doubleArrayContainerArray;
                this.s[i] = downstreamPulseResponseArray;
                this.t[i] = objectArray;
                this.v[i] = objectArray2;
                this.u[i] = objectArray3;
                int n11 = 0;
                Enumeration enumeration = ((Hashtable)object2).elements();
                while (enumeration.hasMoreElements()) {
                    downstreamPulseResponseArray[n11] = object2 = (DownstreamPulseResponse)enumeration.nextElement();
                    if (object2 == null) continue;
                    int n12 = ((DownstreamPulseResponse)object2).h();
                    double d2 = ((DownstreamPulseResponse)object2).i();
                    if (this.y[n2] < n12) {
                        this.y[n2] = n12;
                    }
                    if (this.f[n2] < d2) {
                        this.f[n2] = d2;
                    }
                    int n13 = ((DownstreamPulseResponse)object2).f();
                    int n14 = ((DownstreamPulseResponse)object2).g();
                    int n15 = n13 + n14 + (n8 - 1);
                    if (this.ap.getUsePredictor()) {
                        n15 += n14;
                    }
                    if (n12 < n3) {
                        n3 = n12;
                    }
                    if (n12 > n4) {
                        n4 = n12;
                    }
                    if (n13 < n5) {
                        n5 = n13;
                    }
                    if (n6 < n15) {
                        n6 = n15;
                    }
                    if ((object2 = object.getChildElementAt(((DownstreamPulseResponse)object2).b())) != null && ((Element)object2).getDownstreamNode() != null) {
                        doubleArrayContainerArray[n11] = ((Element)object2).getDownstreamNode().getTSContainer(0);
                    }
                    ++n11;
                }
            }
            ++n2;
        }
        if (this.ap._useConsiderROC && RMAConst.isValidValue((int)this.ap._maxLookaheadROC) && this.ap._maxLookaheadROC > 0 && n7 > this.ap._maxLookaheadROC) {
            n7 = this.ap._maxLookaheadROC;
        }
        this.z = n3;
        this.A = n4;
        this.B = n5;
        if (this.B < 0) {
            this.B = 0;
        }
        this.C = n6 - this.B + 1 + n7;
        this.D = n6 - this.B + 1;
        if (this.C > runTimeWindow.getForecastSteps()) {
            this.C = runTimeWindow.getForecastSteps();
        }
        if (this.D > runTimeWindow.getForecastSteps()) {
            this.D = runTimeWindow.getForecastSteps();
        }
        this.g.printMessage("Pulse Width Steps = " + Integer.toString(this.C) + " for analysis of Downstream Rule " + this.getName());
        if (n7 > 0) {
            this.g.printMessage("Pulse Width Steps associated with ROC constraints = " + Integer.toString(n7) + " for analysis of Downstream Rule " + this.getName());
        }
        if (this.C <= 0) {
            this.g.printMessage("Pulse Width Steps <= 0 for analysis of Downstream Rule " + this.getName() + " - skipping pulse initialization");
            return 0;
        }
        this.p = ReservoirSysOp.a(this.g, this.e);
        return 0;
    }

    @Override
    public void evaluateLimits(RunTimeStep runTimeStep, int n) {
        ((ReleaseFuncOpRule)this).getLimitValue(runTimeStep);
    }

    public void evaluateLimits32(RunTimeStep runTimeStep, int n) {
        int n2;
        int n3;
        ((ReleaseFuncOpRule)this).getLimitValue(runTimeStep);
        RunTimeStep runTimeStep2 = new RunTimeStep(runTimeStep);
        int n4 = runTimeStep.getTotalNumSteps();
        for (n3 = 0; n3 < this.C; ++n3) {
            runTimeStep2.setStep(this.calcTSstep(runTimeStep, n3));
            if (runTimeStep2.step > n4) {
                runTimeStep2.step = n4;
            }
            this.T[n3] = ((ReleaseFuncOpRule)this).getLimitValue(runTimeStep2);
        }
        this.evaluateBaseFlow(runTimeStep);
        double d = 1.0;
        if (this.getLimitType() == -1) {
            d = -1.0;
        }
        double d2 = 1.0;
        if (this._useContingency && this._contingencyType == c) {
            d2 = 1.0 + d * this._contingencyConst / 100.0;
        }
        for (n3 = 0; n3 < this.C; ++n3) {
            int n5 = this.calcTSstep(runTimeStep, n3);
            if (this._useContingency && this._contingencyType == DownstreamOpRule.d && this._contingencyPV != null) {
                d2 = 1.0 + d * this._contingencyPV.interpolate(this.U[n3]) / 100.0;
            }
            this.V[n3] = this.T[n3] - this.U[n3] * d2;
            double d3 = this.V[n3];
            if (d3 == Double.NEGATIVE_INFINITY) {
                d3 = -3.4028234663852886E38;
            }
            if (!(this.n != null & n3 > 0 & n5 <= n4)) continue;
            this.n.array[n5] = d3;
        }
        this.determineActiveReservoirs(runTimeStep);
        n4 = this.e.length;
        for (n2 = 0; n2 < n4; ++n2) {
            this.estResRuleConstraints(runTimeStep, n2, n);
        }
        n = 1;
        if (this.ap.getUsePESTAdj()) {
            int n6 = 1;
            if (this._limitType == -1) {
                n6 = -1;
            }
            this.as.a(runTimeStep, this.V, this.N, this.M, this.B, this.s, n6, this.H);
        } else {
            for (int i = 0; n != 0 && i < 3; ++i) {
                this.evaluateReleases(runTimeStep);
                n = 0;
                for (n2 = 0; n2 < n4; ++n2) {
                    double[][] dArray = (double[][])this.M[n2];
                    int n7 = dArray.length;
                    for (n3 = 0; n3 < n7; ++n3) {
                        if (this.hasROCconstraint(n2, n3) && this.ap._useConsiderROC) {
                            this.modForROCconstraint(runTimeStep, n2, n3);
                        }
                        this.determineRelease(n2, n3, runTimeStep);
                        if (!this.ap.getUseLaggedSpaceAdj() || this.ap.getUsePredictor()) continue;
                        this.correctRelease(n2, n3, runTimeStep);
                    }
                }
            }
        }
        this.assignReleases(runTimeStep);
    }

    void assignReleases(RunTimeStep runTimeStep) {
        int n = this.e.length;
        for (int i = 0; i < n; ++i) {
            if (!this.H[i]) continue;
            DownstreamOpRule downstreamOpRule = this;
            OpValue opValue = downstreamOpRule.computeFlowLimit(downstreamOpRule.x[i], runTimeStep);
            this.x[i].setOpValue(runTimeStep, opValue);
        }
    }

    private int evaluateBaseFlow(RunTimeStep runTimeStep) {
        int n;
        int n2;
        int n3;
        int n4 = this.e.length;
        int n5 = n3 = runTimeStep.getTotalNumSteps();
        if (this.calcTSstep(runTimeStep, 0) + this.C <= n5) {
            System.arraycopy(this.w.array, this.calcTSstep(runTimeStep, 0), this.U, 0, this.C);
        } else {
            for (n2 = 0; n2 < this.C; ++n2) {
                n = this.calcTSstep(runTimeStep, n2);
                if (n > n5) {
                    n = n5;
                }
                this.U[n2] = this.w.array[n];
            }
        }
        Arrays.fill(this.E, 0.0);
        Arrays.fill(this.F, 0.0);
        Arrays.fill(this.G, 0.0);
        for (int i = 0; i < n4; ++i) {
            Object[] objectArray;
            Object[] objectArray2;
            doubleArrayContainer[] doubleArrayContainerArray;
            DownstreamPulseResponse[] downstreamPulseResponseArray;
            if (this.e[i] == null || (downstreamPulseResponseArray = (DownstreamPulseResponse[])this.s[i]) == null || (doubleArrayContainerArray = (doubleArrayContainer[])this.r[i]) == null || (objectArray2 = (Object[])this.t[i]) == null || (objectArray = (Object[])this.N[i]) == null) continue;
            n5 = downstreamPulseResponseArray.length;
            this.y[i] = this.B;
            for (n = 0; n < n5; ++n) {
                int n6;
                int n7;
                int n8;
                if (downstreamPulseResponseArray[n] == null || objectArray2[n] == null || objectArray[n] == null) continue;
                double[] dArray = (double[])objectArray2[n];
                Arrays.fill(dArray, 0.0);
                double[] dArray2 = (double[])objectArray[n];
                Arrays.fill(dArray2, 0.0);
                DownstreamPulseResponse downstreamPulseResponse = downstreamPulseResponseArray[n];
                double[] dArray3 = downstreamPulseResponse.e();
                double[] dArray4 = doubleArrayContainerArray[n].array;
                int n9 = downstreamPulseResponse.h();
                if (this.y[i] < n9) {
                    this.y[i] = n9;
                }
                int n10 = downstreamPulseResponse.f();
                int n11 = downstreamPulseResponse.g();
                int n12 = this.C - (n10 - this.B);
                for (n2 = 1; n2 < n12; ++n2) {
                    n8 = runTimeStep.step + n2 - 1;
                    if (n8 > n3) {
                        n8 = n3;
                    }
                    for (n7 = 0; n7 < n11 && (n6 = n2 + (n10 - this.B) + n7) < this.C; ++n7) {
                        int n13 = n6;
                        this.U[n13] = this.U[n13] - dArray4[n8] * dArray3[n7];
                        int n14 = n6;
                        dArray[n14] = dArray[n14] + dArray3[n7];
                        if (n2 - 1 > this.A - n9) continue;
                        int n15 = n6;
                        this.E[n15] = this.E[n15] + dArray3[n7];
                    }
                }
                n12 = this.C + 1;
                for (n2 = 1; n2 <= n12; ++n2) {
                    n8 = runTimeStep.step - n2;
                    if (n8 < 0) {
                        n8 = 0;
                    }
                    for (n7 = n11 - 1; n7 >= 0 && (n6 = -n2 + (n10 - this.B) + n7 + 1) >= 0; --n7) {
                        if (n6 >= this.C) continue;
                        int n16 = n6;
                        this.U[n16] = this.U[n16] - dArray4[n8] * dArray3[n7];
                        int n17 = n6;
                        dArray2[n17] = dArray2[n17] + dArray4[n8] * dArray3[n7];
                        int n18 = n6;
                        this.F[n18] = this.F[n18] + dArray4[n8] * dArray3[n7];
                        int n19 = n6;
                        this.G[n19] = this.G[n19] + dArray3[n7];
                    }
                }
            }
        }
        if (runTimeStep.step + this.B - 1 + this.C > n3) {
            int n20 = n3 - (runTimeStep.step + this.B - 1);
            if (n20 < 0) {
                n20 = 0;
            }
            Arrays.fill(this.U, n20 + 1, this.C, this.U[n20]);
        }
        return 0;
    }

    private void determineActiveReservoirs(RunTimeStep runTimeStep) {
        if (this.x == null || this.x.length < this.e.length) {
            this.x = new DownstreamCntrlOpRule[this.e.length];
        }
        int n = this.e.length;
        ArrayList arrayList = new ArrayList();
        block0: for (int i = 0; i < n; ++i) {
            this.H[i] = false;
            arrayList.clear();
            this.e[i].getReservoirOp(false).getActiveRules(runTimeStep, arrayList);
            int n2 = arrayList.size();
            for (int j = 0; j < n2; ++j) {
                OpRule opRule = (OpRule)arrayList.get(j);
                if (!(opRule instanceof DownstreamCntrlOpRule) || ((DownstreamCntrlOpRule)opRule).getParentRule() != this) continue;
                this.H[i] = true;
                this.x[i] = (DownstreamCntrlOpRule)opRule;
                continue block0;
            }
        }
    }

    private void evaluateReleases(RunTimeStep runTimeStep) {
        int n = this.e.length;
        RunTimeStep runTimeStep2 = new RunTimeStep(runTimeStep);
        RunTimeStep runTimeStep3 = new RunTimeStep(runTimeStep);
        for (int i = 0; i < this.C; ++i) {
            double d;
            double d2;
            int n2 = 0;
            this.O[i] = 0.0;
            runTimeStep2.step = this.calcTSstep(runTimeStep, i);
            double d3 = 0.0;
            for (int j = 0; j < n; ++j) {
                this.Z[j] = 0.0;
                this.aa[j] = 0.0;
                if (!this.H[j]) {
                    this.ab[j] = false;
                    this.W[j][i] = 0.0;
                    this.X[j][i] = 0.0;
                    continue;
                }
                this.R[j][i] = this.calcLaggedPrevResRel(runTimeStep2, j, i, runTimeStep3);
                this.Q[j][i] = this.calcLaggedInitStor(runTimeStep2, j, i, runTimeStep3);
                this.P[j][i] = this.calcLaggedInflowVol(runTimeStep2, j, runTimeStep3);
                this.ac[j] = this.Q[j][i] + this.P[j][i];
                this.ab[j] = false;
                DownstreamPulseResponse[] downstreamPulseResponseArray = (DownstreamPulseResponse[])this.s[j];
                d2 = 0.0;
                for (int k = 0; k < downstreamPulseResponseArray.length; ++k) {
                    DownstreamPulseResponse downstreamPulseResponse = downstreamPulseResponseArray[k];
                    if (downstreamPulseResponse.f() - this.B > i - 1) {
                        this.ab[j] = false;
                        d = this.calcLaggedRelease(runTimeStep2, j, k);
                        d2 += d;
                        d3 += d;
                        if (runTimeStep.isPerAvgTimeStep() || i == 0) {
                            int n3 = i;
                            this.O[n3] = this.O[n3] + d;
                        } else {
                            runTimeStep3.step = Math.max(runTimeStep2.step - 1, 0);
                            int n4 = i;
                            this.O[n4] = this.O[n4] + 0.5 * (d + this.calcLaggedRelease(runTimeStep2, j, k));
                        }
                        ((double[][])this.Y[j])[k][i] = d;
                        continue;
                    }
                    int n5 = j;
                    this.Z[n5] = this.Z[n5] + this.calcLaggedResOutMax(j, k, i);
                    int n6 = j;
                    this.aa[n6] = this.aa[n6] + this.calcLaggedResOutMin(j, k, i);
                    this.ab[j] = true;
                    ++n2;
                }
                if (this.ab[j]) {
                    this.S[j][i] = this.calcResGCRelVol(runTimeStep2, j, i, runTimeStep3);
                } else {
                    this.W[j][i] = d2;
                    this.X[j][i] = runTimeStep.isPerAvgTimeStep() ? this.W[j][i] * (double)runTimeStep.getTimeStepSeconds() / Storage.DSDT_TO_Q : 0.5 * (this.W[j][i] + this.R[j][i]) * (double)runTimeStep.getTimeStepSeconds() / Storage.DSDT_TO_Q;
                    this.S[j][i] = this.X[j][i];
                }
                double cfr_ignored_0 = this.S[j][i];
            }
            double d4 = runTimeStep.isPerAvgTimeStep() || i == 0 ? this.V[i] - this.O[i] : 0.5 * (Math.max(0.0, this.V[i]) + Math.max(0.0, this.V[i - 1])) - this.O[i];
            if (n2 <= 0) continue;
            d2 = d4;
            d = -d2 * (double)runTimeStep.getTimeStepSeconds() / Storage.DSDT_TO_Q;
            double d5 = this.V[i] - d3;
            Arrays.fill(this.ad, 0.0);
            ReservoirSysOp.a(this.g, this.e, this.ab, runTimeStep2, this.p, this.ac, this.ad, d);
            this.distributeSpace(runTimeStep2, d5, i, runTimeStep3);
        }
    }

    private void estResRuleConstraints(RunTimeStep runTimeStep, int n, int n2) {
        double d;
        double d2;
        if (!this.H[n]) {
            return;
        }
        OpValue opValue = new OpValue();
        int n3 = n2 - 1;
        int n4 = 24;
        if (this.e.length < 2) {
            n4 = 56;
        }
        Object object = this.k.get(n);
        ReservoirOp reservoirOp = this.e[n].getReservoirOp(false);
        DownstreamPulseResponse[] downstreamPulseResponseArray = (DownstreamPulseResponse[])this.s[n];
        int n5 = downstreamPulseResponseArray.length;
        reservoirOp.testOperationStep(runTimeStep, n3, n4, (OpRule)object);
        opValue.value = d2 = reservoirOp.getController().getCurMaxOpValue((RunTimeStep)runTimeStep).value;
        opValue.type = 2;
        opValue.ruleid = -13;
        reservoirOp.getController().distributeRelease(runTimeStep, opValue);
        this.Z[n] = 0.0;
        for (int i = 0; i < n5; ++i) {
            if (reservoirOp.getController(this.e[n].getChildElementAt(downstreamPulseResponseArray[i].a)) == null) continue;
            double d3 = reservoirOp.getController((Element)this.e[n].getChildElementAt((int)downstreamPulseResponseArray[i].a)).getCurOpValue((RunTimeStep)runTimeStep).value;
            double[][] dArray = (double[][])this.K[n];
            Arrays.fill(dArray[i], d3);
            int n6 = n;
            this.Z[n6] = this.Z[n6] + d3;
        }
        reservoirOp.testOperationStep(runTimeStep, n3, n4, (OpRule)object);
        opValue.value = d = reservoirOp.getController().getCurMinOpValue((RunTimeStep)runTimeStep).value;
        opValue.type = 0;
        opValue.ruleid = -13;
        reservoirOp.getController().distributeRelease(runTimeStep, opValue);
        this.aa[n] = 0.0;
        for (int i = 0; i < n5; ++i) {
            if (reservoirOp.getController(this.e[n].getChildElementAt(downstreamPulseResponseArray[i].a)) == null) continue;
            double d4 = reservoirOp.getController((Element)this.e[n].getChildElementAt((int)downstreamPulseResponseArray[i].a)).getCurOpValue((RunTimeStep)runTimeStep).value;
            double[][] dArray = (double[][])this.L[n];
            object = dArray;
            Arrays.fill(dArray[i], d4);
            int n7 = n;
            this.aa[n7] = this.aa[n7] + d4;
        }
        if (this.ap._useConsiderROC) {
            Object object2 = this.e[n].getStorageFunction();
            double d5 = ((Storage)object2).getPreviousElevation(runTimeStep);
            object = reservoirOp.getActiveOpSet().getActiveZone(d5, runTimeStep);
            object2 = null;
            if (object != null) {
                object2 = ((StorageZone)object).getActiveRules(runTimeStep, null);
            }
            object = new double[1];
            double[] dArray = new double[1];
            for (int i = 0; i < n5; ++i) {
                OpController opController = n5 == 1 ? reservoirOp.getController() : reservoirOp.getController(this.e[n].getChildElementAt(downstreamPulseResponseArray[i].a));
                this.I[n].array[i] = opController.getDecrROCLimit(runTimeStep, (double[])object, dArray, d5, (List)object2);
                this.J[n].array[i] = opController.getIncrROCLimit(runTimeStep, (double[])object, dArray, d5, (List)object2);
            }
        }
    }

    private double calcLaggedInflowVol(RunTimeStep runTimeStep, int n, RunTimeStep runTimeStep2) {
        Storage storage = this.e[n].getStorageFunction();
        if (storage == null) {
            return 0.0;
        }
        int n2 = DownstreamPulseResponse.d(this.f[n]);
        double d = DownstreamPulseResponse.e(this.f[n]);
        n = runTimeStep.step;
        int n3 = (n -= n2) - 1;
        if (n < 0) {
            n = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        runTimeStep2.step = n--;
        double d2 = storage.getNetInflow(runTimeStep) * (1.0 - d);
        runTimeStep2.step = n3--;
        d2 += storage.getNetInflow(runTimeStep) * d;
        if (!runTimeStep.isPerAvgTimeStep()) {
            if (n < 0) {
                n = 0;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            runTimeStep2.step = n;
            d2 += storage.getNetInflow(runTimeStep) * (1.0 - d);
            runTimeStep2.step = n3;
            d2 += storage.getNetInflow(runTimeStep) * d;
            d2 *= 0.5;
        }
        double d3 = d2 / Storage.DSDT_TO_Q * (double)runTimeStep.getTimeStepSeconds();
        return d3;
    }

    private double calcLaggedInitStor(RunTimeStep runTimeStep, int n, int n2, RunTimeStep runTimeStep2) {
        double d;
        int n3 = DownstreamPulseResponse.d(this.f[n]);
        double d2 = DownstreamPulseResponse.e(this.f[n]);
        if (n2 + this.B - 1 <= n3) {
            Storage storage;
            int n4 = runTimeStep.step - 1;
            n2 = (n4 -= n3) - 1;
            if (n4 < 0) {
                n4 = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if ((storage = this.e[n].getStorageFunction()) == null) {
                return 0.0;
            }
            runTimeStep2.step = n4;
            d = storage.getStorage(runTimeStep2) * (1.0 - d2);
            runTimeStep2.step = n2;
            d += storage.getStorage(runTimeStep2) * d2;
        } else {
            d = this._limitType == 1 ? this.Q[n][n2 - 1] + this.P[n][n2 - 1] - Math.min(this.X[n][n2 - 1], this.S[n][n2 - 1]) : this.Q[n][n2 - 1] + this.P[n][n2 - 1] - this.X[n][n2 - 1];
        }
        return d;
    }

    private double calcLaggedPrevResRel(RunTimeStep runTimeStep, int n, int n2, RunTimeStep runTimeStep2) {
        double d = 0.0;
        int n3 = DownstreamPulseResponse.d(this.f[n]);
        DownstreamPulseResponse.e(this.f[n]);
        if (n2 + this.B - 1 <= n3) {
            DownstreamPulseResponse[] downstreamPulseResponseArray = (DownstreamPulseResponse[])this.s[n];
            runTimeStep2.step = runTimeStep.step - 1;
            for (int i = 0; i < downstreamPulseResponseArray.length; ++i) {
                d += this.calcLaggedRelease(runTimeStep2, n, i);
            }
        } else {
            d = runTimeStep.isPerAvgTimeStep() ? this.S[n][n2 - 1] / (double)runTimeStep.getTimeStepSeconds() * Storage.DSDT_TO_Q : 2.0 * this.S[n][n2 - 1] / (double)runTimeStep.getTimeStepSeconds() * Storage.DSDT_TO_Q + this.R[n][n2 - 1];
        }
        return d;
    }

    private double calcLaggedResOutMax(int n, int n2, int n3) {
        int n4 = DownstreamPulseResponse.d(this.f[n]);
        double d = DownstreamPulseResponse.e(this.f[n]);
        n3 = Math.max(n3 + this.B - n4, 0);
        int n5 = Math.max(n3 - 1, 0);
        double[] dArray = ((double[][])this.K[n])[n2];
        double d2 = dArray[n3] * (1.0 - d);
        return d2 += dArray[n5] * d;
    }

    private double calcLaggedResOutMin(int n, int n2, int n3) {
        int n4 = DownstreamPulseResponse.d(this.f[n]);
        double d = DownstreamPulseResponse.e(this.f[n]);
        n3 = Math.max(n3 + this.B - n4, 0);
        int n5 = Math.max(n3 - 1, 0);
        double[] dArray = ((double[][])this.L[n])[n2];
        double d2 = dArray[n3] * (1.0 - d);
        return d2 += dArray[n5] * d;
    }

    private double calcLaggedRelease(RunTimeStep runTimeStep, int n, int n2) {
        DownstreamPulseResponse[] downstreamPulseResponseArray = (DownstreamPulseResponse[])this.s[n];
        if (downstreamPulseResponseArray == null) {
            return 0.0;
        }
        Object[] objectArray = (doubleArrayContainer[])this.r[n];
        if (objectArray == null) {
            return 0.0;
        }
        objectArray = objectArray[n2].array;
        int n3 = downstreamPulseResponseArray[n2].j();
        double d = downstreamPulseResponseArray[n2].k();
        int n4 = runTimeStep.step;
        n2 = (n4 -= n3) - 1;
        if (n4 < 0) {
            n4 = 0;
        }
        if (n4 >= objectArray.length) {
            n4 = objectArray.length - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= objectArray.length) {
            n2 = objectArray.length - 1;
        }
        reference var4_7 = objectArray[n4] * (1.0 - d);
        return (double)(var4_7 += objectArray[n2] * d);
    }

    private double calcResGCRelVol(RunTimeStep runTimeStep, int n, int n2, RunTimeStep runTimeStep2) {
        double d = this.Q[n][n2];
        double d2 = this.P[n][n2];
        double d3 = this.e[n].getGuideCurveStorage(runTimeStep);
        double d4 = d - d3 + d2;
        return d4;
    }

    private boolean calcResBalRel(RunTimeStep runTimeStep, int n, int n2, RunTimeStep runTimeStep2) {
        int n3;
        double d;
        boolean bl = false;
        double d2 = this.af[n];
        if (d < 0.0) {
            d2 = 0.0;
        }
        double[][] dArray = (double[][])this.K[n];
        double[][] cfr_ignored_0 = (double[][])this.L[n];
        int n4 = dArray.length;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n3 = 0; n3 < n4; ++n3) {
            d3 += this.calcLaggedResOutMin(n, n3, n2);
            d4 += this.calcLaggedResOutMax(n, n3, n2);
        }
        if (d2 <= 0.0) {
            if (d2 < 0.0) {
                bl = true;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                ((double[][])this.Y[n])[n3][n2] = 0.0;
            }
        } else if (d3 >= d2) {
            for (n3 = 0; n3 < n4; ++n3) {
                ((double[][])this.Y[n])[n3][n2] = this.calcLaggedResOutMin(n, n3, n2) * d2 / d3;
            }
        } else if (d2 >= d4) {
            for (n3 = 0; n3 < n4; ++n3) {
                ((double[][])this.Y[n])[n3][n2] = this.calcLaggedResOutMax(n, n3, n2);
            }
            d2 = d4;
            bl = true;
        } else {
            double d5 = d2 - d3;
            double d6 = 0.0;
            for (n3 = 0; n3 < n4; ++n3) {
                int n5 = n3;
                double d7 = this.calcLaggedResOutMax(n, n3, n2);
                double d8 = this.calcLaggedResOutMin(n, n3, n2);
                double d9 = Math.min(d7 - d8, d5);
                ((double[][])this.Y[n])[n5][n2] = d8 + d9;
                d5 -= d9;
                d6 += ((double[][])this.Y[n])[n5][n2];
            }
            d2 = d6;
        }
        this.W[n][n2] = d2;
        this.X[n][n2] = runTimeStep.isPerAvgTimeStep() || n2 == 0 ? d2 / Storage.DSDT_TO_Q * (double)runTimeStep.getTimeStepSeconds() : 0.5 * (d2 + this.W[n][n2 - 1]) / Storage.DSDT_TO_Q * (double)runTimeStep.getTimeStepSeconds();
        return bl;
    }

    private double distributeSpace(RunTimeStep runTimeStep, double d, int n, RunTimeStep runTimeStep2) {
        int n2;
        int n3 = this.e.length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.ab[n2]) continue;
            double d2 = this.ac[n2] - this.ad[n2];
            this.ae[n2] = d2 / (double)runTimeStep.getTimeStepSeconds() * Storage.DSDT_TO_Q;
        }
        RmaMath.redistributeWithConstraint((double)d, (double[])this.ae, (double[])this.af, (double[])this.aa, (double[])this.Z, (double)1.0E-7, (boolean[])this.ab);
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.ab[n2]) continue;
            this.calcResBalRel(runTimeStep, n2, n, runTimeStep2);
        }
        return 0.0;
    }

    private void smoothResSpace(int n, int n2) {
        DownstreamPulseResponse[] downstreamPulseResponseArray = (DownstreamPulseResponse[])this.s[n];
        if (downstreamPulseResponseArray == null) {
            return;
        }
        int n3 = downstreamPulseResponseArray[n2].j();
        double d = downstreamPulseResponseArray[n2].k();
        int n4 = 0;
        while (n4 < this.C) {
            int n5 = n4 + (n3 - this.B);
            int n6 = n5 + 1;
            if (n5 >= this.C) {
                n5 = this.C - 1;
            }
            if (n6 >= this.C) {
                n6 = this.C - 1;
            }
            ((double[][])this.M[n])[n2][n4] = ((double[][])this.Y[n])[n2][n5] * (1.0 - d);
            double[] dArray = ((double[][])this.M[n])[n2];
            int n7 = n4++;
            dArray[n7] = dArray[n7] + ((double[][])this.Y[n])[n2][n6] * d;
        }
    }

    private void determineRelease(int n, int n2, RunTimeStep downstreamPulseResponseArray) {
        downstreamPulseResponseArray = (DownstreamPulseResponse[])this.s[n];
        if (downstreamPulseResponseArray == null) {
            return;
        }
        Object object = downstreamPulseResponseArray[n2];
        if (this.ap.getUsePredictor()) {
            int n3;
            int n4 = ((DownstreamPulseResponse)object).f();
            int n5 = ((DownstreamPulseResponse)object).g();
            double[] dArray = ((DownstreamPulseResponse)object).e();
            int n6 = ((DownstreamPulseResponse)object).h();
            object = new double[this.C - (n6 - this.B)];
            double[] dArray2 = new double[this.C - (n6 - n4)];
            int n7 = this.getLimitType();
            for (n3 = 0; n3 < this.C - (n6 - this.B); ++n3) {
                int n8 = n3 + (n6 - this.B);
                if (n8 >= this.C) {
                    n8 = this.C - 1;
                }
                object[n3] = ((double[][])this.Y[n])[n2][n8];
            }
            Object[] objectArray = (Object[])this.N[n];
            if (objectArray == null) {
                return;
            }
            double[] dArray3 = (double[])objectArray[n2];
            for (n3 = 1; n3 < this.C - (n6 - n4); ++n3) {
                dArray2[n3] = dArray3[n3];
                for (int i = 0; i < Math.min(n5, n3 + (this.B - n4)); ++i) {
                    int n9 = n3;
                    dArray2[n9] = dArray2[n9] + object[n3 + (this.B - n4) - i] * dArray[i];
                }
            }
            if (n7 == 1) {
                var12_24 = 0;
                var18_25 = 0.0;
                for (n3 = 1; n3 < this.C - (n6 - n4); ++n3) {
                    double d;
                    var20_26 = dArray2[n3] - ((double[][])this.Y[n])[n2][n3];
                    if (!(d > var18_25)) continue;
                    var12_24 = n3;
                    var18_25 = var20_26;
                }
                for (n7 = 0; var12_24 != 0 && n7 < this.ap._predictorMaxIterations * (this.C - (n6 - n4)); ++n7) {
                    int n10;
                    for (n10 = 0; n10 < Math.min(n5, var12_24 + (this.B - n4)); ++n10) {
                        object[var12_24 + (this.B - n4) - n10] = Math.max(0.0, (double)(object[var12_24 + (this.B - n4) - n10] - var18_25 * dArray[n10] * this.ap._predictorCorrectionFactor));
                    }
                    for (n3 = 1; n3 < this.C - (n6 - n4); ++n3) {
                        dArray2[n3] = dArray3[n3];
                        for (n10 = 0; n10 < Math.min(n5, n3 + (this.B - n4)); ++n10) {
                            int n11 = n3;
                            dArray2[n11] = dArray2[n11] + object[n3 + (this.B - n4) - n10] * dArray[n10];
                        }
                    }
                    var12_24 = 0;
                    var18_25 = 0.0;
                    for (n3 = 1; n3 < this.C - (n6 - n4); ++n3) {
                        double d;
                        var20_26 = dArray2[n3] - ((double[][])this.Y[n])[n2][n3];
                        if (!(d > var18_25)) continue;
                        var12_24 = n3;
                        var18_25 = var20_26;
                    }
                }
            } else if (n7 == -1) {
                var12_24 = 0;
                var18_25 = 0.0;
                for (n3 = 1; n3 < this.C - (n6 - n4); ++n3) {
                    double d;
                    var20_26 = dArray2[n3] - ((double[][])this.Y[n])[n2][n3];
                    if (!(d < var18_25)) continue;
                    var12_24 = n3;
                    var18_25 = var20_26;
                }
                for (n7 = 0; var12_24 != 0 && n7 < this.ap._predictorMaxIterations * (this.C - (n6 - n4)); ++n7) {
                    int n12;
                    for (n12 = 0; n12 < Math.min(n5, var12_24 + (this.B - n4)); ++n12) {
                        object[var12_24 + (this.B - n4) - n12] = object[var12_24 + (this.B - n4) - n12] - var18_25 * dArray[n12] * this.ap._predictorCorrectionFactor;
                    }
                    for (n3 = 1; n3 < this.C - (n6 - n4); ++n3) {
                        dArray2[n3] = dArray3[n3];
                        for (n12 = 0; n12 < Math.min(n5, n3 + (this.B - n4)); ++n12) {
                            int n13 = n3;
                            dArray2[n13] = dArray2[n13] + object[n3 + (this.B - n4) - n12] * dArray[n12];
                        }
                    }
                    var12_24 = 0;
                    var18_25 = 0.0;
                    for (n3 = 1; n3 < this.C - (n6 - n4); ++n3) {
                        double d;
                        var20_26 = dArray2[n3] - ((double[][])this.Y[n])[n2][n3];
                        if (!(d < var18_25)) continue;
                        var12_24 = n3;
                        var18_25 = var20_26;
                    }
                }
            }
            for (n3 = 0; n3 < this.C - (n6 - this.B); ++n3) {
                ((double[][])this.M[n])[n2][n3] = (double)object[n3];
            }
            return;
        }
        int n14 = downstreamPulseResponseArray[n2].j();
        double d = downstreamPulseResponseArray[n2].k();
        int n15 = 0;
        while (n15 < this.C) {
            int n16 = n15 + (n14 - this.B);
            int n17 = n16 + 1;
            if (n16 >= this.C) {
                n16 = this.C - 1;
            }
            if (n17 >= this.C) {
                n17 = this.C - 1;
            }
            ((double[][])this.M[n])[n2][n15] = ((double[][])this.Y[n])[n2][n16] * (1.0 - d);
            double[] dArray = ((double[][])this.M[n])[n2];
            int n18 = n15++;
            dArray[n18] = dArray[n18] + ((double[][])this.Y[n])[n2][n17] * d;
        }
    }

    private void correctRelease(int n, int n2, RunTimeStep runTimeStep) {
        int n3 = this.ap._lagMaxIterations;
        double d = Double.NEGATIVE_INFINITY;
        double d2 = 1.0;
        for (int i = 0; i < n3; ++i) {
            boolean bl;
            this.forwardRouteRelease(n, n2);
            double d3 = this.testRoutedRelease(n, n2);
            if (this.routeErrIsSmall(n, n2, d3, d) || !(bl = this.adjustRelease(n, n2, d2 * d3))) break;
            if (i > 0) {
                d2 = (d + d3) / d;
            }
            d = d3;
        }
    }

    private void forwardRouteRelease(int n, int n2) {
        Arrays.fill(this.ag, 0.0);
        DownstreamPulseResponse[] downstreamPulseResponseArray = (DownstreamPulseResponse[])this.s[n];
        Object[] objectArray = (Object[])this.N[n];
        DownstreamPulseResponse downstreamPulseResponse = downstreamPulseResponseArray[n2];
        double[] dArray = downstreamPulseResponse.e();
        int n3 = downstreamPulseResponse.f();
        int n4 = downstreamPulseResponse.g();
        downstreamPulseResponse.h();
        objectArray = (double[])objectArray[n2];
        this.ag[0] = this.ag[0] + objectArray[0];
        for (int i = 1; i < this.C; ++i) {
            int n5;
            int n6 = i;
            this.ag[n6] = this.ag[n6] + objectArray[i];
            int n7 = i;
            if (n7 >= this.C) {
                n7 = this.C - 1;
            }
            for (int j = 0; j < n4 && (n5 = i + (n3 - this.B) + j) < this.C; ++j) {
                int n8 = n5;
                this.ag[n8] = this.ag[n8] + ((double[][])this.M[n])[n2][n7] * dArray[j];
            }
        }
    }

    private double testRoutedRelease(int n, int n2) {
        double d = Double.NEGATIVE_INFINITY;
        int n3 = 1;
        if (this._limitType == -1) {
            n3 = -1;
        }
        Object object = (DownstreamPulseResponse[])this.s[n];
        object = object[n2];
        int n4 = object.f();
        n4 = n4 + 1 - this.B;
        int n5 = this.D;
        String cfr_ignored_0 = "DownstreamOpRule:testRoutedRelease (rule, routedRel, space) " + this.getName();
        for (int i = n4; i < n5; ++i) {
            double d2 = (double)n3 * (this.ag[i] - ((double[][])this.Y[n])[n2][i]);
            if (!(d < d2)) continue;
            d = d2;
        }
        return d;
    }

    private boolean routeErrIsSmall(int n, int n2, double d, double d2) {
        if (Math.abs(d) < this.ap._lagFlowTolerance) {
            return true;
        }
        if (Math.abs(d) < this.ap._lagFractionLimit * this.T[0]) {
            return true;
        }
        if (RMAConst.isValidValue((double)d2)) {
            double d3;
            double d4 = Math.abs(d2 - d);
            if (d3 < 1.0) {
                return true;
            }
        }
        return false;
    }

    private boolean adjustRelease(int n, int n2, double d) {
        int n3;
        boolean bl = false;
        int n4 = 1;
        if (this._limitType == -1) {
            n4 = -1;
        }
        DownstreamPulseResponse[] downstreamPulseResponseArray = (DownstreamPulseResponse[])this.s[n];
        int n5 = downstreamPulseResponseArray[n2].j();
        double d2 = downstreamPulseResponseArray[n2].k();
        double d3 = 0.0;
        double d4 = 0.0;
        for (n3 = 0; n3 < this.C; ++n3) {
            int n6 = n3 + (n5 - this.B);
            int n7 = n6 + 1;
            if (n6 >= this.C) {
                n6 = this.C - 1;
            }
            if (n7 >= this.C) {
                n7 = this.C - 1;
            }
            double d5 = this.U[n6] * (1.0 - d2);
            if (d3 > (d5 += this.U[n7] * d2)) {
                d3 = d5;
            }
            if (!(this.T[n3] > d4)) continue;
            d4 = this.T[n3];
        }
        for (n3 = 1; n3 < this.C; ++n3) {
            double d6;
            double d7 = ((double[][])this.M[n])[n2][n3] - (double)n4 * d;
            if (d6 < 0.0) {
                d7 = 0.0;
            } else if (d7 > 1.05 * (d4 - d3)) {
                d7 = 1.05 * (d4 - d3);
            }
            if (d7 == ((double[][])this.M[n])[n2][n3]) continue;
            bl = true;
            ((double[][])this.M[n])[n2][n3] = d7;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasROCconstraint(int n, int n2) {
        void var2_3;
        boolean bl = this.I[n].array[var2_3] != Double.NEGATIVE_INFINITY || this.J[n].array[var2_3] != Double.NEGATIVE_INFINITY;
        return bl;
    }

    private boolean modForROCconstraint(RunTimeStep doubleArrayContainerArray, int n, int n2) {
        boolean bl = false;
        double d = doubleArrayContainerArray.getTimeStepSeconds();
        double d2 = this.I[n].array[n2];
        double d3 = this.J[n].array[n2];
        double[][] dArray = (double[][])this.Y[n];
        int n3 = this.C;
        if (this._limitType == 1) {
            if (d2 != Double.NEGATIVE_INFINITY) {
                var11_13 = d2 * d;
                for (int i = n3 - 2; i > 0; --i) {
                    if (!(dArray[n2][i] > dArray[n2][i + 1] + var11_13)) continue;
                    dArray[n2][i] = dArray[n2][i + 1] + var11_13;
                    bl = true;
                }
            }
        } else if (d3 != Double.NEGATIVE_INFINITY) {
            var11_13 = d3 * d;
            for (int i = n3 - 2; i > 0; --i) {
                if (!(dArray[n2][i] < dArray[n2][i + 1] - var11_13)) continue;
                dArray[n2][i] = dArray[n2][i + 1] - var11_13;
                bl = true;
            }
        }
        if ((doubleArrayContainerArray = (doubleArrayContainer[])this.r[n]) == null) {
            return bl;
        }
        for (int i = 1; i < n3; ++i) {
            double d4 = dArray[n2][i - 1];
            if (d2 != Double.NEGATIVE_INFINITY && dArray[n2][i] < d4 - d2 * d) {
                dArray[n2][i] = d4 - d2 * d;
                bl = true;
                continue;
            }
            if (d3 == Double.NEGATIVE_INFINITY || !(dArray[n2][i] > d4 + d3 * d)) continue;
            dArray[n2][i] = d4 + d3 * d;
            bl = true;
        }
        return bl;
    }

    public OpValue computeFlowLimit(DownstreamCntrlOpRule object, RunTimeStep runTimeStep) {
        int n;
        object = ((OpRule)object).getController().getElementOp().getOperationsElement();
        int n2 = -1;
        for (int i = 0; i < this.e.length; ++i) {
            if (this.e[i] != object) continue;
            n2 = i;
            break;
        }
        if (n2 < 0) {
            return null;
        }
        DownstreamPulseResponse[] downstreamPulseResponseArray = (DownstreamPulseResponse[])this.s[n2];
        Object[] cfr_ignored_0 = (Object[])this.t[n2];
        Object[] cfr_ignored_1 = (Object[])this.N[n2];
        doubleArrayContainer[] cfr_ignored_2 = (doubleArrayContainer[])this.r[n2];
        int n3 = downstreamPulseResponseArray.length;
        OpValue opValue = new OpValue();
        int n4 = object.getChildElementCount() - 1;
        if (n4 > n3) {
            opValue.childFractionTable = new Hashtable(n3);
        }
        double d = 0.0;
        for (n = 0; n < downstreamPulseResponseArray.length; ++n) {
            d += ((double[][])this.M[n2])[n][1];
        }
        for (n = 0; n < downstreamPulseResponseArray.length; ++n) {
            DownstreamPulseResponse downstreamPulseResponse = downstreamPulseResponseArray[n];
            if (n4 <= n3) continue;
            if (d > 0.0) {
                opValue.childFractionTable.put(new Integer(downstreamPulseResponse.b()), new Float(((double[][])this.M[n2])[n][1] / d));
                continue;
            }
            opValue.childFractionTable.put(new Integer(downstreamPulseResponse.b()), Float.valueOf(1.0f));
        }
        opValue.value = d;
        return opValue;
    }

    @Deprecated
    public OpValue computeFlowLimit_old(DownstreamCntrlOpRule downstreamCntrlOpRule, RunTimeStep object) {
        double d;
        int n;
        object = downstreamCntrlOpRule.getController().getElementOp().getOperationsElement();
        int n2 = -1;
        for (int i = 0; i < this.e.length; ++i) {
            if (this.e[i] != object) continue;
            n2 = i;
            break;
        }
        if (n2 < 0) {
            return null;
        }
        double[] dArray = this.W[n2];
        if (dArray == null || !RMAConst.isValidValue((double)dArray[0])) {
            return null;
        }
        DownstreamPulseResponse[] downstreamPulseResponseArray = (DownstreamPulseResponse[])this.s[n2];
        Object[] objectArray = (Object[])this.t[n2];
        Object[] objectArray2 = (Object[])this.N[n2];
        doubleArrayContainer[] cfr_ignored_0 = (doubleArrayContainer[])this.r[n2];
        int n3 = downstreamPulseResponseArray.length;
        OpValue opValue = new OpValue();
        int n4 = object.getChildElementCount() - 1;
        if (n4 > n3) {
            opValue.childFractionTable = new Hashtable(n3);
        }
        for (n = 0; n < downstreamPulseResponseArray.length; ++n) {
            int n5;
            DownstreamPulseResponse downstreamPulseResponse = downstreamPulseResponseArray[n];
            if (n4 > n3) {
                opValue.childFractionTable.put(new Integer(downstreamPulseResponse.b()), new Float(1.0 / (double)n3));
            }
            double[] dArray2 = downstreamPulseResponse.e();
            int n6 = downstreamPulseResponse.f();
            int n7 = downstreamPulseResponse.g();
            int n8 = downstreamPulseResponse.h();
            double[] cfr_ignored_1 = (double[])objectArray[n];
            double[] dArray3 = (double[])objectArray2[n];
            Arrays.fill(this.ag, 0.0);
            for (n5 = 0; n5 < this.C; ++n5) {
                int n9;
                int n10 = n5;
                this.ag[n10] = this.ag[n10] + dArray3[n5];
                int n11 = n5 - this.B + n8;
                if (n11 >= this.C) {
                    n11 = this.C - 1;
                }
                for (int i = 0; i < n7 && (n9 = n5 + (n6 - this.B) + i) < this.C; ++i) {
                    int n12 = n9;
                    this.ag[n12] = this.ag[n12] + dArray[n11] * dArray2[i];
                }
            }
            n5 = this.y[n2] - this.B;
            if (n5 < 0) {
                n5 = 0;
            }
            if (n5 >= this.ag.length) {
                n5 = this.ag.length - 1;
            }
            double d2 = this.ag[n5] - dArray[n5];
            double cfr_ignored_2 = (Math.abs(d2) + dArray[n5]) / dArray[n5];
            double cfr_ignored_3 = dArray[n5];
            for (n8 = 0; n8 < n7; ++n8) {
                n5 = n8 + (n6 - this.B);
                double cfr_ignored_4 = dArray[n5];
                double cfr_ignored_5 = dArray2[n8];
            }
        }
        n = this.y[n2] - this.B;
        if (n < 0) {
            n = 0;
            this.g.printErrorMessage("DownstreamOp.computeFlowLimit: Warning, _resLag[resId]-_minOffset less than zero");
            this.g.printErrorMessage("Downstream Rule - " + downstreamCntrlOpRule.getName());
        }
        opValue.value = d = dArray[n];
        return opValue;
    }

    @Override
    public Vector getActiveTSRecordProxies(Vector vector, int n) {
        vector = super.getActiveTSRecordProxies(vector, n);
        if (n == 0) {
            Object object = this.getTSRecordProxy(79);
            if (object != null && !vector.contains(object)) {
                vector.add(object);
            }
            if (this._downstreamCntrlParam == b && this._limitType == -1) {
                object = this.getTSRecordProxy(142);
                if (object != null && !vector.contains(object)) {
                    vector.add(object);
                }
            } else if (this._downstreamCntrlParam == b && this._limitType == 1 && (object = this.getTSRecordProxy(141)) != null && !vector.contains(object)) {
                vector.add(object);
            }
            object = this.getTSProxyName();
            if ((object = this.getTSRecordProxy((String)object + "-Final", 167)) != null) {
                vector.addElement(object);
            }
        }
        return vector;
    }

    @Override
    public void updateTSProxyList() {
        String string;
        TSRecordProxy tSRecordProxy;
        if (this instanceof DownstreamCntrlOpRule) {
            super.updateTSProxyList();
            return;
        }
        Object object = this.l != null ? ((RssTSLocationObject)this).getSystem().getNameForKeyString(this.l.getName()) + "-" + this.getName() : this.getName();
        if (this._limitType == -1) {
            tSRecordProxy = this.getTSRecordProxy((String)object, 82);
            if (tSRecordProxy == null) {
                this.addTSRecordProxy((String)object, 82);
            }
            if (this._downstreamCntrlParam == b && (tSRecordProxy = this.getTSRecordProxy((String)object, 142)) == null) {
                this.addTSRecordProxy((String)object, 142);
            }
        } else if (this._limitType == 1) {
            tSRecordProxy = this.getTSRecordProxy((String)object, 81);
            if (tSRecordProxy == null) {
                this.addTSRecordProxy((String)object, 81);
            }
            if (this._downstreamCntrlParam == b && (tSRecordProxy = this.getTSRecordProxy((String)object, 141)) == null) {
                this.addTSRecordProxy((String)object, 141);
            }
        } else {
            tSRecordProxy = this.getTSRecordProxy((String)object, 80);
            if (tSRecordProxy == null) {
                this.addTSRecordProxy((String)object, 80);
            }
        }
        if ((tSRecordProxy = this.getTSRecordProxy(string = (String)object + "-P", 202)) == null) {
            this.addTSRecordProxy(string, 202);
        }
        if ((tSRecordProxy = this.getTSRecordProxy((String)object, 79)) == null) {
            this.addTSRecordProxy((String)object, 79);
        }
        if (this._independentVariable != null && this._independentVariable.getType() == 3 && (tSRecordProxy = this.getTSRecordProxy((String)(object = this._independentVariable.getTimeSeriesName()), 85)) == null) {
            this.addTSRecordProxy((String)object, 85);
        }
        if (this.getTSRecordProxy((String)(object = this.getTSProxyName()) + "-Final", 167) == null) {
            this.addTSRecordProxy((String)object + "-Final", 167);
        }
    }

    @Override
    public double getLargestLimitValue() {
        double d = super.getLargestLimitValue();
        if (d == Double.NEGATIVE_INFINITY) {
            return d;
        }
        if (this._downstreamCntrlParam == b && this.m != null) {
            d = this.m.getFlowFromStage(null, d);
        }
        return d;
    }

    @Override
    public double getLimitValue(RunTimeStep runTimeStep) {
        double d = super.getLimitValue(runTimeStep);
        if (d == Double.NEGATIVE_INFINITY) {
            return d;
        }
        if (this._downstreamCntrlParam == b) {
            this.o.array[runTimeStep.step] = d;
            d = this.m.getFlowFromStage(runTimeStep, d);
        }
        if (this.h != null) {
            this.h.array[runTimeStep.step] = d;
        }
        return d;
    }

    public void copyInto(DownstreamOpRule downstreamOpRule) {
        try {
            this._downstreamCntrlParam = downstreamOpRule.getDownstreamControlParameter();
            this._downstreamLocationID = downstreamOpRule.getDownstreamControlLocationID();
            this._useContingency = downstreamOpRule.usesContingency();
            this._contingencyType = downstreamOpRule.getContingencyType();
            this._contingencyConst = downstreamOpRule.getContingencyConstant();
            this._contingencyPV = downstreamOpRule.getContingencyPV();
            this.i = downstreamOpRule.i;
            this.setLimitType(downstreamOpRule.getLimitType());
            IndependentVariable independentVariable = downstreamOpRule.getIndependentVariable();
            if (independentVariable != null) {
                this.setIndependentVariable((IndependentVariable)independentVariable.clone());
            } else {
                this.setIndependentVariable(null);
            }
            independentVariable = downstreamOpRule.getFunctionRelease();
            if (independentVariable != null) {
                this.setFunctionRelease(independentVariable.clone());
            } else {
                this.setFunctionRelease(null);
            }
            independentVariable = downstreamOpRule.getSeasonalRecord();
            if (independentVariable != null) {
                this.setSeasonalRecord((SeasonalRecord)independentVariable.clone());
            } else {
                this.setSeasonalRecord(null);
            }
            this._multiplier = downstreamOpRule._multiplier != null ? (DayOfWeekMultiplier)downstreamOpRule._multiplier.clone() : null;
            this._timeOfDayMultiplier = downstreamOpRule._timeOfDayMultiplier != null ? (TimeOfDayMultiplier)downstreamOpRule._timeOfDayMultiplier.clone() : null;
            this._useDayOfWeekMultiplier = downstreamOpRule._useDayOfWeekMultiplier;
            this._useTimeOfDayMultiplier = downstreamOpRule._useTimeOfDayMultiplier;
            this._enableRiseFallCond = downstreamOpRule._enableRiseFallCond;
            this._riseFallCondition = downstreamOpRule._riseFallCondition;
            this._avgPeriod = downstreamOpRule._avgPeriod;
            this._riseFallTolerance = downstreamOpRule._riseFallTolerance;
            this._parameterType = downstreamOpRule._parameterType;
            this._useDefaultOptions = downstreamOpRule._useDefaultOptions;
            this._downstreamOptions = downstreamOpRule._downstreamOptions != null ? downstreamOpRule._downstreamOptions.clone() : null;
            this.setName(downstreamOpRule.getName());
            this.setDescription(downstreamOpRule.getDescription());
            return;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("CloneNotSupportedException in DownstreamCntrlOpRule");
            return;
        }
    }

    public void copyChildInto(DownstreamCntrlOpRule downstreamCntrlOpRule) {
        this.copyInto(downstreamCntrlOpRule);
    }

    public void removeRuleRef(DownstreamCntrlOpRule downstreamCntrlOpRule) {
    }

    public int getDownstreamControlParameter() {
        return this._downstreamCntrlParam;
    }

    public void setDownstreamControlParameter(int n) {
        this._downstreamCntrlParam = n;
    }

    public int getDownstreamControlLocationID() {
        return this._downstreamLocationID;
    }

    public void setDownstreamControlLocationID(int n) {
        if (n < -1) {
            n = -1;
        }
        this._downstreamLocationID = n;
    }

    public void getTSRecordProxyVecResVar(Vector vector, int n) {
        if (this.k == null) {
            return;
        }
        for (int i = 0; i < this.k.size(); ++i) {
            String string;
            OpRule opRule = this.k.get(i);
            if (opRule == null || (opRule = opRule.getTSRecordProxy(string = opRule.getTSProxyName(), n)) == null) continue;
            vector.addElement(opRule);
        }
    }

    public TSRecordProxy getTSRecordProxyResVar(int n, int n2) {
        if (this.k == null || this.k.size() <= n) {
            return null;
        }
        OpRule opRule = this.k.get(n);
        if (opRule == null) {
            return null;
        }
        String string = opRule.getTSProxyName();
        opRule = opRule.getTSRecordProxy(string, n2);
        return opRule;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    public List<Element> getManagedElements() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        if (this.e == null || this.e.length == 0) {
            return arrayList;
        }
        int n = this.e.length;
        ArrayList arrayList2 = new ArrayList();
        block0: for (int i = 0; i < n; ++i) {
            this.H[i] = false;
            arrayList2.clear();
            ReservoirOp reservoirOp = this.e[i].getReservoirOp(false);
            OpSet opSet = reservoirOp.getActiveOpSet();
            reservoirOp.getDownstreamRules(opSet.getIndex(), arrayList2);
            int n2 = arrayList2.size();
            for (int j = 0; j < n2; ++j) {
                OpRule opRule = (OpRule)arrayList2.get(j);
                if (!(opRule instanceof DownstreamCntrlOpRule) || ((DownstreamCntrlOpRule)opRule).getParentRule() != this) continue;
                arrayList.add(this.e[i]);
                continue block0;
            }
        }
        return arrayList;
    }
}

