/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.model.TSLocation;
import hec.model.TSRecord;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.Dam;
import hec.rss.model.DownstreamOpRule;
import hec.rss.model.DssOutputGroups;
import hec.rss.model.Element;
import hec.rss.model.Function;
import hec.rss.model.Junction;
import hec.rss.model.OpController;
import hec.rss.model.OpRule;
import hec.rss.model.OpSet;
import hec.rss.model.PowerPlantFlow;
import hec.rss.model.PumpFlow;
import hec.rss.model.RssAlt;
import hec.rss.model.RssNode;
import hec.rss.model.Rule;
import hec.rss.model.Spillway;
import hec.rss.model.StateVariable;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.jdom.Content;

public class DssOutputData
implements AltInputReportInfc,
Cloneable {
    private HashMap _elementMap = new HashMap();
    private boolean _writeAllDSSOutput = true;
    private boolean _writeAllInterpolatedInputData = true;
    private RssAlt _alt;

    public DssOutputData(RssAlt rssAlt) {
        this._alt = rssAlt;
    }

    public RssAlt getAlt() {
        return this._alt;
    }

    public void setNoWriteRecord(String string, int n, int n2) {
        String string2 = n + ":" + n2;
        if (this._elementMap.containsKey(string)) {
            HashMap hashMap = (HashMap)this._elementMap.get(string);
            if (!hashMap.containsKey(string2)) {
                hashMap.put(string2, Boolean.TRUE);
                return;
            }
        } else {
            HashMap<CallSite, Boolean> hashMap = new HashMap<CallSite, Boolean>();
            hashMap.put((CallSite)((Object)string2), Boolean.TRUE);
            this._elementMap.put(string, hashMap);
        }
    }

    public boolean writeAll() {
        return this._writeAllDSSOutput;
    }

    public void setWriteAllDSSOutput(boolean bl) {
        this._writeAllDSSOutput = bl;
    }

    public boolean writeAllInputData() {
        return this._writeAllInterpolatedInputData;
    }

    public void setwriteAllInputData(boolean bl) {
        this._writeAllInterpolatedInputData = bl;
    }

    public void setNoWriteRecord(String string, int n, String object) {
        int[] nArray = DssOutputGroups.get(string + ":" + (String)object);
        object = nArray;
        if (nArray != null && ((Object)object).length > 0) {
            for (int i = 0; i < ((Object)object).length; ++i) {
                Object object2 = object[i];
                this.setNoWriteRecord(string, n, (int)object2);
            }
        }
    }

    public boolean writeRecord(TSRecord tSRecord) {
        tSRecord.getDSSFilename();
        return true;
    }

    public boolean writeRecord(TSRecordProxy tSRecordProxy) {
        if (this._writeAllDSSOutput) {
            return this._writeAllDSSOutput;
        }
        TSLocation tSLocation = tSRecordProxy.getParent();
        String string = "";
        int n = Integer.MIN_VALUE;
        if (tSLocation instanceof RssNode) {
            Element element = ((RssNode)tSLocation).getUpstreamElement();
            if (element == null) {
                element = ((RssNode)tSLocation).getDownstreamElement();
            }
            element = element.getTopParent();
            string = element.getElementType();
            n = element._index;
        } else if (tSLocation instanceof PowerPlantFlow) {
            tSLocation = (PowerPlantFlow)tSLocation;
            if (tSLocation.getAdjustableParameter().b == null) {
                string = tSLocation.getElement().getParent().getParent().getElementType();
                n = tSLocation.getElement().getParent().getParent().getIndex();
            } else {
                string = tSLocation.getAdjustableParameter().b.getElementOp().getOperationsElement().getElementType();
                n = tSLocation.getAdjustableParameter().b.getElementOp().getOperationsElement().getIndex();
            }
        } else if (tSLocation instanceof OpRule) {
            if ((tSLocation = (OpRule)tSLocation) instanceof DownstreamOpRule) {
                if (((DownstreamOpRule)tSLocation).getOperationsElement() != null) {
                    string = ((DownstreamOpRule)tSLocation).getOperationsElement().getElementType();
                    n = ((DownstreamOpRule)tSLocation).getOperationsElement().getIndex();
                } else if (((DownstreamOpRule)tSLocation).e != null && ((DownstreamOpRule)tSLocation).e[0] != null) {
                    string = ((DownstreamOpRule)tSLocation).e[0].getElementType();
                    n = ((DownstreamOpRule)tSLocation).e[0].getIndex();
                }
            } else if (tSLocation.getController() == null) {
                string = null;
                n = tSLocation.getIndex();
            } else {
                string = tSLocation.getController().a.getOperationsElement().getElementType();
                n = tSLocation.getController().a.getOperationsElement().getIndex();
            }
        } else if (tSLocation instanceof OpSet) {
            tSLocation = (OpSet)tSLocation;
            string = tSLocation._resOp.getOperationsElement().getElementType();
            n = tSLocation._resOp.getOperationsElement().getIndex();
        } else if (tSLocation instanceof Rule) {
            if ((tSLocation = (Rule)tSLocation).getController().getDiversionFunction() != null) {
                string = tSLocation.getController().getDiversionFunction().getElement().getElementType();
                n = tSLocation.getController().getDiversionFunction().getElement().getIndex();
            }
        } else if (tSLocation instanceof Function) {
            if ((tSLocation = (Function)tSLocation) instanceof Dam || tSLocation instanceof Spillway || tSLocation instanceof AdjustableFlow || tSLocation instanceof PumpFlow) {
                string = tSLocation.getElement()._parentElement.getParent().getElementType();
                n = tSLocation.getElement()._parentElement.getParent().getIndex();
            } else if (tSLocation instanceof Junction) {
                if (tSLocation.getElement()._parentElement != null) {
                    string = tSLocation.getElement()._parentElement.getParent().getElementType();
                    n = tSLocation.getElement()._parentElement.getParent().getIndex();
                } else {
                    string = tSLocation.getElement().getElementType();
                    n = tSLocation.getElement().getIndex();
                }
            } else if (tSLocation.getElement().getParent() != null) {
                string = tSLocation.getElement().getParent().getElementType();
                n = tSLocation.getElement().getParent().getIndex();
            } else {
                string = tSLocation.getElement().getElementType();
                n = tSLocation.getElement().getIndex();
            }
        } else if (tSLocation instanceof StateVariable) {
            tSLocation = (StateVariable)tSLocation;
            string = "state variable";
            n = tSLocation.getIndex();
        } else if (tSLocation instanceof OpController) {
            tSLocation = (OpController)tSLocation;
            string = tSLocation.getElementOp().getOperationsElement().getElementType();
            n = tSLocation.getElementOp().getOperationsElement().getIndex();
        }
        return this.writeRecord(string, n, tSRecordProxy.getVariableId());
    }

    public void clear() {
        this._elementMap.clear();
    }

    public boolean writeRecord(String object, int n, int n2) {
        String string = n + ":" + n2;
        return !this._elementMap.containsKey(object) || !((HashMap)(object = (HashMap)this._elementMap.get(object))).containsKey(string);
    }

    public void read(BufferedReader bufferedReader) throws IOException {
        this._elementMap = new HashMap();
        String string = bufferedReader.readLine();
        if (string.isEmpty()) {
            string = bufferedReader.readLine();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        if (string2.equals("WriteAllDssOutput")) {
            this.setWriteAllDSSOutput(Boolean.parseBoolean(string3));
            string = bufferedReader.readLine();
        }
        while (!string.equalsIgnoreCase("DssOutputDataEnd")) {
            if (string.startsWith("WriteAllInputDss")) {
                stringTokenizer = new StringTokenizer(string, ";");
                stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
                this.setwriteAllInputData(Boolean.parseBoolean(string3));
            } else if (string.equalsIgnoreCase("ElementHashTableBegin")) {
                string = bufferedReader.readLine();
                while (!string.equalsIgnoreCase("ElementHashTableEnd")) {
                    stringTokenizer = new StringTokenizer(string, ";");
                    string2 = stringTokenizer.nextToken();
                    string3 = stringTokenizer.nextToken();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    if (string2.equalsIgnoreCase("ElementKey")) {
                        String string4 = string3;
                        string = bufferedReader.readLine();
                        if (string.equalsIgnoreCase("VariableHashTableBegin")) {
                            string = bufferedReader.readLine();
                            while (!string.equalsIgnoreCase("VariableHashTableEnd")) {
                                stringTokenizer = new StringTokenizer(string, ";");
                                string2 = stringTokenizer.nextToken();
                                string3 = stringTokenizer.nextToken();
                                string = stringTokenizer.nextToken();
                                if (string2.equalsIgnoreCase("VariableKeys")) {
                                    hashMap.put(string3, string);
                                }
                                string = bufferedReader.readLine();
                            }
                            this._elementMap.put(string4, hashMap);
                        }
                    }
                    string = bufferedReader.readLine();
                }
            }
            string = bufferedReader.readLine();
        }
    }

    public void write(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("WriteAllDssOutput;" + this._writeAllDSSOutput);
        bufferedWriter.newLine();
        bufferedWriter.write("WriteAllInputDss;" + this._writeAllInterpolatedInputData);
        bufferedWriter.newLine();
        if (this._elementMap.isEmpty()) {
            return;
        }
        Object[] objectArray = this._elementMap.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            bufferedWriter.write("ElementHashTableBegin");
            bufferedWriter.newLine();
            HashMap hashMap = (HashMap)this._elementMap.get(objectArray[i]);
            bufferedWriter.write("ElementKey;" + (String)objectArray[i]);
            bufferedWriter.newLine();
            if (hashMap != null) {
                Object[] objectArray2 = hashMap.keySet().toArray();
                bufferedWriter.write("VariableHashTableBegin");
                bufferedWriter.newLine();
                hashMap = (HashMap)this._elementMap.get(objectArray[i]);
                for (int j = 0; j < objectArray2.length; ++j) {
                    bufferedWriter.write("VariableKeys;" + (String)objectArray2[j] + ";" + String.valueOf(hashMap.get(objectArray2[j])));
                    bufferedWriter.newLine();
                }
                bufferedWriter.write("VariableHashTableEnd");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("ElementHashTableEnd");
            bufferedWriter.newLine();
        }
    }

    public Object clone() {
        try {
            DssOutputData dssOutputData = (DssOutputData)super.clone();
            ((DssOutputData)super.clone())._writeAllDSSOutput = this._writeAllDSSOutput;
            dssOutputData._writeAllInterpolatedInputData = this._writeAllInterpolatedInputData;
            return dssOutputData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("clone: Exception cloning HotstartOptions " + String.valueOf(cloneNotSupportedException));
            return null;
        }
    }

    @Override
    public void outputReport(AlternativeInputReport objectArray, org.jdom.Element element) {
        element.setAttribute("Write_DSS_Output", Boolean.toString(this._writeAllDSSOutput));
        element.setAttribute("Write_Interpolated_Input_DSS_Data", Boolean.toString(this._writeAllInterpolatedInputData));
        if (this._writeAllDSSOutput) {
            return;
        }
        if (this._elementMap.isEmpty()) {
            return;
        }
        objectArray = this._elementMap.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Object[] objectArray2 = (Object[])this._elementMap.get(objectArray[i]);
            String string = (String)objectArray[i];
            string = string.replace(' ', '_');
            string = new org.jdom.Element(string);
            element.setContent((Content)string);
            if (objectArray2 == null) continue;
            objectArray2 = objectArray2.keySet().toArray();
            HashMap cfr_ignored_0 = (HashMap)this._elementMap.get(objectArray[i]);
            for (int j = 0; j < objectArray2.length; ++j) {
                org.jdom.Element element2 = new org.jdom.Element("Element");
                string.addContent((Content)element2);
                Object object = ((String)objectArray2[j]).substring(0, ((String)objectArray2[j]).indexOf(":"));
                String string2 = ((String)objectArray2[j]).substring(((String)objectArray2[j]).indexOf(":") + 1, ((String)objectArray2[j]).length());
                object = this._alt.getSystem().getElement(Integer.parseInt((String)object));
                if (object != null) {
                    element2.setAttribute("Name", ((Element)object).getDisplayName());
                }
                element2.setAttribute("VID", string2);
            }
        }
    }
}

