/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.rss.model.DssOutputData;
import hec.rss.model.DssOutputGroups;
import hec.rss.model.Element;
import hec.rss.model.StateVariable;
import hec.ui.TristateCheckBox;
import hec.ui.TristateCheckBoxData;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JOptionPane;
import rma.swing.table.RmaTableModel;
import rma.swing.table.RmaTableModelInterface;

public class DssOutputTableModel
extends RmaTableModel
implements RmaTableModelInterface {
    private String[] _columnHeaders;
    private Class _elementClass;
    TristateCheckBoxData[][] _data;
    boolean _tableFilling;

    public DssOutputTableModel(String[] stringArray) {
        super.setColumnNames(stringArray);
        this._columnHeaders = stringArray;
    }

    public void setDataArray(TristateCheckBoxData[][] tristateCheckBoxDataArray, Class clazz) {
        this._data = tristateCheckBoxDataArray;
        this._elementClass = clazz;
        for (int i = 0; i < this._columnHeaders.length; ++i) {
            for (int j = 0; j < this.getRowCount(); ++j) {
                if (tristateCheckBoxDataArray[j][i] != null) continue;
                tristateCheckBoxDataArray[j][i] = new TristateCheckBoxData("", TristateCheckBox.SELECTED);
            }
        }
        this.checkRowColumnHeadersState(0, 0);
        this.fireTableDataChanged();
    }

    public void setTableFilling(boolean bl) {
        this._tableFilling = bl;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n < 0 || n2 < 0) {
            return;
        }
        if (n2 == 0) {
            object = this._data[n][n2];
            if (object.getState() != TristateCheckBox.NOT_SELECTED) {
                object.setState(TristateCheckBox.NOT_SELECTED);
            } else {
                object.setState(TristateCheckBox.SELECTED);
            }
            this.setValue((TristateCheckBoxData)object, n, n2);
            this.fireTableDataChanged();
        } else if (n == 0) {
            object = this._data[n][n2];
            if (object.getState() != TristateCheckBox.NOT_SELECTED) {
                object.setState(TristateCheckBox.NOT_SELECTED);
            } else {
                object.setState(TristateCheckBox.SELECTED);
            }
            this.setValue((TristateCheckBoxData)object, n, n2);
            this.fireTableDataChanged();
        } else {
            super.setValueAt(object, n, n2);
        }
        this.checkRowColumnHeadersState(n, n2);
    }

    private void setValue(TristateCheckBoxData tristateCheckBoxData, int n, int n2) {
        if (tristateCheckBoxData == null) {
            tristateCheckBoxData = new TristateCheckBoxData("", TristateCheckBox.SELECTED);
        }
        if (n == 0 && n2 == 0) {
            if (tristateCheckBoxData.getState() == TristateCheckBox.SEMI_SELECTED && this._data[n][n2].getState() == TristateCheckBox.NOT_SELECTED || tristateCheckBoxData.getState() == TristateCheckBox.SELECTED) {
                this.setAllDataStates(TristateCheckBox.SELECTED);
                return;
            }
            this.setAllDataStates(TristateCheckBox.NOT_SELECTED);
            return;
        }
        if (n == 0) {
            if (tristateCheckBoxData.getState() == TristateCheckBox.SEMI_SELECTED) {
                tristateCheckBoxData.setState(TristateCheckBox.NOT_SELECTED);
            }
            this.setColumnState(n2, tristateCheckBoxData.getState());
        } else if (n2 == 0 && tristateCheckBoxData.getState() != TristateCheckBox.SEMI_SELECTED) {
            this.setRowSelected(n, tristateCheckBoxData.getState());
        }
        if (n > 0 && n2 > 0) {
            if (tristateCheckBoxData.getState() == TristateCheckBox.SEMI_SELECTED || this._data[n][n2].getState() == TristateCheckBox.SEMI_SELECTED) {
                tristateCheckBoxData.setState(TristateCheckBox.NOT_SELECTED);
            }
            this._data[n][n2] = tristateCheckBoxData;
        }
        this.checkRowColumnHeadersState(n, n2);
    }

    public TristateCheckBox.State nextState(TristateCheckBox.State state) {
        TristateCheckBox.State state2 = TristateCheckBox.NOT_SELECTED;
        if (state == TristateCheckBox.NOT_SELECTED) {
            state2 = TristateCheckBox.SELECTED;
        } else if (state == TristateCheckBox.SELECTED) {
            state2 = TristateCheckBox.SEMI_SELECTED;
        } else if (state == TristateCheckBox.SEMI_SELECTED) {
            state2 = TristateCheckBox.NOT_SELECTED;
        }
        return state2;
    }

    private void setAllDataStates(TristateCheckBox.State state) {
        Boolean bl = state == TristateCheckBox.SELECTED ? Boolean.TRUE : Boolean.FALSE;
        for (int i = 0; i < this._columnHeaders.length; ++i) {
            for (int j = 0; j < this.getRowCount(); ++j) {
                if (this._data[j][i] == null) {
                    this._data[j][i] = new TristateCheckBoxData("", state);
                    continue;
                }
                this._data[j][i].setState(state);
                if (j <= 0 || i <= 0) continue;
                super.setValueAt((Object)bl, j, i);
            }
        }
    }

    private void setColumnState(int n, TristateCheckBox.State state) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this._data[i][n] == null) {
                this._data[i][n] = new TristateCheckBoxData("", state);
                continue;
            }
            if (n == 0 || i == 0) {
                this._data[i][n].setState(state);
                continue;
            }
            if (state == TristateCheckBox.SEMI_SELECTED) continue;
            if (state == TristateCheckBox.NOT_SELECTED) {
                super.setValueAt((Object)Boolean.valueOf("false"), i, n);
                continue;
            }
            super.setValueAt((Object)Boolean.valueOf("true"), i, n);
        }
    }

    public void checkRowColumnHeadersState(int n, int n2) {
        if (this._tableFilling) {
            return;
        }
        boolean bl = true;
        boolean bl2 = true;
        if (n == 0) {
            for (n = 1; n < this.getRowCount(); ++n) {
                TristateCheckBox.State state = this.checkRowSelectedState(n);
                this._data[n][0].setState(state);
                if (state != TristateCheckBox.SELECTED && state != TristateCheckBox.SEMI_SELECTED) {
                    bl2 = false;
                    continue;
                }
                if (state != TristateCheckBox.SELECTED) continue;
                bl = false;
            }
        } else if (n2 == 0) {
            for (n = 1; n < this.getColumnCount(); ++n) {
                TristateCheckBox.State state = this.checkColumnSelectedState(n);
                this._data[0][n].setState(state);
                if (state != TristateCheckBox.SELECTED && state != TristateCheckBox.SEMI_SELECTED) {
                    bl2 = false;
                    continue;
                }
                if (state != TristateCheckBox.SELECTED) continue;
                bl = false;
            }
        }
        if (bl) {
            this._data[0][0].setState(TristateCheckBox.NOT_SELECTED);
        } else if (bl2) {
            this._data[0][0].setState(TristateCheckBox.SELECTED);
        } else {
            this._data[0][0].setState(TristateCheckBox.SEMI_SELECTED);
        }
        this.fireTableDataChanged();
    }

    public TristateCheckBox.State checkRowSelectedState(int n) {
        int n2 = 0;
        for (int i = 1; i < this.getColumnCount(); ++i) {
            Object object = this.getValueAt(n, i);
            if (!(object instanceof Boolean) || !((Boolean)object).booleanValue()) continue;
            ++n2;
        }
        if (n2 == 0) {
            return TristateCheckBox.NOT_SELECTED;
        }
        if (n2 == this.getColumnCount() - 1) {
            return TristateCheckBox.SELECTED;
        }
        return TristateCheckBox.SEMI_SELECTED;
    }

    public TristateCheckBox.State checkColumnSelectedState(int n) {
        int n2 = 0;
        for (int i = 1; i < this.getRowCount(); ++i) {
            Object object = this.getValueAt(i, n);
            if (!(object instanceof Boolean) || !((Boolean)object).booleanValue()) continue;
            ++n2;
        }
        if (n2 == 0) {
            return TristateCheckBox.NOT_SELECTED;
        }
        if (n2 == this.getRowCount() - 1) {
            return TristateCheckBox.SELECTED;
        }
        return TristateCheckBox.SEMI_SELECTED;
    }

    public TristateCheckBox.State checkAllSelectedState() {
        int n = 0;
        int n2 = 0;
        for (int i = 1; i < this.getRowCount(); ++i) {
            Object object = this.getValueAt(i, 0);
            if (!(object instanceof TristateCheckBoxData)) continue;
            if ((object = (TristateCheckBoxData)object).getState() == TristateCheckBox.SELECTED) {
                ++n;
            }
            if (object.getState() != TristateCheckBox.SEMI_SELECTED) continue;
            ++n2;
        }
        if (n == 0) {
            if (n2 > 0) {
                return TristateCheckBox.SEMI_SELECTED;
            }
            return TristateCheckBox.NOT_SELECTED;
        }
        if (n == this.getRowCount() - 1) {
            return TristateCheckBox.SELECTED;
        }
        return TristateCheckBox.SEMI_SELECTED;
    }

    private void setRowSelected(int n, TristateCheckBox.State state) {
        for (int i = 0; i < this._columnHeaders.length; ++i) {
            if (this._data[n][i] == null) {
                this._data[n][i] = new TristateCheckBoxData("", state);
                continue;
            }
            if (i == 0 || n == 0) {
                this._data[n][i].setState(state);
                continue;
            }
            if (state == TristateCheckBox.SEMI_SELECTED) continue;
            if (state == TristateCheckBox.NOT_SELECTED) {
                super.setValueAt((Object)Boolean.valueOf("false"), n, i);
                continue;
            }
            super.setValueAt((Object)Boolean.valueOf("true"), n, i);
        }
    }

    public Object getValueAt(int n, int n2) {
        if (n < 0 || n2 < 0 || this._data == null) {
            return null;
        }
        if (n2 == 0 && n > 0) {
            this._data[n][n2].setState(this.checkRowSelectedState(n));
            return this._data[n][n2];
        }
        if (n == 0 && n2 > 0) {
            this._data[n][n2].setState(this.checkColumnSelectedState(n2));
            return this._data[n][n2];
        }
        if (n == 0 && n2 == 0) {
            this._data[n][n2].setState(this.checkAllSelectedState());
            return this._data[n][n2];
        }
        if (n < this.getRowCount() && n2 < this.getColumnCount()) {
            return super.getValueAt(n, n2);
        }
        return null;
    }

    public RmaTableModel getModel() {
        return this;
    }

    public void saveTable(DssOutputData dssOutputData) {
        Object object;
        if (this._data == null) {
            return;
        }
        Vector<Object> vector = new Vector<StateVariable>();
        if (this._elementClass == StateVariable.class) {
            object = dssOutputData.getAlt().getSystem().getStateVariableList();
            vector.addAll((Collection<Object>)object);
        } else {
            vector = dssOutputData.getAlt().getSystem().getElementVectorByClass(this._elementClass);
        }
        boolean bl = false;
        for (int i = 1; i < this.getRowCount(); ++i) {
            block1: for (int j = 1; j < this.getColumnCount(); ++j) {
                Object object2 = this.getValueAt(i, j);
                if (!(object2 instanceof Boolean)) {
                    this.getValueAt(i, j);
                    bl = true;
                    continue;
                }
                object2 = (Boolean)this.getValueAt(i, j);
                if (((Boolean)object2).booleanValue()) continue;
                object2 = this._data[i][0].getLabel();
                object2 = ((String)object2).trim();
                for (int k = 0; k < vector.size(); ++k) {
                    Object object3;
                    if (vector.get(k) instanceof StateVariable) {
                        object3 = (StateVariable)vector.get(k);
                        if (!object3.getDisplayName().equals(object2)) continue;
                        int n = object3.getIndex();
                        if (n == Integer.MIN_VALUE) continue block1;
                        object3 = DssOutputGroups.get("state variable:" + this._columnHeaders[j]);
                        for (k = 0; k < ((Object)object3).length; ++k) {
                            dssOutputData.setNoWriteRecord("state variable", n, (int)object3[k]);
                        }
                        continue block1;
                    }
                    object = (Element)vector.get(k);
                    if (!((Element)object).getDisplayName().equals(object2)) continue;
                    int n = object.getIndex();
                    if (n == Integer.MIN_VALUE) continue block1;
                    object3 = DssOutputGroups.get(((Element)object).getElementType() + ":" + this._columnHeaders[j]);
                    for (k = 0; k < ((Object)object3).length; ++k) {
                        dssOutputData.setNoWriteRecord(((Element)object).getElementType(), n, (int)object3[k]);
                    }
                    continue block1;
                }
            }
        }
        if (bl) {
            JOptionPane.showMessageDialog(null, "Problem Saving DssOutput Options");
        }
    }
}

