/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.lang.InvalidStateException;
import hec.rss.model.Channel;
import hec.rss.model.ChannelType;
import hec.rss.model.FlowCrossSection;
import java.lang.reflect.Field;

public class EightPointChannel
extends Channel {
    private double[] _x = new double[8];
    private double[] _y = new double[8];
    private double[] _manningsN = new double[3];

    public EightPointChannel() {
        int n;
        for (n = 0; n < 8; ++n) {
            this._x[n] = Double.NEGATIVE_INFINITY;
            this._y[n] = Double.NEGATIVE_INFINITY;
        }
        for (n = 0; n < 3; ++n) {
            this._manningsN[n] = Double.NEGATIVE_INFINITY;
        }
    }

    @Override
    public ChannelType getChannelType() {
        return ChannelType.EIGHT_POINT;
    }

    public double[] getXCoordinates() {
        double[] dArray = new double[this._x.length];
        for (int i = 0; i < this._x.length; ++i) {
            dArray[i] = this._x[i];
        }
        return dArray;
    }

    public double[] getYCoordinates() {
        double[] dArray = new double[this._y.length];
        for (int i = 0; i < this._y.length; ++i) {
            dArray[i] = this._y[i];
        }
        return dArray;
    }

    public double[] getManningsN() {
        double[] dArray = new double[this._manningsN.length];
        for (int i = 0; i < this._manningsN.length; ++i) {
            dArray[i] = this._manningsN[i];
        }
        return dArray;
    }

    public void setXCoordinates(double[] dArray) {
        int n;
        int n2 = Math.min(dArray.length, 8);
        for (n = 0; n < n2; ++n) {
            this._x[n] = dArray[n];
        }
        for (n = n2; n < 8; ++n) {
            this._x[n] = Double.NEGATIVE_INFINITY;
        }
    }

    public void setYCoordinates(double[] dArray) {
        int n;
        int n2 = Math.min(dArray.length, 8);
        for (n = 0; n < n2; ++n) {
            this._y[n] = dArray[n];
        }
        for (n = n2; n < 8; ++n) {
            this._y[n] = Double.NEGATIVE_INFINITY;
        }
    }

    public void setManningsN(double[] dArray) {
        int n;
        int n2 = Math.min(dArray.length, 3);
        for (n = 0; n < n2; ++n) {
            this._manningsN[n] = dArray[n];
        }
        for (n = n2; n < 3; ++n) {
            this._manningsN[n] = Double.NEGATIVE_INFINITY;
        }
    }

    @Override
    public boolean isValid() throws InvalidStateException {
        int n;
        int n2 = 0;
        if (!super.isValid()) {
            ++n2;
        }
        for (n = 1; n < 8; ++n) {
            if (!(Math.abs(this._x[n] - this._x[0]) < Math.abs(this._x[n - 1] - this._x[0]))) continue;
            System.out.println("ERROR: Distance coordinates for 8-point cross-section are not consistent");
            throw new InvalidStateException((Object)this, "Distance coordinates for 8-point cross-section are not consistent");
        }
        for (n = 0; n < 3; ++n) {
            if (!(this._manningsN[n] <= 0.0)) continue;
            System.out.println("ERROR: Invalid Manning's n for 8-point cross-section");
            EightPointChannel eightPointChannel = this;
            throw new InvalidStateException((Object)eightPointChannel, "Invalid Manning's n (" + eightPointChannel._manningsN[n] + ") at position " + (n + 1) + " for 8-point cross-section");
        }
        return n2 == 0;
    }

    @Override
    public double getTopWidth(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        FlowCrossSection flowCrossSection = new FlowCrossSection();
        this.computeFlowCrossSection(d, flowCrossSection);
        return flowCrossSection.c;
    }

    @Override
    public double getCelerity(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        double d2 = this.getMinY();
        FlowCrossSection flowCrossSection = new FlowCrossSection();
        this.computeFlowCrossSection(d, flowCrossSection);
        double d3 = flowCrossSection.d;
        double d4 = d3 * Math.sqrt(this._slope);
        double d5 = flowCrossSection.a;
        double d6 = d + 0.01;
        for (int i = 1; i < 8; ++i) {
            if (!(d + d2 <= this._y[i]) || !(d6 + d2 >= this._y[i])) continue;
            d6 = d - 0.01;
        }
        this.computeFlowCrossSection(d6, flowCrossSection);
        d3 = flowCrossSection.d;
        double d7 = d3 * Math.sqrt(this._slope);
        double d8 = flowCrossSection.a;
        return (d7 - d4) / (d8 - d5);
    }

    double getMinY() {
        double d = this._y[0];
        for (int i = 1; i < 8; ++i) {
            d = Math.min(d, this._y[i]);
        }
        return d;
    }

    @Override
    public double getDepth(double d) {
        double d2 = Math.max(this._x[5] - this._x[2], 1.0);
        double d3 = d / 1.5 / d2;
        int n = 0;
        FlowCrossSection flowCrossSection = new FlowCrossSection();
        this.computeFlowCrossSection(d3, flowCrossSection);
        double d4 = flowCrossSection.d;
        double d5 = d - d4 * Math.sqrt(this._slope);
        double d6 = d3 * 1.1;
        this.computeFlowCrossSection(d6, flowCrossSection);
        d4 = flowCrossSection.d;
        double d7 = d - d4 * Math.sqrt(this._slope);
        double d8 = 0.0;
        while (n < 20) {
            ++n;
            d8 = d5 * d7 < 0.0 && (d3 > d6 * 2.0 || d6 > d3 * 2.0) ? 0.5 * (d3 + d6) : d6 - d7 * (d6 - d3) / (d7 - d5);
            if (Math.abs(d8 - d3) < 0.001 || Math.abs(d8 - d6) < 0.001) break;
            this.computeFlowCrossSection(d8, flowCrossSection);
            d4 = flowCrossSection.d;
            double d9 = d - d4 * Math.sqrt(this._slope);
            if (d7 * d9 < 0.0) {
                if (d5 * d7 < 0.0) {
                    d3 = d8;
                    d5 = d9;
                    continue;
                }
                if (Math.abs(d5) > Math.abs(d7)) {
                    d3 = d6;
                    d5 = d7;
                }
                d6 = d8;
                d7 = d9;
                continue;
            }
            if (d5 * d7 < 0.0) {
                d6 = d8;
                d7 = d9;
                continue;
            }
            if (Math.abs(d5) > Math.abs(d7)) {
                d3 = d6;
                d5 = d7;
            }
            d6 = d8;
            d7 = d9;
        }
        if (d8 < 0.0) {
            d8 = 0.0;
        }
        return d8;
    }

    void computeFlowCrossSection(double d, FlowCrossSection flowCrossSection) {
        double d2 = 1.0;
        if (this.getUnitSystem() == 1) {
            d2 = 1.486;
        }
        double d3 = d + this.getMinY();
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray[i] = 0.0;
            dArray2[i] = 0.0;
        }
        flowCrossSection.b = d;
        flowCrossSection.c = 0.0;
        flowCrossSection.a = 0.0;
        flowCrossSection.d = 0.0;
        double d4 = 0.0;
        double d5 = this._x[0];
        double d6 = this._y[0];
        double d7 = this._x[0];
        double d8 = this._y[0];
        int n = 0;
        for (int i = 1; i < 8; ++i) {
            double d9;
            double d10;
            double d11;
            if (d3 > this._y[i - 1]) {
                d5 = this._x[i - 1];
                d6 = this._y[i - 1];
                d11 = d3 - d6;
                if (d3 > this._y[i]) {
                    d7 = this._x[i];
                    d8 = this._y[i];
                    d10 = d3 - d8;
                } else {
                    d10 = 0.0;
                    d8 = d3;
                    d7 = this._x[i - 1] + (this._x[i] - this._x[i - 1]) * (d8 - this._y[i - 1]) / (this._y[i] - this._y[i - 1]);
                }
                d9 = Math.abs(d7 - d5);
            } else if (d3 > this._y[i]) {
                d11 = 0.0;
                d6 = d3;
                d5 = this._x[i] - (this._x[i] - this._x[i - 1]) * (this._y[i] - d6) / (this._y[i] - this._y[i - 1]);
                d7 = this._x[i];
                d8 = this._y[i];
                d10 = d3 - d8;
                d9 = Math.abs(d7 - d5);
            } else {
                d11 = 0.0;
                d10 = 0.0;
                d9 = 0.0;
            }
            if (d11 + d10 > 0.0) {
                int n2 = n;
                dArray[n2] = dArray[n2] + 0.5 * (d11 + d10) * d9;
                double d12 = d5 - d7;
                double d13 = d6 - d8;
                double d14 = d12;
                double d15 = d13;
                d4 += Math.sqrt(d14 * d14 + d15 * d15);
                flowCrossSection.c += d9;
            }
            if (i != 2 && i != 5 && i != 7) continue;
            if (d4 > 0.0) {
                dArray2[n] = d2 / this._manningsN[n] * dArray[n] * Math.pow(dArray[n] / d4, 0.6666666666666666);
            }
            ++n;
            d4 = 0.0;
        }
        flowCrossSection.d = 0.0;
        for (n = 0; n < 3; ++n) {
            flowCrossSection.d += dArray2[n];
            flowCrossSection.a += dArray[n];
        }
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

