/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.lang.NamedType;
import hec.map.WorldPt;
import hec.model.ModelVariable;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.model.TSLocation;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.AdjustableParameter;
import hec.rss.model.DiversionElement;
import hec.rss.model.DivertedOutletElement;
import hec.rss.model.ElementHotstartState;
import hec.rss.model.ForebayHeadLoss;
import hec.rss.model.Function;
import hec.rss.model.FunctionFactory;
import hec.rss.model.HindcastData;
import hec.rss.model.HotstartState;
import hec.rss.model.JunctionElement;
import hec.rss.model.PlotVariableConstants;
import hec.rss.model.ReachElement;
import hec.rss.model.ReleaseElement;
import hec.rss.model.ReservoirDamElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.Routing;
import hec.rss.model.RssModelVariableConstants;
import hec.rss.model.RssNode;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocation;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.RunTime;
import hec.rss.model.TailElevContainer;
import hec.rss.model.TailwaterElevation;
import hec.rss.model.WaterControlDevice;
import hec.watershed.res.model.PlottableObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import rma.util.RMAConst;
import rma.util.RMAIO;
import rma.util.rmaTokenizer;

public class Element
extends NamedType
implements PlotVariableConstants,
RssModelVariableConstants,
RssReturnStatusConstants,
RssTSLocation,
PlottableObject {
    public static final int RESERVIOR_ELEMENT_ID = 1;
    public static final int REACH_ELEMENT_ID = 2;
    public static final int JUNCTION_ELEMENT_ID = 4;
    public static final int DIVERSION_ELEMENT_ID = 8;
    public static final int DIVERTEDOUTLET_ELEMENT_ID = 16;
    public static final int OUTFLOW = 0;
    public static final int INFLOW = 1;
    RssSystem _system;
    Vector<RssNode> _nodeVector = new Vector();
    Vector<Integer> _nodeDirVector = new Vector();
    Vector<Element> _elemVector = new Vector();
    Vector _obsDataVector;
    Function _function;
    ForebayHeadLoss _forebayHeadLoss = null;
    WaterControlDevice _waterControlDevice = null;
    Element _parentElement = null;
    private transient boolean a = true;
    private transient boolean b = true;
    private transient int c = -1;

    public Element() {
    }

    public Element(RssSystem rssSystem, int n) {
        this._system = rssSystem;
        this._index = n;
    }

    protected void initTSVals(int n) {
        if (this._function != null) {
            this._function.initTSVals(n);
        }
        int n2 = this._elemVector.size();
        for (int i = 0; i < n2; ++i) {
            Element element = this._elemVector.get(i);
            element.initTSVals(n);
        }
    }

    public boolean hasWaterControlDevice() {
        return this._waterControlDevice != null;
    }

    public WaterControlDevice getWaterControlDevice() {
        return this._waterControlDevice;
    }

    public void setWaterControlDevice(WaterControlDevice waterControlDevice) {
        this._waterControlDevice = waterControlDevice;
    }

    public boolean hasForebayHeadLoss() {
        return this._forebayHeadLoss != null;
    }

    public void setHasForebayHeadLoss(boolean bl) {
        if (bl) {
            if (this._forebayHeadLoss == null) {
                this._forebayHeadLoss = new ForebayHeadLoss(this);
                return;
            }
        } else {
            this._forebayHeadLoss = null;
        }
    }

    public ForebayHeadLoss getForebayHeadLoss() {
        return this._forebayHeadLoss;
    }

    public double getEffectiveElev(RunTimeStep runTimeStep) {
        if (this._parentElement == null) {
            return Double.NEGATIVE_INFINITY;
        }
        double d = 0.0;
        double d2 = this._parentElement.getEffectiveElev(runTimeStep);
        if (!RMAConst.isValidValue((double)d2)) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._forebayHeadLoss != null && (d = this._forebayHeadLoss.getHeadLoss(runTimeStep)) != Double.NEGATIVE_INFINITY) {
            this._forebayHeadLoss.a.set(runTimeStep.getStep(), d2 - d);
            this._forebayHeadLoss.b.set(runTimeStep.getStep(), d);
        }
        return d2 -= d;
    }

    public double getPrevEffectiveElev(RunTimeStep runTimeStep) {
        if (this._parentElement == null) {
            return Double.NEGATIVE_INFINITY;
        }
        double d = 0.0;
        double d2 = this._parentElement.getPrevEffectiveElev(runTimeStep);
        if (!RMAConst.isValidValue((double)d2)) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._forebayHeadLoss != null) {
            d = this._forebayHeadLoss.getPrevHeadLoss(runTimeStep);
        }
        return d2 -= d;
    }

    public List getTailwaterElevationObjects(List arrayList) {
        TailwaterElevation tailwaterElevation;
        if (arrayList == null) {
            arrayList = new ArrayList<TailwaterElevation>();
        }
        if (this instanceof TailElevContainer && ((TailElevContainer)((Object)this)).hasTailElev() && (tailwaterElevation = ((TailElevContainer)((Object)this)).getTailwaterElevation()) != null && !arrayList.contains(tailwaterElevation)) {
            arrayList.add(tailwaterElevation);
        }
        if (this._function != null && this._function instanceof TailElevContainer && ((TailElevContainer)((Object)this._function)).hasTailElev() && (tailwaterElevation = ((TailElevContainer)((Object)this._function)).getTailwaterElevation()) != null && !arrayList.contains(tailwaterElevation)) {
            arrayList.add(tailwaterElevation);
        }
        int n = this._elemVector.size();
        for (int i = 0; i < n; ++i) {
            Element element = this._elemVector.get(i);
            element.getTailwaterElevationObjects(arrayList);
        }
        return arrayList;
    }

    public List getRuleConnectivityRefs() {
        return null;
    }

    public static int a(ModelVariable object) {
        if (object == null || object.getObjectType() == null) {
            return 0;
        }
        if ("reservoir".equalsIgnoreCase((String)(object = object.getObjectType()))) {
            return 1;
        }
        if ("reach".equalsIgnoreCase((String)object)) {
            return 2;
        }
        if ("diversion".equalsIgnoreCase((String)object)) {
            return 8;
        }
        if ("diverted outlet".equalsIgnoreCase((String)object)) {
            return 16;
        }
        if ("junction".equalsIgnoreCase((String)object)) {
            return 4;
        }
        return 0;
    }

    public String toString() {
        return this._system.getNameForKeyString(this.getName());
    }

    public void setupForSerialization() {
        if (this._function != null) {
            this._function.setupForSerialization();
        }
        if (this._elemVector == null) {
            return;
        }
        int n = this._elemVector.size();
        for (int i = 0; i < n; ++i) {
            Element element = this._elemVector.get(i);
            element.setupForSerialization();
        }
        if (this._forebayHeadLoss != null) {
            this._forebayHeadLoss.setupForSerialization();
        }
    }

    public void cleanupFromDeSerialization() {
        if (this._function != null) {
            this._function.cleanupFromDeSerialization();
        }
        if (this._elemVector == null) {
            return;
        }
        for (int i = 0; i < this._elemVector.size(); ++i) {
            Element element = this._elemVector.get(i);
            element.cleanupFromDeSerialization();
        }
    }

    public List getReleaseElements(List list) {
        if (list == null) {
            list = new ArrayList<Element>();
        } else {
            list.clear();
        }
        if (this instanceof ReleaseElement) {
            list.add(this);
        }
        int n = this._elemVector.size();
        for (int i = 0; i < n; ++i) {
            Element element = this._elemVector.get(i);
            if (!(element instanceof ReleaseElement)) continue;
            list = element.getReleaseElements(list);
        }
        return list;
    }

    public String getDisplayName() {
        String string = this.getName();
        if (this._system.isKeyString(string)) {
            return string;
        }
        if (this._parentElement != null) {
            return this.getTopParent().getDisplayName() + "-" + this.getName();
        }
        return this.getName();
    }

    protected String getOutputBPart() {
        List list = this.getFullNameList();
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            n += list.get(i).toString().length();
        }
        if (n <= 64) {
            return this.getFullName();
        }
        RssSystem rssSystem = this.getSystem();
        if (rssSystem != null) {
            return rssSystem.generateUniquePathPart(list, "-");
        }
        return this.getFullName().substring(0, 64);
    }

    List getFullNameList() {
        ArrayList<String> arrayList = null;
        if (this._parentElement != null) {
            arrayList = this._parentElement.getFullNameList();
        }
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        arrayList.add(this.getName());
        return arrayList;
    }

    public String getFullName() {
        if (this._parentElement != null) {
            return this._parentElement.getFullName() + "-" + this.getName();
        }
        return this.getName();
    }

    public String getTopParentName() {
        if (this._parentElement != null) {
            return this._parentElement.getTopParentName();
        }
        return this.getName();
    }

    public void applyHindcastData(HindcastData hindcastData) {
    }

    public void getHindcastDataList(Vector vector) {
        if (vector == null) {
            return;
        }
        if (this._function != null) {
            this._function.getHindcastDataList(vector);
        }
        int n = this._elemVector.size();
        for (int i = 0; i < n; ++i) {
            Element element = this._elemVector.elementAt(i);
            if (element == null || !element.isActive()) continue;
            element.getHindcastDataList(vector);
        }
    }

    public Vector getOutletElementList() {
        Vector vector = new Vector();
        this.getOutletElementList(vector);
        return vector;
    }

    public void getOutletElementList(Vector vector) {
        int n = this._elemVector.size();
        for (int i = 0; i < n; ++i) {
            Element element = this._elemVector.elementAt(i);
            if (element.getFunction() instanceof AdjustableFlow) {
                vector.addElement(element);
            }
            element.getOutletElementList(vector);
        }
    }

    public int getChildElementCount() {
        return this._elemVector.size();
    }

    public Element getChildElementAt(int n) {
        if (n < 0 || n >= this._elemVector.size()) {
            return null;
        }
        return this._elemVector.elementAt(n);
    }

    public Enumeration children() {
        return this._elemVector.elements();
    }

    public int getUnitSystem() {
        return this._system.getUnitSystem();
    }

    public synchronized Object clone() {
        try {
            Element element = (Element)super.clone();
            ((Element)super.clone())._nodeVector = (Vector)this._nodeVector.clone();
            element._nodeDirVector = (Vector)this._nodeDirVector.clone();
            element._elemVector = new Vector();
            int n = this._elemVector.size();
            for (int i = 0; i < n; ++i) {
                Element element2 = this._elemVector.elementAt(i);
                if (element2 == null) continue;
                element2 = (Element)element2.clone();
                element2.setParentElement(element);
                element._elemVector.addElement(element2);
            }
            if (this._function != null) {
                element._function = (Function)((RssTSLocationObject)this._function).clone();
                element._function.setElement(element);
            }
            if (this._forebayHeadLoss != null) {
                element._forebayHeadLoss = (ForebayHeadLoss)((RssTSLocationObject)this._forebayHeadLoss).clone();
                element._forebayHeadLoss.setElement(element);
            }
            if (this._obsDataVector != null) {
                element._obsDataVector = (Vector)this._obsDataVector.clone();
            }
            if (this._waterControlDevice != null) {
                element._waterControlDevice = (WaterControlDevice)((RssTSLocationObject)this._waterControlDevice).clone();
            }
            return element;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void copyInto(Element element) {
        this._name = element._name;
        this._description = element._description;
        this._index = element._index;
        this.setValid(element.isValid());
        this._system = element._system;
        this._parentElement = element._parentElement;
        this.a = element.a;
        this._nodeVector = (Vector)element._nodeVector.clone();
        this._nodeDirVector = (Vector)element._nodeDirVector.clone();
        this._elemVector = new Vector();
        int n = element._elemVector.size();
        for (int i = 0; i < n; ++i) {
            Element element2 = element._elemVector.elementAt(i);
            if (element2 == null) continue;
            element2 = (Element)element2.clone();
            element2.setParentElement(this);
            this._elemVector.addElement(element2);
        }
        if (element._function != null) {
            this._function = (Function)((RssTSLocationObject)element._function).clone();
            this._function.setElement(this);
        }
        this._obsDataVector = element._obsDataVector != null ? (Vector)element._obsDataVector.clone() : null;
        if (element._forebayHeadLoss != null) {
            this._forebayHeadLoss = (ForebayHeadLoss)((RssTSLocationObject)this._forebayHeadLoss).clone();
        }
        this.setModified(true);
    }

    public boolean downStreamFrom(Element object) {
        if (object == null) {
            return false;
        }
        if (this._system == null) {
            return false;
        }
        if ((object = this._system.getDownstreamElements((Element)object)) == null || ((Vector)object).size() == 0) {
            return false;
        }
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            Element element = (Element)((Vector)object).elementAt(i);
            if (element != this) continue;
            return true;
        }
        return false;
    }

    public void resetParentElement() {
        if (this._function != null) {
            this._function.resetParent(this);
        }
        Enumeration<Element> enumeration = this._elemVector.elements();
        while (enumeration.hasMoreElements()) {
            Element element = enumeration.nextElement();
            element.setParentElement(this);
            element.resetParentElement();
        }
    }

    public boolean isActive() {
        return this.a;
    }

    public void setActive(boolean bl) {
        this.setActive(bl, false);
    }

    public void setActive(boolean bl, boolean bl2) {
        int n;
        this.a = bl;
        if (this._function != null) {
            Vector vector = this._function.getComputedNodes();
            if (vector == null) {
                return;
            }
            int n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                RssNode rssNode = (RssNode)vector.elementAt(n);
                rssNode.setActive(bl);
            }
        }
        if (bl2) {
            n = this._elemVector.size();
            for (int i = 0; i < n; ++i) {
                Element element = this._elemVector.elementAt(i);
                element.setActive(bl, bl2);
            }
        }
    }

    public boolean isDirty() {
        return this.b;
    }

    public void setDirty(boolean bl) {
        this.b = bl;
    }

    public String getKeyStringForObject(Object object) {
        return this._system.getKeyStringForObject(object);
    }

    public Object getObjectForKeyString(String string) {
        return this._system.getObjectForKeyString(string);
    }

    public Element getTopParent() {
        if (this._parentElement != null) {
            return this._parentElement.getTopParent();
        }
        return this;
    }

    public Element getParent() {
        return this._parentElement;
    }

    public void setParentElement(Element element) {
        this._parentElement = element;
    }

    public void addChildElement(Element element) {
        if (element == null) {
            return;
        }
        this._elemVector.addElement(element);
        element.setParentElement(this);
    }

    public void addChildElementAt(Element element, int n) {
        if (element == null) {
            return;
        }
        if (this._elemVector.size() <= n) {
            this._elemVector.setSize(n + 1);
        }
        this._elemVector.setElementAt(element, n);
        element.setParentElement(this);
    }

    public void removeChild(Element element) {
        if (this._elemVector.contains(element)) {
            element.setParentElement(null);
            this._elemVector.removeElement(element);
            element.dispose(true);
        }
    }

    public void removeAllChildElements() {
        Enumeration<Element> enumeration = this._elemVector.elements();
        while (enumeration.hasMoreElements()) {
            Element element = enumeration.nextElement();
            element.setParentElement(null);
        }
        this._elemVector.removeAllElements();
    }

    public boolean initialize(RunTimeWindow runTimeWindow) {
        if (this.isActive() && this._function != null && !this._function.initialize()) {
            return false;
        }
        if (this.isActive() && this._forebayHeadLoss != null) {
            this._forebayHeadLoss.initialize();
        }
        if (this.isActive() && this._waterControlDevice != null && this._system.getRssRun().shouldComputeWaterQuality()) {
            this._waterControlDevice.setSystem(this._system);
            this._waterControlDevice.initialize(runTimeWindow);
        }
        this.c = this._elemVector.size();
        for (int i = 0; i < this.c; ++i) {
            Element element = this._elemVector.elementAt(i);
            element.setParentElement(this);
            if (element == null || !element.isActive() || element.initialize(runTimeWindow)) continue;
            return false;
        }
        return true;
    }

    public boolean initForPostProcessing(RunTimeWindow runTimeWindow) {
        if (this.isActive() && this._function != null && !this._function.initForPostProcessing()) {
            return false;
        }
        if (this.isActive() && this._forebayHeadLoss != null) {
            this._forebayHeadLoss.initForPostProcessing();
        }
        this.c = this._elemVector.size();
        for (int i = 0; i < this.c; ++i) {
            Element element = this._elemVector.elementAt(i);
            element.setParentElement(this);
            if (element == null || !element.isActive() || element.initForPostProcessing(runTimeWindow)) continue;
            return false;
        }
        return true;
    }

    public boolean initHindcastLoop(RunTimeWindow runTimeWindow) {
        if (this.isActive() && this._function != null && !this._function.initHindcastLoop(runTimeWindow)) {
            return false;
        }
        int n = this._elemVector.size();
        for (int i = 0; i < n; ++i) {
            Element element = this._elemVector.elementAt(i);
            if (element == null || !element.isActive() || element.initHindcastLoop(runTimeWindow)) continue;
            return false;
        }
        return true;
    }

    public boolean initForecastLoop(RunTimeWindow runTimeWindow) {
        if (this.isActive() && this._function != null && !this._function.initForecastLoop(runTimeWindow)) {
            return false;
        }
        int n = this._elemVector.size();
        for (int i = 0; i < n; ++i) {
            Element element = this._elemVector.elementAt(i);
            if (element == null || !element.isActive() || element.initForecastLoop(runTimeWindow)) continue;
            return false;
        }
        return true;
    }

    public void saveElementState(int n) {
        if (this._function != null) {
            this._function.saveFunctionState(n);
        }
        int n2 = this.c;
        for (int i = 0; i < n2; ++i) {
            Element element = this._elemVector.elementAt(i);
            if (element == null) continue;
            element.saveElementState(n);
        }
    }

    public void saveHotstartState(HotstartState hotstartState, int n) {
        if (hotstartState == null) {
            return;
        }
        HotstartState hotstartState2 = hotstartState.getChildState(this.getName(), this.getClass().getName());
        if (hotstartState2 == null) {
            hotstartState2 = this.createHotstartState();
            hotstartState.addChildState(hotstartState2);
        }
        hotstartState2.saveState(n);
    }

    public boolean restoreHotstartState(HotstartState hotstartState) {
        if (hotstartState == null) {
            return false;
        }
        if ((hotstartState = (ElementHotstartState)hotstartState.getChildState(this.getName(), this.getClass().getName())) != null) {
            ((ElementHotstartState)hotstartState).setElement(this);
            return hotstartState.restoreState();
        }
        return false;
    }

    protected ElementHotstartState createHotstartState() {
        return new ElementHotstartState(this);
    }

    public void restoreElementState(int n) {
        if (this._function != null) {
            this._function.restoreFunctionState(n);
        }
        int n2 = this.c;
        for (int i = 0; i < n2; ++i) {
            Element element = this._elemVector.elementAt(i);
            if (element == null) continue;
            element.restoreElementState(n);
        }
    }

    public RssSystem getSystem() {
        return this._system;
    }

    public Vector getElementVector() {
        return this._elemVector;
    }

    public Vector getElementsByClass(Class clazz, Vector vector) {
        if (vector == null) {
            vector = new Vector();
        }
        int n = this._elemVector.size();
        for (int i = 0; i < n; ++i) {
            Element element = this._elemVector.elementAt(i);
            if (element == null) continue;
            if (clazz.isInstance(element) || element._function != null && clazz.isInstance(element._function)) {
                vector.add(element);
            }
            vector = element.getElementsByClass(clazz, vector);
        }
        return vector;
    }

    public boolean hasElementsOfClass(Class clazz) {
        int n = this._elemVector.size();
        for (int i = 0; i < n; ++i) {
            Element element = this._elemVector.elementAt(i);
            if (element == null) continue;
            if (clazz.isInstance(element) || element._function != null && clazz.isInstance(element._function)) {
                return true;
            }
            if (!element.hasElementsOfClass(clazz)) continue;
            return true;
        }
        return false;
    }

    public Element getElementByName(String string) {
        int n = this._elemVector.size();
        for (int i = 0; i < n; ++i) {
            Element element = this._elemVector.elementAt(i);
            if (element == null) continue;
            if (element.getName().equals(string)) {
                return element;
            }
            if ((element = element.getElementByName(string)) == null) continue;
            return element;
        }
        return null;
    }

    public Element getElement(int n) {
        int n2 = this._elemVector.size();
        for (int i = 0; i < n2; ++i) {
            Element element = this._elemVector.elementAt(i);
            if (element == null) continue;
            if (element.getIndex() == n) {
                return element;
            }
            if ((element = element.getElement(n)) == null) continue;
            return element;
        }
        return null;
    }

    public void dispose() {
        this.dispose(false);
    }

    public void dispose(boolean bl) {
        TSLocation tSLocation;
        int n;
        int n2 = this._elemVector.size();
        for (n = 1; n <= n2; ++n) {
            tSLocation = this._elemVector.elementAt(n2 - n);
            if (tSLocation == null) continue;
            tSLocation.dispose(bl);
        }
        this._elemVector.removeAllElements();
        n2 = this._nodeVector.size();
        for (n = 1; n <= n2; ++n) {
            tSLocation = this._nodeVector.elementAt(n2 - n);
            if (tSLocation != null) {
                tSLocation.removeElement(this);
            }
            Integer n3 = this._nodeDirVector.elementAt(n2 - n);
            if (!bl || this._function == null || !this._function.isNodeComputed(n, (RssNode)tSLocation, n3)) continue;
            tSLocation.dispose();
        }
        this._nodeVector.removeAllElements();
        this._nodeDirVector.removeAllElements();
    }

    public void cleanVectors() {
        RssReturnStatusConstants rssReturnStatusConstants;
        int n = this._nodeVector.size();
        --n;
        while (n >= 0) {
            rssReturnStatusConstants = this._nodeVector.elementAt(n);
            if (rssReturnStatusConstants == null || ((RssNode)rssReturnStatusConstants).isDisposed()) {
                System.out.println("Clean Element: remove node " + rssReturnStatusConstants.getName());
                this._nodeVector.remove(n);
                this._nodeDirVector.remove(n);
            }
            --n;
        }
        n = this._elemVector.size();
        --n;
        while (n >= 0) {
            rssReturnStatusConstants = this._elemVector.elementAt(n);
            ((Element)rssReturnStatusConstants).cleanVectors();
            if (((Element)rssReturnStatusConstants).isDisposed()) {
                System.out.println("Clean Element: remove element " + ((Element)rssReturnStatusConstants).getFullName());
                this._elemVector.remove(n);
            }
            --n;
        }
    }

    public boolean isNodeComputed(RssNode rssNode) {
        if (rssNode == null || this._function == null) {
            return false;
        }
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            RssNode rssNode2 = this._nodeVector.get(i);
            if (rssNode2 != rssNode) continue;
            return this._function.isNodeComputed(i, rssNode, this._nodeDirVector.get(i));
        }
        return false;
    }

    public boolean isDisposed() {
        if (this._nodeVector.isEmpty()) {
            return true;
        }
        int n = this._nodeVector.size();
        --n;
        while (n >= 0) {
            RssNode rssNode = this._nodeVector.elementAt(n);
            if (rssNode != null) {
                return false;
            }
            --n;
        }
        return true;
    }

    public Vector getNodeVector() {
        return this._nodeVector;
    }

    public Vector getNodeDirVector() {
        return this._nodeDirVector;
    }

    public RssNode getDownstreamNode() {
        int n = this._nodeVector.size();
        for (int i = 0; i < n; ++i) {
            RssNode rssNode = this._nodeVector.elementAt(i);
            Integer n2 = this._nodeDirVector.elementAt(i);
            if (n2 != 0) continue;
            return rssNode;
        }
        return null;
    }

    public RssNode getUpstreamNode() {
        int n = this._nodeVector.size();
        for (int i = 0; i < n; ++i) {
            Integer n2 = this._nodeDirVector.get(i);
            if (n2 != 1) continue;
            RssNode rssNode = this._nodeVector.get(i);
            return rssNode;
        }
        return null;
    }

    public List getDownstreamNodes(List arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList<RssNode>();
        }
        int n = this._nodeVector.size();
        for (int i = 0; i < n; ++i) {
            RssNode rssNode = this._nodeVector.get(i);
            Integer n2 = this._nodeDirVector.get(i);
            if (n2 != 0) continue;
            arrayList.add(rssNode);
        }
        return arrayList;
    }

    public List<RssNode> getUpstreamNodes(List<RssNode> list) {
        if (list == null) {
            list = new ArrayList<RssNode>();
        }
        int n = this._nodeVector.size();
        for (int i = 0; i < n; ++i) {
            RssNode rssNode = this._nodeVector.get(i);
            Integer n2 = this._nodeDirVector.get(i);
            if (n2 != 1) continue;
            list.add(rssNode);
        }
        return list;
    }

    public Vector<Element> getDownstreamElements(Vector<Element> vector) {
        if (vector == null) {
            vector = new Vector();
        }
        int n = this._nodeVector.size();
        for (int i = 0; i < n; ++i) {
            RssReturnStatusConstants rssReturnStatusConstants = this._nodeVector.elementAt(i);
            Integer n2 = this._nodeDirVector.elementAt(i);
            if (rssReturnStatusConstants == null || n2 != 0 || (rssReturnStatusConstants = rssReturnStatusConstants.getDownstreamElement()) == null || vector.contains(rssReturnStatusConstants)) continue;
            vector.add((Element)rssReturnStatusConstants);
        }
        return vector;
    }

    public List<Element> getLinkedElementList(int n) {
        ArrayList<Element> arrayList = new ArrayList<Element>(1);
        int n2 = this._nodeVector.size();
        for (int i = 0; i < n2; ++i) {
            RssReturnStatusConstants rssReturnStatusConstants = this._nodeVector.elementAt(i);
            Iterator<Element> iterator = this._nodeDirVector.elementAt(i);
            if (rssReturnStatusConstants == null || (Integer)((Object)iterator) != n) continue;
            if (n == 0) {
                rssReturnStatusConstants = ((RssNode)rssReturnStatusConstants).getDownstreamElement();
                if (!(this instanceof DiversionElement) && rssReturnStatusConstants instanceof JunctionElement) {
                    iterator = ((Element)rssReturnStatusConstants).getLinkedElementList(1);
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        Element element = iterator.next();
                        if (element == this || !(element instanceof DiversionElement) || !element.isActive() || rssReturnStatusConstants != ((DiversionElement)element).getSourceElement()) continue;
                        arrayList.add(element);
                    }
                }
            } else {
                rssReturnStatusConstants = ((RssNode)rssReturnStatusConstants).getUpstreamElement();
            }
            if (rssReturnStatusConstants == null || !((Element)(rssReturnStatusConstants = ((Element)rssReturnStatusConstants).getTopParent())).isActive() || arrayList.contains(rssReturnStatusConstants)) continue;
            arrayList.add((Element)rssReturnStatusConstants);
        }
        return arrayList;
    }

    public void addNode(RssNode rssNode, int n, boolean bl) {
        if (this._nodeVector.contains(rssNode)) {
            return;
        }
        this._nodeVector.addElement(rssNode);
        this._nodeDirVector.addElement(n);
        if (n == 0) {
            rssNode.setName(this._system.getKeyStringForObject(this));
        }
        if (n == 0) {
            rssNode.setUpstreamElement(this);
            return;
        }
        rssNode.setDownstreamElement(this);
    }

    public void addNode(RssNode rssNode, int n) {
        if (rssNode == null || this._nodeVector.contains(rssNode)) {
            return;
        }
        this._nodeVector.addElement(rssNode);
        this._nodeDirVector.addElement(n);
        if (n == 0) {
            rssNode.setName(this._system.getKeyStringForObject(this));
        }
        if (n == 0) {
            rssNode.setUpstreamElement(this);
            return;
        }
        rssNode.setDownstreamElement(this);
    }

    public void removeNode(RssNode rssNode) {
        int n = this._nodeVector.size();
        for (int i = 0; i < n; ++i) {
            RssNode rssNode2 = this._nodeVector.elementAt(i);
            if (rssNode2 != rssNode) continue;
            this._nodeVector.removeElementAt(i);
            this._nodeDirVector.removeElementAt(i);
            break;
        }
        rssNode.removeElement(this);
    }

    public WorldPt getReferencePt() {
        if (this._nodeVector.size() > 0) {
            RssNode rssNode = this._nodeVector.elementAt(0);
            return rssNode.getLocation();
        }
        return null;
    }

    public Function getFunction() {
        return this._function;
    }

    public void setFunction(Function function) {
        this._function = function;
        if (this._function != null) {
            this._function.setElement(this);
        }
    }

    public AdjustableParameter findAdjParam(String string, String string2) {
        if (this._function == null || string.compareTo(this._function.getName()) != 0) {
            return null;
        }
        return this._function.findAdjParam(string2);
    }

    public AdjustableParameter findAdjParam(String string, String string2, String string3) {
        int n = string.indexOf(";");
        String string4 = string;
        if (n >= 0) {
            string4 = string.substring(0, n);
        }
        int n2 = this._elemVector.size();
        for (int i = 0; i < n2; ++i) {
            Element element = this._elemVector.elementAt(i);
            if (element == null || !string4.equals(element.getName())) continue;
            if (n < 0) {
                return element.findAdjParam(string2, string3);
            }
            return element.findAdjParam(string.substring(n + 1), string2, string3);
        }
        return null;
    }

    public Element findElement(String string) {
        String string2 = string;
        int n = string.indexOf(";");
        if (n >= 0) {
            string2 = string.substring(0, n);
        }
        int n2 = this._elemVector.size();
        for (int i = 0; i < n2; ++i) {
            Element element = this._elemVector.elementAt(i);
            if (element == null || string2.compareTo(element.getName()) != 0) continue;
            if (n < 0) {
                return element;
            }
            return element.findElement(string.substring(n + 1));
        }
        return null;
    }

    public TSDataSet getTSDataSet(boolean bl) {
        if (bl) {
            return this._system.getInputTSDataSet();
        }
        return this._system.getOutputTSDataSet();
    }

    public int getNodeCount() {
        return this._nodeVector.size();
    }

    public RssNode getNode(int n) {
        if (n < 0 || n >= this._nodeVector.size()) {
            return null;
        }
        return this._nodeVector.elementAt(n);
    }

    public int getNodeDir(int n) {
        if (n < 0 || n >= this._nodeDirVector.size()) {
            return -1;
        }
        Integer n2 = this._nodeDirVector.elementAt(n);
        return n2;
    }

    public int computeHindcastStep(RunTimeStep runTimeStep) {
        int n = this._elemVector.size();
        for (int i = n - 1; i >= 0; --i) {
            int n2;
            Element element = this._elemVector.elementAt(i);
            if (element == null || !element.isActive() || (n2 = element.computeHindcastStep(runTimeStep)) == 0) continue;
            return n2;
        }
        if (this._function != null && (n = this._function.computeHindcastStep(runTimeStep)) != 0) {
            return n;
        }
        return 0;
    }

    public int computeForecastStep(RunTimeStep runTimeStep) {
        int n;
        for (int i = this.c - 1; i >= 0; --i) {
            int n2;
            Element element = this._elemVector.elementAt(i);
            if (element == null || !element.isActive() || (n2 = element.computeForecastStep(runTimeStep)) == 0) continue;
            return n2;
        }
        if (this._function != null && (n = this._function.computeForecastStep(runTimeStep)) != 0) {
            return n;
        }
        return 0;
    }

    public int computeForecastStep(RunTimeStep runTimeStep, double[] dArray, double[] dArray2, int n) {
        int n2;
        for (int i = this.c - 1; i >= 0; --i) {
            int n3;
            Element element = this._elemVector.elementAt(i);
            if (element == null || !element.isActive() || (n3 = element.computeForecastStep(runTimeStep, dArray, dArray2, n)) == 0) continue;
            return n3;
        }
        if (this._function != null && (n2 = this._function.computeForecastStep(runTimeStep, dArray, dArray2, n)) != 0) {
            return n2;
        }
        return 0;
    }

    public double computeSubStepFlow(RunTimeStep runTimeStep, double d, double d2) {
        double d3 = 0.0;
        for (int i = this.c - 1; i >= 0; --i) {
            Element element = this._elemVector.elementAt(i);
            if (element == null || !element.isActive()) continue;
            d3 += element.computeSubStepFlow(runTimeStep, d, d2);
        }
        if (this._function != null) {
            d3 += this._function.computeSubStepFlow(runTimeStep, d, d2);
        }
        return d3;
    }

    public int computeHindcast(RunTimeWindow runTimeWindow, int n) {
        if (this._function == null && this._elemVector.size() <= 0) {
            return 1;
        }
        if (this._function != null && this._function instanceof Routing) {
            return ((Routing)this._function).computeHindcast(runTimeWindow, n);
        }
        int n2 = this._elemVector.size();
        RunTimeStep runTimeStep = new RunTimeStep(runTimeWindow);
        new RunTimeStep(runTimeWindow).flag = n;
        for (int i = 0; i <= runTimeWindow.getNumLookbackSteps(); ++i) {
            runTimeStep.setStep(i);
            for (n = n2 - 1; n > 0; --n) {
                Element element = this._elemVector.elementAt(n);
                if (!element.isActive() || element.computeHindcastStep(runTimeStep) == 0) continue;
                this._system.printMessage("Element.computeHindcast: Error at step " + Integer.toString(i));
                return 1;
            }
            if (this._function == null || this._function.computeHindcastStep(runTimeStep) == 0) continue;
            this._system.printMessage("Element.computeHindcast: Error at step " + Integer.toString(i));
            return 1;
        }
        return 0;
    }

    public int computeForecast(RunTimeWindow runTimeWindow, int n) {
        if (this._function == null && this._elemVector.size() <= 0) {
            return 1;
        }
        if (this._function instanceof Routing) {
            return ((Routing)this._function).computeForecast(runTimeWindow, n);
        }
        int n2 = this._elemVector.size();
        RunTimeStep runTimeStep = new RunTimeStep(runTimeWindow);
        new RunTimeStep(runTimeWindow).flag = n;
        for (int i = runTimeWindow.getNumLookbackSteps() + 1; i <= runTimeWindow.getNumSteps(); ++i) {
            Element element;
            runTimeStep.setStep(i);
            for (int j = n2 - 1; j > 0; --j) {
                element = this._elemVector.elementAt(j);
                if (!element.isActive() || element.computeForecastStep(runTimeStep) == 0) continue;
                this._system.printMessage("Element.computeHindcast: Error at step " + Integer.toString(i));
                return 1;
            }
            if (this._function == null) continue;
            if (this._function.computeForecastStep(runTimeStep) != 0) {
                this._system.printMessage("Element.computeHindcast: Error at step " + Integer.toString(i));
                return 1;
            }
            if (this.getSystem().b && this.getSystem().shouldSaveHotstartAtTimeStep(i, n)) {
                ArrayList<Element> arrayList = new ArrayList<Element>(1);
                element = this.getTopParent();
                arrayList.add(element);
                this.getSystem().checkSaveHotstart(i, n, arrayList);
            }
            if (i != runTimeWindow.getNumSteps() - runTimeWindow.getNumRoutingSteps() - 1) continue;
            this.saveElementState(4);
        }
        return 0;
    }

    public boolean getForecastEquation(RunTime runTime) {
        if (this._function == null) {
            return false;
        }
        return this._function.getForecastEquation(runTime);
    }

    public boolean getHindcastEquation(RunTime runTime) {
        if (this._function == null) {
            return false;
        }
        return this._function.getHindcastEquation(runTime);
    }

    public boolean readData(BufferedReader bufferedReader) {
        int n = -1;
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.length() == 0) {
                    string = bufferedReader.readLine();
                    continue;
                }
                if (string.indexOf("Element") < 0) break;
                Object object = RMAIO.getType((String)string, (String)"=");
                string = RMAIO.getParam((String)string, (String)"=");
                if (((String)object).compareTo("Element Name") == 0) {
                    this.setName(string);
                } else if (((String)object).compareTo("Element Description") == 0) {
                    this.setDescription(string);
                } else if (((String)object).compareTo("Element Nodes") == 0) {
                    object = new rmaTokenizer(string, ",");
                    int n2 = 0;
                    while (object.hasMoreTokens()) {
                        try {
                            String string2 = object.nextToken();
                            if (this._nodeVector.size() < n2 + 1) {
                                this._nodeVector.setSize(n2 + 1);
                            }
                            if ((var5_8 = RMAIO.parseInt((String)string2)) >= 0 && var5_8 != Integer.MIN_VALUE) {
                                RssNode rssNode = this._system.getNode(var5_8);
                                this._nodeVector.setElementAt(rssNode, n2);
                                if (rssNode == null) {
                                    this._system.printMessage("Warning! RssNode " + var5_8 + " not found");
                                }
                            }
                            ++n2;
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            break;
                        }
                    }
                } else if (((String)object).compareTo("Element NodeDir") == 0) {
                    object = new rmaTokenizer(string, ",");
                    int n3 = 0;
                    try {
                        while (true) {
                            int n4;
                            Object object2 = object.nextToken();
                            if (this._nodeDirVector.size() < n3 + 1) {
                                this._nodeDirVector.setSize(n3 + 1);
                            }
                            if ((n4 = RMAIO.parseInt((String)object2)) >= 0 && n4 != Integer.MIN_VALUE) {
                                this._nodeDirVector.setElementAt(n4, n3);
                                object2 = this._nodeVector.elementAt(n3);
                                if (n4 == 0) {
                                    ((RssNode)object2).setUpstreamElement(this);
                                } else {
                                    ((RssNode)object2).setDownstreamElement(this);
                                }
                            }
                            ++n3;
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                } else if (((String)object).compareTo("Element") == 0 || ((String)object).compareTo("ReservoirElement") == 0) {
                    var5_8 = RMAIO.parseInt((String)string);
                    if (var5_8 != Integer.MIN_VALUE) {
                        int n5 = this._elemVector.size();
                        if (var5_8 + 1 > n5) {
                            this._elemVector.setSize(var5_8 + 50);
                        }
                        if (((Element)(object = ((String)object).compareTo("ReservoirElement") == 0 ? new ReservoirElement(this._system, var5_8) : new Element(this._system, var5_8))).readData(bufferedReader)) {
                            this._elemVector.setElementAt((Element)object, var5_8);
                            if (var5_8 > n) {
                                n = var5_8;
                            }
                        } else {
                            System.out.println("Error reading data for Element " + var5_8);
                        }
                    }
                } else if (((String)object).compareTo("Element Function") == 0) {
                    object = FunctionFactory.a(this, string);
                    if (object == null) {
                        this._system.printMessage("Could not create Function " + string);
                    } else if (((Function)object).readData(bufferedReader)) {
                        this._function = object;
                    }
                } else if (((String)object).compareTo("Element End") == 0) break;
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        this._nodeVector.trimToSize();
        this._elemVector.setSize(++n);
        this._elemVector.trimToSize();
        return true;
    }

    public boolean writeData(BufferedWriter bufferedWriter) {
        Object object;
        int n;
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Element=" + this.getIndex()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Element Name=" + this.getName()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Element Description=" + this.getDescription()));
        Object object2 = "Element Nodes= ";
        for (n = 0; n < this._nodeVector.size(); ++n) {
            object = this._nodeVector.elementAt(n);
            object2 = (String)object2 + object.getIndex() + ", ";
        }
        if (this._nodeVector.size() > 0) {
            object2 = ((String)object2).substring(0, ((String)object2).length() - 2);
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)object2);
        object2 = "Element NodeDir= ";
        for (n = 0; n < this._nodeDirVector.size(); ++n) {
            object = this._nodeDirVector.elementAt(n);
            object2 = (String)object2 + ((Integer)object).toString() + ", ";
        }
        if (this._nodeDirVector.size() > 0) {
            object2 = ((String)object2).substring(0, ((String)object2).length() - 2);
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)object2);
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"");
        n = this._elemVector.size();
        for (int i = 0; i < n; ++i) {
            object2 = this._elemVector.elementAt(i);
            ((Element)object2).writeData(bufferedWriter);
        }
        if (this._function != null) {
            this._function.writeData(bufferedWriter);
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"");
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Element End=" + this.getIndex()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"");
        return true;
    }

    public Vector getRequiredTSRecordProxies() {
        Vector<RssNode> vector = new Vector<RssNode>();
        List list = this.getDownstreamNodes(null);
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            RssNode rssNode = this._nodeVector.get(i);
            if (list.contains(rssNode) || (rssNode = rssNode.getTSRecordProxy(0)) == null || rssNode.isInput()) continue;
            vector.addElement(rssNode);
        }
        return vector;
    }

    public Vector getFlowContolTSRecordProxies() {
        Vector<Object> vector = new Vector<Object>();
        RssNode rssNode = this.getDownstreamNode();
        if (rssNode != null && rssNode.getTSRecordProxy(0) != null) {
            vector.addElement(rssNode.getTSRecordProxy(0));
        }
        int n = this._elemVector.size();
        for (int i = 0; i < n; ++i) {
            Object object = this._elemVector.elementAt(i);
            if (object == null) continue;
            object = ((Element)object).getFlowContolTSRecordProxies();
            for (int j = 0; j < ((Vector)object).size(); ++j) {
                vector.addElement(((Vector)object).elementAt(j));
            }
        }
        return vector;
    }

    public Vector getComputedTSRecordProxies_old() {
        Vector<Object> vector = new Vector<Object>();
        if (this._elemVector.size() <= 0) {
            List list = this.getDownstreamNodes(null);
            for (int i = 0; i < list.size(); ++i) {
                RssNode rssNode = (RssNode)list.get(i);
                if (rssNode == null || rssNode.getTSRecordProxy(0) == null) continue;
                vector.addElement(rssNode.getTSRecordProxy(0));
            }
        } else {
            int n = this._elemVector.size();
            for (int i = 0; i < n; ++i) {
                Object object = this._elemVector.elementAt(i);
                if (object == null) continue;
                object = ((Element)object).getComputedTSRecordProxies();
                for (int j = 0; j < ((Vector)object).size(); ++j) {
                    vector.addElement(((Vector)object).elementAt(j));
                }
            }
        }
        return vector;
    }

    public Vector getComputedTSRecordProxies() {
        if (this._elemVector.size() <= 0) {
            if (this._function != null) {
                return this._function.getComputedTSRecordProxies();
            }
            return new Vector();
        }
        Vector vector = new Vector();
        int n = this._elemVector.size();
        for (int i = 0; i < n; ++i) {
            Object object = this._elemVector.elementAt(i);
            if (object == null) continue;
            object = ((Element)object).getComputedTSRecordProxies();
            for (int j = 0; j < ((Vector)object).size(); ++j) {
                vector.addElement(((Vector)object).elementAt(j));
            }
        }
        return vector;
    }

    public void clearTSProxyList() {
        if (this._function != null) {
            this._function.clearTSProxyList();
        }
        int n = this._elemVector.size();
        for (int i = 0; i < n; ++i) {
            Element element = this._elemVector.elementAt(i);
            if (element == null) continue;
            element.clearTSProxyList();
        }
    }

    public void updateTSProxyList() {
        if (this._function != null) {
            ((RssTSLocationObject)this._function).updateTSProxyList();
        }
        if (this._forebayHeadLoss != null) {
            ((RssTSLocationObject)this._forebayHeadLoss).updateTSProxyList();
        }
        int n = this._elemVector.size();
        for (int i = 0; i < n; ++i) {
            NamedType namedType = this._elemVector.elementAt(i);
            if (namedType == null) continue;
            namedType.updateTSProxyList();
            if (!(namedType instanceof TailElevContainer) || !((TailElevContainer)namedType).hasTailElev() || (namedType = ((TailElevContainer)namedType).getTailwaterElevation()) == null) continue;
            namedType.updateTSProxyList();
        }
    }

    public void updateWQTSProxyList(List<ModelVariable> list) {
        if (this._function != null) {
            this._function.updateWQTSProxyList(list);
        }
        for (Element element : this._elemVector) {
            Element element2 = element;
            element2 = element;
            element.updateWQTSProxyList(list);
        }
    }

    public Vector getActiveTSProxies(Vector vector, int n) {
        if (vector == null) {
            vector = new Vector();
        }
        if (this._function != null) {
            this._function.getActiveTSProxies(vector, n);
        }
        if (this._forebayHeadLoss != null) {
            this._forebayHeadLoss.getActiveTSProxies(vector, n);
        }
        int n2 = this._elemVector.size();
        for (int i = 0; i < n2; ++i) {
            NamedType namedType = this._elemVector.elementAt(i);
            if (namedType == null || !namedType.isActive()) continue;
            namedType.getActiveTSProxies(vector, n);
            if (!(namedType instanceof TailElevContainer) || !((TailElevContainer)namedType).hasTailElev() || (namedType = ((TailElevContainer)namedType).getTailwaterElevation()) == null) continue;
            namedType.getActiveTSProxies(vector, n);
        }
        return vector;
    }

    public Vector getTSRecordProxies() {
        int n;
        Object object;
        Vector vector = new Vector();
        if (this._function != null && (object = this._function.getTSRecordProxies()) != null) {
            for (n = 0; n < ((Vector)object).size(); ++n) {
                vector.addElement(((Vector)object).elementAt(n));
            }
        }
        int n2 = this._elemVector.size();
        for (int i = 0; i < n2; ++i) {
            object = this._elemVector.elementAt(i);
            if (object == null || !((Element)object).isActive() || (object = ((Element)object).getTSRecordProxies()) == null) continue;
            n = ((Vector)object).size();
            for (int j = 0; j < n; ++j) {
                vector.addElement(((Vector)object).elementAt(j));
            }
        }
        return vector;
    }

    public List getActiveStateVariables(List arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        if (this._forebayHeadLoss != null) {
            this._forebayHeadLoss.getReferencedStateVariables(arrayList);
        }
        int n = this._elemVector.size();
        for (int i = 0; i < n; ++i) {
            NamedType namedType = this._elemVector.elementAt(i);
            if (namedType == null || !namedType.isActive()) continue;
            namedType.getActiveStateVariables(arrayList);
            if (!(namedType instanceof TailElevContainer) || !((TailElevContainer)namedType).hasTailElev() || (namedType = ((TailElevContainer)namedType).getTailwaterElevation()) == null) continue;
            namedType.getReferencedStateVariables(arrayList);
        }
        return arrayList;
    }

    @Override
    public TSRecordProxy getTSRecordProxy(int n) {
        Object object = null;
        if (this._function != null) {
            object = this._function.getTSRecordProxy(n);
        }
        if (object != null) {
            return object;
        }
        int n2 = this._elemVector.size();
        for (int i = 0; i < n2; ++i) {
            object = this._elemVector.elementAt(i);
            if (object == null || (object = ((Element)object).getTSRecordProxy(n)) == null) continue;
            return object;
        }
        return null;
    }

    public TSRecordProxy getTSRecordProxy(String string) {
        Object object = null;
        if (this._function != null) {
            object = this._function.getTSRecordProxy(string);
        }
        if (object != null) {
            return object;
        }
        int n = this._elemVector.size();
        for (int i = 0; i < n; ++i) {
            object = this._elemVector.elementAt(i);
            if (object == null || (object = ((Element)object).getTSRecordProxy(string)) == null) continue;
            return object;
        }
        return null;
    }

    public void setName(String string) {
        Object object;
        String string2;
        int n;
        String string3 = this.getName();
        if (this._function != null && (n = (string2 = this._function.getName()).indexOf(string3)) >= 0) {
            object = string + string2.substring(n + string3.length());
            this._function.setName((String)object);
        }
        if (this._elemVector != null) {
            int n2 = this._elemVector.size();
            for (n = 0; n < n2; ++n) {
                Object object2;
                int n3;
                object = this._elemVector.elementAt(n);
                if (object == null || (n3 = ((String)(object2 = object.getName())).indexOf(string3)) < 0) continue;
                object2 = string + ((String)object2).substring(n3 + string3.length());
                ((Element)object).setName((String)object2);
            }
        }
        if (this._nodeVector != null) {
            for (int i = 0; i < this._nodeVector.size(); ++i) {
                int n4;
                RssNode rssNode = this._nodeVector.elementAt(i);
                if (rssNode == null || (n4 = ((String)(object = rssNode.getName())).indexOf(string3)) < 0) continue;
                String string4 = string + ((String)object).substring(n4 + string3.length());
                rssNode.setName(string4);
            }
        }
        super.setName(string);
    }

    public double calcSeepageFlow(double d) {
        if (this._parentElement != null) {
            return this._parentElement.calcSeepageFlow(d);
        }
        return 0.0;
    }

    public Vector getModelVariables(Vector vector) {
        return vector;
    }

    public Vector getDefaultModelVariables() {
        return new Vector(0);
    }

    public Vector getPlotTypes() {
        return null;
    }

    public BufferedReader getPlotTypeFile(String object) {
        Object object2 = object;
        if (!((String)object).endsWith(".plotType")) {
            object = ((String)object2).concat(".plotType");
        }
        object2 = this.getPlotTypeDirectory();
        object = ((String)object2).concat("/").concat((String)object);
        object2 = this.getClass().getClassLoader().getResource((String)object);
        if (object2 == null) {
            System.out.println("getPlotTypeName: failed to find URL for " + (String)object);
            return null;
        }
        File file = new File(((URL)object2).getFile());
        try {
            if (file.exists()) {
                return new BufferedReader(new FileReader(file));
            }
            object = this.getClass().getClassLoader().getResourceAsStream((String)object);
            if (object != null) {
                return new BufferedReader(new InputStreamReader((InputStream)object));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("getPlotTypeName: file not found " + String.valueOf(fileNotFoundException));
        }
        System.out.println("getPlotTypeName: failed to find file for " + ((URL)object2).getFile());
        return null;
    }

    public String getPlotTypeDirectory() {
        return "hec/rss/client/plottypes/" + this.getElementType();
    }

    public Vector getPlotTypeNames() {
        Vector<String> vector;
        String string = this.getPlotTypeDirectory();
        URL uRL = this.getClass().getClassLoader().getResource(string);
        if (uRL == null || uRL.getFile().contains(".jar!/" + string)) {
            vector = this.getPlotTypeNamesFromJar(string);
        } else {
            vector = new Vector<String>();
            String[] stringArray = new File(uRL.getFile());
            if (stringArray.exists() && stringArray.isDirectory() && (stringArray = stringArray.list()) != null) {
                vector.ensureCapacity(stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    string2 = string2.endsWith(".plotType") ? stringArray[i].substring(0, string2.indexOf(".plotType")) : stringArray[i];
                    vector.add(string2);
                }
            }
        }
        if (vector.size() > 0) {
            Collections.sort(vector);
            if (vector.remove("default")) {
                vector.add(0, "default");
            }
            return vector;
        }
        System.out.println(this.getElementType() + ".getPlotTypeNames: Failed to find file " + (uRL == null ? string : uRL.getFile()));
        return vector;
    }

    private Vector getPlotTypeNamesFromJar(String string) {
        Vector<Object> vector = new Vector<Object>();
        URL uRL = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        try {
            Object object = new File(uRL.toURI());
            object = new JarFile((File)object);
            try {
                Enumeration<JarEntry> enumeration = ((JarFile)object).entries();
                vector.ensureCapacity(((ZipFile)object).size());
                while (enumeration.hasMoreElements()) {
                    Object object2 = enumeration.nextElement();
                    if (!((ZipEntry)object2).getName().startsWith(string) || ((ZipEntry)object2).isDirectory()) continue;
                    if (((String)(object2 = ((ZipEntry)object2).getName())).endsWith(".plotType")) {
                        object2 = Paths.get((String)object2, new String[0]).getFileName().toString();
                        object2 = ((String)object2).substring(0, ((String)object2).indexOf(".plotType"));
                    }
                    vector.add(object2);
                }
            }
            finally {
                ((ZipFile)object).close();
            }
        }
        catch (IOException | URISyntaxException exception) {
            System.out.println("getPlotTypeNamesFromJar: error reading jarfile " + String.valueOf(uRL) + " error " + String.valueOf(exception));
            return vector;
        }
        vector.trimToSize();
        return vector;
    }

    public String getElementType() {
        if (this instanceof ReservoirElement) {
            return "reservoir";
        }
        if (this instanceof ReachElement) {
            return "reach";
        }
        if (this instanceof JunctionElement) {
            return "junction";
        }
        if (this instanceof DiversionElement) {
            return "diversion";
        }
        if (this instanceof DivertedOutletElement) {
            return "divertedoutlet";
        }
        if (this instanceof ReservoirDamElement) {
            return "Dam";
        }
        return "";
    }

    public int getElementTypeId() {
        if (this instanceof ReservoirElement) {
            return 1;
        }
        if (this instanceof ReachElement) {
            return 2;
        }
        if (this instanceof JunctionElement) {
            return 4;
        }
        if (this instanceof DiversionElement) {
            return 8;
        }
        if (this instanceof DivertedOutletElement) {
            return 16;
        }
        return 0;
    }

    public Vector getTSRecords(ModelVariable modelVariable, Vector vector) {
        return vector;
    }

    public Vector getTSRecords(ModelVariable modelVariable, Vector vector, Vector vector2) {
        return this.getTSRecords(modelVariable, vector);
    }

    public void setObsDataVector(Vector vector) {
        this.setModified(true);
        if (vector == null) {
            this._obsDataVector = null;
            return;
        }
        this._obsDataVector = (Vector)vector.clone();
    }

    public Vector getObsDataVector() {
        return this._obsDataVector;
    }

    protected void importObservedData(Element object, StringBuffer stringBuffer) {
        object = ((Element)object).getObsDataVector();
        this.setObsDataVector((Vector)object);
    }

    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

