/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.data.Parameter;
import hec.heclib.util.doubleArrayContainer;
import hec.io.AsciiSerializable;
import hec.model.PairedValues;
import hec.model.RunTimeStep;
import hec.rss.model.OpRule;
import hec.rss.model.OpValue;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Vector;

public class ElevReleaseOpRule
extends OpRule
implements AsciiSerializable,
Serializable,
Cloneable {
    public static final String PARAMSTR_MAXRULE = "FLow-MaxRule";
    public static final String PARAMSTR_MINRULE = "FLow-MinRule";
    public static final int MIN = -1;
    public static final int MAX = 1;
    public static final int SPECIFIED = 0;
    private PairedValues _elevRelease = new PairedValues();
    private int _limitType;
    private transient doubleArrayContainer a;
    private transient doubleArrayContainer b;

    public ElevReleaseOpRule() {
    }

    public ElevReleaseOpRule(String string) {
        super(string);
    }

    @Override
    public void updateTSProxyList() {
        if (this._limitType == -1) {
            TSRecordProxy tSRecordProxy = this.getTSRecordProxy(82);
            if (tSRecordProxy == null) {
                this.addTSRecordProxy(82);
                return;
            }
        } else if (this._limitType == 1) {
            TSRecordProxy tSRecordProxy = this.getTSRecordProxy(81);
            if (tSRecordProxy == null) {
                this.addTSRecordProxy(81);
                return;
            }
        } else {
            TSRecordProxy tSRecordProxy = this.getTSRecordProxy(80);
            if (tSRecordProxy == null) {
                this.addTSRecordProxy(80);
            }
        }
    }

    @Override
    public Vector getActiveTSRecordProxies(Vector vector, int n) {
        if (vector == null) {
            vector = new Vector<TSRecordProxy>();
        }
        if (n == 0) {
            if (this._limitType == -1) {
                TSRecordProxy tSRecordProxy = this.getTSRecordProxy(82);
                if (tSRecordProxy != null) {
                    vector.addElement(tSRecordProxy);
                }
            } else if (this._limitType == 1) {
                TSRecordProxy tSRecordProxy = this.getTSRecordProxy(81);
                if (tSRecordProxy != null) {
                    vector.addElement(tSRecordProxy);
                }
            } else {
                TSRecordProxy tSRecordProxy = this.getTSRecordProxy(80);
                if (tSRecordProxy != null) {
                    vector.addElement(tSRecordProxy);
                }
            }
        }
        return vector;
    }

    @Override
    public boolean initializeCompute() {
        this.a = null;
        this.b = null;
        if (!super.initializeCompute()) {
            return false;
        }
        this.b = this._controller.getElementOp().getOperationsElement().getStorageFunction().getTSContainer(10);
        this.a = this._limitType == -1 ? this.getTSContainer(82) : (this._limitType == 1 ? this.getTSContainer(81) : this.getTSContainer(80));
        if (this.b == null || this.a == null) {
            this._controller.getElementOp().getOperationsElement().getSystem().printErrorMessage("ElevReleaseOpRule.initializeCompute: Failed to load time series arrays");
            return false;
        }
        return true;
    }

    @Override
    public OpValue evaluateRule(RunTimeStep object, double d) {
        double d2;
        if (this.b == null) {
            return null;
        }
        int n = object.step - 1;
        if (n < 0) {
            n = 0;
        }
        if ((d2 = this._elevRelease.interpolate(this.b.array[n])) == Double.NEGATIVE_INFINITY) {
            return null;
        }
        if (this.getEnableRiseFallCondition() && !this.checkRisingFallingCondition((RunTimeStep)object)) {
            return null;
        }
        object = new OpValue();
        new OpValue().value = d2;
        object.type = this._limitType == 0 ? 1 : (this._limitType == 1 ? 2 : 0);
        return object;
    }

    @Override
    public Object clone() {
        ElevReleaseOpRule elevReleaseOpRule = (ElevReleaseOpRule)super.clone();
        ((ElevReleaseOpRule)super.clone())._elevRelease = (PairedValues)this._elevRelease.clone();
        return elevReleaseOpRule;
    }

    public void setElevationRelease(PairedValues pairedValues) {
        if (pairedValues == null) {
            return;
        }
        this._elevRelease = pairedValues;
    }

    public PairedValues getElevationRelease() {
        this._elevRelease.setUnitSystem(this.getUnitSystem());
        this._elevRelease.setParamXId(Parameter.PARAMID_ELEV);
        this._elevRelease.setParamYId(Parameter.PARAMID_FLOW);
        return this._elevRelease;
    }

    public void setInterpolationType(int n) {
        this._elevRelease.setInterpolationType(n);
    }

    public int getInterpolationType() {
        return this._elevRelease.getInterpolationType();
    }

    public int getLimitType() {
        return this._limitType;
    }

    public void setLimitType(int n) {
        if (n != -1 && n != 1 && n != 0) {
            return;
        }
        this._limitType = n;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

