/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.heclib.util.HecTime;
import hec.io.AsciiSerializable;
import hec.model.RunTimeStep;
import hec.model.SeasonalRecord;
import hec.rss.model.DayOfWeekMultiplier;
import hec.rss.model.GenerationRequirement;
import hec.rss.model.PowerGenerationPatternContainer;
import hec.rss.model.PowerPlant;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.ScheduledHydropowerOpRule;
import hec.rss.model.Storage;
import java.io.Serializable;
import java.lang.reflect.Field;
import rma.util.RMAConst;

public class FirmEnergyOpRule
extends ScheduledHydropowerOpRule
implements AsciiSerializable,
Serializable,
Cloneable {
    private boolean _usePlantFactor = false;
    private double[] _monthlyEnergyRequirements = new double[12];
    private transient double f = 0.0;
    private transient int i = -1;
    private transient double j = 0.0;
    private transient double k = 0.0;
    private transient int l = -1;
    private transient boolean m = false;
    private transient boolean n;
    private transient GenerationRequirement o;
    private transient double[] p;
    private transient double[] q;
    private transient double[] r;
    private transient Storage s;

    public FirmEnergyOpRule() {
    }

    public FirmEnergyOpRule(String string) {
        super(string);
    }

    @Override
    public void updateByDemandScale(double d) {
        if (this.m_powerReqVariation == 0) {
            int n = 0;
            while (n < 12) {
                int n2 = n++;
                this._monthlyEnergyRequirements[n2] = this._monthlyEnergyRequirements[n2] * d;
            }
        } else {
            this._seasonalPowerRequirement.scaleValues(d);
        }
        this.setDemandScale(1.0);
    }

    @Override
    public boolean initializeCompute() {
        if (!super.initializeCompute()) {
            return false;
        }
        this.k = 0.0;
        this.l = -1;
        this.j = 0.0;
        this.m = false;
        this.n = true;
        if (this.e == null || this.e.isEmpty()) {
            ((RssTSLocationObject)this).getSystem().printErrorMessage("FirmEnergyOpRule.initializeCompute: no power plant");
            return false;
        }
        double d = 0.0;
        for (PowerPlant powerPlant : this.e) {
            d += powerPlant.getInstalledCapacity();
        }
        this.o = new GenerationRequirement(this.m_powerReqVariation, this.m_powerReqSpecifiedAs, this._monthlyEnergyRequirements, this.m_generationPeriod, this.m_startDayOfPeriod, this.m_startingDay, this.m_dayBelongsToTerm, this._seasonalPowerRequirement, d, this.g);
        this.s = this.getOperationsElement().getStorageFunction();
        return true;
    }

    @Override
    protected double getEnergyReguirement(RunTimeStep runTimeStep, double d) {
        double d2;
        if (this.n) {
            this.m_patternContainer.fillPatternTS(runTimeStep.rtw, this.b.array);
            this.o.a(runTimeStep.rtw, this.m_patternContainer, this.b.array, this.a.array);
            this.n = false;
        }
        double d3 = this.a.array[runTimeStep.step];
        if (d2 <= 0.0) {
            return 0.0;
        }
        if (this.useDemandScale()) {
            d3 *= this.getDemandScale();
        }
        int n = this.o.b(runTimeStep);
        int n2 = this.o.c(runTimeStep);
        if (n == 1) {
            return d3;
        }
        runTimeStep.getTimeStepSeconds();
        int n3 = runTimeStep.rtw.getNumSteps();
        if (this.p == null || this.p.length != n) {
            this.p = new double[n];
            this.q = new double[n];
            this.r = new double[n];
        }
        double d4 = 0.0;
        ReservoirElement reservoirElement = (ReservoirElement)this.s.getElement().getTopParent();
        int n4 = runTimeStep.step - n2;
        if (n4 < 0) {
            n4 = 0;
        }
        while (n4 < runTimeStep.step) {
            int n5 = n4;
            if (n5 <= runTimeStep.rtw.getNumLookbackSteps()) {
                n5 = runTimeStep.rtw.getNumLookbackSteps() + 1;
            }
            for (int i = 0; i < this.e.size(); ++i) {
                if (!RMAConst.isValidValue((double)this.d[i].array[n5])) continue;
                d4 += this.d[i].array[n5];
            }
            ++n4;
        }
        double d5 = d3 - d4;
        if (n2 + 1 == n) {
            return d5;
        }
        FirmEnergyOpRule firmEnergyOpRule = this;
        reservoirElement.getSystemGenerationLimits2(runTimeStep, firmEnergyOpRule, firmEnergyOpRule.q, this.r, n2, n);
        int n6 = runTimeStep.step - n2;
        int n7 = n6 >= 0 ? n6 : 0;
        int n8 = n6 >= 0 ? 0 : -n6;
        int n9 = n;
        if (n6 < 0) {
            n9 += n6;
        }
        if (n6 + n > n3) {
            n9 -= n6 + n - n3 - 1;
        }
        System.arraycopy(this.b.array, n7, this.p, n8, n9);
        n7 = n - n2;
        if (n6 + n > n3) {
            n7 -= n6 + n - n3 - 1;
        }
        PowerGenerationPatternContainer.a(this.p, d5, n2, n7, this.q, this.r);
        return this.p[n2];
    }

    public SeasonalRecord getSeasonalPowerRequirement() {
        this._seasonalPowerRequirement.setUnitSystem(this.getUnitSystem());
        return this._seasonalPowerRequirement;
    }

    public void setSeasonalPowerRequirement(SeasonalRecord seasonalRecord) {
        if (seasonalRecord == null) {
            return;
        }
        this._seasonalPowerRequirement = seasonalRecord;
    }

    public void setUsePlantFactor(boolean bl) {
        this._usePlantFactor = bl;
    }

    public boolean usePlantFactor() {
        return this._usePlantFactor;
    }

    public boolean setMonthlyEnergyRequirements(double[] dArray) {
        if (dArray == null || dArray.length != 12) {
            return false;
        }
        this._monthlyEnergyRequirements = dArray;
        return true;
    }

    public double[] getMonthlyEnergyRequirements() {
        return (double[])this._monthlyEnergyRequirements.clone();
    }

    private double getDailyFactor(RunTimeStep runTimeStep) {
        DayOfWeekMultiplier dayOfWeekMultiplier = this.getMultiplier();
        runTimeStep = new HecTime(runTimeStep.getHecTime());
        int n = RunTimeStep.getDayOfWeek((HecTime)runTimeStep);
        int n2 = runTimeStep.julian();
        runTimeStep.setJulian(n2 -= runTimeStep.day() - 1, 60);
        if (this.i != runTimeStep.month()) {
            int n3 = runTimeStep.month();
            double d = 0.0;
            while (runTimeStep.month() == n3) {
                int n4 = RunTimeStep.getDayOfWeek((HecTime)runTimeStep);
                d = dayOfWeekMultiplier != null && this.useDayOfWeekMultiplier() ? (d += dayOfWeekMultiplier.getMultiplier(n4)) : (d += 1.0);
                runTimeStep.increment(1, 1440);
            }
            this.f = d;
            this.i = n3;
        }
        if (this.f == 0.0) {
            return 0.0;
        }
        double d = 1.0;
        if (dayOfWeekMultiplier != null && this.useDayOfWeekMultiplier()) {
            d = dayOfWeekMultiplier.getMultiplier(n);
        }
        double d2 = d / this.f;
        return d2;
    }

    private double getHourlyFactor(RunTimeStep runTimeStep) {
        double d;
        int n = runTimeStep.getHecTime().hour();
        int n2 = runTimeStep.getHecTime().minute();
        double d2 = runTimeStep.getTimeStepMinutes();
        int n3 = (int)(d2 / 60.0 + 0.001);
        if (this._timeOfDayMultiplier == null || !this.useTimeOfDayMultiplier()) {
            return 0.041666666666666664;
        }
        if (d2 <= 60.0) {
            int n4 = n;
            if (n2 > 0) {
                ++n4;
            }
            if ((n4 %= 24) == 0) {
                n4 = 24;
            }
            d = this._timeOfDayMultiplier.getHourlyWeightedMultiplier(n4);
        } else if (d2 >= 1440.0) {
            d = 0.041666666666666664;
        } else {
            double d3 = 0.0;
            n -= n3;
            for (n2 = 0; n2 < n3; ++n2) {
                ++n;
                if ((n %= 24) == 0) {
                    n = 24;
                }
                double d4 = this._timeOfDayMultiplier.getHourlyWeightedMultiplier(n);
                d3 += d4;
            }
            d = d3 / (double)n3;
        }
        return d;
    }

    protected double computeMonthlyEnergyReq(RunTimeStep runTimeStep) {
        HecTime hecTime = runTimeStep.getHecTime();
        int n = hecTime.month() - 1;
        if (this.m_powerReqSpecifiedAs == 11 || this.m_powerReqSpecifiedAs == 13) {
            return this._monthlyEnergyRequirements[n];
        }
        if (this.m_powerReqSpecifiedAs == 12) {
            HecTime hecTime2 = new HecTime(hecTime);
            hecTime2.setTimeIncrement(3);
            int n2 = RunTimeStep.getDayOfWeek((HecTime)hecTime);
            int n3 = n2 - this.m_startingDay;
            if (n3 < 0) {
                n3 = 7 - n3;
            }
            hecTime2.subtract(n3);
            for (n3 = 0; n3 < 7; ++n3) {
                if (RunTimeStep.getDayOfWeek((HecTime)hecTime2) == this.m_dayBelongsToTerm) {
                    n = hecTime2.month() - 1;
                    return this._monthlyEnergyRequirements[n];
                }
                hecTime2.add(1);
            }
            return this._monthlyEnergyRequirements[n];
        }
        double d = this._monthlyEnergyRequirements[n];
        return this.computeMonthlyEnergyReqForPlantFactor(runTimeStep, d);
    }

    protected double computeSeasonalEnergyReq(RunTimeStep runTimeStep) {
        HecTime hecTime = runTimeStep.getHecTime();
        hecTime.month();
        int[] nArray = this._seasonalPowerRequirement.getTimeArray();
        if (nArray == null || nArray.length == 0) {
            return 0.0;
        }
        int n = nArray.length - 1;
        int n2 = hecTime.dayOfYear() * 1440 + hecTime.minutesSinceMidnight();
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (n2 < nArray[i]) continue;
            n = i;
            break;
        }
        if (this.m_powerReqSpecifiedAs == 11 || this.m_powerReqSpecifiedAs == 13) {
            return this._seasonalPowerRequirement.getDataArray()[n];
        }
        if (this.m_powerReqSpecifiedAs == 12) {
            HecTime hecTime2 = new HecTime(hecTime);
            hecTime2.setTimeIncrement(3);
            int n3 = RunTimeStep.getDayOfWeek((HecTime)hecTime);
            if ((n3 -= this.m_startingDay) < 0) {
                n3 = 7 - n3;
            }
            hecTime2.subtract(n3);
            for (n3 = 0; n3 < 7; ++n3) {
                if (RunTimeStep.getDayOfWeek((HecTime)hecTime2) == this.m_dayBelongsToTerm && (n2 = hecTime2.dayOfYear() * 1440 + hecTime2.minutesSinceMidnight()) < nArray[n] && --n < 0) {
                    n = nArray.length - 1;
                }
                hecTime2.add(1);
            }
            return this._seasonalPowerRequirement.getDataArray()[n];
        }
        return this.computeMonthlyEnergyReqForPlantFactor(runTimeStep, 0.0);
    }

    private double computeMonthlyEnergyReqForPlantFactor(RunTimeStep runTimeStep, double d) {
        if (this.e == null) {
            String string = "No Power Plant for ScheduledHydropower: " + this._controller.getName();
            System.out.println(string);
            return 0.0;
        }
        if (this._monthlyEnergyRequirements == null || this._monthlyEnergyRequirements.length < 12) {
            String string = "No Monthly Energy Requirements set for ScheduledHydropower: " + this._controller.getName();
            System.out.println(string);
            return 0.0;
        }
        double d2 = this.getMonthlyEnergyCapacity(runTimeStep.getHecTime().month() - 1);
        if (!RMAConst.isValidValue((double)d2)) {
            return 0.0;
        }
        return d2 *= d / 100.0;
    }

    protected double getEnergyReguirementOld(RunTimeStep runTimeStep, double d) {
        HecTime hecTime = runTimeStep.getHecTime();
        hecTime.month();
        double d2 = this.m_powerReqVariation == 0 ? this.computeMonthlyEnergyReq(runTimeStep) : this.computeSeasonalEnergyReq(runTimeStep);
        int n = this.m_powerReqSpecifiedAs;
        if (this.m_powerReqSpecifiedAs == 10) {
            n = 13;
        }
        int n2 = 0;
        int n3 = runTimeStep.getTimeStepMinutes();
        int n4 = n3 / 60;
        if (this.m_generationPeriod == 1) {
            var11_12 = hecTime.minutesSinceMidnight() / 60;
            n2 = var11_12 / n4 - 1;
        } else if (this.m_generationPeriod == 2) {
            var11_12 = RunTimeStep.getDayOfWeek((HecTime)hecTime);
            int n5 = var11_12 - this.m_startingDay;
            if (n5 < 0) {
                n5 = n5 + 6 + 1;
            }
            int n6 = hecTime.minutesSinceMidnight() / 60;
            n2 = (n5 * 24 + n6) / n4 - 1;
        }
        if (runTimeStep.step - runTimeStep.rtw.getNumLookbackSteps() < n2) {
            n2 -= runTimeStep.step - runTimeStep.rtw.getNumLookbackSteps();
        }
        if (n2 <= 0) {
            n2 = 0;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        HecTime hecTime2 = new HecTime(hecTime);
        hecTime2.setTimeIncrement(1);
        hecTime2.subtract(n3);
        for (int i = 1; i <= n2; ++i) {
            if (runTimeStep.step - i < 0) continue;
            d3 += this.b.array[runTimeStep.step - i];
            for (int j = 0; j < this.e.size(); ++j) {
                d4 += this.c[j].array[runTimeStep.step - i];
            }
        }
        double d5 = d3 - d4;
        for (int i = 2; i <= n2; ++i) {
            if (runTimeStep.step - i < 0) continue;
            d3 += this.b.array[runTimeStep.step - i];
            for (int j = 0; j < this.e.size(); ++j) {
                d4 += this.c[j].array[runTimeStep.step - i];
            }
        }
        double d6 = d3 - d4;
        double d7 = d5 - d6;
        double d8 = 0.0;
        for (PowerPlant powerPlant : this.e) {
            d8 += powerPlant.calculateAvailablePowerCapacity(d, powerPlant.getTailwaterElevation(runTimeStep));
        }
        Object object = this.m_patternContainer.computePowerGenPattern(runTimeStep, d2, n, this.m_startingDay, this.m_dayBelongsToTerm, d8, d5 -= this.k, d3, this.m_generationPeriod, this.m_startDayOfPeriod);
        if (runTimeStep.step > this.l) {
            this.j += d7;
        }
        if ((n3 = hecTime.minutesSinceMidnight() / 60) < 0 || n3 > 24) {
            return 0.0;
        }
        if (n3 == 24) {
            n3 = 0;
        }
        this.b.array[runTimeStep.step] = (double)object[1][n3];
        if (object[1][n3] > 0.0 && this.m) {
            this.k += this.j;
            this.j = 0.0;
            this.m = false;
        }
        if (object[1][n3] == 0.0) {
            this.m = true;
        }
        return (double)object[0][n3];
    }

    @Override
    public Object clone() {
        FirmEnergyOpRule firmEnergyOpRule = (FirmEnergyOpRule)super.clone();
        return firmEnergyOpRule;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

