/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSDataSet;
import hec.io.DSSArrayContainer;
import hec.io.DSSIdentifier;
import hec.model.RunTimeWindow;
import hec.rss.model.DiversionElement;
import hec.rss.model.DiversionRule;
import hec.rss.model.DownstreamCntrlOpRule;
import hec.rss.model.DownstreamOp;
import hec.rss.model.DownstreamOpRule;
import hec.rss.model.Element;
import hec.rss.model.OpRule;
import hec.rss.model.OpSet;
import hec.rss.model.ReleaseFuncOpRule;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableConstants;
import hec.rss.model.RssNode;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.Rule;
import hec.rss.model.ScheduledHydropowerOpRule;
import hec.rss.model.Storage;
import hec.rss.model.StorageZone;
import hec.rss.model.StorageZoneRef;
import hec.rss.model.SystemHydropowerOpRule;
import hec.rss.model.SystemHydropowerRule;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import rma.util.RMAIO;

public class FirmYieldRuleRef
implements RssModelVariableConstants,
RssReturnStatusConstants,
Cloneable {
    public static final String RULETYPE_DIVERSION = "Diversion";
    public static final String RULETYPE_HYDROPOWER = "Local Hydropower";
    public static final String RULETYPE_SYSHYDROPOWER = "System Hydropower";
    public static final String RULETYPE_RESMIN = "Minimum Reservoir Release";
    public static final String RULETYPE_DNSTRMMIN = "Minimum Downstream Flow";
    public static final int FYTEST_CONVERGE = 0;
    public static final int FYTEST_INCR_DEMAND = 1;
    public static final int FYTEST_DECR_DEMAND = -1;
    public static final int FYTEST_RULEFAIL = -2;
    public static final int FYTEST_STOPSCRIPT = 2;
    public static final int FYTEST_DSSREAD_ERROR = -10;
    public static final int FYTEST_RULENOTFOUND_ERROR = -11;
    public static final int FYTEST_RULEINZONE_ERROR = -12;
    private boolean a = false;
    private RssTSLocationObject b = null;
    private Object c = null;
    private List<StorageZoneRef> d = new ArrayList<StorageZoneRef>();
    private transient String e;

    public FirmYieldRuleRef() {
    }

    public FirmYieldRuleRef(RssTSLocationObject rssTSLocationObject, Object object) {
        this.b = rssTSLocationObject;
        this.c = object;
    }

    public RssTSLocationObject a() {
        return this.b;
    }

    public Object b() {
        return this.c;
    }

    public String c() {
        Object object = null;
        if (this.c == null) {
            return null;
        }
        if (this.b instanceof Rule) {
            object = ((DiversionElement)this.c).getName();
        } else if (this.b instanceof DownstreamOpRule) {
            object = (DownstreamOpRule)this.b;
            int n = ((DownstreamOpRule)object).getDownstreamControlLocationID();
            if ((object = ((RssTSLocationObject)object).getSystem().getNode(n)) == null) {
                return null;
            }
            if ((object = ((RssNode)object).getUpstreamElement()) == null) {
                return null;
            }
            object = object.getName();
        } else if (this.b instanceof ScheduledHydropowerOpRule) {
            object = ((ReservoirElement)this.c).getName();
        } else if (this.b instanceof SystemHydropowerRule) {
            object = "System";
        } else if (this.b instanceof ReleaseFuncOpRule) {
            object = ((ReservoirElement)this.c).getName();
        }
        return object;
    }

    public String d() {
        if (this.b == null) {
            return null;
        }
        return this.b.getName();
    }

    public String e() {
        String string = null;
        if (this.b instanceof Rule) {
            string = RULETYPE_DIVERSION;
        } else if (this.b instanceof DownstreamOpRule) {
            string = RULETYPE_DNSTRMMIN;
        } else if (this.b instanceof ScheduledHydropowerOpRule) {
            string = RULETYPE_HYDROPOWER;
        } else if (this.b instanceof SystemHydropowerRule) {
            string = RULETYPE_SYSHYDROPOWER;
        } else if (this.b instanceof ReleaseFuncOpRule) {
            string = RULETYPE_RESMIN;
        }
        return string;
    }

    public List<ReservoirElement> a(RssAlt object) {
        ArrayList<ReservoirElement> arrayList = new ArrayList<ReservoirElement>();
        if (this.b == null) {
            return arrayList;
        }
        RssReturnStatusConstants rssReturnStatusConstants = this.b instanceof Rule ? ((RssTSLocationObject)((Rule)this.b)).getSystem() : ((RssTSLocationObject)((OpRule)this.b)).getSystem();
        if (this.b instanceof Rule) {
            Rule cfr_ignored_0 = (Rule)this.b;
            object = (DiversionElement)this.c;
            object = ((Element)object).getUpstreamNode().getUpstreamElement();
            Vector<ReservoirElement> vector = ((RssSystem)rssReturnStatusConstants).getElementVectorByClass(ReservoirElement.class);
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ReservoirElement reservoirElement = (ReservoirElement)vector.get(i);
                Vector vector2 = ((RssSystem)rssReturnStatusConstants).getDownstreamElements(reservoirElement);
                if (!vector2.contains(object)) continue;
                arrayList.add(reservoirElement);
            }
        } else if (this.b instanceof DownstreamOpRule) {
            rssReturnStatusConstants = (DownstreamOpRule)this.b;
            FirmYieldRuleRef.a((RssAlt)object, ((DownstreamOp)this.c).a, (DownstreamOpRule)rssReturnStatusConstants, arrayList);
        } else if (this.b instanceof ScheduledHydropowerOpRule) {
            arrayList.add((ReservoirElement)this.c);
        } else if (this.b instanceof SystemHydropowerRule) {
            rssReturnStatusConstants = (SystemHydropowerRule)this.b;
            ((SystemHydropowerRule)rssReturnStatusConstants).getReservoirs(arrayList);
        } else if (this.b instanceof ReleaseFuncOpRule) {
            arrayList.add((ReservoirElement)this.c);
        }
        return arrayList;
    }

    public static List<ReservoirElement> a(RssAlt rssAlt, RssSystem object, DownstreamOpRule downstreamOpRule, List<ReservoirElement> list) {
        if (list == null) {
            list = new ArrayList<ReservoirElement>();
        }
        if (rssAlt == null || object == null) {
            return list;
        }
        object = ((RssSystem)object).getElementVector();
        int n = object.size();
        block0: for (int i = 0; i < n; ++i) {
            Object object2 = (Element)object.get(i);
            if (!(object2 instanceof ReservoirElement)) continue;
            ReservoirElement reservoirElement = (ReservoirElement)object2;
            int n2 = rssAlt.getResOpSetSelection(object2.getIndex());
            object2 = reservoirElement.getReservoirOp().getOperationSet(n2);
            if (object2 == null) continue;
            object2 = ((OpSet)object2).getRules(null);
            int n3 = object2.size();
            for (int j = 0; j < n3; ++j) {
                OpRule opRule = (OpRule)object2.get(j);
                if (!(opRule instanceof DownstreamCntrlOpRule) || !downstreamOpRule.getName().equals(opRule.getName()) || downstreamOpRule.getIndex() != ((DownstreamCntrlOpRule)opRule).getParentRule().getIndex() || downstreamOpRule.getDownstreamControlLocationID() != ((DownstreamCntrlOpRule)opRule).getParentRule().getDownstreamControlLocationID()) continue;
                if (list.contains(reservoirElement)) continue block0;
                list.add(reservoirElement);
                continue block0;
            }
        }
        return list;
    }

    public void a(BufferedWriter bufferedWriter) {
        if (bufferedWriter == null) {
            return;
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"FirmYieldRuleRefBegin");
        if (this.c instanceof ReservoirElement) {
            var2_2 = (ReservoirElement)this.c;
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Reservoir=" + var2_2.getIndex() + ":" + var2_2.getName()));
            this.e = "Reservoir=" + var2_2.getIndex() + ":" + var2_2.getName() + "\n";
            if (this.b instanceof OpRule) {
                RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Rule=" + this.b.getIndex() + ":" + this.b.getName() + ":" + ((OpRule)this.b).getController().getIndex()));
                this.e = this.e + "Rule=" + this.b.getIndex() + ":" + this.b.getName() + ":" + ((OpRule)this.b).getController().getIndex() + "\n";
            } else if (this.b instanceof DiversionRule) {
                RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Rule=" + this.b.getIndex() + ":" + this.b.getName() + ":" + ((DiversionRule)this.b).getController().getIndex()));
                this.e = this.e + "Rule=" + this.b.getIndex() + ":" + this.b.getName() + ":" + ((DiversionRule)this.b).getController().getIndex() + "\n";
            } else {
                RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Rule=" + this.b.getIndex() + ":" + this.b.getName()));
                this.e = this.e + "Rule=" + this.b.getIndex() + ":" + this.b.getName() + "\n";
            }
        } else if (this.c instanceof DownstreamOp) {
            var2_2 = (DownstreamOpRule)this.b;
            DownstreamOp cfr_ignored_0 = (DownstreamOp)this.c;
            if (var2_2 != null) {
                RMAIO.fout((BufferedWriter)bufferedWriter, (String)("DownstreamRule=" + var2_2.getDownstreamControlLocationID() + ":" + var2_2.getIndex()));
                this.e = this.e + "DownstreamRule=" + var2_2.getDownstreamControlLocationID() + ":" + var2_2.getIndex() + "\n";
            }
        } else if (this.c instanceof DiversionElement) {
            var2_2 = (DiversionElement)this.c;
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Diversion=" + var2_2.getIndex() + ":" + var2_2.getName()));
            this.e = this.e + "Diversion=" + var2_2.getIndex() + ":" + var2_2.getName() + "\n";
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Rule=" + this.b.getIndex() + ":" + this.b.getName()));
            this.e = this.e + "Rule=" + this.b.getIndex() + ":" + this.b.getName() + "\n";
        } else if (this.c == null && this.b instanceof SystemHydropowerOpRule) {
            var2_2 = (SystemHydropowerOpRule)this.b;
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("SystemHydroRule=" + var2_2.getIndex() + ":" + var2_2.getName()));
            this.e = this.e + "SystemHydroRule=" + var2_2.getIndex() + ":" + var2_2.getName() + "\n";
        }
        for (int i = 0; i < this.d.size(); ++i) {
            this.e = this.d.get(i).writeData(bufferedWriter, this.e);
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"FirmYieldRuleRefEnd");
        this.e = this.e + "FirmYieldRuleRefEnd\n";
    }

    public void a(RssAlt object, BufferedReader bufferedReader) {
        this.e = new String();
        StringWriter stringWriter = new StringWriter();
        try {
            while ((object = bufferedReader.readLine()) != null) {
                stringWriter.getBuffer().append((String)object);
                if (((String)object).startsWith("FirmYieldRuleRefEnd")) {
                    this.e = stringWriter.getBuffer().toString();
                    return;
                }
                stringWriter.getBuffer().append("\n");
            }
        }
        catch (IOException iOException) {
            System.out.println("readDataFromFile:error reading FirmYieldRuleRef " + String.valueOf(iOException));
        }
        this.a = false;
    }

    public boolean f() {
        return this.a;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void a(RssSystem rssReturnStatusConstants) {
        if (this.e == null) {
            this.e = new String();
        }
        Object object = new StringReader(this.e);
        object = new BufferedReader((Reader)object);
        Reader reader = object;
        object = rssReturnStatusConstants;
        FirmYieldRuleRef firmYieldRuleRef = this;
        try {
            block2: while (true) {
                OpRule opRule;
                int n;
                Object object2;
                int n2;
                Object object3;
                block22: {
                    int n3;
                    block21: {
                        String string;
                        block19: {
                            block20: {
                                if ((string = ((BufferedReader)reader).readLine()) == null) {
                                    firmYieldRuleRef.a = true;
                                    return;
                                }
                                if (string.startsWith("FirmYieldRuleRefEnd")) {
                                    firmYieldRuleRef.a = true;
                                    return;
                                }
                                object3 = RMAIO.getType((String)string, (String)"=");
                                if ("Reservoir".equalsIgnoreCase((String)object3)) {
                                    string = RMAIO.getParam((String)string, (String)"=");
                                    int n4 = RMAIO.parseInt((String)RMAIO.getType((String)string, (String)":"));
                                    RMAIO.getParam((String)string, (String)":");
                                    firmYieldRuleRef.c = ((RssSystem)object).getElement(n4);
                                    continue;
                                }
                                if (RULETYPE_DIVERSION.equalsIgnoreCase((String)object3)) {
                                    string = RMAIO.getParam((String)string, (String)"=");
                                    int n5 = RMAIO.parseInt((String)RMAIO.getType((String)string, (String)":"));
                                    RMAIO.getParam((String)string, (String)":");
                                    firmYieldRuleRef.c = ((RssSystem)object).getElement(n5);
                                    continue;
                                }
                                if (!"Rule".equalsIgnoreCase((String)object3)) break block19;
                                string = RMAIO.getParam((String)string, (String)"=");
                                object3 = new StringTokenizer(string, ":");
                                n2 = Integer.MIN_VALUE;
                                object2 = "";
                                n3 = Integer.MIN_VALUE;
                                if (((StringTokenizer)object3).hasMoreTokens()) {
                                    n2 = RMAIO.parseInt((String)((StringTokenizer)object3).nextToken());
                                }
                                if (((StringTokenizer)object3).hasMoreTokens()) {
                                    object2 = ((StringTokenizer)object3).nextToken();
                                }
                                if (((StringTokenizer)object3).hasMoreTokens()) {
                                    n3 = RMAIO.parseInt((String)((StringTokenizer)object3).nextToken());
                                }
                                if (!(firmYieldRuleRef.c instanceof ReservoirElement)) break block20;
                                object3 = (ReservoirElement)firmYieldRuleRef.c;
                                object3 = ((ReservoirElement)object3).getReservoirOp().getRules();
                                break block21;
                            }
                            if (!(firmYieldRuleRef.c instanceof DiversionElement)) continue;
                            object3 = (DiversionElement)firmYieldRuleRef.c;
                            object3 = ((DiversionElement)object3).getController().getRuleVector();
                            break block22;
                        }
                        if ("SystemHydroRule".equalsIgnoreCase((String)object3)) {
                            string = RMAIO.getParam((String)string, (String)"=");
                            int n6 = RMAIO.parseInt((String)RMAIO.getType((String)string, (String)":"));
                            string = RMAIO.getParam((String)string, (String)":");
                            firmYieldRuleRef.b = ((RssSystem)object).getSystemHydropowerRule(string);
                            if (firmYieldRuleRef.b != null) continue;
                            firmYieldRuleRef.b = ((RssSystem)object).getSystemHydropowerRule(n6);
                            continue;
                        }
                        if ("StorageZone".equalsIgnoreCase((String)object3)) {
                            object3 = new StorageZoneRef();
                            if (!((StorageZoneRef)object3).parseData((RssSystem)object, string = RMAIO.getParam((String)string, (String)"="))) continue;
                            firmYieldRuleRef.d.add((StorageZoneRef)object3);
                            continue;
                        }
                        if (!"DownstreamRule".equalsIgnoreCase((String)object3)) continue;
                        string = RMAIO.getParam((String)string, (String)"=");
                        int n7 = RMAIO.parseInt((String)RMAIO.getType((String)string, (String)":"));
                        int n8 = RMAIO.parseInt((String)RMAIO.getParam((String)string, (String)":"));
                        firmYieldRuleRef.c = object2 = ((RssSystem)object).getDownstreamOp(n7);
                        if (object2 == null) continue;
                        firmYieldRuleRef.b = ((DownstreamOp)object2).getDownstreamOpRule(n8);
                        continue;
                    }
                    for (n = 0; n < object3.size(); ++n) {
                        opRule = (OpRule)object3.get(n);
                        if (opRule.getIndex() != n2 || opRule.getController().getIndex() != n3) continue;
                        firmYieldRuleRef.b = opRule;
                        break;
                    }
                    if (firmYieldRuleRef.b != null) continue;
                    n = 0;
                    while (true) {
                        if (n >= object3.size()) continue block2;
                        opRule = (OpRule)object3.get(n);
                        if (((String)object2).equals(opRule.getName())) {
                            firmYieldRuleRef.b = opRule;
                            continue block2;
                        }
                        ++n;
                    }
                }
                for (n = 0; n < object3.size(); ++n) {
                    opRule = (OpRule)object3.get(n);
                    if (opRule.getIndex() != n2) continue;
                    firmYieldRuleRef.b = opRule;
                    break;
                }
                if (firmYieldRuleRef.b != null) continue;
                n = 0;
                while (true) {
                    if (n >= object3.size()) continue block2;
                    opRule = (OpRule)object3.get(n);
                    if (((String)object2).equals(opRule.getName())) {
                        firmYieldRuleRef.b = opRule;
                        continue block2;
                    }
                    ++n;
                }
                break;
            }
        }
        catch (IOException iOException) {
            System.out.println("readDataFromFile:error reading FirmYieldRuleRef " + String.valueOf(iOException));
            firmYieldRuleRef.a = false;
            return;
        }
    }

    public static List<FirmYieldRuleRef> a(RssAlt rssAlt, RssSystem rssSystem) {
        ArrayList<FirmYieldRuleRef> arrayList = new ArrayList<FirmYieldRuleRef>();
        if (rssAlt == null || rssSystem == null) {
            return arrayList;
        }
        Vector vector = rssSystem.getElementVector();
        int n = vector.size();
        ArrayList<OpRule> arrayList2 = new ArrayList<OpRule>();
        ArrayList arrayList3 = new ArrayList();
        for (int i = 0; i < n; ++i) {
            Object object = (Element)vector.get(i);
            if (!(object instanceof ReservoirElement)) continue;
            ReservoirElement reservoirElement = (ReservoirElement)object;
            int n2 = rssAlt.getResOpSetSelection(object.getIndex());
            object = reservoirElement.getReservoirOp().getOperationSet(n2);
            if (object == null) continue;
            object = ((OpSet)object).getRules(null);
            int n3 = object.size();
            for (int j = 0; j < n3; ++j) {
                OpRule opRule = (OpRule)object.get(j);
                if (opRule instanceof ScheduledHydropowerOpRule || opRule instanceof SystemHydropowerOpRule) continue;
                if (opRule instanceof DownstreamCntrlOpRule) {
                    if ((opRule = ((DownstreamCntrlOpRule)opRule).getParentRule()) == null || arrayList2.contains(opRule) || ((ReleaseFuncOpRule)opRule).getLimitType() != -1) continue;
                    DownstreamOp downstreamOp = rssSystem.getDownstreamOp(((DownstreamOpRule)opRule).getDownstreamControlLocationID());
                    opRule.setSystem(rssSystem);
                    downstreamOp.setSystem(rssSystem);
                    arrayList.add(new FirmYieldRuleRef(opRule, downstreamOp));
                    arrayList2.add(opRule);
                    continue;
                }
                if (!(opRule instanceof ReleaseFuncOpRule) || ((ReleaseFuncOpRule)(opRule = (ReleaseFuncOpRule)opRule)).getLimitType() != -1 && ((ReleaseFuncOpRule)opRule).getLimitType() != 0) continue;
                arrayList.add(new FirmYieldRuleRef(opRule, reservoirElement));
            }
        }
        arrayList2.clear();
        arrayList3.clear();
        return arrayList;
    }

    public StorageZone a(ReservoirElement reservoirElement) {
        int n = this.d.size();
        for (int i = 0; i < n; ++i) {
            Cloneable cloneable = this.d.get(i);
            cloneable = cloneable.getStorageZone();
            Object object = ((StorageZone)cloneable).getOpSet();
            if ((object = ((OpSet)object).getElementOp().getOperationsElement()) != reservoirElement) continue;
            return cloneable;
        }
        return null;
    }

    public double[] a(RssRun rssRun, RunTimeWindow runTimeWindow, double d, double d2) {
        double[] dArray = new double[2];
        double[] dArray2 = dArray;
        dArray[0] = -901.0;
        dArray2[1] = -901.0;
        if (this.b == null && !this.f()) {
            this.a(rssRun._alt.getSystem());
        }
        if (this.b == null) {
            System.out.println("The Firm Yield Rule is Null. ");
            rssRun._alt.getSystem().printErrorMessage("Firm Yield Rule is Null. Please check the Firm Yield Data in the Alternative Editor");
            dArray2[0] = -11.0;
            return dArray2;
        }
        RssSystem rssSystem = this.b instanceof Rule ? ((RssTSLocationObject)((Rule)this.b)).getSystem() : ((RssTSLocationObject)((OpRule)this.b)).getSystem();
        rssSystem = rssSystem.getDSSFileManager();
        TSDataSet tSDataSet = rssRun.getRegOutputTSData();
        List<ReservoirElement> list = this.a(rssRun.getAlternative());
        int n = list.size();
        if (n <= 0) {
            System.out.println("The Firm Yield Rule " + this.b.getName() + " was not found in any reservoirs.");
            rssRun._alt.getSystem().printErrorMessage("The Firm Yield Rule " + this.b.getName() + " was not found in any reservoirs. Please check the Firm Yield Data in the Alternative Editor");
            dArray2[0] = -11.0;
            return dArray2;
        }
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            int n5;
            int n6;
            Object object;
            Object object2;
            Object object3;
            ReservoirElement reservoirElement = list.get(i);
            Object object4 = this.a(reservoirElement);
            if (object4 == null) {
                System.out.println("The Firm Yield Rule " + this.b.getName() + " has a Null Zone Specification. ");
                rssRun._alt.getSystem().printErrorMessage("The Firm Yield Rule " + this.b.getName() + " has a Null Zone Specification. Please check the Firm Yield Data in the Alternative Editor");
                dArray2[0] = -11.0;
                return dArray2;
            }
            double d5 = ((StorageZone)object4).getFirstElevation();
            Object object5 = reservoirElement.a.b.getZoneVector();
            for (int j = 0; j < ((Vector)object5).size(); ++j) {
                double d6;
                object3 = (StorageZone)((Vector)object5).get(j);
                if ("Inactive".equals(object3.getName())) continue;
                object2 = new ArrayList();
                ((StorageZone)object3).getPrimaryRules((List)object2);
                boolean bl = false;
                for (int k = 0; k < object2.size(); ++k) {
                    object = (OpRule)object2.get(k);
                    if (!this.b.getName().equals(object.getName())) continue;
                    bl = true;
                }
                double d7 = ((StorageZone)object3).getFirstElevation();
                if (d6 - d5 > Double.MIN_VALUE) {
                    if (bl) continue;
                    System.out.println("The firm yield rule " + this.b.getName() + " in reservoir " + reservoirElement.getName() + " is absent from zone " + object3.getName() + " which is above the upper limit of the firm yield rule zone " + object4.getName());
                    rssRun._alt.getSystem().printErrorMessage("The firm yield rule " + this.b.getName() + " in reservoir " + reservoirElement.getName() + " is absent from zone " + object3.getName() + " which is above the upper limit of the firm yield rule zone " + object4.getName() + ". Please add it to the zone and rerun the simulation.");
                    dArray2[0] = -12.0;
                    return dArray2;
                }
                if (!bl) continue;
                System.out.println("The firm yield rule " + this.b.getName() + " in reservoir " + reservoirElement.getName() + " is present in zone " + object3.getName() + " which is below the upper limit of the firm yield rule zone " + object4.getName());
                rssRun._alt.getSystem().printErrorMessage("The firm yield rule " + this.b.getName() + " in reservoir " + reservoirElement.getName() + " is present in zone " + object3.getName() + " which is below the upper limit of the firm yield rule zone " + object4.getName() + ". Please remove it from the zone and rerun the simulation.");
                dArray2[0] = -12.0;
                return dArray2;
            }
            object5 = reservoirElement.getStorageFunction().getTSRecordProxy(11);
            object5 = tSDataSet.getTSRecord(object5.getName(), 11);
            Object object6 = object5.getDSSPathname();
            if (object4 == null) continue;
            object2 = ((StorageZone)object4).getOpSet().getFullZoneName((StorageZone)object4);
            object5 = ((StorageZone)object4).getOpSet().getTSRecordProxy((String)object2, 78);
            object5 = tSDataSet.getTSRecord(object5.getName(), 78);
            Object object7 = object5.getDSSPathname();
            StorageZone storageZone = reservoirElement.a.getActiveOpSet().getGuideCurveZone();
            if (storageZone == null) continue;
            object = storageZone.getOpSet().getFullZoneName(storageZone);
            object5 = storageZone.getOpSet().getTSRecordProxy((String)object, 78);
            object5 = tSDataSet.getTSRecord(object5.getName(), 78);
            object4 = object5.getDSSPathname();
            if (this.b instanceof ReleaseFuncOpRule) {
                if (((ReleaseFuncOpRule)this.b).getLimitType() == 0) {
                    object5 = ((OpRule)this.b).getTSRecordProxy(80);
                    object5 = tSDataSet.getTSRecord(object5.getName(), 80);
                } else {
                    object5 = ((OpRule)this.b).getTSRecordProxy(82);
                    object5 = tSDataSet.getTSRecord(object5.getName(), 82);
                }
            } else {
                object5 = ((OpRule)this.b).getTSRecordProxy(79);
                object5 = tSDataSet.getTSRecord(object5.getName(), 79);
            }
            object3 = object5.getDSSPathname();
            object5 = ((OpRule)this.b).getTargetTSRecordProxy();
            object5 = tSDataSet.getTSRecord(object5.getName(), object5.getVariableId());
            Object object8 = object5.getDSSPathname();
            object5 = object5.getDSSFilename();
            object6 = new DSSIdentifier((String)object5, (String)object6);
            DSSIdentifier dSSIdentifier = new DSSIdentifier((String)object5, (String)object7);
            object4 = new DSSIdentifier((String)object5, (String)object4);
            object3 = new DSSIdentifier((String)object5, (String)object3);
            object5 = new DSSIdentifier((String)object5, (String)object8);
            object6.setTimeWindow(runTimeWindow.getStartTime(), runTimeWindow.getEndTime());
            dSSIdentifier.setTimeWindow(runTimeWindow.getStartTime(), runTimeWindow.getEndTime());
            object4.setTimeWindow(runTimeWindow.getStartTime(), runTimeWindow.getEndTime());
            object3.setTimeWindow(runTimeWindow.getStartTime(), runTimeWindow.getEndTime());
            object5.setTimeWindow(runTimeWindow.getStartTime(), runTimeWindow.getEndTime());
            try {
                object6 = rssSystem.read((DSSIdentifier)object6);
                object8 = rssSystem.read(dSSIdentifier);
                object4 = rssSystem.read((DSSIdentifier)object4);
                object3 = rssSystem.read((DSSIdentifier)object3);
                object5 = rssSystem.read((DSSIdentifier)object5);
            }
            catch (RemoteException remoteException) {
                System.out.println("testFirmYield:error in dssFileManger.read " + String.valueOf(remoteException));
                dArray2[0] = -10.0;
                return dArray2;
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("testFirmYield:error in dssFileManger.read " + String.valueOf(fileNotFoundException));
                dArray2[0] = -10.0;
                return dArray2;
            }
            object6 = ((DSSArrayContainer)object6).dataArray;
            object8 = ((DSSArrayContainer)object8).dataArray;
            object4 = ((DSSArrayContainer)object4).dataArray;
            object3 = ((DSSArrayContainer)object3).dataArray;
            object5 = ((DSSArrayContainer)object5).dataArray;
            int n7 = 1;
            int n8 = 0;
            if (this.b instanceof DownstreamOpRule) {
                object7 = (DownstreamOpRule)this.b;
                n7 = ((DownstreamOpRule)object7).getNumRouteSteps();
                n6 = -1;
                for (n5 = 0; n5 < ((DownstreamOpRule)object7).e.length; ++n5) {
                    if (((DownstreamOpRule)object7).e[n5] != reservoirElement) continue;
                    n6 = n5;
                    break;
                }
                n8 = Math.round((float)((DownstreamOpRule)object7).f[n6]);
            }
            n6 = ((Object)object6).length;
            n5 = 0;
            int n9 = 0;
            double d8 = 0.0;
            double d9 = 0.0;
            for (int j = n7; j < n6; ++j) {
                if (object6[j] < object8[j]) {
                    ++n5;
                }
                if (object6[j] <= object8[j] + d) {
                    ++n9;
                }
                if (object5[j] < object3[j] - d2) {
                    ++n4;
                }
                if (object4[j] - object6[j] >= 1.0) {
                    n7 = 0;
                } else {
                    n7 = 1;
                    d8 = 0.0;
                    d9 = 0.0;
                }
                if (n7 != 0 || j >= n6 - n8) continue;
                double d10 = Math.max((double)(object3[j + n8] - object5[j + n8]), 0.0);
                reference var66_17 = object6[j] - object8[j];
                d3 = Math.min(d3, (double)(var66_17 / (d8 += object3[j + n8] * (double)runTimeWindow.getTimeStepSeconds() / Storage.DSDT_TO_Q)));
                d4 = Math.max(d4, (d9 += d10 * (double)runTimeWindow.getTimeStepSeconds() / Storage.DSDT_TO_Q) / d8);
            }
            if (n2 > n5) {
                n2 = n5;
            }
            if (n3 <= n9) continue;
            n3 = n9;
        }
        if (n4 > 0) {
            if (n2 <= 0 && this.b instanceof DownstreamOpRule && d3 > Double.MIN_VALUE) {
                dArray2[0] = 1.0;
                dArray2[1] = d3 + 1.0;
                return dArray2;
            }
            dArray2[0] = -2.0;
            dArray2[1] = 1.0 - d4;
            return dArray2;
        }
        if (n3 <= 0) {
            dArray2[0] = 1.0;
            dArray2[1] = d3 != Double.POSITIVE_INFINITY ? d3 + 1.0 : 2.0;
            return dArray2;
        }
        if (n2 > 0) {
            dArray2[0] = -1.0;
            dArray2[1] = d3 + 1.0;
            return dArray2;
        }
        dArray2[0] = 0.0;
        dArray2[1] = 1.0;
        return dArray2;
    }

    public int a(RssRun object, RunTimeWindow object2, double d) {
        RssSystem rssSystem = ((RssTSLocationObject)((OpRule)this.b)).getSystem();
        rssSystem = rssSystem.getDSSFileManager();
        object = ((RssRun)object).getRegOutputTSData();
        Object object3 = ((OpRule)this.b).getTSRecordProxy(80);
        object3 = object.getTSRecord(object3.getName(), 80);
        String string = object3.getDSSPathname();
        object3 = ((OpRule)this.b).getTargetTSRecordProxy();
        object3 = object.getTSRecord(object3.getName(), object3.getVariableId());
        object = object3.getDSSPathname();
        object3 = object3.getDSSFilename();
        string = new DSSIdentifier((String)object3, string);
        object = new DSSIdentifier((String)object3, (String)object);
        string.setTimeWindow(object2.getStartTime(), object2.getEndTime());
        object.setTimeWindow(object2.getStartTime(), object2.getEndTime());
        try {
            object2 = rssSystem.read((DSSIdentifier)string);
            object = rssSystem.read((DSSIdentifier)object);
        }
        catch (RemoteException remoteException) {
            System.out.println("testFirmYield:error in dssFileManger.read " + String.valueOf(remoteException));
            return -1;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("testFirmYield:error in dssFileManger.read " + String.valueOf(fileNotFoundException));
            return -1;
        }
        object2 = object2.dataArray;
        object = ((DSSArrayContainer)object).dataArray;
        int n = ((DSSArrayContainer)object).dataArray.length;
        for (int i = 1; i < n; ++i) {
            if (!(object[i] > object2[i] + d)) continue;
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.b.getName() + " - " + this.c();
    }

    public void a(List<StorageZoneRef> list) {
        this.d.clear();
        this.d.addAll(list);
    }

    public List<StorageZoneRef> g() {
        return this.d;
    }

    public void b(RssAlt rssAlt) {
        Object object;
        Object object2 = rssAlt;
        FirmYieldRuleRef firmYieldRuleRef = this;
        if (firmYieldRuleRef.b != null && firmYieldRuleRef.c != null) {
            if (firmYieldRuleRef.b instanceof SystemHydropowerRule) {
                object = ((SystemHydropowerRule)firmYieldRuleRef.b).getName();
                int n = ((SystemHydropowerRule)firmYieldRuleRef.b).getIndex();
                firmYieldRuleRef.b = ((RssAlt)object2).getSystem().getSystemHydropowerRule((String)object);
                if (firmYieldRuleRef.b == null) {
                    firmYieldRuleRef.b = ((RssAlt)object2).getSystem().getSystemHydropowerRule(n);
                }
            } else if (firmYieldRuleRef.b instanceof DownstreamOpRule) {
                int n = ((DownstreamOpRule)firmYieldRuleRef.b).getDownstreamControlLocationID();
                int n2 = ((DownstreamOpRule)firmYieldRuleRef.b).getIndex();
                firmYieldRuleRef.c = object2 = ((RssAlt)object2).getSystem().getDownstreamOp(n);
                if (object2 != null) {
                    firmYieldRuleRef.b = ((DownstreamOp)object2).getDownstreamOpRule(n2);
                }
            } else if (firmYieldRuleRef.b instanceof OpRule && firmYieldRuleRef.c instanceof ReservoirElement) {
                int n = ((OpRule)firmYieldRuleRef.b).getIndex();
                String string = ((OpRule)firmYieldRuleRef.b).getName();
                object2 = (ReservoirElement)firmYieldRuleRef.c;
                var6_15 = ((ReservoirElement)object2).getReservoirOp().getRules();
                for (var8_16 = 0; var8_16 < var6_15.size(); ++var8_16) {
                    var7_17 = (OpRule)var6_15.get(var8_16);
                    if (var7_17.getIndex() != n) continue;
                    firmYieldRuleRef.b = var7_17;
                    break;
                }
                if (firmYieldRuleRef.b == null) {
                    for (var8_16 = 0; var8_16 < var6_15.size(); ++var8_16) {
                        var7_17 = (OpRule)var6_15.get(var8_16);
                        if (!string.equals(var7_17.getName())) continue;
                        firmYieldRuleRef.b = var7_17;
                        break;
                    }
                }
            } else if (firmYieldRuleRef.b instanceof Rule && firmYieldRuleRef.c instanceof DiversionElement) {
                DiversionElement diversionElement = (DiversionElement)firmYieldRuleRef.c;
                Vector vector = diversionElement.getController().getRuleVector();
                int n = ((Rule)firmYieldRuleRef.b).getIndex();
                var6_15 = ((Rule)firmYieldRuleRef.b).getName();
                for (var8_16 = 0; var8_16 < vector.size(); ++var8_16) {
                    var7_17 = (Rule)vector.get(var8_16);
                    if (var7_17.getIndex() != n) continue;
                    firmYieldRuleRef.b = var7_17;
                    break;
                }
                if (firmYieldRuleRef.b == null) {
                    for (var8_16 = 0; var8_16 < vector.size(); ++var8_16) {
                        var7_17 = (Rule)vector.get(var8_16);
                        if (!((String)var6_15).equals(var7_17.getName())) continue;
                        firmYieldRuleRef.b = var7_17;
                        break;
                    }
                }
            }
        }
        if (this.d != null) {
            int n = this.d.size();
            for (int i = 0; i < n; ++i) {
                object = this.d.get(i);
                ((StorageZoneRef)object).updateZone(rssAlt);
            }
        }
    }

    public Object clone() {
        try {
            FirmYieldRuleRef firmYieldRuleRef = (FirmYieldRuleRef)super.clone();
            return firmYieldRuleRef;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println(cloneNotSupportedException);
            return null;
        }
    }
}

