/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.Parameter;
import hec.heclib.util.doubleArrayContainer;
import hec.model.PairedValues;
import hec.model.RunTimeStep;
import hec.rss.model.AdjustableDiversion;
import hec.rss.model.AdjustableParameter;
import hec.rss.model.Controller;
import hec.rss.model.Element;
import hec.rss.model.JunctionElement;
import hec.rss.model.OpController;
import hec.rss.model.RssNode;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.Rule;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Vector;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class FlowFunction
extends Rule {
    PairedValues _flowValues = new PairedValues();
    String _flowLocation = "";
    int _flowLocationIndex = -1;
    public static final String FLOW = "Flow";
    private transient doubleArrayContainer b;
    private transient Vector c;

    public FlowFunction() {
        this.setRuleType("Function of Flow");
    }

    @Deprecated
    public FlowFunction(Controller controller) {
        super(controller);
        this.setRuleType("Function of Flow");
    }

    public FlowFunction(OpController opController) {
        super(opController);
        this.setRuleType("Function of Flow");
    }

    public void setFlowValues(PairedValues pairedValues) {
        this._flowValues = pairedValues;
    }

    public PairedValues getFlowValues() {
        this._flowValues.setUnitSystem(this.getUnitSystem());
        this._flowValues.setParamXId(Parameter.PARAMID_FLOW);
        this._flowValues.setParamYId(Parameter.PARAMID_FLOW);
        return this._flowValues;
    }

    public void setFlowLocation(String string) {
        this._flowLocation = string;
    }

    public String getFlowLocation() {
        return this._flowLocation;
    }

    public void setFlowLocationIndex(int n) {
        this._flowLocationIndex = n;
    }

    public int getFlowLocationIndex() {
        return this._flowLocationIndex;
    }

    @Override
    public double getValue(AdjustableParameter adjustableParameter, RunTimeStep runTimeStep, double d) {
        int n = runTimeStep.step > 0 ? runTimeStep.step - 1 : 0;
        double d2 = d;
        if (this.c != null) {
            double d3 = 0.0;
            for (n = 0; n < this.c.size(); ++n) {
                doubleArrayContainer doubleArrayContainer2 = (doubleArrayContainer)this.c.elementAt(n);
                d3 += doubleArrayContainer2.array[runTimeStep.step];
            }
            d2 = this._flowValues.interpolateValue(d3);
        } else if (this.b != null) {
            d2 = this._flowValues.interpolateValue(this.b.array[n]);
        }
        if (!RMAConst.isValidValue((double)d2)) {
            this.controller.getDiversionFunction().printErrorMessage("FlowFunction.getValue: invalid release calculation");
            this.controller.getDiversionFunction().printErrorMessage("Controller: " + this.controller.getName());
            this.controller.getDiversionFunction().printErrorMessage("Date and Time: " + runTimeStep.dateTimeString());
        }
        if (this.useDemandScale()) {
            return d2 * this.getDemandScale();
        }
        return d2;
    }

    @Override
    public boolean initialize() {
        this.b = null;
        this.c = null;
        Object object = ((RssTSLocationObject)this.controller.getDiversionFunction()).getSystem().getNode(this._flowLocationIndex);
        if (object == null) {
            this.controller.getDiversionFunction().printErrorMessage("FlowFunction.initialize: Failed to find flow location");
            this.controller.getDiversionFunction().printErrorMessage("Controller: " + this.controller.getName());
            return false;
        }
        Element element = ((RssNode)object).getUpstreamElement();
        if (element != null && element instanceof JunctionElement) {
            this.c = new Vector();
            object = element.getNodeVector();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                Element element2;
                int n;
                RssNode rssNode = (RssNode)((Vector)object).elementAt(i);
                if (rssNode == null || (n = element.getNodeDir(i)) == 0 || (element2 = rssNode.getUpstreamElement()) != null && element2.getFunction() instanceof AdjustableDiversion) continue;
                element2 = rssNode.getTSContainer(0);
                if (element2 == null) {
                    element2 = rssNode.getTSContainer(4);
                }
                if (element2 == null) continue;
                this.c.addElement(element2);
            }
            if (this.c.size() <= 0) {
                this.controller.getDiversionFunction().printErrorMessage("FlowFunction.intialize: failed to get source time series");
                this.controller.getDiversionFunction().printErrorMessage("Controller: " + this.controller.getName());
                return false;
            }
        } else {
            this.b = object.getTSContainer(0);
            if (this.b == null) {
                this.controller.getDiversionFunction().printErrorMessage("FlowFunction.intialize: failed to get flow time series");
                this.controller.getDiversionFunction().printErrorMessage("Controller: " + this.controller.getName());
                return false;
            }
        }
        return true;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    @Deprecated
    public boolean writeData(BufferedWriter bufferedWriter) {
        String string = this.getRuleType();
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller Rule=" + string));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller " + string + " Name=" + this.getName()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller " + string + " flowLocation=" + this._flowLocation));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller " + string + " flowLocationIndex=" + this._flowLocationIndex));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller " + string + " values=" + this._flowValues.getData()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller " + string + " End"));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"");
        return true;
    }

    @Override
    @Deprecated
    public boolean readData(BufferedReader bufferedReader) {
        String string = this.getRuleType();
        try {
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (string2.length() == 0) {
                    string2 = bufferedReader.readLine();
                    continue;
                }
                if (string2.indexOf("Controller " + string) < 0) break;
                String string3 = RMAIO.getType((String)string2, (String)"=");
                string2 = RMAIO.getParam((String)string2, (String)"=");
                if (string3.equals("Controller " + string + " Name")) {
                    this.setName(string2);
                } else if (string3.equals("Controller " + string + " flowLocation")) {
                    this._flowLocation = string2;
                } else if (string3.equals("Controller " + string + " flowLocationIndex")) {
                    this._flowLocationIndex = Integer.parseInt(string2);
                } else if (string3.equals("Controller " + string + " values")) {
                    this._flowValues.setData(string2);
                } else if (string3.equals("Controller " + string + " End")) break;
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }
}

