/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.data.Parameter;
import hec.heclib.util.doubleArrayContainer;
import hec.lang.DSSPathString;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.model.SeasonalRecord;
import hec.rss.model.OpRule;
import hec.rss.model.OpValue;
import hec.rss.model.OperationsElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirSysOp;
import hec.rss.model.RssModelVariableConstants;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssNode;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.Storage;
import java.util.List;
import java.util.Vector;
import rma.lang.RmaMath;

@Deprecated
public class FlowLimitOpRule
extends OpRule
implements RssModelVariableConstants {
    public static final int MIN = -1;
    public static final int MAX = 1;
    public static final String PARAMSTR_MAXRULE = "FLow-MaxRule";
    public static final String PARAMSTR_MINRULE = "FLow-MinRule";
    public static final String PARAMSTR_MAXRULEID = "FLow-Max-RuleId";
    public static final String PARAMSTR_MINRULEID = "FLow-Min-RuleId";
    int _limitType = -1;
    int _rssNodeIndex = -1;
    SeasonalRecord _seasonalRecord = new SeasonalRecord();
    private transient int a;
    private transient int b;
    private transient double[] c;
    private transient double[] d;
    private transient double[] e;
    private transient double[] f;
    private transient double[] i;
    private transient int[] j;
    private transient int[] k;
    private transient int l;
    private transient int m;
    private transient int n;
    private transient int o;
    private transient double p;
    private transient double[] q;
    private transient doubleArrayContainer r;
    private transient RunTimeStep s;
    private transient RssNode t;
    private transient double[] u;
    private transient double[] v;
    private transient double[] w;
    private transient double[] x;
    private transient boolean y;
    private transient Vector z;
    private transient Vector A;
    private transient int[] B;
    private transient boolean[] C;
    private transient int D;
    private transient double[] E;
    private transient double[] F;
    private transient double[] G;
    private transient double[] H;
    private transient double[] I;
    private transient int[] J;
    private transient int[] K;

    public FlowLimitOpRule() {
    }

    public FlowLimitOpRule(String string) {
        super(string);
    }

    @Override
    public void getElementDependencies(List list) {
        if (this._rssNodeIndex < 0) {
            return;
        }
        RssReturnStatusConstants rssReturnStatusConstants = ((RssTSLocationObject)this).getSystem().getNode(this._rssNodeIndex);
        if (rssReturnStatusConstants == null) {
            return;
        }
        if (!list.contains(rssReturnStatusConstants = rssReturnStatusConstants.getUpstreamElement())) {
            list.add(rssReturnStatusConstants);
        }
    }

    public int getLag() {
        return this.l;
    }

    public int getMaxRoutingSteps() {
        return this.n - this.b + 1;
    }

    @Override
    public void updateTSProxyList() {
        Object object;
        if (this._limitType == -1) {
            object = this.getTSRecordProxy(82);
            if (object == null) {
                this.addTSRecordProxy(82);
            }
        } else {
            object = this.getTSRecordProxy(81);
            if (object == null) {
                this.addTSRecordProxy(81);
            }
        }
        if (this._rssNodeIndex >= 0 && (object = this.getTSRecordProxy(86)) == null) {
            object = this._controller.getElementOp().getOperationsElement().getSystem();
            RssNode rssNode = object.getNode(this._rssNodeIndex);
            if ((object = RssModelVariableSet.newTSRecordProxy((RssSystem)object, rssNode, 86)) != null) {
                this._tsrecordVector.addElement(object);
            }
        }
    }

    @Override
    public Vector getActiveTSRecordProxies(Vector vector, int n) {
        if (vector == null) {
            vector = new Vector<TSRecordProxy>();
        }
        if (n == 0) {
            TSRecordProxy tSRecordProxy;
            if (this._limitType == -1) {
                tSRecordProxy = this.getTSRecordProxy(82);
                if (tSRecordProxy != null) {
                    vector.addElement(tSRecordProxy);
                }
            } else {
                tSRecordProxy = this.getTSRecordProxy(81);
                if (tSRecordProxy != null) {
                    vector.addElement(tSRecordProxy);
                }
            }
            if (this._rssNodeIndex >= 0 && (tSRecordProxy = this.getTSRecordProxy(86)) != null) {
                vector.addElement(tSRecordProxy);
            }
        }
        return vector;
    }

    @Override
    public synchronized Object clone() {
        try {
            FlowLimitOpRule flowLimitOpRule = (FlowLimitOpRule)super.clone();
            ((FlowLimitOpRule)super.clone())._seasonalRecord = (SeasonalRecord)this._seasonalRecord.clone();
            flowLimitOpRule._limitType = this._limitType;
            flowLimitOpRule._rssNodeIndex = this._rssNodeIndex;
            flowLimitOpRule.a = this.a;
            flowLimitOpRule.b = this.b;
            flowLimitOpRule.o = this.o;
            flowLimitOpRule.l = this.l;
            if (this.c != null) {
                flowLimitOpRule.c = new double[this.c.length];
                System.arraycopy(this.c, 0, flowLimitOpRule.c, 0, this.c.length);
            }
            if (this.d != null) {
                flowLimitOpRule.d = new double[this.d.length];
                System.arraycopy(this.d, 0, flowLimitOpRule.d, 0, this.d.length);
            }
            if (this.e != null) {
                flowLimitOpRule.e = new double[this.e.length];
                System.arraycopy(this.e, 0, flowLimitOpRule.e, 0, this.e.length);
            }
            return flowLimitOpRule;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean computePulseResponse(RunTimeStep runTimeStep, double d, double d2, int n) {
        int n2;
        if (this._rssNodeIndex < 0) {
            return false;
        }
        Object object = this._controller.getElementOp().getOperationsElement().getSystem().getNode(this._rssNodeIndex);
        object = object.getTSArray(0);
        int n3 = runTimeStep.step;
        int n4 = runTimeStep.nstep;
        this.b = n;
        double[] dArray = new double[n4];
        double d3 = d - d2;
        if (d3 == 0.0) {
            return false;
        }
        int n5 = n4;
        int n6 = -1;
        double d4 = Double.MIN_VALUE;
        for (int i = 0; i < n4; ++i) {
            dArray[i] = (double)(object[i + n3] - d2);
            dArray[i] = dArray[i] / d3;
            if (!(d4 < dArray[i])) continue;
            d4 = dArray[i];
            this.l = i;
        }
        double d5 = d4 * 0.001;
        double d6 = 0.0;
        for (n2 = 0; n2 < n4; ++n2) {
            if (dArray[n2] > d5) {
                n5 = n2;
                if (n6 < 0) {
                    n6 = n2;
                }
                d6 += dArray[n2];
                continue;
            }
            dArray[n2] = 0.0;
        }
        this.a = n5 - n6 + 1;
        if (d6 != 0.0) {
            n2 = n6;
            while (n2 <= n5) {
                int n7 = n2++;
                dArray[n7] = dArray[n7] / d6;
            }
        }
        this.c = dArray;
        this.m = n6;
        this.n = n5;
        this.o = n5 + 1;
        this.p = 1.0;
        if (d4 > 0.0 && d6 > 0.0) {
            this.p = d4 / d6;
        }
        this.l -= this.b + 1;
        if (this.l < 0) {
            this.l = 0;
        }
        return true;
    }

    @Deprecated
    public boolean calculateRoutedRelease(RunTimeWindow object) {
        if (this._rssNodeIndex < 0) {
            return false;
        }
        double[] dArray = this._controller.getReleaseArray();
        object = dArray;
        if (dArray == null) {
            return false;
        }
        if (this.e == null || this.e.length != ((RunTimeWindow)object).length) {
            this.e = new double[((RunTimeWindow)object).length];
        }
        int n = this.e.length;
        if (this.m >= 0) {
            for (int i = 0; i < n; ++i) {
                this.e[i] = 0.0;
                for (int j = 0; j < this.a; ++j) {
                    int n2;
                    int n3 = this.m + j;
                    if (n3 >= this.c.length) {
                        n3 = this.c.length - 1;
                    }
                    if ((n2 = i - (this.m - (this.b + 1)) - j) < 0) {
                        n2 = 0;
                    }
                    if (n2 >= ((RunTimeWindow)object).length) {
                        n2 = ((RunTimeWindow)object).length - 1;
                    }
                    int n4 = i;
                    this.e[n4] = this.e[n4] + this.c[n3] * object[n2];
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.e[i] = (double)object[i];
            }
        }
        return true;
    }

    @Deprecated
    public boolean calculateRoutedRelease_old(RunTimeWindow runTimeWindow) {
        int n;
        if (this._rssNodeIndex < 0) {
            return false;
        }
        double[] dArray = this._controller.getReleaseArray();
        if (dArray == null) {
            return false;
        }
        if (this.e == null || this.e.length != dArray.length) {
            this.e = new double[dArray.length];
        }
        int n2 = this.e.length;
        if (this.m >= 0) {
            for (n = 0; n < n2; ++n) {
                this.e[n] = 0.0;
                for (int i = 0; i <= this.a; ++i) {
                    int n3 = n - (this.m - (this.b + 1)) - i;
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    int n4 = n;
                    this.e[n4] = this.e[n4] + this.c[this.m + i] * dArray[n3];
                }
            }
        } else {
            for (n = 0; n < n2; ++n) {
                this.e[n] = dArray[n];
            }
        }
        this.s.rtw = runTimeWindow;
        this.s.step = 0;
        this.s.nstep = 1;
        n = 0;
        while (n < this.s.getTotalNumSteps()) {
            this.s.step = n++;
            this.q[this.s.step] = this._seasonalRecord.interpolate(this.s);
        }
        return true;
    }

    private void calcBackQByIterativeSoln(double[] dArray) {
        int n;
        double[] dArray2 = new double[this.a];
        double[] dArray3 = new double[this.a];
        for (n = 0; n < this.a; ++n) {
            dArray2[n] = this.c[n + this.m];
        }
        int n2 = this.m - (this.b + 1);
        int n3 = this.d.length <= dArray.length ? this.d.length : dArray.length;
        for (int i = 0; i < 5; ++i) {
            int n4 = n2 + this.l;
            if (n4 >= n3) {
                n4 = n3 - 1;
            }
            this.d[0] = this.q[n4] - (dArray[n4] - this.e[n4]);
            for (n = 1; n < n3; ++n) {
                double d = 0.0;
                for (int j = 0; j < this.a; ++j) {
                    n4 = n + n2 + j;
                    if (n4 >= n3) {
                        n4 = n3 - 1;
                    }
                    dArray3[j] = this.q[n4] - (dArray[n4] - this.e[n4]);
                    double d2 = dArray2[j];
                    for (int k = 0; k < this.a; ++k) {
                        if (k == j) continue;
                        n4 = n - (this.a - 1) + j + k;
                        if (n4 < 0) {
                            n4 = 0;
                        }
                        if (n4 >= n3) {
                            n4 = n3 - 1;
                        }
                        if (i == 0 && n4 >= n) {
                            d2 += dArray2[k];
                            continue;
                        }
                        int n5 = j;
                        dArray3[n5] = dArray3[n5] - this.d[n4] * dArray2[k];
                    }
                    int n6 = j;
                    dArray3[n6] = dArray3[n6] / d2;
                    d += dArray3[j];
                }
                this.d[n] = d / (double)this.a;
            }
        }
    }

    private void calcBackQByDirectSoln(double[] dArray) {
        int n;
        int n2;
        int n3;
        int n4 = this.a;
        int n5 = this.m;
        double[] dArray2 = new double[3];
        for (n3 = 0; n3 < n4; ++n3) {
            dArray2[n3] = this.c[n3 + n5];
            double cfr_ignored_0 = dArray2[n3];
        }
        if (this.i == null) {
            int n6 = n4;
            this.i = new double[n6 * n6];
            this.j = new int[n4];
            this.k = new int[1];
            for (n3 = 0; n3 < n4; ++n3) {
                for (n2 = 0; n2 < n4; ++n2) {
                    n = n3 - n2;
                    this.i[n3 * n4 + n2] = n >= 0 ? dArray2[n4 - 1 - n] : 0.0;
                }
            }
            RmaMath.luDComp((double[])this.i, (int)n4, (int[])this.j, (int[])this.k);
        }
        dArray2 = new double[n4];
        int n7 = n5 - (this.b + 1);
        n = dArray.length;
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                int n8 = n3 + n7 + n2;
                if (n8 >= n) {
                    n8 = n - 1;
                }
                dArray2[n2] = this.q[n8] - (dArray[n8] - this.e[n8]);
                for (int i = 0; i < n4 - 1 - n2; ++i) {
                    n8 = n3 + n7 - (n4 - 1) + i;
                    int n9 = n3 - (n4 - 1 - n2) + i;
                    if (n8 < 0) {
                        n8 = 0;
                    }
                    if (n8 >= n) {
                        n8 = n - 1;
                    }
                    if (n9 < 0) {
                        int n10 = n2;
                        dArray2[n10] = dArray2[n10] - (this.q[n8] - (dArray[n8] - this.e[n8])) * this.c[n5 + i];
                        continue;
                    }
                    int n11 = n2;
                    dArray2[n11] = dArray2[n11] - this.d[n9] * this.c[n5 + i];
                }
            }
            RmaMath.luBackSub((double[])this.i, (int)n4, (int[])this.j, (double[])dArray2);
            this.d[n3] = dArray2.length < 2 || n3 == 0 ? dArray2[0] : (this.d[n3 - 1] + 2.0 * dArray2[0] + dArray2[1]) / 4.0;
        }
    }

    @Override
    public boolean initializeCompute() {
        RssSystem rssSystem = this._controller.getElementOp().getOperationsElement().getSystem();
        this.s = new RunTimeStep();
        this.q = this._limitType == -1 ? this.getTSArray(82) : this.getTSArray(81);
        if (this.q == null) {
            rssSystem.printErrorMessage("FlowLimitOpRule.initializeCompute: Failed to load time series arrays");
            return false;
        }
        this.t = null;
        this.f = null;
        this.r = null;
        if (this._rssNodeIndex >= 0) {
            this.t = this._controller.getElementOp().getOperationsElement().getSystem().getNode(this._rssNodeIndex);
            this.f = this.t.getTSArray(0);
            this.t.addFlowRule(this);
            this.u = new double[this.a << 1];
            this.v = new double[this.a << 1];
            this.w = new double[this.a << 1];
            this.x = new double[this.a * 3];
        }
        if (this._rssNodeIndex >= 0) {
            TSDataSet tSDataSet = rssSystem.getOutputTSDataSet();
            if (tSDataSet == null) {
                return false;
            }
            TSRecordProxy tSRecordProxy = this.getTSRecordProxy(86);
            if (tSRecordProxy == null) {
                return false;
            }
            if ((tSRecordProxy = tSDataSet.getTSRecord(tSRecordProxy.getName(), 86)) == null) {
                return false;
            }
            DSSPathString dSSPathString = new DSSPathString(tSRecordProxy.getDSSPathname());
            dSSPathString.setCPart("FLOW-CUMLOC");
            tSRecordProxy.setDSSPathname(dSSPathString.getPathname());
            tSDataSet.loadTSRecord(tSRecordProxy.getName(), 86, "");
            this.r = this.getTSContainer(86);
            if (this.r == null) {
                rssSystem.printErrorMessage("FlowLimitOpRule.initializeCompute: Failed to load cummulative local flow TS");
                return false;
            }
        }
        this.e = null;
        this.d = null;
        this.i = null;
        this.y = true;
        return true;
    }

    @Override
    public OpValue evaluateRule(RunTimeStep runTimeStep, double d, int n) {
        if (this._rssNodeIndex < 0) {
            return this.evaluateRuleLocal(runTimeStep, d);
        }
        return this.evaluateRuleDownstream(runTimeStep, d, n);
    }

    OpValue evaluateRuleLocal(RunTimeStep object, double d) {
        double d2 = this._seasonalRecord.interpolate(object);
        if (d2 == Double.NEGATIVE_INFINITY) {
            return null;
        }
        this.q[object.step] = d2;
        object = new OpValue();
        new OpValue().value = d2;
        object.type = this._limitType == 1 ? 2 : 0;
        return object;
    }

    boolean initializeFirstPass() {
        FlowLimitOpRule flowLimitOpRule;
        int n;
        Vector vector = this.t.getFlowRuleVector();
        if (vector == null) {
            return false;
        }
        this.z = new Vector();
        this.A = new Vector();
        int n2 = vector.size();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            flowLimitOpRule = (FlowLimitOpRule)vector.elementAt(n);
            if (flowLimitOpRule._limitType != this._limitType || this.z.contains(flowLimitOpRule) || flowLimitOpRule.l > this.l) continue;
            this.z.add(flowLimitOpRule);
            OperationsElement operationsElement = flowLimitOpRule.getOperationsElement();
            this.A.add(operationsElement);
            if (flowLimitOpRule == this) {
                this.D = n3;
            }
            ++n3;
        }
        n2 = this.A.size();
        this.B = new int[n2];
        this.C = new boolean[n2];
        this.E = new double[n2];
        this.F = new double[n2];
        this.G = new double[n2];
        this.H = new double[n2];
        this.I = new double[n2];
        this.J = new int[n2];
        this.K = new int[n2];
        for (n = 0; n < n2; ++n) {
            flowLimitOpRule = (FlowLimitOpRule)this.z.elementAt(n);
            this.B[n] = flowLimitOpRule.m - flowLimitOpRule.b + flowLimitOpRule.a;
        }
        this.y = false;
        return true;
    }

    OpValue evaluateRuleDownstream(RunTimeStep runTimeStep, double d, int n) {
        int n2;
        if (this.y && !this.initializeFirstPass()) {
            return null;
        }
        this.q[runTimeStep.step] = this._seasonalRecord.interpolate(runTimeStep);
        int n3 = this.z.size();
        int n4 = n2 = this.m - this.b + this.a;
        int n5 = 0;
        this.s.init(runTimeStep);
        --this.s.step;
        if (this.s.step < 0) {
            this.s.step = 0;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            FlowLimitOpRule flowLimitOpRule = (FlowLimitOpRule)this.z.elementAt(n2);
            this.C[n2] = flowLimitOpRule.isActive(this.s);
            if (!this.C[n2]) continue;
            ++n5;
            flowLimitOpRule.calculateRoutedRelease(runTimeStep.rtw);
        }
        if (n5 <= 0) {
            return null;
        }
        ReservoirSysOp.a(((RssTSLocationObject)this).getSystem(), this.A, this.s, this.C, this.F);
        double d2 = this.getLimitValue(runTimeStep, this.A, this.z, this.D, n4);
        n2 = this._controller.b.getNumDecisionSteps(runTimeStep);
        if (n2 > 1) {
            RunTimeStep runTimeStep2 = new RunTimeStep(runTimeStep);
            for (n = 1; n < n2; ++n) {
                runTimeStep2.step = runTimeStep.step + n;
                if (runTimeStep2.step > runTimeStep.getTotalNumSteps()) break;
                double d3 = this.getLimitValue(runTimeStep2, this.A, this.z, this.D, n4);
                if (this._limitType == 1 && d2 > d3) {
                    d2 = d3;
                    continue;
                }
                if (this._limitType != -1 || !(d2 < d3)) continue;
                d2 = d3;
            }
        }
        OpValue opValue = new OpValue();
        new OpValue().value = d2;
        opValue.type = this._limitType == 1 ? 2 : 0;
        return opValue;
    }

    private double getLimitValue(RunTimeStep runTimeStep, Vector vector, Vector vector2, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = this.m - (this.b + 1);
        double[] dArray = this._controller.getReleaseArray();
        for (n5 = -this.a; n5 < this.a << 1; ++n5) {
            n4 = runTimeStep.step + n5;
            if (n4 < 0) {
                n4 = 0;
            }
            if (n4 > runTimeStep.getTotalNumSteps()) {
                n4 = runTimeStep.getTotalNumSteps();
            }
            this.x[n5 + this.a] = dArray[n4];
        }
        for (n5 = 0; n5 < this.a << 1; ++n5) {
            n4 = runTimeStep.step + n6 + n5;
            if (n4 > runTimeStep.getTotalNumSteps()) {
                n4 = runTimeStep.getTotalNumSteps();
            }
            this.s.step = n4;
            double d = this._seasonalRecord.interpolate(runTimeStep);
            FlowLimitOpRule flowLimitOpRule = this;
            this.u[n5] = flowLimitOpRule.getFlowSpace(flowLimitOpRule.s, d, runTimeStep, vector, vector2, n, n2);
            if (this.u[n5] < 0.0) {
                this.u[n5] = 0.0;
            }
            if ((n4 = n5 - (this.l - n6)) < 0) continue;
            this.x[n4 + this.a] = this.u[n5];
        }
        for (n3 = 0; n3 < this.a << 1; ++n3) {
            this.v[n3] = 0.0;
            for (n4 = 0; n4 < this.a; ++n4) {
                int n7 = this.a + n3 - n4;
                if (n7 < 0) {
                    n7 = 0;
                }
                int n8 = this.m + n4;
                int n9 = n3;
                this.v[n9] = this.v[n9] + this.x[n7] * this.c[n8];
            }
        }
        for (n3 = 0; n3 < this.a << 1; ++n3) {
            this.w[n3] = this.u[n3] - this.v[n3];
        }
        if (this._limitType == 1) {
            double d = Double.MAX_VALUE;
            for (n5 = 0; n5 < this.a; ++n5) {
                if (!(this.w[n5] < d)) continue;
                d = this.w[n5];
            }
            int n10 = this.a;
            this.x[n10] = this.x[n10] + d;
        } else {
            double d = Double.MIN_VALUE;
            for (n5 = 0; n5 < this.a; ++n5) {
                if (!(this.w[n5] > d)) continue;
                d = this.w[n5];
            }
            int n11 = this.a;
            this.x[n11] = this.x[n11] + d;
        }
        if (this.x[this.a] < 0.0) {
            this.x[this.a] = 0.0;
        }
        return this.x[this.a];
    }

    double getFlowSpace(RunTimeStep runTimeStep, double d, RunTimeStep runTimeStep2, Vector vector, Vector vector2, int n, int n2) {
        int n3;
        RunTimeStep runTimeStep3 = new RunTimeStep(runTimeStep2);
        if (runTimeStep3.step > 0) {
            --runTimeStep3.step;
        }
        if (this.t == null) {
            return 0.0;
        }
        double d2 = d - this.f[runTimeStep.step];
        double cfr_ignored_0 = this.f[runTimeStep.step];
        int n4 = vector.size();
        double d3 = 0.0;
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            if (!this.C[n3]) continue;
            ++n5;
            Object object = (FlowLimitOpRule)vector2.elementAt(n3);
            d2 += ((FlowLimitOpRule)object).e[runTimeStep.step];
            if (object == this) {
                double cfr_ignored_1 = ((FlowLimitOpRule)object).e[runTimeStep.step];
            }
            this.K[n3] = ((FlowLimitOpRule)object).m - ((FlowLimitOpRule)object).b + 1;
            runTimeStep3.step = runTimeStep2.step;
            if (runTimeStep3.step > 0) {
                // empty if block
            }
            this.J[n3] = --runTimeStep3.step;
            object = ((OpRule)object)._controller.getReleaseArray();
            this.I[n3] = (double)object[runTimeStep3.step];
            double cfr_ignored_2 = this.I[n3];
            object = (ReservoirElement)vector.elementAt(n3);
            object = ((ReservoirElement)object).getStorageFunction();
            this.E[n3] = ((Storage)object).getStorage(runTimeStep3);
            d3 += this.E[n3];
            this.H[n3] = ((Storage)object).getNetInflow(runTimeStep2);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (!this.C[n3]) continue;
            this.G[n3] = d3 == 0.0 ? d2 / (double)n5 : d2 / d3 * this.E[n3];
        }
        double d4 = 0.0;
        for (n3 = 0; n3 < n4; ++n3) {
            if (!this.C[n3]) continue;
            d4 += this.H[n3];
        }
        double cfr_ignored_3 = d4 / (double)n5;
        for (n3 = 0; n3 < n4; ++n3) {
            if (!this.C[n3]) continue;
            int n6 = n3;
            this.G[n6] = this.G[n6] + this.H[n3];
        }
        for (int i = 0; i < n4; ++i) {
            if (!this.C[i]) continue;
            double d5 = (this.E[i] - this.F[i]) / (double)runTimeStep.getTimeStepSeconds() * Storage.DSDT_TO_Q;
            int n7 = i;
            this.G[n7] = this.G[n7] + d5;
        }
        double d6 = 0.0;
        double d7 = 0.0;
        for (n3 = 0; n3 < n4; ++n3) {
            if (!this.C[n3]) continue;
            if (this.G[n3] < d7) {
                d7 = this.G[n3];
            }
            d6 += this.G[n3];
        }
        double d8 = (d6 -= (double)n4 * d7) == 0.0 ? 1.0 / (double)n5 : (this.G[n] - d7) / d6;
        return d2 * d8;
    }

    public void setInterpolationType(int n) {
        this._seasonalRecord.setInterpolationType(n);
    }

    public int getInterpolationType() {
        return this._seasonalRecord.getInterpolationType();
    }

    public SeasonalRecord getSeasonalRecord() {
        this._seasonalRecord.setUnitSystem(this.getUnitSystem());
        this._seasonalRecord.setParameterId(Parameter.PARAMID_FLOW);
        return this._seasonalRecord;
    }

    public int getLimitType() {
        return this._limitType;
    }

    public void setLimitType(int n) {
        if (n != -1 && n != 1) {
            return;
        }
        this._limitType = n;
    }

    public int getRssNodeIndex() {
        return this._rssNodeIndex;
    }

    public void setRssNodeIndex(int n) {
        if (n < -1) {
            n = -1;
        }
        this._rssNodeIndex = n;
    }
}

