/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.heclib.util.doubleArrayContainer;
import hec.io.AsciiSerializable;
import hec.model.ModelVariable;
import hec.model.RunTimeStep;
import hec.rss.model.Element;
import hec.rss.model.IndependentVariable;
import hec.rss.model.RssModelVariableConstants;
import hec.rss.model.RssNode;
import hec.rss.model.RssRatingObject;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jdom.Content;
import rma.util.RMAConst;

public class ForebayHeadLoss
extends RssTSLocationObject
implements AsciiSerializable,
RssModelVariableConstants,
AltInputReportInfc,
Serializable,
Cloneable {
    public static final String RATING_NAME = "Head Loss Rating";
    Element _element;
    RssRatingObject _ratingObject;
    private transient RunTimeStep c = null;
    transient doubleArrayContainer a;
    transient doubleArrayContainer b;

    public ForebayHeadLoss() {
    }

    public ForebayHeadLoss(Element element) {
        this._element = element;
        this._ratingObject = this.getRatingObject();
    }

    public void setElement(Element element) {
        this._element = element;
        if (this._ratingObject != null) {
            this._ratingObject.setElement(element);
        }
    }

    @Override
    public synchronized Object clone() {
        ForebayHeadLoss forebayHeadLoss = (ForebayHeadLoss)super.clone();
        if (this._ratingObject != null) {
            forebayHeadLoss._ratingObject = (RssRatingObject)((RssTSLocationObject)this._ratingObject).clone();
            forebayHeadLoss._ratingObject.setElement(forebayHeadLoss._element);
        }
        return forebayHeadLoss;
    }

    public void initialize() {
        for (int i = 0; i < this._tsrecordVector.size(); ++i) {
            TSRecordProxy tSRecordProxy = (TSRecordProxy)this._tsrecordVector.elementAt(i);
            if (tSRecordProxy == null) continue;
            tSRecordProxy.initialize();
        }
        if (this._ratingObject != null) {
            this._ratingObject.initialize();
        }
        this.c = null;
        this.a = this.getTSContainer(this.getOutputBPart(), 143);
        this.b = this.getTSContainer(this.getOutputBPart(), 144);
    }

    public void initForPostProcessing() {
        if (this._ratingObject != null) {
            this._ratingObject.initialize();
        }
        this.c = null;
    }

    public double getHeadLoss(RunTimeStep runTimeStep) {
        double d = 0.0;
        if (this._ratingObject != null && this._ratingObject.usesIndependentVariable() && !RMAConst.isValidValue((double)(d = this._ratingObject.getElevation(runTimeStep, 0.0)))) {
            d = 0.0;
        }
        return d;
    }

    public double getPrevHeadLoss(RunTimeStep runTimeStep) {
        double d = 0.0;
        if (this._ratingObject != null && this._ratingObject.usesIndependentVariable()) {
            if (this.c == null) {
                this.c = new RunTimeStep(runTimeStep);
            }
            this.c.step = runTimeStep.getPrevStep();
            d = this._ratingObject.getElevation(this.c, 0.0);
            if (!RMAConst.isValidValue((double)d)) {
                d = 0.0;
            }
        }
        return d;
    }

    public void getHeadLoss(RunTimeStep runTimeStep, ParamDouble paramDouble) {
        double d = this.getHeadLoss(runTimeStep);
        paramDouble.setValue(d);
        paramDouble.setUnitSystem(this._element.getUnitSystem());
        paramDouble.setParameterId(Parameter.PARAMID_ELEV);
    }

    public void getPrevHeadLoss(RunTimeStep runTimeStep, ParamDouble paramDouble) {
        double d = this.getPrevHeadLoss(runTimeStep);
        paramDouble.setValue(d);
        paramDouble.setUnitSystem(this._element.getUnitSystem());
        paramDouble.setParameterId(Parameter.PARAMID_ELEV);
    }

    public RssRatingObject getRatingObject() {
        if (this._ratingObject == null) {
            this._ratingObject = new RssRatingObject(this._element);
            this._ratingObject.setUsesIndependentVariable(true);
            this._ratingObject.setUsesRatingCurveElev(false);
            IndependentVariable independentVariable = this.getDefaultIndependentVariable();
            this._ratingObject.setIndependentVariable(independentVariable);
            this._ratingObject.setRatingName(RATING_NAME);
        }
        return this._ratingObject;
    }

    public IndependentVariable getDefaultIndependentVariable() {
        IndependentVariable independentVariable = new IndependentVariable(2);
        Element element = this.getElement();
        Element element2 = element.getTopParent();
        RssNode rssNode = element.getDownstreamNode();
        element.getUpstreamNode();
        element = null;
        if (rssNode != null) {
            element = rssNode.getTSRecordProxy(0);
        }
        rssNode = new ModelVariable("Node", "Flow", 0, Parameter.PARAMID_FLOW);
        independentVariable.setModalVariableInfo((TSRecordProxy)element, element2, (ModelVariable)rssNode);
        return independentVariable;
    }

    public Element getElement() {
        return this._element;
    }

    @Override
    public RssSystem getSystem() {
        if (this._element == null) {
            return null;
        }
        return this._element.getSystem();
    }

    public void setRatingObject(RssRatingObject rssRatingObject) {
        this._ratingObject = rssRatingObject;
    }

    public void getReferencedStateVariables(List list) {
        if (this._ratingObject != null) {
            this._ratingObject.getReferencedStateVariables(list);
        }
    }

    protected String getOutputBPart() {
        ArrayList<String> arrayList = this.getElement().getFullNameList();
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        arrayList.add("FOREBAY");
        return this.getElement().getSystem().generateUniquePathPart(arrayList, "-");
    }

    public Vector getActiveTSProxies(Vector vector, int n) {
        if (vector == null) {
            vector = new Vector<TSRecordProxy>();
        }
        boolean bl = false;
        if (n == 1) {
            bl = true;
        }
        int n2 = this._tsrecordVector.size();
        for (int i = 0; i < n2; ++i) {
            TSRecordProxy tSRecordProxy = (TSRecordProxy)this._tsrecordVector.elementAt(i);
            if (tSRecordProxy.isInput() != bl) continue;
            vector.add(tSRecordProxy);
        }
        if (this._ratingObject != null) {
            this._ratingObject.getActiveTSProxies(vector, n);
        }
        if (n == 0) {
            ForebayHeadLoss forebayHeadLoss = this;
            vector.add(forebayHeadLoss.getTSRecordProxy(forebayHeadLoss.getOutputBPart(), 143));
            ForebayHeadLoss forebayHeadLoss2 = this;
            vector.add(forebayHeadLoss2.getTSRecordProxy(forebayHeadLoss2.getOutputBPart(), 144));
        }
        return vector;
    }

    @Override
    public void updateTSProxyList() {
        if (this._element == null) {
            return;
        }
        if (this._element.getFunction() != null && this._element.getFunction().getTSRecordProxy(30) == null) {
            this._element.getFunction().addTSRecordProxy(30);
        }
        if (this._ratingObject != null) {
            ((RssTSLocationObject)this._ratingObject).updateTSProxyList();
        }
        ForebayHeadLoss forebayHeadLoss = this;
        TSRecordProxy tSRecordProxy = forebayHeadLoss.getTSRecordProxy(forebayHeadLoss.getOutputBPart(), 143);
        if (tSRecordProxy == null) {
            ForebayHeadLoss forebayHeadLoss2 = this;
            forebayHeadLoss2.addTSRecordProxy(forebayHeadLoss2.getOutputBPart(), 143);
        }
        ForebayHeadLoss forebayHeadLoss3 = this;
        tSRecordProxy = forebayHeadLoss3.getTSRecordProxy(forebayHeadLoss3.getOutputBPart(), 144);
        if (tSRecordProxy == null) {
            ForebayHeadLoss forebayHeadLoss4 = this;
            forebayHeadLoss4.addTSRecordProxy(forebayHeadLoss4.getOutputBPart(), 144);
        }
    }

    public void setupForSerialization() {
        if (this._ratingObject != null) {
            this._ratingObject.setRatingName(RATING_NAME);
            this._ratingObject.setupForSerialization();
        }
    }

    @Override
    public Object getFieldObject(Field object) {
        try {
            object = ((Field)object).get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        element.setAttribute("Name", this.getDisplayName());
        org.jdom.Element element2 = new org.jdom.Element("Rating_Curve");
        element.addContent((Content)element2);
        this._ratingObject.outputReport(alternativeInputReport, element2);
    }
}

