/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.model.ModelVariable;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.model.TSLocation;
import hec.rss.model.AdjustableParameter;
import hec.rss.model.Element;
import hec.rss.model.HindcastData;
import hec.rss.model.HotstartState;
import hec.rss.model.RssModelVariableConstants;
import hec.rss.model.RssNode;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocation;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.RunTime;
import hec.rss.model.Storage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public abstract class Function
extends RssTSLocationObject
implements RssModelVariableConstants,
RssReturnStatusConstants,
RssTSLocation {
    Element element = null;
    AdjustableParameter adjustableParam = null;

    public Function() {
    }

    public Function(Element element) {
        this.element = element;
    }

    public void cleanupFromDeSerialization() {
    }

    protected void initTSVals(int n) {
    }

    public static double getFlowVolume(RunTimeStep runTimeStep, double d, double d2) {
        if (runTimeStep == null) {
            return 0.0;
        }
        double d3 = !runTimeStep.isPerAvgTimeStep() ? 0.5 * (d2 + d) / Storage.DSDT_TO_Q * (double)runTimeStep.getTimeStepSeconds() : d2 / Storage.DSDT_TO_Q * (double)runTimeStep.getTimeStepSeconds();
        return d3;
    }

    public static double getFlowVolume(RunTimeStep runTimeStep, double[] dArray) {
        if (runTimeStep == null || dArray == null) {
            return 0.0;
        }
        int n = runTimeStep.step;
        if (n < 0) {
            n = 0;
        } else if (n >= dArray.length) {
            n = dArray.length - 1;
        }
        int n2 = n - 1;
        if (n2 < 0) {
            n2 = 0;
        }
        return Function.getFlowVolume(runTimeStep, dArray[n2], dArray[n]);
    }

    @Override
    public RssSystem getSystem() {
        if (this.element == null) {
            return null;
        }
        return this.element.getSystem();
    }

    public void printErrorMessage(String string) {
        this.printErrorMessage(null, string);
    }

    public void printErrorMessage(String string, String string2) {
        RssSystem rssSystem = this.element.getSystem();
        Object object = this.getClass().getName();
        if (string != null) {
            object = (String)object + "." + string;
        }
        rssSystem.printErrorMessage((String)object + ": " + string2);
        rssSystem.printMessage(this.element.getClass().getName() + ": " + this.element.getFullName());
    }

    public void applyHindcastData(HindcastData hindcastData) {
    }

    public String getDisplayName() {
        if (this.element == null) {
            return this.getName();
        }
        return this.element.getDisplayName();
    }

    protected String getOutputBPart() {
        List list = this.getFullNameList();
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            n += list.get(i).toString().length();
        }
        if (n <= 64) {
            return this.getFullName();
        }
        RssSystem rssSystem = this.getElement().getSystem();
        if (rssSystem != null) {
            return rssSystem.generateUniquePathPart(list, "-");
        }
        return this.getFullName().substring(0, 64);
    }

    List getFullNameList() {
        ArrayList<String> arrayList = null;
        if (this.element != null) {
            arrayList = this.element.getFullNameList();
        }
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        arrayList.add(this.getName());
        return arrayList;
    }

    public String getFullName() {
        if (this.element == null) {
            return this.getName();
        }
        return this.element.getFullName() + "-" + this.getName();
    }

    public void setupForSerialization() {
    }

    public void getHindcastDataList(Vector vector) {
    }

    public int getUnitSystem() {
        if (this.element == null) {
            throw new IllegalAccessError("ERROR <Function.getUnitSystem()> : Null parent Element.  Can't get Unit System");
        }
        return this.element.getUnitSystem();
    }

    public void resetParent(Element object) {
        this.setElement((Element)object);
        if (this.adjustableParam != null) {
            this.adjustableParam.setFunction(this);
        }
        object = this._tsrecordVector.elements();
        while (object.hasMoreElements()) {
            TSRecordProxy tSRecordProxy = (TSRecordProxy)object.nextElement();
            tSRecordProxy.setParent((TSLocation)this);
        }
    }

    public void copyInto(Function function) {
        if (function == null) {
            return;
        }
        super.copyInto(function);
        if (function.adjustableParam != null) {
            this.adjustableParam = (AdjustableParameter)function.adjustableParam.clone();
            this.adjustableParam.setFunction(this);
        }
    }

    @Override
    public synchronized Object clone() {
        Function function = (Function)super.clone();
        if (this.adjustableParam != null) {
            function.adjustableParam = (AdjustableParameter)this.adjustableParam.clone();
            function.adjustableParam.setFunction(function);
        }
        return function;
    }

    Vector getComputedNodes() {
        Vector<RssNode> vector = new Vector<RssNode>();
        for (int i = 0; i < this.element.getNodeCount(); ++i) {
            RssNode rssNode = this.element.getNode(i);
            if (rssNode == null || this.element.getNodeDir(i) != 0) continue;
            vector.addElement(rssNode);
        }
        return vector;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public Element getElement() {
        return this.element;
    }

    public boolean initialize() {
        if (this.adjustableParam != null) {
            this.adjustableParam.initialize();
        }
        for (int i = 0; i < this._tsrecordVector.size(); ++i) {
            TSRecordProxy tSRecordProxy = (TSRecordProxy)this._tsrecordVector.elementAt(i);
            if (tSRecordProxy == null) continue;
            tSRecordProxy.initialize();
        }
        return true;
    }

    public boolean initForPostProcessing() {
        if (this.adjustableParam != null) {
            this.adjustableParam.initialize();
        }
        return true;
    }

    public boolean initHindcastLoop(RunTimeWindow runTimeWindow) {
        return true;
    }

    public boolean initForecastLoop(RunTimeWindow runTimeWindow) {
        return true;
    }

    public void saveFunctionState(int n) {
    }

    public void restoreFunctionState(int n) {
    }

    public boolean hasDefaultParameters() {
        return false;
    }

    public AdjustableParameter findAdjParam(String string) {
        if (this.adjustableParam == null || string.compareTo(this.adjustableParam.getName()) != 0) {
            return null;
        }
        return this.adjustableParam;
    }

    public boolean getForecastEquation(RunTime runTime) {
        this.element.getSystem().printErrorMessage("Function.getForecastEquation: not implemented in Class " + this.getClass().getName());
        return false;
    }

    public boolean getHindcastEquation(RunTime runTime) {
        this.element.getSystem().printErrorMessage("Function.getHindcastEquation: not implemented in Class " + this.getClass().getName());
        return false;
    }

    public int computeHindcastStep(RunTimeStep runTimeStep) {
        this.element.getSystem().printErrorMessage("Function.computeHindcastStep: not implemented in Class " + this.getClass().getName());
        return 1;
    }

    public int computeForecastStep(RunTimeStep runTimeStep) {
        this.element.getSystem().printErrorMessage("Function.computeForecastStep: not implemented in Class " + this.getClass().getName());
        return 1;
    }

    public int computeForecastStep(RunTimeStep runTimeStep, double[] dArray, double[] dArray2, int n) {
        return this.computeForecastStep(runTimeStep);
    }

    public double computeSubStepFlow(RunTimeStep runTimeStep, double d, double d2) {
        return 0.0;
    }

    public boolean writeData(BufferedWriter bufferedWriter) {
        return true;
    }

    public boolean readData(BufferedReader bufferedReader) {
        return true;
    }

    public AdjustableParameter getAdjustableParameter() {
        return this.adjustableParam;
    }

    public String getKeyStringForObject(Object object) {
        return this.element.getKeyStringForObject(object);
    }

    public Object getObjectForKeyString(String string) {
        return this.element.getObjectForKeyString(string);
    }

    public Vector getActiveTSProxies(Vector vector, int n) {
        if (vector == null) {
            vector = new Vector<TSRecordProxy>();
        }
        boolean bl = false;
        if (n == 1) {
            bl = true;
        }
        int n2 = this._tsrecordVector.size();
        for (n = 0; n < n2; ++n) {
            TSRecordProxy tSRecordProxy = (TSRecordProxy)this._tsrecordVector.elementAt(n);
            if (tSRecordProxy.isInput() != bl) continue;
            vector.add(tSRecordProxy);
        }
        return vector;
    }

    @Override
    public void updateTSProxyList() {
        if (this.element == null) {
            return;
        }
        List list = this.element.getDownstreamNodes(null);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            RssNode rssNode = (RssNode)list.get(i);
            if (rssNode.getTSRecordProxy(0) != null) continue;
            rssNode.addTSRecordProxy(0);
        }
    }

    public void updateWQTSProxyList(List<ModelVariable> list) {
        if (this.element == null) {
            return;
        }
        List list2 = this.element.getDownstreamNodes(null);
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            RssNode rssNode = (RssNode)list2.get(i);
            for (ModelVariable modelVariable : list) {
                int n2 = modelVariable.getType();
                if (rssNode.getTSRecordProxy(n2) != null) continue;
                rssNode.addTSRecordProxy(n2);
            }
        }
    }

    public Vector getComputedTSRecordProxies() {
        return ((RssTSLocationObject)this).getComputedTSRecordProxies(null);
    }

    @Override
    public Vector getComputedTSRecordProxies(Vector vector) {
        if (vector == null) {
            vector = new Vector<TSRecordProxy>();
        }
        List list = this.element != null ? this.element.getDownstreamNodes(null) : new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            RssNode rssNode = (RssNode)list.get(i);
            if (rssNode == null || rssNode.getTSRecordProxy(0) == null) continue;
            vector.addElement(rssNode.getTSRecordProxy(0));
        }
        return vector;
    }

    public boolean isNodeComputed(int n, RssNode rssNode, Integer n2) {
        return n2 == 0;
    }

    public void saveHotstartState(HotstartState hotstartState, int n) {
    }

    public boolean restoreHotstartState(HotstartState hotstartState) {
        return true;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

