/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.heclib.util.doubleArrayContainer;
import hec.model.RunTimeStep;
import hec.rss.model.Element;
import hec.rss.model.OpRule;
import hec.rss.model.OpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.StorageZone;

public class GCOpRule
extends OpRule {
    StorageZone _gczone;

    public GCOpRule() {
    }

    public GCOpRule(String string) {
        super(string);
    }

    @Override
    public void evaluateLimits(RunTimeStep runTimeStep, int n) {
        if (this._gczone == null) {
            Element element = this._controller.getReleaseElement().getTopParent();
            if (!(element instanceof ReservoirElement)) {
                return;
            }
            OpSet opSet = ((ReservoirElement)element).getReservoirOp(false).getActiveOpSet();
            if (opSet == null) {
                return;
            }
            this._gczone = opSet.getGuideCurveZone();
            if (this._gczone == null) {
                this._gczone = opSet.getInactiveZone();
                if (this._gczone == null) {
                    return;
                }
            }
        }
        double d = this._controller.getFlowObjectiveToZoneElev(this._gczone, this._controller.c, runTimeStep, null, null, Double.NEGATIVE_INFINITY);
        if (this.h == null) {
            this.h = new doubleArrayContainer(new double[runTimeStep.getTotalNumSteps() + 1]);
        }
        this.h.array[runTimeStep.step] = d;
    }

    @Override
    public int getRuleLimitType() {
        return 1;
    }
}

