/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.SimulationPeriod;
import hec.heclib.dss.DSSPathname;
import hec.io.DSSIdentifier;
import hec.io.DataContainer;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.io.TimeSeriesContainer;
import hec.lang.UserId;
import hec.lang.annotation.Scriptable;
import hec.rss.model.RssSystem;
import hec.rss.model.globalvariable.AltExternalGlobalData;
import hec.rss.model.globalvariable.AltScalarGlobalData;
import hec.rss.model.globalvariable.AltStringGlobalData;
import hec.rss.model.globalvariable.AltTableGlobalData;
import hec.rss.model.globalvariable.AltTimeSeriesGlobalData;
import hec.rss.model.globalvariable.BaseAltGlobalData;
import hec.rss.model.globalvariable.GlobalVariableData;
import hec.rss.model.globalvariable.GlobalVariableType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import rma.util.RMAIO;

public class GVDataSet
extends Manager {
    private String _altName;
    private List<GlobalVariableData> _gvRecords = new ArrayList<GlobalVariableData>();
    private FluentLogger _logger = FluentLogger.forEnclosingClass();

    public void init() {
    }

    public void setAltName(String string) {
        this._altName = string;
    }

    public String getAltName() {
        return this._altName;
    }

    @Scriptable
    public List<GlobalVariableData> getGVRecords() {
        return this._gvRecords;
    }

    @Scriptable
    public List<GlobalVariableData> getGVRecords(GlobalVariableType globalVariableType) {
        return this._gvRecords.stream().filter(globalVariableData -> globalVariableData.getType() == globalVariableType).collect(Collectors.toList());
    }

    @Scriptable
    public GlobalVariableData getGlobalVariableData(int n, GlobalVariableType object) {
        object = this.getGVRecords((GlobalVariableType)((Object)object));
        object = object.iterator();
        while (object.hasNext()) {
            GlobalVariableData globalVariableData = (GlobalVariableData)object.next();
            if (globalVariableData.getIndex() != n) continue;
            globalVariableData.setGVDataSet(this);
            return globalVariableData;
        }
        return null;
    }

    @Scriptable
    public GlobalVariableData getGlobalVariableData(String string, GlobalVariableType object) {
        if (string == null) {
            return null;
        }
        object = this.getGVRecords((GlobalVariableType)((Object)object));
        object = object.iterator();
        while (object.hasNext()) {
            GlobalVariableData globalVariableData = (GlobalVariableData)object.next();
            if (!globalVariableData.getName().equals(string)) continue;
            globalVariableData.setGVDataSet(this);
            return globalVariableData;
        }
        return null;
    }

    public String getDSSFilename() {
        if (this.getProxyList().getContainer() instanceof SimulationPeriod) {
            return ((SimulationPeriod)this.getProxyList().getContainer()).getOutputDSSFilePath();
        }
        GVDataSet gVDataSet = this;
        return gVDataSet.getDSSFilename(gVDataSet.getIdentifier());
    }

    public String getDSSFilename(Identifier object) {
        if (object == null) {
            this.getIdentifier();
        }
        object = this.getIdentifier().getPath();
        String string = "";
        if (object != null) {
            string = RMAIO.getDirectoryFromPath((String)object);
            object = RMAIO.getFileNameNoExtension((String)object);
            object = ((String)object).concat("_igv");
            string = RMAIO.concatPath((String)string, (String)((String)object).concat(".dss"));
        }
        return string;
    }

    /*
     * Loose catch block
     */
    public boolean readFile(Identifier identifier) {
        block17: {
            Object object;
            if ((identifier = identifier.getFile()) == null) {
                return false;
            }
            this._gvRecords.clear();
            System.out.println("opening " + identifier.getPath());
            BufferedReader bufferedReader = identifier.getBufferedReader();
            while ((object = bufferedReader.readLine()) != null) {
                if (((String)object).length() == 0) continue;
                String string = RMAIO.getType((String)object, (String)"=");
                object = RMAIO.getParam((String)object, (String)"=");
                if ("GVDataSet Name".equalsIgnoreCase(string)) {
                    this.setName((String)object);
                    continue;
                }
                if ("Description".equalsIgnoreCase(string)) {
                    object = ((String)object).replace('|', '\n');
                    this.setDescription((String)object);
                    continue;
                }
                if ("ModifiedTime".equalsIgnoreCase(string)) {
                    try {
                        this.setLastModifiedTime(Long.parseLong((String)object));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (!"GVRecord".equalsIgnoreCase(string)) continue;
                object = GlobalVariableType.valueOf((String)object);
                if ((object = this.createGlobalVariableData((GlobalVariableType)((Object)object))) == null) continue;
                object.setGVDataSet(this);
                if (!object.readData(bufferedReader)) continue;
                this._gvRecords.add((GlobalVariableData)object);
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            break block17;
            catch (IOException iOException) {
                try {
                    this.printErrorMessage("Failed to open file " + identifier.getPath());
                }
                catch (Throwable throwable) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException3) {}
                return false;
            }
        }
        this.printLogMessage("GVDataSet Dimensions:\n" + 0 + " GVRecords");
        this.setModified(false);
        return true;
    }

    private GlobalVariableData createGlobalVariableData(GlobalVariableType globalVariableType) {
        GlobalVariableData globalVariableData = null;
        switch (globalVariableType) {
            case SCALAR: {
                globalVariableData = new AltScalarGlobalData();
                break;
            }
            case STRING: {
                globalVariableData = new AltStringGlobalData();
                break;
            }
            case TABLE: {
                globalVariableData = new AltTableGlobalData();
                break;
            }
            case TIME_SERIES: {
                globalVariableData = new AltTimeSeriesGlobalData();
                break;
            }
            case EXTERNAL: {
                globalVariableData = new AltExternalGlobalData();
            }
        }
        if (globalVariableData != null) {
            globalVariableData.setGVDataSet(this);
        }
        return globalVariableData;
    }

    public boolean writeData() {
        boolean bl = true;
        for (int i = 0; i < this._gvRecords.size(); ++i) {
            GlobalVariableData globalVariableData = this._gvRecords.get(i);
            if (globalVariableData == null || globalVariableData.isMarkedForDeletion() || globalVariableData.writeDssData(null)) continue;
            bl = false;
        }
        return bl;
    }

    public boolean writeFile(Identifier object) {
        int n;
        BufferedWriter bufferedWriter;
        this.setReloadOk(false);
        HecFile hecFile = object.getFile();
        if (hecFile == null) {
            return false;
        }
        boolean bl = false;
        object = this.getDSSFilename((Identifier)object);
        try {
            if (object != null && this.getFileManager().fileExists((String)object) && !(this.getProxyList().getContainer() instanceof SimulationPeriod)) {
                this.getDSSFileManager().close((String)object);
                bufferedWriter = new Identifier((String)object);
                n = ((String)object).lastIndexOf(46);
                object = ((String)object).substring(0, n);
                object = ((String)object).concat(".bak").concat(".dss");
                object = new Identifier((String)object);
                if (this.getFileManager().renameFile(UserId.getUserId(), (Identifier)bufferedWriter, (Identifier)object) == null) {
                    ((FluentLogger.Api)this._logger.atInfo()).log("failed to rename file " + String.valueOf(bufferedWriter) + " to " + String.valueOf(object));
                }
            }
        }
        catch (RemoteException remoteException) {}
        try {
            bufferedWriter = hecFile.getBufferedWriter();
            if (bufferedWriter != null) {
                this.writeLastModTime(bufferedWriter);
                bufferedWriter.write("GVDataSet Name=" + this.getName());
                bufferedWriter.newLine();
                bufferedWriter.write("Description=" + this.getDescription());
                bufferedWriter.newLine();
                bufferedWriter.newLine();
                for (n = 0; n < this._gvRecords.size(); ++n) {
                    object = this._gvRecords.get(n);
                    if (object == null || object.isMarkedForDeletion()) continue;
                    bufferedWriter.write("GVRecord=" + object.getType().name());
                    bufferedWriter.newLine();
                    object.writeData(bufferedWriter, object.getDSSFilename());
                    bufferedWriter.newLine();
                }
                bufferedWriter.newLine();
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            bl = true;
        }
        catch (IOException iOException) {
            ((FluentLogger.Api)this._logger.atInfo()).log("Error writingg " + hecFile.getPath() + " Error:" + String.valueOf(iOException));
        }
        finally {
            hecFile.save();
            this.setReloadOk(true);
        }
        if (bl) {
            this.setModified(false);
        }
        return bl;
    }

    public void appendGVRecords(GVDataSet object) {
        if (object != null) {
            for (GlobalVariableData globalVariableData : ((GVDataSet)((Object)object)).getGVRecords()) {
                GlobalVariableData globalVariableData2 = globalVariableData.clone();
                if (globalVariableData instanceof BaseAltGlobalData) {
                    globalVariableData = new DSSPathname(globalVariableData2.getDSSPathname());
                    if (this.getName() != null) {
                        globalVariableData.setFPart(this.getName().replace(":", ""));
                    }
                    globalVariableData2.setDSSPathname(globalVariableData.getPathname());
                }
                this._gvRecords.add(globalVariableData2);
            }
        }
    }

    public GlobalVariableData createGVRecord(GlobalVariableType globalVariableType, int n) {
        if (globalVariableType == null || n < 0) {
            return null;
        }
        GlobalVariableData globalVariableData = this.getGlobalVariableData(n, globalVariableType);
        if (globalVariableData != null) {
            return globalVariableData;
        }
        switch (globalVariableType) {
            case SCALAR: {
                globalVariableData = new AltScalarGlobalData();
                break;
            }
            case STRING: {
                globalVariableData = new AltStringGlobalData();
                break;
            }
            case TABLE: {
                globalVariableData = new AltTableGlobalData();
                break;
            }
            case TIME_SERIES: {
                globalVariableData = new AltTimeSeriesGlobalData();
                break;
            }
            case EXTERNAL: {
                globalVariableData = new AltExternalGlobalData();
                break;
            }
            default: {
                return null;
            }
        }
        globalVariableData.setIndex(n);
        globalVariableData.setGVDataSet(this);
        this._gvRecords.add(globalVariableData);
        return globalVariableData;
    }

    public void loadGlobalVariableValues() {
        for (int i = 0; i < this._gvRecords.size(); ++i) {
            GlobalVariableData globalVariableData = this._gvRecords.get(i);
            globalVariableData.loadData();
        }
    }

    public boolean refreshData(Manager manager) {
        if (!manager.getClass().getName().equals(((Object)((Object)this)).getClass().getName())) {
            ((FluentLogger.Api)this._logger.atInfo()).log("can't refresh from type " + manager.getClass().getName() + " when I'm a " + ((Object)((Object)this)).getClass().getName());
            return false;
        }
        ArrayList<GlobalVariableData> arrayList = new ArrayList<GlobalVariableData>();
        Object object = (GVDataSet)manager;
        DSSPathname dSSPathname = new DSSPathname();
        object = ((GVDataSet)((Object)object))._gvRecords;
        DSSIdentifier dSSIdentifier = new DSSIdentifier();
        for (int i = 0; i < object.size(); ++i) {
            GlobalVariableData globalVariableData;
            block11: {
                globalVariableData = (GlobalVariableData)object.get(i);
                globalVariableData.loadData();
                globalVariableData = globalVariableData.clone();
                dSSPathname.setPathname(globalVariableData.getDSSPathname());
                if (globalVariableData instanceof AltTimeSeriesGlobalData) {
                    String string = globalVariableData.getDSSPathname();
                    String string2 = globalVariableData.getDSSFilename();
                    if (string != null && !string.isEmpty() && string2 != null && !string2.isEmpty()) {
                        dSSIdentifier.setFileName(string2);
                        dSSIdentifier.setDSSPath(string);
                        try {
                            string = this.getDSSFileManager().readTS(dSSIdentifier, false);
                            if (string == null) break block11;
                            ((TimeSeriesContainer)string).fullName = dSSPathname.getPathname();
                            ((TimeSeriesContainer)string).fileName = string2;
                            ((TimeSeriesContainer)string).fileName = RMAIO.isFullPath((String)(string2 = manager.getRelativePath(string2))) ? string2 : this.makeAbsolutePath(string2);
                            ((FluentLogger.Api)this._logger.atInfo()).log("Saving TS GV '" + String.valueOf(globalVariableData) + "' time series to " + ((TimeSeriesContainer)string).fileName + ":" + ((TimeSeriesContainer)string).fullName);
                            globalVariableData.setDSSFilename(((TimeSeriesContainer)string).fileName);
                            int n = this.getDSSFileManager().write((DataContainer)string);
                            if (n != 0) {
                                ((FluentLogger.Api)this._logger.atInfo()).log("Error writing " + String.valueOf(dSSIdentifier) + " rv=" + n);
                            }
                        }
                        catch (FileNotFoundException | RemoteException iOException) {
                            ((FluentLogger.Api)this._logger.atInfo()).log("error copying TS DSS record " + String.valueOf(dSSIdentifier) + " Error:" + String.valueOf(iOException));
                        }
                    } else {
                        ((FluentLogger.Api)this._logger.atInfo()).log("no dss file or path set for GlobalVariable " + String.valueOf(globalVariableData));
                    }
                } else {
                    if (!dSSPathname.getPathname().replace("/", "").isEmpty() && (dSSPathname.getFPart() == null || dSSPathname.getFPart().isEmpty())) {
                        dSSPathname.setFPart(this.getName());
                    }
                    globalVariableData.setDSSPathname(dSSPathname.getPathname());
                }
            }
            if (!(globalVariableData.getType() == GlobalVariableType.TIME_SERIES || globalVariableData.getDSSFilename().isEmpty() || globalVariableData instanceof AltTableGlobalData && ((AltTableGlobalData)globalVariableData).isDSS())) {
                globalVariableData.setDSSFilename(this.getDSSFilename());
            }
            globalVariableData.setGVDataSet(this);
            arrayList.add(globalVariableData);
        }
        this._gvRecords.clear();
        this._gvRecords.addAll(arrayList);
        GVDataSet gVDataSet = this;
        gVDataSet.writeFile(gVDataSet.getIdentifier());
        return true;
    }

    public Manager saveManagerAs(String string, String string2, ManagerProxyListContainer managerProxyListContainer, RssSystem rssSystem) {
        GlobalVariableData globalVariableData;
        if (managerProxyListContainer == null) {
            managerProxyListContainer = this._proxyList.getContainer();
        }
        Object object = this._proxyList.getModel();
        if ((string = this.getSaveAsId(string, string2, (object = (GVDataSet)(managerProxyListContainer = managerProxyListContainer.getManagerProxyList((String)object)).newManager(((Object)((Object)this)).getClass().getName())).getIndex())) == null) {
            return null;
        }
        object.getIdentifier().copy((Identifier)string);
        managerProxyListContainer.saveManager(UserId.getUserId(), (Manager)object);
        if (string2 != null) {
            object.getIdentifier().setName(string2 + ":" + this.getName());
        } else {
            object.getIdentifier().setName(this.getName());
        }
        int n = object.getIndex();
        ((GVDataSet)((Object)object)).readFile(this.getIdentifier());
        List<GlobalVariableData> list = ((GVDataSet)((Object)object)).getGVRecords();
        String string3 = this.getDSSFilename();
        Iterator<GlobalVariableData> iterator = list.iterator();
        while (iterator.hasNext()) {
            globalVariableData = iterator.next();
            RssSystem rssSystem2 = rssSystem;
            Object object2 = globalVariableData;
            if (globalVariableData != null && rssSystem2.getGlobalVariable((String)(object2 = object2.getName())) != null) {
                globalVariableData.readDssData(string3, globalVariableData.getDSSPathname());
                continue;
            }
            iterator.remove();
        }
        for (int i = 0; i < list.size(); ++i) {
            globalVariableData = list.get(i);
            globalVariableData.readDssData(string3, globalVariableData.getDSSPathname());
        }
        if (string2 != null) {
            object.setName(string2 + ":" + this.getName());
        } else {
            object.setName(this.getName());
        }
        object.setDescription(this.getDescription());
        object.setIndex(n);
        object.setModified(true);
        managerProxyListContainer.saveManager(UserId.getUserId(), (Manager)object);
        managerProxyListContainer.unloadManager(object.getIdentifier());
        if (object.isModified()) {
            Object object3 = object;
            ((GVDataSet)((Object)object3)).writeFile(object3.getIdentifier());
        }
        return object;
    }
}

