/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.heclib.util.doubleArrayContainer;
import hec.model.RunTimeWindow;
import hec.rss.client.WaterControlPortRowItem;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.Element;
import hec.rss.model.ReservoirElement;
import hec.rss.model.WaterControlDevice;
import hec.rss.model.WaterControlDeviceType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Vector;

public class GatedIntakeControlDevice
extends WaterControlDevice {
    public static final int DEFAULT_NUM_PORT_LEVELS = 4;
    private List<WaterControlPortRowItem> _portRows;
    String _name = "";
    private boolean _usePoolElevation;
    private double _bedElevation;
    private int _numberOfPortLevels = 4;
    private int[] _portNumberArray;
    private double[] _invertElevationArray;
    private transient doubleArrayContainer[] b;
    private WaterControlDeviceType _type = WaterControlDeviceType.GATED_INTAKE;

    public GatedIntakeControlDevice() {
        this._portNumberArray = new int[this._numberOfPortLevels];
        this._portRows = new ArrayList<WaterControlPortRowItem>();
        int n = 0;
        while (n < this._numberOfPortLevels) {
            int n2 = n++;
            this._portNumberArray[n2] = n2 + 1;
            this._portRows.add(new WaterControlPortRowItem());
        }
    }

    public void setType(WaterControlDeviceType waterControlDeviceType) {
        this._type = waterControlDeviceType;
    }

    @Override
    public WaterControlDeviceType getType() {
        return this._type;
    }

    public void setUsePoolElevation(boolean bl) {
        this._usePoolElevation = bl;
    }

    public boolean getUsePoolElevation() {
        return this._usePoolElevation;
    }

    public void setBedElevation(double d) {
        this._bedElevation = d;
    }

    public double getBedElevation() {
        return this._bedElevation;
    }

    public List<WaterControlPortRowItem> getPortRows() {
        return this._portRows;
    }

    public void setPortRows(List<WaterControlPortRowItem> list) {
        this._portRows = list;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public void setNumberOfPortLevels(int n) {
        this._numberOfPortLevels = n;
    }

    public int getNumberOfPortLevels() {
        return this._numberOfPortLevels;
    }

    public void setFlows(int n, double[] dArray) {
        for (int i = 0; i < this._numberOfPortLevels; ++i) {
            this.b[i].set(n, dArray[i]);
        }
    }

    public double[] getPortCenterlines() {
        double[] dArray = new double[this._numberOfPortLevels];
        for (int i = 0; i < this._numberOfPortLevels; ++i) {
            double d = this._portRows.get(i).getInvertElevation();
            double d2 = this._portRows.get(i).getGeometry().getHeight();
            dArray[i] = d + d2 / 2.0;
        }
        return dArray;
    }

    @Override
    public void updateTSProxyList() {
        for (int i = 0; i < this._numberOfPortLevels; ++i) {
            String string = this.getDSSBpart(i + 1);
            TSRecordProxy tSRecordProxy = this.getTSRecordProxy(string, 70);
            if (tSRecordProxy != null) continue;
            this.addTSRecordProxy(string, 70);
        }
    }

    public String getDSSBpart(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        Vector<ReservoirElement> vector = this.a.getElementVectorByClass(ReservoirElement.class);
        int n2 = vector.size();
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            ReservoirElement reservoirElement = (ReservoirElement)vector.get(i);
            Object object = new ArrayList(reservoirElement.getElementsByClass(AdjustableFlow.class, null));
            object = object.iterator();
            while (object.hasNext()) {
                WaterControlDevice waterControlDevice;
                Element element = (Element)object.next();
                if (!element.hasWaterControlDevice() || (waterControlDevice = element.getWaterControlDevice()).getIndex() != this.getIndex()) continue;
                stringBuilder.append(reservoirElement.getName() + "-");
                stringBuilder.append(element.getName() + "-");
                bl = true;
                break;
            }
            if (bl) break;
        }
        stringBuilder.append(this._name + "-");
        stringBuilder.append("L");
        stringBuilder.append(n);
        return stringBuilder.toString();
    }

    @Override
    public Vector getActiveTSProxies(Vector vector, int n) {
        if (vector == null) {
            vector = new Vector<TSRecordProxy>();
        }
        if (n != 1 && n == 0) {
            for (n = 0; n < this._numberOfPortLevels; ++n) {
                GatedIntakeControlDevice gatedIntakeControlDevice = this;
                vector.add(gatedIntakeControlDevice.getTSRecordProxy(gatedIntakeControlDevice.getDSSBpart(n + 1), 70));
            }
        }
        return vector;
    }

    @Override
    public GatedIntakeControlDevice clone() {
        GatedIntakeControlDevice gatedIntakeControlDevice = (GatedIntakeControlDevice)super.clone();
        ((GatedIntakeControlDevice)super.clone())._invertElevationArray = this._invertElevationArray != null ? Arrays.copyOf(this._invertElevationArray, gatedIntakeControlDevice.getNumberOfPortLevels()) : null;
        gatedIntakeControlDevice._portNumberArray = this._portNumberArray != null ? Arrays.copyOf(this._portNumberArray, gatedIntakeControlDevice.getNumberOfPortLevels()) : null;
        gatedIntakeControlDevice._portRows = new ArrayList<WaterControlPortRowItem>();
        for (int i = 0; i < this._numberOfPortLevels; ++i) {
            gatedIntakeControlDevice._portRows.add((WaterControlPortRowItem)this._portRows.get(i).clone());
        }
        return gatedIntakeControlDevice;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void initialize(RunTimeWindow runTimeWindow) {
        this.b = new doubleArrayContainer[this._numberOfPortLevels];
        for (int i = 0; i < this._numberOfPortLevels; ++i) {
            String string = this.getDSSBpart(i + 1);
            string = this.getTSRecordProxy(string, 70);
            string.initialize(runTimeWindow);
            this.b[i] = string.getTSContainer();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (GatedIntakeControlDevice)object;
        return this._usePoolElevation == ((GatedIntakeControlDevice)object)._usePoolElevation && Double.compare(((GatedIntakeControlDevice)object)._bedElevation, this._bedElevation) == 0 && this._numberOfPortLevels == ((GatedIntakeControlDevice)object)._numberOfPortLevels && this._portRows.equals(((GatedIntakeControlDevice)object)._portRows) && this._name.equals(((GatedIntakeControlDevice)object)._name) && Arrays.equals(this._portNumberArray, ((GatedIntakeControlDevice)object)._portNumberArray) && Arrays.equals(this._invertElevationArray, ((GatedIntakeControlDevice)object)._invertElevationArray);
    }

    public int hashCode() {
        int n = Objects.hash(this._portRows, this._name, this._usePoolElevation, this._bedElevation, this._numberOfPortLevels);
        n = n * 31 + Arrays.hashCode(this._portNumberArray);
        n = n * 31 + Arrays.hashCode(this._invertElevationArray);
        return n;
    }
}

