/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.heclib.util.HecTime;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.model.SeasonalRecord;
import hec.model.TSRecord;
import hec.rss.model.PowerGenerationOptions;
import hec.rss.model.PowerGenerationPatternContainer;
import hec.rss.model.RssSystem;
import hec.rss.model.RunTimePeriod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import rma.util.RMAConst;

public class GenerationRequirement
implements PowerGenerationOptions {
    private static int[] a = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private int b;
    private int c;
    private double[] d;
    private int e;
    private int f;
    private int g;
    private int h;
    private SeasonalRecord i;
    private double j;
    private transient int k = -1;
    private transient TSRecord l = null;
    private transient int m;
    private transient RssSystem n;

    public GenerationRequirement(int n, int n2, double[] dArray, int n3, int n4, int n5, int n6, SeasonalRecord seasonalRecord, double d, RssSystem rssSystem) {
        this.b = n;
        this.c = n2;
        this.d = dArray;
        this.e = n3;
        this.f = n5;
        this.h = n4;
        this.g = n6;
        this.i = seasonalRecord;
        this.j = d;
        this.n = rssSystem;
    }

    @Override
    public void setRequirementVariation(int n) {
        this.b = n;
    }

    @Override
    public int getRequirementVariation() {
        return this.b;
    }

    @Override
    public void setPowerReqSpecification(int n) {
        this.c = n;
    }

    @Override
    public int getPowerReqSpecification() {
        return this.c;
    }

    @Override
    public void setStartingDay(int n) {
        this.h = n;
    }

    @Override
    public int getStartingDay() {
        return this.h;
    }

    @Override
    public void setDayBelongsToTerm(int n) {
        this.g = n;
    }

    @Override
    public int getDayBelongsToTerm() {
        return this.g;
    }

    @Override
    public void setStartDayOfPeriod(int n) {
        this.f = n;
    }

    @Override
    public int getStartDayOfPeriod() {
        return this.f;
    }

    @Override
    public void setGenerationPeriod(int n) {
        this.e = n;
    }

    @Override
    public int getGenerationPeriod() {
        return this.e;
    }

    public void a(TSRecord tSRecord) {
        this.l = tSRecord;
    }

    public void a(RunTimeWindow runTimeWindow, PowerGenerationPatternContainer object, double[] dArray, double[] dArray2) {
        if (runTimeWindow == null || object == null) {
            return;
        }
        int n = runTimeWindow.getNumSteps();
        if (dArray == null || dArray.length < n + 1) {
            return;
        }
        if (this.c == 11) {
            Object object2;
            int n2;
            var9_12 = dArray2;
            var8_13 = dArray;
            var7_14 = object;
            var6_15 = runTimeWindow;
            object = this;
            int n3 = var6_15.getTimeStepSeconds();
            var11_25 = 86400 / n3;
            var12_26 = var6_15.getNumSteps();
            HecTime hecTime = var6_15.getLookbackTime();
            var14_42 = var6_15.getRunTimeStepAtTime(hecTime);
            int n4 = hecTime.secondsSinceMidnight();
            if (n4 == 0) {
                n4 = 86400;
            }
            if ((n2 = n4 / n3 - 1) != 0) {
                int n5;
                var27_60 = ((GenerationRequirement)object).f(var14_42);
                var14_42.step -= n2;
                HecTime hecTime2 = new HecTime(var14_42.getHecTime());
                HecTime hecTime3 = new HecTime(hecTime2);
                var14_42.step += var11_25 - 1;
                HecTime hecTime4 = new HecTime(var14_42.getHecTime());
                RunTimeWindow runTimeWindow2 = new RunTimeWindow(hecTime3, hecTime4, hecTime2);
                runTimeWindow2.setTimeStep(var6_15.getTimeStep(), var6_15.getTimeIncrement());
                object2 = new double[var11_25];
                var7_14.fillPatternTS(runTimeWindow2, (double[])object2);
                var25_87 = 0.0;
                for (n5 = 0; n5 < var11_25; ++n5) {
                    var25_87 += object2[n5];
                }
                if (var25_87 > 0.0) {
                    var29_88 = var27_60 / var25_87;
                    for (n5 = n2; n5 < var11_25; ++n5) {
                        var8_13[n5 - n2] = (double)(object2[n5] * var29_88);
                        var9_12[n5 - n2] = var27_60;
                    }
                } else {
                    for (n5 = n2; n5 < var11_25; ++n5) {
                        var8_13[n5 - n2] = 0.0;
                        var9_12[n5 - n2] = 0.0;
                    }
                }
            }
            int n6 = 0;
            if (n2 != 0) {
                n6 = var11_25 - n2;
            }
            int n7 = (var12_26 - n6) / var11_25;
            for (int i = 0; i < n7; ++i) {
                int n8;
                var14_42.step = n6 + i * var11_25;
                var27_60 = ((GenerationRequirement)object).f(var14_42);
                var25_87 = 0.0;
                for (n8 = 0; n8 < var11_25; ++n8) {
                    var25_87 += var8_13[n6 + i * var11_25 + n8];
                }
                if (var25_87 > 0.0) {
                    var29_88 = var27_60 / var25_87;
                    for (n8 = 0; n8 < var11_25; ++n8) {
                        int n9 = n6 + i * var11_25 + n8;
                        var8_13[n9] = var8_13[n9] * var29_88;
                        var9_12[n6 + i * var11_25 + n8] = var27_60;
                    }
                    continue;
                }
                for (n8 = 0; n8 < var11_25; ++n8) {
                    var8_13[n6 + i * var11_25 + n8] = 0.0;
                    var9_12[n6 + i * var11_25 + n8] = 0.0;
                }
            }
            if (n6 + n7 * var11_25 < var12_26 + 1) {
                int n10;
                int n11;
                var14_42.step = n11 = n6 + n7 * var11_25;
                var27_60 = ((GenerationRequirement)object).f(var14_42);
                object2 = new HecTime(var14_42.getHecTime());
                HecTime hecTime5 = new HecTime(object2);
                var14_42.step += var11_25;
                HecTime hecTime6 = new HecTime(var14_42.getHecTime());
                RunTimeWindow runTimeWindow3 = new RunTimeWindow(hecTime5, hecTime6, object2);
                runTimeWindow3.setTimeStep(var6_15.getTimeStep(), var6_15.getTimeIncrement());
                double[] dArray3 = new double[var11_25];
                var7_14.fillPatternTS(runTimeWindow3, dArray3);
                var25_87 = 0.0;
                for (n10 = 0; n10 < var11_25; ++n10) {
                    var25_87 += dArray3[n10];
                }
                int n12 = var12_26 - n11 + 1;
                if (var25_87 > 0.0) {
                    var29_88 = var27_60 / var25_87;
                    for (n10 = 0; n10 < n12; ++n10) {
                        var8_13[n11 + n10] = dArray3[n10] * var29_88;
                        var9_12[n11 + n10] = var27_60;
                    }
                } else {
                    for (n10 = 0; n10 < n12; ++n10) {
                        var8_13[n11 + n10] = 0.0;
                        var9_12[n11 + n10] = 0.0;
                    }
                }
            }
        } else if (this.c == 12) {
            int n13;
            int n14;
            var9_12 = dArray2;
            var8_13 = dArray;
            var7_14 = object;
            var6_15 = runTimeWindow;
            object = this;
            int n15 = var6_15.getTimeStepSeconds();
            var11_25 = 604800 / n15;
            var12_26 = var6_15.getNumSteps();
            HecTime hecTime = var6_15.getLookbackTime();
            var14_42 = var6_15.getRunTimeStepAtTime(hecTime);
            int n16 = hecTime.secondsSinceMidnight();
            if (n16 == 0) {
                n16 = 86400;
            }
            if ((n14 = (n13 = RunTimeStep.getDayOfWeek((HecTime)hecTime)) - ((GenerationRequirement)object).h) < 0) {
                n14 += 7;
            }
            n16 = n16 / n15 - 1 + n14 * 86400 / n15;
            RunTimeStep runTimeStep = new RunTimeStep(var14_42);
            int n17 = ((GenerationRequirement)object).g - ((GenerationRequirement)object).h;
            if (n17 < 0) {
                n17 += 7;
            }
            n17 *= 86400 / n15;
            if (n16 != 0) {
                int n18;
                var14_42.step -= n16;
                HecTime hecTime7 = new HecTime(var14_42.getHecTime());
                HecTime hecTime8 = new HecTime(hecTime7);
                runTimeStep.step = var14_42.step + n17;
                var27_60 = ((GenerationRequirement)object).f(runTimeStep);
                var14_42.step += var11_25 - 1;
                HecTime hecTime9 = new HecTime(var14_42.getHecTime());
                RunTimeWindow runTimeWindow4 = new RunTimeWindow(hecTime8, hecTime9, hecTime7);
                runTimeWindow4.setTimeStep(var6_15.getTimeStep(), var6_15.getTimeIncrement());
                double[] dArray4 = new double[var11_25 + 1];
                var7_14.fillPatternTS(runTimeWindow4, dArray4);
                var25_87 = 0.0;
                for (n18 = 0; n18 < var11_25; ++n18) {
                    var25_87 += dArray4[n18];
                }
                if (var25_87 > 0.0) {
                    var29_88 = var27_60 / var25_87;
                    for (n18 = n16; n18 < var11_25 && n18 - n16 < var8_13.length; ++n18) {
                        var8_13[n18 - n16] = dArray4[n18] * var29_88;
                        var9_12[n18 - n16] = var27_60;
                    }
                } else {
                    for (n18 = n16; n18 < var11_25; ++n18) {
                        var8_13[n18 - n16] = 0.0;
                        var9_12[n18 - n16] = 0.0;
                    }
                }
            }
            int n19 = 0;
            if (n16 != 0) {
                n19 = var11_25 - n16;
            }
            int n20 = (var12_26 - n19) / var11_25;
            for (int i = 0; i < n20; ++i) {
                int n21;
                var14_42.step = n19 + i * var11_25;
                runTimeStep.step = var14_42.step + n17;
                var27_60 = ((GenerationRequirement)object).f(runTimeStep);
                var25_87 = 0.0;
                for (n21 = 0; n21 < var11_25; ++n21) {
                    var25_87 += var8_13[n19 + i * var11_25 + n21];
                }
                if (var25_87 > 0.0) {
                    var29_88 = var27_60 / var25_87;
                    for (n21 = 0; n21 < var11_25; ++n21) {
                        int n22 = n19 + i * var11_25 + n21;
                        var8_13[n22] = var8_13[n22] * var29_88;
                        var9_12[n19 + i * var11_25 + n21] = var27_60;
                    }
                    continue;
                }
                for (n21 = 0; n21 < var11_25; ++n21) {
                    var8_13[n19 + i * var11_25 + n21] = 0.0;
                    var9_12[n19 + i * var11_25 + n21] = 0.0;
                }
            }
            if (n19 + n20 * var11_25 < var12_26 + 1) {
                int n23;
                int n24;
                var14_42.step = n24 = n19 + n20 * var11_25;
                runTimeStep.step = var14_42.step + n17;
                var27_60 = ((GenerationRequirement)object).f(runTimeStep);
                HecTime hecTime10 = new HecTime(var14_42.getHecTime());
                HecTime hecTime11 = new HecTime(hecTime10);
                var14_42.step += var11_25;
                HecTime hecTime12 = new HecTime(var14_42.getHecTime());
                RunTimeWindow runTimeWindow5 = new RunTimeWindow(hecTime11, hecTime12, hecTime10);
                runTimeWindow5.setTimeStep(var6_15.getTimeStep(), var6_15.getTimeIncrement());
                double[] dArray5 = new double[var11_25 + 1];
                var7_14.fillPatternTS(runTimeWindow5, dArray5);
                var25_87 = 0.0;
                for (n23 = 0; n23 < var11_25; ++n23) {
                    var25_87 += dArray5[n23];
                }
                int n25 = var12_26 - n24 + 1;
                if (var25_87 > 0.0) {
                    var29_88 = var27_60 / var25_87;
                    for (n23 = 0; n23 < n25; ++n23) {
                        var8_13[n24 + n23] = dArray5[n23] * var29_88;
                        var9_12[n24 + n23] = var27_60;
                    }
                } else {
                    for (n23 = 0; n23 < n25; ++n23) {
                        var8_13[n24 + n23] = 0.0;
                        var9_12[n24 + n23] = 0.0;
                    }
                }
            }
        } else {
            Object object3;
            int n26;
            int n27;
            var9_12 = dArray2;
            var8_13 = dArray;
            var7_14 = object;
            var6_15 = runTimeWindow;
            object = this;
            int n28 = var6_15.getTimeStepSeconds();
            var12_26 = var6_15.getNumSteps();
            Object object4 = var6_15.getLookbackTime();
            var14_42 = var6_15.getRunTimeStepAtTime((HecTime)object4);
            int n29 = object4.secondsSinceMidnight();
            if (n29 == 0) {
                n29 = 86400;
            }
            if (((GenerationRequirement)object).b == 0) {
                n27 = object4.day() - 1;
                n26 = GenerationRequirement.a((HecTime)object4);
            } else {
                int n30;
                RunTimeStep runTimeStep = var14_42;
                object4 = object;
                int[] nArray = ((GenerationRequirement)object4).l != null ? ((GenerationRequirement)object4).l.getTimeArray() : ((GenerationRequirement)object4).i.getTimeArray();
                if (nArray == null || nArray.length == 0) {
                    n30 = 0;
                } else {
                    var11_25 = ((GenerationRequirement)object4).g(runTimeStep);
                    runTimeStep = runTimeStep.getHecTime();
                    int n31 = (runTimeStep.dayOfYear() - 1) * 1440 + runTimeStep.minutesSinceMidnight();
                    if (((GenerationRequirement)object4).l != null) {
                        runTimeStep.subtractDays(1);
                        n31 = (int)runTimeStep.getMinutes();
                    }
                    n30 = var11_25 = (n31 - nArray[var11_25]) / 1440;
                }
                n27 = n30;
                n26 = ((GenerationRequirement)object).h(var14_42);
            }
            var11_25 = n26 * 86400 / n28;
            n29 = n29 / n28 - 1 + n27 * 86400 / n28;
            new RunTimeStep(var14_42);
            if (n29 != 0) {
                int n32;
                var14_42.step -= n29;
                HecTime hecTime = new HecTime(var14_42.getHecTime());
                HecTime hecTime13 = new HecTime(hecTime);
                var27_60 = ((GenerationRequirement)object).f(var14_42);
                if (((GenerationRequirement)object).c == 10) {
                    var27_60 *= ((GenerationRequirement)object).j * (double)n26 * 24.0;
                }
                var14_42.step += var11_25 - 1;
                HecTime hecTime14 = new HecTime(var14_42.getHecTime());
                RunTimeWindow runTimeWindow6 = new RunTimeWindow(hecTime13, hecTime14, hecTime);
                runTimeWindow6.setTimeStep(var6_15.getTimeStep(), var6_15.getTimeIncrement());
                object3 = new double[var11_25];
                var7_14.fillPatternTS(runTimeWindow6, (double[])object3);
                var25_87 = 0.0;
                for (n32 = 0; n32 < var11_25; ++n32) {
                    var25_87 += object3[n32];
                }
                if (var25_87 > 0.0) {
                    var29_88 = var27_60 / var25_87;
                    for (n32 = n29; n32 < var11_25 && n32 - n29 < var8_13.length; ++n32) {
                        var8_13[n32 - n29] = object3[n32] * var29_88;
                        var9_12[n32 - n29] = var27_60;
                    }
                } else {
                    for (n32 = n29; n32 < var11_25; ++n32) {
                        var8_13[n32 - n29] = 0.0;
                        var9_12[n32 - n29] = 0.0;
                    }
                }
            }
            int n33 = 0;
            if (n29 != 0) {
                n33 = var11_25 - n29;
            }
            var14_42.step = n33;
            HecTime hecTime = var14_42.getHecTime();
            GenerationRequirement.a(hecTime);
            int n34 = ((GenerationRequirement)object).b == 0 ? GenerationRequirement.a(hecTime) : ((GenerationRequirement)object).h(var14_42);
            var11_25 = n34 * 86400 / n28;
            while (n33 + var11_25 <= var12_26 + 1) {
                int n35;
                var14_42.step = n33;
                var27_60 = ((GenerationRequirement)object).f(var14_42);
                if (((GenerationRequirement)object).c == 10) {
                    var27_60 *= ((GenerationRequirement)object).j * (double)n34 * 24.0;
                }
                var25_87 = 0.0;
                for (n35 = 0; n35 < var11_25; ++n35) {
                    var25_87 += var8_13[n33 + n35];
                }
                if (var25_87 > 0.0) {
                    var29_88 = var27_60 / var25_87;
                    for (n35 = 0; n35 < var11_25; ++n35) {
                        int n36 = n33 + n35;
                        var8_13[n36] = var8_13[n36] * var29_88;
                        var9_12[n33 + n35] = var27_60;
                    }
                } else {
                    for (n35 = 0; n35 < var11_25; ++n35) {
                        var8_13[n33 + n35] = 0.0;
                        var9_12[n33 + n35] = 0.0;
                    }
                }
                var14_42.step = n33 += var11_25;
                hecTime = var14_42.getHecTime();
                n34 = ((GenerationRequirement)object).b == 0 ? GenerationRequirement.a(hecTime) : ((GenerationRequirement)object).h(var14_42);
                var11_25 = n34 * 86400 / n28;
            }
            if (n33 < var12_26 + 1) {
                int n37;
                int n38;
                var14_42.step = n38 = n33;
                var27_60 = ((GenerationRequirement)object).f(var14_42);
                if (((GenerationRequirement)object).c == 10) {
                    var27_60 *= ((GenerationRequirement)object).j * (double)n34 * 24.0;
                }
                HecTime hecTime15 = new HecTime(var14_42.getHecTime());
                HecTime hecTime16 = new HecTime(hecTime15);
                var14_42.step += var11_25;
                object3 = new HecTime(var14_42.getHecTime());
                RunTimeWindow runTimeWindow7 = new RunTimeWindow(hecTime16, (HecTime)object3, hecTime15);
                runTimeWindow7.setTimeStep(var6_15.getTimeStep(), var6_15.getTimeIncrement());
                double[] dArray6 = new double[var11_25];
                var7_14.fillPatternTS(runTimeWindow7, dArray6);
                var25_87 = 0.0;
                for (n37 = 0; n37 < var11_25; ++n37) {
                    var25_87 += dArray6[n37];
                }
                int n39 = var12_26 - n38 + 1;
                if (var25_87 > 0.0) {
                    var29_88 = var27_60 / var25_87;
                    for (n37 = 0; n37 < n39; ++n37) {
                        var8_13[n38 + n37] = dArray6[n37] * var29_88;
                        var9_12[n38 + n37] = var27_60;
                    }
                } else {
                    for (n37 = 0; n37 < n39; ++n37) {
                        var8_13[n38 + n37] = 0.0;
                        var9_12[n38 + n37] = 0.0;
                    }
                }
            }
        }
        double d = this.j * (double)runTimeWindow.getTimeStepSeconds() / 3600.0;
        double[] dArray7 = new double[dArray.length];
        Arrays.fill(dArray7, d);
        PowerGenerationPatternContainer.a(dArray, dArray7, 0, dArray.length, 1.0);
        if (this.e == 0) {
            System.arraycopy(dArray, 0, dArray2, 0, dArray2.length);
            return;
        }
        RunTimeWindow runTimeWindow8 = runTimeWindow;
        runTimeWindow = runTimeWindow8.getRunTimeStepAtTime(runTimeWindow8.getLookbackTime());
        int n40 = this.c((RunTimeStep)runTimeWindow);
        int n41 = this.b((RunTimeStep)runTimeWindow);
        double d2 = 0.0;
        int n42 = n40;
        for (n40 = 0; n40 <= n; ++n40) {
            d2 += dArray[n40];
            if (n42 + 1 >= n41) {
                n42 = n40 - n41 + 1;
                if (n42 < 0) {
                    n42 = 0;
                }
                Arrays.fill(dArray2, n42, n40 + 1, d2);
                n42 = 0;
                d2 = 0.0;
                continue;
            }
            ++n42;
        }
        if (n42 > 0) {
            if ((n42 = n40 - n42) < 0) {
                n42 = 0;
            }
            Arrays.fill(dArray2, n42, n40, d2);
        }
    }

    private double a(int n) {
        int[] nArray = this.l.getTimeArray();
        if (n < nArray[0] || n > nArray[nArray.length - 1]) {
            return Double.NEGATIVE_INFINITY;
        }
        int n2 = this.m;
        if (n2 < 0 || n2 >= nArray.length - 1) {
            n2 = 0;
        }
        if (n2 < nArray.length - 1 && n >= nArray[n2] && n < nArray[n2 + 1]) {
            this.m = n2;
            return this.l.getValue(n2);
        }
        if (++n2 < nArray.length - 1 && n >= nArray[n2] && n < nArray[n2 + 1]) {
            this.m = n2;
            return this.l.getValue(n2);
        }
        n2 = GenerationRequirement.a(nArray, n, nArray.length);
        return this.l.getValue(n2);
    }

    protected static int a(int[] nArray, int n, int n2) {
        int n3 = 0;
        int n4 = n2 + 1;
        if (nArray[n2 - 1] > nArray[0]) {
            while (n4 - n3 > 1) {
                n2 = (n4 + n3) / 2;
                if (nArray[n2 - 1] > n) {
                    n4 = n2;
                    continue;
                }
                n3 = n2;
            }
        } else {
            while (n4 - n3 > 1) {
                n2 = (n4 + n3) / 2;
                if (nArray[n2 - 1] < n) {
                    n4 = n2;
                    continue;
                }
                n3 = n2;
            }
        }
        return n3 - 1;
    }

    private double f(RunTimeStep runTimeStep) {
        double d;
        HecTime hecTime = runTimeStep.getHecTime();
        if (this.l != null) {
            d = this.a((int)hecTime.getMinutes());
            if (RMAConst.isUndefinedValue((double)d)) {
                d = 0.0;
            }
            if (this.c == 10 && d > 1.0) {
                this.n.printErrorMessage("SystemHydropowerRule: Plant Factor is expected but the input time series data is greater than 1.");
            }
        } else if (this.b == 0) {
            int n = hecTime.month() - 1;
            d = this.d[n];
        } else {
            int n = this.g(runTimeStep);
            d = this.i.getDataArray()[n];
        }
        return d;
    }

    private int g(RunTimeStep runTimeStep) {
        int[] nArray = this.l != null ? this.l.getTimeArray() : this.i.getTimeArray();
        if (nArray == null || nArray.length == 0) {
            return 0;
        }
        runTimeStep = runTimeStep.getHecTime();
        int n = nArray.length - 1;
        int n2 = runTimeStep.dayOfYear() * 1440 + runTimeStep.minutesSinceMidnight();
        if (this.l != null) {
            n2 = (int)runTimeStep.getMinutes();
        }
        int n3 = runTimeStep.year();
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n4 = nArray[i];
            if (n3 % 4 == 0 && (n3 % 100 != 0 || n3 % 400 == 0) && n4 / 1440 >= 60) {
                n4 += 1440;
            }
            if (n2 < n4) continue;
            n = i;
            break;
        }
        return n;
    }

    private int h(RunTimeStep runTimeStep) {
        int[] nArray = this.l != null ? this.l.getTimeArray() : this.i.getTimeArray();
        if (nArray == null || nArray.length == 0) {
            return 0;
        }
        int n = this.g(runTimeStep);
        int n2 = n + 1;
        if (n2 >= nArray.length) {
            n2 = 0;
        }
        runTimeStep = runTimeStep.getHecTime();
        int n3 = runTimeStep.year();
        if (n2 == n) {
            if (n3 % 4 == 0 && (n3 % 100 != 0 || n3 % 400 == 0)) {
                return 366;
            }
            return 365;
        }
        if (n2 < n) {
            n = nArray[n] / 1440;
            int n4 = 365 - n + 1;
            if (n <= 59 && n3 % 4 == 0 && (n3 % 100 != 0 || n3 % 400 == 0)) {
                ++n4;
            }
            return n4;
        }
        n = nArray[n] / 1440;
        int n5 = nArray[n2] / 1440;
        n2 = n5 - n;
        if (n <= 59 && n5 >= 60 && n3 % 4 == 0 && (n3 % 100 != 0 || n3 % 400 == 0)) {
            ++n2;
        }
        return n2;
    }

    public List a(RunTimeWindow runTimeWindow) {
        int n;
        int n2 = runTimeWindow.getNumSteps();
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        Object object = runTimeWindow.getLookbackTime();
        RunTimeWindow runTimeWindow2 = runTimeWindow = runTimeWindow.getRunTimeStepAtTime(object);
        object = this;
        int n3 = runTimeWindow2.getTimeStepSeconds();
        int n4 = (runTimeWindow2 = runTimeWindow2.getHecTime()).secondsSinceMidnight();
        if (n4 == 0) {
            n4 = 86400;
        }
        if (object.c == 11) {
            n = n4 / n3 - 1;
        } else if (object.e == 12) {
            int n5 = RunTimeStep.getDayOfWeek((HecTime)runTimeWindow2);
            n = n5 - object.f;
            if (n < 0) {
                n += 7;
            }
            n = n4 / n3 - 1 + n * 86400 / n3;
        } else if (object.e == 13) {
            n = n4 / n3 - 1;
        } else if (object.e == 14) {
            n = n4 / n3 - 1;
        } else {
            int n6 = RunTimeStep.getDayOfWeek((HecTime)runTimeWindow2);
            n = n6 - object.f;
            if (n < 0) {
                n += 7;
            }
            n = n4 / n3 - 1 + n * 86400 / n3;
        }
        int n7 = this.i((RunTimeStep)runTimeWindow);
        int[] nArray = new int[2];
        int[] nArray2 = nArray;
        nArray[0] = runTimeWindow.step;
        nArray2[1] = n7;
        arrayList.add(nArray2);
        runTimeWindow.step += n7 - n;
        while (runTimeWindow.step <= n2) {
            n7 = this.i((RunTimeStep)runTimeWindow);
            int[] nArray3 = new int[2];
            nArray2 = nArray3;
            nArray3[0] = runTimeWindow.step;
            nArray2[1] = n7;
            arrayList.add(nArray2);
            runTimeWindow.step += n7;
        }
        return arrayList;
    }

    private int i(RunTimeStep runTimeStep) {
        int n = runTimeStep.getTimeStepSeconds();
        int n2 = 1;
        if (this.c == 11) {
            n2 = 8600 / n;
        } else if (this.e == 12) {
            n2 = 60200 / n;
        } else if (this.e == 13) {
            runTimeStep = runTimeStep.getHecTime();
            int n3 = GenerationRequirement.a((HecTime)runTimeStep);
            n2 = n3 * 8600 / n;
        } else if (this.e == 14) {
            this.g(runTimeStep);
        }
        return n2;
    }

    public RunTimePeriod a(RunTimeStep runTimeStep) {
        RunTimePeriod runTimePeriod = new RunTimePeriod();
        new RunTimePeriod().a = runTimeStep;
        runTimePeriod.b = this.b(runTimeStep);
        runTimePeriod.c = this.c(runTimeStep);
        if (runTimeStep.step + (runTimePeriod.b - runTimePeriod.c) > runTimeStep.getTotalNumSteps()) {
            runTimePeriod.b = runTimeStep.getTotalNumSteps() - (runTimeStep.step - runTimePeriod.c) + 1;
        }
        return runTimePeriod;
    }

    public int b(RunTimeStep runTimeStep) {
        if (this.k >= 0) {
            return this.k;
        }
        if (runTimeStep == null || runTimeStep.rtw == null) {
            return 1;
        }
        this.k = this.e == 0 ? 1 : (this.e == 1 ? 86400 / runTimeStep.rtw.getTimeStepSeconds() : 604800 / runTimeStep.rtw.getTimeStepSeconds());
        return this.k;
    }

    public int c(RunTimeStep runTimeStep) {
        int n;
        int n2 = runTimeStep.getTimeStepSeconds();
        runTimeStep.rtw.getNumSteps();
        runTimeStep = runTimeStep.getHecTime();
        int n3 = runTimeStep.secondsSinceMidnight();
        if (n3 == 0) {
            n3 = 86400;
        }
        if (this.e == 0) {
            n = 0;
        } else if (this.e == 1) {
            n = n3 / n2 - 1;
        } else {
            n = RunTimeStep.getDayOfWeek((HecTime)runTimeStep);
            if ((n -= this.h) < 0) {
                n += 7;
            }
            n = n3 / n2 - 1 + n * 86400 / n2;
        }
        return n;
    }

    public static int a(HecTime hecTime) {
        int n = hecTime.month();
        int n2 = hecTime.year();
        if (--n == 1 && n2 % 4 == 0 && (n2 % 100 != 0 || n2 % 400 == 0)) {
            return 29;
        }
        return a[n];
    }

    public double a(RunTimeStep runTimeStep, double[] dArray) {
        double d = this.b == 0 ? this.d(runTimeStep) : this.e(runTimeStep);
        if (d == 0.0) {
            return 0.0;
        }
        if (this.e == 1) {
            return d / 7.0;
        }
        if (this.e == 2) {
            return d;
        }
        int n = 86400 / runTimeStep.getTimeStepSeconds();
        if (n <= 0) {
            return 0.0;
        }
        int n2 = runTimeStep.step - 3 * n;
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = runTimeStep.rtw.getNumSteps();
        double d2 = 0.0;
        for (int i = n2; i < n * 7; ++i) {
            int n4 = n2 + i;
            if (n4 > n3) {
                n4 = n3;
            }
            d2 += dArray[n4];
        }
        if (d2 <= 0.0) {
            return 0.0;
        }
        double d3 = dArray[runTimeStep.step] * d / d2;
        return d3;
    }

    protected double d(RunTimeStep runTimeStep) {
        HecTime hecTime = runTimeStep.getHecTime();
        int n = hecTime.month() - 1;
        if (this.c == 11) {
            return this.d[n] * 7.0;
        }
        if (this.c == 13) {
            int n2 = GenerationRequirement.a(hecTime);
            if (this.l != null) {
                return this.a((int)runTimeStep.getHecTime().getMinutes()) / (double)n2 * 7.0;
            }
            return this.d[n] / (double)n2 * 7.0;
        }
        if (this.c == 12) {
            int n3;
            HecTime hecTime2 = new HecTime(hecTime);
            hecTime2.setTimeIncrement(3);
            int n4 = RunTimeStep.getDayOfWeek((HecTime)hecTime);
            int n5 = n4 - this.f;
            if (n5 < 0) {
                n5 += 7;
            }
            if ((n3 = this.g - this.f) < 0) {
                n3 += 7;
            }
            hecTime2.subtract(n5 -= n3);
            n = hecTime2.month() - 1;
            return this.d[n];
        }
        double d = this.d[n];
        return d * this.j * 24.0 * 7.0;
    }

    protected double e(RunTimeStep runTimeStep) {
        HecTime hecTime = runTimeStep.getHecTime();
        if (this.l != null) {
            return this.a((int)hecTime.getMinutes());
        }
        int[] nArray = this.l != null ? this.l.getTimeArray() : this.i.getTimeArray();
        if (nArray == null || nArray.length == 0) {
            return 0.0;
        }
        int n = this.g(runTimeStep);
        if (this.c == 11) {
            if (this.l != null) {
                return this.l.getValue(n);
            }
            return this.i.getDataArray()[n] * 7.0;
        }
        if (this.c == 14) {
            if (this.l != null) {
                return this.l.getValue(n);
            }
            int n2 = n + 1 < nArray.length ? (nArray[n + 1] - nArray[n]) / 1440 : 365 - nArray[n] / 1440;
            if (n2 <= 0) {
                n2 = 1;
            }
            return this.i.getDataArray()[n] / (double)n2 * 7.0;
        }
        if (this.c == 12) {
            int n3;
            if (this.l != null) {
                return this.l.getValue(n);
            }
            HecTime hecTime2 = new HecTime(hecTime);
            hecTime2.setTimeIncrement(3);
            n = RunTimeStep.getDayOfWeek((HecTime)hecTime);
            if ((n -= this.f) < 0) {
                n += 7;
            }
            if ((n3 = this.g - this.f) < 0) {
                n3 += 7;
            }
            hecTime2.subtract(n -= n3);
            n = nArray.length - 1;
            n3 = hecTime2.dayOfYear() * 1440 + hecTime2.minutesSinceMidnight();
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (n3 < nArray[i]) continue;
                n = i;
                break;
            }
            return this.i.getDataArray()[n];
        }
        if (this.l != null) {
            return this.a((int)hecTime.getMinutes()) * this.j * 24.0 * 7.0;
        }
        return this.i.getDataArray()[n] * this.j * 24.0 * 7.0;
    }
}

