/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.heclib.util.doubleArrayContainer;
import hec.lang.DSSPathString;
import hec.model.RunTimeStep;
import hec.rss.model.Element;
import hec.rss.model.Function;
import hec.rss.model.ReservoirDamElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOutletElement;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssNode;
import java.lang.reflect.Field;

public class HoldoutFunction
extends Function {
    private transient double[] a;
    private transient doubleArrayContainer[] b;
    private transient double[] c;

    public HoldoutFunction() {
    }

    public HoldoutFunction(ReservoirElement reservoirElement) {
        super(reservoirElement);
    }

    @Override
    public void updateTSProxyList() {
        TSRecordProxy tSRecordProxy = null;
        if (this.getTSRecordProxy(16) == null && (tSRecordProxy = RssModelVariableSet.newTSRecordProxy(this.element.getSystem(), ((ReservoirElement)this.element).getStorageFunction(), 16)) != null) {
            this._tsrecordVector.addElement(tSRecordProxy);
        }
        if (tSRecordProxy != null) {
            this.setModified(true);
        }
    }

    @Override
    public synchronized Object clone() {
        HoldoutFunction holdoutFunction = (HoldoutFunction)super.clone();
        return holdoutFunction;
    }

    @Override
    public int computeForecastStep(RunTimeStep runTimeStep) {
        if (this.b == null || this.a == null) {
            return 1;
        }
        int n = this.b.length;
        for (int i = 0; i < n; ++i) {
            if (this.b[i] == null) continue;
            this.b[i].array[runTimeStep.step] = this.a[runTimeStep.step] * this.c[i];
        }
        return 0;
    }

    @Override
    public int computeHindcastStep(RunTimeStep runTimeStep) {
        return ((Function)this).computeForecastStep(runTimeStep);
    }

    @Override
    public boolean initialize() {
        int n;
        TSDataSet tSDataSet = this.element.getSystem().getOutputTSDataSet();
        if (tSDataSet == null) {
            return false;
        }
        TSRecordProxy tSRecordProxy = this.getTSRecordProxy(16);
        if (tSRecordProxy == null) {
            return false;
        }
        if ((tSRecordProxy = tSDataSet.getTSRecord(tSRecordProxy.getName(), 16)) == null) {
            return false;
        }
        DSSPathString dSSPathString = new DSSPathString(tSRecordProxy.getDSSPathname());
        dSSPathString.setCPart("FLOW-HOLDOUT");
        tSRecordProxy.setDSSPathname(dSSPathString.getPathname());
        tSDataSet.loadTSRecord(tSRecordProxy.getName(), 16, "");
        this.a = this.getTSArray(16);
        if (this.a == null) {
            HoldoutFunction holdoutFunction = this;
            holdoutFunction.printErrorMessage("Failed to get Holdout Time Series for " + holdoutFunction.element.getName());
            this.printErrorMessage("HoldoutFunction.initialize");
            return false;
        }
        int n2 = this.element._elemVector.size();
        this.c = new double[n2 - 1];
        this.b = new doubleArrayContainer[n2 - 1];
        for (n = 1; n < n2; ++n) {
            Element element = this.element._elemVector.elementAt(n);
            if (!(element instanceof ReservoirOutletElement)) {
                HoldoutFunction holdoutFunction = this;
                holdoutFunction.printErrorMessage("Unexpected element type in reservoir " + holdoutFunction.element.getName());
                this.printErrorMessage("HoldoutFunction.initialize");
                return false;
            }
            this.c[n - 1] = element instanceof ReservoirDamElement ? 1.0 : 0.0;
            RssNode rssNode = element.getDownstreamNode();
            if (rssNode == null) {
                this.b[n - 1] = null;
                this.c[n - 1] = 0.0;
                continue;
            }
            this.b[n - 1] = rssNode.getTSContainer(0);
            if (this.b[n - 1] != null) continue;
            this.c[n - 1] = 0.0;
        }
        double d = 0.0;
        for (n = 0; n < n2 - 1; ++n) {
            d += this.c[n];
        }
        if (d > 0.0) {
            n = 0;
            while (n < n2 - 1) {
                int n3 = n++;
                this.c[n3] = this.c[n3] / d;
            }
        }
        return true;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

