/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSDataSet;
import hec.clientapp.rmi.csinterface.HecRmiWorkspace;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.io.AsciiSerializable;
import hec.io.DSSIdentifier;
import hec.io.Identifier;
import hec.io.TimeSeriesContainer;
import hec.lang.UserId;
import hec.model.RunTimeWindow;
import hec.model.TSRecord;
import hec.rss.model.NetworkHotstartState;
import hec.rss.model.RssSystem;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.io.HecAsciiDeserializer;
import mil.army.usace.hec.rmi.io.HecAsciiSerializer;
import rma.util.RMAIO;

public class HotstartContainer
implements AsciiSerializable {
    private static boolean a = true;
    private HecTime _time = new HecTime();
    private double _hoursToSave;
    private Map<String, NetworkHotstartState> _map = new HashMap<String, NetworkHotstartState>();
    private transient List<TimeSeriesContainer> b = new ArrayList<TimeSeriesContainer>();
    private transient HecTime c;
    private transient int d = -1;
    private transient RssSystem e;
    private transient String f;
    private transient boolean g = true;
    private transient boolean h = true;

    public HotstartContainer(RssSystem rssSystem) {
        this.e = rssSystem;
    }

    public void setTime(HecTime hecTime) {
        this._time.set(hecTime);
    }

    public void put(String string, NetworkHotstartState networkHotstartState) {
        this._map.put(string, networkHotstartState);
        networkHotstartState.setParentContainer(this);
    }

    public HecTime getHotstartTime() {
        return this._time;
    }

    public NetworkHotstartState get(String string) {
        return this._map.get(string);
    }

    public String getFilename(boolean bl) {
        return this.getFilename(null, bl);
    }

    protected int getNumStepsBack() {
        if (this.d == -1) {
            this.calcNumStepsBack();
        }
        return this.d;
    }

    protected void printWarningMessage(String string) {
        this.e.printWarningMessage(string);
    }

    protected void printErrorMessage(String string) {
        this.e.printErrorMessage(string);
    }

    public String getFilename(String string, boolean bl) {
        if (this.f == null) {
            this.f = HotstartContainer.a(this.e, string, this._time, bl);
        }
        return this.f;
    }

    public static String a(RssSystem object, String string, HecTime object2, boolean bl) {
        RmiWorkspace rmiWorkspace;
        Object object3 = object.getProxyList().getContainer();
        if (!bl && object3 instanceof HecRmiWorkspace) {
            rmiWorkspace = (RmiWorkspace)object3;
            try {
                rmiWorkspace = ((HecRmiWorkspace)rmiWorkspace).getBaseWorkspace();
            }
            catch (RemoteException remoteException) {
                System.out.println("RemoteException " + String.valueOf(remoteException));
                remoteException.printStackTrace();
            }
        } else {
            rmiWorkspace = (RmiWorkspace)object.getWorkspace().getRemote();
        }
        try {
            object3 = rmiWorkspace.getWorkspacePath() + "/rss/hotstarts/";
        }
        catch (RemoteException remoteException) {
            System.out.println("getFileName:RemoteException " + String.valueOf(remoteException));
            remoteException.printStackTrace();
            return null;
        }
        object = string == null ? ((RssSystem)object).getAlternative().getName() : string;
        int n = ((String)object).indexOf(":");
        if (n >= 0) {
            object = ((String)object).substring(n + 1);
        }
        HecTime hecTime = new HecTime(object2);
        hecTime.showTimeAsBeginningOfDay(false);
        hecTime.setTimeIncrement(2);
        object2 = hecTime.dateAndTime(4);
        if ("00:00".equals(hecTime.time())) {
            hecTime.setTime("0000");
            object2 = hecTime.dateAndTime(4);
        }
        object2 = RMAIO.removeChar((String)object2, (char)',');
        object2 = RMAIO.removeChar((String)object2, (char)':');
        object = ((String)object).concat(".").concat((String)object2);
        object = RMAIO.userNameToFileName((String)object);
        object = ((String)object3).concat((String)object).concat(".dss");
        return object;
    }

    public void addTimeSeries(TimeSeriesContainer timeSeriesContainer) {
        if (timeSeriesContainer == null) {
            return;
        }
        this.b.add(timeSeriesContainer);
    }

    public double getHoursToSave() {
        return this._hoursToSave;
    }

    public void setHoursToSave(double d) {
        this._hoursToSave = d;
    }

    public List<TimeSeriesContainer> getTimeSeriesList() {
        return this.b;
    }

    protected boolean readTimeSeries(String string, int n) {
        DSSManager dSSManager = this.e.getDSSFileManager();
        TSDataSet tSDataSet = this.e.getRssRun().getOutputTSData();
        if (tSDataSet == null) {
            this.e.printErrorMessage("Hotstart.readTimeSeries: Failed to find Output TimeSeries for " + n);
            return false;
        }
        Vector vector = tSDataSet.getTSRecords();
        int n2 = vector.size();
        DSSIdentifier dSSIdentifier = new DSSIdentifier(string);
        string = this.e.c;
        HecTime hecTime = new HecTime(string.getLookbackTime());
        hecTime.setTimeIncrement(string.getTimeIncrement());
        hecTime.subtract(string.getTimeStep());
        dSSIdentifier.setStartTime(hecTime);
        HecTime hecTime2 = new HecTime(string.getEndTime());
        hecTime2.setTimeIncrement(string.getTimeIncrement());
        hecTime2.add(string.getTimeStep());
        dSSIdentifier.setEndTime(hecTime2);
        this.e.printMessage("Hotstart start=" + String.valueOf(hecTime) + " end=" + String.valueOf(hecTime2));
        dSSIdentifier.setTimeWindow(string.getLookbackTime().dateAndTime(104) + " " + string.getEndTime().dateAndTime(104));
        hecTime2 = new DSSPathname();
        int n3 = string.getNumLookbackSteps();
        for (int i = 0; i < n2; ++i) {
            string = (TSRecord)vector.get(i);
            string = string.getTimeSeriesContainer();
            hecTime2.setPathname(((TimeSeriesContainer)string).fullName);
            hecTime2.setDPart("");
            hecTime2.setFPart("");
            dSSIdentifier.setDSSPath(hecTime2.getPathname());
            if (this.b.size() > 0) {
                hecTime = this.findTimeSeries(hecTime2.getPathname());
            } else {
                try {
                    hecTime = dSSManager.readTS(dSSIdentifier, true);
                }
                catch (RemoteException remoteException) {
                    this.e.printErrorMessage("Failed to load hotstart timeseries " + String.valueOf(dSSIdentifier) + " Error:" + String.valueOf(remoteException));
                    System.out.println("loadTimeSeries: RemoteException " + String.valueOf(remoteException));
                    remoteException.printStackTrace();
                    return false;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.e.printErrorMessage("Hotstart timeseries file " + dSSIdentifier.getFileName() + " not found.");
                    System.out.println("loadTimeSeries: FileNotFoundException " + String.valueOf(fileNotFoundException));
                    return false;
                }
            }
            if (hecTime == null) {
                this.e.printErrorMessage("loadTimeSeries: failed to find hotstart TimeSeries " + String.valueOf(dSSIdentifier) + " in hotstart file");
                return false;
            }
            this.setTimeSeries((TimeSeriesContainer)hecTime, (TimeSeriesContainer)string, n3);
        }
        return true;
    }

    private void createTimeseries() {
        double d;
        this.getSaveStartTime();
        double d2 = this.getHoursToSave();
        if (d > 0.0) {
            Object object = this.e.getRssRun().getOutputTSData();
            object = object.getTSRecords();
            int n = ((Vector)object).size();
            HecTime hecTime = this.getHotstartTime();
            hecTime = new HecTime(hecTime);
            int n2 = (int)(d2 * 60.0);
            hecTime.subtractMinutes(n2);
            for (int i = 0; i < n; ++i) {
                TSRecord tSRecord = (TSRecord)((Vector)object).get(i);
                if (tSRecord == null || (tSRecord = tSRecord.getTimeSeriesContainer()) == null || tSRecord.numberValues == 0 || (tSRecord = this.trimTimeSeries((TimeSeriesContainer)tSRecord)) == null) continue;
                this.addTimeSeries((TimeSeriesContainer)tSRecord);
            }
        }
    }

    public TimeSeriesContainer trimTimeSeries(TimeSeriesContainer timeSeriesContainer) {
        int n = this.getNumStepsBack();
        int n2 = 0;
        if (timeSeriesContainer.numberValues > 0) {
            int n3 = this.getCurrentRunTimeStep();
            n2 = n3 - n;
        }
        if (n2 < 0) {
            this.printWarningMessage("Unable to create hotstart state");
            return null;
        }
        if (n2 > timeSeriesContainer.times.length) {
            return null;
        }
        int[] nArray = new int[n];
        double[] dArray = new double[n];
        if (timeSeriesContainer.times != null && timeSeriesContainer.values != null) {
            try {
                System.arraycopy(timeSeriesContainer.times, n2, nArray, 0, n);
            }
            catch (Exception exception) {
                System.out.println("trimTimeSeries:");
            }
            System.arraycopy(timeSeriesContainer.values, n2, dArray, 0, n);
        }
        HecTime hecTime = this.getSaveStartTime();
        HecTime hecTime2 = this.getHotstartTime();
        TimeSeriesContainer timeSeriesContainer2 = new TimeSeriesContainer();
        new TimeSeriesContainer().times = nArray;
        timeSeriesContainer2.values = dArray;
        timeSeriesContainer2.numberValues = n;
        if (timeSeriesContainer2.numberValues > 0) {
            timeSeriesContainer2.startTime = hecTime.value();
            timeSeriesContainer2.endTime = hecTime2.value();
        }
        timeSeriesContainer2.fullName = timeSeriesContainer.fullName;
        timeSeriesContainer2.fileName = this.getFilename(false);
        return timeSeriesContainer2;
    }

    protected int getCurrentRunTimeStep() {
        return this.e.c.getStepAtTime(this._time) + 1;
    }

    protected HecTime getSaveStartTime() {
        if (this.c == null) {
            this.calcNumStepsBack();
        }
        return this.c;
    }

    protected void calcNumStepsBack() {
        RunTimeWindow runTimeWindow = this.e.c;
        int n = runTimeWindow.getTimeIncrement();
        int n2 = runTimeWindow.getTimeStep();
        HecTime hecTime = new HecTime(this._time);
        hecTime.setTimeIncrement(n);
        hecTime.subtractMinutes((int)this._hoursToSave * 60);
        HecTime hecTime2 = new HecTime(this._time);
        hecTime2.setTimeIncrement(n);
        n = 0;
        while (hecTime2.greaterThanEqualTo(hecTime)) {
            hecTime2.subtract(n2);
            ++n;
        }
        n2 = runTimeWindow.getStepAtTime(this._time) + 1;
        this.c = new HecTime(runTimeWindow.getTimeAtStep(n2 - n));
        if (this.c.lessThan(runTimeWindow.getLookbackTime())) {
            this.c = new HecTime(runTimeWindow.getLookbackTime());
            int n3 = runTimeWindow.getStepAtTime(this.c);
            n = n2 - n3;
        }
        this.d = n;
    }

    private TimeSeriesContainer findTimeSeries(String string) {
        DSSPathname dSSPathname = new DSSPathname();
        int n = this.b.size();
        for (int i = 0; i < n; ++i) {
            TimeSeriesContainer timeSeriesContainer = this.b.get(i);
            dSSPathname.setPathname(timeSeriesContainer.fullName);
            dSSPathname.setDPart("");
            if (!dSSPathname.getPathname().equals(string)) continue;
            return timeSeriesContainer;
        }
        return null;
    }

    private void setTimeSeries(TimeSeriesContainer timeSeriesContainer, TimeSeriesContainer timeSeriesContainer2, int n) {
        if (timeSeriesContainer.values == null || timeSeriesContainer2.values == null) {
            this.e.printWarningMessage("Failed to restore timeseries for " + timeSeriesContainer2.fullName);
            return;
        }
        int n2 = n;
        if (timeSeriesContainer2.values.length < n) {
            n2 = timeSeriesContainer2.values.length;
        }
        n = Math.min(timeSeriesContainer2.values.length, n2);
        n2 -= timeSeriesContainer.values.length;
        for (int i = timeSeriesContainer.values.length - 1; i >= 0; --i) {
            timeSeriesContainer2.values[n--] = timeSeriesContainer.values[i];
            if (n < 0) break;
        }
        if (timeSeriesContainer.numberValues <= 0) {
            this.e.printLogMessage("Hotstart data in pathname, " + timeSeriesContainer.fullName + " is empty and not used during the compute.");
            return;
        }
        double d = timeSeriesContainer.values[0];
        if (n2 >= 0) {
            if (this.h) {
                this.printWarningMessage("Lookback may be longer than available Hotstart data.  Filling beginging of lookback with first hotstart value for Time-Series: \n" + timeSeriesContainer.fullName + "\nData may be empty because the time series is not used during the compute or for the entire lookback period.");
                this.h = false;
            } else {
                this.e.printLogMessage("Hotstart - Filling beginging of lookback with first hotstart value for Time-Series: " + timeSeriesContainer.fullName);
            }
            Arrays.fill(timeSeriesContainer2.values, 0, n2 + 1, d);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void saveFile() {
        this.e.printLogMessage("Saving Hotstart state at " + String.valueOf(this.getHotstartTime()));
        var1_1 = this.getFilename(false);
        var2_2 = (RmiWorkspace)this.e.getWorkspace().getRemote();
        try {
            var2_2 = var2_2.getFileManager();
        }
        catch (RemoteException var4_4) {
            this.e.printErrorMessage("Failed to get RmiFileManager during HotStart write " + String.valueOf(var4_4));
            System.out.println("saveFile:RemoteException " + String.valueOf(var4_4));
            return;
        }
        try {
            var4_5 = RMAIO.getDirectoryFromPath((String)var1_1);
            if (!var2_2.fileExists(var4_5)) {
                var5_8 = new Identifier((String)var1_1);
                var2_2.newFile(UserId.getUserId(), var5_8);
            }
        }
        catch (RemoteException var4_6) {
            this.e.printWarningMessage("Failed to determine status of Hotstart file " + (String)var1_1 + " Error:" + String.valueOf(var4_6));
            System.out.println("saveFile:Failed to determine status of Hotstart file " + (String)var1_1 + " Error:" + String.valueOf(var4_6));
        }
        this.createTimeseries();
        var4_7 = System.currentTimeMillis();
        var3_9 = null;
        var6_12 = var1_1.lastIndexOf(".");
        var1_1 = var1_1.substring(0, var6_12);
        var1_1 = var1_1.concat(".nhs");
        try {
            var10_15 = new Identifier((String)var1_1);
            var11_18 = var2_2.newFile(UserId.getUserId(), var10_15);
            if (var11_18 == null) {
                var11_18 = var2_2.openFile(UserId.getUserId(), var10_15);
            }
            if (var11_18 == null) {
                this.e.printErrorMessage("Failed to write Hotstart data.");
            }
            var1_1 = var11_18.getFile();
            var3_9 = var1_1.getBufferedWriter();
            var2_2 = new HecAsciiSerializer(var3_9);
            var2_2.serializeObject((Object)this);
            ** if (var3_9 == null) goto lbl-1000
        }
        catch (RemoteException var10_16) {
            try {
                this.e.printErrorMessage("Failed to save Hotstart State for time " + String.valueOf(this._time));
                System.out.println("saveFile:RemoteException saving Hotstart State file for " + String.valueOf(this._time) + " Exception:" + String.valueOf(var10_16));
                var10_16.printStackTrace();
                ** if (var3_9 == null) goto lbl-1000
            }
            catch (Throwable var6_13) {
                if (var3_9 != null) {
                    try {
                        var3_9.close();
                    }
                    catch (IOException v2) {}
                }
                throw var6_13;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var3_9.close();
                }
                catch (IOException v1) {}
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                var3_9.close();
            }
            catch (IOException v0) {}
        }
lbl-1000:
        // 2 sources

        {
        }
        if (HotstartContainer.a) {
            var10_15 = new DSSIdentifier();
            var10_15.setFileName(this.getFilename(false));
            var11_18 = this.e.getDSSFileManager();
            var1_1 = this.getTimeSeriesList();
            var2_3 = var1_1.size();
            var3_9 = new HecTime(this.getSaveStartTime());
            var6_14 = this.getHotstartTime();
            var3_9.setTimeIncrement(1);
            var6_14.setTimeIncrement(1);
            var10_15.setTimeWindow(var3_9.dateAndTime(104) + " " + var6_14.dateAndTime(104));
            var10_15.setStartTime((HecTime)var3_9);
            var10_15.setEndTime(var6_14);
            var7_19 = new DSSPathname();
            var8_20 = 0;
            System.out.println("saveFile:saving hotstart dss start=" + String.valueOf(var3_9) + " to " + String.valueOf(var6_14));
            for (var9_21 = 0; var9_21 < var2_3; ++var9_21) {
                var6_14 = (TimeSeriesContainer)var1_1.get(var9_21);
                var7_19.setPathname(var6_14.fullName);
                var7_19.setFPart("");
                var10_15.setDSSPath(var7_19.getPathname());
                if (var6_14.numberValues == 0) {
                    System.out.println("saveFile:" + var6_14.fullName + " is empty");
                    ++var8_20;
                }
                try {
                    var6_14.fileName = var10_15.getFileName();
                    var6_14.storedAsdoubles = true;
                    var3_10 = var11_18.write((DSSIdentifier)var10_15, var6_14.values, var6_14.values.length, true, true, true);
                    if (var3_10 == 0) continue;
                    System.out.println("saveFile:write failed for " + String.valueOf(var10_15));
                    continue;
                }
                catch (RemoteException var3_11) {
                    this.e.printErrorMessage("Failed to save Hotstart timeseries for " + var6_14.fullName);
                    System.out.println("saveFile:RemoteException saving Hotstart DSS data for " + var6_14.fullName + " Error:" + String.valueOf(var3_11));
                    var3_11.printStackTrace();
                }
            }
            if (var8_20 > 0) {
                this.e.printErrorMessage("There were " + var8_20 + " empty TS Records");
            }
        }
        var10_17 = System.currentTimeMillis();
        System.out.println("saveFile:took " + (var10_17 - var4_7) + "ms");
    }

    public boolean loadFile(String object, int n) {
        RmiFileManager rmiFileManager;
        String string = this.getFilename((String)object, true);
        int n2 = string.lastIndexOf(".");
        String string2 = string.substring(0, n2);
        string2 = string2.concat(".nhs");
        RmiWorkspace rmiWorkspace = (RmiWorkspace)this.e.getWorkspace().getRemote();
        try {
            rmiFileManager = rmiWorkspace.getFileManager();
        }
        catch (RemoteException remoteException) {
            this.e.printErrorMessage("Failed to get RmiFileManager during HotStart load " + String.valueOf(remoteException));
            System.out.println("loadFile:RemoteException " + String.valueOf(remoteException));
            return false;
        }
        try {
            if (!rmiFileManager.fileExists(string2)) {
                this.e.printErrorMessage("Failed to find Hotstart file " + string2);
                object = HotstartContainer.a(this.e, (String)object, this._time, false);
                int n3 = ((String)object).lastIndexOf(".");
                object = ((String)object).substring(0, n3);
                object = ((String)object).concat(".nhs");
                if (rmiFileManager.fileExists((String)object)) {
                    this.e.printErrorMessage("Rerun the Simulation Extract to copy the Hotstart file to the Simulation directory");
                }
                return false;
            }
        }
        catch (RemoteException remoteException) {
            this.e.printErrorMessage("load: Error during checking of Hotstart file " + string2 + " Error:" + String.valueOf(remoteException));
            System.out.println("loadFile: Error during checking of Hotstart file. RemoteException " + String.valueOf(remoteException));
            remoteException.printStackTrace();
        }
        object = new Identifier(string2);
        this.e.printMessage("Loading Hotstart file from " + string2);
        try {
            object = rmiFileManager.openFile(UserId.getUserId(), (Identifier)object);
        }
        catch (RemoteException remoteException) {
            this.e.printErrorMessage("Error opening Hotstart file " + string2 + " Error:" + String.valueOf(remoteException));
            System.out.println("RemoteException " + String.valueOf(remoteException));
            remoteException.printStackTrace();
            return false;
        }
        if (object == null) {
            this.e.printErrorMessage("Failed to find Hotstart file " + string2);
            return false;
        }
        object = object.getFile().getBufferedReader();
        if (!(object = new HecAsciiDeserializer((BufferedReader)object)).deserializeObject((Object)this)) {
            this.e.printErrorMessage("Failed to load hotstart state from " + string2);
            return false;
        }
        this.readTimeSeries(string, n);
        object = this.values();
        object = object.iterator();
        while (object.hasNext()) {
            NetworkHotstartState networkHotstartState = (NetworkHotstartState)object.next();
            networkHotstartState.setNetwork(this.e);
        }
        this.e.getDSSFileManager();
        new DSSPathname();
        return true;
    }

    public boolean fixElements(int n, List list) {
        Object object = this.values();
        object = object.iterator();
        while (object.hasNext()) {
            NetworkHotstartState networkHotstartState = (NetworkHotstartState)object.next();
            if (networkHotstartState.getComputeType() != n || networkHotstartState.findElements(list)) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this._map.clear();
    }

    public Collection<NetworkHotstartState> values() {
        return this._map.values();
    }

    public int size() {
        return this._map.size();
    }

    public void setCanSave(boolean bl) {
        this.g = bl;
    }

    public boolean canSave(RunTimeWindow runTimeWindow) {
        if (this._time.greaterThanEqualTo(runTimeWindow.getLookbackTime()) && this._time.lessThanEqualTo(runTimeWindow.getEndTime())) {
            return this.g;
        }
        return false;
    }

    public Object getFieldObject(Field object) {
        try {
            object = ((Field)object).get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    static {
        try {
            Field field = HotstartContainer.class.getField("b");
            int n = field.getModifiers();
            a = Modifier.isTransient(n);
            return;
        }
        catch (SecurityException securityException) {
            System.out.println("SecurityException " + String.valueOf(securityException));
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return;
        }
    }
}

