/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.heclib.util.HecTime;
import hec.lang.annotation.Scriptable;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import org.jdom.Element;
import rma.util.RMAIO;

public class HotstartOptions
implements AltInputReportInfc,
Serializable,
Cloneable {
    private boolean _enabled;
    private boolean _createHotstart;
    private boolean _saveAtEndofSim;
    private boolean _saveAtInterval;
    private HecTime _intervalDateTime;
    private int _timeStep = 1;
    private int _timeIncrement = 2;
    private String _destDir;
    private double _hoursToSave = 1.0;
    private boolean _loadHotstart;
    private String _loadAltName;
    private String _srcDir;
    private boolean _saveAtDateTime;
    private HecTime _saveAtDate = new HecTime();
    private boolean _saveAtLookback;

    public HotstartOptions() {
        this._saveAtDate.showTimeAsBeginningOfDay(true);
        this._intervalDateTime = new HecTime();
        this._intervalDateTime.showTimeAsBeginningOfDay(true);
    }

    @Scriptable
    public boolean shouldCreateHotstart() {
        return this._createHotstart;
    }

    @Scriptable
    public void setCreateHotstart(boolean bl) {
        this._createHotstart = bl;
    }

    @Scriptable
    public boolean shouldSaveAtEndofSim() {
        return this._saveAtEndofSim;
    }

    @Scriptable
    public void setSaveAtEndofSim(boolean bl) {
        this._saveAtEndofSim = bl;
    }

    @Scriptable
    public boolean shouldSaveAtInterval() {
        return this._saveAtInterval;
    }

    @Scriptable
    public void setSaveAtInterval(boolean bl) {
        this._saveAtInterval = bl;
    }

    public void setIntervalDateTime(HecTime hecTime) {
        this._intervalDateTime.set(hecTime);
    }

    public HecTime getIntervalDateTime() {
        return this._intervalDateTime;
    }

    @Scriptable
    public int getTimeStep() {
        return this._timeStep;
    }

    @Scriptable
    public void setTimeStep(int n) {
        this._timeStep = n;
    }

    @Scriptable
    public int getTimeIncrement() {
        return this._timeIncrement;
    }

    @Scriptable
    public void setTimeIncrement(int n) {
        this._timeIncrement = n;
    }

    public String getDestDir() {
        return this._destDir;
    }

    public void setDestDir(String string) {
        this._destDir = string;
    }

    @Scriptable
    public double getHoursToSave() {
        return this._hoursToSave;
    }

    public void setHoursToSave(double d) {
        this._hoursToSave = d;
    }

    public boolean shouldLoadHotstart() {
        return this._loadHotstart;
    }

    public void setLoadHotstart(boolean bl) {
        this._loadHotstart = bl;
    }

    public String getLoadAltName() {
        return this._loadAltName;
    }

    public void setLoadAltName(String string) {
        this._loadAltName = string;
    }

    public void setSaveAtDateTime(boolean bl) {
        this._saveAtDateTime = bl;
    }

    public boolean shouldSaveAtDateTime() {
        return this._saveAtDateTime;
    }

    public void setSaveAtDateTime(HecTime hecTime) {
        this._saveAtDate.set(hecTime);
    }

    public HecTime getSaveAtDateTime() {
        return this._saveAtDate;
    }

    public boolean shouldSaveAtLookback() {
        return this._saveAtLookback;
    }

    public void setSaveAtLookback(boolean bl) {
        this._saveAtLookback = bl;
    }

    public boolean writeData(BufferedWriter bufferedWriter) throws IOException {
        if (bufferedWriter == null) {
            return false;
        }
        bufferedWriter.write("Hotstart Options");
        bufferedWriter.newLine();
        bufferedWriter.write("Enabled:");
        bufferedWriter.write(String.valueOf(this._enabled));
        bufferedWriter.newLine();
        bufferedWriter.write("CreateHotStart:");
        bufferedWriter.write(String.valueOf(this._createHotstart));
        bufferedWriter.newLine();
        bufferedWriter.write("SaveAtEnd:");
        bufferedWriter.write(String.valueOf(this._saveAtEndofSim));
        bufferedWriter.newLine();
        bufferedWriter.write("SaveAtLookback:");
        bufferedWriter.write(String.valueOf(this._saveAtLookback));
        bufferedWriter.newLine();
        bufferedWriter.write("SaveAtInterval:");
        bufferedWriter.write(String.valueOf(this._saveAtInterval));
        bufferedWriter.newLine();
        bufferedWriter.write("IntervalDateTime:");
        bufferedWriter.write(String.valueOf(this._intervalDateTime));
        bufferedWriter.newLine();
        bufferedWriter.write("TimeStep:");
        bufferedWriter.write(String.valueOf(this._timeStep));
        bufferedWriter.newLine();
        bufferedWriter.write("TimeIncrement:");
        bufferedWriter.write(String.valueOf(this._timeIncrement));
        bufferedWriter.newLine();
        bufferedWriter.write("SaveAtDateTime:");
        bufferedWriter.write(String.valueOf(this._saveAtDateTime));
        bufferedWriter.newLine();
        if (this._saveAtDate.isDefined()) {
            bufferedWriter.write("SaveAtDate:");
            bufferedWriter.write(this._saveAtDate.dateAndTime());
            bufferedWriter.newLine();
        }
        if (this._destDir != null) {
            bufferedWriter.write("DestDir:" + this._destDir);
            bufferedWriter.newLine();
        }
        bufferedWriter.write("TimeStepsToSave:");
        bufferedWriter.write(String.valueOf(this._hoursToSave));
        bufferedWriter.newLine();
        bufferedWriter.write("LoadHotstart:");
        bufferedWriter.write(String.valueOf(this._loadHotstart));
        bufferedWriter.newLine();
        if (this._loadAltName != null) {
            bufferedWriter.write("AltName:");
            bufferedWriter.write(this._loadAltName);
            bufferedWriter.newLine();
        }
        if (this._srcDir != null) {
            bufferedWriter.write("SrcDir:");
            bufferedWriter.write(this._srcDir);
            bufferedWriter.newLine();
        }
        bufferedWriter.write("Hotstart End");
        bufferedWriter.newLine();
        return true;
    }

    public boolean loadData(BufferedReader bufferedReader) throws IOException {
        String string;
        if (bufferedReader == null) {
            return false;
        }
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            if ("Hotstart End".equalsIgnoreCase(string = string.trim())) {
                if (!bl) {
                    this._enabled = this._createHotstart || this._loadHotstart;
                }
                return true;
            }
            String string2 = RMAIO.getType((String)string, (String)":");
            string = RMAIO.getParam((String)string, (String)":");
            if ("Enabled".equalsIgnoreCase(string2)) {
                this._enabled = Boolean.parseBoolean(string);
                bl = true;
                continue;
            }
            if ("CreateHotStart".equalsIgnoreCase(string2)) {
                this._createHotstart = Boolean.parseBoolean(string);
                continue;
            }
            if ("SaveAtEnd".equalsIgnoreCase(string2)) {
                this._saveAtEndofSim = Boolean.parseBoolean(string);
                continue;
            }
            if ("SaveAtLookback".equalsIgnoreCase(string2)) {
                this._saveAtLookback = Boolean.parseBoolean(string);
                continue;
            }
            if ("SaveAtInterval".equalsIgnoreCase(string2)) {
                this._saveAtInterval = Boolean.parseBoolean(string);
                continue;
            }
            if ("IntervalDateTime".equalsIgnoreCase(string2)) {
                this._intervalDateTime.set(string);
                continue;
            }
            if ("TimeStep".equalsIgnoreCase(string2)) {
                this._timeStep = RMAIO.parseInt((String)string);
                continue;
            }
            if ("TimeIncrement".equalsIgnoreCase(string2)) {
                this._timeIncrement = RMAIO.parseInt((String)string);
                continue;
            }
            if ("DestDir".equalsIgnoreCase(string2)) {
                this._destDir = string;
                continue;
            }
            if ("TimeStepsToSave".equalsIgnoreCase(string2)) {
                this._hoursToSave = RMAIO.parseDouble((String)string);
                continue;
            }
            if ("LoadHotstart".equalsIgnoreCase(string2)) {
                this._loadHotstart = Boolean.parseBoolean(string);
                continue;
            }
            if ("AltName".equalsIgnoreCase(string2)) {
                this._loadAltName = string;
                continue;
            }
            if ("SrcDir".equalsIgnoreCase(string2)) {
                this._srcDir = string;
                continue;
            }
            if ("SaveAtDateTime".equalsIgnoreCase(string2)) {
                this._saveAtDateTime = Boolean.parseBoolean(string);
                continue;
            }
            if (!"SaveAtDate".equalsIgnoreCase(string2)) continue;
            this._saveAtDate.set(string);
        }
        if (!bl) {
            this._enabled = this._createHotstart || this._loadHotstart;
        }
        return true;
    }

    public HotstartOptions clone() {
        try {
            HotstartOptions hotstartOptions = (HotstartOptions)super.clone();
            ((HotstartOptions)super.clone())._saveAtDate = new HecTime();
            hotstartOptions._saveAtDate.set(this._saveAtDate);
            hotstartOptions._intervalDateTime = new HecTime();
            hotstartOptions._intervalDateTime.set(this._intervalDateTime);
            return hotstartOptions;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("clone: Exception cloning HotstartOptions " + String.valueOf(cloneNotSupportedException));
            return null;
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, Element element) {
        element.setAttribute("HotStart_Enabled", Boolean.toString(this._enabled));
        element.setAttribute("Create_Hotstart_File", Boolean.toString(this._createHotstart));
        element.setAttribute("Number_of_Hours_to_Save", Double.toString(this._hoursToSave));
        element.setAttribute("Save_at_State_of_Simulation", Boolean.toString(this._saveAtLookback));
        element.setAttribute("Save_at_End_of_Simulation", Boolean.toString(this._saveAtEndofSim));
        element.setAttribute("Save_at_Data_Time", Boolean.toString(this._saveAtDateTime));
        element.setAttribute("Date", this._saveAtDate.toString(4));
        element.setAttribute("Save_at_Interval", Boolean.toString(this._saveAtInterval));
        element.setAttribute("Interval", Integer.toString(this._timeIncrement));
        element.setAttribute("Interval_Date_Time", this._intervalDateTime.toString(4));
        element.setAttribute("Load_Hotstart_File", Boolean.toString(this._loadHotstart));
        if (this.getLoadAltName() != null) {
            element.setAttribute("Alternative_Name", this.getLoadAltName());
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean bl) {
        this._enabled = bl;
    }
}

