/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.heclib.util.doubleArrayContainer;
import hec.io.AsciiSerializable;
import hec.io.TimeSeriesContainer;
import hec.model.ModelVariable;
import hec.model.RunTimeStep;
import hec.rss.model.DiversionRule;
import hec.rss.model.Element;
import hec.rss.model.OpSet;
import hec.rss.model.ReleaseFuncOpRule;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.StateVariable;
import hec.rss.model.StorageZone;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.TimeSeriesGlobalVariable;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Content;
import rma.util.RMAConst;

public class IndependentVariable
implements AsciiSerializable,
AltInputReportInfc,
Cloneable {
    public static final int DATE_TYPE = 0;
    public static final int DATE_TIME_TYPE = 1;
    public static final int MODEL_VARIABLE_TYPE = 2;
    public static final int TIME_SERIES_TYPE = 3;
    public static final int STATE_VARIABLE_TYPE = 4;
    public static final int TWO_VARIABLE_TYPE = 5;
    public static final int GLOBAL_VARIABLE_TYPE = 6;
    public static final String[] TS_FUNCTION_STRINGS = new String[]{"Current Value", "Previous Value", "Offset Value", "Period Average", "Period Maximum", "Period Minimum"};
    public static final int TS_CURRENT_TYPE = 0;
    public static final int TS_PREVIOUS_TYPE = 1;
    public static final int TS_LAGGED_TYPE = 2;
    public static final int TS_PERAVG_TYPE = 3;
    public static final int TS_PERMAX_TYPE = 4;
    public static final int TS_PERMIN_TYPE = 5;
    private int _type = 0;
    private int _modelVariableId;
    private int _elementIndex = Integer.MIN_VALUE;
    private String _tsproxyName = null;
    private String _tsName = "";
    private int _tsOptFunctionType = 1;
    private double _tsOptLag;
    private double _tsOptPeriod;
    private boolean _tsOptChecked;
    private transient String a;
    private int _stateVariableIndex;
    private String _stateVariableName;
    private int _globalVariableIndex;
    private String _globalVariableName;
    private transient String b;
    private IndependentVariable _rowVar;
    private IndependentVariable _colVar;
    private String _rowVarInterpType;
    private String _colVarInterpType;
    private transient doubleArrayContainer c;
    private String[] _twoVariableColumnValues;

    public IndependentVariable(int n) {
        this._type = n;
    }

    public IndependentVariable() {
    }

    public void getElementDependencies(List<Element> list, Element element) {
        if (list == null || element == null) {
            return;
        }
        RssSystem rssSystem = element.getSystem();
        if (this.getType() == 2) {
            Element element2 = rssSystem.getElement(this.getElementId());
            if (element2 != null && (element2 = element2.getTopParent()) != element && !list.contains(element2)) {
                list.add(element2);
            }
            return;
        }
        if (this.getType() == 5) {
            Element element3 = rssSystem.getElement(this.getRowVariable().getElementId());
            if (element3 != null && (element3 = element3.getTopParent()) != element && !list.contains(element3)) {
                list.add(element3);
            }
            if ((element3 = rssSystem.getElement(this.getColVariable().getElementId())) != null && (element3 = element3.getTopParent()) != element && !list.contains(element3)) {
                list.add(element3);
            }
        }
    }

    public double evaluateTSFunction(RunTimeStep runTimeStep) {
        if (this.c == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.evaluateTSFunction(runTimeStep, this.c.array);
    }

    public double evaluateTSFunction(RunTimeStep runTimeStep, double[] dArray) {
        if (runTimeStep == null || dArray == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (runTimeStep.step >= dArray.length) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._tsOptChecked) {
            this._tsOptFunctionType = 0;
        }
        int n = 0;
        if (this._tsOptFunctionType >= 2) {
            n = (int)(this._tsOptLag * 3600.0 / (double)runTimeStep.getTimeStepSeconds());
        }
        int n2 = 1;
        if (this._tsOptFunctionType >= 3 && (n2 = (int)(this._tsOptPeriod * 3600.0 / (double)runTimeStep.getTimeStepSeconds())) <= 0) {
            n2 = 1;
        }
        int n3 = runTimeStep.getTotalNumSteps();
        int n4 = runTimeStep.step - n;
        if (n4 < 0) {
            n4 = 0;
        }
        if (n4 > n3) {
            n4 = n3;
        }
        while (n4 > 0 && !RMAConst.isValidValue((double)dArray[n4])) {
            --n4;
        }
        switch (this._tsOptFunctionType) {
            case 0: {
                return dArray[runTimeStep.step];
            }
            case 1: {
                int n5 = runTimeStep.step - 1;
                if (n5 < 0) {
                    n5 = 0;
                }
                if (n5 > n4) {
                    n5 = n4;
                }
                return dArray[n5];
            }
            case 2: {
                int n6 = runTimeStep.step - n;
                if (n6 < 0) {
                    n6 = 0;
                }
                if (n6 > n4) {
                    n6 = n4;
                }
                return dArray[n6];
            }
            case 3: {
                double d = 0.0;
                for (int i = 0; i < n2; ++i) {
                    n3 = runTimeStep.step - (n + i);
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    if (n3 > n4) {
                        n3 = n4;
                    }
                    d += dArray[n3];
                }
                double d2 = d / (double)n2;
                return d2;
            }
            case 4: {
                double d = Double.MIN_VALUE;
                for (int i = 0; i < n2; ++i) {
                    int n7 = runTimeStep.step - (n + i);
                    if (n7 < 0) {
                        n7 = 0;
                    }
                    if (n7 > n4) {
                        n7 = n4;
                    }
                    if (!(d < dArray[n7])) continue;
                    d = dArray[n7];
                }
                if (d == Double.MIN_VALUE) {
                    d = Double.NEGATIVE_INFINITY;
                }
                return d;
            }
            case 5: {
                double d = Double.MAX_VALUE;
                for (int i = 0; i < n2; ++i) {
                    int n8 = runTimeStep.step - (n + i);
                    if (n8 < 0) {
                        n8 = 0;
                    }
                    if (n8 > n4) {
                        n8 = n4;
                    }
                    if (!(d > dArray[n8])) continue;
                    d = dArray[n8];
                }
                if (d == Double.MAX_VALUE) {
                    d = Double.NEGATIVE_INFINITY;
                }
                return d;
            }
        }
        return Double.NEGATIVE_INFINITY;
    }

    public boolean initializeCompute(RssSystem rssSystem, RssTSLocationObject rssTSLocationObject) {
        if (this.getType() == 5) {
            IndependentVariable independentVariable = this.getRowVariable();
            IndependentVariable independentVariable2 = this.getColVariable();
            if (independentVariable != null) {
                IndependentVariable.a(independentVariable, rssSystem, rssTSLocationObject);
            }
            if (independentVariable2 != null) {
                IndependentVariable.a(independentVariable2, rssSystem, rssTSLocationObject);
            }
        } else {
            return IndependentVariable.a(this, rssSystem, rssTSLocationObject);
        }
        return true;
    }

    public static boolean a(IndependentVariable independentVariable, RssSystem rssSystem, RssTSLocationObject rssTSLocationObject) {
        switch (independentVariable.getType()) {
            case 2: {
                TSRecordProxy tSRecordProxy = rssSystem.getTSRecordProxy(independentVariable.getTSProxyName(), independentVariable.getModelVariableId());
                if (tSRecordProxy == null && rssSystem.getComputeType() == 0) {
                    rssSystem.printErrorMessage("IndependentVariable.initializeCompute(Type=MODEL_VARIABLE_TYPE ): failed to find TSRecordProxy");
                    return false;
                }
                if (tSRecordProxy != null) {
                    independentVariable.c = tSRecordProxy.getTSContainer();
                }
                if (independentVariable.c != null || rssSystem.getComputeType() != 0) break;
                rssSystem.printErrorMessage("IndependentVariable.initializeCompute(Type=MODEL_VARIABLE_TYPE ): failed to find Model Variable Time Series");
                return false;
            }
            case 3: {
                String string = independentVariable.getTimeSeriesName();
                if (string == null) {
                    rssSystem.printErrorMessage("IndependentVariable.initializeCompute:(Type=TIME_SERIES_TYPE ) external time series name is null");
                    return false;
                }
                boolean cfr_ignored_0 = rssTSLocationObject instanceof OpSet;
                independentVariable.c = rssTSLocationObject.getTSContainer(string, 85);
                if (independentVariable.c != null) break;
                rssSystem.printErrorMessage("IndependentVariable.initializeCompute:(Type=TIME_SERIES_TYPE) failed to find Time Series");
                return false;
            }
            case 4: {
                int n = independentVariable.getStateVariableId();
                rssTSLocationObject = rssSystem.getStateVariable(n);
                if (rssTSLocationObject == null) {
                    rssTSLocationObject = rssSystem.getStateVariable(independentVariable.getStateVariableName());
                }
                if (rssTSLocationObject == null) {
                    rssSystem.printErrorMessage("IndependentVariable.initializeCompute:(Type=STATE_VARIABLE_TYPE) failed to find State Variable => " + independentVariable.getStateVariableName());
                    return false;
                }
                independentVariable.c = rssTSLocationObject.getTSContainer(97);
                if (independentVariable.c != null || rssSystem.getComputeType() != 0) break;
                rssSystem.printErrorMessage("IndependentVariable.initializeCompute:(Type=STATE_VARIABLE_TYP) failed to find State Variable Time Series  State Variable => " + rssTSLocationObject.getName());
                return false;
            }
            case 6: {
                int n = independentVariable.getGlobalVariableId();
                GlobalVariable globalVariable = rssSystem.getGlobalVariable(n);
                if (globalVariable == null) {
                    globalVariable = rssSystem.getGlobalVariable(independentVariable.getGlobalVariableName());
                }
                if (!(globalVariable instanceof TimeSeriesGlobalVariable)) {
                    rssSystem.printErrorMessage("IndependentVariable.initializeCompute:(Type=GLOBAL_VARIABLE_TYPE) failed to find Time Series Global Variable => " + independentVariable.getStateVariableName());
                    return false;
                }
                TimeSeriesContainer timeSeriesContainer = ((TimeSeriesGlobalVariable)(globalVariable = (TimeSeriesGlobalVariable)globalVariable)).getTimeSeriesContainer();
                if (timeSeriesContainer == null) {
                    rssSystem.printErrorMessage("IndependentVariable.initializeCompute:(Type=GLOBAL_VARIABLE_TYPE) failed to find Globat Variable Time Series  Global Variable => " + globalVariable.getName());
                    return false;
                }
                independentVariable.c = new doubleArrayContainer(timeSeriesContainer.values);
                if (independentVariable.c != null || rssSystem.getComputeType() != 0) break;
                rssSystem.printErrorMessage("IndependentVariable.initializeCompute:(Type=GLOBAL_VARIABLE_TYPE) failed to find Globat Variable Time Series values  Global Variable => " + globalVariable.getName());
                return false;
            }
        }
        return true;
    }

    public String getTSProxyName() {
        return this._tsproxyName;
    }

    public int[] getModelVariableElementIds() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this._type == 5) {
            if (this._rowVar.getType() == 2) {
                arrayList.add(this._rowVar.getElementId());
            }
            if (this._colVar.getType() == 2) {
                arrayList.add(this._colVar.getElementId());
            }
        } else if (this._type == 2) {
            arrayList.add(this.getElementId());
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return nArray;
    }

    public void setModalVariableInfo(TSRecordProxy tSRecordProxy, Element element, ModelVariable modelVariable) {
        if (this._type != 2) {
            throw new IllegalStateException("Can only set ModelVariable Information for ModelVariable Type");
        }
        if (tSRecordProxy != null) {
            this._tsproxyName = tSRecordProxy.getName();
        }
        this._elementIndex = element != null ? element.getIndex() : -1;
        if (modelVariable != null) {
            this._modelVariableId = modelVariable.getType();
            return;
        }
        this._modelVariableId = -1;
    }

    void setModalVariableInfo(String string, int n, ModelVariable modelVariable) {
        if (this._type != 2) {
            throw new IllegalStateException("Can only set ModelVariable Information for ModelVariable Type");
        }
        this._tsproxyName = string;
        this._elementIndex = n;
        this._modelVariableId = modelVariable.getType();
    }

    public void setTimeSeriesName(String string) {
        if (this._type != 3) {
            throw new IllegalStateException("Can only set TimeSeries Name for TimeSeries Type");
        }
        this._tsName = string;
    }

    public void setTimeSeriesOptions(int n, double d, double d2) {
        if (this._type == 2 || this._type == 3 || this._type == 4 || this._type == 6) {
            this._tsOptFunctionType = n;
            this._tsOptLag = d;
            this._tsOptPeriod = d2;
            return;
        }
        throw new IllegalStateException("Can only set TimeSeries Options for ModelVariable, TimeSeries, State Variable or Global Variable Types. Current Type is " + this._type);
    }

    public void setTimeSeriesOptions(boolean bl) {
        if (this._type == 2 || this._type == 3 || this._type == 4 || this._type == 6) {
            this._tsOptChecked = bl;
            return;
        }
        throw new IllegalStateException("Can only set TimeSeries Options for ModelVariable, TimeSeries, State Variable or Global Variable Types. Current Type is " + this._type);
    }

    public String getTimeSeriesName() {
        return this._tsName;
    }

    public String getTimeSeriesFunction() {
        return TS_FUNCTION_STRINGS[this._tsOptFunctionType];
    }

    public double getTimeSeriesLag() {
        return this._tsOptLag;
    }

    public double getDisplayOnlyTimeSeriesLag() {
        return -1.0 * this._tsOptLag;
    }

    public void setTimeSeriesLag(double d) {
        this._tsOptLag = d;
    }

    public double getTimeSeriesPeriod() {
        return this._tsOptPeriod;
    }

    public void setTimeSeriesPeriod(double d) {
        this._tsOptPeriod = d;
    }

    public int getType() {
        return this._type;
    }

    public int getElementId() {
        return this._elementIndex;
    }

    public int getModelVariableId() {
        return this._modelVariableId;
    }

    public ModelVariable getModelVariable() {
        return RssModelVariableSet.getModelVariable(this._modelVariableId);
    }

    public int getStateVariableId() {
        return this._stateVariableIndex;
    }

    public String getStateVariableName() {
        return this._stateVariableName;
    }

    public int getGlobalVariableId() {
        return this._globalVariableIndex;
    }

    public String getGlobalVariableName() {
        return this._globalVariableName;
    }

    public String getTwoVariableName() {
        if (this._rowVar == null || this._colVar == null) {
            return null;
        }
        if (this.b == null) {
            this.b = this._rowVar.toString() + " -vs- " + this._colVar.toString();
        }
        return this.b;
    }

    public void setStateVariable(StateVariable stateVariable) {
        if (this._type != 4) {
            throw new IllegalStateException("Can only set StateVariable Information for StateVariable Type");
        }
        if (stateVariable == null) {
            this._stateVariableIndex = -1;
            return;
        }
        this._stateVariableIndex = stateVariable.getIndex();
        this._stateVariableName = stateVariable.getName();
    }

    public void setGlobalVariable(GlobalVariable globalVariable) {
        if (this._type != 6) {
            throw new IllegalStateException("Can only set GlobalVariable Information for GlobalVariable Type");
        }
        if (globalVariable == null) {
            this._globalVariableIndex = -1;
            return;
        }
        this._globalVariableIndex = globalVariable.getIndex();
        this._globalVariableName = globalVariable.getName();
    }

    public void setTwoVariableRule(IndependentVariable independentVariable, IndependentVariable independentVariable2) {
        if (this._type != 5) {
            throw new IllegalStateException("Can only set Two Variable Rule Information for TwoVariableRule Type");
        }
        if (independentVariable == null || independentVariable2 == null) {
            return;
        }
        this._rowVar = independentVariable;
        this._colVar = independentVariable2;
        this.b = this._rowVar.toString() + " -vs- " + this._colVar.toString();
    }

    public IndependentVariable getRowVariable() {
        if (this._type != 5) {
            throw new IllegalStateException("Can only set Two Variable Rule Information for TwoVariableRule Type");
        }
        if (this._rowVar == null) {
            return new IndependentVariable();
        }
        return this._rowVar;
    }

    public IndependentVariable getColVariable() {
        if (this._type != 5) {
            throw new IllegalStateException("Can only set Two Variable Rule Information for TwoVariableRule Type");
        }
        if (this._colVar == null) {
            return new IndependentVariable(2);
        }
        return this._colVar;
    }

    public boolean areTheSame(IndependentVariable independentVariable) {
        if (independentVariable == null) {
            return false;
        }
        if (this._type == 2 && this._type == independentVariable.getType()) {
            return this.getModelVariable().getParamId() == independentVariable.getModelVariable().getParamId() && this.getElementId() == independentVariable.getElementId();
        }
        if (this._type == 3 && this._type == independentVariable.getType()) {
            return this._tsName.equals(independentVariable.getTimeSeriesName());
        }
        if (this._type == 4) {
            return this.getStateVariableName().equals(independentVariable.getStateVariableName());
        }
        if (this._type == 6) {
            return this.getGlobalVariableName().equals(independentVariable.getGlobalVariableName());
        }
        return this._type == independentVariable.getType();
    }

    public boolean timeSeriesOptionsAreTheSame(IndependentVariable independentVariable) {
        if (independentVariable == null) {
            return false;
        }
        if (independentVariable.getTimeSeriesLag() != this.getTimeSeriesLag()) {
            return false;
        }
        if (!independentVariable.getTimeSeriesFunction().equals(this.getTimeSeriesFunction())) {
            return false;
        }
        return independentVariable.getTimeSeriesPeriod() == this.getTimeSeriesPeriod();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("IndependentVariable.clone: Exception in clone() " + String.valueOf(cloneNotSupportedException));
            return null;
        }
    }

    public String buildFunctionOfString(ReleaseFuncOpRule rssReturnStatusConstants) {
        int n = this.getType();
        if (n == 0) {
            return "Date";
        }
        if (n == 1) {
            return "Date and Time";
        }
        if (n != 2 && n != 3 && n != 4 && n != 6) {
            return "Function Not Defined";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 3) {
            stringBuffer.append(this.getTimeSeriesName());
            if (this._tsOptChecked) {
                return stringBuffer.toString();
            }
        } else if (n == 2) {
            String string = "";
            if (rssReturnStatusConstants != null && rssReturnStatusConstants.getRssSystem() != null) {
                rssReturnStatusConstants = rssReturnStatusConstants.getRssSystem();
                string = ((RssSystem)rssReturnStatusConstants).getNameForKeyString(this.getTSProxyName());
            }
            stringBuffer.append(string);
            stringBuffer.append(" " + this.getModelVariable().getName());
        } else if (n == 4) {
            StateVariable stateVariable = rssReturnStatusConstants.getRssSystem().getStateVariable(this._stateVariableIndex);
            if (stateVariable != null) {
                stringBuffer.append(stateVariable.getName());
            } else {
                stringBuffer.append(this._stateVariableName);
            }
        } else {
            GlobalVariable globalVariable = rssReturnStatusConstants.getRssSystem().getGlobalVariable(this._globalVariableIndex);
            if (globalVariable != null) {
                stringBuffer.append(globalVariable.getName());
            } else {
                stringBuffer.append(this._globalVariableName);
            }
        }
        String string = this.getTimeSeriesFunction();
        stringBuffer.append(", " + string);
        if (string != null && (string.indexOf("Lagged") >= 0 || string.indexOf("Period") >= 0)) {
            stringBuffer.append(", " + this.getDisplayOnlyTimeSeriesLag() + " hr offset");
        }
        if (string != null && string.indexOf("Period") >= 0) {
            stringBuffer.append(", " + this.getTimeSeriesPeriod() + " hr period");
        }
        return stringBuffer.toString();
    }

    public String buildFunctionOfString(DiversionRule rssReturnStatusConstants) {
        int n = this.getType();
        if (n == 0) {
            return "Date";
        }
        if (n == 1) {
            return "Date and Time";
        }
        if (n != 2 && n != 3 && n != 4 && n != 6) {
            return "Function Not Defined";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 3) {
            stringBuffer.append(this.getTimeSeriesName());
        } else if (n == 2) {
            String string = "";
            if (rssReturnStatusConstants != null && ((RssTSLocationObject)rssReturnStatusConstants).getSystem() != null) {
                rssReturnStatusConstants = ((RssTSLocationObject)rssReturnStatusConstants).getSystem();
                string = ((RssSystem)rssReturnStatusConstants).getNameForKeyString(this.getTSProxyName());
            }
            stringBuffer.append(string);
            stringBuffer.append(" " + this.getModelVariable().getName());
        } else if (n == 4) {
            StateVariable stateVariable = ((RssTSLocationObject)rssReturnStatusConstants).getSystem().getStateVariable(this._stateVariableIndex);
            if (stateVariable != null) {
                stringBuffer.append(stateVariable.getName());
            } else {
                stringBuffer.append(this._stateVariableName);
            }
        } else {
            GlobalVariable globalVariable = ((RssTSLocationObject)rssReturnStatusConstants).getSystem().getGlobalVariable(this._globalVariableIndex);
            if (globalVariable != null) {
                stringBuffer.append(globalVariable.getName());
            } else {
                stringBuffer.append(this._globalVariableName);
            }
        }
        String string = this.getTimeSeriesFunction();
        stringBuffer.append(", " + string);
        if (string != null && (string.indexOf("Lagged") >= 0 || string.indexOf("Period") >= 0)) {
            stringBuffer.append(", " + this.getDisplayOnlyTimeSeriesLag() + " hr offset");
        }
        if (string != null && string.indexOf("Period") >= 0) {
            stringBuffer.append(", " + this.getTimeSeriesPeriod() + " hr period");
        }
        return stringBuffer.toString();
    }

    public String buildFunctionOfString(StorageZone object) {
        Object object2;
        int n = this.getType();
        if (n == 0) {
            return "Date";
        }
        if (n == 1) {
            return "Date and Time";
        }
        if (n != 2 && n != 3 && n != 4 && n != 5 && n != 6) {
            return "Function Not Defined";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 3) {
            if (!this.getTimeSeriesName().isEmpty()) {
                stringBuffer.append(this.getTimeSeriesName());
                if (this._tsOptChecked) {
                    return stringBuffer.toString();
                }
            } else {
                stringBuffer.append("External Variable");
            }
        } else if (n == 5) {
            if (this.getRowVariable() != null && this.getColVariable() != null) {
                stringBuffer.append(this.getTwoVariableName());
            }
        } else if (n == 2) {
            object2 = "";
            if (object != null && ((StorageZone)object).getSystem() != null) {
                object = ((StorageZone)object).getSystem();
                object2 = ((RssSystem)object).getNameForKeyString(this.getTSProxyName());
            }
            stringBuffer.append((String)object2);
            stringBuffer.append(" " + this.getModelVariable().getName());
        } else if (n == 4) {
            object2 = ((StorageZone)object).getSystem().getStateVariable(this._stateVariableIndex);
            if (object2 != null) {
                stringBuffer.append(object2.getName());
            } else {
                stringBuffer.append(this._stateVariableName);
            }
        } else {
            object2 = ((StorageZone)object).getSystem().getGlobalVariable(this._globalVariableIndex);
            if (object2 != null) {
                stringBuffer.append(object2.getName());
            } else {
                stringBuffer.append(this._globalVariableName);
            }
        }
        if ((object2 = this.getTimeSeriesFunction()) != null && n != 3 && n != 5) {
            stringBuffer.append(", " + (String)object2);
        } else if (object2 != null && n == 3 && !this.getTimeSeriesName().isEmpty()) {
            stringBuffer.append(", " + (String)object2);
        }
        if (object2 != null && (((String)object2).indexOf("Lagged") >= 0 || ((String)object2).indexOf("Period") >= 0)) {
            stringBuffer.append(", " + this.getDisplayOnlyTimeSeriesLag() + " hr offset");
        }
        if (object2 != null && ((String)object2).indexOf("Period") >= 0) {
            stringBuffer.append(", " + this.getTimeSeriesPeriod() + " hr period");
        }
        return stringBuffer.toString();
    }

    public String buildFunctionOfString(RssSystem rssSystem) {
        Object object;
        int n = this.getType();
        if (n == 0) {
            return "Date";
        }
        if (n == 1) {
            return "Date and Time";
        }
        if (n != 2 && n != 3 && n != 4 && n != 6 && n != 5) {
            return "Function Not Defined";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 3) {
            if (!this.getTimeSeriesName().isEmpty()) {
                stringBuffer.append(this.getTimeSeriesName());
                if (this._tsOptChecked) {
                    return stringBuffer.toString();
                }
            } else {
                stringBuffer.append("External Variable");
            }
        } else if (n == 5) {
            if (this.getRowVariable() != null && this.getColVariable() != null) {
                stringBuffer.append(this.getTwoVariableName());
            }
        } else if (n == 2) {
            object = "";
            if (rssSystem != null) {
                object = rssSystem.getNameForKeyString(this.getTSProxyName());
            }
            stringBuffer.append((String)object);
            stringBuffer.append(" " + this.getModelVariable().getName());
        } else if (n == 4) {
            object = null;
            if (rssSystem != null) {
                object = rssSystem.getStateVariable(this._stateVariableIndex);
            }
            if (object != null) {
                stringBuffer.append(object.getName());
            } else {
                stringBuffer.append(this._stateVariableName);
            }
        } else {
            object = null;
            if (rssSystem != null) {
                object = rssSystem.getGlobalVariable(this._globalVariableIndex);
            }
            if (object != null) {
                stringBuffer.append(object.getName());
            } else {
                stringBuffer.append(this._globalVariableName);
            }
        }
        if ((object = this.getTimeSeriesFunction()) != null && n != 3 && n != 5) {
            stringBuffer.append(", " + (String)object);
        } else if (object != null && n == 3 && !this.getTimeSeriesName().isEmpty()) {
            stringBuffer.append(", " + (String)object);
        }
        if (object != null && (((String)object).indexOf("Lagged") >= 0 || ((String)object).indexOf("Period") >= 0)) {
            stringBuffer.append(", " + this.getDisplayOnlyTimeSeriesLag() + " hr offset");
        }
        if (object != null && ((String)object).indexOf("Period") >= 0) {
            stringBuffer.append(", " + this.getTimeSeriesPeriod() + " hr period");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        switch (this._type) {
            case 0: {
                return "Date";
            }
            case 1: {
                return "Date Time";
            }
            case 3: {
                return this.getTimeSeriesName();
            }
            case 2: {
                if (this.a == null) {
                    return "Model Variable " + String.valueOf(this.getModelVariable());
                }
                return this.a;
            }
            case 4: {
                if ("State Variable " + this._stateVariableName != null) {
                    return this._stateVariableName;
                }
                return "not defined";
            }
            case 6: {
                if ("Global Variable " + this._globalVariableName != null) {
                    return this._globalVariableName;
                }
                return "not defined";
            }
            case 5: {
                if ("Two Variable " + this.b != null) {
                    return this.b;
                }
                return "not defined";
            }
        }
        return "Function not Defined";
    }

    public void setModelVariableString(String string) {
        this.a = string;
    }

    public Object getFieldObject(Field object) {
        try {
            object = ((Field)object).get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public boolean isTSOptChecked() {
        return this._tsOptChecked;
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public void setTwoVariableColumnValues(String[] stringArray) {
        this._twoVariableColumnValues = stringArray;
    }

    public String[] getTwoVariableColumnValues() {
        return this._twoVariableColumnValues;
    }

    public void setRowVariableInterpType(String string) {
        this._rowVarInterpType = string;
    }

    public void setColVariableInterpType(String string) {
        this._colVarInterpType = string;
    }

    public String getRowVariableInterpType() {
        return this._rowVarInterpType;
    }

    public String getColVariableInterpType() {
        return this._colVarInterpType;
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        element.setAttribute("Function_Of", Integer.toString(this._type));
        if (this._type == 2) {
            element.setAttribute("ModelVariable", this.getModelVariable().getName());
            element.setAttribute("TimeSeries_Options", Integer.toString(this._tsOptFunctionType));
            element.setAttribute("Offset", Double.toString(this._tsOptLag));
            element.setAttribute("Period", Double.toString(this._tsOptPeriod));
        } else if (this._type == 3) {
            element.setAttribute("ExternalVariable", this._tsName);
            element.setAttribute("TimeSeries_Options", Integer.toString(this._tsOptFunctionType));
            element.setAttribute("Offset", Double.toString(this._tsOptLag));
            element.setAttribute("Period", Double.toString(this._tsOptPeriod));
        } else if (this._type == 4) {
            element.setAttribute("StateVariable", this._stateVariableName);
            element.setAttribute("TimeSeries_Options", Integer.toString(this._tsOptFunctionType));
            element.setAttribute("Offset", Double.toString(this._tsOptLag));
            element.setAttribute("Period", Double.toString(this._tsOptPeriod));
        } else if (this._type == 6) {
            element.setAttribute("GlobalVariable", this._globalVariableName);
            element.setAttribute("TimeSeries_Options", Integer.toString(this._tsOptFunctionType));
            element.setAttribute("Offset", Double.toString(this._tsOptLag));
            element.setAttribute("Period", Double.toString(this._tsOptPeriod));
        } else if (this._type == 5) {
            IndependentVariable independentVariable;
            IndependentVariable independentVariable2 = this.getRowVariable();
            if (independentVariable2 != null) {
                independentVariable = new org.jdom.Element("RowVariable");
                element.addContent((Content)independentVariable);
                independentVariable2.outputReport(alternativeInputReport, (org.jdom.Element)independentVariable);
            }
            if ((independentVariable = this.getColVariable()) != null) {
                independentVariable = new org.jdom.Element("ColVariable");
                element.addContent((Content)independentVariable);
                independentVariable2.outputReport(alternativeInputReport, (org.jdom.Element)independentVariable);
            }
        }
        if (this._tsOptChecked) {
            element.setAttribute("Define_Zone_With_Time_Series", Boolean.toString(this._tsOptChecked));
        }
    }
}

