/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.model.TSRecordProxy;
import hec.data.Parameter;
import hec.heclib.util.HecTime;
import hec.heclib.util.doubleArrayContainer;
import hec.io.AsciiSerializable;
import hec.lang.NamedType;
import hec.model.Interpolate;
import hec.model.PairedValues;
import hec.model.PairedValuesExt;
import hec.model.RunTimeStep;
import hec.rss.RssRmiWorkspace;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.Element;
import hec.rss.model.ElementHotstartState;
import hec.rss.model.HotstartState;
import hec.rss.model.IndependentVariable;
import hec.rss.model.InducedSurchargeOpHotstartState;
import hec.rss.model.InflowTimeSeriesOptionModel;
import hec.rss.model.OpController;
import hec.rss.model.OpRule;
import hec.rss.model.OpValue;
import hec.rss.model.OutletGroupElement;
import hec.rss.model.OutletUsageModel;
import hec.rss.model.ReservoirDamElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.Storage;
import hec.rss.model.reports.AlternativeInputReport;
import hec.rss.server.RssComputeOptions;
import hec.util.XMLUtilities;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import org.jdom.Content;
import rma.util.RMAConst;

public class InducedSurchargeOpRule
extends OpRule
implements AsciiSerializable,
Serializable,
Cloneable {
    private InflowTimeSeriesOptionModel _inflowTimeSeriesOption;
    private OutletUsageModel _outletUsage;
    IndependentVariable _independentVariable;
    IndependentVariable _tableLookupIndependentVariable;
    private boolean _useTableLookupIndependentVariable = false;
    private transient doubleArrayContainer c;
    private transient doubleArrayContainer d;
    private transient doubleArrayContainer e;
    private transient doubleArrayContainer f;
    private transient doubleArrayContainer i;
    private transient doubleArrayContainer j;
    private transient AdjustableFlow k;
    private transient Element l;
    private transient double m = 0.0;
    private transient double n = 0.0;
    private transient double o = 0.0;
    private transient HecTime p;
    transient double[] a;
    transient double[] b;
    private PairedValues _surchargeCurve = new PairedValues();
    private double _recessionConst = Double.NEGATIVE_INFINITY;
    private double _minDischarge = Double.NEGATIVE_INFINITY;
    private double _topOfFCPool = Double.NEGATIVE_INFINITY;
    private double _thresholdTime = Double.NEGATIVE_INFINITY;
    private int _fallingPoolOption = 3;
    private double _ratio = Double.NEGATIVE_INFINITY;
    private double _ratioPeriod = Double.NEGATIVE_INFINITY;
    private double _inflowAvgPeriod = Double.NEGATIVE_INFINITY;
    private PairedValuesExt _userDefinedIsCurves = new PairedValuesExt();
    private double[] _inflowsForCurves;
    private boolean _useUserDefinedIsCurves = false;
    private boolean _userCurvesAreRateOfRise = false;
    private double _rateOfRisePeriod;
    private transient PairedValuesExt q = new PairedValuesExt();
    private transient double[] r;
    private transient double s = 0.0;
    private transient double[] t;
    private PairedValuesExt _userDefinedRateOfRiseCurves = new PairedValuesExt();
    private PairedValuesExt _userDefinedFuncOfInflowCurves = new PairedValuesExt();
    private double[] _rateOfRiseForCurves;
    private double[] _reservoirInflowsForCurves;
    private double[] _plotInflows;
    private double[] _plotRateOfRise;
    private double _rateOfRiseLookbackHours = 1.0;
    private boolean _useRateOfRise;
    private double[] _inflowValues;
    public static final int UNDEF_OPTION = -1;
    public static final int RATIO_OF_INFLOW = 0;
    public static final int AVG_RELEASE_AND_INFLOW = 1;
    public static final int PEAK_GATE_OPENING = 2;
    public static final int PEAK_RELEASE = 3;

    public InducedSurchargeOpRule() {
        this.init();
    }

    public InducedSurchargeOpRule(String string) {
        super(string);
        this.init();
    }

    @Override
    public void evaluateLimits(RunTimeStep runTimeStep, int n) {
        double d;
        int n2;
        this.getUnitSystem();
        n = runTimeStep.step - 1;
        if (n < 0) {
            n = 0;
        }
        if ((n2 = runTimeStep.step - 2) < 0) {
            n2 = 0;
        }
        double d2 = this.f.array[n];
        this.p = runTimeStep.getHecTime();
        Storage storage = this._controller.getElementOp().getOperationsElement().getStorageFunction();
        double d3 = this._independentVariable.evaluateTSFunction(runTimeStep, this.i.array);
        double d4 = this.j.array[n];
        this.d.array[runTimeStep.step] = d3;
        this.c.array[runTimeStep.step] = d4;
        boolean bl = this.reservoirFalling(runTimeStep, this._thresholdTime);
        if (!bl) {
            double d5;
            double d6;
            if (this._useUserDefinedIsCurves) {
                if (this._userCurvesAreRateOfRise) {
                    double d7;
                    d6 = this.j.array[n2];
                    this.e.array[runTimeStep.step] = d7 = 60.0 * (d4 - d6) / (double)runTimeStep.getTimeStepMinutes();
                    this.n = d2;
                    d5 = this.computeReleaseFromEsrdRateOfRise(d4, d3, d7);
                } else {
                    double d8 = d3;
                    if (this._useTableLookupIndependentVariable && this._tableLookupIndependentVariable != null) {
                        d8 = this._tableLookupIndependentVariable.evaluateTSFunction(runTimeStep);
                    }
                    this.n = d2;
                    d5 = this.computeReleaseFromUserCurves(d4, d8);
                }
                if (d5 == -3.4028234663852886E38 && RMAConst.isValidValue((double)(d6 = this.h.array[n]))) {
                    d5 = d6;
                }
            } else {
                d5 = this.computeReleaseFromSurchargeFunction(d4, d3);
            }
            if (d5 == -3.4028234663852886E38) {
                this.o = 0.0;
                this.n = 0.0;
                this.h.array[runTimeStep.step] = -3.4028234663852886E38;
                return;
            }
            d6 = this.h.array[n];
            if (RMAConst.isValidValue((double)d6) && d6 > d5) {
                d5 = d6;
            }
            this.m = Double.NEGATIVE_INFINITY;
            this.o = d5;
            this.n = d2;
            this.h.array[runTimeStep.step] = d5;
            return;
        }
        if (this._useUserDefinedIsCurves && this._userCurvesAreRateOfRise) {
            this.e.array[runTimeStep.step] = -3.4028234663852886E38;
        }
        boolean bl2 = false;
        if (RMAConst.isValidValue((double)this.h.array[n]) && this.h.array[n] > 0.0) {
            bl2 = true;
        }
        if (!RMAConst.isValidValue((double)(d = this._topOfFCPool))) {
            d = this._surchargeCurve.getXValue(0);
        }
        if (d4 > d && bl2) {
            double d9 = 0.0;
            if (this._fallingPoolOption == 0) {
                double d10;
                double d11 = this._ratio;
                if (d11 <= 0.0 || !RMAConst.isValidValue((double)d11)) {
                    d11 = 1.0;
                }
                double d12 = this.averageInflow(runTimeStep, this._ratioPeriod);
                d9 = d11 * d12;
                if (d10 > this.o) {
                    d9 = this.o;
                }
            } else if (this._fallingPoolOption == 1) {
                double d13;
                double d14 = this.averageInflow(runTimeStep, this._inflowAvgPeriod);
                d9 = (d14 + d2) / 2.0;
                if (d13 > this.o) {
                    d9 = this.o;
                }
            } else if (this._fallingPoolOption == 2) {
                double d15 = this._controller.getFlowForPrevGateHeight(runTimeStep, d4);
                double d16 = this.estimateEOPElevation(runTimeStep, storage, d4, d15, true);
                d9 = this._controller.getFlowForPrevGateHeight(runTimeStep, d16);
            } else if (this._fallingPoolOption == 3) {
                d9 = this.o;
            }
            this.h.array[runTimeStep.step] = d9;
            return;
        }
        this.o = 0.0;
        this.h.array[runTimeStep.step] = -3.4028234663852886E38;
    }

    private double computeReleaseFromSurchargeFunction(double d, double d2) {
        double d3;
        double d4;
        Storage storage = this._controller.getElementOp().getOperationsElement().getStorageFunction();
        double d5 = 1.0;
        if (this.getUnitSystem() == 2) {
            d5 = 0.028344671201814057;
        }
        double d6 = d5 * 1.0;
        double d7 = this._recessionConst * 3600.0;
        double d8 = this._surchargeCurve.getYValue(0);
        double d9 = this._surchargeCurve.getXValue(d8);
        double d10 = storage.elevationToStorage(d9);
        double d11 = d7 * d2;
        if (d8 > d6) {
            d11 = d7 * (d2 - d8 * (1.0 + Math.log(d2 / d8)));
        }
        if ((d4 = storage.storageToElevation(d3 = d10 - (d11 /= Storage.DSDT_TO_Q))) > d || d2 < d8) {
            return -3.4028234663852886E38;
        }
        double d12 = this.getDischargeValue(d2, d);
        return d12;
    }

    @Override
    public OpValue getOpValue(RunTimeStep runTimeStep) {
        if (!RMAConst.isValidValue((double)this.h.array[runTimeStep.step])) {
            return null;
        }
        OpValue opValue = new OpValue();
        new OpValue().type = 0;
        opValue.value = this.h.array[runTimeStep.step];
        return opValue;
    }

    private void init() {
        this._surchargeCurve = new PairedValues();
        this._independentVariable = new IndependentVariable(3);
    }

    protected boolean initOtherIndependentVariable(IndependentVariable independentVariable) {
        RssSystem rssSystem = ((RssTSLocationObject)this).getSystem();
        if (rssSystem == null) {
            return false;
        }
        if (independentVariable == null) {
            rssSystem.printErrorMessage("InducedSurchargeOpRule.initializeCompute(" + this.getName() + "): Function is not defined");
            return false;
        }
        boolean bl = independentVariable.initializeCompute(rssSystem, this);
        return bl;
    }

    public void setInflowValues(double[] dArray) {
        if (dArray == null) {
            return;
        }
        this._inflowValues = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            double d = dArray[i];
            if (d == Double.NEGATIVE_INFINITY) {
                return;
            }
            this._inflowValues[i] = d;
        }
    }

    public void setRecessionConstant(double d) {
        this._recessionConst = d;
    }

    public void setTopOfFloodControlPool(double d) {
        this._topOfFCPool = d;
    }

    public void setFallingPoolThresholdTime(double d) {
        this._thresholdTime = d;
    }

    public void setFallingPoolOption(int n) {
        this._fallingPoolOption = n;
    }

    public void setRatio(double d) {
        this._ratio = d;
    }

    public void setRatioPeriod(double d) {
        this._ratioPeriod = d;
    }

    public void setInflowAvgPeriod(double d) {
        this._inflowAvgPeriod = d;
    }

    public void setSurchargeCurve(PairedValues pairedValues) {
        this._surchargeCurve.setParamXId(Parameter.PARAMID_ELEV);
        this._surchargeCurve.setParamYId(Parameter.PARAMID_FLOW);
        this._surchargeCurve = pairedValues;
    }

    public void setPlotInflowValues(double[] dArray) {
        this._plotInflows = dArray;
        if (this._plotInflows != null) {
            this._useRateOfRise = false;
        }
    }

    public void setPlotRateOfRiseValues(double[] dArray) {
        this._plotRateOfRise = dArray;
        if (this._plotRateOfRise != null) {
            this._useRateOfRise = true;
        }
    }

    public void setPlotRateOfRiseLookbackHours(double d) {
        this._rateOfRiseLookbackHours = d;
    }

    public void setUseRateOfRise(boolean bl) {
        this._useRateOfRise = bl;
    }

    public void setOutletUsageModel(OutletUsageModel outletUsageModel) {
        this._outletUsage = outletUsageModel;
    }

    public void setTimeSeriesOptionModel(InflowTimeSeriesOptionModel inflowTimeSeriesOptionModel) {
        this._inflowTimeSeriesOption = inflowTimeSeriesOptionModel;
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    public double[] getInflowValues() {
        return this._inflowValues;
    }

    public double getRecessionConstant() {
        return this._recessionConst;
    }

    public double getTopOfFloodControlPool() {
        return this._topOfFCPool;
    }

    public double getFallingPoolThresholdTime() {
        return this._thresholdTime;
    }

    public int getFallingPoolOption() {
        return this._fallingPoolOption;
    }

    public double getRatio() {
        return this._ratio;
    }

    public double getRatioPeriod() {
        return this._ratioPeriod;
    }

    public double getInflowAvgPeriod() {
        return this._inflowAvgPeriod;
    }

    public PairedValues getSurchargeCurve() {
        this._surchargeCurve.setUnitSystem(this.getUnitSystem());
        this._surchargeCurve.setParamXId(Parameter.PARAMID_ELEV);
        this._surchargeCurve.setParamYId(Parameter.PARAMID_FLOW);
        return this._surchargeCurve;
    }

    public double getDischargeValue(double d, double d2) {
        int n;
        double d3;
        double d4;
        double d5 = 1.0;
        if (this.getUnitSystem() == 2) {
            d5 = 0.028344671201814057;
        }
        double d6 = d5 * 1.0;
        Storage storage = this._controller.getElementOp().getOperationsElement().getStorageFunction();
        double d7 = storage.elevationToStorage(d2);
        double d8 = this._surchargeCurve.getYValue(0);
        double d9 = this._surchargeCurve.getXValue(this._surchargeCurve.size() - 1);
        if (d2 >= d9) {
            ReservoirElement reservoirElement = (ReservoirElement)this._controller.getElementOp().getOperationsElement();
            reservoirElement.getTotalCompositeRelease(d2);
            if (this.getNetwork().getRssRun() != null && this.getNetwork().getRssRun().getLogLevel() >= 7) {
                String string = this._controller.getElementOp().getOperationsElement().getName();
                this.getNetwork().printLogMessage("Reservoir elevation beyond definition of");
                this.getNetwork().printLogMessage("Induced surcharge curve for " + string);
                this.getNetwork().printLogMessage("    Date/Time = " + String.valueOf(this.p));
                this.getNetwork().printLogMessage("    Inflow = " + d);
                this.getNetwork().printLogMessage("    Elev   = " + d2);
                this.getNetwork().printLogMessage("  Release will be set to inflow.");
                this.getNetwork().printLogMessage("    Qout   = " + d + "\n");
            }
            return d;
        }
        double d10 = d * 0.25;
        double d11 = this._surchargeCurve.interpolate(d2);
        if (d4 > d10) {
            d10 = d11;
        }
        if (d11 > d) {
            double d12 = d;
            if (this.o > d) {
                d12 = this.o;
            }
            this.printCurveDischargeMessages("", d, d11, d2, d12);
            return d12;
        }
        double d13 = d10;
        double d14 = this.fq(d7, d, storage, d10) + d10;
        if (d3 < d8) {
            d14 = d8;
        }
        if (d14 > d * 0.95) {
            d14 = d * 0.95;
        }
        if (d14 == d13) {
            d14 = d13 * 1.1;
        }
        double d15 = this.fq(d7, d, storage, d13);
        double d16 = this.fq(d7, d, storage, d14);
        int n2 = n = this.getGlobalMaxIteration();
        double d17 = 0.0;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            double d18;
            double d19;
            d17 = d13 - d15 * ((d14 - d13) / (d16 - d15));
            if (d19 < d8) {
                d17 = d8;
            }
            if (Math.abs(d10 - d17) < d6) {
                bl = true;
                n2 = i;
                break;
            }
            double d20 = this.fq(d7, d, storage, d17);
            double d21 = d15 * d20;
            if (d18 < 0.0) {
                d14 = d17;
                d16 = d20;
            } else {
                d13 = d17;
                d15 = d20;
            }
            d10 = d17;
        }
        if (!bl) {
            String string = this._controller.getElementOp().getOperationsElement().getName();
            this.getNetwork().printLogMessage("Induced surcharge did not converge for " + string);
            this.getNetwork().printLogMessage("    Date/Time = " + String.valueOf(this.p));
            this.getNetwork().printLogMessage("    Inflow = " + d);
            this.getNetwork().printLogMessage("    Elev   = " + d2);
            this.getNetwork().printLogMessage("    N Iter = " + n2);
            this.getNetwork().printLogMessage("  Release will be set to inflow. ");
            this.getNetwork().printLogMessage("    Qout   = " + d + "\n");
            d17 = d;
        }
        double d22 = d17;
        return d22;
    }

    private int getGlobalMaxIteration() {
        Object object = (RssRmiWorkspace)((Object)((RssTSLocationObject)this).getSystem().getWorkspace().getRemote());
        if (object == null) {
            ((RssTSLocationObject)this).getSystem().printErrorMessage("An error occurred while trying to get the Global Induced Surcharge Max Iteration Option.\nA defualt value of 50 iterations will be used.");
            return 50;
        }
        try {
            object = object.getRssComputeOptions();
        }
        catch (RemoteException remoteException) {
            StringBuffer stringBuffer = new StringBuffer("An error occurred while trying to get the Global Induced Surcharge Max Iteration Option from the server.\nA defualt value of 50 iterations will be used.");
            stringBuffer.append(remoteException.getMessage());
            ((RssTSLocationObject)this).getSystem().printErrorMessage(stringBuffer.toString());
            return 50;
        }
        return ((RssComputeOptions)object).getInducedSurchargeMaxIterations();
    }

    public double getElevationForInflowRelease(double d, double d2) {
        if (this._surchargeCurve.size() < 3) {
            return Double.NEGATIVE_INFINITY;
        }
        double d3 = this._surchargeCurve.getYValue(0);
        double d4 = this._surchargeCurve.getYValue(this._surchargeCurve.size() - 1);
        if (d2 < d3 || d2 > d4) {
            return Double.NEGATIVE_INFINITY;
        }
        double d5 = this._recessionConst * 3600.0;
        double d6 = d2 < 0.001 ? d5 * d : d5 * (d - d2 * (1.0 + Math.log(d / d2)));
        double d7 = 43560.0;
        if (this.getUnitSystem() == 2) {
            d7 = 1.0;
        }
        Storage storage = this._controller.getElementOp().getOperationsElement().getStorageFunction();
        double d8 = this._surchargeCurve.getXValue(d2);
        double d9 = storage.elevationToStorage(d8);
        double d10 = d9 - (d6 /= d7);
        double d11 = storage.storageToElevation(d10);
        return d11;
    }

    public double getElevationForRateOfRise(double d, double d2) {
        if (this._surchargeCurve.size() < 3) {
            return Double.NEGATIVE_INFINITY;
        }
        double d3 = this._surchargeCurve.getYValue(0);
        double d4 = this._surchargeCurve.getYValue(this._surchargeCurve.size() - 1);
        if (d2 < d3 || d2 > d4) {
            return Double.NEGATIVE_INFINITY;
        }
        Storage storage = this._controller.getElementOp().getOperationsElement().getStorageFunction();
        double d5 = this._surchargeCurve.getXValue(d2);
        double d6 = 1.0;
        if (this.getUnitSystem() == 2) {
            d6 = 0.028344671201814057;
        }
        double d7 = d6 * 0.001;
        int n = this.getGlobalMaxIteration();
        for (int i = 0; i < n; ++i) {
            double d8 = storage.getFlowForRateOfRise(d, d5, 360.0);
            double d9 = d8 + d2;
            double d10 = d5;
            d5 = this.getElevationForInflowRelease(d9, d2);
            double d11 = 1.0;
            if (i > 3) {
                d11 = 0.5;
            }
            double d12 = d5 - d10;
            d5 = d10 + d11 * d12;
            if (Math.abs(d12) < d7) break;
        }
        return d5;
    }

    public void setUserDefinedIsCurves(PairedValuesExt pairedValuesExt, double[] dArray) {
        this._userDefinedIsCurves = pairedValuesExt;
        this._inflowsForCurves = dArray;
    }

    public PairedValuesExt getUserDefinedIsCurves() {
        return this._userDefinedIsCurves;
    }

    public double[] getUserDefinedIsInflows() {
        return this._inflowsForCurves;
    }

    public void setUseUserDefinedIsCurves(boolean bl) {
        this._useUserDefinedIsCurves = bl;
    }

    public boolean getUseUserDefinedIsCurves() {
        return this._useUserDefinedIsCurves;
    }

    public void setUserCurvesAreRateOfRise(boolean bl) {
        this._userCurvesAreRateOfRise = bl;
    }

    public boolean getUserCurvesAreRateOfRise() {
        return this._userCurvesAreRateOfRise;
    }

    public void setUserDefinedIsCurvesForRateOfRise(PairedValuesExt pairedValuesExt, double[] dArray) {
        this._userDefinedRateOfRiseCurves = pairedValuesExt;
        this._rateOfRiseForCurves = dArray;
    }

    public PairedValuesExt getUserDefinedIsCurvesForRateOfRise() {
        return this._userDefinedRateOfRiseCurves;
    }

    public double[] getUserDefinedRateOfRise() {
        return this._rateOfRiseForCurves;
    }

    public void setUserDefinedIsCurvesForFunctionOfInflow(PairedValuesExt pairedValuesExt, double[] dArray) {
        this._userDefinedFuncOfInflowCurves = pairedValuesExt;
        this._reservoirInflowsForCurves = dArray;
    }

    public PairedValuesExt getUserDefinedIsCurvesForFunctionOfInflow() {
        return this._userDefinedFuncOfInflowCurves;
    }

    public double[] getUserDefinedIsReservoirInflow() {
        return this._reservoirInflowsForCurves;
    }

    private double computeReleaseFromUserCurves(double d, double d2) {
        double d3;
        int n;
        ReservoirElement reservoirElement = (ReservoirElement)this._controller.getElementOp().getOperationsElement();
        reservoirElement.getTotalCompositeRelease(d);
        if (d2 <= this.t[0]) {
            return -3.4028234663852886E38;
        }
        if (d < this.q.getXValue(0)) {
            return -3.4028234663852886E38;
        }
        if (d2 >= this.t[this.t.length - 1]) {
            double d4 = this.q.getYValue(d, this.t.length - 1);
            return d4;
        }
        for (n = 0; n < this.t.length - 1 && d2 > this.t[n]; ++n) {
        }
        if (d < this.r[n]) {
            return -3.4028234663852886E38;
        }
        double d5 = this.q.getYValue(d, 0);
        if (n == 0) {
            n = 1;
        }
        double d6 = this.q.getYValue(d, n - 1);
        double d7 = this.q.getYValue(d, n);
        double d8 = d7 - d6;
        if (Math.abs(d3) < 1.0) {
            double d9 = d6;
            if (d2 < d9) {
                double d10 = d2;
                if (this.o > d2) {
                    d10 = this.o;
                }
                this.printCurveDischargeMessages("", d2, d9, d, d10);
                return d10;
            }
            return d9;
        }
        this.dqde(d, n - 1);
        this.dqde(d, n);
        double d11 = (d2 - this.t[n - 1]) / (this.t[n] - this.t[n - 1]);
        double d12 = d6 + d11 * (d7 - d6);
        if (d2 < d5) {
            double d13 = d2;
            if (this.o > d2) {
                d13 = this.o;
            }
            this.printCurveDischargeMessages("", d2, d12, d, d13);
            return d13;
        }
        if (d5 > this.t[n - 1]) {
            d11 = (d2 - d5) / (this.t[n] - d5);
            d12 = d5 + d11 * (d7 - d5);
        }
        return d12;
    }

    private double dqde(double d, int n) {
        double[] dArray = this.q.getXArray();
        double[] dArray2 = this.q.getYArray(n);
        int n2 = dArray.length;
        int n3 = d < dArray[0] ? 0 : (d >= dArray[n2 - 1] ? n2 - 2 : Interpolate.bisearch((double[])dArray, (double)d, (int)dArray.length));
        double d2 = dArray[n3 + 1] - dArray[n3];
        double d3 = dArray2[n3 + 1] - dArray2[n3];
        double d4 = d3 / d2;
        return d4;
    }

    private double computeReleaseFromEsrdRateOfRise(double d, double d2, double d3) {
        double d4;
        int n;
        if (d3 < 0.0) {
            return this.o;
        }
        Object object = (ReservoirElement)this._controller.getElementOp().getOperationsElement();
        ((ReservoirElement)object).getTotalCompositeRelease(d);
        double[] dArray = new double[this._inflowsForCurves.length + 1];
        object = dArray;
        dArray[0] = this.s;
        object[0] = 0.0;
        System.arraycopy(this._inflowsForCurves, 0, object, 1, this._inflowsForCurves.length);
        if (d2 <= this.s) {
            return -3.4028234663852886E38;
        }
        Object object2 = object;
        if (d3 >= object2[((Object)object2).length - 1]) {
            double d5 = this.q.getYValue(d, ((Object)object).length - 1);
            return d5;
        }
        for (n = 0; n < ((Object)object).length - 1 && d3 > object[n]; ++n) {
        }
        if (d < this.r[n]) {
            return -3.4028234663852886E38;
        }
        double d6 = this.q.getYValue(d, 0);
        if (n == 0) {
            n = 1;
        }
        double d7 = this.q.getYValue(d, n - 1);
        double d8 = this.q.getYValue(d, n);
        double d9 = d8 - d7;
        if (Math.abs(d4) < 1.0) {
            double d10 = d7;
            if (d2 < d10) {
                double d11 = d2;
                if (this.o > d2) {
                    d11 = this.o;
                }
                this.printCurveDischargeMessages("", d2, d10, d, d11);
                return d11;
            }
            return d10;
        }
        this.dqde(d, n - 1);
        this.dqde(d, n);
        double d12 = (d3 - object[n - 1]) / (object[n] - object[n - 1]);
        double d13 = d7 + d12 * (d8 - d7);
        if (d2 < d6) {
            double d14 = d2;
            if (this.o > d2) {
                d14 = this.o;
            }
            this.printCurveDischargeMessages("Rate of Rise", d2, d13, d, d14);
            return d14;
        }
        if (d6 > object[n - 1]) {
            double cfr_ignored_0 = (d2 - d6) / (object[n] - d6);
        }
        return d13;
    }

    private void printCurveDischargeMessages(String string, double d, double d2, double d3, double d4) {
        if (this.getNetwork().getRssRun() != null && this.getNetwork().getRssRun().getLogLevel() >= 7) {
            String string2 = this._controller.getElementOp().getOperationsElement().getName();
            this.getNetwork().printLogMessage("ESRD " + string + " curve discharge value for the current reservoir elevation");
            this.getNetwork().printLogMessage("is greater than inflow for " + string2);
            this.getNetwork().printLogMessage("    Date/Time = " + this.p.dateAndTime(104));
            this.getNetwork().printLogMessage("    Inflow = " + d);
            this.getNetwork().printLogMessage("    Qcurve = " + d2);
            this.getNetwork().printLogMessage("    Elev   = " + d3);
            this.getNetwork().printLogMessage("  Release will be set to inflow or previous peak release.");
            this.getNetwork().printLogMessage("    Qout   = " + d4);
            this.getNetwork().printLogMessage("    ResPrev= " + this.n + "\n");
        }
    }

    public double[] getPlotInflowValues() {
        return this._plotInflows;
    }

    public double[] getPlotRateOfRiseValues() {
        return this._plotRateOfRise;
    }

    public double getPlotRateOfRiseLookbackHours() {
        return this._rateOfRiseLookbackHours;
    }

    public InflowTimeSeriesOptionModel getInflowTimeSeriesOption() {
        return this._inflowTimeSeriesOption;
    }

    public OutletUsageModel getOutletUsageModel() {
        return this._outletUsage;
    }

    public void setIndependentVariable(IndependentVariable independentVariable) {
        this._independentVariable = independentVariable;
    }

    public void setTableLookupIndependentVariable(IndependentVariable independentVariable) {
        this._tableLookupIndependentVariable = independentVariable;
    }

    public IndependentVariable getIndependentVariable() {
        return this._independentVariable;
    }

    public IndependentVariable getTableLookupIndependentVariable() {
        if (this._tableLookupIndependentVariable == null) {
            this._tableLookupIndependentVariable = (IndependentVariable)this._independentVariable.clone();
        }
        return this._tableLookupIndependentVariable;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean initializeCompute() {
        this.j = null;
        this.i = null;
        this.f = null;
        if (!super.initializeCompute()) {
            return false;
        }
        NamedType namedType = this._controller.getElementOp().getOperationsElement().getStorageFunction();
        this.j = namedType.getTSContainer(10);
        this.i = namedType.getTSContainer(13);
        this.f = this._controller.getReleaseTSContainer();
        namedType = this._controller.getReleaseElement();
        this.k = null;
        this.l = null;
        if (namedType instanceof ReservoirDamElement || namedType instanceof OutletGroupElement) {
            this.l = namedType;
        } else {
            namedType = this._controller.getReleaseElement().getFunction();
            if (namedType instanceof AdjustableFlow) {
                this.k = (AdjustableFlow)namedType;
            }
        }
        this.m = 0.0;
        this.o = 0.0;
        this.a = new double[7];
        this.b = new double[7];
        this.c = this.getTSContainer(10);
        if (this.c == null && this.g != null) {
            this.g.printErrorMessage("InducedSurchargeOpRule.initializeCompute: Failed to find output elevation series array for " + this.getName());
            return false;
        }
        this.d = this.getTSContainer(13);
        if (this.d == null && this.g != null) {
            this.g.printErrorMessage("InducedSurchargeOpRule.initializeCompute: Failed to find output net inflow series array for " + this.getName());
            return false;
        }
        if (this._useUserDefinedIsCurves && this._userCurvesAreRateOfRise) {
            this.e = this.getTSContainer(22);
            if (this.e == null && this.g != null) {
                this.g.printErrorMessage("InducedSurchargeOpRule.initializeCompute: Failed to find output roc series array for " + this.getName());
                return false;
            }
        }
        if (this._useUserDefinedIsCurves) {
            this.initializeUserCurvesForCompute();
            if (this._useTableLookupIndependentVariable) {
                InducedSurchargeOpRule inducedSurchargeOpRule = this;
                inducedSurchargeOpRule.initOtherIndependentVariable(inducedSurchargeOpRule._tableLookupIndependentVariable);
            }
        }
        if (this._useTableLookupIndependentVariable) {
            if (this.g == null) {
                this.g = ((RssTSLocationObject)this).getSystem();
            }
            if (this._independentVariable == null) {
                this.g.printErrorMessage("InducedSurchargeOpRule.initializeCompute(" + this.getName() + "): Table lookup Independent Variable is not defined");
                return false;
            }
        }
        return true;
    }

    private boolean initializeUserCurvesForCompute() {
        int n;
        double[] dArray;
        this.q = this._userDefinedIsCurves.clone();
        int n2 = this.q.getNumberCurves();
        int n3 = this.q.size();
        this.r = new double[n2];
        double[] dArray2 = this.q.getXArray();
        double[][] dArray3 = this.q.getYData();
        block0: for (int i = 0; i < n2; ++i) {
            int n4;
            int n5;
            dArray = dArray3[i];
            this.r[i] = Double.NEGATIVE_INFINITY;
            for (n5 = 0; n5 < n3; ++n5) {
                if (!RMAConst.isValidValue((double)dArray[n5])) continue;
                n4 = n5;
                for (n = 0; n < n4; ++n) {
                    dArray[n] = dArray[n4];
                }
                this.r[i] = dArray2[n5];
                break;
            }
            for (n5 = n3 - 1; n5 >= 0; --n5) {
                if (!RMAConst.isValidValue((double)dArray[n5])) continue;
                n4 = n5;
                for (n = n3 - 1; n > n4; --n) {
                    dArray[n] = dArray[n4];
                }
                continue block0;
            }
        }
        this.s = 0.0;
        double d = 1.0E10;
        n = 0;
        dArray = dArray3[0];
        for (n2 = 0; n2 < n3; ++n2) {
            if (!RMAConst.isValidValue((double)dArray[n2]) || !(d > dArray[n2])) continue;
            d = dArray[n2];
            n = 1;
        }
        if (n != 0) {
            this.s = d;
        }
        this.q.setArrays(dArray2, dArray3);
        this.t = new double[this._inflowsForCurves.length + 1];
        this.t[0] = this.s;
        System.arraycopy(this._inflowsForCurves, 0, this.t, 1, this._inflowsForCurves.length);
        return true;
    }

    @Override
    public OpValue evaluateRule(RunTimeStep runTimeStep, double d) {
        ((OpRule)this).evaluateLimits(runTimeStep, 0);
        return ((OpRule)this).getOpValue(runTimeStep);
    }

    @Override
    public void saveFunctionState(int n) {
        if (this.a != null && n < this.a.length) {
            this.a[n] = this.m;
        }
        if (this.b != null && n < this.b.length) {
            this.b[n] = this.o;
        }
    }

    @Override
    public void restoreFunctionState(int n) {
        if (n == 3) {
            return;
        }
        if (this.a != null && n < this.a.length) {
            this.m = this.a[n];
        }
        if (this.b != null && n < this.b.length) {
            this.o = this.b[n];
        }
    }

    public void saveHotstartState(ElementHotstartState elementHotstartState, int n) {
        InducedSurchargeOpHotstartState inducedSurchargeOpHotstartState = (InducedSurchargeOpHotstartState)elementHotstartState.getChildState(this.getName(), this.getClass().getName());
        if (inducedSurchargeOpHotstartState == null) {
            inducedSurchargeOpHotstartState = new InducedSurchargeOpHotstartState(this);
            elementHotstartState.addChildState(inducedSurchargeOpHotstartState);
        }
        ((HotstartState)inducedSurchargeOpHotstartState).saveState(n);
    }

    @Override
    public Object clone() {
        InducedSurchargeOpRule inducedSurchargeOpRule = (InducedSurchargeOpRule)super.clone();
        return inducedSurchargeOpRule;
    }

    public boolean fallingPoolOptionsValid() {
        if (this._fallingPoolOption == -1) {
            return false;
        }
        return !(this._fallingPoolOption == 0 ? this._ratio == Double.NEGATIVE_INFINITY || this._ratioPeriod == Double.NEGATIVE_INFINITY : (this._fallingPoolOption == 1 ? this._inflowAvgPeriod == Double.NEGATIVE_INFINITY : this._thresholdTime == Double.NEGATIVE_INFINITY || this._topOfFCPool == Double.NEGATIVE_INFINITY));
    }

    public double averageInflow(RunTimeStep runTimeStep, double d) {
        int n;
        int n2;
        if (d <= 0.0 || !RMAConst.isValidValue((double)d)) {
            d = 1.0;
        }
        double d2 = runTimeStep.getTimeStepSeconds();
        int n3 = 1;
        if (d2 > 1.0 && d > 0.0) {
            n3 = (int)(d * 3600.0 / d2);
        }
        if ((n2 = (n = runTimeStep.step) - n3) < 0) {
            n2 = 0;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        while (n2 <= n) {
            d4 += this.i.array[n2];
            d3 += 1.0;
            ++n2;
        }
        if (d3 > 0.0) {
            d5 = d4 / d3;
        }
        return d5;
    }

    public boolean reservoirFalling(RunTimeStep runTimeStep, double d) {
        int n;
        int n2;
        if (d <= 0.0 || !RMAConst.isValidValue((double)d)) {
            d = 1.0;
        }
        double d2 = runTimeStep.getTimeStepSeconds();
        int n3 = 1;
        if (d2 > 1.0 && d > 0.0) {
            n3 = (int)(d * 3600.0 / d2);
        }
        if ((n2 = runTimeStep.step - 1) < 0) {
            n2 = 0;
        }
        if ((n = n2 - n3) < 0) {
            n = 0;
        }
        double d3 = this.j.array[n2];
        while (n < n2) {
            if (RMAConst.isValidValue((double)this.j.array[n]) && this.j.array[n] <= d3) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public double fq(double d, double d2, Storage storage, double d3) {
        double d4 = this._surchargeCurve.getXValue(d3);
        double d5 = storage.elevationToStorage(d4);
        double d6 = (d5 - d) * Storage.DSDT_TO_Q;
        double d7 = this._recessionConst * 3600.0;
        double d8 = 10.0;
        if (d3 > 0.001) {
            d8 = 1.0 + Math.log(d2 / d3);
        }
        if (d8 >= 0.0 && d8 < 0.1) {
            d8 = 0.1;
        }
        if (d8 < 0.0 && d8 > -0.1) {
            d8 = -0.1;
        }
        double d9 = (d2 - d6 / d7) / d8 - d3;
        return d9;
    }

    private double estimateEOPElevation(RunTimeStep runTimeStep, Storage storage, double d, double d2, boolean bl) {
        double d3;
        double d4 = d2;
        double d5 = storage.getNetInflow(runTimeStep);
        if (!RMAConst.isValidValue((double)d2) || !RMAConst.isValidValue((double)d5)) {
            return d;
        }
        double d6 = storage.getPreviousStorage(runTimeStep);
        if (!runTimeStep.isPerAvgTimeStep() && bl) {
            d3 = storage.getOutflowArray()[runTimeStep.step - 1];
            double d7 = storage.getNetInflowArray()[runTimeStep.step - 1];
            if (!RMAConst.isValidValue((double)d3) || !RMAConst.isValidValue((double)d7)) {
                return d;
            }
            d4 = (d2 + d3) / 2.0;
            d5 = (d5 + d7) / 2.0;
        }
        double d8 = (d5 - d4) * (double)runTimeStep.getTimeStepSeconds() / Storage.DSDT_TO_Q;
        d3 = storage.storageToElevation(d6 + d8);
        return d3;
    }

    public boolean useRateOfRise() {
        return this._useRateOfRise;
    }

    @Override
    public int getRuleLimitType() {
        return 0;
    }

    @Override
    public Vector getActiveTSRecordProxies(Vector vector, int n) {
        String string;
        TSRecordProxy tSRecordProxy;
        vector = super.getActiveTSRecordProxies(vector, n);
        if (n == 0) {
            tSRecordProxy = this.getTSRecordProxy(10);
            if (tSRecordProxy != null && !vector.contains(tSRecordProxy)) {
                vector.addElement(tSRecordProxy);
            }
            if ((tSRecordProxy = this.getTSRecordProxy(13)) != null && !vector.contains(tSRecordProxy)) {
                vector.addElement(tSRecordProxy);
            }
            if (this._useUserDefinedIsCurves && this._userCurvesAreRateOfRise && (tSRecordProxy = this.getTSRecordProxy(22)) != null && !vector.contains(tSRecordProxy)) {
                vector.addElement(tSRecordProxy);
            }
        }
        if (n == 1 && this._tableLookupIndependentVariable != null && this._tableLookupIndependentVariable.getType() == 3 && this.useTableLookupIndependentVariable() && (tSRecordProxy = this.getTSRecordProxy(string = this._tableLookupIndependentVariable.getTimeSeriesName(), 85)) != null) {
            vector.addElement(tSRecordProxy);
        }
        return vector;
    }

    public boolean useTableLookupIndependentVariable() {
        return this._useTableLookupIndependentVariable;
    }

    public void setUseTableLookupIndependentVariable(boolean bl) {
        this._useTableLookupIndependentVariable = bl;
    }

    @Override
    public void updateTSProxyList() {
        super.updateTSProxyList();
        String string = this.getTSProxyName();
        TSRecordProxy tSRecordProxy = this.getTSRecordProxy(string, 10);
        if (tSRecordProxy == null) {
            this.addTSRecordProxy(string, 10);
        }
        if ((tSRecordProxy = this.getTSRecordProxy(string, 13)) == null) {
            this.addTSRecordProxy(string, 13);
        }
        if (this._useUserDefinedIsCurves && this._userCurvesAreRateOfRise && (tSRecordProxy = this.getTSRecordProxy(string, 22)) == null) {
            this.addTSRecordProxy(string, 22);
        }
        if (this._tableLookupIndependentVariable != null) {
            if (this._tableLookupIndependentVariable.getType() == 3 && (tSRecordProxy = this.getTSRecordProxy(string = this._tableLookupIndependentVariable.getTimeSeriesName(), 85)) == null) {
                this.addTSRecordProxy(string, 85);
            }
        }
    }

    @Override
    public Vector getRequiredTSRecordProxies(Vector vector) {
        Object object;
        if (vector == null) {
            vector = new Vector<Object>();
        }
        if ((object = this.getController()) == null) {
            return vector;
        }
        if ((object = ((OpController)object).getElementOp().getOperationsElement()) == null) {
            return vector;
        }
        object = object.getSystem();
        ((RssSystem)object).getElement(this._tableLookupIndependentVariable.getElementId());
        object = ((RssSystem)object).getTSRecordProxy(this._tableLookupIndependentVariable.getTSProxyName(), this._tableLookupIndependentVariable.getModelVariableId());
        if (object != null) {
            vector.add(object);
        }
        return vector;
    }

    @Override
    public void getReferencedStateVariables(List list) {
        if (this._independentVariable == null) {
            return;
        }
        if (this._independentVariable.getType() == 4) {
            RssReturnStatusConstants rssReturnStatusConstants = ((RssTSLocationObject)this).getSystem();
            if (rssReturnStatusConstants == null) {
                return;
            }
            if ((rssReturnStatusConstants = rssReturnStatusConstants.getStateVariable(this._independentVariable.getStateVariableId())) != null && !list.contains(rssReturnStatusConstants)) {
                list.add(rssReturnStatusConstants);
            }
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        org.jdom.Element element2;
        super.outputReport(alternativeInputReport, element);
        element.setAttribute("Rule", "InducedSurcharge");
        if (this._useUserDefinedIsCurves) {
            element.setAttribute("UseRateOfRise", Boolean.toString(this.useRateOfRise()));
            this.getSurchargeCurve();
            var4_3 = this.getUserDefinedIsCurves();
            element2 = new org.jdom.Element("SpecifyESRDCurves");
            element.addContent((Content)element2);
            XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])var4_3.getXArray());
            for (int i = 0; i < var4_3.getNumberCurves(); ++i) {
                element2 = new org.jdom.Element("SpecifyESRDCurves" + i);
                element.addContent((Content)element2);
                XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])var4_3.getCurve(i).getYArray());
            }
        } else {
            element.setAttribute("TimeOfRecession", Double.toString(this._thresholdTime));
            var4_3 = this.getSurchargeCurve();
            element.setAttribute("InterpType", Integer.toString(var4_3.getInterpolationType()));
            element2 = new org.jdom.Element("ISEnvelopeCurve_Elevation");
            element.addContent((Content)element2);
            XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])var4_3.getYArray());
            element2 = new org.jdom.Element("ISEnvelopeCurve_Release");
            element.addContent((Content)element2);
            XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])var4_3.getXArray());
        }
        element2 = new org.jdom.Element("InflowTimeSeriesOptions");
        element.addContent((Content)element2);
        if (this._inflowTimeSeriesOption != null) {
            element2.setAttribute("Function_Type", Integer.toString(this._inflowTimeSeriesOption.getTimeSeriesFunctionType()));
            element2.setAttribute("Lag", Double.toString(this._inflowTimeSeriesOption.getTimeSeriesLag()));
            element2.setAttribute("Lag", Double.toString(this._inflowTimeSeriesOption.getTimeSeriesPeriod()));
        }
        element2 = new org.jdom.Element("UseVariableforESRDOptions");
        element.addContent((Content)element2);
        if (this._useTableLookupIndependentVariable) {
            element2 = new org.jdom.Element("IndependentVariable");
            this._independentVariable.outputReport(alternativeInputReport, element2);
        }
        if (this._enableRiseFallCond) {
            element2 = new org.jdom.Element("FallingPoolOptions");
            element.addContent((Content)element2);
            element2.setAttribute("TimeOfPoolDecrease", Double.toString(this.getFallingPoolThresholdTime()));
            element2.setAttribute("FallingPoolTrancitionElev", Double.toString(this.getTopOfFloodControlPool()));
            int n = this.getFallingPoolOption();
            element2.setAttribute("Type", Integer.toString(n));
            if (n == 0) {
                element2.setAttribute("Release", Double.toString(this.getRatio()));
                element2.setAttribute("Period", Double.toString(this.getRatioPeriod()));
                return;
            }
            if (n == 1) {
                element2.setAttribute("Period", Double.toString(this.getInflowAvgPeriod()));
                return;
            }
            if (n == 2) {
                element2.setAttribute("MaintainPeakRelease", "true");
                return;
            }
            if (n == 3) {
                element2.setAttribute("MaintainPeakGateOpenings", "true");
            }
        }
    }

    static {
        FluentLogger.forEnclosingClass();
    }
}

