/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.io.AsciiSerializable;
import hec.model.ModelVariable;
import hec.model.RunTimeStep;
import hec.rss.model.Element;
import hec.rss.model.IndependentVariable;
import hec.rss.model.ReleaseFuncOpRule;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssSystem;
import java.lang.reflect.Field;

public class InflowTimeSeriesOptionModel
implements AsciiSerializable,
Cloneable {
    private int _type;
    private int _modelVariableId;
    private int _elementIndex = Integer.MIN_VALUE;
    private String _tsproxyName = null;
    private String _tsName;
    private int _tsOptFunctionType;
    private double _tsOptLag;
    private double _tsOptPeriod;
    private transient String a;
    public static final int DATE_TYPE = 0;
    public static final int DATE_TIME_TYPE = 1;
    public static final int MODEL_VARIABLE_TYPE = 2;
    public static final int TIME_SERIES_TYPE = 3;
    public static final String[] TS_FUNCTION_STRINGS = new String[]{"Current Value", "Previous Value", "Lagged Value", "Period Average", "Period Maximum", "Period Minimum"};
    public static final int TS_CURRENT_TYPE = 0;
    public static final int TS_PREVIOUS_TYPE = 1;
    public static final int TS_LAGGED_TYPE = 2;
    public static final int TS_PERAVG_TYPE = 3;
    public static final int TS_PERMAX_TYPE = 4;
    public static final int TS_PERMIN_TYPE = 5;

    public void InflowTimeSeriesOptionModel() {
    }

    public void setModalVariableInfo(TSRecordProxy tSRecordProxy, Element element, ModelVariable modelVariable) {
        if (this._type != 2) {
            throw new IllegalStateException("Can only set ModelVariable Information for ModelVariable Type");
        }
        this._tsproxyName = tSRecordProxy.getName();
        this._elementIndex = element.getIndex();
        this._modelVariableId = modelVariable.getType();
    }

    public void setTimeSeriesName(String string) {
        if (this._type != 3) {
            throw new IllegalStateException("Can only set TimeSeries Name for TimeSeries Type");
        }
        this._tsName = string;
    }

    public void setTimeSeriesOptions(int n, double d, double d2) {
        this._tsOptLag = d;
        this._tsOptFunctionType = n;
        this._tsOptPeriod = d2;
    }

    public void setModelVariableString(String string) {
        this.a = string;
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public String getTSProxyName() {
        return this._tsproxyName;
    }

    public String getTimeSeriesName() {
        return this._tsName;
    }

    public String getTimeSeriesFunction() {
        return TS_FUNCTION_STRINGS[this._tsOptFunctionType];
    }

    public int getTimeSeriesFunctionType() {
        return this._tsOptFunctionType;
    }

    public double getTimeSeriesLag() {
        return this._tsOptLag;
    }

    public double getTimeSeriesPeriod() {
        return this._tsOptPeriod;
    }

    public int getType() {
        return this._type;
    }

    public int getElementId() {
        return this._elementIndex;
    }

    public int getModelVariableId() {
        return this._modelVariableId;
    }

    public ModelVariable getModelVariable() {
        return RssModelVariableSet.getModelVariable(this._modelVariableId);
    }

    public Object getFieldObject(Field object) {
        try {
            object = ((Field)object).get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public double evaluateTSFunction(RunTimeStep runTimeStep, double[] dArray) {
        if (runTimeStep == null || dArray == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (runTimeStep.step >= dArray.length) {
            return Double.NEGATIVE_INFINITY;
        }
        int n = 0;
        if (this._tsOptFunctionType >= 2 && (n = (int)(this._tsOptLag * 3600.0 / (double)runTimeStep.getTimeStepSeconds())) < 0) {
            n = 0;
        }
        int n2 = 1;
        if (this._tsOptFunctionType >= 3 && (n2 = (int)(this._tsOptPeriod * 3600.0 / (double)runTimeStep.getTimeStepSeconds())) <= 0) {
            n2 = 1;
        }
        switch (this._tsOptFunctionType) {
            case 0: {
                return dArray[runTimeStep.step];
            }
            case 1: {
                int n3 = runTimeStep.step - 1;
                if (n3 < 0) {
                    n3 = 0;
                }
                return dArray[n3];
            }
            case 2: {
                int n4 = runTimeStep.step - n;
                if (n4 < 0) {
                    n4 = 0;
                }
                return dArray[n4];
            }
            case 3: {
                double d = 0.0;
                for (int i = 0; i < n2; ++i) {
                    int n5 = runTimeStep.step - (n + i);
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    d += dArray[n5];
                }
                double d2 = d / (double)n2;
                return d2;
            }
            case 4: {
                double d = Double.MIN_VALUE;
                for (int i = 0; i < n2; ++i) {
                    int n6 = runTimeStep.step - (n + i);
                    if (n6 < 0) {
                        n6 = 0;
                    }
                    if (!(d < dArray[n6])) continue;
                    d = dArray[n6];
                }
                if (d == Double.MIN_VALUE) {
                    d = Double.NEGATIVE_INFINITY;
                }
                return d;
            }
            case 5: {
                double d = Double.MAX_VALUE;
                for (int i = 0; i < n2; ++i) {
                    int n7 = runTimeStep.step - (n + i);
                    if (n7 < 0) {
                        n7 = 0;
                    }
                    if (!(d > dArray[n7])) continue;
                    d = dArray[n7];
                }
                if (d == Double.MAX_VALUE) {
                    d = Double.NEGATIVE_INFINITY;
                }
                return d;
            }
        }
        return Double.NEGATIVE_INFINITY;
    }

    public boolean areTheSame(IndependentVariable independentVariable) {
        if (independentVariable == null) {
            return false;
        }
        if (this._type == 2 && this._type == independentVariable.getType()) {
            return this.getModelVariable().getParamId() == independentVariable.getModelVariable().getParamId();
        }
        if (this._type == 3 && this._type == independentVariable.getType()) {
            return this._tsName.equals(independentVariable.getTimeSeriesName());
        }
        return this._type == independentVariable.getType();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("IndependentVariable.clone: Exception in clone() " + String.valueOf(cloneNotSupportedException));
            return null;
        }
    }

    public String buildFunctionOfString(ReleaseFuncOpRule rssReturnStatusConstants) {
        int n = this.getType();
        if (n == 0) {
            return "Date";
        }
        if (n == 1) {
            return "Date and Time";
        }
        if (n != 2 && n != 3) {
            return "Function Not Defined";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 3) {
            stringBuffer.append(this.getTimeSeriesName());
        } else {
            String string = "";
            if (rssReturnStatusConstants != null && rssReturnStatusConstants.getRssSystem() != null) {
                rssReturnStatusConstants = rssReturnStatusConstants.getRssSystem();
                string = ((RssSystem)rssReturnStatusConstants).getNameForKeyString(this.getTSProxyName());
            }
            stringBuffer.append(string);
            stringBuffer.append(" " + this.getModelVariable().getName());
        }
        String string = this.getTimeSeriesFunction();
        stringBuffer.append(", " + string);
        if (string != null && (string.indexOf("Lagged") >= 0 || string.indexOf("Period") >= 0)) {
            stringBuffer.append(", " + this.getTimeSeriesLag() + " hr offset");
        }
        if (string != null && string.indexOf("Period") >= 0) {
            stringBuffer.append(", " + this.getTimeSeriesPeriod() + " hr period");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        switch (this._type) {
            case 0: {
                return "Date";
            }
            case 1: {
                return "Date Time";
            }
            case 3: {
                return this.getTimeSeriesName();
            }
            case 2: {
                if (this.a == null) {
                    return "Model Variable " + String.valueOf(this.getModelVariable());
                }
                return this.a;
            }
        }
        return "Function not Defined";
    }

    void setModalVariableInfo(String string, int n, ModelVariable modelVariable) {
        if (this._type != 2) {
            throw new IllegalStateException("Can only set ModelVariable Information for ModelVariable Type");
        }
        this._tsproxyName = string;
        this._elementIndex = n;
        this._modelVariableId = modelVariable.getType();
    }
}

