/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.data.DataSetIllegalArgumentException;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.doubleArrayContainer;
import hec.io.DSSIdentifier;
import hec.model.ModelVariable;
import hec.model.PairedValues;
import hec.model.RunTimeStep;
import hec.model.TSLocation;
import hec.model.TSRecord;
import hec.rss.model.Continuity;
import hec.rss.model.DiversionElement;
import hec.rss.model.Element;
import hec.rss.model.Function;
import hec.rss.model.IndependentVariable;
import hec.rss.model.Junction$JuncRatingType;
import hec.rss.model.JunctionElement;
import hec.rss.model.RSimDssPathPartGenerator;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssAlt;
import hec.rss.model.RssNode;
import hec.rss.model.RssRatingObject;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.TailElevContainer;
import hec.rss.model.TailwaterElevation;
import hec.rss.model.VerticalDatumSettings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.VerticalDatumException;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class Junction
extends Continuity
implements TailElevContainer,
Cloneable {
    private transient double a = 0.0;
    private transient double b = 0.0;
    private transient double c = 0.0;
    private transient double d = 0.0;
    VerticalDatumSettings _verticalDatumSettings = new VerticalDatumSettings();
    PairedValues _ratingCurve = new PairedValues();
    RssRatingObject _ratingObject;
    Junction$JuncRatingType _ratingType = Junction$JuncRatingType.UNDEF;
    boolean _hasTailElev = false;
    TailwaterElevation _tailElev;
    private transient doubleArrayContainer[] e;
    private transient doubleArrayContainer[] f;
    private transient doubleArrayContainer[] g;
    private transient doubleArrayContainer[] h;
    private transient doubleArrayContainer i;
    private transient double[] j;
    private transient double[] k;
    private transient doubleArrayContainer l;
    private transient doubleArrayContainer m;
    private transient doubleArrayContainer n;
    private transient boolean o = false;

    public Junction() {
        this._verticalDatumSettings.setUnits("ft");
    }

    public Junction(Element element) {
        super(element);
    }

    public double getBCAdjFac(int n) {
        double d = 1.0;
        if (this.j != null && n < this.j.length) {
            d = this.j[n];
        }
        if (this.k != null && n < this.k.length) {
            d *= this.k[n];
        }
        return d;
    }

    public double getDiversionVolume(RunTimeStep runTimeStep) {
        double d = 0.0;
        int n = this.element.getNodeCount();
        for (int i = 0; i < n; ++i) {
            Element element;
            RssNode rssNode = this.element.getNode(i);
            if (rssNode == null || !rssNode.isActive() || (element = rssNode.getUpstreamElement()) == null || !(element.getTopParent() instanceof DiversionElement) || (rssNode = rssNode.getTSContainer(0)) == null || ((doubleArrayContainer)rssNode).array == null) continue;
            d -= Junction.getFlowVolume(runTimeStep, ((doubleArrayContainer)rssNode).array);
        }
        return d;
    }

    public double getLocalInflowVolume(RunTimeStep runTimeStep) {
        if (this.e == null) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < this.e.length; ++i) {
            if (this.e[i] == null) continue;
            d += Junction.getFlowVolume(runTimeStep, this.e[i].array) * this.j[i] * this.k[i];
        }
        return d;
    }

    @Override
    public void setupForSerialization() {
        super.setupForSerialization();
        if (this._ratingCurve != null) {
            DSSPathname dSSPathname = new DSSPathname();
            Object object = new RSimDssPathPartGenerator();
            Object object2 = this.getName();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add((String)object2);
            object2 = object.generatePathnamePart(arrayList, "");
            dSSPathname.setAPart((String)object2);
            arrayList.clear();
            arrayList.add("Rating Curve");
            object2 = ((RssTSLocationObject)this).getSystem();
            object = object2 != null ? ((RssSystem)object2).generateUniquePathPart(arrayList, "-") : object.generatePathnamePart(arrayList, "-");
            dSSPathname.setBPart((String)object);
            object = Parameter.getParamString((int)Parameter.PARAMID_STAGE) + "-" + Parameter.getParamString((int)Parameter.PARAMID_FLOW);
            dSSPathname.setCPart((String)object);
            object = this.getElement().getSystem().getDssPairedDataFilePath();
            object2 = dSSPathname.getPathname();
            this._ratingCurve.setDssIdentifer(new DSSIdentifier((String)object, (String)object2));
            this._ratingCurve.setDssPathName(dSSPathname.getPathname());
            this._ratingCurve.setParamXId(Parameter.PARAMID_STAGE);
            this._ratingCurve.setParamYId(Parameter.PARAMID_FLOW);
            this._ratingCurve.setUnitSystem(this.getUnitSystem());
        }
        if (this._tailElev != null) {
            this._tailElev.setupForSerialization();
        }
        if (this._ratingObject != null) {
            this._ratingObject.setRatingName("Rating Curve");
            this._ratingObject.setupForSerialization();
        }
    }

    @Override
    public TailwaterElevation getTailwaterElevation() {
        if (this._tailElev == null) {
            this._tailElev = new TailwaterElevation(this.element);
        }
        if (this._tailElev.getElement() == null) {
            this._tailElev.setElement(this.element);
        }
        return this._tailElev;
    }

    @Override
    public void setHasTailElev(boolean bl) {
        this._hasTailElev = bl;
    }

    @Override
    public boolean hasTailElev() {
        return this._hasTailElev;
    }

    @Override
    public void setElement(Element element) {
        super.setElement(element);
        if (this._tailElev != null) {
            this._tailElev.setElement(element);
        }
        if (this._ratingObject != null) {
            this._ratingObject.setElement(element);
        }
    }

    @Override
    public synchronized Object clone() {
        Junction junction = (Junction)super.clone();
        ((Junction)super.clone())._verticalDatumSettings = new VerticalDatumSettings(this._verticalDatumSettings);
        if (this._ratingCurve != null) {
            junction._ratingCurve = (PairedValues)this._ratingCurve.clone();
        }
        if (this._tailElev != null) {
            junction._tailElev = (TailwaterElevation)((RssTSLocationObject)this._tailElev).clone();
            junction._tailElev.setElement(this.element);
        }
        if (this._ratingObject != null) {
            junction._ratingObject = (RssRatingObject)((RssTSLocationObject)this._ratingObject).clone();
            junction._ratingObject.setElement(this.element);
        }
        return junction;
    }

    public double getLastOutflow() {
        return this.a;
    }

    public double getAvailableFlow() {
        return this.d;
    }

    public void setAvailableFlow(double d) {
        this.d = d;
    }

    public boolean isConfluence() {
        int n = 0;
        int n2 = 0;
        int n3 = this.element.getNodeCount();
        for (int i = 0; i < n3; ++i) {
            RssNode rssNode = this.element.getNode(i);
            if (rssNode == null || !rssNode.isActive()) continue;
            if (this.element.getNodeDir(i) == 0) {
                ++n2;
                continue;
            }
            if (rssNode.getUpstreamElement() == null) continue;
            ++n;
        }
        return n > 1 || n2 > 1;
    }

    @Override
    public boolean initialize() {
        RssNode rssNode;
        int n;
        this.f = null;
        this.g = null;
        this.j = null;
        this.m = null;
        this.n = null;
        this.l = null;
        this.k = null;
        this.h = null;
        this.i = null;
        if (!super.initialize()) {
            return false;
        }
        this.a = 0.0;
        this.b = 0.0;
        this.c = 0.0;
        this.d = 0.0;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.element.getNodeCount();
        for (n = 0; n < n4; ++n) {
            rssNode = this.element.getNode(n);
            if (rssNode == null || !rssNode.isActive()) continue;
            if (this.element.getNodeDir(n) == 0) {
                ++n3;
                continue;
            }
            ++n2;
        }
        if (n2 <= 0) {
            this.element.getSystem().printErrorMessage("Junction.initialize: No inflow to this junction");
            this.element.getSystem().printMessage("Junction: " + this.element.getName());
            return false;
        }
        if (n3 <= 0) {
            this.element.getSystem().printErrorMessage("Junction.initialize: No outflow from this junction");
            this.element.getSystem().printMessage("Junction: " + this.element.getName());
            return false;
        }
        this.e = new doubleArrayContainer[n2];
        this.f = new doubleArrayContainer[n2];
        this.g = new doubleArrayContainer[n3];
        this.j = new double[n2];
        this.k = new double[n2];
        rssNode = null;
        RssRun rssRun = this.getElement().getSystem().getRssRun();
        this.o = rssRun.getAlternative().useObsTSData();
        if (this.element.getSystem().getComputeType() != 0) {
            this.o = false;
        }
        if (this.o) {
            this.h = new doubleArrayContainer[n3];
            rssNode = rssRun.getObservedTSData();
        }
        int n5 = 0;
        n3 = 0;
        RssAlt rssAlt = this.getElement().getSystem().getAlternative();
        for (n = 0; n < n4; ++n) {
            Object object;
            RssNode rssNode2 = this.element.getNode(n);
            if (rssNode2 == null || !rssNode2.isActive()) continue;
            if (this.element.getNodeDir(n) == 0) {
                TSRecord tSRecord;
                this.g[n3] = rssNode2.getTSContainer(0);
                if (this.g[n3] == null) {
                    this.element.getSystem().printErrorMessage("Junction.initialize: Failed to get outflow TS array from node " + rssNode2.getName());
                    this.element.getSystem().printMessage("Junction: " + this.element.getName());
                    return false;
                }
                if (this.o && rssNode != null && (tSRecord = rssNode.getTSRecord((object = rssNode2.getTSRecordProxy(0)).getName(), 0)) != null) {
                    this.h[n3] = tSRecord.getTSContainer();
                }
                ++n3;
                continue;
            }
            this.j[n5] = 1.0;
            this.e[n5] = rssNode2.getTSContainer(4);
            if (this.e[n5] != null) {
                this.j[n5] = rssNode2.getTSFactor(4);
                if (rssAlt != null && this.getElement() instanceof JunctionElement) {
                    object = rssNode2.getName();
                    int n6 = ((String)object).lastIndexOf("~");
                    if (n6 >= 0) {
                        object = ((String)object).substring(n6 + 1);
                    }
                    this.k[n5] = rssAlt.getLocationInflowFactor((JunctionElement)this.getElement(), (String)object);
                }
                this.f[n5] = rssNode2.getTSContainer(0);
            } else {
                this.f[n5] = rssNode2.getTSContainer(0);
            }
            if (this.f[n5] == null) {
                this.element.getSystem().printErrorMessage("Junction.initialize: Failed to get inflow TS array from node " + rssNode2.getName());
                this.element.getSystem().printMessage("Junction: " + this.element.getName());
                return false;
            }
            ++n5;
        }
        this.i = this.getTSContainer(197);
        this.l = this.getTSContainer(65);
        this.m = this.getTSContainer(66);
        this.n = this.getTSContainer(68);
        if (this._tailElev != null && this._hasTailElev) {
            this._tailElev.initialize();
        }
        if (this._ratingObject != null) {
            this._ratingObject.initialize();
        }
        return true;
    }

    public double getTotalLocalFlowFactor(String string) {
        double d = 1.0;
        RssAlt rssAlt = this.getElement().getSystem().getAlternative();
        int n = this.element.getNodeCount();
        for (int i = 0; i < n; ++i) {
            RssNode rssNode = this.element.getNode(i);
            if (rssNode == null || !rssNode.isActive() || this.element.getNodeDir(i) == 0 || !rssNode.getName().equals(string)) continue;
            d = rssNode.getTSFactor(4);
            if (rssAlt == null || !(this.getElement() instanceof JunctionElement)) continue;
            string = rssNode.getName();
            i = string.lastIndexOf("~");
            if (i >= 0) {
                string = string.substring(i + 1);
            }
            d *= rssAlt.getLocationInflowFactor((JunctionElement)this.getElement(), string);
            break;
        }
        return d;
    }

    @Override
    public int computeHindcastStep(RunTimeStep runTimeStep) {
        return ((Function)this).computeForecastStep(runTimeStep);
    }

    @Override
    public int computeForecastStep(RunTimeStep runTimeStep) {
        double d;
        double[] dArray;
        int n;
        double d2 = 0.0;
        double d3 = 0.0;
        this.a = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n2 = this.f.length;
        try {
            for (n = 0; n < n2; ++n) {
                dArray = this.f[n].array;
                if (this.f[n].array == null) continue;
                if (this.e[n] != null) {
                    double[] dArray2 = this.e[n].array;
                    if (this.e[n].array != null) {
                        dArray[runTimeStep.step] = dArray2[runTimeStep.step] * this.j[n] * this.k[n];
                        d3 += dArray[runTimeStep.step];
                    }
                }
                d2 += dArray[runTimeStep.step];
                if (dArray[runTimeStep.step] >= 0.0) {
                    d4 += dArray[runTimeStep.step];
                    continue;
                }
                d5 += dArray[runTimeStep.step];
            }
            this.l.array[runTimeStep.step] = d2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("computeForecastStep:WARNING: missing data error for Element " + String.valueOf(this.getElement()));
            ((RssTSLocationObject)this).getSystem().printErrorMessage("Missing data error for Element " + String.valueOf(this.getElement()));
            throw arrayIndexOutOfBoundsException;
        }
        n2 = this.g.length;
        for (n = 0; n < n2; ++n) {
            dArray = this.g[n].array;
            if (this.g[n].array == null) continue;
            dArray[runTimeStep.step] = d2 / (double)n2;
        }
        if (this.o) {
            for (n = 0; n < n2; ++n) {
                if (this.h[n] == null || this.h[n].array == null || !RMAConst.isValidValue((double)(d = this.h[n].array[runTimeStep.step]))) continue;
                this.g[n].array[runTimeStep.step] = d;
            }
        }
        this.a = d2;
        double d6 = d4;
        this.d = d6 + (d6 - this.b);
        this.b = d4;
        this.c = d5;
        if (this.m != null) {
            d = this.getStage(runTimeStep, this.a);
            if (d == Double.NEGATIVE_INFINITY) {
                d = -3.4028234663852886E38;
            }
            this.m.array[runTimeStep.step] = d;
        }
        if (this.n != null) {
            this.n.array[runTimeStep.step] = d = this.getElevation(runTimeStep, this.a);
        }
        if (this.i != null) {
            this.i.array[runTimeStep.step] = d3;
        }
        if (this._tailElev != null && this._hasTailElev) {
            this._tailElev.computeElevation(runTimeStep);
        }
        return 0;
    }

    public Junction$JuncRatingType getRatingType() {
        if (this._ratingType == Junction$JuncRatingType.UNDEF && this._ratingObject != null) {
            if (this._ratingObject.usesIndependentVariable()) {
                this._ratingType = Junction$JuncRatingType.RATINGOBJECT;
            } else if (this._ratingCurve != null) {
                this._ratingType = Junction$JuncRatingType.PAIREDVALUES;
            }
        }
        return this._ratingType;
    }

    public void setRatingType(Junction$JuncRatingType junction$JuncRatingType) {
        this._ratingType = junction$JuncRatingType;
    }

    public double getElevation(RunTimeStep runTimeStep, double d) {
        double d2 = Double.NEGATIVE_INFINITY;
        Junction$JuncRatingType junction$JuncRatingType = this.getRatingType();
        if (junction$JuncRatingType == Junction$JuncRatingType.RATINGOBJECT && this._ratingObject != null) {
            d2 = this._ratingObject.getElevation(runTimeStep, d);
        } else if (junction$JuncRatingType == Junction$JuncRatingType.PAIREDVALUES && this._ratingCurve != null) {
            if (this._ratingObject != null && this._ratingObject.getOutOfRangeValuesToMissing() && this._ratingCurve.isYValueOutOfRange(d)) {
                return Double.NEGATIVE_INFINITY;
            }
            double d3 = this._ratingCurve.getXValue(d);
            double d4 = this.getRatingObjStageDatum();
            d2 = RMAConst.isValidValue((double)d4) ? d3 + d4 : d3;
        }
        return d2;
    }

    public double getRatingObjStageDatum() {
        double d = 0.0;
        RssRatingObject rssRatingObject = this.getRatingObject();
        ParamDouble paramDouble = new ParamDouble();
        rssRatingObject.getStageDatum(paramDouble);
        if (RMAConst.isValidValue((double)paramDouble.getValue())) {
            d = paramDouble.convertToUnitSystem(this.getUnitSystem());
        }
        return d;
    }

    public double getStage(RunTimeStep runTimeStep, double d) {
        double d2 = Double.NEGATIVE_INFINITY;
        Junction$JuncRatingType junction$JuncRatingType = this.getRatingType();
        if (junction$JuncRatingType == Junction$JuncRatingType.RATINGOBJECT && this._ratingObject != null) {
            double d3 = this._ratingObject.getElevation(runTimeStep, d);
            double d4 = this.getRatingObjStageDatum();
            d2 = RMAConst.isValidValue((double)d4) ? d3 - d4 : d3;
        } else if (junction$JuncRatingType == Junction$JuncRatingType.PAIREDVALUES && this._ratingCurve != null) {
            if (this._ratingObject != null && this._ratingObject.getOutOfRangeValuesToMissing() && this._ratingCurve.isYValueOutOfRange(d)) {
                return Double.NEGATIVE_INFINITY;
            }
            d2 = this._ratingCurve.getXValue(d);
        }
        return d2;
    }

    public double getFlowFromStage(RunTimeStep runTimeStep, double d) {
        double d2 = Double.NEGATIVE_INFINITY;
        Junction$JuncRatingType junction$JuncRatingType = this.getRatingType();
        if (junction$JuncRatingType == Junction$JuncRatingType.RATINGOBJECT && this._ratingObject != null) {
            d2 = this._ratingObject.getFlowFromStage(runTimeStep, d);
        } else if (junction$JuncRatingType == Junction$JuncRatingType.PAIREDVALUES && this._ratingCurve != null) {
            if (this._ratingObject != null && this._ratingObject.getOutOfRangeValuesToMissing() && this._ratingCurve.isXValueOutOfRange(d)) {
                return Double.NEGATIVE_INFINITY;
            }
            d2 = this._ratingCurve.getYValue(d);
        }
        return d2;
    }

    @Override
    public Vector getActiveTSProxies(Vector vector, int n) {
        if (vector == null) {
            vector = new Vector<TSRecordProxy>();
        }
        super.getActiveTSProxies(vector, n);
        if (n == 0) {
            vector.add(this.getTSRecordProxy(65));
        }
        if (this._tailElev != null && this._hasTailElev) {
            ((RssTSLocationObject)this._tailElev).getActiveTSRecordProxies(vector, n);
        }
        if (this._ratingObject != null) {
            this._ratingObject.getActiveTSProxies(vector, n);
        }
        return vector;
    }

    @Override
    public void updateTSProxyList() {
        super.updateTSProxyList();
        TSRecordProxy tSRecordProxy = this.getTSRecordProxy(65);
        if (tSRecordProxy == null) {
            this.addTSRecordProxy(65);
        }
        if (!this.hasRatingCurve()) {
            this.removeTSRecordProxy(66);
            this.removeTSRecordProxy(68);
        } else {
            String string;
            tSRecordProxy = this.getTSRecordProxy(66);
            if (tSRecordProxy == null) {
                this.addTSRecordProxy(66);
            }
            if ((tSRecordProxy = this.getTSRecordProxy(68)) == null) {
                this.addTSRecordProxy(68);
                tSRecordProxy = this.getTSRecordProxy(68);
            }
            VerticalDatumSettings verticalDatumSettings = new VerticalDatumSettings(this._verticalDatumSettings);
            try {
                string = Parameter.getParameter((int)Parameter.PARAMID_ELEV).getUnitsStringForSystem(this.getUnitSystem());
                verticalDatumSettings.setUnits(string);
            }
            catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
                Logger.getLogger(ReservoirElement.class.getName()).log(Level.SEVERE, null, dataSetIllegalArgumentException);
            }
            string = verticalDatumSettings.toVerticalDatumXml();
            try {
                tSRecordProxy.setVerticalDatumInfo(string);
            }
            catch (VerticalDatumException verticalDatumException) {
                Logger.getLogger(Junction.class.getName()).log(Level.SEVERE, null, verticalDatumException);
            }
        }
        if (this._tailElev != null && this._hasTailElev) {
            ((RssTSLocationObject)this._tailElev).updateTSProxyList();
        }
        if (this._ratingObject != null) {
            ((RssTSLocationObject)this._ratingObject).updateTSProxyList();
        }
    }

    @Override
    public Vector getComputedTSRecordProxies(Vector vector) {
        Object object;
        vector = super.getComputedTSRecordProxies(vector);
        int n = this.element.getNodeCount();
        for (int i = 0; i < n; ++i) {
            object = this.element.getNode(i);
            if (object == null || !((RssNode)object).isActive() || ((RssNode)object).getTSRecordProxy(4) == null || (object = ((RssNode)object).getTSRecordProxy(0)) == null) continue;
            vector.add(object);
        }
        object = this.getTSRecordProxy(65);
        if (object != null) {
            vector.add(object);
        }
        if (this.hasRatingCurve()) {
            object = this.getTSRecordProxy(66);
            if (object == null) {
                this.addTSRecordProxy(66);
                object = this.getTSRecordProxy(66);
            }
            if (object != null) {
                vector.add(object);
            }
            if ((object = this.getTSRecordProxy(68)) == null) {
                this.addTSRecordProxy(68);
                object = this.getTSRecordProxy(68);
            }
            if (object != null) {
                vector.add(object);
            }
        }
        return vector;
    }

    public boolean hasRatingCurve() {
        Junction$JuncRatingType junction$JuncRatingType = this.getRatingType();
        boolean bl = false;
        if (junction$JuncRatingType == Junction$JuncRatingType.PAIREDVALUES) {
            if (this._ratingCurve != null && this._ratingCurve.size() > 0) {
                bl = true;
            }
        } else if (junction$JuncRatingType == Junction$JuncRatingType.RATINGOBJECT && this._ratingObject != null && !this._ratingObject.isEmpty()) {
            bl = true;
        }
        return bl;
    }

    public PairedValues getRatingCurve() {
        this._ratingCurve.setUnitSystem(this.getUnitSystem());
        this._ratingCurve.setParamXId(Parameter.PARAMID_STAGE);
        this._ratingCurve.setParamYId(Parameter.PARAMID_FLOW);
        return (PairedValues)this._ratingCurve.clone();
    }

    public void setRatingCurve(PairedValues pairedValues) {
        if (pairedValues == null) {
            return;
        }
        this._ratingCurve = pairedValues;
        this._ratingCurve.setUnitSystem(this.getUnitSystem());
        this._ratingCurve.setParamXId(Parameter.PARAMID_STAGE);
        this._ratingCurve.setParamYId(Parameter.PARAMID_FLOW);
    }

    public RssRatingObject getRatingObject() {
        if (this._ratingObject == null) {
            this._ratingObject = new RssRatingObject(this.element);
            IndependentVariable independentVariable = this.getDefaultIndependentVariable();
            this._ratingObject.setIndependentVariable(independentVariable);
            this._ratingObject.setRatingName("Tail Rating Curve");
        }
        return this._ratingObject;
    }

    public void setRatingObject(RssRatingObject rssRatingObject) {
        this._ratingObject = rssRatingObject;
    }

    public IndependentVariable getDefaultIndependentVariable() {
        IndependentVariable independentVariable = new IndependentVariable(2);
        TSLocation tSLocation = this.getElement();
        Element element = tSLocation.getTopParent();
        if ((tSLocation = tSLocation.getDownstreamNode()) == null) {
            return null;
        }
        tSLocation = tSLocation.getTSRecordProxy(0);
        ModelVariable modelVariable = new ModelVariable("Node", "Flow", 0, Parameter.PARAMID_FLOW);
        independentVariable.setModalVariableInfo((TSRecordProxy)tSLocation, element, modelVariable);
        return independentVariable;
    }

    public void getReferencedStateVariables(List list) {
        if (this._ratingObject != null) {
            this._ratingObject.getReferencedStateVariables(list);
        }
    }

    public void setVerticalDatumSettings(VerticalDatumSettings verticalDatumSettings) {
        this._verticalDatumSettings = verticalDatumSettings != null ? verticalDatumSettings : new VerticalDatumSettings();
    }

    public VerticalDatumSettings getVerticalDatumSettings() {
        return this._verticalDatumSettings;
    }

    @Override
    @Deprecated
    public boolean writeData(BufferedWriter bufferedWriter) {
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"Element Function=Junction");
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Element Junction Name=" + this.getName()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"Element Junction End");
        return true;
    }

    @Override
    @Deprecated
    public boolean readData(BufferedReader bufferedReader) {
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.length() == 0) {
                    string = bufferedReader.readLine();
                    continue;
                }
                if (string.indexOf("Element Junction") < 0) break;
                String string2 = RMAIO.getType((String)string, (String)"=");
                string = RMAIO.getParam((String)string, (String)"=");
                if (string2.compareTo("Element Junction Name") == 0) {
                    this.setName(string);
                } else if (string2.compareTo("Element Junction End") == 0) break;
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

