/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.StreamAlignment;
import hec.clientapp.model.TSRecordProxy;
import hec.lang.NamedType;
import hec.lang.annotation.Scriptable;
import hec.map.WorldPt;
import hec.model.ModelVariable;
import hec.model.PairedValues;
import hec.model.PairedValuesExt;
import hec.model.StreamElement;
import hec.model.TSRecord;
import hec.rss.model.AdjustableDiversion;
import hec.rss.model.DiversionElement;
import hec.rss.model.DownstreamCntrlOpRule;
import hec.rss.model.DownstreamOp;
import hec.rss.model.Element;
import hec.rss.model.ElementAssignmentContainer;
import hec.rss.model.Function;
import hec.rss.model.FunctionFactory;
import hec.rss.model.IndependentVariable;
import hec.rss.model.Junction;
import hec.rss.model.OpRule;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssNode;
import hec.rss.model.RssRatingObject;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.RuleResolution;
import hec.rss.model.reports.AltInputReportEnums;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import hec.rss.server.JunctionElementData;
import hec.util.XMLUtilities;
import hec.watershed.model.ComputationPoint;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.jdom.Content;
import rma.util.NumberFormat;
import rma.util.RMAIO;
import rma.util.rmaTokenizer;

public class JunctionElement
extends Element
implements AltInputReportInfc {
    protected boolean _hasKnownOutflow = false;
    protected int _cpIndex = 0;
    Vector _localFlowVec = new Vector();
    int _labelPosition = 0;
    long _computationPointId = Long.MIN_VALUE;
    private transient ComputationPoint a;
    private transient double b = Double.NEGATIVE_INFINITY;
    private transient StreamElement c = null;
    private int _streamJunctionId = -1;
    private String _fillColorName;

    public JunctionElement() {
        this._function = new Junction(this);
    }

    public JunctionElement(RssSystem rssSystem, int n) {
        super(rssSystem, n);
        this._function = new Junction(this);
    }

    public void setLabelPosition(int n) {
        this._labelPosition = n;
    }

    public int getLabelPosition() {
        return this._labelPosition;
    }

    public String getFillColorName() {
        return this._fillColorName;
    }

    public void setFillColorName(String string) {
        this._fillColorName = string;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public boolean isDownstreamControlLocation() {
        int n = this._nodeVector.size();
        for (int i = 0; i < n; ++i) {
            RssReturnStatusConstants rssReturnStatusConstants = this._nodeVector.elementAt(i);
            if ((rssReturnStatusConstants = this._system.getDownstreamOp(rssReturnStatusConstants.getIndex())) == null || ((DownstreamOp)rssReturnStatusConstants).isRuleTableEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isConfluence() {
        if (!(this._function instanceof Junction)) {
            return false;
        }
        Junction junction = (Junction)this._function;
        return junction.isConfluence();
    }

    public Vector getDiversions(Vector vector) {
        if (vector == null) {
            vector = new Vector<Element>();
        }
        int n = this._nodeVector.size();
        for (int i = 0; i < n; ++i) {
            RssNode rssNode = this._nodeVector.elementAt(i);
            if (rssNode == null) continue;
            int n2 = this._nodeDirVector.elementAt(i);
            Element element = null;
            if (n2 == 1) {
                element = rssNode.getUpstreamElement();
            }
            if (element == null) continue;
            while (element.getParent() != null) {
                element = element.getParent();
            }
            if (!(element instanceof DiversionElement) || ((Element)((DiversionElement)element)).getUpstreamNode() != rssNode) continue;
            vector.addElement(element);
        }
        return vector;
    }

    @Override
    public Vector getRequiredTSRecordProxies() {
        Vector<TSRecordProxy> vector = new Vector<TSRecordProxy>();
        List list = this.getDownstreamNodes(null);
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            TSRecordProxy tSRecordProxy;
            RssReturnStatusConstants rssReturnStatusConstants = this._nodeVector.get(i);
            if (list.contains(rssReturnStatusConstants) || ((RssNode)rssReturnStatusConstants).getTSRecordProxy(4) != null || (tSRecordProxy = ((RssNode)rssReturnStatusConstants).getTSRecordProxy(0)) == null || tSRecordProxy.isInput()) continue;
            vector.addElement(tSRecordProxy);
            rssReturnStatusConstants = ((RssNode)rssReturnStatusConstants).getUpstreamElement();
            if (rssReturnStatusConstants == null || !(((Element)rssReturnStatusConstants).getTopParent() instanceof DiversionElement)) continue;
            rssReturnStatusConstants = (DiversionElement)((Element)rssReturnStatusConstants).getTopParent();
            if (list.contains(rssReturnStatusConstants = ((DiversionElement)rssReturnStatusConstants).getSourceElement().getDownstreamNode()) || (tSRecordProxy = ((RssNode)rssReturnStatusConstants).getTSRecordProxy(0)) == null || tSRecordProxy.isInput()) continue;
            vector.addElement(tSRecordProxy);
        }
        return vector;
    }

    public Vector getConnectedElements() {
        Vector<RssReturnStatusConstants> vector = new Vector<RssReturnStatusConstants>();
        int n = this._nodeVector.size();
        for (int i = 0; i < n; ++i) {
            RssReturnStatusConstants rssReturnStatusConstants = this._nodeVector.elementAt(i);
            int n2 = this._nodeDirVector.elementAt(i);
            rssReturnStatusConstants = n2 == 1 ? ((RssNode)rssReturnStatusConstants).getUpstreamElement() : ((RssNode)rssReturnStatusConstants).getDownstreamElement();
            if (rssReturnStatusConstants == null) continue;
            while (((Element)rssReturnStatusConstants).getParent() != null) {
                rssReturnStatusConstants = ((Element)rssReturnStatusConstants).getParent();
            }
            vector.addElement(rssReturnStatusConstants);
        }
        return vector;
    }

    public long getComputationPointId() {
        return this._computationPointId;
    }

    public void setComputationPoint(ComputationPoint computationPoint) {
        this.a = computationPoint;
        if (computationPoint == null) {
            this._computationPointId = Long.MIN_VALUE;
            return;
        }
        this._computationPointId = computationPoint.getId();
        this.setName(computationPoint.getName());
        this.setDescription(computationPoint.getDescription());
    }

    public boolean hasRatingCurve() {
        return ((Junction)this._function).hasRatingCurve();
    }

    @Override
    public List getActiveStateVariables(List list) {
        if (this._function instanceof Junction) {
            ((Junction)this._function).getReferencedStateVariables(list);
        }
        return list;
    }

    public void getData(JunctionElementData junctionElementData) {
        if (junctionElementData == null) {
            return;
        }
        junctionElementData.a = this.getName();
        junctionElementData.b = this.getDescription();
        junctionElementData.c = this.getStreamStation();
        junctionElementData.g = this.getCPIndex();
        StreamElement streamElement = this.getStream();
        junctionElementData.d = streamElement != null ? streamElement.getName() : "<none>";
        junctionElementData.e = this.getTribNameArray();
        junctionElementData.f = this._hasKnownOutflow;
        junctionElementData.j = this._labelPosition;
        junctionElementData.i = this.getLocalFlowVector();
        junctionElementData.h = this._computationPointId;
        junctionElementData.k = this._fillColorName;
    }

    public void setData(JunctionElementData junctionElementData) {
        this.setData(junctionElementData, true);
    }

    public void setData(JunctionElementData junctionElementData, boolean bl) {
        RssNode rssNode;
        if (junctionElementData == null) {
            return;
        }
        if (bl) {
            this.setDescription(junctionElementData.b);
            JunctionElement junctionElement = this;
            junctionElement.setStreamStation(junctionElement.getStream(), junctionElementData.c);
            this.setCPIndex(junctionElementData.g);
        }
        this.setLocalFlowVector(junctionElementData.i);
        this._labelPosition = junctionElementData.j;
        this._fillColorName = junctionElementData.k;
        if (junctionElementData.f != this._hasKnownOutflow && (rssNode = this.getDownstreamNode()) != null) {
            if (junctionElementData.f) {
                rssNode.addTSRecord(this.getName() + " Known Outflow", "FLOW", true);
            } else {
                rssNode.removeTSRecord(this.getName() + " Known Outflow", "FLOW", true);
            }
            this._hasKnownOutflow = junctionElementData.f;
        }
    }

    public double getStreamStation() {
        if (this.b == Double.NEGATIVE_INFINITY) {
            for (int i = 0; i < this._nodeVector.size(); ++i) {
                RssNode rssNode = this._nodeVector.elementAt(i);
                Integer n = this._nodeDirVector.elementAt(i);
                if (n != 0) continue;
                this.b = rssNode.getStreamStation();
            }
        }
        return this.b;
    }

    public boolean setStreamStation(StreamElement streamElement, double d) {
        RssNode rssNode;
        int n;
        if (streamElement != null) {
            for (n = 0; n < this._nodeVector.size(); ++n) {
                rssNode = this._nodeVector.elementAt(n);
                if (rssNode.getStream() == null || rssNode.getStream() == this.getStream()) continue;
                StreamAlignment streamAlignment = this._system.getAlignment();
                if (streamAlignment == null) {
                    return false;
                }
                streamElement = streamElement.getLocationByStation(d);
                for (int i = 0; i < this._nodeVector.size(); ++i) {
                    RssNode rssNode2 = this._nodeVector.elementAt(i);
                    rssNode = streamAlignment.findNearestStreamNode(rssNode2.getStream(), (WorldPt)streamElement);
                    if (rssNode == null) continue;
                    rssNode2.setStreamStation(rssNode.getStation());
                }
                return false;
            }
            if (this.getStream() != streamElement) {
                if (this.c != null) {
                    this._system.printMessage("JunctionElement.setStreamStation: Warning - attempted to set station of junction " + this.getName() + " currently on stream " + this.c.getName() + " to a station on stream " + streamElement.getName());
                }
                return false;
            }
        }
        for (n = 0; n < this._nodeVector.size(); ++n) {
            rssNode = this._nodeVector.elementAt(n);
            rssNode.setStreamStation(d);
        }
        this.b = d;
        return true;
    }

    public void resetStream() {
        this.c = null;
        this.getStream();
    }

    public StreamElement getStream() {
        if (this.c == null) {
            for (int i = 0; i < this._nodeVector.size(); ++i) {
                RssNode rssNode = this._nodeVector.elementAt(i);
                Integer n = this._nodeDirVector.elementAt(i);
                if (rssNode == null || n != 0) continue;
                this.c = rssNode.getStream();
                if (this.c != null) continue;
                System.out.println(this.getName() + ".getStream: can't find stream for node " + rssNode.getName());
            }
        }
        return this.c;
    }

    public String[] getTribNameArray() {
        this.getStream();
        if (this.c == null) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            Object object = this._nodeVector.elementAt(i);
            if (((RssNode)object).getStream() == null || ((RssNode)object).getStream() == this.c) continue;
            object = ((RssNode)object).getStream().getName();
            boolean bl = false;
            for (int j = 0; j < vector.size(); ++j) {
                if (!((String)object).equals(vector.elementAt(j))) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            vector.addElement(object);
        }
        if (vector.size() > 0) {
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                stringArray[i] = (String)vector.elementAt(i);
            }
            return stringArray;
        }
        return null;
    }

    public Vector getLocalFlowVector() {
        Vector<String[]> vector = new Vector<String[]>();
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            RssNode rssNode = this._nodeVector.elementAt(i);
            Integer n = this._nodeDirVector.elementAt(i);
            if (n != 1 || rssNode.getUpstreamElement() != null || (n = rssNode.getTSRecordProxy(4)) == null) continue;
            String[] stringArray = new String[4];
            String[] stringArray2 = stringArray;
            stringArray[0] = n.getName();
            stringArray2[1] = NumberFormat.sprintf((String)"%.3f", (double)n.getFactor());
            stringArray2[2] = Integer.toString(n.getIndex());
            stringArray2[3] = Integer.toString(rssNode.getIndex());
            vector.addElement(stringArray2);
        }
        return vector;
    }

    public void setLocalFlowVector(Vector object) {
        int n;
        Object object2;
        Vector<RssNode> vector = new Vector<RssNode>();
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            RssNode rssNode = this._nodeVector.elementAt(i);
            object2 = this._nodeDirVector.elementAt(i);
            if (object2.intValue() != 1 || rssNode.getUpstreamElement() != null || rssNode.getTSRecordProxy(4) == null) continue;
            vector.addElement(rssNode);
        }
        Vector vector2 = (Vector)((Vector)object).clone();
        block1: for (n = vector2.size() - 1; n >= 0; --n) {
            object2 = (String[])vector2.elementAt(n);
            if (object2[3] == null) continue;
            int n2 = RMAIO.parseInt((String)object2[3]);
            double d = Double.NEGATIVE_INFINITY;
            if (object2[1] != null && object2[1].length() > 0) {
                d = RMAIO.parseDouble((String)object2[1]);
            }
            for (int i = vector.size() - 1; i >= 0; --i) {
                RssNode rssNode = (RssNode)vector.elementAt(i);
                if (n2 != rssNode.getIndex()) continue;
                TSRecordProxy tSRecordProxy = rssNode.getTSRecordProxy(4);
                rssNode.setName(object2[0]);
                tSRecordProxy.setName(object2[0]);
                if (d != Double.NEGATIVE_INFINITY) {
                    tSRecordProxy.setFactor(d);
                }
                vector.removeElementAt(i);
                vector2.removeElementAt(n);
                continue block1;
            }
        }
        for (n = 0; n < vector2.size(); ++n) {
            RssNode rssNode;
            object2 = (String[])vector2.elementAt(n);
            if (object2 == null || object2[0] == null || object2[0].length() == 0) continue;
            double d = Double.NEGATIVE_INFINITY;
            if (object2[1] != null && object2[1].length() > 0) {
                d = RMAIO.parseDouble((String)object2[1]);
            }
            if (vector.size() > 0) {
                Vector<RssNode> vector3 = vector;
                rssNode = (RssNode)vector3.elementAt(vector3.size() - 1);
                Vector<RssNode> vector4 = vector;
                vector4.removeElementAt(vector4.size() - 1);
            } else {
                object = this.getDownstreamNode();
                rssNode = this._system.createNode(((RssNode)object).getLocation());
                rssNode.setStreamIndex(object.getStreamIndex());
                rssNode.setStreamName(object.getStreamName());
                rssNode.setStreamCoord(((RssNode)object).getStreamCoord());
                rssNode.setStreamStation(object.getStreamStation());
                this.addNode(rssNode, 1);
            }
            JunctionElement junctionElement = this;
            rssNode.setName(junctionElement.getKeyStringForObject(junctionElement) + "~" + object2[0]);
            rssNode.addTSRecordProxy(4);
            object = rssNode.getTSRecordProxy(4);
            object.setName(object2[0]);
            if (d != Double.NEGATIVE_INFINITY) {
                object.setFactor(d);
            }
            rssNode.addTSRecordProxy(0);
            object = rssNode.getTSRecordProxy(0);
            object.setName(rssNode.getName());
        }
        for (n = 0; n < vector.size(); ++n) {
            object2 = (RssNode)vector.elementAt(n);
            object2.dispose();
        }
        this._system.cleanVectors();
    }

    public void setCPIndex(int n) {
        this._cpIndex = n;
    }

    public int getCPIndex() {
        return this._cpIndex;
    }

    @Override
    public boolean readData(BufferedReader bufferedReader) {
        try {
            Object object = bufferedReader.readLine();
            while (object != null) {
                if (((String)object).length() == 0) {
                    object = bufferedReader.readLine();
                    continue;
                }
                String string = RMAIO.getType((String)object, (String)"=");
                object = RMAIO.getParam((String)object, (String)"=");
                if (string.compareTo("JunctionElement Name") == 0) {
                    this.setName((String)object);
                } else if (string.compareTo("JunctionElement Description") == 0) {
                    this.setDescription((String)object);
                } else if (string.compareTo("Element Nodes") == 0) {
                    var4_7 = new rmaTokenizer((String)object, ",");
                    int n = 0;
                    while (var4_7.hasMoreTokens()) {
                        try {
                            int n2;
                            object = var4_7.nextToken();
                            if (this._nodeVector.size() < n + 1) {
                                this._nodeVector.setSize(n + 1);
                            }
                            if ((n2 = RMAIO.parseInt((String)object)) >= 0 && n2 != Integer.MIN_VALUE) {
                                var5_8 = this._system.getNode(n2);
                                this._nodeVector.setElementAt((RssNode)var5_8, n);
                                if (var5_8 == null) {
                                    this._system.printMessage("Warning! RssNode " + n2 + " not found");
                                }
                            }
                            ++n;
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            break;
                        }
                    }
                } else if (string.compareTo("Element NodeDir") == 0) {
                    var4_7 = new rmaTokenizer((String)object, ",");
                    int n = 0;
                    try {
                        while (true) {
                            object = var4_7.nextToken();
                            if (this._nodeDirVector.size() < n + 1) {
                                this._nodeDirVector.setSize(n + 1);
                            }
                            int[] nArray = new int[1];
                            var5_8 = nArray;
                            nArray[0] = RMAIO.parseInt((String)object);
                            if (var5_8[0] >= 0 && var5_8[0] != Integer.MIN_VALUE) {
                                this._nodeDirVector.setElementAt(new Integer(var5_8[0]), n);
                                object = this._nodeVector.elementAt(n);
                                if (var5_8[0] == 0) {
                                    ((RssNode)object).setUpstreamElement(this);
                                } else {
                                    ((RssNode)object).setDownstreamElement(this);
                                }
                            }
                            ++n;
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                } else if (string.compareTo("Element Function") == 0) {
                    var4_7 = FunctionFactory.a(this, (String)object);
                    if (var4_7 == null) {
                        this._system.printMessage("Could not create Function " + (String)object);
                    } else if (((Function)var4_7).readData(bufferedReader)) {
                        this._function = var4_7;
                    }
                } else if (string.compareTo("JunctionElement End") == 0) break;
                object = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    public boolean writeData(BufferedWriter bufferedWriter) {
        Object object;
        int n;
        new String();
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("JunctionElement=" + this.getIndex()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("JunctionElement Name= " + this.getName()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("JunctionElement Description= " + this.getDescription()));
        if (this._function != null) {
            this._function.writeData(bufferedWriter);
        }
        Object object2 = "Element Nodes= ";
        for (n = 0; n < this._nodeVector.size(); ++n) {
            object = this._nodeVector.elementAt(n);
            object2 = (String)object2 + object.getIndex() + ", ";
        }
        if (this._nodeVector.size() > 0) {
            object2 = ((String)object2).substring(0, ((String)object2).length() - 2);
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)object2);
        object2 = "Element NodeDir= ";
        for (n = 0; n < this._nodeDirVector.size(); ++n) {
            object = this._nodeDirVector.elementAt(n);
            object2 = (String)object2 + ((Integer)object).toString() + ", ";
        }
        if (this._nodeDirVector.size() > 0) {
            object2 = ((String)object2).substring(0, ((String)object2).length() - 2);
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)object2);
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"");
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"JunctionElement End");
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"");
        return true;
    }

    public void addJunction(JunctionElement junctionElement) {
        RssNode rssNode = this.getDownstreamNode();
        junctionElement.getDownstreamNode();
        boolean bl = false;
        if (rssNode.getDownstreamElement() != null) {
            bl = true;
        }
        int n = junctionElement._nodeVector.size();
        for (int i = 1; i <= n; ++i) {
            RssNode rssNode2 = junctionElement._nodeVector.elementAt(n - i);
            if (rssNode2 == null) continue;
            Integer n2 = junctionElement._nodeDirVector.elementAt(n - i);
            if (n2 == 1) {
                this.addNode(rssNode2, n2);
                junctionElement.removeNode(rssNode2);
                continue;
            }
            if (rssNode2.getDownstreamElement() != null) {
                this.addNode(rssNode2, n2);
                junctionElement.removeNode(rssNode2);
                if (bl) continue;
                this.removeNode(rssNode);
                continue;
            }
            if (!(rssNode.getStreamCoord() < 0.01)) continue;
            this.addNode(rssNode2, n2);
            junctionElement.removeNode(rssNode2);
            if (bl) continue;
            this.removeNode(rssNode);
        }
        junctionElement.dispose();
        this._system.cleanVectors();
    }

    public boolean hasConnectedElements() {
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            Integer n;
            RssNode rssNode = this._nodeVector.elementAt(i);
            if (rssNode == null || !((n = this._nodeDirVector.elementAt(i)) == 1 ? rssNode.getUpstreamElement() != null : rssNode.getDownstreamElement() != null)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Vector getModelVariables(Vector vector) {
        if (vector == null) {
            vector = new Vector<ModelVariable>();
        }
        vector.add(RssModelVariableSet.getModelVariable(110));
        vector.add(RssModelVariableSet.getModelVariable(117));
        vector.add(RssModelVariableSet.getModelVariable(118));
        vector.add(RssModelVariableSet.getModelVariable(119));
        vector.add(RssModelVariableSet.getModelVariable(111));
        vector.add(RssModelVariableSet.getModelVariable(112));
        vector.add(RssModelVariableSet.getModelVariable(115));
        vector.add(RssModelVariableSet.getModelVariable(116));
        vector.add(RssModelVariableSet.getModelVariable(81));
        vector.add(RssModelVariableSet.getModelVariable(82));
        vector.add(RssModelVariableSet.getModelVariable(80));
        vector.add(RssModelVariableSet.getModelVariable(131));
        vector.add(RssModelVariableSet.getModelVariable(132));
        vector.add(RssModelVariableSet.getModelVariable(133));
        return vector;
    }

    @Override
    public Vector getDefaultModelVariables() {
        Vector<ModelVariable> vector = new Vector<ModelVariable>();
        vector.add(RssModelVariableSet.getModelVariable(110));
        return vector;
    }

    @Override
    public Vector getTSRecords(ModelVariable object, Vector vector) {
        if (vector == null) {
            vector = new Vector<Object>();
        }
        if (object == null) {
            return vector;
        }
        switch (object.getType()) {
            case 110: {
                List list = this.getDownstreamNodes(null);
                for (int i = 0; i < list.size(); ++i) {
                    TSRecordProxy tSRecordProxy;
                    object = (RssNode)list.get(i);
                    if (object == null || (tSRecordProxy = ((RssNode)object).getTSRecordProxy(0)) == null) continue;
                    vector.addElement(tSRecordProxy);
                }
                break;
            }
            case 80: 
            case 81: 
            case 82: {
                Vector<ReservoirElement> vector2 = this._system.getElementVectorByClass(ReservoirElement.class);
                RssAlt rssAlt = this._system.getAlternative();
                if (vector2 == null || vector2.size() <= 0 || rssAlt == null) break;
                int n = vector2.size();
                for (int i = 0; i < n; ++i) {
                    NamedType namedType = (ReservoirElement)vector2.get(i);
                    if (namedType == null) continue;
                    int n2 = rssAlt.getResOpSetSelection(namedType.getIndex());
                    Vector vector3 = new Vector();
                    namedType.getDownstreamRules(n2, vector3);
                    int n3 = vector3.size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        namedType = (OpRule)vector3.elementAt(n2);
                        if (!(namedType instanceof DownstreamCntrlOpRule)) continue;
                        namedType = (DownstreamCntrlOpRule)namedType;
                        int n4 = namedType.getDownstreamControlLocationID();
                        RssNode rssNode = this._system.getNode(n4);
                        JunctionElement junctionElement = null;
                        if (rssNode.getUpstreamElement() instanceof JunctionElement) {
                            junctionElement = (JunctionElement)rssNode.getUpstreamElement();
                        } else if (rssNode.getDownstreamElement() instanceof JunctionElement) {
                            junctionElement = (JunctionElement)rssNode.getDownstreamElement();
                        }
                        if (junctionElement != this) continue;
                        namedType = namedType.getParentRule();
                        if ((namedType = namedType.getTSRecordProxy(object.getType())) == null || vector.contains(namedType)) continue;
                        vector.addElement(namedType);
                    }
                }
                break;
            }
            case 117: {
                Vector vector4 = this.getNodeVector();
                for (int i = 0; i < vector4.size(); ++i) {
                    TSRecordProxy tSRecordProxy;
                    Element element;
                    Integer n;
                    object = (RssNode)vector4.elementAt(i);
                    if (object == null || (n = this._nodeDirVector.elementAt(i)) == 0 || (element = ((RssNode)object).getUpstreamElement()) != null && element.getFunction() instanceof AdjustableDiversion || (tSRecordProxy = ((RssNode)object).getTSRecordProxy(4)) != null || (tSRecordProxy = ((RssNode)object).getTSRecordProxy(0)) == null) continue;
                    vector.addElement(tSRecordProxy);
                }
                break;
            }
            case 119: {
                Vector vector5 = this.getNodeVector();
                for (int i = 0; i < vector5.size(); ++i) {
                    TSRecordProxy tSRecordProxy;
                    Element element;
                    Integer n;
                    object = (RssNode)vector5.elementAt(i);
                    if (object == null || (n = this._nodeDirVector.elementAt(i)) == 0 || (element = ((RssNode)object).getUpstreamElement()) == null || !(element.getFunction() instanceof AdjustableDiversion) || (tSRecordProxy = ((RssNode)object).getTSRecordProxy(0)) == null) continue;
                    vector.addElement(tSRecordProxy);
                }
                break;
            }
            case 118: {
                Vector vector6 = this.getNodeVector();
                for (int i = 0; i < vector6.size(); ++i) {
                    TSRecordProxy tSRecordProxy;
                    Integer n;
                    object = (RssNode)vector6.elementAt(i);
                    if (object == null || (n = this._nodeDirVector.elementAt(i)) == 0 || (tSRecordProxy = ((RssNode)object).getTSRecordProxy(4)) == null || (tSRecordProxy = ((RssNode)object).getTSRecordProxy(0)) == null) continue;
                    vector.addElement(tSRecordProxy);
                }
                break;
            }
            case 111: {
                List list = this.getDownstreamNodes(null);
                for (int i = 0; i < list.size(); ++i) {
                    TSRecordProxy tSRecordProxy;
                    object = (RssNode)list.get(i);
                    if (object == null || (tSRecordProxy = ((RssNode)object).getTSRecordProxy(0)) == null) continue;
                    vector.addElement(tSRecordProxy);
                }
                break;
            }
            case 112: {
                List list = this.getDownstreamNodes(null);
                for (int i = 0; i < list.size(); ++i) {
                    TSRecordProxy tSRecordProxy;
                    object = (RssNode)list.get(i);
                    if (object == null || (tSRecordProxy = ((RssNode)object).getTSRecordProxy(0)) == null) continue;
                    vector.addElement(tSRecordProxy);
                }
                break;
            }
            case 115: {
                TSRecordProxy tSRecordProxy = this._function.getTSRecordProxy(66);
                if (tSRecordProxy == null) break;
                vector.addElement(tSRecordProxy);
                break;
            }
            case 116: {
                TSRecordProxy tSRecordProxy = this._function.getTSRecordProxy(66);
                if (tSRecordProxy == null) break;
                vector.addElement(tSRecordProxy);
            }
        }
        return vector;
    }

    public boolean importFrom(RuleResolution object) {
        if (!(((ElementAssignmentContainer)object).b instanceof JunctionElement)) {
            System.out.println("importFrom: can't import a JunctionElement from a " + String.valueOf(((ElementAssignmentContainer)object).b));
            return false;
        }
        object = (JunctionElement)((ElementAssignmentContainer)object).b;
        this.setDescription(object.getDescription());
        Object object2 = (Junction)((Element)object).getFunction();
        PairedValues pairedValues = ((Junction)object2).getRatingCurve();
        object2 = new JunctionElementData();
        ((JunctionElement)object).getData((JunctionElementData)object2);
        this.setData((JunctionElementData)object2, false);
        object2 = (Junction)this.getFunction();
        ((Junction)object2).setRatingCurve((PairedValues)pairedValues.clone());
        this.importObservedData((Element)object, null);
        this.setModified(true);
        this.getSystem().setModified(true);
        return true;
    }

    @Scriptable
    public TSRecord getLocalFlowTimeSeries(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        Vector vector = this.getNodeVector();
        for (int i = 0; i < vector.size(); ++i) {
            Integer n;
            RssNode rssNode = (RssNode)vector.elementAt(i);
            if (rssNode == null || (n = this._nodeDirVector.elementAt(i)) == 0 || (n = rssNode.getTSRecordProxy(4)) == null || (n = rssNode.getTSRecordProxy(0)) == null || n.getName().indexOf(string) < 0) continue;
            return n.getTSRecord();
        }
        return null;
    }

    @Scriptable
    public List<TSRecord> getLocalFlowTimeSeries() {
        Vector vector = this.getNodeVector();
        ArrayList<TSRecord> arrayList = new ArrayList<TSRecord>();
        for (int i = 0; i < vector.size(); ++i) {
            Integer n;
            RssNode rssNode = (RssNode)vector.elementAt(i);
            if (rssNode == null || (n = this._nodeDirVector.elementAt(i)) == 0 || (n = rssNode.getTSRecordProxy(4)) == null || (n = rssNode.getTSRecordProxy(0)) == null || (rssNode = n.getTSRecord()) == null) continue;
            arrayList.add((TSRecord)rssNode);
        }
        return arrayList;
    }

    @Override
    public void updateTSProxyList() {
        super.updateTSProxyList();
        if (!this.getLocalFlowVector().isEmpty()) {
            this._function.removeTSRecordProxy(197);
            TSRecordProxy tSRecordProxy = this._function.getTSRecordProxy(197);
            if (tSRecordProxy == null) {
                this._function.addTSRecordProxy(197);
            }
        }
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        Cloneable cloneable;
        org.jdom.Element element2;
        PairedValuesExt pairedValuesExt;
        element.setAttribute("Name", this.getDisplayName());
        element.setAttribute("Description", this.getDescription());
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.JUNCTION_INFO).a()) {
            element.setAttribute("StreamStation", Double.toString(this.getStreamStation()));
            pairedValuesExt = "";
            if (this.getStream() != null) {
                pairedValuesExt = this.getStream().getName();
            }
            element.setAttribute("Stream", (String)pairedValuesExt);
            element2 = new org.jdom.Element("Tributaries");
            element.addContent((Content)element2);
            XMLUtilities.createArrayElements((org.jdom.Element)element2, (String[])this.getTribNameArray());
            element.setAttribute("LabelPossition", Integer.toString(this.getLabelPosition()));
        }
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.JUNCTION_LOCAL_FLOW).a() && this.getLocalFlowVector() != null) {
            cloneable = this.getLocalFlowVector();
            for (int i = 0; i < ((Vector)cloneable).size(); ++i) {
                pairedValuesExt = (String[])((Vector)cloneable).get(i);
                element2 = new org.jdom.Element("LocalFlow");
                element.addContent((Content)element2);
                element2.setAttribute("Name", pairedValuesExt[0]);
                element2.setAttribute("Factor", pairedValuesExt[1]);
            }
        }
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.JUNC_RATING_CURVE).a() && this.getLocalFlowVector() != null) {
            pairedValuesExt = (Junction)this.getFunction();
            element2 = new org.jdom.Element("RatingCurve");
            element.addContent((Content)element2);
            cloneable = pairedValuesExt.getRatingObject();
            element2.setAttribute("SetForMissingValues", Boolean.toString(((RssRatingObject)cloneable).getOutOfRangeValuesToMissing()));
            if (((RssRatingObject)cloneable).usesIndependentVariable()) {
                IndependentVariable independentVariable = ((RssRatingObject)cloneable).getIndependentVariable();
                var4_11 = new org.jdom.Element("IndependentVaraible");
                element2.addContent((Content)var4_11);
                independentVariable.outputReport(alternativeInputReport, var4_11);
                if (independentVariable.getType() == 5) {
                    pairedValuesExt = ((RssRatingObject)cloneable).getIndependentVariableRatingCurveExt();
                    var4_11 = new org.jdom.Element("X_Parameter");
                    element2.addContent((Content)var4_11);
                    XMLUtilities.createArrayElements((org.jdom.Element)var4_11, (double[])pairedValuesExt.getXArray());
                    for (int i = 0; i < pairedValuesExt.getNumberCurves(); ++i) {
                        cloneable = pairedValuesExt.getCurve(i);
                        var4_11 = new org.jdom.Element("Stage" + Integer.toString(i));
                        element2.addContent((Content)var4_11);
                        XMLUtilities.createArrayElements((org.jdom.Element)var4_11, (double[])cloneable.getYArray());
                    }
                } else {
                    pairedValuesExt = ((RssRatingObject)cloneable).getIndependentVariableRatingCurve();
                    var4_11 = new org.jdom.Element("X_Parameter");
                    element2.addContent((Content)var4_11);
                    XMLUtilities.createArrayElements((org.jdom.Element)var4_11, (double[])pairedValuesExt.getXArray());
                    var4_11 = new org.jdom.Element("Stage");
                    element2.addContent((Content)var4_11);
                    XMLUtilities.createArrayElements((org.jdom.Element)var4_11, (double[])pairedValuesExt.getYArray());
                }
            } else {
                element2.setAttribute("Rating_Type", "SimpleRating");
                PairedValues pairedValues = ((RssRatingObject)cloneable).getIndependentVariableRatingCurve();
                element2.setAttribute("StageDatum", Double.toString(pairedValues.getDatum()));
                var4_11 = new org.jdom.Element("X_Parameter");
                element2.addContent((Content)var4_11);
                XMLUtilities.createArrayElements((org.jdom.Element)var4_11, (double[])pairedValuesExt._ratingCurve.getXArray());
                var4_11 = new org.jdom.Element("Stage");
                element2.addContent((Content)var4_11);
                XMLUtilities.createArrayElements((org.jdom.Element)var4_11, (double[])pairedValuesExt._ratingCurve.getYArray());
            }
        }
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.JUNC_OBSERVED).a() && this._obsDataVector != null && !this._obsDataVector.isEmpty()) {
            element2 = new org.jdom.Element("ObservedData");
            element.addContent((Content)element2);
            for (int i = 0; i < this._obsDataVector.size(); ++i) {
                pairedValuesExt = (String)this._obsDataVector.get(i);
                element2.setAttribute("NameParamID", (String)pairedValuesExt);
            }
        }
    }

    public void setStreamJunctionId(int n) {
        this._streamJunctionId = n;
    }

    public int getStreamJunctionId() {
        return this._streamJunctionId;
    }
}

