/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.Parameter;
import hec.heclib.dss.DSSPathname;
import hec.io.DSSIdentifier;
import hec.model.PairedValues;
import hec.model.RunTimeStep;
import hec.rss.model.Element;
import hec.rss.model.HotstartState;
import hec.rss.model.LagAndKCarryOver;
import hec.rss.model.LagAndKHotstartState;
import hec.rss.model.RSimDssPathPartGenerator;
import hec.rss.model.Routing;
import hec.rss.model.RoutingHotstartState;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.jdom.Content;

public class LagAndKRouting
extends Routing {
    private PairedValues _inflowLagTable = new PairedValues();
    private PairedValues _outflowKTable = new PairedValues();
    private boolean _isConstantLag = true;
    private boolean _isConstantK = true;
    private double _constantLag = 0.0;
    private double _constantK = 0.0;
    private transient boolean a = false;
    private transient LagAndKCarryOver b = null;
    private transient LagAndKCarryOver[] c;
    private transient PairedValues d;
    private transient PairedValues e;
    private transient boolean f = false;
    private transient PairedValues g = null;
    private transient boolean h = false;

    public LagAndKRouting() {
    }

    public LagAndKRouting(Element element) {
        super(element);
    }

    @Override
    public void setupForSerialization() {
        RssReturnStatusConstants rssReturnStatusConstants;
        super.setupForSerialization();
        if (this._inflowLagTable == null && this._outflowKTable == null) {
            return;
        }
        DSSPathname dSSPathname = new DSSPathname();
        Object object = new RSimDssPathPartGenerator();
        String string = this.getElement().getTopParent().getName();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        string = object.generatePathnamePart(arrayList, "");
        dSSPathname.setAPart(string);
        arrayList.clear();
        String string2 = this.getElement().getName();
        if (string2 != null && string2.startsWith("~") && (rssReturnStatusConstants = this.getElement().getParent()) != null) {
            string2 = rssReturnStatusConstants.getName();
        }
        if (!string2.equalsIgnoreCase(string)) {
            arrayList.add(string2);
        }
        arrayList.add("LAG&K");
        rssReturnStatusConstants = ((RssTSLocationObject)this).getSystem();
        object = rssReturnStatusConstants != null ? ((RssSystem)rssReturnStatusConstants).generateUniquePathPart(arrayList, "-") : object.generatePathnamePart(arrayList, "-");
        dSSPathname.setBPart((String)object);
        object = this.getElement().getSystem().getDssPairedDataFilePath();
        if (this._inflowLagTable != null) {
            string = "INFLOW-LAG";
            dSSPathname.setCPart(string);
            string = dSSPathname.getPathname();
            this._inflowLagTable.setDssIdentifer(new DSSIdentifier((String)object, string));
            this._inflowLagTable.setParamXId(Parameter.PARAMID_FLOW);
            this._inflowLagTable.setParamYId(-1);
            this._inflowLagTable.setUnitSystem(this.getUnitSystem());
        }
        if (this._outflowKTable != null) {
            string = "OUTFLOW-K";
            dSSPathname.setCPart(string);
            string = dSSPathname.getPathname();
            this._outflowKTable.setDssIdentifer(new DSSIdentifier((String)object, string));
            this._outflowKTable.setParamXId(Parameter.PARAMID_FLOW);
            this._outflowKTable.setParamYId(-1);
            this._outflowKTable.setUnitSystem(this.getUnitSystem());
        }
    }

    @Override
    public synchronized Object clone() {
        LagAndKRouting lagAndKRouting = (LagAndKRouting)super.clone();
        ((LagAndKRouting)super.clone())._inflowLagTable = (PairedValues)this._inflowLagTable.clone();
        lagAndKRouting._outflowKTable = (PairedValues)this._outflowKTable.clone();
        return lagAndKRouting;
    }

    @Override
    public void saveFunctionState(int n) {
        if (this.c == null || n >= this.c.length) {
            return;
        }
        LagAndKCarryOver lagAndKCarryOver = this.c[n];
        if (lagAndKCarryOver == null || this.b == null) {
            return;
        }
        lagAndKCarryOver.set(this.b);
    }

    @Override
    public void restoreFunctionState(int n) {
        if (this.c == null || n >= this.c.length) {
            return;
        }
        LagAndKCarryOver lagAndKCarryOver = this.c[n];
        if (lagAndKCarryOver == null) {
            return;
        }
        if (this.b == null) {
            this.b = new LagAndKCarryOver();
        }
        this.b.set(lagAndKCarryOver);
        if (n == 6) {
            this.setStateInitialized(false);
            return;
        }
        this.setStateInitialized(true);
    }

    @Override
    public void saveHotstartState(HotstartState hotstartState, int n) {
        LagAndKHotstartState lagAndKHotstartState = (LagAndKHotstartState)hotstartState.getChildState(this.getName(), this.getClass().getName());
        if (lagAndKHotstartState == null) {
            lagAndKHotstartState = new LagAndKHotstartState(this);
            hotstartState.addChildState(lagAndKHotstartState);
        }
        ((HotstartState)lagAndKHotstartState).saveState(n);
    }

    @Override
    public boolean restoreHotstartState(HotstartState hotstartState) {
        if ((hotstartState = (LagAndKHotstartState)hotstartState.getChildState(this.getName(), this.getClass().getName())) != null) {
            ((RoutingHotstartState)hotstartState).routing(this);
            return hotstartState.restoreState();
        }
        LagAndKRouting lagAndKRouting = this;
        lagAndKRouting.printErrorMessage("Failed to find LagAndKRouting hotstart state for " + String.valueOf(lagAndKRouting.getElement()));
        return false;
    }

    @Override
    public boolean initialize() {
        boolean bl = super.initialize();
        String string = System.getProperty("SKIP_INITIALIZE");
        if (string == null || string.equals("true")) {
            this.setStateInitialized(false);
            this.c = new LagAndKCarryOver[7];
            for (int i = 0; i < 7; ++i) {
                this.c[i] = new LagAndKCarryOver();
            }
        }
        return bl;
    }

    private void setStateInitialized(boolean bl) {
        this.a = bl;
    }

    private boolean isStateInitialized() {
        return this.a;
    }

    @Override
    public int computeForecastStep(RunTimeStep runTimeStep) {
        double d = this._tsUpstrm[runTimeStep.step];
        double d2 = runTimeStep.step > 0 ? this._tsUpstrm[runTimeStep.step - 1] : this._tsUpstrm[0];
        this._shouldCheckHotstart = false;
        this._tsDnstrm[runTimeStep.step] = this.computeRoutingStep((double)runTimeStep.getTimeStepMinutes() / 60.0, d2, d);
        if (runTimeStep != null && ((RssTSLocationObject)this).getSystem().b && ((RssTSLocationObject)this).getSystem().shouldSaveHotstartAtTimeStep(runTimeStep.step, runTimeStep.flag)) {
            ArrayList<Element> arrayList = new ArrayList<Element>(1);
            Element element = this.element.getTopParent();
            arrayList.add(element);
            ((RssTSLocationObject)this).getSystem().checkSaveHotstart(runTimeStep.step, runTimeStep.flag, arrayList);
        }
        return this.checkForecastStepCalc(runTimeStep, true);
    }

    @Override
    public int computeRouting(RunTimeStep runTimeStep) {
        double d;
        int n = runTimeStep.step;
        int n2 = runTimeStep.nstep;
        if (!this.isStateInitialized()) {
            this.b = new LagAndKCarryOver();
            d = this._tsUpstrm[n];
            this.b.setInflowState(d);
            this.b.setOutflowState(d);
            this.b.setStorageState(this.findStorage(d));
            this.setStateInitialized(true);
        }
        d = (double)runTimeStep.getTimeStepMinutes() / 60.0;
        for (int i = 0; i < n2; ++i) {
            double d2 = this._tsUpstrm[i + n];
            double d3 = i + n - 1 > 0 ? this._tsUpstrm[i + n - 1] : this._tsUpstrm[0];
            this._tsDnstrm[i + n] = this.computeRoutingStep(d, d3, d2);
            if (((RssTSLocationObject)this).getSystem().b) {
                int n3 = i + n;
                if (((RssTSLocationObject)this).getSystem().shouldSaveHotstartAtTimeStep(n3, runTimeStep.flag)) {
                    ArrayList<Element> arrayList = new ArrayList<Element>(1);
                    Element element = this.element.getTopParent();
                    arrayList.add(element);
                    ((RssTSLocationObject)this).getSystem().checkSaveHotstart(n3, runTimeStep.flag, arrayList);
                }
            }
            if (i != runTimeStep.rtw.getForecastSteps() - runTimeStep.rtw.getNumRoutingSteps() - 1) continue;
            this.element.saveElementState(4);
        }
        return this.checkForecastCalc(runTimeStep, true);
    }

    protected double computeRoutingStep(double d, double d2, double d3) {
        if (!this.isStateInitialized()) {
            this.b = new LagAndKCarryOver();
            this.b.setInflowState(d2);
            this.b.setOutflowState(d2);
            this.setStateInitialized(true);
        }
        double[] dArray = new double[2];
        double[] dArray2 = dArray;
        dArray[0] = d2;
        dArray2[1] = d3;
        double[] dArray3 = this.lagInflow(d, this.b, dArray2);
        dArray2[0] = dArray3[0];
        dArray2[1] = dArray3[1];
        dArray3 = this.attenuateFlow(d, this.b, dArray2);
        double d4 = dArray3[1];
        this.b.shiftTimes(-d);
        return d4;
    }

    protected double[] lagInflow(double d, LagAndKCarryOver lagAndKCarryOver, double[] dArray) {
        int n;
        int n2;
        double[] dArray2 = lagAndKCarryOver.getInflowArray();
        double[] dArray3 = lagAndKCarryOver.getInflowTimes();
        int n3 = dArray2.length + dArray.length;
        double[] dArray4 = new double[n3];
        double[] dArray5 = new double[n3];
        int n4 = 0;
        for (int i = 0; i < dArray2.length; ++i) {
            dArray4[n4] = dArray2[i];
            dArray5[n4] = dArray3[i];
            ++n4;
        }
        double d2 = 0.0;
        for (n2 = 0; n2 < dArray.length; ++n2) {
            double d3 = this.isConstantLag() ? this.getConstantLag() : this._inflowLagTable.getYValue(dArray[n2]);
            dArray5[n4] = d2 + d3;
            dArray4[n4] = dArray[n2];
            d2 += d;
            ++n4;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n5 = n2;
            for (int i = n2 + 1; i < n3; ++i) {
                if (!(dArray5[i] < dArray5[n5])) continue;
                n5 = i;
            }
            double d4 = dArray5[n5];
            dArray5[n5] = dArray5[n2];
            dArray5[n2] = d4;
            d4 = dArray4[n5];
            dArray4[n5] = dArray4[n2];
            dArray4[n2] = d4;
        }
        for (int i = 1; i < n3; ++i) {
            if (!(Math.abs(dArray5[i] - dArray5[i - 1]) < 1.0E-10)) continue;
            n2 = i - 1;
            int n6 = i;
            while (++n6 < n3 && Math.abs(dArray5[n6] - dArray5[n2]) < 1.0E-10) {
            }
            --n6;
            double d5 = 0.0;
            int n7 = 0;
            for (n4 = n2; n4 <= n6; ++n4) {
                d5 = Math.max(d5, dArray4[n4]);
                ++n7;
            }
            dArray4[n2] = d5;
            int n8 = n2;
            for (n4 = n6 + 1; n4 < n3; ++n4) {
                dArray4[++n8] = dArray4[n4];
                dArray5[n8] = dArray5[n4];
            }
            n3 -= n7 - 1;
        }
        double[] dArray6 = new double[n3];
        double[] dArray7 = new double[n3];
        System.arraycopy(dArray4, 0, dArray6, 0, n3);
        System.arraycopy(dArray5, 0, dArray7, 0, n3);
        dArray4 = dArray6;
        dArray5 = dArray7;
        double d6 = (double)(dArray.length - 1) * d;
        for (n4 = 1; n4 < n3 && dArray5[n4] < d6; ++n4) {
        }
        --n4;
        int n9 = n3;
        if (dArray5[n9 - 1] == d6) {
            --n9;
        }
        n2 = n9 - n4;
        dArray3 = new double[n2];
        double[] dArray8 = new double[n2];
        int n10 = 0;
        for (n = n4; n < n9; ++n) {
            dArray8[n10] = dArray4[n];
            dArray3[n10] = dArray5[n];
            ++n10;
        }
        lagAndKCarryOver.setInflowArrays(dArray8, dArray3);
        for (n = 1; n < n3; ++n) {
            double d7;
            double d8;
            if (!(dArray5[n] - dArray5[n - 1] > d * 2.0)) continue;
            if (dArray4[n] < dArray4[n - 1]) {
                d8 = dArray5[n - 1] + d;
                d7 = dArray4[n];
            } else {
                d8 = dArray5[n] - d;
                d7 = dArray4[n - 1];
            }
            dArray6 = new double[n3 + 1];
            dArray7 = new double[n3 + 1];
            System.arraycopy(dArray5, 0, dArray7, 0, n);
            System.arraycopy(dArray4, 0, dArray6, 0, n);
            dArray7[n] = d8;
            dArray6[n] = d7;
            System.arraycopy(dArray5, n, dArray7, n + 1, n3 - n);
            System.arraycopy(dArray4, n, dArray6, n + 1, n3 - n);
            dArray5 = dArray7;
            dArray4 = dArray6;
            n3 = dArray7.length;
        }
        double d9 = dArray5[n3 - 1];
        int n11 = (int)(d9 / d) + 1;
        double[] dArray9 = new double[n11];
        d2 = 0.0;
        for (int i = 0; i < n11; ++i) {
            dArray9[i] = this.interpolateLaggedFlow(d2, dArray5, dArray4, d);
            d2 += d;
        }
        return dArray9;
    }

    private double interpolateLaggedFlow(double d, double[] dArray, double[] dArray2, double d2) {
        int n;
        if (d < dArray[0]) {
            return dArray2[0];
        }
        if (d > dArray[dArray.length - 1]) {
            return dArray2[dArray2.length - 1];
        }
        double d3 = d - d2;
        double d4 = 0.0;
        int n2 = 0;
        for (n = 0; n < dArray.length && dArray[n] < d; ++n) {
            if (dArray[n] > d3) {
                if (!(dArray2[n] > d4)) continue;
                d4 = dArray2[n];
            }
            n2 = n;
        }
        double d5 = d + d2;
        int n3 = 0;
        d4 = 0.0;
        while (n < dArray.length && dArray[n] < d5) {
            if (dArray2[n] > d4) {
                d4 = dArray2[n];
                n3 = n;
            }
            ++n;
        }
        if (n3 == 0) {
            n3 = Math.min(n2, dArray.length - 1);
        }
        double d6 = Math.abs(dArray2[n3] - dArray2[n2]) < 1.0E-10 ? dArray2[n2] : (d - dArray[n2]) / (dArray[n3] - dArray[n2]) * (dArray2[n3] - dArray2[n2]) + dArray2[n2];
        return d6;
    }

    protected double[] attenuateFlow(double d, LagAndKCarryOver lagAndKCarryOver, double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        if (!this.useKTable()) {
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            return dArray2;
        }
        if (!this.haveAttenuationTables()) {
            this.buildAttenuationTables(d);
        }
        double d2 = d * 3600.0;
        double d3 = d / 2.0;
        double d4 = lagAndKCarryOver.getStorageState();
        double d5 = lagAndKCarryOver.getInflowState();
        double d6 = lagAndKCarryOver.getOutflowState();
        double d7 = d5;
        double d8 = d6;
        dArray2[0] = d6;
        double d9 = d4;
        for (int i = 1; i < n; ++i) {
            d7 = dArray[i];
            double d10 = d5 + d7 + d4 * 2.0 / d2 - d6;
            d8 = this.d.getXValue(d10);
            double d11 = this.findK(d6);
            double d12 = this.findK(d8);
            if (d11 < d3 && d12 < d3) {
                d8 = Math.min(d7, d10);
            } else if (d11 < d3 || d12 < d3) {
                double d13 = d2 / 4.0;
                double d14 = (d7 - d5) / 4.0;
                double d15 = d3 / 4.0;
                for (int j = 0; j < 4; ++j) {
                    d7 = d5 + d14;
                    d10 = d5 + d7 + d4 * 2.0 / d13 - d6;
                    d8 = this.e.getXValue(d10);
                    d11 = this.findK(d6);
                    d12 = this.findK(d8);
                    if (d11 < d15 || d12 < d15) {
                        d8 = Math.min(d7, d10);
                    }
                    d9 = (d10 - d8) * d13 / 2.0;
                    d5 = d7;
                    d6 = d8;
                    d4 = d9;
                }
                d7 = dArray[i];
                this.findK(d8);
            }
            d9 = (d10 - d8) * d2 / 2.0;
            dArray2[i] = d8;
            d5 = d7;
            d6 = d8;
            d4 = d9;
        }
        lagAndKCarryOver.setInflowState(d7);
        lagAndKCarryOver.setOutflowState(d8);
        lagAndKCarryOver.setStorageState(d9);
        return dArray2;
    }

    private double findK(double d) {
        double d2 = this.isConstantK() ? this.getConstantK() : this._outflowKTable.getYValue(d);
        return d2;
    }

    private boolean useKTable() {
        if (this.isConstantK()) {
            return this.getConstantK() > 0.0;
        }
        return this._outflowKTable.size() > 0;
    }

    public PairedValues getInflowLagTable() {
        return this._inflowLagTable;
    }

    public PairedValues getOutflowKTable() {
        return this._outflowKTable;
    }

    public void setInflowLagTable(PairedValues pairedValues) {
        this._inflowLagTable = pairedValues;
    }

    public void setOutflowKTable(PairedValues pairedValues) {
        if (this._outflowKTable == null || pairedValues == null) {
            this._outflowKTable = pairedValues;
            this.setHaveStorageTable(false);
            return;
        }
        boolean bl = false;
        if (this._outflowKTable.getPairCount() != pairedValues.getPairCount()) {
            bl = true;
        } else {
            double[] dArray = this._outflowKTable.getXArray();
            double[] dArray2 = this._outflowKTable.getYArray();
            double[] dArray3 = pairedValues.getXArray();
            double[] dArray4 = pairedValues.getYArray();
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                if (dArray[i] != dArray3[i]) {
                    bl = true;
                    break;
                }
                if (dArray2[i] == dArray4[i]) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            this._outflowKTable = pairedValues;
            this.setHaveStorageTable(false);
        }
    }

    public void setIsConstantLag(boolean bl) {
        this._isConstantLag = bl;
    }

    public boolean isConstantLag() {
        return this._isConstantLag;
    }

    public void setIsConstantK(boolean bl) {
        if (this._isConstantK != bl) {
            this._isConstantK = bl;
            this.setHaveStorageTable(false);
        }
    }

    public boolean isConstantK() {
        return this._isConstantK;
    }

    public void setConstantLag(double d) {
        this._constantLag = d;
    }

    public double getConstantLag() {
        return this._constantLag;
    }

    public void setConstantK(double d) {
        if (this._constantK != d) {
            this._constantK = d;
            this.setHaveStorageTable(false);
        }
    }

    public double getConstantK() {
        return this._constantK;
    }

    public boolean setCarryOverState(int n, LagAndKCarryOver lagAndKCarryOver) {
        if (this.b == null) {
            this.b = new LagAndKCarryOver();
        }
        this.b.set(lagAndKCarryOver);
        this.setStateInitialized(true);
        if (this.c == null || this.c.length < n) {
            return true;
        }
        this.c[n].set(lagAndKCarryOver);
        return true;
    }

    public LagAndKCarryOver getCarryOverState() {
        return this.b;
    }

    public double findStorage(double d) {
        if (!this.haveStorageTable()) {
            this.buildOutflowStorageTable();
        }
        double d2 = this.g.getYValue(d);
        return d2;
    }

    private void buildOutflowStorageTable() {
        this.g = new PairedValues();
        if (this.isConstantK()) {
            this.g.addPair(0.0, 0.0);
            double d = this.getConstantK() * 1000000.0 * 3600.0;
            this.g.addPair(1000000.0, d);
        } else {
            double d;
            double d2;
            double d3;
            double d4 = 0.0;
            this.g.addPair(0.0, 0.0);
            int n = this._outflowKTable.getPairCount();
            double[] dArray = this._outflowKTable.getXArray();
            double[] dArray2 = this._outflowKTable.getYArray();
            double d5 = dArray[0];
            if (dArray[0] > 1.0E-10) {
                d3 = dArray[0];
                double d6 = dArray2[0];
                d2 = dArray[0];
                d4 = 0.0 + d6 * d3 * 3600.0;
                this.g.addPair(d2, d4);
            }
            for (int i = 1; i < n; ++i) {
                d5 = dArray[i - 1];
                d3 = dArray[i] - dArray[i - 1];
                double d7 = dArray2[i] - dArray2[i - 1];
                int n2 = 1;
                if (Math.abs(d7) > 1.0E-10) {
                    n2 = (int)((d3 + d7 * 12.0) / 100.0 + 1.5);
                    if (n2 > 20) {
                        n2 = 20;
                    }
                    if (n2 <= 0) {
                        n2 = 1;
                    }
                }
                for (int j = 0; j < n2; ++j) {
                    double d8 = dArray[i - 1] + d3 * (double)(j + 1) / (double)n2;
                    d = (d5 + d8) / 2.0;
                    d4 = this._outflowKTable.getYValue(d) * 3600.0 * (d8 - d5) + d4;
                    d2 = d8;
                    this.g.addPair(d2, d4);
                    d5 = d8;
                }
            }
            d = (d5 + 1000000.0) / 2.0;
            d4 = this._outflowKTable.getYValue(d) * 3600.0 * (1000000.0 - d5) + d4;
            this.g.addPair(1000000.0, d4);
        }
        this.setHaveStorageTable(true);
    }

    private void setHaveStorageTable(boolean bl) {
        this.h = bl;
    }

    private boolean haveStorageTable() {
        return this.h;
    }

    private boolean haveAttenuationTables() {
        return this.f && this.haveStorageTable();
    }

    private void buildAttenuationTables(double d) {
        this.d = new PairedValues();
        this.buildAttenuationTable(d, this.d);
        this.e = new PairedValues();
        this.buildAttenuationTable(d / 4.0, this.e);
        this.f = true;
    }

    private void buildAttenuationTable(double d, PairedValues pairedValues) {
        double d2 = d * 3600.0;
        if (!this.haveStorageTable()) {
            this.buildOutflowStorageTable();
        }
        double[] dArray = this.g.getXArray();
        double[] dArray2 = this.g.getYArray();
        int n = this.g.getPairCount();
        for (int i = 0; i < n; ++i) {
            double d3 = dArray[i];
            double d4 = dArray2[i];
            double d5 = d4 * 2.0 / d2 + d3;
            pairedValues.addPair(d3, d5);
        }
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        if (this._isConstantLag) {
            element.setAttribute("ConstLag", Double.toString(this._constantLag));
        } else {
            alternativeInputReport = new org.jdom.Element("Inflow");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._inflowLagTable.getXArray());
            alternativeInputReport = new org.jdom.Element("Lag");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._inflowLagTable.getYArray());
        }
        if (this._isConstantK) {
            element.setAttribute("ConstK", Double.toString(this._constantK));
            return;
        }
        alternativeInputReport = new org.jdom.Element("Outflow");
        element.addContent((Content)alternativeInputReport);
        XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._outflowKTable.getXArray());
        alternativeInputReport = new org.jdom.Element("K");
        element.addContent((Content)alternativeInputReport);
        XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._outflowKTable.getYArray());
    }
}

