/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.model.RunTimeStep;
import hec.model.SeasonalValue;
import hec.rss.model.AdjustableParameter;
import hec.rss.model.Controller;
import hec.rss.model.OpController;
import hec.rss.model.Rule;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.NoSuchElementException;
import rma.util.RMAIO;
import rma.util.rmaTokenizer;

public class MinMax
extends Rule {
    double _minReqdFlow = 0.0;
    double _minDesiredFlow = 0.0;
    double _maxFlow = Double.MAX_VALUE;
    SeasonalValue _minValues = new SeasonalValue();
    SeasonalValue _maxValues = new SeasonalValue();

    public MinMax() {
    }

    @Deprecated
    public MinMax(Controller controller) {
        super(controller);
    }

    public MinMax(OpController opController) {
        super(opController);
    }

    public String getMinValues() {
        if (this._minValues == null) {
            return null;
        }
        return this._minValues.toString();
    }

    public String getMaxValues() {
        if (this._maxValues == null) {
            return null;
        }
        return this._maxValues.toString();
    }

    @Override
    public double getValue(AdjustableParameter adjustableParameter, RunTimeStep runTimeStep, double d) {
        double d2 = this._minReqdFlow;
        double d3 = this._maxFlow;
        if (this._minValues != null) {
            d2 = this._minValues.interpolateValue(runTimeStep);
        }
        if (this._maxValues != null) {
            d3 = this._maxValues.interpolateValue(runTimeStep);
        }
        if (d < d2) {
            d = d2;
        } else if (d > d3) {
            d = d3;
        }
        if (this.useDemandScale()) {
            return d * this.getDemandScale();
        }
        return d;
    }

    @Override
    public boolean writeData(BufferedWriter bufferedWriter) {
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"Controller Rule=MinMax");
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller MinMax Name=" + this.getName()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller MinMax TS=" + this.tsLocationType + ", " + this.tsLocationName + ", " + this.tsLocationParam));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller MinMax MinReqdFlow=" + this._minReqdFlow));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller MinMax MinDesiredFlow=" + this._minDesiredFlow));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller MinMax MaxFlow=" + this._maxFlow));
        if (this._minValues != null) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller MinMax MinValues=" + this._minValues.toString()));
        }
        if (this._maxValues != null) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller MinMax MaxValues=" + this._maxValues.toString()));
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"Controller MinMax End");
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"");
        return true;
    }

    @Override
    public boolean readData(BufferedReader bufferedReader) {
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.length() == 0) {
                    string = bufferedReader.readLine();
                    continue;
                }
                if (string.indexOf("Controller MinMax") < 0) break;
                String string2 = RMAIO.getType((String)string, (String)"=");
                string = RMAIO.getParam((String)string, (String)"=");
                if (string2.compareTo("Controller MinMax Name") == 0) {
                    this.setName(string);
                } else if (string2.compareTo("Controller MinMax TS") == 0) {
                    string = new rmaTokenizer(string, ",");
                    try {
                        this.tsLocationType = string.nextToken();
                        this.tsLocationName = string.nextToken();
                        this.tsLocationParam = string.nextToken();
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                } else if (string2.compareTo("Controller MinMax MinReqdFlow") == 0) {
                    this._minReqdFlow = RMAIO.parseDouble((String)string);
                } else if (string2.compareTo("Controller MinMax MinDesiredFlow") == 0) {
                    this._minDesiredFlow = RMAIO.parseDouble((String)string);
                } else if (string2.compareTo("Controller MinMax MaxFlow") == 0) {
                    this._maxFlow = RMAIO.parseDouble((String)string);
                } else if (string2.compareTo("Controller MinMax MinValues") == 0) {
                    this._minValues = new SeasonalValue();
                    this._minValues.parseString(string);
                } else if (string2.compareTo("Controller MinMax MaxValues") == 0) {
                    this._maxValues = new SeasonalValue();
                    this._maxValues.parseString(string);
                } else if (string2.compareTo("Controller MinMax End") == 0) break;
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void setMinValues(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this._minValues == null) {
            this._minValues = new SeasonalValue();
        }
        this._minValues.parseString(string);
    }

    public void setMaxValues(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this._maxValues == null) {
            this._maxValues = new SeasonalValue();
        }
        this._maxValues.parseString(string);
    }

    public void removeAllMinValues() {
        this._minValues = new SeasonalValue();
    }

    public void removeAllMaxValues() {
        this._maxValues = new SeasonalValue();
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

