/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.model.RunTimeStep;
import hec.rss.model.AdjustableParameter;
import hec.rss.model.Controller;
import hec.rss.model.OpController;
import hec.rss.model.Rule;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.StringTokenizer;
import rma.util.RMAIO;

public class MonthlyRelease
extends Rule {
    double[] _monthlyRelease = new double[12];

    public MonthlyRelease() {
        this.setRuleType("Monthly Varying");
    }

    @Deprecated
    public MonthlyRelease(Controller controller) {
        super(controller);
        this.setRuleType("Monthly Varying");
    }

    public MonthlyRelease(OpController opController) {
        super(opController);
        this.setRuleType("Monthly Varying");
    }

    public boolean setValues(double[] dArray) {
        if (dArray == null || dArray.length != 12) {
            return false;
        }
        this._monthlyRelease = dArray;
        return true;
    }

    public double[] getMonthlyValues() {
        return this._monthlyRelease;
    }

    @Override
    public double getValue(AdjustableParameter adjustableParameter, RunTimeStep runTimeStep, double d) {
        int n = runTimeStep.month() - 1;
        if (n < 0) {
            n = 0;
        }
        if (n > 11) {
            n = 11;
        }
        if (this.useDemandScale()) {
            return this._monthlyRelease[n] * this.getDemandScale();
        }
        return this._monthlyRelease[n];
    }

    @Override
    public boolean writeData(BufferedWriter bufferedWriter) {
        String string = this.getRuleType();
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller Rule=" + string));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller " + string + " Name=" + this.getName()));
        Object object = "";
        int n = this._monthlyRelease.length;
        for (int i = 0; i < n; ++i) {
            object = (String)object + this._monthlyRelease[i] + (i < n - 1 ? "," : "");
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller " + string + " values=" + (String)object));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller " + string + " End"));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"");
        return true;
    }

    @Override
    public boolean readData(BufferedReader bufferedReader) {
        String string = this.getRuleType();
        try {
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (string2.length() == 0) {
                    string2 = bufferedReader.readLine();
                    continue;
                }
                if (string2.indexOf("Controller " + string) < 0) break;
                String string3 = RMAIO.getType((String)string2, (String)"=");
                string2 = RMAIO.getParam((String)string2, (String)"=");
                if (string3.equals("Controller " + string + " Name")) {
                    this.setName(string2);
                } else if (string3.equals("Controller " + string + " values")) {
                    this.setValues(string2);
                } else if (string3.equals("Controller " + string + " End")) break;
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private void setValues(String object) {
        if (object == null || ((String)object).length() <= 0) {
            return;
        }
        object = new StringTokenizer((String)object, ",");
        int n = 0;
        while (((StringTokenizer)object).hasMoreTokens() && n < this._monthlyRelease.length) {
            String string = ((StringTokenizer)object).nextToken();
            this._monthlyRelease[n++] = RMAIO.parseDouble((String)string);
        }
    }

    @Override
    public MonthlyRelease clone() {
        MonthlyRelease monthlyRelease = (MonthlyRelease)super.clone();
        double[] dArray = this.getMonthlyValues();
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        monthlyRelease.setValues(dArray2);
        return monthlyRelease;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

