/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.DataSetException;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.data.Units;
import hec.model.RunTimeStep;
import hec.rss.model.Element;
import hec.rss.model.Routing;
import hec.rss.model.RunTime;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.NoSuchElementException;
import rma.util.RMAIO;
import rma.util.rmaTokenizer;

public class MuskingumCunge8ptRouting
extends Routing {
    double[] _channelLength = new double[1];
    double[] _channelSlope = new double[1];
    double[] _xsDistance = new double[8];
    double[] _xsElevation = new double[8];
    double[] _xsManningsN = new double[3];
    int _numberNodes = Integer.MIN_VALUE;
    boolean _useNumberNodes = false;
    private transient double[] a;
    private transient double[] b;
    private transient double[] c = new double[2];
    private transient double[] d = new double[2];
    private transient double[] e = new double[2];
    private transient double[] f = new double[1];
    private transient double[] g = new double[1];
    private transient double[] h = new double[1];
    private transient double[] i = new double[1];
    private transient double[] j = new double[1];
    private transient double[] k = new double[1];
    private transient double[] l = new double[1];
    private transient double[] m = new double[1];
    private transient double[] n = new double[1];
    private transient boolean o = false;
    private transient boolean p = true;

    public MuskingumCunge8ptRouting() {
    }

    public MuskingumCunge8ptRouting(Element element) {
        super(element);
    }

    @Override
    public synchronized Object clone() {
        MuskingumCunge8ptRouting muskingumCunge8ptRouting = (MuskingumCunge8ptRouting)super.clone();
        if (this._channelLength != null) {
            muskingumCunge8ptRouting._channelLength = new double[this._channelLength.length];
            System.arraycopy(this._channelLength, 0, muskingumCunge8ptRouting._channelLength, 0, this._channelLength.length);
        }
        if (this._channelSlope != null) {
            muskingumCunge8ptRouting._channelSlope = new double[this._channelSlope.length];
            System.arraycopy(this._channelSlope, 0, muskingumCunge8ptRouting._channelSlope, 0, this._channelSlope.length);
        }
        if (this._xsDistance != null) {
            muskingumCunge8ptRouting._xsDistance = new double[this._xsDistance.length];
            System.arraycopy(this._xsDistance, 0, muskingumCunge8ptRouting._xsDistance, 0, this._xsDistance.length);
        }
        if (this._xsElevation != null) {
            muskingumCunge8ptRouting._xsElevation = new double[this._xsElevation.length];
            System.arraycopy(this._xsElevation, 0, muskingumCunge8ptRouting._xsElevation, 0, this._xsElevation.length);
        }
        if (this._xsManningsN != null) {
            muskingumCunge8ptRouting._xsManningsN = new double[this._xsManningsN.length];
            System.arraycopy(this._xsManningsN, 0, muskingumCunge8ptRouting._xsManningsN, 0, this._xsManningsN.length);
        }
        return muskingumCunge8ptRouting;
    }

    @Override
    public int computeRouting(RunTimeStep runTimeStep) {
        return this.checkForecastCalc(runTimeStep, true);
    }

    @Override
    public boolean getForecastEquation(RunTime runTime) {
        return this.checkForecastCalc(runTime, true);
    }

    @Override
    public boolean initialize() {
        if (!super.initialize()) {
            return false;
        }
        String string = System.getProperty("SKIP_INITIALIZE");
        if (string == null || string.equals("true")) {
            this.o = false;
            if (this._numberNodes < 2) {
                this._numberNodes = 2;
            }
            this.a = new double[this._numberNodes];
            this.b = new double[this._numberNodes];
        }
        return true;
    }

    @Override
    public boolean readData(BufferedReader bufferedReader) {
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.length() == 0) {
                    string = bufferedReader.readLine();
                    continue;
                }
                if (string.indexOf("Element MuskingumCunge8ptRouting") < 0) break;
                String string2 = RMAIO.getType((String)string, (String)"=");
                string = RMAIO.getParam((String)string, (String)"=");
                if (string2.compareTo("Element MuskingumCunge8ptRouting Name") == 0) {
                    this.setName(string);
                } else if (string2.compareTo("Element MuskingumCunge8ptRouting channelLength") == 0) {
                    this._channelLength[0] = RMAIO.parseDouble((String)string);
                    if (this._channelLength[0] == Double.NEGATIVE_INFINITY) {
                        this._channelLength[0] = 0.0;
                    }
                } else if (string2.compareTo("Element MuskingumCunge8ptRouting channelSlope") == 0) {
                    this._channelSlope[0] = RMAIO.parseDouble((String)string);
                    if (this._channelSlope[0] == Double.NEGATIVE_INFINITY) {
                        this._channelSlope[0] = 0.0;
                    }
                } else if (string2.compareTo("Element MuskingumCunge8ptRouting numberNodes") == 0) {
                    this._numberNodes = RMAIO.parseInt((String)string);
                    if (this._numberNodes == Integer.MIN_VALUE) {
                        this._numberNodes = 1;
                    }
                } else if (string2.compareTo("Element MuskingumCunge8ptRouting useNumberNodes") == 0) {
                    this._useNumberNodes = string.compareTo("false") == 0 ? false : string.compareTo("true") == 0;
                } else if (string2.compareTo("Element MuskingumCunge8ptRouting xsDistance") == 0) {
                    string = new rmaTokenizer(string, ",");
                    try {
                        for (var4_4 = 0; var4_4 < 8; ++var4_4) {
                            string2 = string.nextToken();
                            this._xsDistance[var4_4] = RMAIO.parseDouble((String)string2);
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                } else if (string2.compareTo("Element MuskingumCunge8ptRouting xsElevation") == 0) {
                    string = new rmaTokenizer(string, ",");
                    try {
                        for (var4_4 = 0; var4_4 < 8; ++var4_4) {
                            string2 = string.nextToken();
                            this._xsElevation[var4_4] = RMAIO.parseDouble((String)string2);
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                } else if (string2.compareTo("Element MuskingumCunge8ptRouting xsManningsN") == 0) {
                    string = new rmaTokenizer(string, ",");
                    try {
                        for (var4_4 = 0; var4_4 < 3; ++var4_4) {
                            string2 = string.nextToken();
                            this._xsManningsN[var4_4] = RMAIO.parseDouble((String)string2);
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                } else if (string2.compareTo("Element MuskingumCunge8ptRouting End") == 0) break;
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    public boolean writeData(BufferedWriter bufferedWriter) {
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"Element Function=MuskingumCunge8ptRouting");
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Element MuskingumCunge8ptRouting Name=" + this.getName()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Element MuskingumCunge8ptRouting channelLength=" + this._channelLength[0]));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Element MuskingumCunge8ptRouting channelSlope=" + this._channelSlope[0]));
        String string = "Element MuskingumCunge8ptRouting xsDistance=" + this._xsDistance[0];
        for (int i = 1; i < 8; ++i) {
            string = string + "," + this._xsDistance[i];
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)string);
        String string2 = "Element MuskingumCunge8ptRouting xsElevation=" + this._xsElevation[0];
        for (int i = 1; i < 8; ++i) {
            string2 = string2 + "," + this._xsElevation[i];
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)string2);
        String string3 = "Element MuskingumCunge8ptRouting xsManningsN=" + this._xsManningsN[0];
        for (int i = 1; i < 3; ++i) {
            string3 = string3 + "," + this._xsManningsN[i];
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)string3);
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Element MuskingumCunge8ptRouting numberNodes=" + this._numberNodes));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Element MuskingumCunge8ptRouting useNumberNodes=" + this._useNumberNodes));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"Element MuskingumCunge8ptRouting End");
        return true;
    }

    public void setchannelLength(ParamDouble paramDouble) {
        if (paramDouble == null) {
            return;
        }
        if (paramDouble.getUnitSystem() == this.getUnitSystem()) {
            this._channelLength[0] = paramDouble.getValue();
            return;
        }
        this._channelLength[0] = paramDouble.convertToUnitSystem(this.getUnitSystem());
    }

    public void setchannelLength(double[] dArray) {
        this._channelLength = dArray;
    }

    public void setchannelSlope(double[] dArray) {
        if (dArray[0] == Double.NEGATIVE_INFINITY) {
            this._channelSlope[0] = 0.0;
            return;
        }
        this._channelSlope[0] = dArray[0];
    }

    public void setxsDistance(double[] dArray) {
        for (int i = 0; i < 8; ++i) {
            this._xsDistance[i] = dArray[i] == Double.NEGATIVE_INFINITY ? 0.0 : dArray[i];
        }
    }

    public void setxsElevation(double[] dArray) {
        for (int i = 0; i < 8; ++i) {
            this._xsElevation[i] = dArray[i] == Double.NEGATIVE_INFINITY ? 0.0 : dArray[i];
        }
    }

    public void setxsManningsN(double[] dArray) {
        for (int i = 0; i < 3; ++i) {
            this._xsManningsN[i] = dArray[i] == Double.NEGATIVE_INFINITY ? 0.0 : dArray[i];
        }
    }

    public void setnumberNodes(int n) {
        if (n == Integer.MIN_VALUE) {
            this._numberNodes = 1;
            return;
        }
        this._numberNodes = n;
    }

    public void setuseNumberNodes(boolean bl) {
        this._useNumberNodes = bl;
    }

    public void getchannelLength(ParamDouble paramDouble) {
        paramDouble.setValue(this._channelLength[0]);
        paramDouble.setParameterId(Parameter.PARAMID_LENGTH);
        paramDouble.setUnitSystem(this.getUnitSystem());
    }

    public double[] getchannelLength() {
        return this._channelLength;
    }

    public double[] getchannelSlope() {
        return this._channelSlope;
    }

    public double[] getxsDistance() {
        double[] dArray = new double[this._xsDistance.length];
        for (int i = 0; i < 8; ++i) {
            dArray[i] = this._xsDistance[i] == Double.NEGATIVE_INFINITY ? this._xsDistance[i] : this._xsDistance[i];
        }
        return dArray;
    }

    public double[] getxsElevation() {
        double[] dArray = new double[this._xsElevation.length];
        for (int i = 0; i < 8; ++i) {
            dArray[i] = this._xsElevation[i] == Double.NEGATIVE_INFINITY ? this._xsElevation[i] : this._xsElevation[i];
        }
        return dArray;
    }

    public double[] getxsManningsN() {
        return this._xsManningsN;
    }

    public int getnumberNodes() {
        return this._numberNodes;
    }

    public boolean getuseNumberNodes() {
        return this._useNumberNodes;
    }

    public void setIsSI(boolean bl) {
        this.p = bl;
    }

    public void convertToWatershedUnits() {
        if (this.getUnitSystem() == 2) {
            return;
        }
        try {
            int n;
            String string = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_LENGTH, (int)2);
            String string2 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_LENGTH, (int)1);
            Units.convertUnits((double[])this._channelLength, (String)string, (String)string2);
            for (n = 0; n < this._xsDistance.length; ++n) {
                this._xsDistance[n] = Units.convertUnits((double)this._xsDistance[n], (String)string, (String)string2);
            }
            for (n = 0; n < this._xsElevation.length; ++n) {
                this._xsElevation[n] = Units.convertUnits((double)this._xsElevation[n], (String)string, (String)string2);
            }
            return;
        }
        catch (DataSetException dataSetException) {
            this.element.getSystem().printErrorMessage("ERROR <MuskingumCunge8ptRouting.convertToWatershedUnits()> : A DataSet Exception occured when converting data. Data is now in wrong Unit System");
            this.element.getSystem().printErrorMessage(dataSetException.getMessage());
            dataSetException.printStackTrace();
            return;
        }
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public boolean initializeStandalone() {
        if (!this.o) {
            if (this._numberNodes < 2) {
                this._numberNodes = 2;
            }
            this.a = new double[this._numberNodes];
            this.b = new double[this._numberNodes];
            this.o = true;
        }
        return true;
    }

    static {
        Math.pow(0.3048, 3.0);
    }
}

