/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.DataSetException;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.data.Units;
import hec.model.RunTimeStep;
import hec.rss.model.Element;
import hec.rss.model.Routing;
import hec.rss.model.RunTime;
import java.lang.reflect.Field;

public class MuskingumCungePrismRouting
extends Routing {
    double[] _channelLength = new double[1];
    double[] _channelSlope = new double[1];
    double[] _manningsN = new double[1];
    char[] _channelType = new char[10];
    int lenChanType = 6;
    double[] _bottomWidth = new double[1];
    double[] _sideSlope = new double[1];
    int _numberNodes = Integer.MIN_VALUE;
    boolean _useNumberNodes = false;
    private transient double[] a;
    private transient double[] b;
    private transient double[] c = new double[2];
    private transient double[] d = new double[2];
    private transient double[] e = new double[2];
    private transient double[] f = new double[1];
    private transient double[] g = new double[1];
    private transient double[] h = new double[1];
    private transient double[] i = new double[1];
    private transient double[] j = new double[1];
    private transient double[] k = new double[1];
    private transient double[] l = new double[1];
    private transient double[] m = new double[1];
    private transient double[] n = new double[1];
    private transient boolean o = false;
    private transient boolean p = true;

    public MuskingumCungePrismRouting() {
    }

    public MuskingumCungePrismRouting(Element element) {
        super(element);
    }

    @Override
    public synchronized Object clone() {
        MuskingumCungePrismRouting muskingumCungePrismRouting = (MuskingumCungePrismRouting)super.clone();
        if (this._channelLength != null) {
            muskingumCungePrismRouting._channelLength = new double[this._channelLength.length];
            System.arraycopy(this._channelLength, 0, muskingumCungePrismRouting._channelLength, 0, this._channelLength.length);
        }
        if (this._channelSlope != null) {
            muskingumCungePrismRouting._channelSlope = new double[this._channelSlope.length];
            System.arraycopy(this._channelSlope, 0, muskingumCungePrismRouting._channelSlope, 0, this._channelSlope.length);
        }
        if (this._manningsN != null) {
            muskingumCungePrismRouting._manningsN = new double[this._manningsN.length];
            System.arraycopy(this._manningsN, 0, muskingumCungePrismRouting._manningsN, 0, this._manningsN.length);
        }
        if (this._channelType != null) {
            muskingumCungePrismRouting._channelType = new char[this._channelType.length];
            System.arraycopy(this._channelType, 0, muskingumCungePrismRouting._channelType, 0, this._channelType.length);
        }
        if (this._bottomWidth != null) {
            muskingumCungePrismRouting._bottomWidth = new double[this._bottomWidth.length];
            System.arraycopy(this._bottomWidth, 0, muskingumCungePrismRouting._bottomWidth, 0, this._bottomWidth.length);
        }
        if (this._sideSlope != null) {
            muskingumCungePrismRouting._sideSlope = new double[this._sideSlope.length];
            System.arraycopy(this._sideSlope, 0, muskingumCungePrismRouting._sideSlope, 0, this._sideSlope.length);
        }
        return muskingumCungePrismRouting;
    }

    @Override
    public boolean getForecastEquation(RunTime runTime) {
        return this.checkForecastCalc(runTime, true);
    }

    @Override
    public int computeRouting(RunTimeStep runTimeStep) {
        return this.checkForecastCalc(runTimeStep, true);
    }

    @Override
    public boolean initialize() {
        if (!super.initialize()) {
            return false;
        }
        String string = System.getProperty("SKIP_INITIALIZE");
        if (string == null || string.equals("true")) {
            this.o = false;
            if (this._numberNodes < 2) {
                this._numberNodes = 2;
            }
            this.a = new double[this._numberNodes];
            this.b = new double[this._numberNodes];
        }
        return true;
    }

    public void setchannelLength(double[] dArray) {
        if (dArray[0] == Double.NEGATIVE_INFINITY) {
            this._channelLength[0] = 0.0;
            return;
        }
        this._channelLength[0] = dArray[0];
    }

    public void setchannelSlope(double[] dArray) {
        if (dArray[0] == Double.NEGATIVE_INFINITY) {
            this._channelSlope[0] = 0.0;
            return;
        }
        this._channelSlope[0] = dArray[0];
    }

    public void setmanningsN(double[] dArray) {
        if (dArray[0] == Double.NEGATIVE_INFINITY) {
            this._manningsN[0] = 0.0;
            return;
        }
        this._manningsN[0] = dArray[0];
    }

    public void setchannelType(char[] cArray) {
        this._channelType = cArray;
    }

    public void setbottomWidth(double[] dArray) {
        if (dArray[0] == Double.NEGATIVE_INFINITY) {
            this._bottomWidth[0] = 0.0;
            return;
        }
        this._bottomWidth[0] = dArray[0];
    }

    public void setsideSlope(double[] dArray) {
        if (dArray[0] == Double.NEGATIVE_INFINITY) {
            this._sideSlope[0] = 0.0;
            return;
        }
        this._sideSlope[0] = dArray[0];
    }

    public void setnumberNodes(int n) {
        this._numberNodes = n == Integer.MIN_VALUE ? 1 : n;
        this.a = new double[this._numberNodes];
        this.b = new double[this._numberNodes];
        this.o = false;
    }

    public void setuseNumberNodes(boolean bl) {
        this._useNumberNodes = bl;
    }

    public void setchannelLength(ParamDouble paramDouble) {
        if (paramDouble == null) {
            return;
        }
        int n = this.getUnitSystem();
        if (n == paramDouble.getUnitSystem()) {
            this._channelLength[0] = paramDouble.getValue();
            return;
        }
        this._channelLength[0] = paramDouble.convertToUnitSystem(n);
    }

    public void getchannelLength(ParamDouble paramDouble) {
        paramDouble.setValue(this._channelLength[0]);
        paramDouble.setUnitSystem(this.getUnitSystem());
        paramDouble.setPrecision(2);
        paramDouble.setParameterId(Parameter.PARAMID_LENGTH);
    }

    public double[] getchannelLength() {
        double[] dArray = new double[]{this._channelLength[0] == Double.NEGATIVE_INFINITY ? this._channelLength[0] : this._channelLength[0]};
        return dArray;
    }

    public void setIsSI(boolean bl) {
        this.p = bl;
    }

    public double[] getchannelSlope() {
        return this._channelSlope;
    }

    public double[] getmanningsN() {
        return this._manningsN;
    }

    public char[] getchannelType() {
        return this._channelType;
    }

    public void setbottomWidth(ParamDouble paramDouble) {
        if (paramDouble == null) {
            return;
        }
        int n = this.getUnitSystem();
        if (n == paramDouble.getUnitSystem()) {
            this._bottomWidth[0] = paramDouble.getValue();
            return;
        }
        this._bottomWidth[0] = paramDouble.convertToUnitSystem(n);
    }

    public void getbottomWidth(ParamDouble paramDouble) {
        if (paramDouble == null) {
            return;
        }
        paramDouble.setValue(this._bottomWidth[0]);
        paramDouble.setUnitSystem(this.getUnitSystem());
        paramDouble.setPrecision(2);
        paramDouble.setParameterId(Parameter.PARAMID_WIDTH);
    }

    public double[] getbottomWidth() {
        double[] dArray = new double[1];
        double[] dArray2 = dArray;
        dArray[0] = this._bottomWidth[0];
        return dArray2;
    }

    public double[] getsideSlope() {
        return this._sideSlope;
    }

    public int getnumberNodes() {
        return this._numberNodes;
    }

    public boolean getuseNumberNodes() {
        return this._useNumberNodes;
    }

    public void convertToWatershedUnits() {
        if (this.getUnitSystem() == 2) {
            return;
        }
        try {
            String string = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_LENGTH, (int)2);
            String string2 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_LENGTH, (int)1);
            Units.convertUnits((double[])this._channelLength, (String)string, (String)string2);
            string = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_WIDTH, (int)2);
            string2 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_WIDTH, (int)1);
            Units.convertUnits((double[])this._bottomWidth, (String)string, (String)string2);
            return;
        }
        catch (DataSetException dataSetException) {
            this.element.getSystem().printErrorMessage("ERROR <MuskingumCungePrismRouting.convertToWatershedUnits()> : A DataSet Exception occured when converting data. Data is now in wrong Unit System");
            this.element.getSystem().printErrorMessage(dataSetException.getMessage());
            dataSetException.printStackTrace();
            return;
        }
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public boolean initializeStandalone() {
        if (!this.o) {
            if (this._numberNodes < 2) {
                this._numberNodes = 2;
            }
            this.a = new double[this._numberNodes];
            this.b = new double[this._numberNodes];
            this.o = true;
        }
        return true;
    }

    static {
        Math.pow(0.3048, 3.0);
    }
}

