/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.heclib.util.doubleContainer;
import hec.heclib.util.intContainer;
import hec.lang.InvalidStateException;
import hec.model.PairedValues;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.rss.model.Channel;
import hec.rss.model.ChannelType;
import hec.rss.model.CircularChannel;
import hec.rss.model.EightPointChannel;
import hec.rss.model.Element;
import hec.rss.model.ElementHotstartState;
import hec.rss.model.HotstartState;
import hec.rss.model.MuskingumCunge8ptRouting;
import hec.rss.model.MuskingumCungeHotstartState;
import hec.rss.model.MuskingumCungePrismRouting;
import hec.rss.model.Routing;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.TrapezoidalChannel;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.jdom.Content;
import rma.util.RMAConst;

public class MuskingumCungeRouting
extends Routing {
    private Channel _channel;
    private double _maximumExpectedFlow = 100.0;
    private double _minimumExpectedFlow = 0.0;
    private int _numberTimestepSubintervals = 1;
    private transient double c;
    private transient int d;
    transient double[] a;
    private transient double e;
    private transient boolean f = false;
    private transient double g;
    private transient double h;
    private transient double i;
    transient Object[] b;
    private transient double[] j = new double[2];
    private transient double[] k = new double[2];
    private transient double[] l = new double[2];
    private transient PairedValues m = new PairedValues();
    private transient PairedValues n = new PairedValues();
    private transient boolean o;
    private transient String p;
    private transient double q;
    private RunTimeStep _computeRoutingRunTimeStep = null;

    public MuskingumCungeRouting() {
        this(null, ChannelType.UNKNOWN);
    }

    public MuskingumCungeRouting(Element element) {
        this(element, ChannelType.UNKNOWN);
    }

    public MuskingumCungeRouting(Element element, ChannelType channelType) {
        super(element);
        this.setChannelType(channelType);
    }

    public ChannelType getChannelType() {
        if (this._channel == null) {
            return ChannelType.UNKNOWN;
        }
        return this._channel.getChannelType();
    }

    public double getMaximumExpectedFlow() {
        return this._maximumExpectedFlow;
    }

    public double getMinimumExpectedFlow() {
        return this._minimumExpectedFlow;
    }

    public void setMaximumExpectedFlow(double d) {
        this._maximumExpectedFlow = d;
    }

    public void setMinimumExpectedFlow(double d) {
        this._minimumExpectedFlow = d;
    }

    public void getMaximumExpectedFlow(ParamDouble paramDouble) {
        if (paramDouble == null) {
            return;
        }
        paramDouble.setValue(this._maximumExpectedFlow);
        paramDouble.setUnitSystem(this.getUnitSystem());
        paramDouble.setPrecision(0);
        paramDouble.setParameterId(Parameter.PARAMID_FLOW);
    }

    public void setMaximumExpectedFlow(ParamDouble paramDouble) {
        if (paramDouble == null) {
            return;
        }
        int n = this.getUnitSystem();
        if (n == paramDouble.getUnitSystem()) {
            this._maximumExpectedFlow = paramDouble.getValue();
            return;
        }
        this._maximumExpectedFlow = paramDouble.convertToUnitSystem(n);
    }

    public void getMinimumExpectedFlow(ParamDouble paramDouble) {
        if (paramDouble == null) {
            return;
        }
        paramDouble.setValue(this._minimumExpectedFlow);
        paramDouble.setUnitSystem(this.getUnitSystem());
        paramDouble.setPrecision(0);
        paramDouble.setParameterId(Parameter.PARAMID_FLOW);
    }

    public void setMinimumExpectedFlow(ParamDouble paramDouble) {
        if (paramDouble == null) {
            return;
        }
        int n = this.getUnitSystem();
        if (n == paramDouble.getUnitSystem()) {
            this._minimumExpectedFlow = paramDouble.getValue();
            return;
        }
        this._minimumExpectedFlow = paramDouble.convertToUnitSystem(n);
    }

    public void setNumberOfTimestepSubintervals(int n) {
        this._numberTimestepSubintervals = n;
        if (this._numberTimestepSubintervals <= 0) {
            this._numberTimestepSubintervals = 1;
        }
    }

    public int getNumberOfTimestepSubintervals() {
        return this._numberTimestepSubintervals;
    }

    public void setChannelType(ChannelType channelType) {
        if (this._channel != null && this._channel.getChannelType().equals(channelType)) {
            return;
        }
        this._channel = channelType.equals(ChannelType.TRAPEZOID) ? new TrapezoidalChannel() : (channelType.equals(ChannelType.EIGHT_POINT) ? new EightPointChannel() : (channelType.equals(ChannelType.CIRCLE) ? new CircularChannel() : null));
        if (this._channel != null) {
            this._channel.setUnitSystem(this.getUnitSystem());
        }
    }

    public Channel getChannel() {
        return this._channel;
    }

    @Override
    public int computeRouting(RunTimeStep runTimeStep) {
        int n;
        int n2 = runTimeStep.step;
        int n3 = runTimeStep.nstep;
        System.currentTimeMillis();
        if (n2 > 0) {
            --n2;
            ++n3;
        }
        int n4 = runTimeStep.getTimeStepMinutes();
        double d = n4 * 60;
        if (n3 > this.j.length) {
            this.j = new double[n3];
            this.l = new double[n3];
            this.k = new double[n3];
        }
        System.arraycopy(this._tsUpstrm, n2, this.j, 0, n3);
        if (!this.f) {
            this.initializeNodes(n4, this.j[0]);
        }
        double d2 = 0.0;
        double d3 = (double)(n3 - 1) * d;
        n4 = (int)(d3 / this.c) + 1;
        if (n4 > 1) {
            d2 = d3 / (double)(n4 - 1);
        }
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        this.changeTimeInterval(d, d2, n3, n4, this.j, dArray);
        double[] dArray3 = new double[n4];
        for (n = 0; n < n4; ++n) {
            dArray3[n] = 0.0;
        }
        this._computeRoutingRunTimeStep = runTimeStep;
        this.route(d2, n4, dArray, dArray3, dArray2, this.d, this.a);
        this._computeRoutingRunTimeStep = null;
        this.changeTimeInterval(d2, d, n4, n3, dArray2, this.l);
        for (n = 0; n < n3; ++n) {
            this._tsDnstrm[n + n2] = this.l[n];
        }
        System.currentTimeMillis();
        return this.checkForecastCalc(runTimeStep, true);
    }

    @Override
    public int computeRouting(RunTimeStep runTimeStep, double[] dArray, double[] dArray2, Object[] objectArray, double[] dArray3) {
        int n;
        if (dArray == null || dArray2 == null || dArray3 == null) {
            return 1;
        }
        int n2 = runTimeStep.step;
        int n3 = runTimeStep.nstep;
        int n4 = 0;
        if (n2 > 0) {
            --n2;
            ++n3;
            n4 = -1;
        }
        int n5 = runTimeStep.getTimeStepMinutes();
        double d = n5 * 60;
        if (n3 > this.j.length) {
            this.j = new double[n3];
            this.l = new double[n3];
            this.k = new double[n3];
        }
        System.arraycopy(dArray, n2, this.j, 0, n3);
        if (!this.f) {
            this.initializeNodes(n5, dArray[0]);
        }
        double d2 = 0.0;
        double d3 = (double)(n3 - 1) * d;
        n5 = (int)(d3 / this.c) + 1;
        if (n5 > 1) {
            d2 = d3 / (double)(n5 - 1);
        }
        double[] dArray4 = new double[n5];
        double[] dArray5 = new double[n5];
        this.changeTimeInterval(d, d2, n3, n5, dArray, dArray4);
        dArray = new double[n5];
        for (n = 0; n < n5; ++n) {
            dArray[n] = 0.0;
        }
        this._computeRoutingRunTimeStep = runTimeStep;
        this.route(d2, n5, dArray4, dArray, dArray5, this.d, this.a);
        this._computeRoutingRunTimeStep = null;
        this.changeTimeInterval(d2, d, n5, n3, dArray5, this.l);
        for (int i = 0; i < n3; ++i) {
            dArray2[i + n2] = this.l[i];
            n = i + n4;
            if (n < 0) continue;
            dArray3[n] = this.l[i];
        }
        return 0;
    }

    @Override
    public int computeForecastStep(RunTimeStep runTimeStep) {
        double d = this._tsUpstrm[runTimeStep.step];
        double d2 = runTimeStep.step > 0 ? this._tsUpstrm[runTimeStep.step - 1] : this._tsUpstrm[0];
        this._shouldCheckHotstart = false;
        this._tsDnstrm[runTimeStep.step] = this.computeRoutingStep(runTimeStep.getTimeStepMinutes(), d2, d);
        if (runTimeStep != null && ((RssTSLocationObject)this).getSystem().b && ((RssTSLocationObject)this).getSystem().shouldSaveHotstartAtTimeStep(runTimeStep.step, runTimeStep.flag)) {
            ArrayList<Element> arrayList = new ArrayList<Element>(1);
            Element element = this.element.getTopParent();
            arrayList.add(element);
            ((RssTSLocationObject)this).getSystem().checkSaveHotstart(runTimeStep.step, runTimeStep.flag, arrayList);
        }
        return this.checkForecastStepCalc(runTimeStep, true);
    }

    @Override
    public int computeForecast(RunTimeWindow runTimeWindow, int n) {
        RunTimeStep runTimeStep = new RunTimeStep(runTimeWindow);
        new RunTimeStep(runTimeWindow).step = runTimeWindow.getNumLookbackSteps() + 1;
        runTimeStep.nstep = runTimeWindow.getNumSteps() - runTimeWindow.getNumLookbackSteps();
        runTimeStep.flag = n;
        this._computeRoutingRunTimeStep = runTimeStep;
        this._shouldCheckHotstart = true;
        return ((Routing)this).computeRouting(runTimeStep);
    }

    public double computeRoutingStep(int n, double d, double d2) {
        int n2;
        int n3;
        if (!this.f) {
            this.initializeNodes(n, d);
        }
        if ((n3 = (int)((double)(n *= 60) / this.c + 0.5) + 1) < 2) {
            n3 = 2;
        }
        if (n3 != this.j.length) {
            this.j = new double[n3];
            this.k = new double[n3];
            this.l = new double[n3];
        }
        double d3 = n / (n3 - 1);
        this.j[0] = d;
        for (n2 = 1; n2 < n3 - 1; ++n2) {
            this.j[n2] = d + (d2 - d) * ((double)n2 * this.e) / (double)n;
        }
        this.j[n3 - 1] = d2;
        for (n2 = 0; n2 < n3; ++n2) {
            this.k[n2] = 0.0;
        }
        this.route(d3, n3, this.j, this.k, this.l, this.d, this.a);
        return this.a[this.d - 1];
    }

    private int route(double d, int n, double[] dArray, double[] dArray2, double[] dArray3, int n2, double[] dArray4) {
        int n3;
        double d2 = 0.0;
        if (n2 < 2) {
            return -1;
        }
        double d3 = this._channel.getLength() / (double)(n2 - 1);
        double[] dArray5 = new double[n2];
        double[] dArray6 = dArray5;
        dArray5[0] = dArray[0];
        for (n3 = 1; n3 < n2; ++n3) {
            dArray6[n3] = dArray4[n3];
        }
        dArray3[0] = dArray4[n2 - 1];
        double d4 = 0.0;
        if (this._computeRoutingRunTimeStep != null) {
            d4 = this._computeRoutingRunTimeStep.nstep / n;
        }
        for (int i = 1; i < n; ++i) {
            double d5 = dArray[i];
            double d6 = dArray2[i];
            double d7 = d5;
            int n4 = (int)d4 * i;
            for (int j = 1; j < n2; ++j) {
                double d8;
                double d9;
                double d10;
                if (RMAConst.isUndefinedValue((double)d7) || RMAConst.isUndefinedValue((double)dArray6[j]) || RMAConst.isUndefinedValue((double)dArray6[j - 1]) || RMAConst.isUndefinedValue((double)d6)) {
                    dArray6[j - 1] = d7;
                    d2 = -3.4028234663852886E38;
                    d7 = -3.4028234663852886E38;
                    continue;
                }
                int n5 = 1;
                double d11 = d10 = (d7 + dArray6[j] + dArray6[j - 1]) / 3.0 + d6 * d3;
                do {
                    double d12;
                    double d13;
                    double d14;
                    double d15;
                    if (d10 <= 0.01) {
                        d15 = 1.0;
                        d14 = 1.0;
                    } else {
                        double d16;
                        double d17;
                        double d18;
                        double d19 = d10;
                        if (d18 > this.m.getXValue(0) && d19 < this.m.getXValue(this.m.size() - 1)) {
                            d17 = this.m.getYValue(d19);
                            d16 = this.n.getYValue(d19);
                        } else {
                            double d20;
                            double d21 = this._channel.getDepth(d19);
                            if (d20 < 0.0) {
                                return -1;
                            }
                            d17 = this._channel.getCelerity(d21);
                            d16 = this._channel.getTopWidth(d21);
                        }
                        d15 = d17 * d / d3;
                        d14 = d10 / (d16 * this._channel.getSlope() * d17 * d3);
                    }
                    double d22 = d15 + 1.0 + d14;
                    double d23 = (d15 + 1.0 - d14) / d22;
                    double d24 = (d15 + -1.0 + d14) / d22;
                    double d25 = (1.0 - d15 + d14) / d22;
                    double d26 = d15 * 2.0 / d22;
                    if (d24 < 0.0 && !this.o) {
                        String string = this.getElement().getName();
                        this.p = "\nMuskingum-Cunge Routing for " + string + ": coefficient C2 < 0.0.\n   May need to lower Default Reference flow for reach.  Q flow = " + d10;
                        System.out.println(this.p);
                        this.getElement().getSystem().printWarningMessage(this.p);
                        this.o = true;
                    }
                    d2 = d23 * dArray6[j - 1] + d24 * d7 + d25 * dArray6[j] + d26 * d6 * d3;
                    if (d13 < 0.0) {
                        d2 = 0.0;
                    }
                    d8 = d11 * 0.01;
                    d9 = Math.abs(d11 - d2);
                    if (!(d12 > d8) || n5 > 20) continue;
                    d10 = (d2 + dArray6[j - 1] + dArray6[j] + d7) / 4.0;
                    d11 = d2;
                    ++n5;
                } while (d9 > d8 && n5 <= 20);
                dArray6[j - 1] = d7;
                d7 = d2;
            }
            dArray6[n2 - 1] = d2;
            dArray3[i] = d2;
            if (this._computeRoutingRunTimeStep != null && i == this._computeRoutingRunTimeStep.rtw.getForecastSteps() - this._computeRoutingRunTimeStep.rtw.getNumRoutingSteps()) {
                for (n3 = 0; n3 < n2; ++n3) {
                    dArray4[n3] = dArray6[n3];
                }
                this.element.saveElementState(4);
            }
            if (this._computeRoutingRunTimeStep == null || !((RssTSLocationObject)this).getSystem().b || !((RssTSLocationObject)this).getSystem().shouldSaveHotstartAtTimeStep(n4, this._computeRoutingRunTimeStep.flag)) continue;
            ArrayList<Element> arrayList = new ArrayList<Element>(1);
            Element element = this.element.getTopParent();
            arrayList.add(element);
            ((RssTSLocationObject)this).getSystem().checkSaveHotstart(n4, this._computeRoutingRunTimeStep.flag, arrayList);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            dArray4[n3] = dArray6[n3];
        }
        return 0;
    }

    @Override
    public boolean initialize() {
        String string = System.getProperty("SKIP_INITIALIZE");
        if (string == null || string.equals("true")) {
            this.f = false;
        }
        if (!super.initialize()) {
            return false;
        }
        if (!this.isValid()) {
            return false;
        }
        this.initInterpolationCurves();
        this.o = false;
        this.p = "";
        this.q = -1.0;
        return true;
    }

    private boolean initInterpolationCurves() {
        if (this._channel == null || this._channel.getChannelType() == ChannelType.UNKNOWN) {
            return false;
        }
        this.m.clearValues();
        this.n.clearValues();
        int n = 160;
        double d = 0.1;
        if (this._channel.getChannelType() == ChannelType.EIGHT_POINT) {
            n = 320;
            d = 0.1 / 2.0;
        }
        this.getUnitSystem();
        for (int i = 0; i < n; ++i) {
            double d2 = (double)i * d;
            double d3 = Math.exp(d2);
            double d4 = this._channel.getDepth(d3);
            double d5 = this._channel.getCelerity(d4);
            double d6 = this._channel.getTopWidth(d4);
            this.m.addPair(d3, d5);
            this.n.addPair(d3, d6);
        }
        if (this._channel.getChannelType() == ChannelType.EIGHT_POINT) {
            this.m.setInterpolationType(0);
            this.n.setInterpolationType(0);
        } else {
            this.m.setInterpolationType(1);
            this.n.setInterpolationType(1);
        }
        return true;
    }

    public boolean isValid() {
        int n = 0;
        if (!RMAConst.isValidValue((double)this._maximumExpectedFlow)) {
            this.element.getSystem().printErrorMessage("ERROR: Invalid value for maximum expected flow for Muskingum-Cunge routing");
            ++n;
        } else if (this._maximumExpectedFlow <= 0.0) {
            this.element.getSystem().printErrorMessage("ERROR: Maximum expected flow is not greater than zero for Muskingum-Cunge routing");
            ++n;
        }
        if (!RMAConst.isValidValue((double)this._minimumExpectedFlow)) {
            this.element.getSystem().printErrorMessage("ERROR: Invalid value for minimum expected flow for Muskingum-Cunge routing");
            ++n;
        }
        if (this._channel == null) {
            this.element.getSystem().printErrorMessage("ERROR: Channel has not been defined for Muskingum-Cunge routing");
            ++n;
        } else {
            try {
                if (!this._channel.isValid()) {
                    this.element.getSystem().printErrorMessage("Errors in channel parameters for Muskingum-Cunge routing");
                    ++n;
                }
            }
            catch (InvalidStateException invalidStateException) {
                this.element.getSystem().printErrorMessage("Errors in Muskingum-Cunge routing for " + this.element.getName() + ".\n" + invalidStateException.getMessage());
            }
        }
        if (n > 0) {
            this.element.getSystem().printErrorMessage("Reach = " + this.element.getName());
            this.element.getSystem().printErrorMessage(" ");
            return false;
        }
        return true;
    }

    private boolean initializeNodes(int n, double d) {
        double d2 = this._maximumExpectedFlow;
        intContainer intContainer2 = new intContainer();
        doubleContainer doubleContainer2 = new doubleContainer();
        if ((n = this.computeNumberNodes(d2, 0, n, intContainer2, doubleContainer2)) < 0) {
            return false;
        }
        this.c = doubleContainer2.value;
        this.d = intContainer2.value;
        this.a = new double[this.d];
        for (n = 0; n < this.d; ++n) {
            this.a[n] = d;
        }
        this.b = new Object[7];
        for (n = 0; n < 7; ++n) {
            this.b[n] = new double[this.d];
            System.arraycopy(this.a, 0, this.b[n], 0, this.a.length);
        }
        this.f = true;
        return true;
    }

    private int computeNumberNodes(double d, int n, int n2, intContainer intContainer2, doubleContainer doubleContainer2) {
        double d2;
        int n3;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9 = d * 3.0;
        double d10 = this._channel.getDepth(d9);
        if (d8 < 0.0) {
            return -1;
        }
        double d11 = this._channel.getCelerity(d10);
        if (d7 <= 0.0) {
            d11 = 0.15;
        }
        double d12 = this._channel.getLength();
        double d13 = d12 / d11;
        int n4 = this._numberTimestepSubintervals;
        if (n4 <= 0) {
            n4 = 1;
        }
        double d14 = n2 * 60 / n4;
        if (d6 > 14400.0) {
            d14 = 14400.0;
        }
        double d15 = n2 * 60;
        double d16 = d5 = d4 < d13 ? d15 : d13;
        if (n > 0) {
            double d17 = n * 60 / 20;
            double d18 = d5 = d5 < d17 ? d5 : d17;
        }
        if (d5 > d14) {
            d5 = d14;
        }
        if (d5 < d15) {
            int n5 = (int)(d15 / d5 + 0.5);
            d5 = d15 / (double)n5;
        }
        double d19 = this._channel.getDepth(d);
        d11 = this._channel.getCelerity(d19);
        if (d3 <= 0.0) {
            d11 = 0.15;
        }
        double d20 = this._channel.getSlope();
        double d21 = this._channel.getTopWidth(d19);
        double d22 = d11 * d5;
        if (d21 > 0.0 && d20 > 0.0) {
            double d23 = 0.5 * (d22 + d / (d21 * d20 * d11));
            double d24 = d22 = d22 < d23 ? d22 : d23;
        }
        if ((n3 = (int)(d12 / d22 + 0.5)) <= 0) {
            n3 = 1;
        }
        if (n3 > 200) {
            n3 = 200;
        }
        d22 = d12 / (double)n3;
        intContainer2.value = n3 + 1;
        doubleContainer2.value = d5;
        double d25 = d22 / d11;
        if (d2 > d5) {
            doubleContainer2.value = d25;
        }
        return 0;
    }

    protected void computeFlowStats(double d) {
        int n = 0;
        double d2 = 0.0;
        this.h = 1.0E10;
        this.g = 0.0;
        for (int i = 0; i < this.j.length; ++i) {
            if (!RMAConst.isValidValue((double)this.j[i]) || !(this.j[i] > 0.001)) continue;
            ++n;
            d2 += this.j[i];
            if (this.h > this.j[i]) {
                this.h = this.j[i];
            }
            if (!(this.g < this.j[i])) continue;
            this.g = this.j[i];
        }
        if (n > 0) {
            this.i = d2 / (double)n;
            return;
        }
        this.i = d;
        this.h = d;
        this.g = d;
    }

    @Override
    public void saveFunctionState(int n) {
        if (this.b == null || n >= this.b.length) {
            return;
        }
        double[] dArray = (double[])this.b[n];
        if (dArray == null || dArray.length < this.a.length) {
            return;
        }
        System.arraycopy(this.a, 0, dArray, 0, this.a.length);
    }

    @Override
    public void restoreFunctionState(int n) {
        if (this.b == null || n >= this.b.length) {
            return;
        }
        double[] dArray = (double[])this.b[n];
        if (dArray == null || dArray.length < this.a.length) {
            return;
        }
        System.arraycopy(dArray, 0, this.a, 0, this.a.length);
    }

    public void saveHotstartState(ElementHotstartState elementHotstartState, int n) {
        MuskingumCungeHotstartState muskingumCungeHotstartState = (MuskingumCungeHotstartState)elementHotstartState.getChildState(this.getName(), this.getClass().getName());
        if (muskingumCungeHotstartState == null) {
            muskingumCungeHotstartState = new MuskingumCungeHotstartState(this);
            elementHotstartState.addChildState(muskingumCungeHotstartState);
        }
        ((HotstartState)muskingumCungeHotstartState).saveState(n);
    }

    private void changeTimeInterval(double d, double d2, int n, int n2, double[] dArray, double[] dArray2) {
        dArray2[0] = dArray[0];
        double d3 = d2;
        for (int i = 1; i < n2 - 1; ++i) {
            int n3 = (int)(d3 / d);
            dArray2[i] = n3 < n - 1 ? (RMAConst.isUndefinedValue((double)dArray[n3]) || RMAConst.isUndefinedValue((double)dArray[n3 + 1]) ? Double.NEGATIVE_INFINITY : dArray[n3] + (dArray[n3 + 1] - dArray[n3]) * (d3 - d * (double)n3) / d) : dArray[n - 1];
            d3 += d2;
        }
        dArray2[n2 - 1] = dArray[n - 1];
    }

    public void copyDataFromMuskingumCunge8ptRouting(MuskingumCunge8ptRouting muskingumCunge8ptRouting) {
        if (muskingumCunge8ptRouting == null) {
            return;
        }
        EightPointChannel eightPointChannel = (EightPointChannel)this.getChannel();
        Object object = new ParamDouble();
        muskingumCunge8ptRouting.getchannelLength((ParamDouble)object);
        eightPointChannel.setchannelLength((ParamDouble)object);
        double[] dArray = muskingumCunge8ptRouting.getchannelSlope();
        object = dArray;
        if (dArray != null) {
            eightPointChannel.setSlope((double)object[0]);
        }
        eightPointChannel.setManningsN(muskingumCunge8ptRouting.getxsManningsN());
        eightPointChannel.setXCoordinates(muskingumCunge8ptRouting.getxsDistance());
        eightPointChannel.setYCoordinates(muskingumCunge8ptRouting.getxsElevation());
    }

    public void copyDataFromMuskingumCungePrismRouting(MuskingumCungePrismRouting muskingumCungePrismRouting) {
        if (muskingumCungePrismRouting == null) {
            return;
        }
        Object object = muskingumCungePrismRouting.getchannelType();
        Object object2 = ChannelType.CIRCLE;
        if (object == null || object[0] == 'P' || object[0] == 'p') {
            object2 = ChannelType.TRAPEZOID;
        }
        this.setChannelType((ChannelType)object2);
        object = this.getChannel();
        object2 = new ParamDouble();
        muskingumCungePrismRouting.getchannelLength((ParamDouble)object2);
        ((Channel)object).setchannelLength((ParamDouble)object2);
        double[] dArray = muskingumCungePrismRouting.getchannelSlope();
        object2 = dArray;
        if (dArray != null) {
            ((Channel)object).setSlope((double)object2[0]);
        }
        if (((Channel)object).getChannelType() == ChannelType.CIRCLE) {
            double[] dArray2 = muskingumCungePrismRouting.getbottomWidth();
            object2 = dArray2;
            if (dArray2 != null) {
                ((CircularChannel)object).setDiameter((double)object2[0]);
            }
            double[] dArray3 = muskingumCungePrismRouting.getmanningsN();
            object2 = dArray3;
            if (dArray3 != null) {
                ((CircularChannel)object).setManningsN((double)object2[0]);
                return;
            }
        } else if (((Channel)object).getChannelType() == ChannelType.TRAPEZOID) {
            double[] dArray4 = muskingumCungePrismRouting.getbottomWidth();
            object2 = dArray4;
            if (dArray4 != null) {
                ((TrapezoidalChannel)object).setBottomWidth((double)object2[0]);
            }
            double[] dArray5 = muskingumCungePrismRouting.getmanningsN();
            object2 = dArray5;
            if (dArray5 != null) {
                ((TrapezoidalChannel)object).setManningsN((double)object2[0]);
            }
            double[] dArray6 = muskingumCungePrismRouting.getsideSlope();
            object2 = dArray6;
            if (dArray6 != null) {
                ((TrapezoidalChannel)object).setSideSlope((double)object2[0]);
            }
        }
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void setupForSerialization() {
        this.initInterpolationCurves();
        super.setupForSerialization();
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        if (this._channel instanceof EightPointChannel) {
            element.setAttribute("Type", "MuskingumCunge8Pt");
            element.setAttribute("ChannelLength", Double.toString(((EightPointChannel)this._channel)._length));
            element.setAttribute("ChannelSlope", Double.toString(((EightPointChannel)this._channel)._slope));
            alternativeInputReport = new org.jdom.Element("Station");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])((EightPointChannel)this._channel).getXCoordinates());
            alternativeInputReport = new org.jdom.Element("Elevation");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])((EightPointChannel)this._channel).getYCoordinates());
            alternativeInputReport = new org.jdom.Element("ManningsN");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])((EightPointChannel)this._channel).getManningsN());
        } else {
            element.setAttribute("Type", "MuskingumCungePrismatic");
            element.setAttribute("ChannelLength", Double.toString(this._channel._length));
            element.setAttribute("ChannelSlope", Double.toString(this._channel._slope));
            if (this._channel instanceof TrapezoidalChannel) {
                element.setAttribute("ManningsN", Double.toString(((TrapezoidalChannel)this._channel).getManningsN()));
                element.setAttribute("BottomWidth", Double.toString(((TrapezoidalChannel)this._channel).getBottomWidth()));
                element.setAttribute("SideSlope", Double.toString(((TrapezoidalChannel)this._channel).getSideSlope()));
            } else if (this._channel instanceof CircularChannel) {
                element.setAttribute("ManningsN", Double.toString(((CircularChannel)this._channel).getManningsN()));
                element.setAttribute("ChannelDiameter", Double.toString(((CircularChannel)this._channel).getDiameter()));
            }
        }
        element.setAttribute("ReferenceFlow", Double.toString(this._maximumExpectedFlow));
        element.setAttribute("RoutingTimeStepSubintervals", Integer.toString(this._numberTimestepSubintervals));
    }

    @Override
    public boolean initializeStandalone() {
        this.f = false;
        if (!super.initialize()) {
            return false;
        }
        this.initInterpolationCurves();
        this.o = false;
        this.p = "";
        this.q = -1.0;
        return true;
    }

    @Override
    public double computeRoutingStepStandalone(int n, double d, double d2, double d3, double[] dArray, double[] dArray2) {
        double d4 = this.computeRoutingStep(n, d, d2);
        System.arraycopy(this.a, 0, dArray2, 0, this.d);
        return d4;
    }
}

