/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.model.RunTimeStep;
import hec.rss.model.Element;
import hec.rss.model.HotstartState;
import hec.rss.model.MuskingumHotstartState;
import hec.rss.model.MuskingumRouting$SubReachData;
import hec.rss.model.Routing;
import hec.rss.model.RoutingHotstartState;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.reports.AlternativeInputReport;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class MuskingumRouting
extends Routing {
    double[] _muskingumK = new double[1];
    double[] _muskingumX = new double[1];
    int _numberReaches = g;
    private transient double[] d;
    transient double[] a;
    transient boolean b = false;
    transient Object[] c;
    private static double e = 0.2;
    private static double f = 10.0;
    private static int g = 1;

    public MuskingumRouting() {
    }

    public MuskingumRouting(Element element) {
        super(element);
        this._muskingumK[0] = f;
        this._muskingumX[0] = e;
    }

    @Override
    public synchronized Object clone() {
        MuskingumRouting muskingumRouting = (MuskingumRouting)super.clone();
        if (this._muskingumK != null) {
            muskingumRouting._muskingumK = new double[this._muskingumK.length];
            System.arraycopy(this._muskingumK, 0, muskingumRouting._muskingumK, 0, this._muskingumK.length);
        }
        if (this._muskingumX != null) {
            muskingumRouting._muskingumX = new double[this._muskingumX.length];
            System.arraycopy(this._muskingumX, 0, muskingumRouting._muskingumX, 0, this._muskingumX.length);
        }
        return muskingumRouting;
    }

    @Override
    public void saveFunctionState(int n) {
        if (this.c == null || n >= this.c.length) {
            return;
        }
        double[] dArray = (double[])this.c[n];
        if (dArray == null || dArray.length < this.a.length) {
            return;
        }
        System.arraycopy(this.a, 0, dArray, 0, this.a.length);
    }

    @Override
    public void restoreFunctionState(int n) {
        if (this.c == null || n >= this.c.length) {
            return;
        }
        double[] dArray = (double[])this.c[n];
        if (dArray == null || dArray.length < this.d.length) {
            return;
        }
        System.arraycopy(dArray, 0, this.d, 0, this.d.length);
        System.arraycopy(dArray, 0, this.a, 0, this.a.length);
        if (n == 6) {
            this.b = false;
        }
    }

    @Override
    public void saveHotstartState(HotstartState hotstartState, int n) {
        MuskingumHotstartState muskingumHotstartState = (MuskingumHotstartState)hotstartState.getChildState(this.getName(), this.getClass().getName());
        if (muskingumHotstartState == null) {
            muskingumHotstartState = new MuskingumHotstartState(this);
            hotstartState.addChildState(muskingumHotstartState);
        }
        ((HotstartState)muskingumHotstartState).saveState(n);
    }

    @Override
    public boolean restoreHotstartState(HotstartState hotstartState) {
        if ((hotstartState = (MuskingumHotstartState)hotstartState.getChildState(this.getName(), this.getClass().getName())) != null) {
            ((RoutingHotstartState)hotstartState).routing(this);
            return hotstartState.restoreState();
        }
        MuskingumRouting muskingumRouting = this;
        muskingumRouting.printErrorMessage("Failed to find MuskingumRouting hotstart state for " + String.valueOf(muskingumRouting.getElement()));
        return false;
    }

    @Override
    public int computeForecastStep(RunTimeStep runTimeStep) {
        double d = this._tsUpstrm[runTimeStep.step];
        double d2 = runTimeStep.step > 0 ? this._tsUpstrm[runTimeStep.step - 1] : this._tsUpstrm[0];
        this._tsDnstrm[runTimeStep.step] = this.computeRoutingStep((double)runTimeStep.getTimeStepMinutes() / 60.0, d2, d);
        return this.checkForecastStepCalc(runTimeStep, true);
    }

    @Override
    public int computeRouting(RunTimeStep runTimeStep, double[] dArray, double[] dArray2, Object[] objectArray, double[] dArray3) {
        int n;
        int n2;
        if (dArray == null || dArray2 == null || dArray3 == null) {
            return 1;
        }
        for (n2 = 0; n2 < runTimeStep.nstep; ++n2) {
            dArray3[n2] = 0.0;
        }
        n2 = runTimeStep.step;
        int n3 = runTimeStep.nstep;
        if (!this.b) {
            for (int i = 0; i < this._numberReaches; ++i) {
                this.d[i] = dArray[n2];
            }
            this.b = true;
        }
        double d = (double)runTimeStep.getTimeStepMinutes() / 60.0;
        for (int i = 0; i < n3 && (n = i + n2) < dArray.length; ++i) {
            int n4 = Math.max(0, n - 1);
            double d2 = dArray[n];
            double d3 = dArray[n4];
            dArray3[i] = this.computeRoutingStep(d, d3, d2, (MuskingumRouting$SubReachData)objectArray[n4], (MuskingumRouting$SubReachData)objectArray[n]);
        }
        return 0;
    }

    @Override
    public int computeRouting(RunTimeStep runTimeStep) {
        int n = runTimeStep.step;
        int n2 = runTimeStep.nstep;
        runTimeStep.getTimeStepMinutes();
        if (!this.b) {
            for (int i = 0; i < this._numberReaches; ++i) {
                this.d[i] = this._tsUpstrm[n];
            }
            this.b = true;
        }
        double d = (double)runTimeStep.getTimeStepMinutes() / 60.0;
        for (int i = 0; i < n2; ++i) {
            double d2 = this._tsUpstrm[i + n];
            double d3 = i + n - 1 > 0 ? this._tsUpstrm[i + n - 1] : this._tsUpstrm[0];
            this._tsDnstrm[i + n] = this.computeRoutingStep(d, d3, d2);
            if (((RssTSLocationObject)this).getSystem().b) {
                int n3 = i + n;
                if (((RssTSLocationObject)this).getSystem().shouldSaveHotstartAtTimeStep(n3, runTimeStep.flag)) {
                    ArrayList<Element> arrayList = new ArrayList<Element>(1);
                    Element element = this.element.getTopParent();
                    arrayList.add(element);
                    ((RssTSLocationObject)this).getSystem().checkSaveHotstart(n3, runTimeStep.flag, arrayList);
                }
            }
            if (i != runTimeStep.rtw.getForecastSteps() - runTimeStep.rtw.getNumRoutingSteps() - 1) continue;
            this.element.saveElementState(4);
        }
        return this.checkForecastCalc(runTimeStep, true);
    }

    public double computeRoutingStep(double d, double d2, double d3, MuskingumRouting$SubReachData muskingumRouting$SubReachData, MuskingumRouting$SubReachData muskingumRouting$SubReachData2) {
        double d4;
        double d5 = this._muskingumK[0];
        double d6 = this._muskingumX[0];
        int n = this._numberReaches;
        double d7 = d4 = d5 / (double)n;
        double d8 = (-d4 * d6 + d * 0.5) / (d7 - d7 * d6 + d * 0.5);
        double d9 = d4;
        double d10 = (d4 * d6 + d * 0.5) / (d9 - d9 * d6 + d * 0.5);
        double d11 = d4;
        double d12 = d4;
        double d13 = (d11 - d11 * d6 - d * 0.5) / (d12 - d12 * d6 + d * 0.5);
        double d14 = d2;
        double d15 = d3;
        for (int i = 0; i < n; ++i) {
            double d16;
            double d17 = muskingumRouting$SubReachData.a()[i];
            d15 = d16 = d8 * d15 + d10 * d14 + d13 * d17;
            muskingumRouting$SubReachData2.a()[i] = d16;
            d14 = d17;
        }
        return muskingumRouting$SubReachData2.a()[this._numberReaches - 1];
    }

    private double computeRoutingStep(double d, double d2, double d3) {
        int n;
        double d4;
        double d5 = this._muskingumK[0];
        double d6 = this._muskingumX[0];
        int n2 = this._numberReaches;
        double d7 = d4 = d5 / (double)n2;
        double d8 = (-d4 * d6 + d * 0.5) / (d7 - d7 * d6 + d * 0.5);
        double d9 = d4;
        double d10 = (d4 * d6 + d * 0.5) / (d9 - d9 * d6 + d * 0.5);
        double d11 = d4;
        double d12 = d4;
        double d13 = (d11 - d11 * d6 - d * 0.5) / (d12 - d12 * d6 + d * 0.5);
        double d14 = d2;
        double d15 = d3;
        for (n = 0; n < n2; ++n) {
            double d16;
            double d17 = this.d[n];
            d15 = d16 = d8 * d15 + d10 * d14 + d13 * d17;
            this.a[n] = d16;
            d14 = d17;
        }
        for (n = 0; n < this._numberReaches; ++n) {
            this.d[n] = this.a[n];
        }
        return this.a[this._numberReaches - 1];
    }

    @Override
    public boolean initialize() {
        if (!super.initialize()) {
            return false;
        }
        String string = System.getProperty("SKIP_INITIALIZE");
        if (string == null || string.equals("true")) {
            this.b = false;
            if (this._numberReaches <= 0 || this._numberReaches == Integer.MIN_VALUE) {
                this._numberReaches = 1;
            }
            this.d = new double[this._numberReaches];
            this.a = new double[this._numberReaches];
            this.c = new Object[7];
            for (int i = 0; i < 7; ++i) {
                this.c[i] = new double[this._numberReaches];
            }
        }
        return true;
    }

    @Override
    public boolean hasDefaultParameters() {
        return this._muskingumK[0] == f && this._muskingumX[0] == e;
    }

    public void setmuskingumK(double[] dArray) {
        if (dArray[0] == Double.NEGATIVE_INFINITY) {
            this._muskingumK[0] = f;
            return;
        }
        this._muskingumK[0] = dArray[0];
    }

    public void setmuskingumX(double[] dArray) {
        if (dArray[0] == Double.NEGATIVE_INFINITY) {
            this._muskingumX[0] = e;
            return;
        }
        this._muskingumX[0] = dArray[0];
    }

    public void setnumberReaches(int n) {
        this._numberReaches = n == Integer.MIN_VALUE || n <= 0 ? g : n;
        this.d = new double[this._numberReaches];
        this.a = new double[this._numberReaches];
        this.b = false;
    }

    public double[] getmuskingumK() {
        return this._muskingumK;
    }

    public double[] getmuskingumX() {
        return this._muskingumX;
    }

    public int getnumberReaches() {
        return this._numberReaches;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    public static void a(String[] stringArray) {
        for (int i = 0; i < 1000; ++i) {
            System.out.println(i);
        }
        System.out.println("HiTHere");
        double[] dArray = new double[1];
        double[] dArray2 = dArray;
        dArray[0] = 0.9;
        double[] dArray3 = new double[1];
        dArray2 = dArray3;
        dArray3[0] = 0.1;
        dArray2 = new double[10];
        for (int i = 0; i < 5; ++i) {
            dArray2[0] = 10.0;
        }
        double[] dArray4 = new double[10];
        double[] dArray5 = new double[10];
        dArray2 = dArray5;
        dArray5[0] = 20.0;
        dArray2[1] = 30.0;
        double[] dArray6 = new double[10];
        dArray2 = dArray6;
        dArray6[0] = 0.0;
        dArray2[1] = 0.0;
        byte[] cfr_ignored_0 = new byte[81];
        System.out.println("It worked");
        System.out.println(dArray2[0] + ", " + dArray2[1]);
        System.out.println(dArray4[0] + ", " + dArray4[1]);
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        element.setAttribute("MuskingumK", Double.toString(this._muskingumK[0]));
        element.setAttribute("MuskingumX", Double.toString(this._muskingumX[0]));
        element.setAttribute("NumOfSubReaches", Integer.toString(this._numberReaches));
    }

    @Override
    public Object newRouteData() {
        MuskingumRouting muskingumRouting = this;
        return new MuskingumRouting$SubReachData(muskingumRouting, muskingumRouting._numberReaches);
    }

    @Override
    public boolean initializeStandalone() {
        if (!this.b) {
            if (this._numberReaches <= 0 || this._numberReaches == Integer.MIN_VALUE) {
                this._numberReaches = 1;
            }
            this.d = new double[this._numberReaches];
            this.a = new double[this._numberReaches];
            this.c = new Object[7];
            for (int i = 0; i < 7; ++i) {
                this.c[i] = new double[this._numberReaches];
            }
            this.b = true;
        }
        return true;
    }

    @Override
    public int getNumberSubreaches() {
        return this._numberReaches;
    }

    @Override
    public double[] getSubreachFlowArray(double d, double d2, int n) {
        double[] dArray = new double[this._numberReaches + 1];
        for (int i = 0; i < this._numberReaches; ++i) {
            dArray[i + 1] = this.a[i];
        }
        dArray[0] = d;
        return dArray;
    }

    @Override
    public double computeRoutingStepStandalone(int n, double d, double d2, double d3, double[] dArray, double[] dArray2) {
        MuskingumRouting$SubReachData muskingumRouting$SubReachData = (MuskingumRouting$SubReachData)((Routing)this).newRouteData();
        System.arraycopy(dArray, 1, muskingumRouting$SubReachData.a(), 0, ((Routing)this).getNumberSubreaches());
        MuskingumRouting$SubReachData muskingumRouting$SubReachData2 = (MuskingumRouting$SubReachData)((Routing)this).newRouteData();
        double d4 = (double)n / 60.0;
        double d5 = this.computeRoutingStep(d4, d, d2, muskingumRouting$SubReachData, muskingumRouting$SubReachData2);
        System.arraycopy(muskingumRouting$SubReachData2.a(), 0, dArray2, 1, ((Routing)this).getNumberSubreaches());
        dArray2[0] = d2;
        return d5;
    }
}

