/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.io.DSSIdentifier;
import hec.io.Identifier;
import hec.io.TimeSeriesContainer;
import hec.lang.UserId;
import hec.rss.model.Element;
import hec.rss.model.ElementHotstartState;
import hec.rss.model.HotstartContainer;
import hec.rss.model.HotstartState;
import hec.rss.model.ReservoirHotstartState;
import hec.rss.model.RssSystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.util.List;
import mil.army.usace.hec.rmi.io.HecAsciiDeserializer;
import mil.army.usace.hec.rmi.io.HecAsciiSerializer;
import rma.util.RMAIO;

public class NetworkHotstartState
extends HotstartState {
    private transient RssSystem b;
    private HecTime _time;
    private int _computeType;
    private List<String> _pathList;
    private HotstartContainer _parentContainer;

    public NetworkHotstartState() {
    }

    public NetworkHotstartState(RssSystem rssSystem, HecTime hecTime, int n) {
        this.b = rssSystem;
        this._time = new HecTime(hecTime);
        this._computeType = n;
        NetworkHotstartState networkHotstartState = this;
        networkHotstartState.setName(networkHotstartState.b.getName());
        NetworkHotstartState networkHotstartState2 = this;
        networkHotstartState2.setObjectClass(networkHotstartState2.b.getClass().getName());
    }

    void setNetwork(RssSystem rssSystem) {
        this.b = rssSystem;
    }

    @Override
    public boolean restoreState() {
        return true;
    }

    @Override
    public void saveState(int n) {
    }

    public void saveState(List list, int n) {
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            Element element = (Element)list.get(i);
            if (element == null) continue;
            element.saveHotstartState(this, n);
        }
    }

    @Override
    public HecTime getHotstartTime() {
        return this._time;
    }

    @Override
    protected int getNumStepsBack() {
        return this._parentContainer.getNumStepsBack();
    }

    @Override
    public void addTimeSeries(TimeSeriesContainer timeSeriesContainer) {
        this._parentContainer.addTimeSeries(timeSeriesContainer);
    }

    @Override
    public List<TimeSeriesContainer> getTimeSeriesList() {
        return this._parentContainer.getTimeSeriesList();
    }

    /*
     * Unable to fully structure code
     */
    public void saveFile() {
        var1_1 = this.getCPart();
        this.b.printLogMessage("Saving Hotstart state at " + String.valueOf(this.getHotstartTime()) + " for " + var1_1);
        var1_1 = this.getFilename();
        var2_3 = (RmiWorkspace)this.b.getWorkspace().getRemote();
        try {
            var2_3 = var2_3.getFileManager();
        }
        catch (RemoteException var5_4) {
            this.b.printErrorMessage("Failed to get RmiFileManager during HotStart write " + String.valueOf(var5_4));
            System.out.println("saveFile:RemoteException " + String.valueOf(var5_4));
            return;
        }
        try {
            var5_5 = RMAIO.getDirectoryFromPath((String)var1_1);
            if (!var2_3.fileExists(var5_5)) {
                var6_8 = new Identifier(var1_1);
                var2_3.newFile(UserId.getUserId(), var6_8);
            }
        }
        catch (RemoteException var5_6) {
            this.b.printWarningMessage("Failed to determine status of Hotstart file " + var1_1 + " Error:" + String.valueOf(var5_6));
            System.out.println("saveFile:Failed to determine status of Hotstart file " + var1_1 + " Error:" + String.valueOf(var5_6));
        }
        var5_7 = System.currentTimeMillis();
        var3_9 = null;
        var4_10 = var1_1.lastIndexOf(".");
        var1_1 = var1_1.substring(0, var4_10);
        var1_1 = var1_1.concat(".nhs");
        try {
            var1_1 = new Identifier(var1_1);
            var4_11 = var2_3.newFile(UserId.getUserId(), (Identifier)var1_1);
            if (var4_11 == null) {
                var4_11 = var2_3.openFile(UserId.getUserId(), (Identifier)var1_1);
            }
            if (var4_11 == null) {
                this.b.printErrorMessage("Failed to write Hotstart data.");
            }
            var2_3 = var4_11.getFile();
            var3_9 = var2_3.getBufferedWriter();
            var7_13 = new HecAsciiSerializer(var3_9);
            var7_13.serializeObject((Object)this);
            ** if (var3_9 == null) goto lbl-1000
        }
        catch (RemoteException var1_2) {
            try {
                this.b.printErrorMessage("Failed to save Hotstart State for time " + String.valueOf(this._time));
                System.out.println("saveFile:RemoteException saving Hotstart State file for " + String.valueOf(this._time) + " Exception:" + String.valueOf(var1_2));
                var1_2.printStackTrace();
                ** if (var3_9 == null) goto lbl-1000
            }
            catch (Throwable var8_15) {
                if (var3_9 != null) {
                    try {
                        var3_9.close();
                    }
                    catch (IOException v2) {}
                }
                throw var8_15;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var3_9.close();
                }
                catch (IOException v1) {}
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                var3_9.close();
            }
            catch (IOException v0) {}
        }
lbl-1000:
        // 2 sources

        {
        }
        var1_1 = new DSSIdentifier();
        var1_1.setFileName(this.getFilename());
        var4_12 = this.b.getDSSFileManager();
        var2_3 = this.getTimeSeriesList();
        var7_14 = var2_3.size();
        var3_9 = this.getSaveStartTime();
        var8_16 = this.getHotstartTime();
        var3_9.setTimeIncrement(1);
        var8_16.setTimeIncrement(1);
        var1_1.setTimeWindow(var3_9.dateAndTime(104) + " " + var8_16.dateAndTime(104));
        var1_1.setStartTime((HecTime)var3_9);
        var1_1.setEndTime(var8_16);
        var3_9 = new DSSPathname();
        var9_17 = 0;
        for (var21_18 = 0; var21_18 < var7_14; ++var21_18) {
            var8_16 = (TimeSeriesContainer)var2_3.get(var21_18);
            var3_9.setPathname(var8_16.fullName);
            var1_1.setDSSPath(var3_9.getPathname());
            if (var8_16.numberValues == 0) {
                System.out.println("saveFile:" + var8_16.fullName + " is empty");
                ++var9_17;
            }
            try {
                var8_16.fileName = var1_1.getFileName();
                var8_16.storedAsdoubles = true;
                var10_20 = var4_12.write((DSSIdentifier)var1_1, var8_16.values, var8_16.values.length, true, true, true);
                if (var10_20 == 0) continue;
                System.out.println("saveFile:write failed for " + String.valueOf(var1_1));
                continue;
            }
            catch (RemoteException var22_21) {
                this.b.printErrorMessage("Failed to save Hotstart timeseries for " + var8_16.fullName);
                System.out.println("saveFile:RemoteException saving Hotstart DSS data for " + var8_16.fullName + " Error:" + String.valueOf(var22_21));
                var22_21.printStackTrace();
            }
        }
        if (var9_17 > 0) {
            this.b.printErrorMessage("There were " + var9_17 + " empty TS Records");
        }
        var21_19 = System.currentTimeMillis();
        System.out.println("saveFile:took " + (var21_19 - var5_7) + "ms");
    }

    private String getCPart() {
        switch (this._computeType) {
            case 4: {
                return "CUMLOC";
            }
            case 2: {
                return "HOLDOUT";
            }
            case 3: {
                return "PULSEROUTING";
            }
            case 0: {
                return "REG";
            }
            case 1: {
                return "UNREG";
            }
            case -1: {
                return "EOC";
            }
        }
        return "";
    }

    public String getFilename(boolean bl) {
        return this.getFilename(null, bl);
    }

    public String getFilename(String string, boolean bl) {
        return this._parentContainer.getFilename(string, bl);
    }

    public boolean loadFile(String string) {
        string = this.getFilename(string, true);
        int n = string.lastIndexOf(".");
        string = string.substring(0, n);
        string = string.concat(".nhs");
        Object object = (RmiWorkspace)this.b.getWorkspace().getRemote();
        try {
            object = object.getFileManager();
        }
        catch (RemoteException remoteException) {
            this.b.printErrorMessage("Failed to get RmiFileManager during HotStart load " + String.valueOf(remoteException));
            System.out.println("loadFile:RemoteException " + String.valueOf(remoteException));
            return false;
        }
        try {
            if (!object.fileExists(string)) {
                this.b.printErrorMessage("Failed to find Hotstart file " + string);
                return false;
            }
        }
        catch (RemoteException remoteException) {
            this.b.printErrorMessage("load: Error during checking of Hotstart file " + string + " Error:" + String.valueOf(remoteException));
            System.out.println("loadFile: Error during checking of Hotstart file. RemoteException " + String.valueOf(remoteException));
            remoteException.printStackTrace();
        }
        Identifier identifier = new Identifier(string);
        this.b.printMessage("Loading Hotstart file from " + string);
        try {
            object = object.openFile(UserId.getUserId(), identifier);
        }
        catch (RemoteException remoteException) {
            this.b.printErrorMessage("Error opening Hotstart file " + string + " Error:" + String.valueOf(remoteException));
            System.out.println("RemoteException " + String.valueOf(remoteException));
            remoteException.printStackTrace();
            return false;
        }
        if (object == null) {
            this.b.printErrorMessage("Failed to find Hotstart file " + string);
            return false;
        }
        object = object.getFile().getBufferedReader();
        if (!(object = new HecAsciiDeserializer((BufferedReader)object)).deserializeObject((Object)this)) {
            this.b.printErrorMessage("Failed to load hotstart state from " + string);
            return false;
        }
        this.b.getDSSFileManager();
        this.getCPart();
        new DSSPathname();
        NetworkHotstartState networkHotstartState = this;
        return networkHotstartState.findElements(networkHotstartState.b.getElementVector());
    }

    public boolean findElements(List list) {
        Element element;
        int n;
        ElementHotstartState elementHotstartState;
        int n2;
        int n3 = this._childStates.size();
        int n4 = list.size();
        block0: for (n2 = 0; n2 < n3; ++n2) {
            elementHotstartState = (ElementHotstartState)this._childStates.get(n2);
            for (n = 0; n < n4; ++n) {
                element = (Element)list.get(n);
                if (!element.getName().equals(elementHotstartState.getName()) || !element.getClass().getName().equals(elementHotstartState.getObjectClass())) continue;
                elementHotstartState.setElement(element);
                if (((HotstartState)elementHotstartState).restoreState()) continue block0;
                this.b.printErrorMessage("Failed to restore " + element.getElementType() + " " + element.getName() + " to its Hotstart state");
                return false;
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            boolean bl = false;
            element = (Element)list.get(n2);
            for (n = 0; n < n3; ++n) {
                elementHotstartState = (ElementHotstartState)this._childStates.get(n);
                if (!element.getName().equals(elementHotstartState.getName()) || !element.getClass().getName().equals(elementHotstartState.getObjectClass())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.b.printErrorMessage("Failed to find Hotstart State for " + element.getElementType() + " " + String.valueOf(element) + " for " + this.getCPart());
            return false;
        }
        return true;
    }

    private HotstartState createChildState(String string) {
        if (string.endsWith("ELEMENTHOTSTARTSTATE")) {
            return new ElementHotstartState();
        }
        if (string.endsWith("RESERVOIRHOTSTARTSTATE")) {
            return new ReservoirHotstartState();
        }
        return null;
    }

    @Override
    protected void printWarningMessage(String string) {
        this._parentContainer.printWarningMessage(string);
        this.b.printWarningMessage(string);
    }

    @Override
    protected void printErrorMessage(String string) {
        this._parentContainer.printErrorMessage(string);
        this.b.printErrorMessage(string);
    }

    public void setParentContainer(HotstartContainer hotstartContainer) {
        this._parentContainer = hotstartContainer;
    }

    public int getComputeType() {
        return this._computeType;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

