/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.lang.NamedType;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.AdjustableParameter;
import hec.rss.model.ControlStructure;
import hec.rss.model.Element;
import hec.rss.model.Function;
import hec.rss.model.OpControllable;
import hec.rss.model.OpController;
import hec.rss.model.RssReturnStatusConstants;
import java.lang.reflect.Field;
import java.util.List;

public class OpControllableElement
extends NamedType
implements OpControllable,
RssReturnStatusConstants {
    OpController _controller;
    int _elemIndex;
    private transient Element b;
    transient AdjustableParameter a;

    @Override
    public void setReleaseElement(Element element) {
        this.b = element;
        this._elemIndex = element.getIndex();
    }

    @Override
    public int getReleaseElementId() {
        return this._elemIndex;
    }

    public OpControllableElement() {
    }

    public OpControllableElement(OpController opController, int n) {
        this._controller = opController;
        this._elemIndex = n;
    }

    public OpControllableElement(OpController opController, Element element) {
        this._controller = opController;
        this._elemIndex = element.getIndex();
        this.b = element;
    }

    @Override
    public double getIncrROCLimit(RunTimeStep runTimeStep, double[] dArray, double[] dArray2, double d, List list) {
        double d2;
        double d3;
        dArray[0] = d3 = this.a.getPreviousValue(runTimeStep);
        double d4 = this.a.getMaxRateOfIncrease();
        if (Math.abs(d2) < 1.0E-12) {
            d4 = 0.0;
        }
        dArray2[0] = d4 == 0.0 || d4 == Double.NEGATIVE_INFINITY ? 0.0 : d3 / (d4 /= 3600.0);
        return d4;
    }

    @Override
    public double getDecrROCLimit(RunTimeStep runTimeStep, double[] dArray, double[] dArray2, double d, List list) {
        double d2;
        double d3;
        dArray[0] = d3 = this.a.getPreviousValue(runTimeStep);
        double d4 = this.a.getMaxRateOfDecrease();
        if (Math.abs(d2) < 1.0E-12) {
            d4 = 0.0;
        }
        dArray2[0] = d4 == 0.0 || d4 == Double.NEGATIVE_INFINITY ? 0.0 : d3 / (d4 /= 3600.0);
        return d4;
    }

    public boolean isUncontrolled() {
        if (this.b == null) {
            return true;
        }
        return !(this.b.getFunction() instanceof AdjustableFlow);
    }

    @Override
    public double getFlowForPrevGateHeight(RunTimeStep runTimeStep, double d) {
        double d2 = 0.0;
        Function function = this.b.getFunction();
        if (function instanceof AdjustableFlow) {
            AdjustableFlow adjustableFlow = (AdjustableFlow)function;
            double d3 = adjustableFlow.getPrevGateHeight(runTimeStep);
            d2 = adjustableFlow.getFlowForGateHeight(d, d3);
        } else if (function instanceof ControlStructure) {
            d2 = ((ControlStructure)function).getRelease(d);
        }
        return d2;
    }

    @Override
    public double getInstFlowCap(RunTimeStep runTimeStep, double d, double[] dArray, double[] dArray2) {
        if (this.a == null) {
            return 0.0;
        }
        return this.a.getInstFlowCap(runTimeStep, d, dArray, dArray2);
    }

    @Override
    public synchronized Object clone() {
        try {
            OpControllableElement opControllableElement = (OpControllableElement)super.clone();
            ((OpControllableElement)super.clone())._controller = this._controller;
            opControllableElement._elemIndex = this._elemIndex;
            opControllableElement.b = this.b;
            opControllableElement.a = this.a;
            return opControllableElement;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public void setController(OpController opController) {
        this._controller = opController;
    }

    @Override
    public double setParameterValue(double d, RunTimeStep runTimeStep) {
        if (this.a == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.a.testValue(d, runTimeStep);
    }

    public int commitOperation(double d, RunTimeStep runTimeStep, int n) {
        if (this.a == null) {
            return 1;
        }
        double d2 = this.a.getValue(runTimeStep);
        double d3 = 0.005;
        if (d > 1.0) {
            d3 = d * 0.005;
        }
        this.a.setValue(d, runTimeStep, n);
        if (Math.abs(d - d2) < d3) {
            return 0;
        }
        return 100;
    }

    @Override
    public double getCurrentParameterValue() {
        if (this.a == null) {
            return 0.0;
        }
        return this.a.getCurrentValue();
    }

    @Override
    public double getPreviousParameterValue(RunTimeStep runTimeStep) {
        if (this.a == null) {
            return 0.0;
        }
        return this.a.getPreviousValue(runTimeStep);
    }

    @Override
    public AdjustableParameter getAdjustableParameter() {
        return this.a;
    }

    @Override
    public boolean initializeCompute(RunTimeWindow object) {
        object = this._controller.getElementOp();
        if (object == null) {
            return false;
        }
        if ((object = object.getOperationsElement()) == null) {
            return false;
        }
        this.b = object.getSystem().getElement(this._elemIndex);
        if (this.b == null) {
            return false;
        }
        object = this.b.getFunction();
        if (object == null) {
            return false;
        }
        this.a = ((Function)object).getAdjustableParameter();
        if (this.a == null) {
            return false;
        }
        this.a.setOpController(this._controller);
        return true;
    }

    @Override
    public boolean initForPostProcessing(RunTimeWindow runTimeWindow) {
        return this.initializeCompute(runTimeWindow);
    }

    @Override
    public int initOperationStep(RunTimeStep runTimeStep, int n) {
        this.a.initCurrentLimits(runTimeStep, n);
        return 0;
    }

    @Override
    public void recalcPhysicalLimitsInst(RunTimeStep runTimeStep, double d) {
        this.a.recalcCurrentLimitsInst(runTimeStep, d);
    }

    @Override
    public void recalcPhysicalLimits(RunTimeStep runTimeStep, double[] dArray, double[] dArray2, int n) {
        this.a.recalcCurrentLimits(runTimeStep, dArray, dArray2, n);
    }

    @Override
    public void setReleaseElementId(int n) {
        this._elemIndex = n;
        this.b = null;
    }

    public int getElementIndex() {
        return this._elemIndex;
    }

    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

