/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.data.Parameter;
import hec.heclib.util.doubleArrayContainer;
import hec.heclib.util.doubleContainer;
import hec.heclib.util.intContainer;
import hec.lang.NamedType;
import hec.model.IntToDoubleArrayContainer;
import hec.model.IntToDoubleContainer;
import hec.model.Interpolate;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.model.TSLocation;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.AdjustableParameter;
import hec.rss.model.ControlStructure;
import hec.rss.model.DemandRuleInf;
import hec.rss.model.DivertedOutletElement;
import hec.rss.model.DownstreamCntrlOpRule;
import hec.rss.model.DownstreamOpRule;
import hec.rss.model.Element;
import hec.rss.model.ElementOp;
import hec.rss.model.FlowLimitOpRule;
import hec.rss.model.Function;
import hec.rss.model.HindcastData;
import hec.rss.model.HotstartState;
import hec.rss.model.IndependentVariable;
import hec.rss.model.OpControllable;
import hec.rss.model.OpControllableElement;
import hec.rss.model.OpControllerHotstartState;
import hec.rss.model.OpRule;
import hec.rss.model.OpRuleFactory;
import hec.rss.model.OpSet;
import hec.rss.model.OpValue;
import hec.rss.model.OperationsElement;
import hec.rss.model.OutletGroupElement;
import hec.rss.model.PowerPlant;
import hec.rss.model.RateChangeLimitOpRule;
import hec.rss.model.ReleaseAllocation;
import hec.rss.model.ReleaseAllocationObject;
import hec.rss.model.ReleaseAllocationSet;
import hec.rss.model.ReleaseFuncOpRule;
import hec.rss.model.ReleaseOverrides;
import hec.rss.model.ReservoirDamElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOp;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.RuleConnectivityRef;
import hec.rss.model.Storage;
import hec.rss.model.StorageZone;
import hec.rss.model.SystemHydropowerOpRule;
import hec.rss.model.TandemOpRule;
import hec.rss.model.TandemSysOpRule;
import hec.rss.model.WaterAccount;
import hec.rss.model.WaterAccountSet;
import hec.rss.server.RssComputeOptions;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import rma.lang.RmaMath;
import rma.util.DoubleVector;
import rma.util.RMAConst;

public class OpController
extends RssTSLocationObject
implements OpControllable {
    public static final String PARAMSTR_DECISION = "FLow-Decision";
    public static final String PARAMSTR_RULEID = "RuleID";
    public static final String PARAMSTR_ZONEID = "ZoneID";
    public static final int OBJECTIVE_GC = -1;
    public static final int OBJECTIVE_RO = -2;
    public static final int OBJECTIVE_EO = -3;
    public static final int OBJECTIVE_ZB = -4;
    public static final int OBJECTIVE_MIN = -5;
    public static final String[] OBJECTIVE_NAME = new String[]{"not used", "GC", "RO", "EO", "ZB", "MinLimit", "not used", "not used", "not used", "not used", "Unctrl", "PhysMaxCap", "PhysMinCap", "MaxLimit", "MinRelease", "PhysIROC", "PhysDROC", "CapOutage", "NotUsed", "CapOverride"};
    public static final int CNSTRNTID_PHYSMAX = -11;
    public static final int CNSTRNTID_PHYSMIN = -12;
    public static final int CNSTRNTID_CHILDMAX = -13;
    public static final int CNSTRNTID_CHILDMIN = -14;
    public static final int CNSTRNTID_PHYSIROC = -15;
    public static final int CNSTRNTID_PHYSDROC = -16;
    public static final int CNSTRNTID_CAPOUTAGE = -17;
    public static final int CNSTRNTID_CAPOVERRIDE = -19;
    public static final int CNSTRNTID_UNCONTROLLED = -10;
    public static final String[] CNSTRNT_NAME = OBJECTIVE_NAME;
    public static final double ZERO_TOL = 1.0E-10;
    public static final int DISTMETH_BALANCE = 0;
    public static final int DISTMETH_SEQUENTIAL = 1;
    private transient boolean D;
    private transient boolean E;
    private transient boolean F;
    private transient double G;
    private transient double H;
    private transient int I;
    private transient double J;
    private transient double K;
    transient ElementOp a;
    private transient Element L;
    int _releaseElemId = Integer.MIN_VALUE;
    Vector _controllableVec = new Vector();
    Hashtable _ruleTable = new Hashtable();
    OpController _parentOpController;
    int _distributionMethod = 0;
    int _nextRuleIndex = 0;
    int _nextOpControllableIndex = 0;
    private transient intContainer M = new intContainer();
    transient OpSet b;
    private transient Storage N;
    private transient double O = Double.NEGATIVE_INFINITY;
    transient AdjustableParameter c;
    private transient Hashtable P = null;
    private transient Hashtable Q = null;
    transient double[] d;
    transient double[] e;
    private transient double[] R;
    private transient double[] S;
    private transient double[] T;
    private transient double[] U;
    private transient Vector V;
    transient doubleArrayContainer f;
    transient doubleArrayContainer g;
    private transient int W = -1;
    transient int[] h;
    transient double[] i;
    transient double[] j;
    transient double[] k;
    transient int[] l;
    transient int[] m;
    transient OpValue[] n;
    private transient OpValue X;
    private transient OpValue Y;
    private transient OpValue Z;
    private transient OpValue aa;
    private transient double[][] ab = null;
    private transient boolean[] ac;
    private transient boolean[] ad;
    private transient double[] ae;
    private transient double[] af;
    private transient double[] ag;
    private transient double[] ah;
    private transient boolean[] ai;
    transient OpValue[] o;
    transient OpValue[] p;
    transient OpValue[] q;
    transient OpValue[] r;
    transient int[] s;
    transient double[] t;
    transient double[] u;
    transient double[] v;
    transient int[] w;
    transient int[] x;
    transient OpValue[] y;
    transient OpValue[] z;
    transient OpValue[] A;
    transient OpValue[] B;
    transient OpValue[] C;
    private transient List<PowerPlant> aj;
    private transient Map<ReleaseAllocationSet, List<OpController>> ak;
    private transient Map<ReleaseAllocationSet, List> al;
    private transient Map<ReleaseAllocationSet, Map<intContainer, doubleContainer>> am;
    public static final String TOP_PARENT_NAME = "Reservoir";

    public OpController() {
    }

    public OpController(String string) {
        super(string);
    }

    public OpController(String string, int n) {
        super(string);
        this.setIndex(n);
    }

    public void applyPhysicalLimits32(RunTimeStep runTimeStep, boolean bl) {
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        dArray[0] = 0.0;
        dArray[1] = runTimeStep.getTimeStepSeconds();
        dArray2[0] = this.N.getPreviousElevationEst33(runTimeStep);
        dArray2[1] = this.N.getElevationEst33(runTimeStep);
        if (!RMAConst.isValidValue((double)dArray2[1])) {
            dArray2[1] = dArray2[0];
        }
        this.recalcPhysicalLimits(runTimeStep, dArray, dArray2, 2);
    }

    public void loadControllerLimits(RunTimeStep runTimeStep) {
        this.o[runTimeStep.step].value = this.f.array[runTimeStep.step];
        this.p[runTimeStep.step].value = this.g.array[runTimeStep.step];
        int n = this._controllableVec.size();
        for (int i = 0; i < n; ++i) {
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(i);
            if (!(opControllable instanceof OpController)) continue;
            opControllable = (OpController)opControllable;
            ((OpController)opControllable).loadControllerLimits(runTimeStep);
        }
    }

    double saveReleaseToGuideCurve(RunTimeStep runTimeStep) {
        StorageZone storageZone = this.b.getGuideCurveZone();
        if (storageZone == null && (storageZone = this.b.getInactiveZone()) == null) {
            return Double.NEGATIVE_INFINITY;
        }
        double d = this.getFlowObjectiveToZoneElev(storageZone, this.c, runTimeStep, null, null, Double.NEGATIVE_INFINITY);
        if (this.T != null) {
            this.T[runTimeStep.step] = d;
        }
        return d;
    }

    @Override
    public double getIncrROCLimit(RunTimeStep runTimeStep, double[] dArray, double[] dArray2, double d, List list) {
        int n;
        int n2 = this._controllableVec.size();
        double[] dArray3 = new double[1];
        double d2 = 0.0;
        double[] dArray4 = new double[1];
        double d3 = 0.0;
        for (n = 0; n < n2; ++n) {
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(n);
            opControllable.getIncrROCLimit(runTimeStep, dArray3, dArray4, d, list);
            d2 += dArray3[0];
            if (dArray4[0] == Double.NEGATIVE_INFINITY) continue;
            d3 = Math.max(dArray4[0], d3);
        }
        if (list != null) {
            int n3 = list.size();
            for (n = 0; n < n3; ++n) {
                double d4;
                OpRule opRule = (OpRule)list.get(n);
                if (!(opRule instanceof RateChangeLimitOpRule) || opRule.getController() != this || ((RateChangeLimitOpRule)(opRule = (RateChangeLimitOpRule)opRule)).getType() != 1 || (d4 = ((RateChangeLimitOpRule)opRule).getRateOfChangeLimit(runTimeStep) / 3600.0) == Double.NEGATIVE_INFINITY) continue;
                dArray4[0] = d2 / d4;
                d3 = Math.max(dArray4[0], d3);
            }
        }
        dArray[0] = d2;
        dArray2[0] = d3;
        double d5 = d3 > 0.0 ? d2 / d3 : Double.NEGATIVE_INFINITY;
        return d5;
    }

    @Override
    public double getDecrROCLimit(RunTimeStep runTimeStep, double[] dArray, double[] dArray2, double d, List list) {
        int n;
        int n2 = this._controllableVec.size();
        double[] dArray3 = new double[1];
        double d2 = 0.0;
        double[] dArray4 = new double[1];
        double d3 = 0.0;
        for (n = 0; n < n2; ++n) {
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(n);
            opControllable.getDecrROCLimit(runTimeStep, dArray3, dArray4, d, list);
            d2 += dArray3[0];
            if (dArray4[0] == Double.NEGATIVE_INFINITY) continue;
            d3 = Math.max(dArray4[0], d3);
        }
        if (list != null) {
            int n3 = list.size();
            for (n = 0; n < n3; ++n) {
                double d4;
                OpRule opRule = (OpRule)list.get(n);
                if (!(opRule instanceof RateChangeLimitOpRule) || opRule.getController() != this || ((RateChangeLimitOpRule)(opRule = (RateChangeLimitOpRule)opRule)).getType() != 0 || (d4 = ((RateChangeLimitOpRule)opRule).getRateOfChangeLimit(runTimeStep) / 3600.0) == Double.NEGATIVE_INFINITY) continue;
                dArray4[0] = d2 / d4;
                d3 = Math.max(dArray4[0], d3);
            }
        }
        dArray[0] = d2;
        dArray2[0] = d3;
        double d5 = d3 > 0.0 ? d2 / d3 : Double.NEGATIVE_INFINITY;
        return d5;
    }

    @Override
    public double getFlowForPrevGateHeight(RunTimeStep runTimeStep, double d) {
        double d2 = 0.0;
        int n = this._controllableVec.size();
        for (int i = 0; i < n; ++i) {
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(i);
            d2 += opControllable.getFlowForPrevGateHeight(runTimeStep, d);
        }
        return d2;
    }

    @Override
    public double getInstFlowCap(RunTimeStep runTimeStep, double d, double[] dArray, double[] dArray2) {
        double d2 = 0.0;
        int n = this._controllableVec.size();
        for (int i = 0; i < n; ++i) {
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(i);
            d2 += opControllable.getInstFlowCap(runTimeStep, d, dArray, dArray2);
        }
        return d2;
    }

    public double getCurLimitPowerFlow(RunTimeStep runTimeStep, int n) {
        double d = 0.0;
        Function function = this.getReleaseElement().getFunction();
        if (function instanceof AdjustableFlow) {
            if (((AdjustableFlow)(function = (AdjustableFlow)function)).hasPowerPlant()) {
                d = n == 2 ? 0.0 + this.p[runTimeStep.step].value : (n == 0 ? 0.0 + this.o[runTimeStep.step].value : 0.0 + this.n[runTimeStep.step].value);
            }
            return d;
        }
        int n2 = this._controllableVec.size();
        for (int i = 0; i < n2; ++i) {
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(i);
            if (!(opControllable instanceof OpController)) continue;
            d += ((OpController)opControllable).getCurLimitPowerFlow(runTimeStep, n);
        }
        return d;
    }

    void setRuleId(RunTimeStep runTimeStep, int n) {
        if (this.e == null) {
            return;
        }
        this.e[runTimeStep.step] = n;
    }

    public WaterAccount getWaterAccount(OpRule opRule) {
        WaterAccount waterAccount = null;
        WaterAccountSet waterAccountSet = ((RssTSLocationObject)this).getSystem().getAlternative().getWaterAccountSet();
        OperationsElement operationsElement = this.a.getOperationsElement();
        if (waterAccountSet != null && operationsElement instanceof ReservoirElement && waterAccountSet.containsReservoir((ReservoirElement)operationsElement) && opRule instanceof DemandRuleInf) {
            waterAccount = ((DemandRuleInf)((Object)opRule)).getWaterAccount();
        }
        return waterAccount;
    }

    private double calcWAPrevMinRuleVal(OpController opController, double d, double d2, OpRule opRule, RunTimeStep runTimeStep) {
        double d3 = Math.max(this.o[runTimeStep.step].value, d);
        double d4 = d2;
        if (opController != null) {
            int n = this._controllableVec.size();
            for (int i = 0; i < n; ++i) {
                Object object = (OpControllable)this._controllableVec.get(i);
                if (!(object instanceof OpController) || object == opController) continue;
                object = ((OpController)object).getCurMinOpValue(runTimeStep);
                d4 += ((OpValue)object).value;
            }
        }
        double d5 = Double.NEGATIVE_INFINITY;
        if (this._parentOpController != null) {
            d5 = this._parentOpController.calcWAPrevMinRuleVal(this, d3, d4, opRule, runTimeStep);
        } else if (this.o[runTimeStep.step].ruleid == -4) {
            d3 = d4;
        }
        return Math.max(d5, d3 - d4);
    }

    public boolean applyRuleLimits2(RunTimeStep runTimeStep, OpRule opRule, int n) {
        if (opRule.getController() == this) {
            int n2;
            Object object;
            int n3;
            OpValue opValue = opRule.getOpValue(runTimeStep);
            if (opValue == null || !RMAConst.isValidValue((double)opValue.value)) {
                return false;
            }
            int n4 = this._index << 16 | opRule.getIndex();
            WaterAccount waterAccount = this.getWaterAccount(opRule);
            boolean bl = waterAccount != null;
            double d = this.o[runTimeStep.step].value;
            if (bl) {
                d = this.calcWAPrevMinRuleVal(null, d, 0.0, opRule, runTimeStep);
                if (opValue.childFractionTable != null) {
                    n3 = this.L.getChildElementCount();
                    for (int i = 0; i < n3; i += 1) {
                        Element element;
                        Float f = (Float)opValue.childFractionTable.get(i);
                        if (f != null && (double)f.floatValue() != 0.0 || (object = this.a.getController(element = this.L.getChildElementAt(i))) == null) continue;
                        d -= ((OpController)object).getCurMinOpValue((RunTimeStep)runTimeStep).value;
                    }
                }
                this.checkForWAclipping(runTimeStep, waterAccount, opValue, d);
            }
            if (opValue.childFractionTable == null) {
                boolean bl2 = this.applyOpValue(opValue, n4, runTimeStep);
                this.g.array[runTimeStep.step] = this.p[runTimeStep.step].value;
                this.f.array[runTimeStep.step] = this.o[runTimeStep.step].value;
                if (bl) {
                    this.evalWA(runTimeStep, waterAccount, d, this.o[runTimeStep.step].value);
                }
                return bl2;
            }
            n3 = this.L.getChildElementCount();
            double d2 = 0.0;
            for (n2 = 0; n2 < n3; n2 += 1) {
                object = (Float)opValue.childFractionTable.get(n2);
                if (object == null) continue;
                OpValue opValue2 = new OpValue(opValue);
                opValue2.value *= (double)((Float)object).floatValue();
                opValue2.childFractionTable = null;
                object = this.L.getChildElementAt(n2);
                if ((object = this.a.getController((Element)object)) == null) continue;
                ((OpController)object).applyOpValue(opValue2, n4, runTimeStep);
                ((OpController)object).g.array[runTimeStep.step] = ((OpController)object).p[runTimeStep.step].value;
                ((OpController)object).f.array[runTimeStep.step] = ((OpController)object).o[runTimeStep.step].value;
                d2 += ((OpController)object).o[runTimeStep.step].value;
            }
            n2 = this.recalculateChildLimits(runTimeStep) ? 1 : 0;
            this.g.array[runTimeStep.step] = this.p[runTimeStep.step].value;
            this.f.array[runTimeStep.step] = this.o[runTimeStep.step].value;
            if (bl) {
                this.evalWA(runTimeStep, waterAccount, d, d2);
            }
            return n2 != 0;
        }
        int n5 = this._controllableVec.size();
        for (int i = 0; i < n5; ++i) {
            OpController opController;
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(i);
            if (!(opControllable instanceof OpController) || !(opController = (OpController)opControllable).hasRule(opRule)) continue;
            opController.applyRuleLimits2(runTimeStep, opRule, n);
            break;
        }
        boolean bl = this.recalculateChildLimits(runTimeStep);
        this.g.array[runTimeStep.step] = this.p[runTimeStep.step].value;
        this.f.array[runTimeStep.step] = this.o[runTimeStep.step].value;
        return bl;
    }

    private void checkForWAclipping(RunTimeStep runTimeStep, WaterAccount waterAccount, OpValue opValue, double d) {
        double d2;
        double d3 = opValue.value;
        double d4 = waterAccount.getDemand(runTimeStep);
        double d5 = Math.max(d3 - d, 0.0);
        double d6 = d5 + d4;
        if (waterAccount.hasYieldAnalysis()) {
            d2 = waterAccount.getRuleDemand(runTimeStep);
            waterAccount.setRuleDemand(runTimeStep, d2 + d5);
        }
        if (d6 > (d2 = waterAccount.getAvailableVolume(runTimeStep) / (double)runTimeStep.getTimeStepSeconds() * Storage.DSDT_TO_Q)) {
            double d7 = d6 - d2;
            double d8 = d2 < 0.0 ? d : d3 - d7;
            opValue.value = d8;
        }
    }

    private void evalWA(RunTimeStep runTimeStep, WaterAccount waterAccount, double d, double d2) {
        double d3 = waterAccount.getDemand(runTimeStep);
        double d4 = Math.max(d2 - d, 0.0);
        double d5 = d4 + d3;
        waterAccount.setDemand(runTimeStep, d5);
        waterAccount.updateCurrentVolume(runTimeStep);
    }

    public double getMinReleaseVol(RunTimeStep runTimeStep) {
        if (this.f == null || this.f.array == null) {
            return 0.0;
        }
        int n = runTimeStep.step - 1;
        if (n < 0) {
            n = 0;
        }
        return Function.getFlowVolume(runTimeStep, this.d[n], this.f.array[runTimeStep.step]);
    }

    public double getMaxReleaseVol(RunTimeStep runTimeStep) {
        if (this.g == null || this.g.array == null) {
            return 0.0;
        }
        int n = runTimeStep.step - 1;
        if (n < 0) {
            n = 0;
        }
        return Function.getFlowVolume(runTimeStep, this.d[n], this.g.array[runTimeStep.step]);
    }

    public boolean isUncontrolled() {
        Object object;
        return this._controllableVec.size() == 1 && (object = (OpControllable)this._controllableVec.get(0)) instanceof OpControllableElement && (object = this.getReleaseElement()) != null && (object = ((Element)object).getFunction()) != null && !(object instanceof AdjustableFlow);
    }

    public boolean hasPowerPlants() {
        if (this.aj == null) {
            this.getPowerPlantList(true);
        }
        return !this.aj.isEmpty();
    }

    public PowerPlant getElementPowerPlant() {
        AdjustableFlow adjustableFlow;
        PowerPlant powerPlant = null;
        Function function = this.L.getFunction();
        if (function instanceof AdjustableFlow && (adjustableFlow = (AdjustableFlow)function).hasPowerPlant()) {
            powerPlant = ((AdjustableFlow)function).getPowerPlant();
        }
        return powerPlant;
    }

    public List<PowerPlant> getPowerPlantList(boolean bl) {
        if (bl) {
            this.aj = null;
        }
        ArrayList<PowerPlant> arrayList = new ArrayList<PowerPlant>();
        if (this.aj != null) {
            arrayList.addAll(this.aj);
            return arrayList;
        }
        this.aj = new ArrayList<PowerPlant>();
        PowerPlant powerPlant = null;
        Function function = this.L.getFunction();
        if (function instanceof AdjustableFlow) {
            AdjustableFlow adjustableFlow = (AdjustableFlow)function;
            if (adjustableFlow.hasPowerPlant()) {
                powerPlant = ((AdjustableFlow)function).getPowerPlant();
            }
            if (powerPlant != null && !this.aj.contains(powerPlant)) {
                this.aj.add(powerPlant);
            }
        } else {
            int n = this._controllableVec.size();
            for (int i = 0; i < n; ++i) {
                Object object = (OpControllable)this._controllableVec.get(i);
                if (!(object instanceof OpController)) continue;
                object = ((OpController)object).getPowerPlantList(bl);
                object = object.iterator();
                while (object.hasNext()) {
                    PowerPlant powerPlant2 = object.next();
                    if (powerPlant2 == null || this.aj.contains(powerPlant2)) continue;
                    this.aj.add(powerPlant2);
                }
            }
        }
        arrayList.addAll(this.aj);
        return arrayList;
    }

    double getElementReleaseForPower(RunTimeStep runTimeStep, double d) {
        PowerPlant powerPlant = this.getElementPowerPlant();
        if (powerPlant == null) {
            return 0.0;
        }
        double d2 = powerPlant.getTailwaterElevation(runTimeStep);
        double d3 = powerPlant.getPoolElevation(runTimeStep);
        double d4 = powerPlant.getRequiredRelease(d, d3, d2);
        return d4;
    }

    double getPowerForElementRelease(RunTimeStep runTimeStep, double d) {
        PowerPlant powerPlant = this.getElementPowerPlant();
        if (powerPlant == null) {
            return 0.0;
        }
        double d2 = powerPlant.getTailwaterElevation(runTimeStep);
        double d3 = powerPlant.getPoolElevation(runTimeStep);
        double d4 = powerPlant.calculatePower(d, d3, d2);
        return d4;
    }

    double getPowerForMinRelease(RunTimeStep runTimeStep) {
        if (!this.hasPowerPlants()) {
            return 0.0;
        }
        if (this.getReleaseElement().getFunction() instanceof AdjustableFlow) {
            PowerPlant powerPlant = this.getElementPowerPlant();
            if (powerPlant == null) {
                return 0.0;
            }
            double d = powerPlant.getTailwaterElevation(runTimeStep);
            double d2 = powerPlant.getPoolElevation(runTimeStep);
            double d3 = powerPlant.calculatePower(this.o[runTimeStep.step].value, d2, d);
            return d3;
        }
        double d = 0.0;
        int n = this._controllableVec.size();
        for (int i = 0; i < n; ++i) {
            OpControllable opControllable = (OpControllable)this._controllableVec.get(i);
            if (!(opControllable instanceof OpController)) continue;
            d += ((OpController)opControllable).getPowerForMinRelease(runTimeStep);
        }
        return d;
    }

    double getPowerForMaxRelease(RunTimeStep runTimeStep) {
        if (!this.hasPowerPlants()) {
            return 0.0;
        }
        if (this.getReleaseElement().getFunction() instanceof AdjustableFlow) {
            PowerPlant powerPlant = this.getElementPowerPlant();
            if (powerPlant == null) {
                return 0.0;
            }
            double d = powerPlant.getTailwaterElevation(runTimeStep);
            double d2 = powerPlant.getPoolElevation(runTimeStep);
            double d3 = powerPlant.calculatePower(this.p[runTimeStep.step].value, d2, d);
            return d3;
        }
        double d = 0.0;
        int n = this._controllableVec.size();
        for (int i = 0; i < n; ++i) {
            OpControllable opControllable = (OpControllable)this._controllableVec.get(i);
            if (!(opControllable instanceof OpController)) continue;
            d += ((OpController)opControllable).getPowerForMaxRelease(runTimeStep);
        }
        return d;
    }

    public List getRuleConnectivityRefs(boolean bl) {
        Object object;
        ArrayList<RuleConnectivityRef> arrayList = new ArrayList<RuleConnectivityRef>();
        if (!this._ruleTable.isEmpty()) {
            Object object2;
            RuleConnectivityRef ruleConnectivityRef;
            TSLocation tSLocation;
            Enumeration<Object> enumeration = this._ruleTable.elements();
            while (enumeration.hasMoreElements()) {
                tSLocation = (OpRule)enumeration.nextElement();
                if (tSLocation instanceof ReleaseFuncOpRule) {
                    ReleaseFuncOpRule releaseFuncOpRule = (ReleaseFuncOpRule)tSLocation;
                    object = releaseFuncOpRule.getIndependentVariable();
                    if (object != null) {
                        if (((IndependentVariable)object).getType() == 2) {
                            ruleConnectivityRef = new RuleConnectivityRef();
                            ruleConnectivityRef.a(releaseFuncOpRule);
                            ruleConnectivityRef.b(object);
                            ruleConnectivityRef.a(2);
                            arrayList.add(ruleConnectivityRef);
                        } else if (((IndependentVariable)object).getType() == 4) {
                            ruleConnectivityRef = new RuleConnectivityRef();
                            ruleConnectivityRef.a(releaseFuncOpRule);
                            ruleConnectivityRef.b(object);
                            ruleConnectivityRef.a(5);
                            arrayList.add(ruleConnectivityRef);
                        }
                    }
                    if (!(tSLocation instanceof DownstreamCntrlOpRule)) continue;
                    object2 = (DownstreamCntrlOpRule)tSLocation;
                    int n = ((DownstreamOpRule)object2).getDownstreamControlLocationID();
                    tSLocation = ((RssTSLocationObject)this).getSystem().getNode(n);
                    ruleConnectivityRef = new RuleConnectivityRef();
                    ruleConnectivityRef.a(object2);
                    ruleConnectivityRef.b(tSLocation);
                    ruleConnectivityRef.a(0);
                    arrayList.add(ruleConnectivityRef);
                    continue;
                }
                if (tSLocation instanceof TandemOpRule) {
                    TandemOpRule tandemOpRule = (TandemOpRule)tSLocation;
                    int n = tandemOpRule.getReservoirIndex();
                    object2 = ((RssTSLocationObject)this).getSystem().getNode(n);
                    ruleConnectivityRef = new RuleConnectivityRef();
                    ruleConnectivityRef.a(tandemOpRule);
                    ruleConnectivityRef.b(object2);
                    ruleConnectivityRef.a(4);
                    arrayList.add(ruleConnectivityRef);
                    continue;
                }
                if (tSLocation instanceof FlowLimitOpRule) {
                    FlowLimitOpRule flowLimitOpRule = (FlowLimitOpRule)tSLocation;
                    int n = flowLimitOpRule.getRssNodeIndex();
                    if (n < 0) continue;
                    object2 = ((RssTSLocationObject)this).getSystem().getNode(n);
                    ruleConnectivityRef = new RuleConnectivityRef();
                    ruleConnectivityRef.a(flowLimitOpRule);
                    ruleConnectivityRef.b(object2);
                    ruleConnectivityRef.a(0);
                    arrayList.add(ruleConnectivityRef);
                    continue;
                }
                if (!(tSLocation instanceof SystemHydropowerOpRule)) continue;
                SystemHydropowerOpRule systemHydropowerOpRule = (SystemHydropowerOpRule)tSLocation;
                object = systemHydropowerOpRule.getReservoirIndexArray();
                for (int i = 0; i < ((Object)object).length; ++i) {
                    object2 = (ReservoirElement)((RssTSLocationObject)this).getSystem().getElement((int)object[i]);
                    if (object2 == null) continue;
                    ruleConnectivityRef = new RuleConnectivityRef();
                    ruleConnectivityRef.a(tSLocation);
                    ruleConnectivityRef.b(object2);
                    ruleConnectivityRef.a(4);
                    arrayList.add(ruleConnectivityRef);
                }
            }
            enumeration = this.a.getOpSetTable().elements();
            while (enumeration.hasMoreElements()) {
                tSLocation = (OpSet)enumeration.nextElement();
                for (int i = 0; i < ((OpSet)tSLocation)._zoneVec.size(); ++i) {
                    object = ((OpSet)tSLocation)._zoneVec.get(i);
                    if (((StorageZone)object)._independentVariable.getType() != 2 || (object2 = ((StorageZone)object)._independentVariable) == null || ((IndependentVariable)object2).getType() != 2) continue;
                    ruleConnectivityRef = new RuleConnectivityRef();
                    ruleConnectivityRef.a(object);
                    ruleConnectivityRef.b(object2);
                    ruleConnectivityRef.a(2);
                    arrayList.add(ruleConnectivityRef);
                }
            }
        }
        if (bl) {
            int n = this._controllableVec.size();
            for (int i = 0; i < n; ++i) {
                List list;
                object = (OpControllable)this._controllableVec.elementAt(i);
                if (!(object instanceof OpController) || (list = ((OpController)object).getRuleConnectivityRefs(bl)) == null) continue;
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    public void saveFunctionState(int n) {
        if (this.s == null) {
            return;
        }
        Object object = this.getReleaseElement().getSystem().getStateRts();
        this.s[n] = this.h[((RunTimeStep)object).step];
        this.t[n] = this.i[((RunTimeStep)object).step];
        this.u[n] = this.j[((RunTimeStep)object).step];
        this.v[n] = this.k[((RunTimeStep)object).step];
        this.w[n] = this.l[((RunTimeStep)object).step];
        this.x[n] = this.m[((RunTimeStep)object).step];
        this.y[n].init(this.n[((RunTimeStep)object).step]);
        this.z[n].init(this.o[((RunTimeStep)object).step]);
        this.A[n].init(this.p[((RunTimeStep)object).step]);
        this.B[n].init(this.q[((RunTimeStep)object).step]);
        this.C[n].init(this.r[((RunTimeStep)object).step]);
        if (this._ruleTable != null) {
            object = this._ruleTable.elements();
            while (object.hasMoreElements()) {
                OpRule opRule = (OpRule)object.nextElement();
                opRule.saveFunctionState(n);
            }
        }
        int n2 = this._controllableVec.size();
        for (int i = 0; i < n2; ++i) {
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(i);
            if (!(opControllable instanceof OpController)) continue;
            ((OpController)opControllable).saveFunctionState(n);
        }
    }

    public void restoreFunctionState(int n) {
        if (this.s == null) {
            return;
        }
        Object object = this.getReleaseElement().getSystem().getStateRts();
        this.h[((RunTimeStep)object).step] = this.s[n];
        this.i[((RunTimeStep)object).step] = this.t[n];
        this.j[((RunTimeStep)object).step] = this.u[n];
        this.k[((RunTimeStep)object).step] = this.v[n];
        this.l[((RunTimeStep)object).step] = this.w[n];
        this.m[((RunTimeStep)object).step] = this.x[n];
        this.n[((RunTimeStep)object).step].init(this.y[n]);
        this.o[((RunTimeStep)object).step].init(this.z[n]);
        this.p[((RunTimeStep)object).step].init(this.A[n]);
        this.q[((RunTimeStep)object).step].init(this.B[n]);
        this.r[((RunTimeStep)object).step].init(this.C[n]);
        if (this._ruleTable != null) {
            object = this._ruleTable.elements();
            while (object.hasMoreElements()) {
                OpRule opRule = (OpRule)object.nextElement();
                opRule.restoreFunctionState(n);
            }
        }
        int n2 = this._controllableVec.size();
        for (int i = 0; i < n2; ++i) {
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(i);
            if (!(opControllable instanceof OpController)) continue;
            ((OpController)opControllable).restoreFunctionState(n);
        }
    }

    public void saveHotstartState(HotstartState hotstartState, int n) {
        OpControllerHotstartState opControllerHotstartState = (OpControllerHotstartState)hotstartState.getChildState(this.getName(), this.getClass().getName());
        if (opControllerHotstartState == null) {
            opControllerHotstartState = new OpControllerHotstartState(this);
            hotstartState.addChildState(opControllerHotstartState);
        }
        ((HotstartState)opControllerHotstartState).saveState(n);
    }

    public boolean restoreHotstartState(HotstartState hotstartState) {
        if ((hotstartState = (OpControllerHotstartState)hotstartState.getChildState(this.getName(), this.getClass().getName())) != null) {
            ((OpControllerHotstartState)hotstartState).setOpController(this);
            return hotstartState.restoreState();
        }
        return false;
    }

    public DownstreamCntrlOpRule getDownstreamRuleForParent(int n, int n2) {
        Enumeration enumeration = this._ruleTable.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof DownstreamCntrlOpRule) || ((DownstreamCntrlOpRule)v).getParentRuleIndex() != n2 || ((DownstreamCntrlOpRule)v).getParentRule() == null || ((DownstreamCntrlOpRule)v).getParentRule().getDownstreamControlLocationID() != n) continue;
            return (DownstreamCntrlOpRule)v;
        }
        return null;
    }

    public SystemHydropowerOpRule getSystemHydropowerRuleForParent(int n) {
        Enumeration enumeration = this._ruleTable.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof SystemHydropowerOpRule) || ((SystemHydropowerOpRule)v).getParentRuleIndex() != n) continue;
            return (SystemHydropowerOpRule)v;
        }
        return null;
    }

    public TandemSysOpRule getTandemSysOpRuleForParent(int n) {
        Enumeration enumeration = this._ruleTable.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof TandemSysOpRule) || ((TandemSysOpRule)v).getParentIndex() != n) continue;
            return (TandemSysOpRule)v;
        }
        return null;
    }

    public void setZone(RunTimeStep runTimeStep, StorageZone storageZone) {
        if (storageZone != null) {
            this.S[runTimeStep.step] = storageZone.getIndex();
            return;
        }
        this.S[runTimeStep.step] = Double.NEGATIVE_INFINITY;
    }

    @Override
    public int initOperationStep(RunTimeStep runTimeStep, int n) {
        Object object;
        int n2;
        this.i[runTimeStep.step] = Double.NEGATIVE_INFINITY;
        this.j[runTimeStep.step] = Double.NEGATIVE_INFINITY;
        this.k[runTimeStep.step] = Double.NEGATIVE_INFINITY;
        this.l[runTimeStep.step] = -1;
        this.m[runTimeStep.step] = -1;
        this.n[runTimeStep.step].init();
        this.c.setDefaultParameters();
        int n3 = this._controllableVec.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = (OpControllable)this._controllableVec.elementAt(n2);
            object.initOperationStep(runTimeStep, n);
            object = object.getAdjustableParameter();
            if (n2 == 0) {
                this.c.setConstraints((AdjustableParameter)object);
            } else {
                this.c.sumConstraints((AdjustableParameter)object);
            }
            this.o[runTimeStep.step].value = this.o[runTimeStep.step].value == Double.NEGATIVE_INFINITY ? ((AdjustableParameter)object).getMinValue() : (this.o[runTimeStep.step].value += ((AdjustableParameter)object).getMinValue());
            if (this.p[runTimeStep.step].value == Double.NEGATIVE_INFINITY) {
                this.p[runTimeStep.step].value = ((AdjustableParameter)object).getMaxValue();
                continue;
            }
            this.p[runTimeStep.step].value += ((AdjustableParameter)object).getMaxValue();
        }
        this.g.array[runTimeStep.step] = this.p[runTimeStep.step].value;
        this.f.array[runTimeStep.step] = this.o[runTimeStep.step].value;
        n3 = this.V.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = (OpRule)this.V.get(n2);
            ((OpRule)object).initOperationStep(runTimeStep, n);
        }
        return 0;
    }

    public OpValue getCurrentOpValue(RunTimeStep runTimeStep) {
        return this.n[runTimeStep.step];
    }

    public void setCurrentOpValue(double d, RunTimeStep runTimeStep) {
        if (this.n != null) {
            this.n[runTimeStep.step].value = d;
        }
    }

    public void setCurrentOpValue(double d, int n, RunTimeStep runTimeStep) {
        if (this.n[runTimeStep.step] != null) {
            this.n[runTimeStep.step].value = d;
            this.n[runTimeStep.step].constraintid = n;
        }
    }

    public void setCurrentOpValue(double d, int n, int n2, RunTimeStep runTimeStep) {
        if (this.n[runTimeStep.step] != null) {
            this.n[runTimeStep.step].value = d;
            this.n[runTimeStep.step].ruleid = n;
            this.n[runTimeStep.step].constraintid = n2;
        }
    }

    public void setCurMaxOpValue(double d, int n, int n2, RunTimeStep runTimeStep) {
        if (this.p != null) {
            this.p[runTimeStep.step].value = d;
            this.p[runTimeStep.step].ruleid = n;
            this.p[runTimeStep.step].constraintid = n2;
        }
    }

    public void setCurMinOpValue(double d, int n, int n2, RunTimeStep runTimeStep) {
        if (this.o != null) {
            this.o[runTimeStep.step].value = d;
            this.o[runTimeStep.step].ruleid = n;
            this.o[runTimeStep.step].constraintid = n2;
        }
    }

    public OpValue getCurMinOpValue(RunTimeStep runTimeStep) {
        return this.o[runTimeStep.step];
    }

    public OpValue getCurMaxOpValue(RunTimeStep runTimeStep) {
        return this.p[runTimeStep.step];
    }

    public OpValue getCurOpValue(RunTimeStep runTimeStep) {
        return this.n[runTimeStep.step];
    }

    public double getDecisionValue(RunTimeStep runTimeStep) {
        if (runTimeStep == null || runTimeStep.step < 0 || this.d == null || runTimeStep.step >= this.d.length) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.d[runTimeStep.step];
    }

    public double getEstimatedCurLimit(int n, RunTimeStep runTimeStep) {
        double d = n == 0 ? this.o[runTimeStep.step].value : this.p[runTimeStep.step].value;
        if (this._parentOpController != null) {
            double d2 = this._parentOpController.getEstimatedCurLimitForChild(this, n, runTimeStep);
            if (n == 0) {
                if (d2 > d) {
                    d = d2;
                }
            } else if (d2 < d) {
                d = d2;
            }
        }
        return d;
    }

    public double getEstimatedCurLimitForChild(OpController opController, int n, RunTimeStep object) {
        double d = this.getEstimatedCurLimit(n, (RunTimeStep)object);
        if (this.b.hasUserDefinedReleaseAllocation() && this.b.getReleaseAllocationObject() != null) {
            ReleaseAllocationObject releaseAllocationObject = this.b.getReleaseAllocationObject();
            object = releaseAllocationObject.getActiveReleaseAllocationSet((RunTimeStep)object);
            if (((ReleaseAllocation)(object = ((ReleaseAllocationSet)((Object)object)).getReleaseAllocation(this.getIndex()))).getAllocationType() == 0) {
                return this.getEstCurChildLimSeq(opController, n, (ReleaseAllocation)object, d);
            }
            if (((ReleaseAllocation)object).getAllocationType() == 2) {
                return this.getEstCurChildLimStep(opController, n, (ReleaseAllocation)object, d);
            }
            return this.getEstCurChildLimBal(opController, n, (ReleaseAllocation)object, d);
        }
        return this.getEstCurChildLimBal(opController, n, null, d);
    }

    public double getCurLimitOpValue(int n, RunTimeStep runTimeStep) {
        if (n == 0) {
            return this.o[runTimeStep.step].value;
        }
        return this.p[runTimeStep.step].value;
    }

    private double getEstCurChildLimSeq(OpController opController, int n, ReleaseAllocation releaseAllocation, double d) {
        return 0.0;
    }

    private double getEstCurChildLimStep(OpController opController, int n, ReleaseAllocation releaseAllocation, double d) {
        return 0.0;
    }

    private double getEstCurChildLimBal(OpController opController, int n, ReleaseAllocation releaseAllocation, double d) {
        int n2 = this._controllableVec.size();
        if (n2 < 2) {
            return d;
        }
        return 0.0;
    }

    @Override
    public void recalcPhysicalLimitsInst(RunTimeStep runTimeStep, double d) {
        this.o[runTimeStep.step].init(0, 0.0, Float.MIN_VALUE, -12, Integer.MIN_VALUE);
        this.p[runTimeStep.step].init(2, 0.0, Float.MIN_VALUE, -11, Integer.MIN_VALUE);
        this.i[runTimeStep.step] = Double.NEGATIVE_INFINITY;
        this.j[runTimeStep.step] = Double.NEGATIVE_INFINITY;
        this.k[runTimeStep.step] = Double.NEGATIVE_INFINITY;
        this.l[runTimeStep.step] = -1;
        this.m[runTimeStep.step] = -1;
        this.n[runTimeStep.step].init();
        this.c.setDefaultParameters();
        int n = this._controllableVec.size();
        for (int i = 0; i < n; ++i) {
            Object object = (OpControllable)this._controllableVec.elementAt(i);
            object.recalcPhysicalLimitsInst(runTimeStep, d);
            object = object.getAdjustableParameter();
            if (i == 0) {
                this.c.setConstraints((AdjustableParameter)object);
            } else {
                this.c.sumConstraints((AdjustableParameter)object);
            }
            this.o[runTimeStep.step].value = this.o[runTimeStep.step].value == Double.NEGATIVE_INFINITY ? ((AdjustableParameter)object).getMinValue() : (this.o[runTimeStep.step].value += ((AdjustableParameter)object).getMinValue());
            if (this.p[runTimeStep.step].value == Double.NEGATIVE_INFINITY) {
                this.p[runTimeStep.step].value = ((AdjustableParameter)object).getMaxValue();
                continue;
            }
            this.p[runTimeStep.step].value += ((AdjustableParameter)object).getMaxValue();
        }
        this.g.array[runTimeStep.step] = this.p[runTimeStep.step].value;
        this.f.array[runTimeStep.step] = this.o[runTimeStep.step].value;
    }

    @Override
    public void recalcPhysicalLimits(RunTimeStep runTimeStep, double[] dArray, double[] dArray2, int n) {
        this.o[runTimeStep.step].init(0, 0.0, Float.MIN_VALUE, -12, Integer.MIN_VALUE);
        this.p[runTimeStep.step].init(2, 0.0, Float.MIN_VALUE, -11, Integer.MIN_VALUE);
        this.i[runTimeStep.step] = Double.NEGATIVE_INFINITY;
        this.j[runTimeStep.step] = Double.NEGATIVE_INFINITY;
        this.k[runTimeStep.step] = Double.NEGATIVE_INFINITY;
        this.l[runTimeStep.step] = -1;
        this.m[runTimeStep.step] = -1;
        this.n[runTimeStep.step].init();
        this.c.setDefaultParameters();
        int n2 = this._controllableVec.size();
        for (int i = 0; i < n2; ++i) {
            Object object = (OpControllable)this._controllableVec.elementAt(i);
            object.recalcPhysicalLimits(runTimeStep, dArray, dArray2, n);
            object = object.getAdjustableParameter();
            if (i == 0) {
                this.c.setConstraints((AdjustableParameter)object);
            } else {
                this.c.sumConstraints((AdjustableParameter)object);
            }
            this.o[runTimeStep.step].value = this.o[runTimeStep.step].value == Double.NEGATIVE_INFINITY ? ((AdjustableParameter)object).getMinValue() : (this.o[runTimeStep.step].value += ((AdjustableParameter)object).getMinValue());
            if (this.p[runTimeStep.step].value == Double.NEGATIVE_INFINITY) {
                this.p[runTimeStep.step].value = ((AdjustableParameter)object).getMaxValue();
                continue;
            }
            this.p[runTimeStep.step].value += ((AdjustableParameter)object).getMaxValue();
        }
        this.g.array[runTimeStep.step] = this.p[runTimeStep.step].value;
        this.f.array[runTimeStep.step] = this.o[runTimeStep.step].value;
    }

    public void distributePhysicalLimits(RunTimeStep runTimeStep) {
        double d;
        int n;
        this.o[runTimeStep.step].init(0, 0.0, Float.MIN_VALUE, -12, Integer.MIN_VALUE);
        this.p[runTimeStep.step].init(2, 0.0, Float.MIN_VALUE, -11, Integer.MIN_VALUE);
        if (this.isUncontrolled()) {
            this.p[runTimeStep.step].ruleid = -10;
            this.o[runTimeStep.step].ruleid = -10;
        }
        if ((n = this._controllableVec.size()) == 1 && this._controllableVec.elementAt(0) instanceof OpControllableElement) {
            var4_3 = (OpControllable)this._controllableVec.elementAt(0);
            AdjustableParameter adjustableParameter = var4_3.getAdjustableParameter();
            this.o[runTimeStep.step].value = adjustableParameter.getMinValue();
            this.p[runTimeStep.step].value = adjustableParameter.getMaxValue();
            this.p[runTimeStep.step] = this.b.getCapacityOutageOrOverride(this.L, runTimeStep.step, this.p[runTimeStep.step]);
            if (this.o[runTimeStep.step].value > this.p[runTimeStep.step].value) {
                this.o[runTimeStep.step].value = this.p[runTimeStep.step].value;
            }
            if ((d = adjustableParameter.getMinByDROC(runTimeStep)) != Double.NEGATIVE_INFINITY && this.o[runTimeStep.step].value < d) {
                this.o[runTimeStep.step].value = d;
                this.o[runTimeStep.step].ruleid = -16;
            }
            if ((d = adjustableParameter.getMaxByIROC(runTimeStep)) != Double.NEGATIVE_INFINITY && this.p[runTimeStep.step].value > d) {
                this.p[runTimeStep.step].value = d;
                this.p[runTimeStep.step].ruleid = -15;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                var4_3 = (OpControllable)this._controllableVec.elementAt(i);
                if (!(var4_3 instanceof OpController)) continue;
                OpController opController = (OpController)var4_3;
                opController.distributePhysicalLimits(runTimeStep);
                this.o[runTimeStep.step].value += opController.o[runTimeStep.step].value;
                this.o[runTimeStep.step].ruleid = -14;
                this.p[runTimeStep.step].value += opController.p[runTimeStep.step].value;
                this.p[runTimeStep.step].ruleid = -13;
            }
        }
        if (this._parentOpController == null && this.a instanceof ReservoirOp) {
            double d2 = this.N.getPreviousStorage(runTimeStep);
            if (runTimeStep.isPerAvgTimeStep()) {
                d = this.N.getNetInflowVolume(runTimeStep);
                double d3 = Math.max(0.0, d2 + d);
                double d4 = d3 / (double)runTimeStep.getTimeStepSeconds() * Storage.DSDT_TO_Q;
                d4 = Math.max(0.0, d4);
                this.p[runTimeStep.step].value = Math.min(d4, this.p[runTimeStep.step].value);
            } else {
                d = this.N.getNetInflow(runTimeStep);
                double d5 = this.N.getPreviousNetInflow(runTimeStep);
                double d6 = this.getReleaseTSContainer().array[runTimeStep.step - 1];
                double d7 = d2 / (double)runTimeStep.getTimeStepSeconds() * Storage.DSDT_TO_Q + d + (d5 - d6) / 2.0;
                d7 = Math.max(0.0, d7);
                this.p[runTimeStep.step].value = Math.min(d7, this.p[runTimeStep.step].value);
            }
        }
        this.g.array[runTimeStep.step] = this.p[runTimeStep.step].value;
        this.f.array[runTimeStep.step] = this.o[runTimeStep.step].value;
    }

    public void applyPhysicalLimits(RunTimeStep runTimeStep, boolean n) {
        if (n != 0) {
            this.getElementOp().determinePhysicalLimits(this, runTimeStep);
        }
        int n2 = this._controllableVec.size();
        int n3 = this.getNumControlledOutlets();
        if (n3 <= 1) {
            return;
        }
        for (n = 0; n < n2; ++n) {
            OpController opController;
            int n4;
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(n);
            if (!(opControllable instanceof OpController) || (n4 = (opController = (OpController)opControllable).getNumControlledOutlets()) <= 0) continue;
            opController.applyPhysicalLimits(runTimeStep, n3 > n4);
        }
    }

    public int getNumControlledOutlets() {
        if (this.W >= 0) {
            return this.W;
        }
        int n = this._controllableVec.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(i);
            if (opControllable instanceof OpController) {
                opControllable = (OpController)opControllable;
                n2 += ((OpController)opControllable).getNumControlledOutlets();
                continue;
            }
            if (!(opControllable instanceof OpControllableElement) || ((OpControllableElement)opControllable).isUncontrolled()) continue;
            ++n2;
        }
        this.W = n2;
        return n2;
    }

    public boolean applyReleaseOverrides(RunTimeStep runTimeStep) {
        double d;
        int n = this._controllableVec.size();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            OpController opController;
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(i);
            if (!(opControllable instanceof OpController) || !(opController = (OpController)opControllable).applyReleaseOverrides(runTimeStep)) continue;
            bl = true;
        }
        if (bl) {
            bl2 = this.recalculateChildLimits(runTimeStep);
        }
        if ((d = this.getOverride(runTimeStep)) != Double.NEGATIVE_INFINITY) {
            if (d <= this.p[runTimeStep.step].value && d >= this.o[runTimeStep.step].value) {
                this.p[runTimeStep.step].value = d;
                this.p[runTimeStep.step].ruleid = -2;
                this.p[runTimeStep.step].constraintid = Integer.MIN_VALUE;
                this.p[runTimeStep.step].type = 1;
                this.o[runTimeStep.step].init(this.p[runTimeStep.step]);
                bl2 = true;
            } else if (this.p[runTimeStep.step].value < d) {
                if (this.p[runTimeStep.step].constraintid == Integer.MIN_VALUE) {
                    this.p[runTimeStep.step].constraintid = this.p[runTimeStep.step].ruleid;
                    this.p[runTimeStep.step].ruleid = -2;
                }
                this.p[runTimeStep.step].type = 1;
                if (this.o[runTimeStep.step].value < this.p[runTimeStep.step].value) {
                    this.o[runTimeStep.step].value = this.p[runTimeStep.step].value;
                    this.o[runTimeStep.step].constraintid = this.p[runTimeStep.step].constraintid;
                    this.o[runTimeStep.step].ruleid = -2;
                    this.o[runTimeStep.step].type = 1;
                    bl2 = true;
                }
            } else {
                if (this.o[runTimeStep.step].constraintid == Integer.MIN_VALUE) {
                    this.o[runTimeStep.step].constraintid = this.o[runTimeStep.step].ruleid;
                    this.o[runTimeStep.step].ruleid = -2;
                }
                this.o[runTimeStep.step].type = 1;
                if (this.p[runTimeStep.step].value < this.o[runTimeStep.step].value) {
                    this.p[runTimeStep.step].value = this.o[runTimeStep.step].value;
                    this.p[runTimeStep.step].constraintid = this.o[runTimeStep.step].constraintid;
                    this.p[runTimeStep.step].ruleid = -2;
                    this.p[runTimeStep.step].type = 1;
                    bl2 = true;
                }
            }
        }
        this.g.array[runTimeStep.step] = this.p[runTimeStep.step].value;
        this.f.array[runTimeStep.step] = this.o[runTimeStep.step].value;
        return bl2;
    }

    public int applyElevationOverrides(RunTimeStep runTimeStep, Hashtable hashtable) {
        double d;
        if (hashtable == null) {
            return 0;
        }
        Object object = (Double)this.Q.get(new Integer(runTimeStep.valueMinutes()));
        if (object == null || (Double)object == Double.NEGATIVE_INFINITY) {
            return 0;
        }
        object = this.b.getGuideCurveZone();
        if (object == null) {
            object = this.b.getInactiveZone();
        }
        if ((d = this.getFlowObjectiveToZoneElev((StorageZone)object, this.c, runTimeStep, null, hashtable, Double.NEGATIVE_INFINITY)) != Double.NEGATIVE_INFINITY) {
            if (d <= this.p[runTimeStep.step].value && d >= this.o[runTimeStep.step].value) {
                this.p[runTimeStep.step].value = d;
                this.p[runTimeStep.step].ruleid = -3;
                this.p[runTimeStep.step].constraintid = Integer.MIN_VALUE;
                this.p[runTimeStep.step].type = 1;
                this.o[runTimeStep.step].init(this.p[runTimeStep.step]);
            } else if (this.p[runTimeStep.step].value < d) {
                if (this.p[runTimeStep.step].constraintid == Integer.MIN_VALUE) {
                    this.p[runTimeStep.step].constraintid = this.p[runTimeStep.step].ruleid;
                    this.p[runTimeStep.step].ruleid = -3;
                }
                this.p[runTimeStep.step].type = 1;
                if (this.o[runTimeStep.step].value < this.p[runTimeStep.step].value) {
                    this.o[runTimeStep.step].value = this.p[runTimeStep.step].value;
                    this.o[runTimeStep.step].constraintid = this.p[runTimeStep.step].constraintid;
                    this.o[runTimeStep.step].ruleid = -3;
                    this.o[runTimeStep.step].type = 1;
                }
            } else {
                if (this.o[runTimeStep.step].constraintid == Integer.MIN_VALUE) {
                    this.o[runTimeStep.step].constraintid = this.o[runTimeStep.step].ruleid;
                    this.o[runTimeStep.step].ruleid = -3;
                }
                this.o[runTimeStep.step].type = 1;
                if (this.p[runTimeStep.step].value < this.o[runTimeStep.step].value) {
                    this.p[runTimeStep.step].value = this.o[runTimeStep.step].value;
                    this.p[runTimeStep.step].constraintid = this.o[runTimeStep.step].constraintid;
                    this.p[runTimeStep.step].ruleid = -3;
                    this.p[runTimeStep.step].type = 1;
                }
            }
        }
        this.g.array[runTimeStep.step] = this.p[runTimeStep.step].value;
        this.f.array[runTimeStep.step] = this.o[runTimeStep.step].value;
        return 0;
    }

    public double applyZoneOperation(RunTimeStep runTimeStep, StorageZone storageZone) {
        if (storageZone == null) {
            return Double.NEGATIVE_INFINITY;
        }
        double d = this.getFlowObjectiveToZoneElev(storageZone, this.c, runTimeStep, null, null, Double.NEGATIVE_INFINITY);
        if (d != Double.NEGATIVE_INFINITY) {
            if (d <= this.p[runTimeStep.step].value && d >= this.o[runTimeStep.step].value) {
                this.p[runTimeStep.step].value = d;
                this.p[runTimeStep.step].ruleid = -4;
                this.p[runTimeStep.step].constraintid = Integer.MIN_VALUE;
                this.p[runTimeStep.step].type = 1;
                this.o[runTimeStep.step].init(this.p[runTimeStep.step]);
            } else if (this.p[runTimeStep.step].value < d) {
                if (this.p[runTimeStep.step].constraintid == Integer.MIN_VALUE) {
                    this.p[runTimeStep.step].constraintid = this.p[runTimeStep.step].ruleid;
                    this.p[runTimeStep.step].ruleid = -4;
                }
                this.p[runTimeStep.step].type = 1;
                if (this.o[runTimeStep.step].value < this.p[runTimeStep.step].value) {
                    this.o[runTimeStep.step].value = this.p[runTimeStep.step].value;
                    this.o[runTimeStep.step].constraintid = this.p[runTimeStep.step].constraintid;
                    this.o[runTimeStep.step].ruleid = -4;
                    this.o[runTimeStep.step].type = 1;
                }
            } else {
                if (this.o[runTimeStep.step].constraintid == Integer.MIN_VALUE) {
                    this.o[runTimeStep.step].constraintid = this.o[runTimeStep.step].ruleid;
                    this.o[runTimeStep.step].ruleid = -4;
                }
                this.o[runTimeStep.step].type = 1;
                if (this.p[runTimeStep.step].value < this.o[runTimeStep.step].value) {
                    this.p[runTimeStep.step].value = this.o[runTimeStep.step].value;
                    this.p[runTimeStep.step].constraintid = this.o[runTimeStep.step].constraintid;
                    this.p[runTimeStep.step].ruleid = -4;
                    this.p[runTimeStep.step].type = 1;
                }
            }
        }
        this.g.array[runTimeStep.step] = this.p[runTimeStep.step].value;
        this.f.array[runTimeStep.step] = this.o[runTimeStep.step].value;
        return d;
    }

    boolean applyOpValue(OpValue opValue, int n, RunTimeStep runTimeStep) {
        if (this._parentOpController != null) {
            OpController opController = this;
            this._parentOpController.getCurChildLimits(opController, opController.q[runTimeStep.step], this.r[runTimeStep.step], runTimeStep);
            if (this.q[runTimeStep.step].value > this.p[runTimeStep.step].value - 1.0E-10) {
                this.q[runTimeStep.step].init(this.p[runTimeStep.step]);
            }
            if (this.r[runTimeStep.step].value < this.o[runTimeStep.step].value + 1.0E-10) {
                this.r[runTimeStep.step].init(this.o[runTimeStep.step]);
            }
            if (this.q[runTimeStep.step].value < this.r[runTimeStep.step].value + 1.0E-10) {
                this.q[runTimeStep.step].init(this.r[runTimeStep.step]);
            }
        } else {
            this.q[runTimeStep.step].init(this.p[runTimeStep.step]);
            this.r[runTimeStep.step].init(this.o[runTimeStep.step]);
        }
        if (opValue.type == 2) {
            if (this.p[runTimeStep.step].value > opValue.value + 1.0E-10 || opValue.value < this.r[runTimeStep.step].value - 1.0E-10) {
                if (opValue.value < this.r[runTimeStep.step].value - 1.0E-10) {
                    if (this.p[runTimeStep.step].value < this.r[runTimeStep.step].value + 1.0E-10) {
                        return false;
                    }
                    this.p[runTimeStep.step].value = this.r[runTimeStep.step].value;
                    this.p[runTimeStep.step].ruleid = n;
                    this.p[runTimeStep.step].constraintid = this.r[runTimeStep.step].ruleid;
                    this.p[runTimeStep.step].type = 2;
                    return true;
                }
                this.p[runTimeStep.step].value = opValue.value;
                this.p[runTimeStep.step].ruleid = n;
                this.p[runTimeStep.step].constraintid = opValue.constraintid;
                this.p[runTimeStep.step].type = 2;
                return true;
            }
            return false;
        }
        if (opValue.type == 0) {
            if (this.o[runTimeStep.step].value < opValue.value - 1.0E-10 || opValue.value > this.q[runTimeStep.step].value + 1.0E-10) {
                if (opValue.value > this.q[runTimeStep.step].value + 1.0E-10) {
                    if (this.o[runTimeStep.step].value > this.q[runTimeStep.step].value - 1.0E-10) {
                        return false;
                    }
                    this.o[runTimeStep.step].value = this.q[runTimeStep.step].value;
                    this.o[runTimeStep.step].constraintid = this.q[runTimeStep.step].ruleid;
                    this.o[runTimeStep.step].ruleid = n;
                    this.o[runTimeStep.step].type = 0;
                    return true;
                }
                this.o[runTimeStep.step].value = opValue.value;
                this.o[runTimeStep.step].constraintid = opValue.constraintid;
                this.o[runTimeStep.step].ruleid = n;
                this.o[runTimeStep.step].type = 0;
                return true;
            }
            return false;
        }
        if (opValue.value < this.p[runTimeStep.step].value - 1.0E-10 && opValue.value > this.o[runTimeStep.step].value + 1.0E-10 || opValue.value > this.q[runTimeStep.step].value - 1.0E-10 || opValue.value < this.r[runTimeStep.step].value + 1.0E-10) {
            if (opValue.value > this.q[runTimeStep.step].value - 1.0E-10) {
                this.o[runTimeStep.step].value = this.q[runTimeStep.step].value;
                this.o[runTimeStep.step].constraintid = this.q[runTimeStep.step].ruleid;
                this.o[runTimeStep.step].ruleid = n;
                this.o[runTimeStep.step].type = 1;
                this.p[runTimeStep.step].init(this.o[runTimeStep.step]);
            } else if (opValue.value < this.r[runTimeStep.step].value + 1.0E-10) {
                this.p[runTimeStep.step].value = this.r[runTimeStep.step].value;
                this.p[runTimeStep.step].ruleid = n;
                this.p[runTimeStep.step].constraintid = this.r[runTimeStep.step].ruleid;
                this.p[runTimeStep.step].type = 1;
                this.o[runTimeStep.step].init(this.p[runTimeStep.step]);
            } else {
                this.p[runTimeStep.step].value = opValue.value;
                this.p[runTimeStep.step].ruleid = n;
                this.p[runTimeStep.step].constraintid = opValue.constraintid;
                this.p[runTimeStep.step].type = 1;
                this.o[runTimeStep.step].init(this.p[runTimeStep.step]);
            }
            return true;
        }
        if (opValue.value < this.o[runTimeStep.step].value + 1.0E-10) {
            if (this.p[runTimeStep.step].value > this.o[runTimeStep.step].value + 1.0E-10) {
                this.p[runTimeStep.step].value = this.o[runTimeStep.step].value;
                this.p[runTimeStep.step].ruleid = n;
                this.p[runTimeStep.step].constraintid = this.o[runTimeStep.step].ruleid;
                this.p[runTimeStep.step].type = 1;
                return true;
            }
        } else if (this.o[runTimeStep.step].value < this.p[runTimeStep.step].value - 1.0E-10) {
            this.o[runTimeStep.step].value = this.p[runTimeStep.step].value;
            this.o[runTimeStep.step].ruleid = n;
            this.o[runTimeStep.step].constraintid = this.p[runTimeStep.step].ruleid;
            this.o[runTimeStep.step].type = 1;
            return true;
        }
        return false;
    }

    boolean recalculateChildLimits(RunTimeStep runTimeStep) {
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = false;
        int n = this._controllableVec.size();
        for (int i = 0; i < n; ++i) {
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(i);
            if (!(opControllable instanceof OpController)) continue;
            opControllable = (OpController)opControllable;
            d += ((OpController)opControllable).o[runTimeStep.step].value;
            d2 += ((OpController)opControllable).p[runTimeStep.step].value;
        }
        if (d > this.o[runTimeStep.step].value) {
            if (d <= this.p[runTimeStep.step].value) {
                this.o[runTimeStep.step].value = d;
                this.o[runTimeStep.step].ruleid = -14;
                this.o[runTimeStep.step].constraintid = Integer.MIN_VALUE;
            } else {
                this.o[runTimeStep.step].value = this.p[runTimeStep.step].value;
                this.o[runTimeStep.step].ruleid = -14;
                this.o[runTimeStep.step].constraintid = this.p[runTimeStep.step].ruleid;
            }
            bl = true;
        }
        if (d2 < this.p[runTimeStep.step].value) {
            if (d2 >= this.o[runTimeStep.step].value) {
                this.p[runTimeStep.step].value = d2;
                this.p[runTimeStep.step].ruleid = -13;
                this.p[runTimeStep.step].constraintid = Integer.MIN_VALUE;
            } else {
                this.p[runTimeStep.step].value = this.o[runTimeStep.step].value;
                this.p[runTimeStep.step].ruleid = -13;
                this.p[runTimeStep.step].constraintid = this.o[runTimeStep.step].ruleid;
            }
            bl = true;
        }
        return bl;
    }

    boolean hasRule(OpRule opRule) {
        if (opRule.getController() == this) {
            return true;
        }
        int n = this._controllableVec.size();
        for (int i = 0; i < n; ++i) {
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(i);
            if (!(opControllable instanceof OpController) || !((OpController)(opControllable = (OpController)opControllable)).hasRule(opRule)) continue;
            return true;
        }
        return false;
    }

    void getCurChildLimits(OpController opController, OpValue opValue, OpValue opValue2, RunTimeStep runTimeStep) {
        if (opController == null || opValue == null || opValue2 == null) {
            return;
        }
        if (this._parentOpController != null) {
            this._parentOpController.getCurChildLimits(this, opValue, opValue2, runTimeStep);
            if (opValue.value >= this.p[runTimeStep.step].value) {
                opValue.init(this.p[runTimeStep.step]);
            }
            if (opValue2.value <= this.o[runTimeStep.step].value) {
                opValue2.init(this.o[runTimeStep.step]);
            }
        } else {
            opValue.init(this.p[runTimeStep.step]);
            opValue2.init(this.o[runTimeStep.step]);
        }
        int n = this._controllableVec.size();
        for (int i = 0; i < n; ++i) {
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(i);
            if (opControllable == null || !(opControllable instanceof OpController) || opControllable == opController) continue;
            opControllable = (OpController)opControllable;
            opValue.value -= ((OpController)opControllable).o[runTimeStep.step].value;
            if (opValue.value < 0.0) {
                opValue.value = 0.0;
            }
            opValue2.value -= ((OpController)opControllable).p[runTimeStep.step].value;
            if (!(opValue2.value < 0.0)) continue;
            opValue2.value = 0.0;
        }
    }

    OpValue distributeRelease(RunTimeStep runTimeStep, OpValue opValue) {
        Object object;
        Object object2;
        if (this.n[runTimeStep.step].ruleid == -10) {
            opValue.init(this.o[runTimeStep.step]);
        } else if (!(this.o[runTimeStep.step].value < 1.0E-10 && opValue.value < 1.0E-10 && opValue.value > -1.0E-10 || !(opValue.value <= this.o[runTimeStep.step].value))) {
            opValue.init(this.o[runTimeStep.step]);
        } else if (opValue.value >= this.p[runTimeStep.step].value) {
            opValue.value = this.p[runTimeStep.step].value;
            opValue.constraintid = this.p[runTimeStep.step].ruleid;
        }
        this.X.init(opValue);
        if (this._controllableVec.size() == 1) {
            if (this._controllableVec.elementAt(0) instanceof OpControllableElement) {
                object2 = (OpControllableElement)this._controllableVec.elementAt(0);
                this.X.value = ((OpControllableElement)object2).setParameterValue(this.X.value, runTimeStep);
            } else {
                object2 = (OpController)this._controllableVec.elementAt(0);
                this.X.init(((OpController)object2).distributeRelease(runTimeStep, this.X));
            }
        } else {
            object2 = this.b.getReleaseAllocationObject();
            object = object2.getActiveReleaseAllocationSet(runTimeStep);
            if ((object2 = object.getReleaseAllocation(this.getIndex())) != null && ((ReleaseAllocation)object2).getAllocationType() == 0) {
                this.X.init(this.sequentialRelease(runTimeStep, (ReleaseAllocationSet)((Object)object), this.X));
            } else if (object2 != null && ((ReleaseAllocation)object2).getAllocationType() == 2) {
                this.X.init(this.steppedRelease(runTimeStep, (ReleaseAllocationSet)((Object)object), this.X));
            } else {
                this.X.init(this.balanceRelease(runTimeStep, (ReleaseAllocationSet)((Object)object), this.X));
            }
        }
        if (Math.abs(opValue.value - this.X.value) > Math.max(Math.abs(opValue.value), 1.0) * 1.0E-10) {
            if (Boolean.getBoolean("RSDEBUGDIST")) {
                object2 = ((RssTSLocationObject)this).getSystem();
                object2.printWarningMessage("OpController.distributeRelease: distributed release not equal to assigned release");
                object = "Assigned release " + opValue.value + " " + this.a.getControllerRuleNameByID(opValue.ruleid) + ":" + this.a.getControllerConstraintNameByID(opValue.constraintid);
                object2.printWarningMessage((String)object);
                object = "Distributed release " + this.X.value + " " + this.a.getControllerRuleNameByID(this.X.ruleid) + ":" + this.a.getControllerConstraintNameByID(this.X.constraintid);
                object2.printWarningMessage((String)object);
                object2.printWarningMessage("OpController for " + this.getReleaseElement().getName() + " at " + runTimeStep.getHecTime().dateAndTime(4) + "\n");
            }
            opValue.value = this.X.value;
        }
        if (this.c != null) {
            this.c.setValue(opValue.value);
        }
        this.i[runTimeStep.step] = opValue.value;
        this.n[runTimeStep.step].init(opValue);
        return opValue;
    }

    OpValue balanceRelease(RunTimeStep runTimeStep, ReleaseAllocationSet object, OpValue opValue) {
        int n;
        int n2 = this._controllableVec.size();
        Arrays.fill(this.af, 1.0);
        Arrays.fill(this.ai, true);
        Map<intContainer, doubleContainer> map = this.am.get(object);
        for (n = 0; n < n2; ++n) {
            double d;
            object = (OpControllable)this._controllableVec.get(n);
            if (!(object instanceof OpController)) {
                this.ai[n] = false;
                continue;
            }
            object = (OpController)object;
            this.ag[n] = ((OpController)object).o[runTimeStep.step].value;
            this.ah[n] = ((OpController)object).p[runTimeStep.step].value;
            this.M.value = object.getIndex();
            try {
                object = map.get(this.M);
                d = object != null ? ((doubleContainer)object).value : 1.0;
            }
            catch (Exception exception) {
                d = 1.0;
            }
            this.af[n] = d;
        }
        RmaMath.balancedDistribution((double)opValue.value, (double[])this.ae, (double[])this.af, (double[])this.ag, (double[])this.ah, (double)1.0E-8, (boolean[])this.ai, (boolean[])this.ac, (boolean[])this.ad);
        double d = 0.0;
        for (n = 0; n < n2; ++n) {
            object = (OpControllable)this._controllableVec.elementAt(n);
            if (!(object instanceof OpController)) continue;
            object = (OpController)object;
            this.Y.init(opValue);
            this.Y.value = this.ae[n];
            ((OpController)object).distributeRelease(runTimeStep, this.Y);
            d += this.Y.value;
        }
        opValue.value = d;
        return opValue;
    }

    OpValue steppedRelease(RunTimeStep runTimeStep, ReleaseAllocationSet namedType, OpValue opValue) {
        Object object;
        int n;
        List<OpController> list = this.ak.get(namedType);
        if (list == null || list.size() < 2) {
            return this.balanceRelease(runTimeStep, (ReleaseAllocationSet)namedType, opValue);
        }
        boolean[] blArray = new boolean[list.size()];
        Arrays.fill(blArray, false);
        double d = 0.0;
        boolean bl = true;
        int n2 = 0;
        Map<intContainer, doubleContainer> map = this.am.get(namedType);
        int n3 = map.size();
        double d2 = 0.0;
        int n4 = this._controllableVec.size();
        for (n = 0; n < n4; ++n) {
            object = (OpControllable)this._controllableVec.get(n);
            if (!(object instanceof OpController) || !((OpController)(object = (OpController)object)).isUncontrolled()) continue;
            d2 += ((OpController)object).getCurrentParameterValue();
        }
        object = namedType.getReleaseAllocation(this.getIndex());
        namedType = this.N;
        if (namedType == null) {
            namedType = this.getElementOp().getOperationsElement().getStorageFunction();
        }
        while (n2++ < n3 && bl) {
            double d3;
            AdjustableFlow adjustableFlow;
            Arrays.fill(this.ab[this.ab.length - 1], 0.0);
            for (n4 = 0; n4 < list.size(); ++n4) {
                if (blArray[n4]) continue;
                IntToDoubleArrayContainer intToDoubleArrayContainer = (IntToDoubleArrayContainer)list.get(n4);
                OpController opController = (OpController)map.get(new intContainer(intToDoubleArrayContainer.intValue));
                n = 0;
                while (n < intToDoubleArrayContainer.doubleVector.size()) {
                    double d4 = 0.0;
                    if (((ReleaseAllocation)object).getReleaseUnits() == 0) {
                        d4 = intToDoubleArrayContainer.doubleVector.get(n) * opController.getAdjustableParameter().getMaxValue() / 100.0;
                    } else if (((ReleaseAllocation)object).getReleaseUnits() == 1) {
                        Object object2;
                        adjustableFlow = (AdjustableFlow)opController.getReleaseElement().getFunction();
                        double d5 = intToDoubleArrayContainer.doubleVector.get(n);
                        double d6 = namedType.getElevation(runTimeStep);
                        if (!adjustableFlow.hasMultipleGateSettings()) {
                            object2 = opController.toString();
                            throw new IllegalStateException("Trying to do simulation with % Gate Opening stepped release and outlet " + (String)object2 + " does not have a gate setting.");
                        }
                        if (adjustableFlow.getGateSettingsParamId() == Parameter.PARAMID_PERCENT) {
                            d4 = adjustableFlow.getFlowForGateHeight(d6, d5);
                        } else {
                            double[] dArray = adjustableFlow.getGateSettings();
                            object2 = dArray;
                            double d7 = dArray[((Object)object2).length - 1] * d5 / 100.0;
                            d4 = adjustableFlow.getFlowForGateHeight(d6, d7);
                        }
                    }
                    this.ab[n4][n] = d4;
                    double[] dArray = this.ab[this.ab.length - 1];
                    int n5 = n++;
                    dArray[n5] = dArray[n5] + d4;
                }
            }
            n4 = 0;
            int n6 = this.ab.length - 1;
            double d8 = opValue.value - d - d2;
            if (d3 >= this.ab[n6][0]) {
                n4 = Integer.MIN_VALUE;
            } else if (d8 < this.ab[n6][this.ab[n6].length - 1]) {
                n4 = Integer.MAX_VALUE;
            }
            bl = false;
            for (int i = 0; i < list.size(); ++i) {
                double d9;
                if (blArray[i]) continue;
                adjustableFlow = (IntToDoubleArrayContainer)list.get(i);
                OpController opController = (OpController)map.get(new intContainer(((IntToDoubleArrayContainer)adjustableFlow).intValue));
                if (n4 == Integer.MIN_VALUE) {
                    d9 = this.ab[i][0];
                } else if (n4 == Integer.MAX_VALUE) {
                    double d10 = this.ab[n6][this.ab[n6].length - 1];
                    double d11 = this.ab[i][this.ab[i].length - 1];
                    d9 = RmaMath.linearInterpolate((double)d10, (double)d11, (double)0.0, (double)0.0, (double)d8);
                } else {
                    int n7 = this.ab[i].length;
                    d9 = Interpolate.linearInterpolate((double[])this.ab[n6], (double[])this.ab[i], (double)d8, (int)n7);
                }
                this.Y.init(opValue);
                this.Y.value = d9;
                opController.distributeRelease(runTimeStep, this.Y);
                if (this.Y.value == d9) continue;
                bl = true;
                d += this.Y.value;
                blArray[i] = true;
            }
        }
        double d12 = 0.0;
        n3 = this._controllableVec.size();
        for (n4 = 0; n4 < n3; ++n4) {
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(n4);
            if (opControllable == null || !(opControllable instanceof OpController)) continue;
            object = (OpController)opControllable;
            if (((OpController)object).isUncontrolled()) {
                d12 += ((OpController)object).getCurrentParameterValue();
                continue;
            }
            if (((OpController)object).n == null || ((OpController)object).n[runTimeStep.step].value == Double.NEGATIVE_INFINITY) continue;
            d12 += ((OpController)object).n[runTimeStep.step].value;
        }
        opValue.value = d12;
        return opValue;
    }

    OpValue sequentialRelease(RunTimeStep runTimeStep, ReleaseAllocationSet object, OpValue opValue) {
        double d;
        OpController opController;
        int n;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = this._controllableVec.size();
        for (n = 0; n < n2; ++n) {
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(n);
            if (!(opControllable instanceof OpController)) continue;
            opController = (OpController)opControllable;
            d3 += opController.o[runTimeStep.step].value;
        }
        double d4 = opValue.value - d3;
        if (d < 0.0) {
            d4 = 0.0;
        }
        n2 = (object = this.al.get(object)) != null ? object.size() : 0;
        for (n = 0; n < n2; ++n) {
            double d5;
            opController = (OpController)object.get(n);
            if (opController == null) continue;
            this.Y.init(opValue);
            this.Y.value = d4 + opController.o[runTimeStep.step].value;
            opController.distributeRelease(runTimeStep, this.Y);
            d2 += this.Y.value;
            d4 -= this.Y.value - opController.o[runTimeStep.step].value;
            if (!(d5 < 0.0)) continue;
            d4 = 0.0;
        }
        n2 = this._controllableVec.size();
        for (n = 0; n < n2; ++n) {
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(n);
            if (!(opControllable instanceof OpController) || object.contains(opController = (OpController)opControllable)) continue;
            this.Y.init(opValue);
            this.Y.value = opController.o[runTimeStep.step].value;
            opController.distributeRelease(runTimeStep, this.Y);
            d2 += this.Y.value;
        }
        opValue.value = d2;
        return opValue;
    }

    double getOverride(RunTimeStep object) {
        double d = Double.NEGATIVE_INFINITY;
        if (this.P != null && (object = (Double)this.P.get(new Integer(object.valueMinutes()))) != null && (Double)object != Double.NEGATIVE_INFINITY) {
            d = (Double)object;
        }
        return d;
    }

    public int commitOperation(RunTimeStep runTimeStep, int n) {
        int n2 = 0;
        this.d[runTimeStep.step] = this.n[runTimeStep.step].value;
        this.e[runTimeStep.step] = this.n[runTimeStep.step].ruleid != Integer.MIN_VALUE ? (double)this.n[runTimeStep.step].ruleid : Double.NEGATIVE_INFINITY;
        this.R[runTimeStep.step] = this.n[runTimeStep.step].constraintid != Integer.MIN_VALUE ? (double)this.n[runTimeStep.step].constraintid : Double.NEGATIVE_INFINITY;
        int n3 = this._controllableVec.size();
        for (int i = 0; i < n3; ++i) {
            int n4;
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(i);
            if (opControllable instanceof OpController) {
                n4 = ((OpController)opControllable).commitOperation(runTimeStep, n);
            } else {
                if (!(opControllable instanceof OpControllableElement)) continue;
                n4 = ((OpControllableElement)opControllable).commitOperation(this.d[runTimeStep.step], runTimeStep, n);
            }
            if (n4 == 100) {
                n2 = 100;
            }
            if (n4 != 1) continue;
            this.a.printErrorMessage("OpController.commitOperation: Failed to commit operation " + this.getName());
            return 1;
        }
        return n2;
    }

    public void applyHindcastData(HindcastData hindcastData) {
    }

    @Override
    public synchronized Object clone() {
        Object object;
        OpControllable opControllable;
        OpController opController = (OpController)super.clone();
        ((OpController)super.clone()).a = this.a;
        opController._controllableVec = new Vector();
        for (int i = 0; i < this._controllableVec.size(); ++i) {
            opControllable = (OpControllable)this._controllableVec.elementAt(i);
            object = (OpControllable)opControllable.clone();
            object.setController(opController);
            opController._controllableVec.addElement(object);
        }
        Enumeration enumeration = this._ruleTable.keys();
        opController._ruleTable = new Hashtable();
        while (enumeration.hasMoreElements()) {
            opControllable = (intContainer)enumeration.nextElement();
            object = (OpRule)this._ruleTable.get(opControllable);
            object = (OpRule)((RssTSLocationObject)object).clone();
            ((OpRule)object).setController(opController);
            opController._ruleTable.put(opControllable, object);
        }
        opController._parentOpController = this._parentOpController;
        opController._nextRuleIndex = this._nextRuleIndex;
        opController._nextOpControllableIndex = this._nextOpControllableIndex;
        opController.M = this.M;
        opController.b = this.b;
        return opController;
    }

    public int getGmtOffset() {
        return this.getElementOp().getGmtOffset();
    }

    public int getUnitSystem() {
        return this.getElementOp().getUnitSystem();
    }

    @Override
    public void setController(OpController opController) {
        this._parentOpController = opController;
    }

    public void resetChildOwnership() {
        Object object;
        int n = this._controllableVec.size();
        for (int i = 0; i < n; ++i) {
            object = (OpControllable)this._controllableVec.get(i);
            if (object == null) continue;
            object.setController(this);
            if (!(object instanceof OpController)) continue;
            ((OpController)object).resetChildOwnership();
        }
        object = this._ruleTable.elements();
        while (object.hasMoreElements()) {
            OpRule opRule = (OpRule)object.nextElement();
            if (opRule == null) continue;
            opRule.setController(this);
            opRule.resetChildOwnership();
        }
        for (n = 0; n < this._tsrecordVector.size(); ++n) {
            object = (TSRecordProxy)this._tsrecordVector.elementAt(n);
            object.setParent((TSLocation)this);
        }
    }

    @Override
    public RssSystem getSystem() {
        Element element = this.getReleaseElement();
        if (element == null) {
            return null;
        }
        return element.getSystem();
    }

    public String getDisplayName() {
        String string;
        Element element = this.getReleaseElement();
        RssSystem rssSystem = element.getSystem();
        if (rssSystem.isKeyString(string = this.getName())) {
            return string;
        }
        return element.getTopParent().getDisplayName() + "-" + this.getName();
    }

    public String getKeyStringForObject(Object object) {
        return this.a.getOperationsElement().getSystem().getKeyStringForObject(object);
    }

    public Object getObjectForKeyString(String string) {
        return this.a.getOperationsElement().getSystem().getObjectForKeyString(string);
    }

    @Override
    public void clearTSProxyList() {
        this._tsrecordVector.clear();
        Object object = this._ruleTable.elements();
        while (object.hasMoreElements()) {
            OpRule opRule = (OpRule)object.nextElement();
            if (opRule == null) continue;
            opRule.clearTSProxyList();
        }
        int n = this._controllableVec.size();
        for (int i = 0; i < n; ++i) {
            object = (OpControllable)this._controllableVec.elementAt(i);
            if (!(object instanceof OpController)) continue;
            ((RssTSLocationObject)((OpController)object)).clearTSProxyList();
        }
    }

    @Override
    public void updateTSProxyList() {
        Object object = ((RssTSLocationObject)this).getTSRecordProxy(69);
        if (object == null) {
            this.addTSRecordProxy(69);
        }
        if ((object = ((RssTSLocationObject)this).getTSRecordProxy(74)) == null) {
            this.addTSRecordProxy(74);
        }
        if ((object = ((RssTSLocationObject)this).getTSRecordProxy(70)) == null) {
            this.addTSRecordProxy(70);
        }
        if ((object = ((RssTSLocationObject)this).getTSRecordProxy(71)) == null) {
            this.addTSRecordProxy(71);
        }
        if ((object = ((RssTSLocationObject)this).getTSRecordProxy(73)) == null) {
            this.addTSRecordProxy(73);
        }
        if ((object = ((RssTSLocationObject)this).getTSRecordProxy(72)) == null) {
            this.addTSRecordProxy(72);
        }
        if (this._parentOpController == null && (object = ((RssTSLocationObject)this).getTSRecordProxy(7)) == null) {
            this.addTSRecordProxy(7);
        }
        int n = this._controllableVec.size();
        for (int i = 0; i < n; ++i) {
            object = (OpControllable)this._controllableVec.elementAt(i);
            if (!(object instanceof OpController)) continue;
            ((RssTSLocationObject)((OpController)object)).updateTSProxyList();
        }
    }

    @Override
    public Vector getActiveTSRecordProxies(Vector vector, int n) {
        Object object;
        if (vector == null) {
            vector = new Vector<TSRecordProxy>();
        }
        if (this.b == null) {
            return vector;
        }
        if (n == 0) {
            object = ((RssTSLocationObject)this).getTSRecordProxy(69);
            if (object != null) {
                vector.addElement((TSRecordProxy)object);
            }
            if ((object = ((RssTSLocationObject)this).getTSRecordProxy(74)) != null) {
                vector.addElement((TSRecordProxy)object);
            }
            if ((object = ((RssTSLocationObject)this).getTSRecordProxy(70)) != null) {
                vector.addElement((TSRecordProxy)object);
            }
            if ((object = ((RssTSLocationObject)this).getTSRecordProxy(71)) != null) {
                vector.addElement((TSRecordProxy)object);
            }
            if ((object = ((RssTSLocationObject)this).getTSRecordProxy(73)) != null) {
                vector.addElement((TSRecordProxy)object);
            }
            if ((object = ((RssTSLocationObject)this).getTSRecordProxy(72)) != null) {
                vector.addElement((TSRecordProxy)object);
            }
            if (this._parentOpController == null && (object = ((RssTSLocationObject)this).getTSRecordProxy(7)) != null) {
                vector.addElement((TSRecordProxy)object);
            }
        }
        int n2 = this._controllableVec.size();
        for (int i = 0; i < n2; ++i) {
            object = (OpControllable)this._controllableVec.get(i);
            if (!(object instanceof OpController)) continue;
            ((RssTSLocationObject)((OpController)object)).getActiveTSRecordProxies(vector, n);
        }
        return vector;
    }

    public double[] getReleaseArray() {
        TSLocation tSLocation = this.getReleaseElement();
        if (tSLocation == null) {
            return null;
        }
        if ((tSLocation = tSLocation instanceof DivertedOutletElement ? ((DivertedOutletElement)tSLocation).getTailNode() : tSLocation.getDownstreamNode()) == null) {
            return null;
        }
        return tSLocation.getTSArray(0);
    }

    public doubleArrayContainer getReleaseTSContainer() {
        if (this._parentOpController != null || !(this.a instanceof ReservoirOp)) {
            TSLocation tSLocation = this.getReleaseElement();
            if (tSLocation == null) {
                return null;
            }
            if ((tSLocation = tSLocation instanceof DivertedOutletElement ? ((DivertedOutletElement)tSLocation).getTailNode() : tSLocation.getDownstreamNode()) == null) {
                return null;
            }
            return tSLocation.getTSContainer(0);
        }
        return this.a.getOperationsElement().getStorageFunction().getTSContainer(21);
    }

    @Override
    public double getCurrentParameterValue() {
        double d = 0.0;
        int n = this._controllableVec.size();
        for (int i = 0; i < n; ++i) {
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(i);
            if (opControllable == null) continue;
            d += opControllable.getCurrentParameterValue();
        }
        if (this.c != null) {
            this.c.setCurrentValue(d);
        }
        return d;
    }

    @Override
    public double getPreviousParameterValue(RunTimeStep runTimeStep) {
        double d = 0.0;
        int n = this._controllableVec.size();
        for (int i = 0; i < n; ++i) {
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(i);
            if (opControllable == null) continue;
            d += opControllable.getPreviousParameterValue(runTimeStep);
        }
        return d;
    }

    public int computeZoneOperationStep(RunTimeStep object, StorageZone object2, double d) {
        this.h[object.step] = -4;
        object2 = new OpValue(1, d, Float.MAX_VALUE);
        new OpValue(1, d, Float.MAX_VALUE).ruleid = this.h[object.step];
        try {
            object = this.distributeRelease((RunTimeStep)object, (OpValue)object2);
        }
        catch (Exception exception) {
            this.a.printErrorMessage(exception.getMessage());
            return 1;
        }
        if (object == null || object.value == Double.NEGATIVE_INFINITY) {
            this.a.printErrorMessage("OpController.computeZoneOperationStep: Failed to apply zone operation");
            return 1;
        }
        return 0;
    }

    public int computeGCOperationStep(RunTimeStep object, List object2) {
        double d = 0.0;
        StorageZone storageZone = this.b.getGuideCurveZone();
        if (storageZone == null) {
            storageZone = this.b.getInactiveZone();
        }
        double d2 = this.getFlowObjectiveToZoneElev(storageZone, this.c, (RunTimeStep)object, (List)object2, null, Double.NEGATIVE_INFINITY);
        this.h[object.step] = -1;
        if (d2 != Double.NEGATIVE_INFINITY) {
            if (d2 < 1.0E-10) {
                d2 = 0.0;
                this.h[object.step] = -5;
            }
            object2 = new OpValue(1, d2, Float.MAX_VALUE);
            new OpValue(1, d2, Float.MAX_VALUE).ruleid = this.h[object.step];
            try {
                object = this.distributeRelease((RunTimeStep)object, (OpValue)object2);
            }
            catch (Exception exception) {
                this.a.printErrorMessage(exception.getMessage());
                return 1;
            }
            if (object == null || object.value == Double.NEGATIVE_INFINITY) {
                this.a.printErrorMessage("OpController.computeGCOperationStep: Failed to apply guide curve operation");
                return 1;
            }
        }
        return 0;
    }

    public void setElementOp(ElementOp object) {
        Object object2;
        this.a = object;
        int n = this._controllableVec.size();
        for (int i = 0; i < n; ++i) {
            object2 = (OpControllable)this._controllableVec.get(i);
            if (object2 == null) continue;
            object2.setController(this);
            if (!(object2 instanceof OpController)) continue;
            ((OpController)object2).setElementOp((ElementOp)object);
        }
        object2 = this._ruleTable.elements();
        while (object2.hasMoreElements()) {
            object = (OpRule)object2.nextElement();
            if (object == null) continue;
            ((OpRule)object).setController(this);
        }
    }

    @Override
    public int getReleaseElementId() {
        return this._releaseElemId;
    }

    @Override
    public void setReleaseElementId(int n) {
        this._releaseElemId = n;
        this.L = null;
    }

    public Element getReleaseElement() {
        if (this.L == null && this._releaseElemId != Integer.MIN_VALUE) {
            this.L = this.a.getOperationsElement().getSystem().getElement(this._releaseElemId);
        }
        return this.L;
    }

    @Override
    public void setReleaseElement(Element element) {
        this.L = element;
        this._releaseElemId = element.getIndex();
    }

    public void updateControllerTree(Element element) {
        int n;
        OpControllable opControllable;
        int n2;
        int n3;
        this.L = element;
        RssSystem rssSystem = element.getSystem();
        this.setName(rssSystem.getKeyStringForObject(element));
        Vector<OpControllable> vector = new Vector<OpControllable>();
        Vector vector2 = element.getElementVector();
        int n4 = vector2.size();
        if (n4 == 0 && element.getFunction() instanceof ControlStructure) {
            int n5 = element.getIndex();
            n3 = this._controllableVec.size();
            for (n2 = 0; n2 < n3; ++n2) {
                opControllable = (OpControllable)this._controllableVec.elementAt(n2);
                if (opControllable.getReleaseElementId() != n5) continue;
                this._controllableVec.removeElement(opControllable);
                vector.addElement(opControllable);
                opControllable.setReleaseElement(element);
                break;
            }
        }
        for (n = 0; n < n4; ++n) {
            Element element2 = (Element)vector2.elementAt(n);
            n3 = 0;
            n2 = element2.getIndex();
            int n6 = this._controllableVec.size();
            for (int i = 0; i < n6; ++i) {
                opControllable = (OpControllable)this._controllableVec.elementAt(i);
                if (opControllable.getReleaseElementId() != n2) continue;
                this._controllableVec.removeElement(opControllable);
                vector.addElement(opControllable);
                if (opControllable instanceof OpController) {
                    ((OpController)opControllable)._parentOpController = this;
                    ((OpController)opControllable).updateControllerTree(element2);
                } else {
                    opControllable.setReleaseElement(element2);
                }
                n3 = 1;
                break;
            }
            if (n3 != 0) continue;
            if (element2 instanceof ReservoirDamElement || element2 instanceof DivertedOutletElement || element2 instanceof OutletGroupElement) {
                opControllable = this.a.newController();
                this.a.newController()._parentOpController = this;
                opControllable.setName(rssSystem.getKeyStringForObject(element2));
                ((OpController)opControllable).setElementOp(this.a);
                ((OpController)opControllable).setReleaseElement(element2);
                ((OpController)opControllable).updateControllerTree(element2);
                vector.add(opControllable);
                continue;
            }
            if (element2.getFunction() == null || !(element2.getFunction() instanceof ControlStructure)) continue;
            opControllable = this.a.newController();
            this.a.newController()._parentOpController = this;
            opControllable.setName(rssSystem.getKeyStringForObject(element2));
            ((OpController)opControllable).setElementOp(this.a);
            ((OpController)opControllable).setReleaseElement(element2);
            vector.add(opControllable);
            ((OpController)opControllable).addControllable(element2);
        }
        n4 = vector.size();
        for (n = n4 - 1; n >= 0; --n) {
            opControllable = (OpControllable)vector.elementAt(n);
            if (!(opControllable instanceof OpController)) continue;
            opControllable = (OpController)opControllable;
            if (((OpController)opControllable)._controllableVec.size() != 0) continue;
            vector.remove(opControllable);
            this.a.deleteControllerReferences(opControllable.getIndex());
        }
        n4 = this._controllableVec.size();
        for (n = 0; n < n4; ++n) {
            opControllable = (OpControllable)this._controllableVec.elementAt(n);
            if (!(opControllable instanceof OpController)) continue;
            opControllable = (OpController)opControllable;
            this.a.deleteControllerReferences(opControllable.getIndex());
        }
        this._controllableVec = vector;
    }

    public ElementOp getElementOp() {
        if (this.a == null && this._parentOpController != null) {
            this.a = this._parentOpController.getElementOp();
        }
        return this.a;
    }

    public ReservoirOp getReservoirOp() {
        ElementOp elementOp = this.getElementOp();
        if (elementOp instanceof ReservoirOp) {
            return (ReservoirOp)elementOp;
        }
        return null;
    }

    @Override
    public boolean initializeCompute(RunTimeWindow object) {
        ReleaseOverrides releaseOverrides;
        Object object2;
        Object object3;
        if (this.getElementOp() == null) {
            return false;
        }
        Object object4 = this.a.getOperationsElement();
        this.N = object4.getStorageFunction();
        this.O = Double.NEGATIVE_INFINITY;
        this.W = -1;
        int n = this._controllableVec.size();
        int n2 = object.getNumSteps();
        this.X = new OpValue();
        this.Y = new OpValue();
        this.Z = new OpValue();
        this.aa = new OpValue();
        if (n > 0) {
            this.ac = new boolean[n];
            this.ad = new boolean[n];
            this.ae = new double[n];
            this.af = new double[n];
            this.ag = new double[n];
            this.ah = new double[n];
            this.ai = new boolean[n];
        }
        this.h = new int[n2 + 1];
        this.n = new OpValue[n2 + 1];
        this.o = new OpValue[n2 + 1];
        this.p = new OpValue[n2 + 1];
        this.q = new OpValue[n2 + 1];
        this.r = new OpValue[n2 + 1];
        this.i = new double[n2 + 1];
        this.j = new double[n2 + 1];
        this.k = new double[n2 + 1];
        this.l = new int[n2 + 1];
        this.m = new int[n2 + 1];
        for (n = 0; n <= n2; ++n) {
            this.n[n] = new OpValue();
            this.o[n] = new OpValue();
            this.p[n] = new OpValue();
            this.q[n] = new OpValue();
            this.r[n] = new OpValue();
        }
        this.s = new int[7];
        this.t = new double[7];
        this.u = new double[7];
        this.v = new double[7];
        this.w = new int[7];
        this.x = new int[7];
        this.y = new OpValue[7];
        this.z = new OpValue[7];
        this.A = new OpValue[7];
        this.B = new OpValue[7];
        this.C = new OpValue[7];
        for (n = 0; n < 7; ++n) {
            this.y[n] = new OpValue();
            this.z[n] = new OpValue();
            this.A[n] = new OpValue();
            this.B[n] = new OpValue();
            this.C[n] = new OpValue();
        }
        for (n = 0; n < this._tsrecordVector.size(); ++n) {
            TSRecordProxy tSRecordProxy = (TSRecordProxy)this._tsrecordVector.elementAt(n);
            if (tSRecordProxy == null) continue;
            tSRecordProxy.initialize();
        }
        this.g = this.getTSContainer(69);
        this.f = this.getTSContainer(74);
        this.d = this.getTSArray(70);
        this.e = this.getTSArray(71);
        this.R = this.getTSArray(73);
        this.S = this.getTSArray(72);
        if (this.d == null || this.e == null || this.S == null) {
            object4.getSystem().printErrorMessage("OpController.initializeCompute: Failed to load time series arrays");
            return false;
        }
        if (this._parentOpController == null) {
            this.T = this.getTSArray(7);
            if (this.T == null) {
                object4.getSystem().printErrorMessage("OpController.initializeCompute: Failed to load time series arrays");
                return false;
            }
        }
        this.P = null;
        this.Q = null;
        Serializable serializable = object4.getSystem().getRssRun().getReleaseOverrides();
        if (serializable != null) {
            Element element = this.getReleaseElement();
            if (element instanceof ReservoirElement) {
                object3 = ((ReservoirElement)element).getStorageFunction();
                if (object3 != null && ((RssTSLocationObject)object3).getTSRecordProxy(21) != null && (object2 = ((RssTSLocationObject)object3).getTSRecordProxy(21)) != null) {
                    this.P = ((ReleaseOverrides)serializable).getReleaseValues(object2.getName());
                }
            } else {
                object3 = element.getDownstreamNode();
                if (object3 != null && ((RssNode)object3).getTSRecordProxy(0) != null && (object2 = ((RssNode)object3).getTSRecordProxy(0)) != null) {
                    this.P = ((ReleaseOverrides)serializable).getReleaseValues(object2.getName());
                }
            }
        }
        if (this._parentOpController == null && (releaseOverrides = object4.getSystem().getRssRun().getElevationOverrides()) != null && (object3 = this.getElementOp().getOperationsElement()) != null && (object2 = object3.getStorageFunction()) != null && (object4 = ((RssTSLocationObject)object2).getTSRecordProxy(10)) != null) {
            this.Q = releaseOverrides.getReleaseValues(object4.getName());
        }
        this.V = new Vector();
        this.b.getControllerRules(this.getIndex(), this.V);
        for (n2 = 0; n2 < this.V.size(); ++n2) {
            object3 = (OpRule)this.V.elementAt(n2);
            if (((OpRule)object3).initializeCompute()) continue;
            return false;
        }
        this.c = new AdjustableParameter();
        for (int i = 0; i < this._controllableVec.size(); ++i) {
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(i);
            if (!opControllable.initializeCompute((RunTimeWindow)object)) {
                return false;
            }
            object3 = opControllable.getAdjustableParameter();
            this.c.sumConstraints((AdjustableParameter)object3);
        }
        this.am = new HashMap<ReleaseAllocationSet, Map<intContainer, doubleContainer>>();
        ReleaseAllocationObject releaseAllocationObject = this.b.getReleaseAllocationObject();
        releaseAllocationObject.initializeCompute((RunTimeWindow)object);
        object4 = releaseAllocationObject.getAllReleaseAllocationSets();
        this.al = new HashMap<ReleaseAllocationSet, List>();
        this.ak = new HashMap<ReleaseAllocationSet, List<OpController>>();
        object = object4.iterator();
        while (object.hasNext()) {
            int n3;
            Object object5;
            object4 = (ReleaseAllocationSet)((Object)object.next());
            serializable = new Hashtable();
            this.am.put((ReleaseAllocationSet)((Object)object4), (Map<intContainer, doubleContainer>)((Object)serializable));
            Object object6 = ((ReleaseAllocationSet)((Object)object4)).getReleaseAllocation(this.getIndex());
            Object object7 = object3 = object6 != null ? ((ReleaseAllocation)object6).getAllocationList() : null;
            if (object6 == null) continue;
            if (((ReleaseAllocation)object6).getAllocationType() == 1) {
                for (int i = 0; i < object3.size(); ++i) {
                    object5 = (IntToDoubleContainer)object3.get(i);
                    serializable.put(new intContainer(((IntToDoubleContainer)object5).intValue), new doubleContainer(((IntToDoubleContainer)object5).doubleValue));
                }
                continue;
            }
            if (((ReleaseAllocation)object6).getAllocationType() == 0) {
                int n4;
                object5 = new ArrayList();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                this.al.put((ReleaseAllocationSet)((Object)object4), arrayList);
                for (n4 = 0; n4 < object3.size(); ++n4) {
                    intContainer intContainer2 = (intContainer)object3.get(n4);
                    for (int i = 0; i < this._controllableVec.size(); ++i) {
                        object6 = (OpControllable)this._controllableVec.elementAt(i);
                        if (object6 == null || !(object6 instanceof OpController) || ((OpController)object6).isUncontrolled() || ((OpController)object6).getIndex() != intContainer2.value) continue;
                        arrayList.add(object6);
                    }
                }
                for (n4 = 0; n4 < this._controllableVec.size(); ++n4) {
                    object6 = (OpControllable)this._controllableVec.elementAt(n4);
                    if (object6 == null || !(object6 instanceof OpController) || ((OpController)object6).isUncontrolled()) continue;
                    boolean bl = false;
                    for (int i = 0; i < object3.size(); ++i) {
                        intContainer intContainer3 = (intContainer)object3.get(i);
                        if (((OpController)object6).getIndex() != intContainer3.value) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    object5.add(object6);
                }
                for (n4 = 0; n4 < object5.size(); ++n4) {
                    arrayList.add(object5.get(n4));
                }
                continue;
            }
            if (((ReleaseAllocation)object6).getAllocationType() != 2) continue;
            int n5 = object3.size();
            object5 = new ArrayList();
            this.ak.put((ReleaseAllocationSet)((Object)object4), (List<OpController>)object5);
            int n6 = 0;
            for (n3 = 0; n3 < this._controllableVec.size(); ++n3) {
                object6 = (OpControllable)this._controllableVec.elementAt(n3);
                if (object6 == null || !(object6 instanceof OpController) || ((OpController)object6).isUncontrolled()) continue;
                boolean bl = false;
                for (int i = 0; i < n5; ++i) {
                    IntToDoubleArrayContainer intToDoubleArrayContainer = (IntToDoubleArrayContainer)object3.get(i);
                    if (((OpController)object6).getIndex() != intToDoubleArrayContainer.intValue) continue;
                    if (intToDoubleArrayContainer.doubleVector != null && intToDoubleArrayContainer.doubleVector.size() > n6) {
                        n6 = intToDoubleArrayContainer.doubleVector.size();
                    }
                    ((ArrayList)object5).add(intToDoubleArrayContainer);
                    serializable.put(new intContainer(intToDoubleArrayContainer.intValue), object6);
                    bl = true;
                }
                if (bl) continue;
                serializable.put(new intContainer(((OpController)object6).getIndex()), object6);
                IntToDoubleArrayContainer intToDoubleArrayContainer = new IntToDoubleArrayContainer(((OpController)object6).getIndex());
                new IntToDoubleArrayContainer(((OpController)object6).getIndex()).doubleVector = new DoubleVector();
                intToDoubleArrayContainer.doubleVector.add(0.0);
                if (n6 <= 0) {
                    n6 = 1;
                }
                ((ArrayList)object5).add(intToDoubleArrayContainer);
            }
            this.ab = new double[((ArrayList)object5).size() + 1][n6];
            for (n3 = 0; n3 < ((ArrayList)object5).size() + 1; ++n3) {
                Arrays.fill(this.ab[n3], 0.0);
            }
        }
        object = ((RssTSLocationObject)this).getSystem().getComputeOptions();
        this.D = ((RssComputeOptions)object).getConsiderROC();
        this.E = ((RssComputeOptions)object).getUseLookAhead();
        this.F = ((RssComputeOptions)object).getIterateNonConstantROC();
        this.G = ((RssComputeOptions)object).getMinLookAheadDays();
        this.H = ((RssComputeOptions)object).getMaxLookAheadDays();
        this.I = ((RssComputeOptions)object).getMaxIterNonConstROC();
        this.J = ((RssComputeOptions)object).getFlowTol();
        this.K = ((RssComputeOptions)object).getStorTol();
        this.getPowerPlantList(true);
        return true;
    }

    @Override
    public boolean initForPostProcessing(RunTimeWindow runTimeWindow) {
        NamedType namedType;
        if (this.getElementOp() == null) {
            return false;
        }
        OperationsElement operationsElement = this.a.getOperationsElement();
        this.N = operationsElement.getStorageFunction();
        this.O = Double.NEGATIVE_INFINITY;
        this.W = -1;
        this._controllableVec.size();
        this.P = null;
        this.Q = null;
        this.V = new Vector();
        this.b.getControllerRules(this.getIndex(), this.V);
        for (int i = 0; i < this.V.size(); ++i) {
            namedType = (OpRule)this.V.elementAt(i);
            if (namedType.initForPostProcessing()) continue;
            return false;
        }
        this.c = new AdjustableParameter();
        for (int i = 0; i < this._controllableVec.size(); ++i) {
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(i);
            if (!opControllable.initForPostProcessing(runTimeWindow)) {
                return false;
            }
            namedType = opControllable.getAdjustableParameter();
            this.c.sumConstraints((AdjustableParameter)namedType);
        }
        RssComputeOptions rssComputeOptions = ((RssTSLocationObject)this).getSystem().getComputeOptions();
        this.D = rssComputeOptions.getConsiderROC();
        this.E = rssComputeOptions.getUseLookAhead();
        this.F = rssComputeOptions.getIterateNonConstantROC();
        this.G = rssComputeOptions.getMinLookAheadDays();
        this.H = rssComputeOptions.getMaxLookAheadDays();
        this.I = rssComputeOptions.getMaxIterNonConstROC();
        this.J = rssComputeOptions.getFlowTol();
        this.K = rssComputeOptions.getStorTol();
        return true;
    }

    @Override
    public AdjustableParameter getAdjustableParameter() {
        return this.c;
    }

    public void setActiveOperations(OpSet opSet) {
        this.b = opSet;
        int n = this._controllableVec.size();
        for (int i = 0; i < n; ++i) {
            OpControllable opControllable = (OpControllable)this._controllableVec.get(i);
            if (!(opControllable instanceof OpController)) continue;
            ((OpController)opControllable).setActiveOperations(opSet);
        }
    }

    public void addControllable(Element element) {
        if (element == null) {
            return;
        }
        int n = element.getIndex();
        int n2 = this._controllableVec.size();
        for (int i = 0; i < n2; ++i) {
            OpControllable opControllable = (OpControllable)this._controllableVec.get(i);
            if (!(opControllable instanceof OpControllableElement) || ((OpControllableElement)opControllable).getElementIndex() != n) continue;
            return;
        }
        OpControllableElement opControllableElement = new OpControllableElement(this, element);
        opControllableElement.setIndex(this.nextOpControllableIndex());
        this._controllableVec.addElement(opControllableElement);
    }

    private int nextOpControllableIndex() {
        ++this._nextOpControllableIndex;
        return this._nextOpControllableIndex - 1;
    }

    private int nextRuleIndex() {
        ++this._nextRuleIndex;
        return this._nextRuleIndex - 1;
    }

    public OpRule newRule(String object, String string, int n) {
        if ((object = OpRuleFactory.newRule((String)object, string, n)) == null) {
            return null;
        }
        ((OpRule)object).setController(this);
        int n2 = this.nextRuleIndex();
        object.setIndex(n2);
        this._ruleTable.put(new intContainer(n2), object);
        return object;
    }

    public OpRule getRule(int n) {
        if (this.M == null) {
            this.M = new intContainer();
        }
        this.M.value = n;
        OpRule opRule = (OpRule)this._ruleTable.get(this.M);
        if (opRule != null) {
            opRule.setController(this);
        }
        return opRule;
    }

    public Vector getRules(Vector vector) {
        if (vector == null) {
            vector = new Vector();
        }
        Enumeration enumeration = this._ruleTable.elements();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    public String[] getRuleNames() {
        String[] stringArray = new String[this._ruleTable.size()];
        int n = 0;
        Enumeration enumeration = this._ruleTable.elements();
        while (enumeration.hasMoreElements()) {
            OpRule opRule = (OpRule)enumeration.nextElement();
            stringArray[n] = opRule.getName();
            ++n;
        }
        return stringArray;
    }

    public OpRule getRule(String string) {
        Enumeration enumeration = this._ruleTable.elements();
        while (enumeration.hasMoreElements()) {
            OpRule opRule = (OpRule)enumeration.nextElement();
            if (!opRule.getName().equals(string)) continue;
            opRule.setController(this);
            return opRule;
        }
        return null;
    }

    public void deleteRule(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        Enumeration enumeration = this._ruleTable.elements();
        while (enumeration.hasMoreElements()) {
            OpRule opRule = (OpRule)enumeration.nextElement();
            if (!opRule.getName().equals(string)) continue;
            this._ruleTable.remove(new intContainer(opRule.getIndex()));
            return;
        }
    }

    public void deleteRule(int n) {
        this._ruleTable.remove(new intContainer(n));
    }

    public String toString() {
        return this.a.getOperationsElement().getSystem().getNameForKeyString(this.getName());
    }

    public void getChildControllers(Vector vector) {
        this.getChildControllers(vector, true);
    }

    public void getChildControllers(Vector vector, boolean bl) {
        if (vector == null) {
            return;
        }
        int n = this._controllableVec.size();
        for (int i = 0; i < n; ++i) {
            Object e = this._controllableVec.get(i);
            if (!(e instanceof OpController)) continue;
            vector.add(e);
            if (!bl) continue;
            ((OpController)e).getChildControllers(vector);
        }
    }

    double getTargetStor(RunTimeStep runTimeStep, RunTimeStep runTimeStep2, int n, StorageZone storageZone, double d, Hashtable hashtable, int n2) {
        if (storageZone == null) {
            if (d != Double.NEGATIVE_INFINITY) {
                return d;
            }
            return this.N.getMinStorage();
        }
        runTimeStep2.step = runTimeStep.step + n2;
        if (runTimeStep2.step < 0) {
            runTimeStep2.step = 0;
        } else if (runTimeStep2.step > n) {
            runTimeStep2.step = n;
        }
        double d2 = storageZone.getElevation(runTimeStep2, hashtable);
        return this.N.elevationToStorage(d2);
    }

    boolean hasROCLimit(AdjustableParameter namedType, List list, int n) {
        double d;
        if (n == 1 ? RMAConst.isValidValue((double)(d = namedType.getMaxRateOfIncrease())) : RMAConst.isValidValue((double)(d = namedType.getMaxRateOfDecrease()))) {
            return true;
        }
        if (list != null) {
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                namedType = (OpRule)list.get(i);
                if (!(namedType instanceof RateChangeLimitOpRule) || ((RateChangeLimitOpRule)namedType).getType() != n) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasNonConstROCLimit(AdjustableParameter namedType, List list, int n) {
        if (list != null) {
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                namedType = (OpRule)list.get(i);
                if (!(namedType instanceof RateChangeLimitOpRule) || ((RateChangeLimitOpRule)namedType).getType() != n || ((RateChangeLimitOpRule)namedType).getFunctionType() == 0) continue;
                return true;
            }
        }
        return false;
    }

    double getROCLimit(AdjustableParameter namedType, List list, int n, double d, double d2, double d3) {
        double d4 = n == 1 ? namedType.getMaxRateOfIncrease() : namedType.getMaxRateOfDecrease();
        if (d4 == Double.NEGATIVE_INFINITY) {
            d4 = Double.MAX_VALUE;
        }
        if (list != null) {
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                double d5;
                namedType = (OpRule)list.get(i);
                if (!(namedType instanceof RateChangeLimitOpRule) || ((RateChangeLimitOpRule)namedType).getType() != n || (d5 = ((RateChangeLimitOpRule)namedType).getRateOfChangeLimit(d, d2, d3)) == Double.NEGATIVE_INFINITY || !(d5 < d4)) continue;
                d4 = d5;
            }
        }
        return d4 / 3600.0;
    }

    double getFlowObjectiveToZoneElev(StorageZone storageZone, AdjustableParameter adjustableParameter, RunTimeStep runTimeStep, List list, Hashtable hashtable, double d) {
        int n;
        if (this._parentOpController != null) {
            return this._parentOpController.getFlowObjectiveToZoneElev(storageZone, adjustableParameter, runTimeStep, list, hashtable, d);
        }
        if (this.N == null) {
            return Double.NEGATIVE_INFINITY;
        }
        boolean bl = this.D;
        boolean bl2 = false;
        if (runTimeStep.isPerAvgTimeStep()) {
            bl2 = true;
        }
        double d2 = runTimeStep.getTimeStepSeconds();
        int n2 = (int)(this.G * 86400.0 / d2);
        int n3 = (int)(this.H * 86400.0 / d2);
        RunTimeStep runTimeStep2 = new RunTimeStep(runTimeStep);
        int n4 = runTimeStep.getTotalNumSteps();
        int n5 = runTimeStep.getPrevStep();
        runTimeStep2.step = n5 + 1;
        int n6 = n = this.b.getNumDecisionSteps(runTimeStep2);
        double d3 = adjustableParameter.getMinValue();
        double d4 = adjustableParameter.getMaxValue();
        boolean bl3 = this.hasROCLimit(adjustableParameter, list, 1);
        boolean bl4 = this.hasROCLimit(adjustableParameter, list, 0);
        boolean bl5 = false;
        if (bl4) {
            bl5 = this.hasNonConstROCLimit(adjustableParameter, list, 0);
        }
        double d5 = this.N.getPreviousStorage(runTimeStep);
        double d6 = this.N.getPreviousElevation(runTimeStep);
        double d7 = this.getPreviousParameterValue(runTimeStep);
        double d8 = this.N.getPreviousNetInflow(runTimeStep);
        double d9 = this.getROCLimit(adjustableParameter, list, 1, d7, d8, d6);
        double d10 = this.getROCLimit(adjustableParameter, list, 0, d7, d8, d6);
        if (Math.abs(d9) < this.J && Math.abs(d10) < this.J || !bl4 && !bl3) {
            bl = false;
        }
        d9 *= d2;
        d10 *= d2;
        double d11 = d8;
        double d12 = d8;
        double d13 = 0.0;
        double d14 = d8;
        double d15 = 0.0;
        for (int i = 1; i <= n; ++i) {
            runTimeStep2.step = n5 + i;
            if (runTimeStep2.step > n4) {
                runTimeStep2.step = n4;
            }
            d11 = this.N.getNetInflow(runTimeStep2);
            d15 += d11;
            d13 = bl2 ? (d13 += d11 * d2 / Storage.DSDT_TO_Q) : (d13 += 0.5 * (d11 + d14) * d2 / Storage.DSDT_TO_Q);
            d14 = d11;
        }
        double cfr_ignored_0 = d15 / (double)n;
        double d16 = this.getTargetStor(runTimeStep, runTimeStep2, n4, storageZone, d, hashtable, n6 - 1);
        runTimeStep2.step = (n5 += n) + 1;
        int n7 = this.b.getNumDecisionSteps(runTimeStep2);
        double d17 = 0.0;
        double d18 = 0.0;
        double d19 = 0.0;
        d14 = d11;
        for (int i = 1; i <= n7; ++i) {
            runTimeStep2.step = n5 + i;
            if (runTimeStep2.step > n4) {
                runTimeStep2.step = n4;
            }
            d12 = this.N.getNetInflow(runTimeStep2);
            d18 += d12;
            d17 = bl2 ? (d17 += d12 * d2 / Storage.DSDT_TO_Q) : (d17 += 0.5 * (d12 + d14) * d2 / Storage.DSDT_TO_Q);
            d14 = d12;
            if (i != 1) continue;
            d19 = d17;
        }
        double d20 = this.getTargetStor(runTimeStep, runTimeStep2, n4, storageZone, d, hashtable, n6 - 1 + n7);
        double d21 = this.getTargetStor(runTimeStep, runTimeStep2, n4, storageZone, d, hashtable, n6);
        double d22 = bl2 ? (d5 + d13 - d16) * Storage.DSDT_TO_Q / (d2 * (double)n) : ((d5 + d13 + d19 - d21) * Storage.DSDT_TO_Q / d2 - 0.5 * (d7 + (d18 /= (double)n7))) / (double)n;
        double d23 = d22;
        boolean bl6 = false;
        boolean bl7 = false;
        if (bl) {
            if (d23 > d7 + d9) {
                d23 = d7 + d9;
            } else if (d23 < d7 - d10) {
                d23 = d7 - d10;
                bl6 = true;
            }
        }
        if (d23 > d4) {
            d23 = d4;
        } else if (d23 < d3) {
            d23 = d3;
            bl7 = true;
        }
        double d24 = d23;
        if (!bl) {
            return d24;
        }
        int n8 = n3;
        if (bl4 && !bl6 && !bl7) {
            boolean bl8 = true;
            for (int i = 0; bl8 && i < this.I; ++i) {
                double d25;
                int n9;
                double d26 = d5;
                double d27 = d7;
                double d28 = d24;
                double d29 = d11;
                double d30 = d13;
                double d31 = d16;
                n5 = runTimeStep.getPrevStep();
                n6 = n9 = n;
                double d32 = bl2 ? d26 + d30 - d28 * (d2 * (double)n9) / Storage.DSDT_TO_Q : d26 + d30 - (d28 * ((double)n9 - 0.5) + d27 * 0.5) * d2 / Storage.DSDT_TO_Q;
                runTimeStep2.step = (n5 += n9) + 1;
                n7 = this.b.getNumDecisionSteps(runTimeStep2);
                double d33 = d17;
                double d34 = d12;
                double d35 = d20;
                double d36 = (d35 - d31) / (d2 * (double)n7) * Storage.DSDT_TO_Q;
                double d37 = d24;
                boolean bl9 = false;
                for (int j = 0; j < n8; ++j) {
                    double d38;
                    n9 = n7;
                    n6 += n9;
                    runTimeStep2.step = (n5 += n9) + 1;
                    n7 = this.b.getNumDecisionSteps(runTimeStep2);
                    double d39 = d29;
                    d29 = d34;
                    d26 = d32;
                    double d40 = this.N.storageToElevation(d26);
                    d27 = d28;
                    d31 = d35;
                    double d41 = d36;
                    d30 = d33;
                    this.getROCLimit(adjustableParameter, list, 1, d27, d39, d40);
                    d10 = this.getROCLimit(adjustableParameter, list, 0, d27, d39, d40);
                    d10 *= d2;
                    d33 = 0.0;
                    d14 = d29;
                    for (int k = 1; k <= n7; ++k) {
                        runTimeStep2.step = n5 + k;
                        if (runTimeStep2.step > n4) {
                            runTimeStep2.step = n4;
                        }
                        d34 = this.N.getNetInflow(runTimeStep2);
                        d33 = bl2 ? (d33 += d34 * d2 / Storage.DSDT_TO_Q) : (d33 += 0.5 * (d34 + d14) * d2 / Storage.DSDT_TO_Q);
                        d14 = d34;
                    }
                    d35 = this.getTargetStor(runTimeStep, runTimeStep2, n4, storageZone, d, hashtable, n6 - 1 + n7);
                    d28 = d27 - d10;
                    if (d38 < d3) {
                        d28 = d3;
                    }
                    if (d28 < d29 - d41 && j >= n2) break;
                    d32 = bl2 ? d26 + d30 - d28 * (d2 * (double)n9) / Storage.DSDT_TO_Q : d26 + d30 - (d28 * ((double)n9 - 0.5) + d27 * 0.5) * d2 / Storage.DSDT_TO_Q;
                    d36 = (d35 - d31) / (d2 * (double)n7) * Storage.DSDT_TO_Q;
                    if (d32 <= d31 + this.K) {
                        double d42 = (d32 - d31) / (d2 * (double)n6) * Storage.DSDT_TO_Q;
                        if (d28 + d42 - d10 <= d34 - d36) {
                            if (d37 > d24 + d42 && !bl9) {
                                d37 = d24 + d42;
                                bl9 = true;
                            }
                            if (!bl9 || j < n2) continue;
                            break;
                        }
                        bl9 = false;
                        continue;
                    }
                    bl9 = false;
                }
                if (!bl5 || !this.F) {
                    bl8 = false;
                } else if (Math.abs(d24 - d37) < this.J) {
                    bl8 = false;
                }
                d24 = d37;
                if (d25 > d4) {
                    d24 = d4;
                    continue;
                }
                if (!(d24 < d3)) continue;
                d24 = d3;
            }
        }
        return d24;
    }

    @Override
    public TSRecordProxy getTSRecordProxy(int n) {
        for (int i = 0; i < this._tsrecordVector.size(); ++i) {
            TSRecordProxy tSRecordProxy = (TSRecordProxy)this._tsrecordVector.elementAt(i);
            if (tSRecordProxy == null || tSRecordProxy.getVariableId() != n) continue;
            return tSRecordProxy;
        }
        return null;
    }

    @Override
    public Vector getComputedTSRecordProxies(Vector vector) {
        if (vector == null) {
            vector = new Vector();
        }
        return vector;
    }

    @Override
    public double setParameterValue(double d, RunTimeStep runTimeStep) {
        System.out.println("Warning, calling OpController.setParameterValue");
        return d;
    }

    public boolean useRecursiveModifiedTest() {
        return true;
    }

    public double getCapacityOutageOrOveride(double d, RunTimeWindow runTimeWindow) {
        return d;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    public boolean applyPowerRuleLimits(RunTimeStep runTimeStep, OpRule opRule, int n) {
        if (opRule.getController() != this) {
            int n2 = this._controllableVec.size();
            for (int i = 0; i < n2; ++i) {
                OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(i);
                if (!(opControllable instanceof OpController) || !((OpController)(opControllable = (OpController)opControllable)).hasRule(opRule)) continue;
                ((OpController)opControllable).applyPowerRuleLimits(runTimeStep, opRule, n);
                break;
            }
            boolean bl = this.recalculateChildLimits(runTimeStep);
            this.g.array[runTimeStep.step] = this.p[runTimeStep.step].value;
            this.f.array[runTimeStep.step] = this.o[runTimeStep.step].value;
            return bl;
        }
        OpValue opValue = opRule.getPowerOpValue(runTimeStep);
        if (opValue == null || !RMAConst.isValidValue((double)opValue.value)) {
            return false;
        }
        int n3 = this._index << 16 | opRule.getIndex();
        this.distributePowerRule(runTimeStep, opValue, n3, opRule);
        return true;
    }

    private OpValue distributePowerRule(RunTimeStep runTimeStep, OpValue opValue, int n, OpRule opRule) {
        if (this._controllableVec.size() == 1) {
            if (this._controllableVec.elementAt(0) instanceof OpControllableElement) {
                Object object = this.getElementPowerPlant();
                if (object != null) {
                    double d = this.getElementReleaseForPower(runTimeStep, opValue.value);
                    object = new OpValue(opValue);
                    new OpValue(opValue).value = d;
                    WaterAccount waterAccount = this.getWaterAccount(opRule);
                    boolean bl = waterAccount != null;
                    double d2 = this.o[runTimeStep.step].value;
                    if (bl) {
                        d2 = this.calcWAPrevMinRuleVal(null, d2, 0.0, opRule, runTimeStep);
                        this.checkForWAclipping(runTimeStep, waterAccount, (OpValue)object, d2);
                    }
                    this.applyOpValue((OpValue)object, n, runTimeStep);
                    this.g.array[runTimeStep.step] = this.p[runTimeStep.step].value;
                    this.f.array[runTimeStep.step] = this.o[runTimeStep.step].value;
                    if (bl) {
                        this.evalWA(runTimeStep, waterAccount, d2, this.o[runTimeStep.step].value);
                    }
                }
            } else {
                OpController opController = (OpController)this._controllableVec.elementAt(0);
                opValue.init(opController.distributePowerRule(runTimeStep, opValue, n, opRule));
                this.recalculateChildLimits(runTimeStep);
                this.g.array[runTimeStep.step] = this.p[runTimeStep.step].value;
                this.f.array[runTimeStep.step] = this.o[runTimeStep.step].value;
            }
        } else {
            ReleaseAllocationObject releaseAllocationObject = this.b.getReleaseAllocationObject();
            ReleaseAllocationSet releaseAllocationSet = releaseAllocationObject.getActiveReleaseAllocationSet(runTimeStep);
            ReleaseAllocation releaseAllocation = releaseAllocationSet.getReleaseAllocation(this.getIndex());
            if (this.b.hasUserDefinedReleaseAllocation() && releaseAllocation != null && releaseAllocation.getAllocationType() == 0) {
                opValue.init(this.sequentialPowerDist(runTimeStep, releaseAllocationSet, opValue, n, opRule));
            } else {
                if (this.b.hasUserDefinedReleaseAllocation() && releaseAllocation != null) {
                    releaseAllocation.getAllocationType();
                }
                opValue.init(this.balancePowerDist(runTimeStep, releaseAllocationSet, opValue, n, opRule));
            }
            this.recalculateChildLimits(runTimeStep);
            this.g.array[runTimeStep.step] = this.p[runTimeStep.step].value;
            this.f.array[runTimeStep.step] = this.o[runTimeStep.step].value;
        }
        return opValue;
    }

    OpValue sequentialPowerDist(RunTimeStep runTimeStep, ReleaseAllocationSet releaseAllocationSet, OpValue opValue, int n, OpRule opRule) {
        double d;
        OpController opController;
        int n2;
        double d2 = 0.0;
        double d3 = 0.0;
        int n3 = this._controllableVec.size();
        for (n2 = 0; n2 < n3; ++n2) {
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(n2);
            if (!(opControllable instanceof OpController)) continue;
            opController = (OpController)opControllable;
            d3 += opController.getPowerForMinRelease(runTimeStep);
        }
        double d4 = opValue.value - d3;
        if (d < 0.0) {
            d4 = 0.0;
        }
        OpValue opValue2 = new OpValue();
        List list = this.al != null ? this.al.get((Object)releaseAllocationSet) : null;
        n3 = list != null ? list.size() : 0;
        for (n2 = 0; n2 < n3; ++n2) {
            double d5;
            opController = (OpController)list.get(n2);
            if (opController == null) continue;
            double d6 = opController.getPowerForMinRelease(runTimeStep);
            opValue2.init(opValue);
            opValue2.value = d4 + d6;
            opController.distributePowerRule(runTimeStep, opValue2, n, opRule);
            d2 += opValue2.value;
            d4 -= opValue2.value - d6;
            if (!(d5 < 0.0)) continue;
            d4 = 0.0;
        }
        List list2 = this.al.get((Object)releaseAllocationSet);
        n3 = this._controllableVec.size();
        for (n2 = 0; n2 < n3; ++n2) {
            double d7;
            OpControllable opControllable = (OpControllable)this._controllableVec.elementAt(n2);
            if (!(opControllable instanceof OpController) || list2.contains(opController = (OpController)opControllable)) continue;
            opValue2.init(opValue);
            opValue2.value = d7 = opController.getPowerForMinRelease(runTimeStep);
            opController.distributePowerRule(runTimeStep, opValue2, n, opRule);
            d2 += opValue2.value;
        }
        opValue.value = d2;
        return opValue;
    }

    OpValue balancePowerDist(RunTimeStep runTimeStep, ReleaseAllocationSet asciiSerializable, OpValue opValue, int n, OpRule opRule) {
        Object object;
        int n2;
        int n3 = this._controllableVec.size();
        Arrays.fill(this.af, 1.0);
        Arrays.fill(this.ai, true);
        for (n2 = 0; n2 < n3; ++n2) {
            double d;
            object = (OpControllable)this._controllableVec.get(n2);
            if (!(object instanceof OpController)) {
                this.ai[n2] = false;
                this.ag[n2] = 0.0;
                this.ah[n2] = 0.0;
                continue;
            }
            if (!((OpController)(object = (OpController)object)).hasPowerPlants()) {
                this.ai[n2] = false;
                this.ag[n2] = 0.0;
                this.ah[n2] = 0.0;
                continue;
            }
            this.ag[n2] = ((OpController)object).getPowerForMinRelease(runTimeStep);
            this.ah[n2] = ((OpController)object).getPowerForMaxRelease(runTimeStep);
            this.M.value = object.getIndex();
            try {
                object = this.am.get(asciiSerializable);
                d = (object = object != null ? (doubleContainer)object.get(this.M) : null) != null ? ((doubleContainer)object).value : 1.0;
            }
            catch (Exception exception) {
                d = 1.0;
            }
            this.af[n2] = d;
        }
        RmaMath.balancedDistribution((double)opValue.value, (double[])this.ae, (double[])this.af, (double[])this.ag, (double[])this.ah, (double)1.0E-8, (boolean[])this.ai, (boolean[])this.ac, (boolean[])this.ad);
        double d = 0.0;
        asciiSerializable = new OpValue();
        for (n2 = 0; n2 < n3; ++n2) {
            object = (OpControllable)this._controllableVec.elementAt(n2);
            if (!(object instanceof OpController)) continue;
            object = (OpController)object;
            asciiSerializable.init(opValue);
            asciiSerializable.value = this.ae[n2];
            ((OpController)object).distributePowerRule(runTimeStep, (OpValue)asciiSerializable, n, opRule);
            d += asciiSerializable.value;
        }
        opValue.value = d;
        return opValue;
    }
}

