/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.io.AsciiSerializable;
import hec.model.RunTimeStep;
import hec.rss.model.HotstartState;
import hec.rss.model.OpControllable;
import hec.rss.model.OpController;
import hec.rss.model.OpRule;
import hec.rss.model.OpValue;
import java.lang.reflect.Field;
import java.util.Enumeration;

public class OpControllerHotstartState
extends HotstartState
implements AsciiSerializable {
    private transient OpController b;
    private int _activeRuleIdState;
    private double _curFlowState;
    private double _curMaxFlowState;
    private double _curMinFlowState;
    private int _curMaxRuleIdState;
    private int _curMinRuleIdState;
    private OpValue _curOpValueState;
    private OpValue _curMinOpValueState;
    private OpValue _curMaxOpValueState;
    private OpValue _largestMinState;
    private OpValue _smallestMaxState;

    public OpControllerHotstartState() {
    }

    public OpControllerHotstartState(OpController opController) {
        super(opController.getName(), opController.getClass().getName());
        this.b = opController;
    }

    @Override
    public boolean restoreState() {
        if (this.b.s == null) {
            return true;
        }
        this.b.s[0] = this._activeRuleIdState;
        this.b.t[0] = this._curFlowState;
        this.b.u[0] = this._curMaxFlowState;
        this.b.v[0] = this._curMinFlowState;
        this.b.w[0] = this._curMaxRuleIdState;
        this.b.x[0] = this._curMinRuleIdState;
        this.b.y[0] = this._curOpValueState;
        this.b.z[0] = this._curMinOpValueState;
        this.b.A[0] = this._curMaxOpValueState;
        this.b.B[0] = this._largestMinState;
        this.b.C[0] = this._smallestMaxState;
        if (this.b._ruleTable != null) {
            Enumeration enumeration = this.b._ruleTable.elements();
            while (enumeration.hasMoreElements()) {
                OpRule opRule = (OpRule)enumeration.nextElement();
                opRule.restoreHotstartState(this);
            }
        }
        int n = this.b._controllableVec.size();
        for (int i = 0; i < n; ++i) {
            OpControllable opControllable = (OpControllable)this.b._controllableVec.get(i);
            if (!(opControllable instanceof OpController)) continue;
            ((OpController)opControllable).restoreHotstartState(this);
        }
        return true;
    }

    @Override
    public void saveState(int n) {
        if (this.b.s == null) {
            return;
        }
        Object object = this.b.getReleaseElement().getSystem().getStateRts();
        this._activeRuleIdState = this.b.h[((RunTimeStep)object).step];
        this._curFlowState = this.b.i[((RunTimeStep)object).step];
        this._curMaxFlowState = this.b.j[((RunTimeStep)object).step];
        this._curMinFlowState = this.b.k[((RunTimeStep)object).step];
        this._curMaxRuleIdState = this.b.l[((RunTimeStep)object).step];
        this._curMinRuleIdState = this.b.m[((RunTimeStep)object).step];
        this._curOpValueState = this.b.n[((RunTimeStep)object).step];
        this._curMinOpValueState = this.b.o[((RunTimeStep)object).step];
        this._curMaxOpValueState = this.b.p[((RunTimeStep)object).step];
        this._largestMinState = this.b.q[((RunTimeStep)object).step];
        this._smallestMaxState = this.b.r[((RunTimeStep)object).step];
        if (this.b._ruleTable != null) {
            object = this.b._ruleTable.elements();
            while (object.hasMoreElements()) {
                OpRule opRule = (OpRule)object.nextElement();
                opRule.saveHotstartState(this, n);
            }
        }
        int n2 = this.b._controllableVec.size();
        for (int i = 0; i < n2; ++i) {
            OpControllable opControllable = (OpControllable)this.b._controllableVec.get(i);
            if (!(opControllable instanceof OpController)) continue;
            ((OpController)opControllable).saveHotstartState(this, n);
        }
    }

    void setOpController(OpController opController) {
        this.b = opController;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

